/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class ASpriteInstance {
    int _posX;
    int _posY;
    int _pos_ox;
    int _pos_oy;
    public ASprite _sprite;
    int _nCrtAnim;
    int _nCrtAFrame;
    int _nCrtTime;
    int[] _rect;

    ASpriteInstance() {
        this._rect = new int[4];
    }

    ASpriteInstance(ASprite aSprite, int n, int n2) {
        this._posX = n;
        this._posY = n2;
        this._sprite = aSprite;
        this._rect = new int[4];
    }

    void SetSprite(ASprite aSprite) {
        this._sprite = aSprite;
        this._nCrtAnim = 0;
        this._nCrtAFrame = 0;
        this._nCrtTime = 0;
        this._pos_ox = 0;
        this._pos_oy = 0;
    }

    void SetAnim(int n) {
        if (n < 0 || n >= this._sprite.GetAnimationCount()) {
            return;
        }
        if (n != this._nCrtAnim) {
            this._nCrtAnim = n;
            this._nCrtAFrame = 0;
            this._nCrtTime = 0;
            this._pos_ox = 0;
            this._pos_oy = 0;
        }
    }

    boolean IsAnimEnded() {
        if (this._nCrtAFrame != this._sprite.GetAFrames(this._nCrtAnim) - 1) {
            return false;
        }
        int n = this._sprite.GetAFrameTime(this._nCrtAnim, this._nCrtAFrame);
        return n == 0 || this._nCrtTime >= n - 1;
    }

    void PaintSprite(Graphics graphics) {
        if (this._sprite == null) {
            return;
        }
        if (this._nCrtTime >= 0) {
            this._sprite.PaintAFrame(graphics, this._nCrtAnim, this._nCrtAFrame, this._posX, this._posY, 0, 0, 0);
        } else if (this._nCrtAnim >= 0) {
            this._sprite.PaintModule(graphics, this._nCrtAnim, this._posX, this._posY, 0);
        } else if (this._nCrtAFrame >= 0) {
            this._sprite.PaintFrame(graphics, this._nCrtAFrame, this._posX, this._posY, 0, 0, 0);
        }
    }

    void UpdateSpriteAnim() {
        if (this._sprite == null || cGame.s_game_onlyRefresh) {
            return;
        }
        if (this._nCrtTime < 0) {
            return;
        }
        int n = this._sprite.GetAFrameTime(this._nCrtAnim, this._nCrtAFrame);
        if (n == 0) {
            return;
        }
        ++this._nCrtTime;
        if (n > this._nCrtTime) {
            return;
        }
        this._nCrtTime = 0;
        ++this._nCrtAFrame;
        if (this._nCrtAFrame >= this._sprite.GetAFrames(this._nCrtAnim)) {
            this._nCrtAFrame = 0;
            this._pos_ox = 0;
            this._pos_oy = 0;
        }
    }

    void UpdateSpriteAnimTo(int n) {
        if (this._sprite == null) {
            return;
        }
        if (this._nCrtTime < 0) {
            return;
        }
        int n2 = this._sprite.GetAFrameTime(this._nCrtAnim, this._nCrtAFrame);
        if (n2 == 0) {
            return;
        }
        ++this._nCrtTime;
        if (n2 > this._nCrtTime) {
            return;
        }
        this._nCrtTime = 0;
        ++this._nCrtAFrame;
        if (this._nCrtAFrame >= this._sprite.GetAFrames(this._nCrtAnim)) {
            this._nCrtAFrame = 0;
            this._pos_ox = 0;
            this._pos_oy = 0;
            this.SetAnim(n);
        }
    }

    int[] GetRect() {
        if (this._sprite != null) {
            if (this._nCrtTime >= 0) {
                this._sprite.GetAFrameRect(this._rect, this._nCrtAnim, this._nCrtAFrame, this._posX, this._posY, 0);
            } else if (this._nCrtAnim >= 0) {
                this._sprite.GetModuleRect(this._rect, this._nCrtAnim, this._posX, this._posY, 0);
            } else if (this._nCrtAFrame >= 0) {
                this._sprite.GetFrameRect(this._rect, this._nCrtAFrame, this._posX, this._posY, 0, 0, 0);
            }
        }
        return this._rect;
    }
}

