/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.AIController;
import com.ea.game.Controller;
import com.ea.game.DDDebug;
import com.ea.game.DDMath;
import com.ea.game.GameAI;
import com.ea.game.GameFormation;
import com.ea.game.GameLogicConstants;
import com.ea.game.GameRender;
import com.ea.game.MainFrame;
import com.ea.game.TouchscreenController;
import com.ea.game.Trajectory;
import com.ea.game.XMLMenuSystem;
import com.ea.sdk.SDKConfig;
import com.ea.sdk.SDKString;

class GameLogic
implements GameLogicConstants {
    public static final int[][] m_cheatCodes = new int[][]{{131072, 65536, 65536, 128, 256}, {131072, 65536, 65536, 128, 512}, {131072, 65536, 65536, 128, 1024}, {131072, 65536, 65536, 128, 2048}, {131072, 65536, 65536, 512, 512}, {131072, 65536, 65536, 128, 8192}, {131072, 65536, 65536, 128, 16384}, {131072, 65536, 65536, 128, 32768}, {131072, 65536, 65536, 128, 65536}, {131072, 65536, 65536, 128, 128}, {131072, 65536, 65536, 256, 128}, {131072, 65536, 65536, 256, 256}, {131072, 65536, 65536, 256, 512}, {131072, 65536, 65536, 256, 1024}, {131072, 65536, 65536, 256, 2048}, {131072, 65536, 65536, 1024, 256}, {131072, 65536, 65536, 1024, 512}, {131072, 65536, 65536, 1024, 1024}, {131072, 65536, 65536, 2048, 256}, {131072, 65536, 65536, 2048, 512}, {131072, 65536, 65536, 256, 4096}, {131072, 65536, 65536, 256, 8192}, {131072, 65536, 65536, 8192, 256}, {131072, 65536, 65536, 16384, 256}, {131072, 65536, 65536, 16384, 512}, {131072, 65536, 65536, 16384, 1024}, {131072, 65536, 65536, 16384, 2048}, {131072, 65536, 65536, 16384, 8192}, {131072, 65536, 65536, 16384, 16384}, {131072, 65536, 65536, 16384, 32768}, {131072, 65536, 65536, 16384, 65536}, {131072, 65536, 65536, 8192, 512}, {131072, 65536, 65536, 8192, 1024}};
    public static final byte[] MATCH_PERIOD_START_TIMES = new byte[]{0, 45, 90, 105, 120, 0, 0};
    public static final byte[] MATCH_PERIOD_LENGTHS = new byte[]{45, 45, 15, 15, -1, 0, -1};
    public static final byte[] MATCH_PERIOD_LENGTH_ADJUST_RANGES = new byte[]{1, 3, 1, 1, 0, 0, 0};
    public static Object NULL_OBJ = null;
    public static int m_gameMode;
    public static int m_possession;
    public static int m_friction;
    public static int m_gameModeResetTimer;
    public static int[] m_ballOutOfPlayPosition;
    public static int m_ballOutOfPlayTeamWithPossessionAsBallWentOut;
    public static int[] m_cornerFlagObject;
    public static int m_nearGoalPostX;
    public static int m_nearGoalPostY;
    public static int m_farGoalPostX;
    public static int m_farGoalPostY;
    public static int m_interruptTimeLastFramesDifference;
    public static int[] m_lockPassTargetsPlayer;
    public static int m_nearestPlayerDistanceSquaredStore;
    public static byte[] setPieceSelection;
    public static boolean m_resetSetPieceTakerInfo;
    public static int m_resetSetPieceTakerTrajectory;
    public static int m_resetSetPieceTakerMode;
    public static int m_resetSetPieceTakerTarget;
    private static boolean m_replayDoNotTrigger;
    public static byte[][][] collisionList;
    protected static Controller[] m_controller;
    public static int m_teamUnderControl;
    public static int[] m_futureBallObject;
    public static int m_ballBouncePositionX;
    public static int m_ballBouncePositionY;
    public static int m_ballBouncePositionZ;
    public static boolean m_futureBallHasBounced;
    public static int m_matchState;
    public static int m_matchNextState;
    public static int m_matchNextSubState;
    public static boolean m_stateDelayedInitialisation;
    public static int m_stateTimer;
    public static int m_inPlayTimer;
    public static int m_matchSubState;
    public static int m_shownPlayer;
    public static boolean m_firstRun;
    public static int m_matchPrevState;
    public static int m_matchPrevSubState;
    public static int m_matchPrevNextState;
    public static int m_matchPrevNextSubState;
    public static int m_celebrationType;
    public static int[] m_shootingPlayer;
    public static int m_scorerTeam;
    public static int m_scorerID;
    public static int m_shootingPlayerShotType;
    public static int m_refereeTimer;
    public static int m_refereeDecision;
    public static boolean m_refereeJumpPlayersToFreeKickPositionsAfterBooking;
    public static boolean m_refereeNextHumanSlideTackleIsOK;
    public static int m_fouledPlayersTeam;
    public static int m_foulxpos;
    public static int m_foulypos;
    public static int[] m_foulingPlayer;
    public static int[] m_fouledPlayer;
    public static int[] m_setPieceTaker;
    public static int[] m_setPieceTargetObject;
    public static int[] m_setPieceWideTargetObject;
    public static final int SETPIECE_WIDETARGET_XPOS = 1000;
    public static final int SETPIECE_WIDETARGET_YPOS = 2500;
    public static int m_movingSetPieceTarget;
    public static int[] m_setPieceGKTargetObject;
    public static boolean m_setPieceShotType;
    public static boolean m_useGKDivePosition;
    public static int m_setPieceTargetPlayer;
    public static int m_trajectoryType;
    public static int m_setPieceMode;
    public static int m_setPieceType;
    public static int m_setPieceTimer;
    public static int[] m_targetMoveAmountsX;
    public static int[] m_targetMoveAmountsZ;
    public static int[] m_penaltyTakers;
    public static int m_penaltiesCount;
    public static boolean[][] m_penaltiesResults;
    public static boolean[] m_penaltesBonus;
    public static boolean m_penaltySavedInShootout;
    public static int m_matchTimerCount;
    public static int m_matchTotalTime;
    public static int m_matchTimer;
    public static int m_matchTimerCurrentSecond;
    public static int m_matchTimerSecond;
    public static int m_matchPeriod;
    public static int m_matchTimerMinute;
    public static int m_extraTimeSetting;
    private static byte m_matchPeriodLength;
    private static byte[] m_matchPeriodLengths;
    public static int m_injuryTime;
    private static int m_potentialPeriodTicks;
    private static int m_matchTimerRealMins;
    private static int m_secondsFactor;
    public static int[] m_offsideline;
    public static int m_offsideLinePosition;
    public static int m_prematchLineupCurrentTeam;
    public static int m_prematchLineupCurrentRow;
    private static int m_prematchLineupTimer;
    protected static int m_prematchLineupTimerFrames;
    public static int m_substitutionState;
    public static int m_substitutionSubState;
    public static int m_substitutionNextState;
    public static int m_substitutionNextSubState;
    private static int[] m_cheatCodesIndex;
    public static int m_updateFrameCounter;
    public static int[] m_bluetoothLandscape;
    public static boolean m_interruptContinueMatchTimer;
    public static int m_fatigueEffect;
    public static int m_ballVoffset;
    public static int m_ballHoffset;
    public static int m_ballZoffset;
    public static int m_playerAnim;
    public static int m_playerAnimFrame;
    public static boolean m_upAnimType;
    public static boolean m_downAnimType;
    public static boolean m_upAnimFrame;
    public static boolean m_downAnimFrame;
    public static boolean m_upDirection;
    public static final int MOVE_AMOUNT = 16;
    public static int[] m_matchEvents;
    public static int m_matchEventOff;
    public static SDKString m_matchEventsString;
    public static int[] m_matchEventsStringParams;
    public static int m_shootoutShootingTeam;
    public static int m_shootoutMotionShotResult;
    public static int m_shootoutMotionShotAccumulatedX;
    public static int m_shootoutMotionShotAccumulatedY;
    private static boolean m_shootoutMotionShotStarted;
    public static int m_goalWidth;
    public static boolean m_quickPlayMomentAvailable;
    public static int m_quickPlayMomentFramesActivated;
    public static boolean m_quickPlayMomentTriggered;
    public static int[] m_quickPlayMomentSetPieceTaker;
    public static int[] m_quickPlayMomentSetPieceTargetObject;
    public static int m_quickPlayMomentTriggeredTimer;
    public static int m_quickPlayMomentConfusedAITimer;
    public static int m_quickPlayMomentTeam;
    public static int AI_DRIBBLE_WITH_BALL_MAX_TIME_OFFENSIVE;
    public static int AI_DRIBBLE_WITH_BALL_MIN_TIME_OFFENSIVE;
    public static int AI_DRIBBLE_WITH_BALL_MAX_TIME_DEFENSIVE;
    public static int AI_DRIBBLE_WITH_BALL_MIN_TIME_DEFENSIVE;
    public static int AI_DRIBBLE_WITH_BALL_MAX_TIME_DEFAULT;
    public static int AI_DRIBBLE_WITH_BALL_MIN_TIME_DEFAULT;
    public static int MIN_AI_AVOID_DEFENDER_TIME;
    public static int MIN_AI_RUN_TIME;
    public static int MIN_AI_SPRINT_TIME;
    public static int MAX_AI_SPRINT_TIME;
    public static int MIN_STOP_BALL_TIME_BEFORE_NEXT_MOVE;
    public static int AI_GRAPPLE_WITH_BALL_MIN_TIME_DEFAULT;
    public static int RUN_ONTO_BALL_TIMEOUT;
    public static int ABSOLUTE_SPEED_RUN_ONTO_PITCH;
    public static int PLAYER_KICK_BALL_FORWARDS_BALL_SPEED;
    public static int THROUGHBALL_MAX_UNAVAILABLE_DURATION;
    public static int GOAL_KICK_MAX_DELAY;
    public static int KEEPER_PARRY_ULTRA_HORIZONTAL_VELOCITY_X;
    public static int KEEPER_PARRY_ULTRA_HORIZONTAL_VELOCITY_Y;
    public static int KEEPER_PARRY_HORIZONTAL_VELOCITY;
    public static int KEEPER_PARRY_VERTICAL_VELOCITY;
    public static int KEEPER_PARRY_ULTRA_VERTICAL_VELOCITY;
    public static int KEEPER_PARRY_BACK_INTO_PLAY_SPEED;
    public static int MAX_PARRY_VERICAL_SPEED;
    public static int LOOSE_BALL_PREDICTION_FRAMES;
    public static int AERIAL_PASS_AVERAGE_SPEED_SHORT;
    public static int AERIAL_PASS_AVERAGE_SPEED_MEDIUM;
    public static int AERIAL_PASS_AVERAGE_SPEED_LONG;
    public static int THROW_IN_AVERAGE_SPEED;
    public static int PASS_INTO_SPACE_MAX_RUN_DIST;
    public static int GROUND_PASS_AVERAGE_SPEED;
    public static int GROUND_PASS_FINAL_SPEED;
    public static int GROUND_PASS_AVERAGE_SPEED_FOR_ONE_TWO_INITIAL_PASS;
    public static int GROUND_PASS_FINAL_SPEED_FOR_ONE_TWO_INITIAL_PASS;
    public static int THROUGH_BALL_FINAL_SPEED;
    public static int JUMPING_CHEST_CONTROLLED_BALL_SPEED;
    public static int JUMPING_CHEST_CONTROL_FRAMES_TO_LAND_THE_JUMP;
    public static int STANDING_CHEST_CONTROLLED_BALL_SPEED;
    public static int PASS_TARGET_UPDATE_DELAY;
    public static int BALL_BOUNCE_THRESHOLD_VELOCITY;
    public static int BALL_PLAYER_REBOUND_THRESHOLD_HIGH_PER_FRAME;
    public static int BALL_PLAYER_REBOUND_THRESHOLD_HIGH_SQUARED;
    public static int GRAVITY_PER_FRAME;
    public static int PLAYER_JUMP_VELOCITY;
    public static int KEEPER_JUMP_VELOCITY;
    public static int AIR_RESISTANCE;
    public static int NUMBER_OF_SECONDS_TO_KEEP_FREE_KICK_AWARENESS;
    public static int NUMBER_OF_SECONDS_TO_KEEP_GOAL_KICK_AWARENESS;
    public static int NUMBER_OF_SECONDS_TO_KEEP_CORNER_KICK_AWARENESS;
    public static int NUMBER_OF_SECONDS_TO_KEEP_PENALTY_KICK_AWARENESS;
    public static int NUMBER_OF_SECONDS_TO_KEEP_THROWIN_AWARENESS;
    public static int SET_PIECE_MANUAL_CAMERA_GROUND_SPEED;
    public static int SET_PIECE_MANUAL_CAMERA_PAUSE;
    public static int GOAL_FAST_VELOCITY_THRESHOLD;
    public static int MIN_POST_REBOUND_SPEED;
    public static int SHOT_LOB_MAX_FRAMES;
    public static int SHOT_SPEED_MAXIMUM_FROM_LONG_DISTANCE;
    public static int SHOT_SPEED_MAXIMUM_FROM_MEDIUM_DISTANCE;
    public static int SHOT_SPEED_MAXIMUM_FROM_SHORT_DISTANCE;
    public static int SHOT_SPEED_MINIMIUM_FROM_LONG_DISTANCE;
    public static int SHOT_SPEED_MINIMIUM_FROM_MEDIUM_DISTANCE;
    public static int SHOT_SPEED_MINIMIUM_FROM_SHORT_DISTANCE;
    public static int GRAPPLE_KICK_BALL_SPEED;
    public static int KEEPER_CLEARANCE_BALL_SPEED;
    public static int PLAYER_CLEARANCE_BALL_SPEED;
    public static int PLAYER_CLEARANCE_TACKLE_BALL_SPEED;
    public static int PLAYER_CLEARANCE_HEADER_BALL_SPEED;
    public static int PLAYER_CLEARANCE_STANDING_TACKLE_BALL_SPEED;
    public static int MARKER_DELAY_DURING_GRAPPLE_BREAK_AWAY;
    public static int PLAYER_CLEARANCE_CONTROL_BALL_SPEED;
    public static int TACKLE_SLIDE_SPEED;
    private static final int BALL_KNOCKED_CLEAR_MAX_BALL_DISTANCE = 100000;
    private static final int BALL_KNOCKED_CLEAR_PERCENTAGE_CHANCE = 30;
    public static int REFEREE_STANDARD_TIMER;
    public static int REFEREE_MIN_TIMER;
    public static int REFEREE_MAX_TIMER;
    public static int m_moveOutOfTunnelTime;
    public static boolean SKIPHINT;
    private static final int IN_POSSESSION_STAT_TIME_THRESHOLD = 72;
    private static final int IN_POSSESSION_STAT_TIME_LIMIT = 150;
    public static boolean lskWasReleased;
    private static long m_manOfTheMatchDelay;
    private static final int MOM_DEB_DELAY = 8;
    public static boolean m_europeanCupTrophyLifted;
    private static final int INITIAL_CELEBRATION_XPOS = 3277;
    private static final int INITIAL_CELEBRATION_YPOS = 14007;
    private static final int CELEBRATION_PLAYERS_X_SPACING = 300;
    private static final int CELEBRATION_PLAYERS_Y_SPACING = 400;
    private static final int CELEBRATION_PODIUM_XPOS = 2677;
    private static final int CELEBRATION_KEEPER_XPOS = 2577;
    private static final int CELEBRATION_KEEPER_YPOS = 14807;
    private static final int QPM_FK_MAX_PLAYER_DISTANCE = 2000;
    private static final int QPM_CORNER_MAX_PLAYER_DISTANCE = 4000;
    private static final int SUBS_PLAYER_ON_START_X = -512;
    private static final int SUBS_PLAYER_ON_START_Y = 16224;
    private static final int SUBS_PLAYER_OFF_START_X = 8207;
    private static final int SUBS_PLAYER_OFF_START_Y = 15790;
    private static final int SUBS_PLAYER_OFF_END_X = -512;
    private static final int SUBS_PLAYER_OFF_END_Y = 15790;
    public static boolean stay;
    public static boolean BL_CORNER_HITTED;
    public static boolean BR_CORNER_HITTED;
    public static boolean TL_CORNER_HITTED;
    public static boolean TR_CORNER_HITTED;
    public static boolean MIDDLE_HITTED;
    public static int minigame_bonus;
    public static int setPieceUpdateTimer;
    static int penaltyGoalScore;
    private static final int NUM_INITIAL_SHOOTOUT_PENS_TOTAL = 10;
    private static final int NUM_INITIAL_SHOOTOUT_PENS_PER_TEAM = 5;
    private static boolean penalty_highscore_state;
    private static final int DEBUG_SCENARIO_START_TIME_MINS = 999;
    private static boolean debugScenarioTriggered;
    public static final int DEBUG_SCENARIO_DATA_MODIFY = 0;
    public static final int DEBUG_SCENARIO_DATA_STATE = 1;
    public static final int DEBUG_SCENARIO_DATA_X = 2;
    public static final int DEBUG_SCENARIO_DATA_Y = 3;
    public static final int DEBUG_SCENARIO_DATA_Z = 4;
    public static final int DEBUG_SCENARIO_DATA_UPDATE = 5;
    public static final int DEBUG_SCENARIO_DATA_TAKE_POSSESSION = 6;
    private static final int DEBUG_SCENARIO_DATA_COUNT = 7;
    private static int[] debugScenarioData;
    private static final int MAX_PLAYERS_BOOKED = 3;
    private static long bapStatTimeDelay;
    private static final int bapStatMaxDelay = 2000;
    public static int m_difficultySettingGrappleSecondsBeforeAITackle_LB_RB;
    public static int m_difficultySettingGrappleSecondsBeforeAITackle_LCB_RCB;
    public static int m_difficultySettingGrappleSecondsBeforeAITackle_CB;
    public static int m_difficultySettingGrappleSecondsBeforeAITackle_Default;
    public static int m_difficultySettingTackleTime_CB;
    public static int m_difficultySettingTackleTime_LB_RB;
    public static int m_difficultySettingTackleTime_LCB_RCB;
    public static int m_difficultySettingTackleTime_Default;
    public static int m_difficultySettingNumFramesAIConfusedForAfterQPM;
    public static int m_difficultySetttingMicroGameGreenZoneScale;
    public static int m_difficultySetttingAISprintingPercentage;
    public static int m_difficultySettingHumanSavePercantage;
    public static int m_difficultySettingAISavePercentage;
    public static int m_difficultySettingAIPlayerGoingOnARunPercentage;
    public static int m_difficultySettingAIPlayerSprintingJustOncePercentage;
    public static int m_difficultySettingAIPlayerSprintWithBallTimeMin;
    public static int m_difficultySettingAIPlayerSprintWithBallTimeMax;
    public static int m_difficultySettingAIPlayerInterceptSpeedAdjust;
    public static int m_difficultySettingHumanPlayerInterceptSpeedAdjust;
    public static int m_difficultySettingLongPassingRandomRangeHuman;
    public static int m_difficultySettingLongPassingRandomRangeAI;
    public static int m_difficultySettingMarkingBallToGoalsideJockeyRuntoDistanceMultiplier;
    public static int m_difficultySettingMarkingOneInXChanceOfSettingPlayerToMarkMultiplier;
    public static int m_difficultySettingDefensiveHeaderMinDistanceToAttacker;
    public static int m_difficultySettingDefensiveHeaderMinBallHeight;
    public static int m_difficultySettingDefensiveHeaderMaxBallHeight;
    public static int m_difficultySettingDefensiveHeaderMaxHorizontalDistance;
    public static int m_difficultySettingDefensiveHeaderMinDistanceToAttackerHuman;
    public static int m_difficultySettingDefensiveHeaderMinBallHeightHuman;
    public static int m_difficultySettingDefensiveHeaderMaxBallHeightHuman;
    public static int m_difficultySettingDefensiveHeaderMaxHorizontalDistanceHuman;
    public static int m_difficultySettingAIOneInNPassBallAwayWhenBeingForcedOutOfPitch;
    public static final int BAP_STAT_GOAL_SCORED = 0;
    public static final int BAP_STAT_BALL_CROSSED = 1;
    public static final int BAP_STAT_SHOT_TAKEN_ONTARGET = 2;
    public static final int BAP_STAT_PASS_COMPLETE = 3;
    public static final int BAP_STAT_AERIAL_SHOT_ONTARGET = 4;
    public static final int BAP_STAT_TACKLE_WON = 5;
    public static final int BAP_STAT_HELD_POSSESSION = 6;
    public static final int BAP_STAT_SPRINT = 7;
    public static final int BAP_STAT_FOUL = 8;
    public static final int BAP_STAT_YELLOW_CARD = 9;
    public static final int BAP_STAT_RED_CARD = 10;
    public static final int BAP_STAT_OWN_GOAL = 11;
    public static final int BAP_STAT_TACKLE_LOST = 12;
    public static final int BAP_STAT_PASS_FAILED = 13;
    public static final int BAP_STAT_SHOT_TAKEN_OFFTARGET = 14;
    public static final int BAP_STAT_AERIAL_SHOT_OFFTARGET = 15;
    public static final int BAP_STAT_TEAM_CLEAN_SHEET = 16;
    public static final int BAP_STAT_TEAM_GOAL_SCORED = 17;
    public static final int BAP_STAT_TEAM_GOAL_CONCEDED = 18;
    public static final int[] BE_A_PRO_STAT_POINTS;
    public static boolean m_beAProPassPlayed;
    public static int m_beAProRating;
    public static int m_beAProHUDRating;
    public static final int FKCHALLENGE_BOX_TIMER = 6;
    private static final int FKCHALLENGE_STORAGE_RANGE = 0;
    private static final int FKCHALLENGE_STORAGE_ANGLE = 1;
    private static final int FKCHALLENGE_STORAGE_GK = 2;
    private static final int FKCHALLENGE_STORAGE_WALL = 3;
    private static final int FKCHALLENGE_STORAGE_SIZE = 4;
    private static int[] m_freeKickChallengeStorage;
    public static int m_freeKickChallengeCurrentRound;
    public static int m_freeKickChallengeTimeElapsed;
    public static int m_freeKickChallengeTimeLastUpdate;
    public static boolean m_freeKickChallengeUpdateTime;
    public static boolean m_freeKickChallengeRoundCompleted;
    private static boolean m_freeKickChallengeGiveCard;
    private static boolean m_freeKickChallengeShowRoundInfo;
    private static boolean m_freeKickChallengeSetupNewFreekick;
    public static boolean m_freeKickChallengeRoundComplete;
    public static int m_freeKickChallengePoints;
    private static int m_freeKickChallengeDistance;
    private static int m_freeKickChallengeAngle;
    private static int m_freeKickChallengeAngleUnmodified;
    public static int m_freeKickChallengePlayer;
    private static boolean m_freeKickChallengeBallOutOfPlay;
    public static boolean BL_CORNER_SUCCESS;
    public static boolean BR_CORNER_SUCCESS;
    public static boolean TL_CORNER_SUCCESS;
    public static boolean TR_CORNER_SUCCESS;
    public static boolean MIDDLE_SUCCESS;
    private static int m_lastVibrateTime;
    private static final int VIBRATE_LEN = 500;
    private static final int VIBRATE_GAP = 500;
    private static final int NUM_PENALTIES = 5;

    public static void gameLogicInit(MainFrame mainFrame) {
        m_firstRun = true;
        GameLogic.init();
    }

    public static void load(int n2) {
        int n3 = 0;
        try {
            switch (n2) {
                case 0: {
                    if (XMLMenuSystem.m_inGameFlag) break;
                    m_quickPlayMomentAvailable = false;
                    m_goalWidth = 2725;
                    m_controller = new Controller[2];
                    for (n3 = 0; n3 < 2; ++n3) {
                        GameLogic.m_controller[n3] = GameAI.teamGetControlType(n3) == 0 ? new AIController(n3) : new TouchscreenController(n3);
                    }
                    for (n3 = 0; n3 < 2; ++n3) {
                        m_controller[n3].setupControls(GameRender.m_landscapeMode);
                    }
                    GameLogic.matchEventsInit();
                    GameLogic.prematchLineupInit();
                    GameLogic.initMatchVars();
                    GameFormation.setFormation(0, GameAI.m_teamStorage[0][4]);
                    GameFormation.setFormation(1, GameAI.m_teamStorage[1][4]);
                    if (m_gameMode != 5) break;
                    GameLogic.freeKickChallengeLoad();
                    GameLogic.freeKickChallengeInit();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    GameLogic.setMatchDifficultyVariables(XMLMenuSystem.m_matchDifficulty);
                    if (XMLMenuSystem.m_inGameFlag) break;
                    if (m_gameMode == 1 || m_gameMode == 2) {
                        GameLogic.setMatchPeriod(0);
                        break;
                    }
                    if (m_gameMode == 99) {
                        GameLogic.setMatchPeriod(4);
                        if (GameRender.m_landscapeMode == 0) {
                            XMLMenuSystem.setMenu(17);
                            break;
                        }
                        XMLMenuSystem.setMenu(20);
                        break;
                    }
                    if (m_gameMode != 5) break;
                    GameLogic.setMatchPeriod(6);
                    if (GameRender.m_landscapeMode == 0) {
                        XMLMenuSystem.setMenu(16);
                        break;
                    }
                    XMLMenuSystem.setMenu(19);
                }
            }
        }
        catch (Exception exception) {
            MainFrame.m_loadError = 1;
        }
    }

    public static void unload() {
        if (m_matchPeriod == 4) {
            GameLogic.penaltyShootOut_Unload();
        }
    }

    public static void init() {
        m_matchTimer = 0;
        GameLogic.setPieceSelectionLoad();
        m_futureBallObject = new int[9];
        m_ballOutOfPlayPosition = new int[9];
        m_setPieceTargetObject = new int[9];
        m_setPieceGKTargetObject = new int[9];
        m_cornerFlagObject = new int[9];
        m_offsideline = new int[2];
        m_possession = 0;
        m_setPieceShotType = false;
        m_matchState = 0;
        collisionList = new byte[13][21][10];
        for (int i2 = 0; i2 < 13; ++i2) {
            for (int i3 = 0; i3 < 21; ++i3) {
                GameLogic.collisionList[i2][i3][0] = 0;
            }
        }
        m_gameModeResetTimer = 0;
        GameLogic.setupMatchPeriodLengths();
        GameRender.replaySetState(false, -1, -1);
        m_targetMoveAmountsX = new int[]{125, 125, 0, -125, -125, -125, 0, 125};
        m_targetMoveAmountsZ = new int[]{0, -85, -85, -85, 0, 85, 85, 85};
        GameLogic.refereeInit();
    }

    public static void updateTeamData(int n2, int[] nArray) {
        int n3 = 0;
        int n4 = ++n3;
        GameAI.m_teamStorage[n2][4] = (short)nArray[n4];
        int n5 = ++n3;
        ++n3;
        GameAI.m_teamStorage[n2][5] = (short)nArray[n5];
        int n6 = ++n3;
        ++n3;
        GameAI.m_teamStorage[n2][2] = (short)nArray[n6];
        for (int i2 = 0; i2 < 5; ++i2) {
            GameRender.m_kitColours[n2][i2] = nArray[n3++];
        }
        GameAI.m_teamStorage[n2][14] = (short)nArray[10];
    }

    public static void checkCheats(int n2) {
        for (int i2 = 0; i2 < 33; ++i2) {
            if (m_cheatCodes[i2][m_cheatCodesIndex[i2]] == n2) {
                int n3 = i2;
                m_cheatCodesIndex[n3] = m_cheatCodesIndex[n3] + 1;
                if (m_cheatCodesIndex[i2] != m_cheatCodes[i2].length) continue;
                GameLogic.m_cheatCodesIndex[i2] = 0;
                switch (i2) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (MainFrame.m_masterState != 6 || m_matchState != 2) break;
                        if (m_matchPeriod == 0) {
                            m_matchPeriod = 1;
                            m_matchPeriodLength = m_matchPeriodLengths[m_matchPeriod];
                        }
                        GameAI.m_teamStorage[GameLogic.getPlayerTeam()][6] = 3;
                        GameAI.m_teamStorage[GameLogic.getOpponentTeam()][6] = 0;
                        m_matchTimerCount = (int)System.currentTimeMillis() - m_matchPeriodLength * m_matchTimerMinute;
                        break;
                    }
                    case 2: {
                        if (MainFrame.m_masterState != 6 || m_matchState != 2) break;
                        if (m_matchPeriod == 0) {
                            m_matchPeriod = 1;
                            m_matchPeriodLength = m_matchPeriodLengths[m_matchPeriod];
                        }
                        GameAI.m_teamStorage[GameLogic.getPlayerTeam()][6] = 0;
                        GameAI.m_teamStorage[GameLogic.getOpponentTeam()][6] = 3;
                        m_matchTimerCount = (int)System.currentTimeMillis() - m_matchPeriodLength * m_matchTimerMinute;
                        break;
                    }
                    case 3: {
                        if (MainFrame.m_masterState != 6 || m_matchState != 2) break;
                        if (m_matchPeriod == 0) {
                            m_matchPeriod = 1;
                            m_matchPeriodLength = m_matchPeriodLengths[m_matchPeriod];
                        }
                        GameAI.m_teamStorage[GameLogic.getPlayerTeam()][6] = 0;
                        GameAI.m_teamStorage[GameLogic.getOpponentTeam()][6] = 0;
                        m_matchTimerCount = (int)System.currentTimeMillis() - m_matchPeriodLength * m_matchTimerMinute;
                        break;
                    }
                    case 4: {
                        if (MainFrame.m_masterState != 6 || m_matchState != 2) break;
                        m_foulxpos = GameAI.m_ballStorage[0];
                        m_foulypos = GameAI.m_ballStorage[1];
                        m_fouledPlayer = GameLogic.nearestPlayerData(GameAI.m_ballStorage, m_possession, 0);
                        m_fouledPlayersTeam = m_possession;
                        m_foulingPlayer = GameLogic.nearestPlayerData(GameAI.m_ballStorage, m_possession ^ 1, 0);
                        GameLogic.refereeSetDecision(3);
                        break;
                    }
                    case 5: {
                        if (MainFrame.m_masterState != 6 || m_matchState != 2) break;
                        int n4 = GameAI.m_ballStorage[10] & 1;
                        int[] nArray = GameAI.m_playerStorage[n4][GameAI.m_ballStorage[10] >> 1];
                        m_offsideLinePosition = m_offsideline[n4 ^ 1];
                        m_foulxpos = nArray[0];
                        m_foulypos = nArray[1];
                        m_fouledPlayersTeam = n4 ^ 1;
                        m_foulingPlayer = nArray;
                        GameLogic.refereeSetDecision(6);
                        break;
                    }
                    case 6: {
                        if (MainFrame.m_masterState != 6 || m_matchState != 2) break;
                        m_foulxpos = GameAI.m_ballStorage[0];
                        m_foulypos = GameAI.m_ballStorage[1];
                        m_fouledPlayersTeam = GameLogic.getPlayerTeam();
                        m_foulingPlayer = GameAI.m_playerStorage[GameLogic.getPlayerTeam() ^ 1][1 + (DDMath.abs(DDMath.getRandom()) % 11 - 1)];
                        m_fouledPlayer = GameAI.m_playerStorage[GameLogic.getPlayerTeam()][1 + (DDMath.abs(DDMath.getRandom()) % 11 - 1)];
                        if (XMLMenuSystem.m_subsRequestCount[m_fouledPlayersTeam] < 3) {
                            GameAI.playerSetState(m_fouledPlayer, 0, 0, 81);
                        }
                        GameLogic.refereeSetDecision(3);
                        break;
                    }
                    case 7: {
                        if (MainFrame.m_masterState != 6 || m_matchState != 2) break;
                        m_foulxpos = GameAI.m_ballStorage[0];
                        m_foulypos = GameAI.m_ballStorage[1];
                        m_fouledPlayer = GameLogic.nearestPlayerData(GameAI.m_ballStorage, m_possession, 0);
                        m_fouledPlayersTeam = m_possession;
                        m_foulingPlayer = GameLogic.nearestPlayerData(GameAI.m_ballStorage, m_possession ^ 1, 0);
                        GameLogic.refereeSetDecision(4);
                        break;
                    }
                    case 8: {
                        if (MainFrame.m_masterState != 6 || m_matchState != 2) break;
                        GameAI.m_teamStorage[GameLogic.m_possession][6] = (short)DDMath.min(GameAI.m_teamStorage[m_possession][6] + 1, 19);
                        break;
                    }
                    case 9: {
                        if (MainFrame.m_masterState != 6 || m_matchState != 2) break;
                        GameAI.m_teamStorage[GameLogic.m_possession][6] = (short)DDMath.max(GameAI.m_teamStorage[m_possession][6] - 1, 0);
                        break;
                    }
                    case 10: {
                        GameAI.debugShotTypeCheatOn = !GameAI.debugShotTypeCheatOn;
                        break;
                    }
                    case 11: {
                        break;
                    }
                    case 12: {
                        if (MainFrame.m_masterState != 6 && MainFrame.m_masterState != 10 || XMLMenuSystem.m_menuMatchType != 1 || XMLMenuSystem.m_menuSeasonType != 2) break;
                        XMLMenuSystem.addTrophyInGame(1);
                        break;
                    }
                    case 13: {
                        if (MainFrame.m_masterState != 6 && MainFrame.m_masterState != 10 || XMLMenuSystem.m_menuMatchType != 1 || XMLMenuSystem.m_menuSeasonType != 2) break;
                        XMLMenuSystem.addTrophyInGame(2);
                        break;
                    }
                    case 14: {
                        if (MainFrame.m_masterState != 6 && MainFrame.m_masterState != 10 || XMLMenuSystem.m_menuMatchType != 1 || XMLMenuSystem.m_menuSeasonType != 2) break;
                        XMLMenuSystem.addTrophyInGame(3);
                        break;
                    }
                    case 15: {
                        DDDebug.DEBUG_DRAW_MARKING_PLAYER_CONTROL_POINTS = !DDDebug.DEBUG_DRAW_MARKING_PLAYER_CONTROL_POINTS;
                        break;
                    }
                    case 16: {
                        DDDebug.DEBUG_DRAW_PASS_INTO_SPACE_CONTROL_POINTS = !DDDebug.DEBUG_DRAW_PASS_INTO_SPACE_CONTROL_POINTS;
                        break;
                    }
                    case 17: {
                        DDDebug.DEBUG_DRAW_TOUCHSCREEN_NEW_CONTROL_ZONES = !DDDebug.DEBUG_DRAW_TOUCHSCREEN_NEW_CONTROL_ZONES;
                        break;
                    }
                    case 18: {
                        if (XMLMenuSystem.m_menuSeasonType != 2) break;
                        GameLogic.beAProUpdateBAPPoints(-50);
                        break;
                    }
                    case 19: {
                        if (XMLMenuSystem.m_menuSeasonType != 2) break;
                        GameLogic.beAProUpdateBAPPoints(50);
                        break;
                    }
                    case 20: {
                        XMLMenuSystem.m_seasonStorage[201] = XMLMenuSystem.m_seasonStorage[3] - 4;
                        if (MainFrame.m_masterState != 6 || m_matchState != 2) break;
                        if (m_matchPeriod == 0) {
                            m_matchPeriod = 1;
                            m_matchPeriodLength = m_matchPeriodLengths[m_matchPeriod];
                        }
                        GameAI.m_teamStorage[GameLogic.getPlayerTeam()][6] = 0;
                        GameAI.m_teamStorage[GameLogic.getOpponentTeam()][6] = 0;
                        m_matchTimerCount = (int)System.currentTimeMillis() - m_matchPeriodLength * m_matchTimerMinute;
                        break;
                    }
                    case 21: {
                        m_matchTimerCount = (int)System.currentTimeMillis() - m_matchPeriodLength * m_matchTimerMinute;
                        break;
                    }
                    case 22: {
                        DDDebug.DEBUG_DRAW_PLAYER_STATE = !DDDebug.DEBUG_DRAW_PLAYER_STATE;
                        break;
                    }
                    case 23: {
                        XMLMenuSystem.teamTacticalOptionsIntelligentPassingSet(GameLogic.getPlayerTeam(), !XMLMenuSystem.teamTacticalOptionsIntelligentPassingGet(GameLogic.getPlayerTeam()));
                        break;
                    }
                    case 24: {
                        XMLMenuSystem.teamTacticalOptionsMarkingStyleSet(GameLogic.getPlayerTeam(), 2);
                        break;
                    }
                    case 25: {
                        XMLMenuSystem.teamTacticalOptionsMarkingStyleSet(GameLogic.getPlayerTeam(), 1);
                        break;
                    }
                    case 26: {
                        XMLMenuSystem.teamTacticalOptionsMarkingStyleSet(GameLogic.getPlayerTeam(), 0);
                        break;
                    }
                    case 27: {
                        XMLMenuSystem.teamTacticalOptionsIntelligentPassingSet(GameLogic.getOpponentTeam(), !XMLMenuSystem.teamTacticalOptionsIntelligentPassingGet(GameLogic.getOpponentTeam()));
                        break;
                    }
                    case 28: {
                        XMLMenuSystem.teamTacticalOptionsMarkingStyleSet(GameLogic.getOpponentTeam(), 2);
                        break;
                    }
                    case 29: {
                        XMLMenuSystem.teamTacticalOptionsMarkingStyleSet(GameLogic.getOpponentTeam(), 1);
                        break;
                    }
                    case 30: {
                        XMLMenuSystem.teamTacticalOptionsMarkingStyleSet(GameLogic.getOpponentTeam(), 0);
                        break;
                    }
                    case 31: {
                        DDDebug.DEBUG_DRAW_PLAYER_STATE_STRING = !DDDebug.DEBUG_DRAW_PLAYER_STATE_STRING;
                        break;
                    }
                    case 32: {
                        GameLogic.debugScenarioTrigger();
                    }
                }
                continue;
            }
            GameLogic.m_cheatCodesIndex[i2] = 0;
        }
    }

    public static void update() {
        DDDebug.msg("match state : " + m_matchState + "  sub state : " + m_matchSubState);
        ++m_updateFrameCounter;
        GameLogic.quickPlayMomentUpdate();
        GameLogic.debugScenarioUpdate();
        if (m_interruptContinueMatchTimer && XMLMenuSystem.m_menuMatchType != 4) {
            GameLogic.interruptContinueMatchTimer();
            m_interruptContinueMatchTimer = false;
        }
        GameAI.throughBallUpdate();
        short[] sArray = GameAI.m_teamStorage[m_possession];
        sArray[1] = (short)(sArray[1] + 1);
        if (GameAI.ballIsInAPass() || !GameAI.ballIsPossessed()) {
            GameAI.m_teamStorage[GameLogic.m_possession][20] = 0;
        }
        if (GameAI.m_teamStorage[m_possession][20] < 150) {
            short[] sArray2 = GameAI.m_teamStorage[m_possession];
            sArray2[20] = (short)(sArray2[20] + 1);
        }
        if (GameAI.m_teamStorage[m_possession][20] > 72 && GameAI.m_teamStorage[m_possession][20] < 150) {
            GameAI.m_teamStorage[GameLogic.m_possession][20] = 150;
            if (GameLogic.m_controller[GameLogic.m_possession].m_controlPlayer != null) {
                GameLogic.m_controller[GameLogic.m_possession].m_controlPlayer[76] = GameLogic.m_controller[GameLogic.m_possession].m_controlPlayer[76] + 1;
                GameLogic.beAProCheckIfBAPStatAchieved(6, GameLogic.m_controller[GameLogic.m_possession].m_controlPlayer, null);
            }
        }
        GameLogic.updateTutorial();
        if (m_gameMode == 5) {
            GameLogic.freeKickChallengeUpdate();
        }
        for (int i2 = 0; i2 < 2; ++i2) {
            if (((GameAI.m_teamStorage[i2][0] & 4) != 4 || m_possession == i2) && ((GameAI.m_teamStorage[i2][0] & 4) != 0 || m_possession != i2) || GameAI.m_teamStorage[m_possession][1] <= GameAI.m_teamStorage[i2][2]) continue;
            short[] sArray3 = GameAI.m_teamStorage[i2];
            sArray3[0] = (short)(sArray3[0] & 0xFFFFFFFB);
            short[] sArray4 = GameAI.m_teamStorage[i2];
            sArray4[0] = (short)(sArray4[0] | (m_possession == i2 ? 4 : 0));
        }
        if (m_matchState == 1) {
            GameLogic.updateMatchStateWaitForTimedEvent();
        } else if (m_matchState == 19) {
            GameLogic.updateMatchStateCelebrations();
        } else if (m_matchState == 2) {
            GameLogic.updateMatchStateInplay();
        } else if (m_matchState == 3) {
            GameLogic.updateMatchStateOutOfPlay();
        } else if (m_matchState == 19) {
            GameLogic.updateMatchStateTrainingReset();
        } else if (m_matchState == 5) {
            GameLogic.updateMatchStateThrowIn();
        } else if (m_matchState == 6) {
            GameLogic.updateMatchStateCorner();
        } else if (m_matchState == 9) {
            GameLogic.updateMatchStateFreeKick();
        } else if (m_matchState == 17) {
            GameLogic.updateMatchStateGoalKick();
        } else if (m_matchState == 14) {
            GameLogic.updateMatchStateGoalKeeperDropKickSelect();
        } else if (m_matchState == 8) {
            GameLogic.updateMatchStatePenalty();
        } else if (m_matchState == 7) {
            GameLogic.updateMatchStateManOfTheMatch();
        } else if (m_matchState == 16) {
            GameLogic.updateMatchStateShowHighlights();
        } else if (m_matchState == 4) {
            GameLogic.updateMatchStateEndOfPeriod();
        } else if (m_matchState == 15) {
            GameLogic.updateMatchStateEndOfMatch();
        } else {
            if (m_matchState == 13) {
                GameLogic.updateMatchStateReplay();
                return;
            }
            if (m_matchState == 12) {
                GameLogic.updateMatchStateRefereeGivingCard();
            } else if (m_matchState == 18) {
                GameLogic.updateMatchStateSubstitutions();
            }
        }
        if (m_gameMode != 4 || m_gameModeResetTimer <= 0 || --m_gameModeResetTimer == 0) {
            // empty if block
        }
        if ((m_gameMode == 99 || m_gameMode == 1 && m_matchPeriod == 4) && m_gameModeResetTimer > 0 && --m_gameModeResetTimer == 0) {
            GameLogic.penaltyShootOutUpdate();
        }
        if (GameLogic.updateTheGameTimer() && GameLogic.updateMatchTimer() > 0 && GameLogic.isItSafeToEndTheHalf()) {
            MainFrame.m_bluetoothTicks = 0;
            GameLogic.setState(4, -1, -1, -1);
        }
        if (m_matchState != 7 && m_matchState != 16) {
            GameLogic.ballUpdate();
            if (m_matchState == 2 && GameAI.ballIsPossessed()) {
                GameLogic.ballUpdatePossessedByDistanceFromLTPDribbler();
                GameLogic.ballUpdatePossessedByLTPState();
            }
            GameLogic.Object_checkCollisions();
        }
        GameAI.playersUpdate();
        GameLogic.ballUpdatePossessedLastFrame();
        GameLogic.offsideLineUpdate();
    }

    public static final boolean isItSafeToEndTheHalf() {
        return GameAI.m_ballStorage[1] - 24011 <= 0 && GameAI.m_ballStorage[1] - 8003 >= 0 && !GameAI.ballIsInTheGoal() && !GameAI.ballIsInAShot() && !GameAI.ballIsInAPass() && m_inPlayTimer >= MainFrame.m_inGameFrameRate * 3 && m_refereeDecision == 0;
    }

    public static final void updateTutorial() {
        if (m_gameMode == 2 && (GameRender.m_managerTutorialIndex = XMLMenuSystem.m_currTutorial != 6 && (GameRender.m_boxState == 5 || XMLMenuSystem.tutorialCurrentHasBeenCompleted()) || XMLMenuSystem.m_tutorialState != 1 ? XMLMenuSystem.checkTutorialProgress() : -1) >= 0) {
            if (XMLMenuSystem.m_tutorialState == 2) {
                GameRender.managerSet(9);
            } else {
                GameRender.managerSet(8);
            }
        }
    }

    public static final void updateControllers() {
        m_controller[GameLogic.getPlayerTeam()].setJoystick(MainFrame.m_joystick);
        for (int i2 = 0; i2 < 2; ++i2) {
            m_controller[i2].update();
        }
    }

    public static final void updateMatchStateWaitForTimedEvent() {
        GameFormation.updateLevel1();
        if (m_matchSubState == 11) {
            if (m_stateTimer == 1) {
                XMLMenuSystem.setMenu(30);
            }
            if (m_gameMode == 1 || m_gameMode == 6) {
                XMLMenuSystem.setSoftKeys(9, 9);
            }
            if (GameLogic.m_controller[0].m_skipToKickOff || GameLogic.m_controller[1].m_skipToKickOff || m_gameMode == 2) {
                GameLogic.buttonThroughToKickOff();
                GameLogic.m_controller[1].m_joystick = 0;
                GameLogic.m_controller[0].m_joystick = 0;
                GameLogic.m_controller[1].m_skipToKickOff = false;
                GameLogic.m_controller[0].m_skipToKickOff = false;
            }
            if (GameLogic.m_controller[0].m_buttonThrough || GameLogic.m_controller[1].m_buttonThrough) {
                GameAI.teamSetState(0, 4);
                GameAI.teamSetState(1, 4);
                GameLogic.setState(1, 1, -1, -1);
            }
            if (GameRender.m_executeLogic && m_stateTimer-- == 0) {
                GameLogic.setState(1, 1, -1, -1);
            }
        } else if (m_matchSubState == 1) {
            if (m_stateTimer == m_moveOutOfTunnelTime && (m_gameMode == 1 || m_gameMode == 6)) {
                GameLogic.requestSound(2);
            }
            if (m_gameMode == 1 || m_gameMode == 6) {
                XMLMenuSystem.setSoftKeys(9, 9);
            }
            if (GameLogic.m_controller[0].m_skipToKickOff || GameLogic.m_controller[1].m_skipToKickOff) {
                GameLogic.buttonThroughToKickOff();
                GameLogic.m_controller[1].m_joystick = 0;
                GameLogic.m_controller[0].m_joystick = 0;
                GameLogic.m_controller[1].m_skipToKickOff = false;
                GameLogic.m_controller[0].m_skipToKickOff = false;
            }
            if (GameLogic.m_controller[0].m_buttonThrough || GameLogic.m_controller[1].m_buttonThrough) {
                GameLogic.buttonThroughToKickOff();
                GameLogic.m_controller[1].m_joystick = 0;
                GameLogic.m_controller[0].m_joystick = 0;
                GameLogic.m_controller[1].m_buttonThrough = false;
                GameLogic.m_controller[0].m_buttonThrough = false;
            }
            if (GameLogic.prematchLineupAvailable()) {
                for (int i2 = 0; i2 < 2; ++i2) {
                    m_controller[i2].setControlPlayer(GameAI.m_playerStorage[i2][0]);
                }
                m_shownPlayer = -1;
            }
            if (--m_stateTimer <= 0) {
                GameLogic.setState(1, 2, -1, -1);
            }
            GameLogic.centreAndStopBall();
        } else if (m_matchSubState == 2) {
            if (GameLogic.m_controller[0].m_skipToKickOff || GameLogic.m_controller[1].m_skipToKickOff || m_gameMode == 2) {
                GameLogic.buttonThroughToKickOff();
                GameLogic.m_controller[1].m_joystick = 0;
                GameLogic.m_controller[0].m_joystick = 0;
                GameLogic.m_controller[1].m_skipToKickOff = false;
                GameLogic.m_controller[0].m_skipToKickOff = false;
            }
            GameFormation.exclusionZonesAdjustment();
            if ((GameLogic.m_controller[0].m_buttonThrough || GameLogic.m_controller[1].m_buttonThrough) && m_prematchLineupCurrentTeam >= 2 && m_matchPeriod == 0 || --m_stateTimer <= 0 && m_prematchLineupCurrentTeam >= 2 && m_matchPeriod == 0 || m_stateTimer <= 0 && m_matchPeriod != 0 || !GameLogic.prematchLineupAvailable()) {
                GameLogic.setState(1, 3, -1, -1);
            }
            GameLogic.centreAndStopBall();
            GameLogic.prematchLineupUpdate();
        } else if (m_matchSubState == 3) {
            if (GameLogic.m_controller[0].m_buttonThrough || GameLogic.m_controller[1].m_buttonThrough) {
                m_stateTimer = 1;
            }
            GameFormation.exclusionZonesAdjustment();
            if (--m_stateTimer <= 0) {
                int n2;
                GameRender.boxClose();
                GameFormation.kickOffByPass();
                int n3 = 0;
                for (n2 = 10; n2 > 0; --n2) {
                    if (GameAI.m_playerStorage[m_possession][n2][49] == 2) continue;
                    GameAI.playerSetState(GameAI.m_playerStorage[m_possession][n2], 11799, 16007, 5);
                    n3 = n2;
                    GameAI.m_playerStorage[GameLogic.m_possession][n2][0] = 11799;
                    GameAI.m_playerStorage[GameLogic.m_possession][n2][1] = 16007;
                    break;
                }
                for (n2 = 10; n2 > 0; --n2) {
                    if (GameAI.m_playerStorage[m_possession][n2][49] == 2 || n2 == n3) continue;
                    GameAI.playerSetState(GameAI.m_playerStorage[m_possession][n2], 13335, 16007, 6);
                    GameAI.m_playerStorage[GameLogic.m_possession][n2][0] = 12823;
                    GameAI.m_playerStorage[GameLogic.m_possession][n2][1] = 16007;
                    break;
                }
                GameLogic.setState(1, 4, -1, -1);
            }
        } else if (m_matchSubState == 4) {
            if (GameAI.teamGetControlType(m_possession) == 0 && GameAI.teamGetControlType(m_possession ^ 1) == 0 && m_stateTimer < 0) {
                GameLogic.m_controller[GameLogic.m_possession].m_buttonThrough = true;
            }
            GameFormation.exclusionZonesAdjustment();
            GameRender.replayRecordBufferFlush();
            if (GameAI.teamGetControlType(m_possession) == 0 && --m_stateTimer <= 0 || GameAI.teamGetControlType(m_possession) == 2 && (--m_stateTimer <= 0 || GameLogic.m_controller[GameLogic.m_possession].m_buttonThrough)) {
                int n4;
                GameLogic.setState(2, -1, -1, -1);
                GameRender.boxSetState(5, 0, 0, 0, 0, 0, 0, false);
                int n5 = 0;
                for (n4 = 10; n4 > 0; --n4) {
                    if (GameAI.m_playerStorage[m_possession][n4][49] == 2) continue;
                    GameAI.playerSetState(GameAI.m_playerStorage[m_possession][n4], 0, 0, 0);
                    n5 = n4;
                    break;
                }
                for (n4 = 10; n4 > 0; --n4) {
                    if (GameAI.m_playerStorage[m_possession][n4][49] == 2 || n4 == n5) continue;
                    GameLogic.m_controller[GameLogic.m_possession].m_tappedPass = true;
                    GameLogic.refereeUpdateOffsidePlayerFlags(true);
                    GameAI.teamSetPossession(GameAI.m_playerStorage[m_possession][n4], GameAI.m_teamStorage[m_possession], m_possession);
                    GameAI.passBall(GameAI.m_ballStorage, GameAI.m_playerStorage[m_possession][n4], 1);
                    GameAI.playerSetState(GameAI.m_playerStorage[m_possession][n4], 0, 0, 10);
                    if (GameAI.teamGetControlType(m_possession) == 2) {
                        m_controller[m_possession].setControlPlayer(GameAI.m_playerStorage[m_possession][n4]);
                    }
                    break;
                }
            }
        } else if (m_matchSubState == 8 || m_matchSubState == 9) {
            if (m_controller[GameLogic.getPlayerTeam()].checkSkipKey()) {
                m_stateTimer = 0;
            }
            if (--m_stateTimer <= 0) {
                if (m_gameMode == 99 || m_gameMode == 1 && m_matchPeriod == 4) {
                    m_gameModeResetTimer = 1;
                } else {
                    int n6 = GameAI.m_ballStorage[1] < 16007 && GameAI.teamGetPitchSide(0) == 1 || GameAI.m_ballStorage[1] > 16007 && GameAI.teamGetPitchSide(0) == 0 ? 0 : 1;
                    if (m_gameMode == 1) {
                        m_possession = n6 ^ 1;
                    } else if (m_gameMode == 2) {
                        m_possession = 0;
                    }
                    GameAI.m_ballStorage[0] = 12311;
                    GameAI.m_ballStorage[1] = 16007;
                    GameAI.teamSetState(0, 1);
                    GameAI.teamSetState(1, 1);
                    if (m_gameMode != 2) {
                        if (XMLMenuSystem.m_replayOption != 0) {
                            m_replayDoNotTrigger = false;
                            if (n6 == 0) {
                                GameLogic.setState(13, 36, 1, 3);
                            } else {
                                GameLogic.setState(13, 37, 1, 3);
                            }
                        } else {
                            GameLogic.setState(1, 3, -1, -1);
                        }
                    } else {
                        GameLogic.setState(1, 3, 2, -1);
                    }
                }
            }
        } else if (m_matchSubState == 20) {
            GameFormation.updateLevel1();
            if (m_stateTimer-- <= 0) {
                GameLogic.setState(m_matchNextState, m_matchNextSubState, -1, -1);
            }
        } else if (m_matchSubState == 31) {
            if (m_quickPlayMomentAvailable && (GameLogic.m_controller[GameLogic.m_quickPlayMomentTeam].m_joystick & 0x50) != 0) {
                m_quickPlayMomentTriggered = true;
            }
            if (GameRender.m_boxState == 5) {
                m_quickPlayMomentAvailable = false;
                if (m_quickPlayMomentTriggered) {
                    m_quickPlayMomentTriggeredTimer = 32;
                    GameLogic.setFouled(m_refereeDecision, false);
                } else if (m_refereeDecision == 3) {
                    GameLogic.setFouled(m_refereeDecision, false);
                } else {
                    GameRender.fadeSet(false);
                    if (GameRender.m_fadeState == 1) {
                        m_foulingPlayer[1] = m_foulingPlayer[1] - 512;
                        GameLogic.m_foulingPlayer[22] = 224;
                        GameLogic.m_foulingPlayer[21] = 224;
                        m_fouledPlayer[1] = m_fouledPlayer[1] + 512;
                        GameLogic.m_fouledPlayer[22] = 160;
                        GameLogic.m_fouledPlayer[21] = 160;
                        GameLogic.setState(1, 5, -1, -1);
                    }
                }
            }
        } else if (m_matchSubState == 32) {
            if (m_quickPlayMomentAvailable && (GameLogic.m_controller[GameLogic.m_quickPlayMomentTeam].m_joystick & 0x50) != 0) {
                m_quickPlayMomentTriggered = true;
            }
            if (GameRender.m_boxState == 5) {
                m_quickPlayMomentAvailable = false;
                GameLogic.setState(9, 25, -1, -1);
            }
        } else if (m_matchSubState == 5 && GameRender.m_refereeAnimationCompleted) {
            GameRender.fadeSet(false);
            if (GameRender.m_fadeState == 1) {
                if (m_gameMode == 5) {
                    XMLMenuSystem.m_inGameFlag = false;
                    MainFrame.m_loadReturnMenu = 68;
                    XMLMenuSystem.m_menuTextBlockNumLines = 0;
                    MainFrame.setMasterState(3);
                    XMLMenuSystem.m_gameInProgress = false;
                } else {
                    GameLogic.setState(12, -1, -1, -1);
                }
            }
        }
    }

    public static final void updateMatchStateCelebrations() {
        if (GameLogic.m_controller[GameLogic.getPlayerTeam()].m_buttonThrough) {
            if (m_europeanCupTrophyLifted) {
                GameLogic.resetSubsData();
                GameLogic.matchEventMakeString();
                XMLMenuSystem.m_overrideLoadMenu = -1;
                XMLMenuSystem.m_inGameFlag = false;
                MainFrame.setMasterState(3);
                XMLMenuSystem.m_gameInProgress = false;
            } else {
                GameLogic.m_controller[GameLogic.getPlayerTeam()].m_buttonThrough = false;
            }
        }
    }

    public static final void updateMatchStateInplay() {
        ++m_inPlayTimer;
        if (GameAI.ballIsInTheGoal()) {
            if (m_refereeDecision == 0 || m_refereeDecision == 1 || m_refereeDecision == 2) {
                int n2 = GameAI.m_ballStorage[1] < 16007 ? 32 : 16;
                GameLogic.ballSetOutOfPitchSide(n2);
            } else {
                GameLogic.refereeUpdate();
            }
        } else {
            short[] sArray = GameAI.m_teamStorage[m_possession];
            sArray[7] = (short)(sArray[7] + 1);
            short[] sArray2 = GameAI.m_teamStorage[m_possession];
            sArray2[1] = (short)(sArray2[1] + 1);
            if (GameAI.m_teamStorage[m_possession][20] < 150) {
                short[] sArray3 = GameAI.m_teamStorage[m_possession];
                sArray3[20] = (short)(sArray3[20] + 1);
            }
            if (GameAI.m_teamStorage[m_possession][20] > 72 && GameAI.m_teamStorage[m_possession][20] < 150) {
                GameAI.m_teamStorage[GameLogic.m_possession][20] = 150;
                if (GameLogic.m_controller[GameLogic.m_possession].m_controlPlayer != null) {
                    GameLogic.m_controller[GameLogic.m_possession].m_controlPlayer[76] = GameLogic.m_controller[GameLogic.m_possession].m_controlPlayer[76] + 1;
                    GameLogic.beAProCheckIfBAPStatAchieved(6, GameLogic.m_controller[GameLogic.m_possession].m_controlPlayer, null);
                }
            }
            int[] nArray = GameAI.ballGetLastTouchPlayer();
            nArray[73] = nArray[73] + 1;
            if (m_matchPeriod != 4) {
                for (int i2 = 0; i2 < 2; ++i2) {
                    if (!m_controller[i2].assessNeedForPlayerSelect()) continue;
                    m_controller[i2].updatePlayerSelect(GameLogic.m_controller[i2].m_forcePlayerSelect);
                }
            }
            if (m_gameMode != 99 && (m_gameMode != 1 || m_matchPeriod != 4)) {
                GameFormation.updateLevel1();
                GameFormation.updateLevel2();
            }
            GameLogic.refereeUpdate();
        }
    }

    public static final void updateMatchStateTrainingReset() {
    }

    public static final void updateMatchStateOutOfPlay() {
        --m_stateTimer;
        GameLogic.m_controller[0].m_microGame.cancelMicroGame();
        GameLogic.m_controller[1].m_microGame.cancelMicroGame();
        GameAI.ballSetToFreeBall();
        if (m_quickPlayMomentAvailable && (GameLogic.m_controller[GameLogic.m_quickPlayMomentTeam].m_joystick & 0x50) != 0) {
            m_quickPlayMomentTriggered = true;
        }
        if (m_gameMode == 2 && XMLMenuSystem.m_currTutorial != 6) {
            return;
        }
        GameFormation.updateLevel1();
        if (m_stateTimer <= 0) {
            if (m_matchNextSubState == 16 || m_matchNextSubState == 40) {
                if (m_gameMode != 2 && m_matchNextSubState == 40) {
                    if (XMLMenuSystem.m_replayOption == 2) {
                        GameLogic.setState(13, 38, 17, 40);
                    } else {
                        GameLogic.setState(17, 40, -1, -1);
                    }
                } else {
                    GameLogic.setState(m_matchNextState, m_matchNextSubState, -1, -1);
                }
            } else if (m_gameMode == 99 || m_gameMode == 1 && m_matchPeriod == 4) {
                m_gameModeResetTimer = 1;
            } else {
                GameLogic.setState(m_matchNextState, m_matchNextSubState, -1, -1);
            }
        }
    }

    public static final void updateMatchStateEndOfPeriod() {
        if (--m_stateTimer == 0) {
            GameRender.replayRecordBufferFlush();
            if (m_matchPeriod == 0 || m_matchPeriod == 2) {
                MainFrame.setMasterState(7);
                XMLMenuSystem.m_globalArray[1] = 1;
                XMLMenuSystem.setMenu(10);
            } else if (m_gameMode == 1 && (XMLMenuSystem.m_menuMatchType == 5 || XMLMenuSystem.m_menuMatchType == 2 || XMLMenuSystem.m_menuMatchType == 4 || XMLMenuSystem.europeanCupIsCurrentFixtureEuropeanCupGame()) || XMLMenuSystem.m_seasonStorage[207] == 2) {
                boolean bl = false;
                boolean bl2 = false;
                if (m_extraTimeSetting == 0 || GameAI.m_teamStorage[0][6] != GameAI.m_teamStorage[1][6]) {
                    bl2 = true;
                } else if (m_matchPeriod == 1 && (m_extraTimeSetting == 1 || m_extraTimeSetting == 3)) {
                    bl = true;
                } else if (m_matchPeriod == 1 && m_extraTimeSetting == 2) {
                    m_matchPeriod = 3;
                    bl = true;
                } else if (m_matchPeriod == 3 && m_extraTimeSetting == 1) {
                    bl2 = true;
                } else if (m_matchPeriod == 3) {
                    bl = true;
                }
                if (bl2) {
                    GameLogic.setState(15, -1, -1, -1);
                }
                if (bl) {
                    MainFrame.setMasterState(7);
                    XMLMenuSystem.m_globalArray[1] = 1;
                    XMLMenuSystem.setMenu(10);
                    GameLogic.m_controller[1].m_goIntoPause = true;
                    GameLogic.m_controller[0].m_goIntoPause = true;
                }
            } else {
                GameLogic.setState(15, -1, -1, -1);
            }
            GameLogic.m_controller[1].m_joystick = 0;
            GameLogic.m_controller[0].m_joystick = 0;
        }
    }

    public static final void updateMatchStateThrowIn() {
        GameFormation.updateLevel1();
        switch (m_matchSubState) {
            case 44: {
                GameLogic.updateMatchSubStateThrowInInit();
                break;
            }
            case 45: {
                m_quickPlayMomentAvailable = false;
                if (m_quickPlayMomentTriggered) {
                    m_quickPlayMomentTriggered = false;
                    m_quickPlayMomentTriggeredTimer = 32;
                    GameLogic.quickPlayMomentPlayThrowin();
                    break;
                }
                GameLogic.updateMatchSubStateThrowInAim();
                break;
            }
            case 46: {
                GameLogic.updateMatchSubStateThrowInMicroGame();
                break;
            }
            case 47: {
                GameLogic.updateMatchSubStateThrowInPerfrom();
            }
        }
    }

    public static final void updateMatchSubStateThrowInInit() {
        m_stateTimer = MainFrame.m_inGameFrameRate;
        if (m_quickPlayMomentAvailable && (GameLogic.m_controller[GameLogic.m_quickPlayMomentTeam].m_joystick & 0x50) != 0) {
            m_quickPlayMomentTriggered = true;
        }
        if (m_setPieceTaker[28] == 12) {
            GameLogic.setState(5, 45, -1, -1);
        }
    }

    public static final void updateMatchSubStateThrowInAim() {
        GameLogic.setPieceUpdateTargets(m_possession, m_setPieceTaker);
        int[] nArray = GameAI.getPassTarget(m_setPieceTaker);
        if (nArray != null) {
            GameLogic.m_setPieceTargetObject[0] = nArray[0];
            GameLogic.m_setPieceTargetObject[1] = nArray[1];
        }
        m_controller[m_possession].updateMoveCameraAlongTheTrajectoryLine();
        if ((m_stateTimer == 0 || GameLogic.m_controller[GameLogic.m_possession].m_buttonThrough) && GameRender.m_fadeState == 2) {
            GameLogic.setState(5, 47, -1, -1);
            GameLogic.m_controller[GameLogic.m_possession].m_passBall = true;
        }
    }

    public static final void updateMatchSubStateThrowInMicroGame() {
        m_controller[m_possession].setControlPlayer(m_setPieceTaker);
    }

    public static final void updateMatchSubStateThrowInPerfrom() {
        GameAI.ballSetCollision(true);
        if (GameAI.m_ballStorage[0] > 1 && GameAI.m_ballStorage[0] < 24621) {
            GameLogic.setState(2, -1, -1, -1);
        }
    }

    public static final void updateMatchStateCorner() {
        switch (m_matchSubState) {
            case 16: {
                GameLogic.updateMatchSubStateCornerInit();
                break;
            }
            case 17: {
                GameLogic.updateMatchSubStateCornerAim();
                break;
            }
            case 18: {
                GameLogic.updateMatchSubStateCornerMicroGame();
                break;
            }
            case 19: {
                GameLogic.updateMatchSubStateCornerTakingIt();
            }
        }
    }

    public static final void updateMatchSubStateCornerInit() {
        if (GameRender.m_fadeState == 1) {
            if (m_stateDelayedInitialisation) {
                m_stateDelayedInitialisation = false;
                GameLogic.setSubStateCornerInit(-1, -1);
                GameFormation.jumpPlayersToTheirPositions();
            }
            if (m_setPieceTaker != null && m_setPieceTaker[28] == 12) {
                GameLogic.setState(6, 17, -1, -1);
                m_setPieceMode = 1;
                GameFormation.jumpPlayersToTheirPositions();
                GameRender.fadeSet(true);
            }
            if (m_resetSetPieceTakerInfo) {
                GameLogic.setPieceReLoadSavedTargetInfo(false);
            }
        }
    }

    public static final void updateMatchSubStateCornerAim() {
        if (GameRender.m_fadeState != 2) {
            return;
        }
        GameLogic.setPieceUpdateTargets(m_possession, m_setPieceTaker);
        if (m_possession != GameLogic.getPlayerTeam()) {
            XMLMenuSystem.setSoftKeys(9, 9);
        }
        int[] nArray = GameAI.getPassTarget(m_setPieceTaker);
        if (GameLogic.isSetPiecePassTargetAShortPass(GameLogic.setPieceGetCurrentTarget())) {
            m_trajectoryType = 3;
        }
        GameLogic.m_setPieceTargetObject[0] = nArray[0];
        GameLogic.m_setPieceTargetObject[1] = nArray[1];
        m_controller[m_possession].updateMoveCameraAlongTheTrajectoryLine();
    }

    public static final void updateMatchSubStateCornerMicroGame() {
        m_controller[m_possession].setControlPlayer(m_setPieceTaker);
    }

    public static final void updateMatchSubStateCornerTakingIt() {
    }

    public static final void updateMatchStatePenalty() {
        switch (m_matchSubState) {
            case 54: {
                GameLogic.updateMatchSubStatePenaltyHint();
            }
            case 12: {
                GameLogic.updateMatchSubStatePenaltyInit();
                break;
            }
            case 13: {
                GameLogic.updateMatchSubStatePenaltyAim();
                break;
            }
            case 14: {
                GameLogic.updateMatchSubStatePenaltyMicroGame();
                break;
            }
            case 15: {
                GameLogic.updateMatchSubStatePenaltyKick();
            }
        }
        if (m_setPieceTaker != null && m_setPieceTaker[12] == GameLogic.getPlayerTeam() && GameLogic.canWinOrLosePKShootout()) {
            GameLogic.updatePKVibration();
        }
    }

    public static final void updateMatchSubStatePenaltyHint() {
        GameLogic.setSubStatePenaltyHint();
    }

    public static final void updateMatchSubStatePenaltyInit() {
        if (GameRender.m_fadeState == 1) {
            GameLogic.setSubStatePenaltyInit(-1, -1);
            GameFormation.jumpPlayersToTheirPositions();
            m_setPieceMode = 0;
            if (m_setPieceTaker != null && m_setPieceTaker[28] == 12) {
                if (GameLogic.isShootoutViewEnabled()) {
                    if (!GameRender.m_stadiumPlayersEyeView) {
                        GameRender.stadiumRendererPitchMapGenerate(true);
                    }
                    GameRender.shootoutPlayersLoad(m_possession, m_setPieceTaker, GameAI.m_playerStorage[m_possession ^ 1][0]);
                }
                GameLogic.setState(8, 13, 8, 5);
                GameRender.fadeSet(true);
            } else if ((m_gameMode != 99 && (m_gameMode != 1 || m_matchPeriod != 4) || m_stateTimer-- <= 0) && m_setPieceTaker[28] != 11) {
                GameAI.playerSetState(m_setPieceTaker, GameAI.m_ballStorage[0], GameAI.m_ballStorage[1] + (GameAI.m_ballStorage[1] < 16007 ? 1536 : -1536), 11);
                GameFormation.jumpPlayersToTheirPositions();
            }
        }
    }

    public static final void updateMatchSubStatePenaltyAim() {
        m_controller[m_possession].updateMoveCameraAlongTheTrajectoryLine();
        m_setPieceMode = 0;
        GameLogic.managerTipCheckandShowForPenalty();
    }

    public static final void updateMatchSubStatePenaltyMicroGame() {
        if (m_possession == GameLogic.getPlayerTeam()) {
            // empty if block
        }
        XMLMenuSystem.setSoftKeys(9, 9);
        m_controller[m_possession].setControlPlayer(m_setPieceTaker);
    }

    public static final void updateMatchSubStatePenaltyKick() {
    }

    public static final void updateMatchStateFreeKick() {
        switch (m_matchSubState) {
            case 55: {
                GameLogic.updateMatchSubStateFreeKickHint();
                break;
            }
            case 25: {
                GameLogic.updateMatchSubStateFreeKickInit();
                break;
            }
            case 26: {
                GameLogic.updateMatchSubStateFreeKickAimWhilstInPassMode();
                break;
            }
            case 29: {
                break;
            }
            case 27: {
                GameLogic.updateMatchSubStateFreeKickAimWhilstInShootMode();
                break;
            }
            case 30: {
                break;
            }
            case 28: {
                GameLogic.updateMatchSubStateFreeKickMicroGame();
            }
        }
    }

    public static final void updateMatchSubStateFreeKickHint() {
        GameLogic.setSubStateFreeKickHint();
    }

    public static final void updateMatchSubStateFreeKickInit() {
        m_controller[m_possession].resetAllActions();
        if (GameRender.m_fadeState == 1 || m_gameMode == 2 || m_gameMode == 5) {
            if (m_stateDelayedInitialisation) {
                m_stateDelayedInitialisation = false;
                GameLogic.setSubStateFreeKickInit();
                GameFormation.jumpPlayersToTheirPositions();
            }
            if (m_setPieceTaker != null && m_setPieceTaker[28] == 12) {
                if (m_setPieceMode == 0) {
                    GameLogic.setState(9, 27, -1, -1);
                } else {
                    GameLogic.setState(9, 26, -1, -1);
                }
                GameFormation.jumpPlayersToTheirPositions();
                m_stateTimer = MainFrame.m_inGameFrameRate * 3;
                if (m_gameMode != 2) {
                    GameRender.fadeSet(true);
                }
            }
            if (m_resetSetPieceTakerInfo) {
                GameLogic.setPieceReLoadSavedTargetInfo(false);
            }
        }
    }

    public static final void updateMatchSubStateFreeKickAimWhilstInShootMode() {
        m_controller[m_possession].resetAllActions();
        GameLogic.setPieceUpdateTargets(m_possession, m_setPieceTaker);
        if (m_possession == GameLogic.getPlayerTeam()) {
            // empty if block
        }
        if (m_gameMode != 2) {
            GameLogic.managerTipCheckandShowForAttackingFreeKick();
        }
        m_controller[m_possession].updateMoveCameraAlongTheTrajectoryLine();
    }

    public static final void updateMatchSubStateFreeKickTakeKickWhilstInShootMode() {
    }

    public static final void updateMatchSubStateFreeKickAimWhilstInPassMode() {
        m_controller[m_possession].resetAllActions();
        GameLogic.setPieceUpdateTargets(m_possession, m_setPieceTaker);
        if (m_possession != GameLogic.getPlayerTeam()) {
            XMLMenuSystem.setSoftKeys(9, 9);
        }
        if (GameLogic.isSetPiecePassTargetAShortPass(GameLogic.setPieceGetCurrentTarget())) {
            m_trajectoryType = 3;
        }
        int[] nArray = GameAI.getPassTarget(m_setPieceTaker);
        GameLogic.m_setPieceTargetObject[0] = nArray[0];
        GameLogic.m_setPieceTargetObject[1] = nArray[1];
        m_controller[m_possession].updateMoveCameraAlongTheTrajectoryLine();
    }

    public static final void updateMatchSubStateFreeKickTakeKickWhilstInPassMode() {
    }

    public static final void updateMatchSubStateFreeKickMicroGame() {
        if (m_possession == GameLogic.getPlayerTeam()) {
            // empty if block
        }
        m_controller[m_possession].setControlPlayer(m_setPieceTaker);
    }

    public static final void updateMatchStateGoalKeeperDropKick() {
    }

    public static final void updateMatchStateGoalKeeperDropKickAim() {
    }

    public static final void updateMatchStateGoalKeeperDropKickSelect() {
        GameFormation.updateLevel1();
    }

    public static void updateMatchStateGoalKick() {
        switch (m_matchSubState) {
            case 40: {
                GameLogic.updateMatchSubStateGoalKickInit();
                break;
            }
            case 41: {
                GameLogic.updateMatchSubStateGoalKickAim();
                break;
            }
            case 42: {
                GameLogic.updateMatchSubStateGoalKickMicroGame();
                break;
            }
            case 43: {
                GameLogic.updateMatchSubStateGoalKickPerformKick();
            }
        }
    }

    public static final void updateMatchSubStateGoalKickInit() {
        if (GameRender.m_fadeState == 1) {
            GameLogic.setSubStateGoalKickInit(-1, -1);
            GameFormation.updateLevel1();
            GameRender.fadeSet(true);
            GameFormation.jumpPlayersToTheirPositions();
        }
    }

    public static final void updateMatchSubStateGoalKickAim() {
        GameFormation.updateLevel1();
    }

    public static final void updateMatchSubStateGoalKickMicroGame() {
        GameFormation.updateLevel1();
    }

    public static final void updateMatchSubStateGoalKickPerformKick() {
    }

    public static final void updateMatchStateRefereeGivingCard() {
        if (m_foulingPlayer[28] != 75 && --m_stateTimer <= 0) {
            GameLogic.setFouled(m_refereeDecision, false);
        }
        if (GameRender.m_fadeState == 1) {
            GameLogic.m_foulingPlayer[0] = m_foulingPlayer[15];
            GameLogic.m_foulingPlayer[1] = m_foulingPlayer[16];
        }
    }

    public static final void updateMatchStateReplay() {
        XMLMenuSystem.setSoftKeys(685, 9);
        if (GameLogic.m_controller[0].m_skipReplay || GameLogic.m_controller[1].m_skipReplay) {
            GameLogic.interruptContinueMatchTimer();
            if (m_matchSubState == 33) {
                if (XMLMenuSystem.m_inGamePrevMenu >= 0) {
                    XMLMenuSystem.setMenu(XMLMenuSystem.m_inGamePrevMenu);
                } else {
                    XMLMenuSystem.setMenu(37);
                }
            }
            GameRender.replaySetState(false, -1, -1);
            if (m_matchSubState == 33) {
                m_matchState = m_matchPrevState;
                m_matchSubState = m_matchPrevSubState;
                m_matchNextState = m_matchPrevNextState;
                m_matchNextSubState = m_matchPrevNextSubState;
            } else {
                MainFrame.clearJoystick();
                GameLogic.setState(m_matchNextState, m_matchNextSubState, 2, -1);
            }
            GameLogic.m_controller[0].m_skipReplay = false;
            GameLogic.m_controller[1].m_skipReplay = false;
        }
    }

    public static final void updateMatchStateReplayOffside() {
        GameLogic.updateMatchStateReplay();
    }

    public static final void updateMatchStateManOfTheMatch() {
        if (m_manOfTheMatchDelay >= 0L) {
            if (--m_manOfTheMatchDelay >= 0L) {
                return;
            }
            MainFrame.clearJoystick();
            MainFrame.m_keysReleasedThisFrame = 0;
        }
        m_stateTimer = 100;
        m_controller[0].setControlPlayer(null);
        m_controller[1].setControlPlayer(null);
        if ((GameLogic.m_controller[GameLogic.getPlayerTeam()].m_joystick & 0x50) == 0) {
            lskWasReleased = true;
        }
        if ((GameLogic.m_controller[GameLogic.getPlayerTeam()].m_joystick & 0x50) != 0 && (GameLogic.m_controller[GameLogic.getPlayerTeam()].m_lastJoystickWatchValue & 0x50) == 0) {
            switch (XMLMenuSystem.m_currMenu) {
                case 32: {
                    XMLMenuSystem.setMenu(10);
                    GameLogic.m_controller[GameLogic.getPlayerTeam()].m_joystick = 0;
                    GameLogic.m_controller[GameLogic.getPlayerTeam()].m_lastJoystickWatchValue |= 0x40;
                    MainFrame.m_keyState = 0;
                    break;
                }
                case -48: 
                case -47: 
                case 10: {
                    int n2;
                    if (XMLMenuSystem.m_menuMatchType == 1 && XMLMenuSystem.m_menuSeasonType == 1 || XMLMenuSystem.m_menuMatchType == 5) {
                        XMLMenuSystem.setMenu(25);
                        GameLogic.m_controller[GameLogic.getPlayerTeam()].m_joystick = 0;
                        GameLogic.m_controller[GameLogic.getPlayerTeam()].m_lastJoystickWatchValue |= 0x40;
                        lskWasReleased = false;
                        break;
                    }
                    GameLogic.resetSubsData();
                    if (XMLMenuSystem.m_menuMatchType == 4) {
                        XMLMenuSystem.setMenu(-46);
                        GameLogic.m_controller[GameLogic.getPlayerTeam()].m_joystick = 0;
                        GameLogic.m_controller[GameLogic.getPlayerTeam()].m_lastJoystickWatchValue |= 0x40;
                        break;
                    }
                    if (m_beAProRating == 1000 && !XMLMenuSystem.isTrophyAcquired(4)) {
                        XMLMenuSystem.addTrophyInGame(4);
                    }
                    if ((n2 = XMLMenuSystem.trophyAcquiredInLastGame()) != -1) {
                        int n3 = XMLMenuSystem.getTrophyStringId(n2);
                        if (n3 != -1) {
                            XMLMenuSystem.m_s_codedTextArray[0][0] = XMLMenuSystem.getMenuStringCoded(XMLMenuSystem.m_s_codedTextArray[0][0], 0, n3, 0);
                        }
                        XMLMenuSystem.setMenu(31);
                        if (m_manOfTheMatchDelay < 0L) {
                            m_manOfTheMatchDelay = 8L;
                        }
                        lskWasReleased = false;
                    } else if ((GameLogic.m_controller[GameLogic.getPlayerTeam()].m_joystick & 0x50) != 0 && lskWasReleased) {
                        GameLogic.matchEventMakeString();
                        if (XMLMenuSystem.m_menuMatchType == 1 && XMLMenuSystem.m_menuSeasonType == 2) {
                            XMLMenuSystem.calculateProStats();
                        }
                        if (XMLMenuSystem.europeanCupIsEuropeanCupWon()) {
                            GameRender.m_replayInProgress = false;
                            GameLogic.setState(19, -1, -1, -1);
                            XMLMenuSystem.setMenu(37);
                        } else {
                            XMLMenuSystem.m_overrideLoadMenu = -1;
                            XMLMenuSystem.m_inGameFlag = false;
                            MainFrame.setMasterState(3);
                            XMLMenuSystem.m_gameInProgress = false;
                            DDDebug.init();
                        }
                    }
                    GameLogic.m_controller[GameLogic.getPlayerTeam()].m_joystick = 0;
                    GameLogic.m_controller[GameLogic.getPlayerTeam()].m_lastJoystickWatchValue |= 0x40;
                    break;
                }
                case 31: {
                    if (!lskWasReleased) break;
                    int n4 = XMLMenuSystem.trophyAcquiredInLastGame();
                    if (n4 != -1) {
                        int n5 = XMLMenuSystem.getTrophyStringId(n4);
                        if (n5 != -1) {
                            XMLMenuSystem.m_s_codedTextArray[0][0] = XMLMenuSystem.getMenuStringCoded(XMLMenuSystem.m_s_codedTextArray[0][0], 0, n5, 0);
                        }
                        XMLMenuSystem.setMenu(31);
                        if (m_manOfTheMatchDelay < 0L) {
                            m_manOfTheMatchDelay = 8L;
                        }
                    } else {
                        GameLogic.matchEventMakeString();
                        if (XMLMenuSystem.m_menuMatchType == 1 && XMLMenuSystem.m_menuSeasonType == 2) {
                            XMLMenuSystem.calculateProStats();
                        }
                        if (XMLMenuSystem.europeanCupIsEuropeanCupWon()) {
                            GameRender.m_replayInProgress = false;
                            GameLogic.setState(19, -1, -1, -1);
                            XMLMenuSystem.setMenu(37);
                        } else {
                            XMLMenuSystem.m_overrideLoadMenu = -1;
                            XMLMenuSystem.m_inGameFlag = false;
                            MainFrame.setMasterState(3);
                            XMLMenuSystem.m_gameInProgress = false;
                            DDDebug.init();
                        }
                    }
                    lskWasReleased = false;
                    break;
                }
                case -46: {
                    GameLogic.sendRematchPacket(true);
                    break;
                }
                case 25: {
                    if ((GameLogic.m_controller[GameLogic.getPlayerTeam()].m_joystick & 0x50) == 0 || !lskWasReleased) break;
                    boolean bl = false;
                    if (XMLMenuSystem.m_menuMatchType == 5) {
                        if (XMLMenuSystem.cupIsTournamentWon()) {
                            bl = true;
                        }
                    } else if (XMLMenuSystem.europeanCupIsEuropeanCupWon()) {
                        bl = true;
                    }
                    if (bl) {
                        GameRender.m_replayInProgress = false;
                        GameLogic.setState(19, -1, -1, -1);
                        XMLMenuSystem.setMenu(37);
                        break;
                    }
                    XMLMenuSystem.m_overrideLoadMenu = -1;
                    XMLMenuSystem.m_inGameFlag = false;
                    GameLogic.resetSubsData();
                    MainFrame.setMasterState(3);
                    XMLMenuSystem.m_gameInProgress = false;
                }
            }
        } else if ((GameLogic.m_controller[GameLogic.getPlayerTeam()].m_joystick & 0x20) != 0) {
            if (XMLMenuSystem.m_currMenu == -46) {
                GameLogic.sendRematchPacket(false);
                XMLMenuSystem.m_overrideLoadMenu = -1;
                XMLMenuSystem.m_inGameFlag = false;
                MainFrame.m_loadReturnMenu = 2;
                MainFrame.setMasterState(3);
                XMLMenuSystem.m_gameInProgress = false;
                DDDebug.init();
            }
            GameLogic.m_controller[GameLogic.getPlayerTeam()].m_joystick = 0;
            MainFrame.m_keyState = 0;
        }
    }

    public static final void updateMatchStateShowHighlights() {
        m_controller[0].setControlPlayer(null);
        m_controller[1].setControlPlayer(null);
        if (GameLogic.m_controller[0].m_skipToMatchStats || GameLogic.m_controller[1].m_skipToMatchStats) {
            MainFrame.m_joystick = 0;
            MainFrame.m_joystickHeld = 0;
            MainFrame.m_keyState = 0;
            GameLogic.m_controller[GameLogic.getPlayerTeam()].m_joystick = 0;
            GameLogic.m_controller[GameLogic.getPlayerTeam()].m_lastJoystickWatchValue |= 0x40;
            GameLogic.m_controller[0].m_skipToMatchStats = false;
            GameLogic.m_controller[1].m_skipToMatchStats = false;
            GameLogic.setState(7, -1, -1, -1);
        }
        if (GameLogic.m_controller[GameLogic.getPlayerTeam()].m_skipToNextHighlight) {
            MainFrame.m_joystick = 0;
            MainFrame.m_joystickHeld = 0;
            MainFrame.m_keyState = 0;
            GameLogic.m_controller[GameLogic.getPlayerTeam()].m_joystick = 0;
            GameRender.fadeSet(false);
            GameLogic.m_controller[0].m_skipToNextHighlight = false;
            GameLogic.m_controller[1].m_skipToNextHighlight = false;
        }
    }

    public static final void updateMatchStateEndOfMatch() {
        m_controller[0].setControlPlayer(null);
        m_controller[1].setControlPlayer(null);
        if (m_controller[GameLogic.getPlayerTeam()].checkSkipKey()) {
            m_stateTimer = 0;
            GameRender.boxClose();
        }
        if (--m_stateTimer <= 0 && GameRender.m_boxState == 5) {
            m_controller[GameLogic.getPlayerTeam()].resetSkipKey();
            if (m_gameMode == 99) {
                if (penalty_highscore_state) {
                    penalty_highscore_state = false;
                    MainFrame.m_loadReturnMenu = 70;
                } else {
                    MainFrame.m_loadReturnMenu = 14;
                }
                XMLMenuSystem.m_inGameFlag = false;
                GameLogic.resetSubsData();
                MainFrame.setMasterState(3);
                XMLMenuSystem.m_gameInProgress = false;
            } else {
                int n2;
                for (n2 = 0; n2 < 2; ++n2) {
                    if (GameAI.m_teamStorage[n2 ^ 1][6] != 0 || n2 != GameLogic.getPlayerTeam()) continue;
                    GameLogic.beAProTeamStatAchieved(16);
                }
                if (XMLMenuSystem.m_menuMatchType == 1 && XMLMenuSystem.m_menuSeasonType == 1 || XMLMenuSystem.m_menuMatchType == 5) {
                    GameAI.m_manOfTheMatch = GameAI.calculateManOfTheMatch(GameLogic.getPlayerTeam());
                }
                if (XMLMenuSystem.m_menuMatchType == 1 || XMLMenuSystem.m_menuMatchType == 5) {
                    if (XMLMenuSystem.m_menuMatchType == 1) {
                        if (XMLMenuSystem.m_menuSeasonType == 2) {
                            XMLMenuSystem.bringInitialNewspaperMenu = false;
                            MainFrame.m_loadReturnMenu = 72;
                            n2 = GameAI.m_playerStorage[GameLogic.getPlayerTeam()][XMLMenuSystem.m_beAProPlayerIndex][11];
                            if ((XMLMenuSystem.m_gmodePlayerStats[n2] & 0x38) != 0) {
                                XMLMenuSystem.bapPlayerWasSuspendedLastGame = true;
                            }
                        } else if (XMLMenuSystem.europeanCupIsCurrentFixtureEuropeanCupGame()) {
                            XMLMenuSystem.m_resultsInitialised = false;
                            MainFrame.m_loadReturnMenu = 36;
                        } else {
                            XMLMenuSystem.m_resultsInitialised = false;
                            MainFrame.m_loadReturnMenu = 34;
                        }
                    } else {
                        XMLMenuSystem.m_resultsInitialised = false;
                        MainFrame.m_loadReturnMenu = 35;
                    }
                    for (n2 = 0; n2 < 18; ++n2) {
                        int n3 = n2;
                        int n4 = GameLogic.getPlayerTeam();
                        int n5 = (XMLMenuSystem.m_gmodePlayerStats[0 + n2] & 0x38) >> 3;
                        int n6 = 0 + n2;
                        XMLMenuSystem.m_gmodePlayerStats[n6] = XMLMenuSystem.m_gmodePlayerStats[n6] & 0xFFFFFFC7;
                        if (n5 > 1) {
                            int n7 = 0 + n2;
                            XMLMenuSystem.m_gmodePlayerStats[n7] = XMLMenuSystem.m_gmodePlayerStats[n7] | --n5 << 3;
                        }
                        n5 = (XMLMenuSystem.m_gmodePlayerStats[0 + n2] & 0x1C0) >> 6;
                        int n8 = 0 + n2;
                        XMLMenuSystem.m_gmodePlayerStats[n8] = XMLMenuSystem.m_gmodePlayerStats[n8] & 0xFFFFFE3F;
                        if (n5 <= 1) continue;
                        int n9 = 0 + n2;
                        XMLMenuSystem.m_gmodePlayerStats[n9] = XMLMenuSystem.m_gmodePlayerStats[n9] | --n5 << 6;
                    }
                    if (!XMLMenuSystem.europeanCupIsCurrentFixtureEuropeanCupGame()) {
                        if (XMLMenuSystem.m_gmodePlayerStats[61] < GameAI.m_teamStorage[GameLogic.getOpponentTeam()][6]) {
                            XMLMenuSystem.m_gmodePlayerStats[61] = GameAI.m_teamStorage[GameLogic.getOpponentTeam()][6];
                            XMLMenuSystem.m_gmodePlayerStats[62] = XMLMenuSystem.m_gmodePlayerStats[60];
                        }
                        if (XMLMenuSystem.m_gmodePlayerStats[63] < GameAI.m_teamStorage[GameLogic.getPlayerTeam()][6]) {
                            XMLMenuSystem.m_gmodePlayerStats[63] = GameAI.m_teamStorage[GameLogic.getPlayerTeam()][6];
                            XMLMenuSystem.m_gmodePlayerStats[64] = XMLMenuSystem.m_gmodePlayerStats[60];
                        }
                        if (GameAI.m_teamStorage[GameLogic.getOpponentTeam()][6] > GameAI.m_teamStorage[GameLogic.getPlayerTeam()][6] && XMLMenuSystem.m_gmodePlayerStats[65] < GameAI.m_teamStorage[GameLogic.getOpponentTeam()][6] - GameAI.m_teamStorage[GameLogic.getPlayerTeam()][6]) {
                            XMLMenuSystem.m_gmodePlayerStats[65] = GameAI.m_teamStorage[GameLogic.getOpponentTeam()][6] - GameAI.m_teamStorage[GameLogic.getPlayerTeam()][6];
                            XMLMenuSystem.m_gmodePlayerStats[68] = XMLMenuSystem.m_gmodePlayerStats[60];
                            XMLMenuSystem.m_gmodePlayerStats[66] = GameAI.m_teamStorage[GameLogic.getOpponentTeam()][6];
                            XMLMenuSystem.m_gmodePlayerStats[67] = GameAI.m_teamStorage[GameLogic.getPlayerTeam()][6];
                        }
                        if (GameAI.m_teamStorage[GameLogic.getPlayerTeam()][6] > GameAI.m_teamStorage[GameLogic.getOpponentTeam()][6] && XMLMenuSystem.m_gmodePlayerStats[69] < GameAI.m_teamStorage[GameLogic.getPlayerTeam()][6] - GameAI.m_teamStorage[GameLogic.getOpponentTeam()][6]) {
                            XMLMenuSystem.m_gmodePlayerStats[69] = GameAI.m_teamStorage[GameLogic.getPlayerTeam()][6] - GameAI.m_teamStorage[GameLogic.getOpponentTeam()][6];
                            XMLMenuSystem.m_gmodePlayerStats[72] = XMLMenuSystem.m_gmodePlayerStats[60];
                            XMLMenuSystem.m_gmodePlayerStats[70] = GameAI.m_teamStorage[GameLogic.getOpponentTeam()][6];
                            XMLMenuSystem.m_gmodePlayerStats[71] = GameAI.m_teamStorage[GameLogic.getPlayerTeam()][6];
                        }
                    }
                    XMLMenuSystem.m_gmodePlayerStats[73] = GameAI.m_manOfTheMatch;
                    for (n2 = 0; n2 < 18; ++n2) {
                        int[] nArray = GameAI.m_playerStorage[GameLogic.getPlayerTeam()][n2];
                        if (XMLMenuSystem.m_menuSeasonType == 2) {
                            nArray[79] = DDMath.min(nArray[79] + 6400, 25600);
                            nArray[79] = DDMath.max(nArray[79], 12800);
                            continue;
                        }
                        nArray[79] = DDMath.min(nArray[79] + 4800, 25600);
                    }
                    XMLMenuSystem.getMenuFatigue();
                    if (XMLMenuSystem.m_menuMatchType == 1 && XMLMenuSystem.m_menuSeasonType == 1) {
                        XMLMenuSystem.writeRMSData(XMLMenuSystem.m_gmodePlayerStats, 256, 10, false);
                        XMLMenuSystem.writeRMSData(XMLMenuSystem.m_menuFatigue, 18, 11, false);
                        XMLMenuSystem.writeRMSData(XMLMenuSystem.m_menuForm, 18, 12, false);
                    } else if (XMLMenuSystem.m_menuMatchType == 5) {
                        XMLMenuSystem.writeRMSData(XMLMenuSystem.m_gmodePlayerStats, 256, 6, false);
                        XMLMenuSystem.writeRMSData(XMLMenuSystem.m_menuFatigue, 18, 7, false);
                        XMLMenuSystem.writeRMSData(XMLMenuSystem.m_menuForm, 18, 8, false);
                    } else {
                        if (GameAI.m_teamStorage[GameLogic.getOpponentTeam()][6] == 0) {
                            if (++XMLMenuSystem.m_solidDefenceCounter >= 3 && !XMLMenuSystem.isTrophyAcquired(2)) {
                                XMLMenuSystem.addTrophyInGame(2);
                            }
                        } else {
                            XMLMenuSystem.m_solidDefenceCounter = 0;
                        }
                        if (m_beAProRating >= 850) {
                            if (++XMLMenuSystem.m_potmCounter >= 4 && !XMLMenuSystem.isTrophyAcquired(0)) {
                                XMLMenuSystem.addTrophyInGame(0);
                            }
                        } else {
                            XMLMenuSystem.m_potmCounter = 0;
                        }
                        XMLMenuSystem.writeRMSData(XMLMenuSystem.m_gmodePlayerStats, 256, 14, false);
                        XMLMenuSystem.bapLastGameWasCup = XMLMenuSystem.europeanCupIsCurrentFixtureEuropeanCupGame();
                        int n10 = n2 = XMLMenuSystem.m_cupStorage[30] == 2 ? 1 : 0;
                        XMLMenuSystem.bapResult = GameAI.m_teamStorage[GameLogic.getOpponentTeam()][6] > GameAI.m_teamStorage[GameLogic.getPlayerTeam()][6] ? (XMLMenuSystem.bapLastGameWasCup ? (n2 != 0 ? 3 : 1) : 1) : (GameAI.m_teamStorage[GameLogic.getOpponentTeam()][6] == GameAI.m_teamStorage[GameLogic.getPlayerTeam()][6] ? 2 : (XMLMenuSystem.bapLastGameWasCup ? (n2 != 0 ? 2 : 0) : 0));
                    }
                } else {
                    MainFrame.m_loadReturnMenu = 2;
                }
                if (m_gameMode == 1) {
                    if (XMLMenuSystem.m_replayOption != 0 && GameRender.m_replayHighlightNumHighlightsStored > 0) {
                        GameLogic.setState(16, -1, -1, -1);
                    } else {
                        GameLogic.setState(7, -1, -1, -1);
                    }
                } else if (m_stateTimer < -100) {
                    XMLMenuSystem.m_inGameFlag = false;
                    GameLogic.resetSubsData();
                    MainFrame.setMasterState(3);
                    XMLMenuSystem.m_gameInProgress = false;
                }
            }
        }
    }

    public static boolean checkSkipSubstitution() {
        if ((m_matchSubState == 50 || m_matchSubState == 51) && m_controller[GameLogic.getPlayerTeam()].checkSkipKey()) {
            if (m_matchSubState == 50) {
                GameAI.playerUpdateState(GameAI.m_playerSubOn, GameAI.m_teamStorage[GameAI.m_playerSubOn[12]], GameAI.m_playerSubOn[12]);
                GameAI.playerUpdateDirection(GameAI.m_playerSubOn);
                GameAI.playerUpdateVelocity(GameAI.m_playerSubOn);
                GameRender.playerUpdateAnimation(GameAI.m_playerSubOn);
                GameLogic.setState(18, 51, -1, -1);
            }
            GameLogic.setState(18, 52, -1, -1);
            return true;
        }
        return false;
    }

    public static final void updateMatchStateSubstitutions() {
        if (m_matchSubState == 48) {
            if (GameRender.m_boxState == 5) {
                GameRender.fadeSet(false);
            }
            if (GameRender.m_fadeState == 1) {
                GameLogic.setState(18, 49, -1, -1);
                if (GameAI.m_playerInjured != null && GameAI.m_playerInjured[12] == GameLogic.getPlayerTeam() && (XMLMenuSystem.m_menuMatchType != 1 || XMLMenuSystem.m_menuSeasonType != 2)) {
                    XMLMenuSystem.exitToInGameMenu(0);
                }
            }
        } else if (m_matchSubState == 49) {
            GameRender.fadeSet(false);
            if (GameRender.m_fadeState == 1) {
                GameLogic.setState(18, 50, -1, -1);
            }
        } else if (m_matchSubState == 50) {
            GameRender.fadeSet(true);
            GameAI.playerUpdateState(GameAI.m_playerSubOn, GameAI.m_teamStorage[GameAI.m_playerSubOn[12]], GameAI.m_playerSubOn[12]);
            GameAI.playerUpdateDirection(GameAI.m_playerSubOn);
            GameAI.playerUpdateVelocity(GameAI.m_playerSubOn);
            GameRender.playerUpdateAnimation(GameAI.m_playerSubOn);
            if (GameAI.m_playerSubOff[0] < 0) {
                GameLogic.setState(18, 51, -1, -1);
            }
        } else if (m_matchSubState == 51) {
            GameAI.playerUpdateState(GameAI.m_playerSubOn, GameAI.m_teamStorage[GameAI.m_playerSubOn[12]], GameAI.m_playerSubOn[12]);
            GameAI.playerUpdateDirection(GameAI.m_playerSubOn);
            GameAI.playerUpdateVelocity(GameAI.m_playerSubOn);
            GameAI.playerUpdatePosition(GameAI.m_playerSubOn);
            GameRender.playerUpdateAnimation(GameAI.m_playerSubOn);
            GameRender.pitchProjectObject(GameAI.m_playerSubOn[0], GameAI.m_playerSubOn[1], GameAI.m_playerSubOn[2]);
            int n2 = GameRender.pitchProjPos[0] - GameRender.m_scrollX;
            int n3 = GameRender.pitchProjPos[1] - GameRender.m_scrollY;
            int n4 = GameRender.m_playerWidth;
            int n5 = GameRender.m_playerHeight;
            if ((n2 + n4 < 0 || n2 - n4 > GameRender.m_screenWidth || n3 + n5 < 0 || n3 - n5 > GameRender.m_screenHeight) && XMLMenuSystem.m_menuMatchType != 4 || XMLMenuSystem.m_menuMatchType == 4 && --m_stateTimer <= 0 || GameAI.m_playerSubOn[28] != 123) {
                GameLogic.setState(18, 52, -1, -1);
            }
        } else if (m_matchSubState == 52) {
            GameRender.fadeSet(false);
            if (GameRender.m_fadeState == 1) {
                GameLogic.setState(18, 53, -1, -1);
            }
        } else if (m_matchSubState == 53 && m_stateTimer-- <= 0) {
            GameLogic.substitutionComplete();
            if (XMLMenuSystem.isSubWaiting()) {
                GameLogic.substitutionStart(m_substitutionState, m_substitutionSubState, m_substitutionNextState, m_substitutionNextSubState);
            } else {
                XMLMenuSystem.setMenu(37);
                GameRender.fadeSet(true);
                GameLogic.setState(m_substitutionState, m_substitutionSubState, m_substitutionNextState, m_substitutionNextSubState);
            }
        }
    }

    public static void setState(int n2, int n3, int n4, int n5) {
        m_controller[0].resetSkipKey();
        m_controller[1].resetSkipKey();
        lskWasReleased = false;
        if (m_matchState == 1 && m_matchSubState == 20 && n2 == 2) {
            return;
        }
        if (m_refereeDecision != 1 && m_refereeDecision != 0 && m_refereeTimer > 0) {
            return;
        }
        if (m_matchState != 13 || n2 != 13) {
            m_matchPrevState = m_matchState;
            m_matchPrevSubState = m_matchSubState;
            m_matchPrevNextState = m_matchNextState;
            m_matchPrevNextSubState = m_matchNextSubState;
        }
        for (int i2 = 0; i2 < 2; ++i2) {
            GameLogic.m_controller[i2].m_buttonThrough = false;
        }
        m_matchState = n2;
        m_matchSubState = n3;
        m_matchNextState = n4;
        m_matchNextSubState = n5;
        m_inPlayTimer = 0;
        if ((GameAI.m_playerInjured != null && (n2 == 9 || n2 == 8) || XMLMenuSystem.isSubWaiting() && n2 != 18 && n2 != 12 && (m_matchPrevState == 13 || m_matchPrevState == 12 || n2 == 5 && n3 == 44 || n2 == 9 && n3 == 25 || n2 == 1 && n3 == 4 || n2 == 6 || n2 == 17 && m_matchSubState != 43)) && m_matchNextState != 8) {
            GameLogic.substitutionStart(n2, n3, n4, n5);
        }
        if (n2 == 1) {
            GameLogic.setStateMatchStateWaitForTimedEvent(m_matchPrevState, m_matchPrevSubState);
        } else if (n2 == 19) {
            GameLogic.setStateMatchStateShowCelebrations();
        } else if (n2 == 2) {
            GameLogic.setStateMatchStateInplay(m_matchPrevState, m_matchPrevSubState);
        } else if (n2 == 3) {
            if (m_gameMode != 2 && n4 == 17 && n5 == 40) {
                if (m_possession != GameLogic.getPlayerTeam() || XMLMenuSystem.m_menuMatchType == 4) {
                    GameLogic.quickPlayEnableQuickPlayMoment();
                    m_quickPlayMomentTeam = m_possession ^ 1;
                }
                GameAI.m_playerStorage[0][0][2] = 0;
                GameAI.m_playerStorage[1][0][2] = 0;
            }
            if (m_gameMode != 2 && GameLogic.quickPlayMomentIsQuickFreekickAvailable() && n4 == 1 && (n5 == 31 || n5 == 32)) {
                GameLogic.quickPlayEnableQuickPlayMoment();
                GameLogic.quickPlayMomentInitFreekick();
                m_quickPlayMomentTeam = m_possession;
            }
            GameLogic.setStateMatchStateOutOfPlay(m_matchPrevState, m_matchPrevSubState);
        } else if (n2 == 7) {
            GameLogic.setStateMatchStateManOfTheMatch(m_matchPrevState, m_matchPrevSubState);
        } else if (n2 == 16) {
            GameLogic.setStateMatchStateShowHighlights(m_matchPrevState, m_matchPrevSubState);
        } else if (n2 == 9) {
            m_quickPlayMomentAvailable = false;
            if (m_quickPlayMomentTriggered) {
                m_quickPlayMomentTriggered = false;
                m_quickPlayMomentTriggeredTimer = 32;
                GameLogic.quickPlayMomentPlayFreekick();
            } else {
                GameLogic.setStateMatchStateFreeKick(m_matchPrevState, m_matchPrevSubState);
            }
        } else if (n2 == 17) {
            m_quickPlayMomentAvailable = false;
            if (m_quickPlayMomentTriggered && m_matchPrevSubState != 43) {
                m_quickPlayMomentTriggered = false;
                m_quickPlayMomentTriggeredTimer = 32;
                GameLogic.quickPlayMomentPlayGoalKick();
            } else {
                GameAI.ballSetCollision(true);
                GameLogic.setStateMatchStateGoalKick(m_matchPrevState, m_matchPrevSubState);
            }
        } else if (n2 == 5) {
            if (m_gameMode == 5) {
                GameLogic.setStateMatchStateGoalKick(m_matchPrevState, m_matchPrevSubState);
            } else {
                GameLogic.setStateMatchStateThrowIn(m_matchPrevState, m_matchPrevSubState);
            }
        } else if (n2 == 8) {
            GameLogic.setStateMatchStatePenalty(m_matchPrevState, m_matchPrevSubState);
        } else if (n2 == 6) {
            m_quickPlayMomentAvailable = false;
            if (m_quickPlayMomentTriggered) {
                m_quickPlayMomentTriggered = false;
                m_quickPlayMomentTriggeredTimer = 32;
                GameLogic.quickPlayMomentPlayCorner();
            } else {
                GameLogic.setStateMatchStateCorner(m_matchPrevState, m_matchPrevSubState);
            }
        } else if (n2 == 14) {
            GameLogic.setSubStateGoalKickInit(m_matchPrevState, m_matchPrevSubState);
        } else if (n2 == 4) {
            GameLogic.setStateMatchStateEndOfPeriod(m_matchPrevState, m_matchPrevSubState);
        } else if (n2 == 15) {
            GameLogic.setStateMatchStateEndOfMatch(m_matchPrevState, m_matchPrevSubState);
        } else if (n2 == 13) {
            GameLogic.setStateMatchStateReplay(m_matchPrevState, m_matchPrevSubState);
        } else if (n2 == 12) {
            GameLogic.setStateMatchStateWaitRefCard(m_matchPrevState, m_matchPrevSubState);
        } else if (n2 == 18) {
            GameLogic.setStateMatchStateSubstitutions(m_matchPrevState, m_matchPrevSubState);
        }
    }

    public static void setStateMatchStateWaitForTimedEvent(int n2, int n3) {
        m_controller[0].resetAllActions();
        m_controller[1].resetAllActions();
        if (m_matchSubState == 11) {
            m_stateTimer = 1;
            GameRender.m_executeLogic = false;
        } else if (m_matchSubState == 1) {
            GameAI.teamSetState(0, 4);
            GameAI.teamSetState(1, 4);
            XMLMenuSystem.setMenu(37);
            m_stateTimer = m_moveOutOfTunnelTime;
            if (m_matchPeriod == 0) {
                GameRender.commentarySet(true, 0);
            } else if (m_matchPeriod == 1) {
                GameRender.commentarySet(true, 2);
            } else if (m_matchPeriod == 2) {
                GameRender.commentarySet(true, 4);
            } else if (m_matchPeriod == 4) {
                GameRender.commentarySet(true, 6);
            }
        } else if (m_matchSubState == 2) {
            GameLogic.centreAndStopBall();
            GameAI.m_ballStorage[6] = 0;
            GameFormation.setKickOffPositions();
            if (GameLogic.prematchLineupAvailable()) {
                m_stateTimer = m_matchPeriod == 0 ? 275 : MainFrame.m_inGameFrameRate * 4;
            }
        } else if (m_matchSubState == 3) {
            int n4;
            GameLogic.centreAndStopBall();
            m_stateTimer = 50 + 6 * MainFrame.m_inGameFrameRate;
            int n5 = 0;
            for (n4 = 10; n4 > 0; --n4) {
                if (GameAI.m_playerStorage[m_possession][n4][49] == 2) continue;
                GameAI.playerSetState(GameAI.m_playerStorage[m_possession][n4], 11799, 16007, 5);
                n5 = n4;
                break;
            }
            for (n4 = 10; n4 > 0; --n4) {
                if (GameAI.m_playerStorage[m_possession][n4][49] == 2 || n4 == n5) continue;
                GameAI.playerSetState(GameAI.m_playerStorage[m_possession][n4], 13335, 16007, 6);
                break;
            }
            if (m_gameMode != 2) {
                XMLMenuSystem.setMenu(29);
            }
        } else if (m_matchSubState == 4) {
            GameRender.boxSetState(5, 0, 0, 0, 0, 0, 0, false);
            XMLMenuSystem.setSoftKeys(9, 9);
            GameLogic.centreAndStopBall();
            GameLogic.requestSound(1);
            XMLMenuSystem.teamTacticalOptionsTacticsSet(GameLogic.getOpponentTeam(), XMLMenuSystem.teamTacticalOptionsCalculateAIOption());
            m_stateTimer = MainFrame.m_inGameFrameRate * 4;
        } else if (m_matchSubState == 20) {
            if (m_gameMode == 2 && m_matchNextState != 9 && XMLMenuSystem.m_currTutorial != 6) {
                if ((XMLMenuSystem.m_currTutorial == 2 || XMLMenuSystem.m_currTutorial == 4 || XMLMenuSystem.m_currTutorial == 5) && XMLMenuSystem.m_tutorialComplete[XMLMenuSystem.m_tutorialIndex + XMLMenuSystem.m_currSubTutorial]) {
                    XMLMenuSystem.tutorialComplete();
                    XMLMenuSystem.m_tutorialTimer = MainFrame.m_inGameFrameRate;
                } else if (!XMLMenuSystem.tutorialCurrentHasBeenCompleted()) {
                    XMLMenuSystem.tutorialReset();
                } else {
                    m_stateTimer = 1 + m_stateTimer - 1;
                }
            }
            MainFrame.vibratePlay(1000);
            m_stateTimer = MainFrame.m_inGameFrameRate;
        } else if (m_matchSubState == 8 || m_matchSubState == 9) {
            if (m_gameMode == 2 && (XMLMenuSystem.m_currTutorial == 1 || XMLMenuSystem.m_currTutorial == 4 || XMLMenuSystem.m_currTutorial == 5)) {
                m_matchState = 3;
            } else {
                int n6 = 0;
                int n7 = 0;
                n6 = GameAI.m_ballStorage[1] < 16007 ? (GameAI.teamGetPitchSide(0) == 0 ? 0 : 1) : (GameAI.teamGetPitchSide(0) == 1 ? 0 : 1);
                n7 = n6 ^ 1;
                m_stateTimer = MainFrame.m_inGameFrameRate * 5;
                if (!(m_gameMode == 4 || m_gameMode == 99 || m_gameMode == 1 && m_matchPeriod == 4 || m_gameMode == 2 && XMLMenuSystem.m_currTutorial != 6)) {
                    GameAI.teamSetState(n6, 7);
                    short[] sArray = GameAI.m_teamStorage[n7];
                    sArray[6] = (short)(sArray[6] + 1);
                    GameAI.m_goalScorer = GameAI.ballGetLastTouchPlayer();
                    if (GameAI.ballGetLastTouchPlayerID() == 0 && m_shootingPlayer != null) {
                        GameAI.m_goalScorer = m_shootingPlayer;
                        GameAI.ballSetLastTouchPlayer(m_shootingPlayer);
                    }
                    if (GameAI.m_goalScorer[12] == GameLogic.getPlayerTeam() && m_matchSubState == 8) {
                        GameLogic.playerStatsAddGoal(GameAI.m_goalScorer);
                    } else if (n7 == GameLogic.getPlayerTeam()) {
                        GameLogic.beAProTeamStatAchieved(17);
                    } else {
                        GameLogic.beAProTeamStatAchieved(18);
                    }
                    GameLogic.matchEventAdd(GameAI.m_goalScorer[12], GameAI.m_goalScorer[11], m_matchTimer, 0);
                    XMLMenuSystem.goalScorerAddToScrollText();
                    GameLogic.CelebrationsInit(n7);
                } else if (m_gameMode == 2 && XMLMenuSystem.m_currTutorial != 6) {
                    XMLMenuSystem.m_tutorialTimer = 0;
                }
                if (m_gameMode != 4 && m_gameMode != 99 && m_gameMode != 2) {
                    GameLogic.CommentaryCheckGoalScorerForSpecialCase(GameAI.m_goalScorer);
                }
            }
            m_shootingPlayer = null;
        } else if (m_matchSubState == 5) {
            if (m_gameMode == 5) {
                GameRender.refereeInit(0, 1, GameRender.m_refereeFrameSequence);
            } else if (m_foulingPlayer[58] == 1) {
                GameRender.refereeInit(0, 0, GameRender.m_refereeFrameSequence);
            } else {
                GameRender.refereeInit(0, 0, GameRender.m_refereeFrameSequenceYellowRed);
            }
            GameRender.fadeSet(true);
        } else if (m_matchSubState == 31) {
            for (int i2 = 0; i2 < 2; ++i2) {
                for (int i3 = 0; i3 < 11; ++i3) {
                    GameAI.objectResetVelocity(GameAI.m_playerStorage[i2][i3]);
                }
            }
            GameRender.boxResetTextId();
            GameRender.boxSetState(0, GameRender.m_commentaryRefereeTimerMaxWrtFramerate, 2, 688, 21, 2, 0, false);
        } else if (m_matchSubState == 32) {
            GameRender.boxResetTextId();
            GameRender.boxSetState(0, GameRender.m_commentaryRefereeTimerMaxWrtFramerate, 2, 688, 19, 2, 0, false);
        }
    }

    public static void centreAndStopBall() {
        GameAI.m_ballStorage[1] = 16007;
        GameAI.m_ballStorage[0] = 12311;
        GameAI.m_ballStorage[2] = 0;
        GameAI.m_ballStorage[3] = 0;
        GameAI.m_ballStorage[4] = 0;
        GameAI.m_ballStorage[5] = 0;
    }

    public static void setStateMatchStateShowCelebrations() {
        int n2;
        int n3 = GameLogic.getPlayerTeam();
        int n4 = n3 == 0 ? 1 : 0;
        int n5 = 3277;
        int n6 = 14007;
        for (n2 = 0; n2 < 4; ++n2) {
            GameAI.m_playerStorage[n3][n2][0] = n5;
            GameAI.m_playerStorage[n3][n2][1] = n6;
            GameAI.playerSetState(GameAI.m_playerStorage[n3][n2], 0, 0, 86);
            GameAI.m_playerStorage[n3][n2][22] = 96;
            n5 += 300;
            n6 += 400;
        }
        for (n2 = 4; n2 < 7; ++n2) {
            GameAI.m_playerStorage[n3][n2][0] = n5;
            if (n2 == 5) {
                int[] nArray = GameAI.m_playerStorage[n3][n2];
                nArray[0] = nArray[0] + 150;
            }
            GameAI.m_playerStorage[n3][n2][1] = n6;
            GameAI.playerSetState(GameAI.m_playerStorage[n3][n2], 0, 0, 86);
            GameAI.m_playerStorage[n3][n2][22] = 64;
            n6 += 400;
        }
        n5 -= 300;
        for (n2 = 7; n2 < 9; ++n2) {
            GameAI.m_playerStorage[n3][n2][0] = n5;
            GameAI.m_playerStorage[n3][n2][1] = n6;
            GameAI.playerSetState(GameAI.m_playerStorage[n3][n2], 0, 0, 86);
            GameAI.m_playerStorage[n3][n2][22] = 32;
            n5 -= 300;
            n6 += 400;
        }
        n5 -= 1500;
        n6 -= 400;
        for (n2 = 9; n2 < 11; ++n2) {
            GameAI.m_playerStorage[n3][n2][0] = n5;
            GameAI.m_playerStorage[n3][n2][1] = n6;
            GameAI.playerSetState(GameAI.m_playerStorage[n3][n2], 0, 0, 86);
            GameAI.m_playerStorage[n3][n2][22] = 96;
            n5 -= 300;
            n6 -= 400;
        }
        GameAI.playerSetState(GameAI.m_playerStorage[n3][1], 0, 0, 87);
        GameAI.m_playerStorage[n3][1][49] = 0;
        GameAI.m_playerStorage[n3][1][0] = 2677;
        GameAI.m_playerStorage[n3][1][1] = 16007;
        GameAI.m_playerStorage[n3][1][2] = 0;
        GameAI.m_playerStorage[n3][0][0] = 2577;
        GameAI.m_playerStorage[n3][0][1] = 14807;
        GameAI.m_playerStorage[n3][0][22] = 32;
        for (n2 = 0; n2 < 11; ++n2) {
            GameAI.m_playerStorage[n4][n2][0] = 0;
            GameAI.m_playerStorage[n4][n2][1] = 0;
            GameAI.m_playerStorage[n4][n2][49] = 2;
            GameAI.m_playerStorage[n3][n2][49] = 0;
        }
        n2 = 0;
        int n7 = 0;
        while (n2 < GameRender.m_confettiAmount) {
            GameRender.m_confettiData[n7 + 2] = GameRender.m_kitColours[n3][1 + (DDMath.getRandom() & 1)];
            ++n2;
            n7 += 4;
        }
        m_europeanCupTrophyLifted = false;
        GameRender.m_managerAnimState = 1;
        GameRender.fadeSet(true);
        GameRender.postmatchCelebrationLoad(false);
    }

    public static void setStateMatchStateInplay(int n2, int n3) {
        m_inPlayTimer = 0;
        m_refereeTimer = 0;
        if (XMLMenuSystem.m_menuMatchType != 4) {
            GameLogic.interruptContinueMatchTimer();
        }
        GameAI.m_ballStorage[6] = GameAI.m_ballStorage[6] & 0xFFFFFFBF;
        XMLMenuSystem.setMenu(37);
    }

    public static void setStateMatchStateOutOfPlay(int n2, int n3) {
        if (n2 != 13) {
            if (m_gameMode == 2) {
                XMLMenuSystem.tutorialBallOutOfPlay();
            }
            if (!(m_gameMode == 1 && m_matchPeriod == 4 || m_gameMode == 99 || m_matchNextState == 9 || m_matchNextState == 8 || m_matchNextState == 1 && m_matchNextSubState == 31)) {
                GameLogic.requestSound(1);
            }
            GameLogic.m_ballOutOfPlayPosition[0] = GameAI.m_ballStorage[0];
            GameLogic.m_ballOutOfPlayPosition[1] = GameAI.m_ballStorage[1];
            GameLogic.m_ballOutOfPlayPosition[2] = GameAI.m_ballStorage[2];
            m_ballOutOfPlayTeamWithPossessionAsBallWentOut = m_possession;
            if (m_matchNextState == 6 || m_matchNextState == 5) {
                if (m_matchNextState == 6) {
                    if (m_gameMode != 2 && GameLogic.quickPlayMomentIsQuickCornerAvailable()) {
                        GameLogic.quickPlayEnableQuickPlayMoment();
                        GameLogic.quickPlayMomentInitCorner();
                        m_quickPlayMomentTeam = m_possession ^ 1;
                        m_stateTimer = MainFrame.m_inGameFrameRate * 2;
                    } else {
                        m_stateTimer = MainFrame.m_inGameFrameRate;
                    }
                } else if (m_gameMode != 2 && GameLogic.quickPlayMomentIsQuickThrowinAvailable()) {
                    GameLogic.quickPlayEnableQuickPlayMoment();
                    m_quickPlayMomentTeam = m_possession ^ 1;
                    m_stateTimer = MainFrame.m_inGameFrameRate * 2;
                } else {
                    m_stateTimer = MainFrame.m_inGameFrameRate;
                }
            } else if (m_quickPlayMomentAvailable || m_quickPlayMomentTriggered) {
                if (m_matchNextState == 17) {
                    GameLogic.quickPlayMomentInitGoalKick();
                    m_stateTimer = MainFrame.m_inGameFrameRate * 2;
                } else {
                    m_stateTimer = 0;
                }
            } else {
                m_stateTimer = MainFrame.m_inGameFrameRate;
            }
            if (m_gameMode == 1) {
                m_possession ^= 1;
                short[] sArray = GameAI.m_teamStorage[0];
                sArray[0] = (short)(sArray[0] & 0xFFFFFFFB);
                short[] sArray2 = GameAI.m_teamStorage[1];
                sArray2[0] = (short)(sArray2[0] & 0xFFFFFFFB);
                short[] sArray3 = GameAI.m_teamStorage[0];
                sArray3[0] = (short)(sArray3[0] | (short)(m_possession == 0 ? 4 : 0));
                short[] sArray4 = GameAI.m_teamStorage[1];
                sArray4[0] = (short)(sArray4[0] | (short)(m_possession == 1 ? 4 : 0));
            } else {
                m_possession = 0;
            }
            if (m_gameMode == 4 && n2 == 2) {
                m_gameModeResetTimer = 20;
            }
            GameLogic.refereeUpdateOffsidePlayerFlags(true);
            m_controller[0].resetAllActions();
            m_controller[1].resetAllActions();
            GameAI.ballSetToFreeBall();
        }
    }

    public static void setStateMatchStateManOfTheMatch(int n2, int n3) {
        if (XMLMenuSystem.m_menuMatchType == 4) {
            XMLMenuSystem.m_gameInProgress = false;
            MainFrame.bluetoothClearBuffer();
        }
        if (XMLMenuSystem.m_menuMatchType == 1 && XMLMenuSystem.m_menuSeasonType == 2) {
            XMLMenuSystem.setMenu(32);
        } else {
            XMLMenuSystem.setMenu(10);
        }
        if (m_manOfTheMatchDelay < 0L) {
            m_manOfTheMatchDelay = 8L;
        }
    }

    public static void setStateMatchStateShowHighlights(int n2, int n3) {
        GameRender.replaySetState(true, 2, -1);
        XMLMenuSystem.setSoftKeys(1010, 684);
    }

    public static void setStateMatchStateFreeKick(int n2, int n3) {
        m_stateTimer = MainFrame.m_inGameFrameRate * 3;
        GameAI.m_ballStorage[6] = GameAI.m_ballStorage[6] & 0xFFFFDFFF;
        switch (m_matchSubState) {
            case 55: {
                if (SKIPHINT) {
                    MainFrame.setMasterState(7);
                    XMLMenuSystem.m_globalArray[1] = 0;
                    break;
                }
                MainFrame.setMasterState(6);
                break;
            }
            case 25: {
                m_stateDelayedInitialisation = true;
                if (m_gameMode == 2 || m_gameMode == 5) break;
                GameRender.fadeSet(false);
                break;
            }
            case 26: {
                GameLogic.setSubStateFreeKickAimInPassMode();
                break;
            }
            case 29: {
                GameLogic.setSubStateFreeKickTakeFreeKickPass();
                break;
            }
            case 27: {
                GameLogic.setSubStateFreeKickAimInShootMode();
                break;
            }
            case 28: {
                GameLogic.setSubStateFreeKickMicroGame();
                break;
            }
            case 30: {
                GameLogic.setSubStateFreeKickTakeFreeKickShoot();
            }
        }
    }

    public static void setSubStateFreeKickHint() {
        if (!SKIPHINT) {
            GameLogic.setState(3, -1, -1, -1);
            GameLogic.setState(9, 25, -1, 26);
        }
    }

    public static void setSubStateFreeKickInit() {
        m_setPieceWideTargetObject = null;
        m_stateDelayedInitialisation = false;
        m_possession = m_fouledPlayersTeam;
        GameAI.ballSetCollision(false);
        m_setPieceType = 0;
        m_setPieceTimer = MainFrame.m_inGameFrameRate * NUMBER_OF_SECONDS_TO_KEEP_FREE_KICK_AWARENESS;
        XMLMenuSystem.setSoftKeys(9, 9);
        GameLogic.m_controller[1].m_joystick = 0;
        GameLogic.m_controller[0].m_joystick = 0;
        GameLogic.resetHumanControlPlayer();
        int[] nArray = m_setPieceTaker;
        m_setPieceTaker = GameAI.teamFindSetPeiceTaker(1, m_possession);
        if (nArray != m_setPieceTaker && nArray != null && (nArray[28] == 11 || nArray[28] == 12)) {
            GameAI.playerSetState(nArray, nArray[25], nArray[26], 71);
        }
        GameAI.objectResetVelocity(GameAI.m_ballStorage);
        GameAI.m_ballStorage[0] = m_foulxpos;
        GameAI.m_ballStorage[1] = m_foulypos;
        boolean bl = GameLogic.isAttackingFreeKick();
        GameFormation.updateLevel1();
        if (bl) {
            m_setPieceMode = 0;
            if (m_gameMode != 2) {
                GameFormation.setUpWalls();
                GameFormation.setUpPlayersInTheBox();
                GameLogic.checkForWideSetPieceTarget();
            }
        } else {
            m_setPieceMode = 1;
            if (m_gameMode != 2) {
                if (GameLogic.isObjectInFinalThird(GameAI.m_ballStorage, GameAI.teamGetPitchSide(m_possession))) {
                    GameFormation.setUpPlayersInTheBox();
                    GameLogic.checkForWideSetPieceTarget();
                } else if (GameLogic.isBallInRangeForDefensiveHeader(m_possession ^ 1)) {
                    GameFormation.setUpDefenceForLongRangeFreeKick();
                    GameFormation.setUpAttackersForLongRangeFreeKick();
                }
            }
        }
        GameLogic.calculateNearFarGoalPostPositions(GameAI.teamGetPitchSide(m_possession ^ 1));
        int n2 = m_nearGoalPostX - GameAI.m_ballStorage[0] >> 8;
        int n3 = m_nearGoalPostY - GameAI.m_ballStorage[1] >> 8;
        int n4 = DDMath.atan(n2, n3);
        GameAI.objectSetPosition(m_setPieceTaker, GameAI.m_ballStorage[0] - ((DDMath.sin(n4) >> 8) * 1280 >> 8), GameAI.m_ballStorage[1] - ((DDMath.cos(n4) >> 8) * 1280 >> 8), 0);
        if (m_setPieceTaker[28] != 12) {
            GameAI.playerSetState(m_setPieceTaker, GameAI.m_ballStorage[0] - ((DDMath.sin(n4) >> 8) * 1280 >> 8), GameAI.m_ballStorage[1] - ((DDMath.cos(n4) >> 8) * 1280 >> 8), 11);
        }
        if (m_gameMode != 5) {
            GameLogic.setPieceSelectionInit(m_possession, m_setPieceTaker);
        }
        if (m_gameMode == 4 || m_gameMode == 5) {
            if (m_gameMode == 4) {
                m_trajectoryType = 3;
            }
            GameLogic.m_setPieceTaker[0] = m_setPieceTaker[15];
            GameLogic.m_setPieceTaker[1] = m_setPieceTaker[16];
        }
        if (m_gameMode == 2) {
            GameRender.m_managerTutorialIndex = XMLMenuSystem.m_tutorialIndex + XMLMenuSystem.m_currSubTutorial;
            GameRender.managerSet(8);
        } else {
            GameLogic.managerTipCheckandShowForNormalFreeKick();
        }
        GameLogic.refereeSetDecision(0);
    }

    private static void checkForWideSetPieceTarget() {
        int n2;
        int n3 = m_foulypos;
        if (GameAI.teamGetPitchSide(m_possession) == 0) {
            n3 = 32015 - n3;
            n2 = 29515;
        } else {
            n2 = 2500;
        }
        int n4 = m_foulxpos >= 12311 ? 23622 : 1000;
        if (n3 >= 4633 && (m_setPieceWideTargetObject = GameLogic.nearestPlayerData(n4, n2, m_possession, 0, m_setPieceTaker)) != null) {
            GameAI.playerSetState(m_setPieceWideTargetObject, n4, n2, 1);
        }
    }

    public static void quickPlayEnableQuickPlayMoment() {
        if (!XMLMenuSystem.isSubWaiting()) {
            m_quickPlayMomentFramesActivated = 0;
            m_quickPlayMomentAvailable = true;
            m_quickPlayMomentTriggered = false;
            m_quickPlayMomentTriggeredTimer = 0;
            GameRender.m_quickPlayMomentIconFramesTillSwitch = 12;
            GameRender.m_quickPlayMomentIconDisplayIcon = true;
        }
    }

    public static boolean quickPlayMomentIsQuickFreekickAvailable() {
        if (!(m_fouledPlayersTeam != GameLogic.getPlayerTeam() && XMLMenuSystem.m_menuMatchType != 4 || m_refereeDecision != 3 && m_refereeDecision != 6)) {
            if (m_refereeDecision == 3) {
                if (GameAI.m_playerInjured != null) {
                    return false;
                }
                int n2 = m_foulxpos;
                int n3 = m_foulypos;
                if (GameAI.teamGetPitchSide(m_fouledPlayersTeam) == 0) {
                    n3 = 32015 - n3;
                }
                if (n3 <= 4633 && n2 >= 6641 && n2 <= 17981) {
                    return false;
                }
            }
            if (DDMath.abs(GameAI.m_ballStorage[0] - m_foulxpos) < 2000 && DDMath.abs(GameAI.m_ballStorage[1] - m_foulypos) < 2000) {
                return true;
            }
        }
        return false;
    }

    public static boolean quickPlayMomentIsKeeperThrowoutShortTargetGood() {
        if (m_possession != GameLogic.getPlayerTeam() && XMLMenuSystem.m_menuMatchType != 4) {
            return true;
        }
        int[] nArray = null;
        int[] nArray2 = null;
        for (int i2 = 1; i2 < 11 && (nArray = GameAI.m_playerStorage[m_possession][i2])[9] != m_setPieceTaker[32]; ++i2) {
        }
        if (nArray == null) {
            return true;
        }
        nArray2 = GameLogic.nearestPlayerData(nArray, m_possession ^ 1, 0);
        if (DDMath.abs(nArray[0] - nArray2[0]) < 3000 && DDMath.abs(nArray[1] - nArray2[1]) < 3000) {
            return false;
        }
        int[] nArray3 = GameAI.m_playerStorage[m_possession][0];
        return !(GameAI.teamGetPitchSide(m_possession) == 0 ? nArray[1] - nArray3[1] <= 0 : nArray[1] - nArray3[1] >= 0);
    }

    public static boolean quickPlayMomentIsQuickCornerAvailable() {
        return false;
    }

    public static boolean quickPlayMomentIsQuickThrowinAvailable() {
        if (m_possession == GameLogic.getPlayerTeam() && XMLMenuSystem.m_menuMatchType != 4) {
            return false;
        }
        int n2 = GameAI.m_ballStorage[0];
        int n3 = GameAI.m_ballStorage[1];
        GameAI.m_ballStorage[0] = m_ballOutOfPlayPosition[0] + (m_ballOutOfPlayPosition[0] < 12311 ? -256 : 256);
        GameAI.m_ballStorage[1] = m_ballOutOfPlayPosition[1];
        GameAI.m_ballStorage[2] = 0;
        int[] nArray = GameLogic.nearestPlayerData(GameAI.m_ballStorage, m_possession ^ 1, 0);
        if (DDMath.abs(GameAI.m_ballStorage[0] - nArray[0]) < 3000 && DDMath.abs(GameAI.m_ballStorage[1] - nArray[1]) < 3000) {
            GameAI.m_ballStorage[0] = n2;
            GameAI.m_ballStorage[1] = n3;
            return true;
        }
        GameAI.m_ballStorage[0] = n2;
        GameAI.m_ballStorage[1] = n3;
        return false;
    }

    public static void quickPlayMomentInitGoalKick() {
        GameAI.ballSetCollision(false);
        m_quickPlayMomentSetPieceTaker = GameAI.m_playerStorage[m_possession ^ 1][0];
        int[] nArray = new int[]{12311 + (m_ballOutOfPlayPosition[0] < 12311 ? -3097 : 3097), m_ballOutOfPlayPosition[1] < 16007 ? 1543 : 30472, 0};
        m_quickPlayMomentSetPieceTargetObject = GameLogic.nearestPlayerData(nArray, m_possession ^ 1, 0);
        GameAI.teamSetState(0, 0);
        GameAI.teamSetState(1, 0);
        int n2 = nArray[0] > 12311 ? nArray[0] + 3100 : nArray[0] - 3100;
        GameAI.playerSetState(m_quickPlayMomentSetPieceTargetObject, n2, nArray[1], 17);
        for (int i2 = 0; i2 < 2; ++i2) {
            for (int i3 = 1; i3 < 11; ++i3) {
                int[] nArray2 = GameAI.m_playerStorage[i2][i3];
                if (nArray2 == m_quickPlayMomentSetPieceTargetObject) continue;
                if (nArray[1] == 1543) {
                    if (nArray2[1] >= 6000) continue;
                    GameAI.playerSetState(nArray2, nArray2[0], 6000, 1);
                    continue;
                }
                if (nArray2[1] <= 26015) continue;
                GameAI.playerSetState(nArray2, nArray2[0], 26015, 1);
            }
        }
    }

    public static void quickPlayMomentPlayGoalKick() {
        m_quickPlayMomentConfusedAITimer = m_difficultySettingNumFramesAIConfusedForAfterQPM;
        GameAI.m_ballStorage[0] = 12311 + (m_ballOutOfPlayPosition[0] < 12311 ? -3097 : 3097);
        GameAI.m_ballStorage[1] = m_ballOutOfPlayPosition[1] < 16007 ? 1543 : 30472;
        GameAI.m_ballStorage[2] = 0;
        GameAI.objectResetVelocity(GameAI.m_ballStorage);
        GameLogic.m_quickPlayMomentSetPieceTaker[22] = m_quickPlayMomentSetPieceTaker[35];
        GameAI.setPassTarget(m_quickPlayMomentSetPieceTaker, m_quickPlayMomentSetPieceTargetObject);
        GameLogic.m_controller[GameLogic.m_possession].m_passBall = true;
        GameLogic.m_quickPlayMomentSetPieceTaker[2] = 0;
        GameAI.playerSetState(m_quickPlayMomentSetPieceTaker, GameAI.m_ballStorage[0], GameAI.m_ballStorage[1], 15);
        GameLogic.setState(17, 43, -1, -1);
        GameAI.ballSetCollision(true);
    }

    public static void quickPlayMomentInitFreekick() {
        m_stateDelayedInitialisation = false;
        m_possession = m_fouledPlayersTeam;
        GameAI.ballSetCollision(false);
        XMLMenuSystem.setSoftKeys(9, 9);
        GameLogic.m_controller[1].m_joystick = 0;
        GameLogic.m_controller[0].m_joystick = 0;
        GameLogic.resetHumanControlPlayer();
        int n2 = GameAI.m_ballStorage[0];
        int n3 = GameAI.m_ballStorage[1];
        GameAI.m_ballStorage[0] = m_foulxpos;
        GameAI.m_ballStorage[1] = m_foulypos;
        m_quickPlayMomentSetPieceTaker = GameLogic.nearestPlayerData(GameAI.m_ballStorage, m_possession, 0);
        GameAI.m_ballStorage[0] = n2;
        GameAI.m_ballStorage[1] = n3;
        m_quickPlayMomentSetPieceTargetObject = GameLogic.nearestPlayerData(m_quickPlayMomentSetPieceTaker, m_possession, 0);
        GameAI.teamSetState(0, 0);
        GameAI.teamSetState(1, 0);
        GameFormation.exclusionFromArea(m_foulxpos, m_foulypos, 2688);
        GameAI.playerSetState(m_quickPlayMomentSetPieceTaker, m_foulxpos, m_foulypos, 1);
        int n4 = m_foulxpos + 2000 >= 24622 ? m_foulxpos - 2000 : m_foulxpos + 2000;
        GameAI.playerSetState(m_quickPlayMomentSetPieceTargetObject, n4, m_foulypos, 1);
        for (int i2 = 1; i2 < 11; ++i2) {
            int[] nArray = GameAI.m_playerStorage[m_possession ^ 1][i2];
            GameAI.playerSetState(nArray, nArray[25], nArray[26], 1);
        }
    }

    public static void quickPlayMomentPlayFreekick() {
        m_quickPlayMomentConfusedAITimer = m_difficultySettingNumFramesAIConfusedForAfterQPM;
        GameAI.objectResetVelocity(GameAI.m_ballStorage);
        GameAI.m_ballStorage[0] = m_foulxpos;
        GameAI.m_ballStorage[1] = m_foulypos;
        GameAI.playerUpdateQuickPlayMomentlongPassTarget(m_quickPlayMomentSetPieceTaker);
        int[] nArray = GameAI.getPassTargetAlternate(m_quickPlayMomentSetPieceTaker);
        if (nArray != null) {
            m_quickPlayMomentSetPieceTargetObject = nArray;
        }
        GameAI.setPassTarget(m_quickPlayMomentSetPieceTaker, m_quickPlayMomentSetPieceTargetObject);
        GameLogic.m_quickPlayMomentSetPieceTaker[0] = m_foulxpos;
        GameLogic.m_quickPlayMomentSetPieceTaker[1] = m_foulypos;
        GameAI.teamSetPossession(m_quickPlayMomentSetPieceTaker, GameAI.m_teamStorage[m_fouledPlayersTeam], m_fouledPlayersTeam);
        GameLogic.m_controller[GameLogic.m_possession].m_passBall = true;
        GameAI.AnimatePass(m_quickPlayMomentSetPieceTaker, m_quickPlayMomentSetPieceTargetObject, 1, 2);
        GameAI.playerSetState(m_quickPlayMomentSetPieceTargetObject, 0, 0, 10);
        GameAI.ballSetCollision(true);
    }

    public static void quickPlayMomentInitCorner() {
        m_stateDelayedInitialisation = false;
        m_possession = m_quickPlayMomentTeam;
        GameAI.ballSetCollision(false);
        XMLMenuSystem.setSoftKeys(9, 9);
        GameLogic.m_controller[1].m_joystick = 0;
        GameLogic.m_controller[0].m_joystick = 0;
        GameLogic.resetHumanControlPlayer();
        GameAI.m_ballStorage[0] = m_ballOutOfPlayPosition[0] < 12311 ? 150 : 24472;
        GameAI.m_ballStorage[1] = m_ballOutOfPlayPosition[1] < 16007 ? 150 : 31865;
        GameAI.m_ballStorage[2] = 0;
        GameAI.objectResetVelocity(GameAI.m_ballStorage);
        m_quickPlayMomentSetPieceTaker = GameLogic.nearestPlayerData(GameAI.m_ballStorage, m_possession, 0);
        m_quickPlayMomentSetPieceTargetObject = GameLogic.nearestPlayerData(m_quickPlayMomentSetPieceTaker, m_possession, 0);
        GameAI.teamSetState(0, 0);
        GameAI.teamSetState(1, 0);
        GameFormation.exclusionFromArea(m_foulxpos, m_foulypos, 2688);
        GameAI.playerSetState(m_quickPlayMomentSetPieceTaker, GameAI.m_ballStorage[0], GameAI.m_ballStorage[1], 1);
        GameAI.playerSetState(m_quickPlayMomentSetPieceTargetObject, GameAI.m_ballStorage[0] + (GameAI.m_ballStorage[0] < 12311 ? 1280 : -1280), GameAI.m_ballStorage[1], 1);
        for (int i2 = 1; i2 < 11; ++i2) {
            int[] nArray = GameAI.m_playerStorage[m_possession ^ 1][i2];
            GameAI.playerSetState(nArray, nArray[25], nArray[26], 1);
        }
        GameFormation.setGoalKeepersToTheirBaseLine();
    }

    public static void quickPlayMomentPlayCorner() {
        m_quickPlayMomentConfusedAITimer = m_difficultySettingNumFramesAIConfusedForAfterQPM;
        GameAI.setPassTarget(m_quickPlayMomentSetPieceTaker, m_quickPlayMomentSetPieceTargetObject);
        GameLogic.m_quickPlayMomentSetPieceTaker[0] = GameAI.m_ballStorage[0];
        GameLogic.m_quickPlayMomentSetPieceTaker[1] = GameAI.m_ballStorage[1];
        GameLogic.m_quickPlayMomentSetPieceTaker[21] = 64;
        GameAI.teamSetPossession(m_quickPlayMomentSetPieceTaker, GameAI.m_teamStorage[m_fouledPlayersTeam], m_fouledPlayersTeam);
        GameLogic.m_controller[GameLogic.m_possession].m_passBall = true;
        GameAI.AnimatePass(m_quickPlayMomentSetPieceTaker, m_quickPlayMomentSetPieceTargetObject, 1, 2);
        GameAI.ballSetCollision(true);
    }

    public static void quickPlayMomentPlayThrowin() {
        m_quickPlayMomentConfusedAITimer = m_difficultySettingNumFramesAIConfusedForAfterQPM;
        GameLogic.setState(5, 47, -1, -1);
        GameLogic.m_controller[GameLogic.m_possession].m_passBall = true;
    }

    private static void quickPlayMomentUpdate() {
        --m_quickPlayMomentConfusedAITimer;
        if (m_quickPlayMomentTriggeredTimer > 0) {
            --m_quickPlayMomentTriggeredTimer;
        }
    }

    public static void setSubStateFreeKickAimInPassMode() {
        GameLogic.setPieceSelectionInit(m_possession, m_setPieceTaker);
        GameLogic.m_setPieceTaker[33] = -1;
        m_trajectoryType = GameLogic.isSetPiecePassTargetAShortPass(GameLogic.setPieceGetCurrentTarget()) ? 3 : 2;
        if (m_resetSetPieceTakerInfo) {
            GameLogic.setPieceReLoadSavedTargetInfo(true);
        }
        int[] nArray = GameAI.getPassTarget(m_setPieceTaker);
        GameLogic.m_setPieceTargetObject[0] = nArray[0];
        GameLogic.m_setPieceTargetObject[1] = nArray[1];
    }

    public static void setSubStateFreeKickTakeFreeKickPass() {
        m_setPieceWideTargetObject = null;
        XMLMenuSystem.setSoftKeys(9, 9);
    }

    public static void setSubStateFreeKickAimInShootMode() {
        GameLogic.m_controller[GameLogic.m_possession].m_passBall = false;
        GameLogic.m_controller[GameLogic.m_possession].m_shootBall = false;
        GameFormation.exclusionZonesAdjustment();
        GameLogic.m_setPieceTargetObject[0] = 12311;
        GameLogic.m_setPieceTargetObject[2] = 312;
        GameLogic.calculateNearFarGoalPostPositions(GameAI.teamGetPitchSide(m_possession ^ 1));
        GameLogic.m_setPieceTargetObject[1] = m_nearGoalPostY;
        if (m_gameMode == 5 && m_freeKickChallengeShowRoundInfo) {
            XMLMenuSystem.m_s_codedTextArray[0][0] = XMLMenuSystem.createSDKString(XMLMenuSystem.m_s_codedTextArray[0][0], "" + (m_freeKickChallengeCurrentRound + 1));
            GameRender.boxSetState(0, 6, 2, 1047, 0, 1, 1, true);
            m_freeKickChallengeShowRoundInfo = false;
        }
        if (m_resetSetPieceTakerInfo) {
            GameLogic.setPieceReLoadSavedTargetInfo(true);
        }
    }

    public static void setSubStateFreeKickMicroGame() {
        if (m_possession == GameLogic.getPlayerTeam()) {
            // empty if block
        }
        GameAI.ballSetCollision(true);
        m_controller[m_possession].setControlPlayer(m_setPieceTaker);
    }

    public static void setSubStateFreeKickTakeFreeKickShoot() {
        m_setPieceWideTargetObject = null;
        XMLMenuSystem.setSoftKeys(9, 9);
        if (m_gameMode == 2 && XMLMenuSystem.m_tutorialState == 0) {
            XMLMenuSystem.m_tutorialState = 1;
            GameRender.m_managerTutorialIndex = XMLMenuSystem.m_tutorialIndex + XMLMenuSystem.m_currSubTutorial;
            GameRender.managerSet(8);
        } else if (m_gameMode != 2) {
            GameLogic.managerTipCheckandShowForAttackingFreeKick();
        }
    }

    public static void setStateMatchStateThrowIn(int n2, int n3) {
        switch (m_matchSubState) {
            case 44: {
                GameLogic.setSubStateThrowInInit(n2, n3);
                break;
            }
            case 45: {
                GameLogic.setSubStateThrowInAim(n2, n3);
                break;
            }
            case 46: {
                GameLogic.setSubStateThrowInMicroGame(n2, n3);
                break;
            }
            case 47: {
                GameLogic.setSubStateThrowInPerform(n2, n3);
            }
        }
    }

    public static void setSubStateThrowInInit(int n2, int n3) {
        m_setPieceType = 3;
        m_setPieceTimer = NUMBER_OF_SECONDS_TO_KEEP_THROWIN_AWARENESS;
        m_controller[0].resetJoystick();
        m_controller[1].resetJoystick();
        m_controller[0].setControlPlayer(null);
        m_controller[1].setControlPlayer(null);
        GameFormation.updateLevel1();
        GameAI.m_ballStorage[0] = m_ballOutOfPlayPosition[0] + (m_ballOutOfPlayPosition[0] < 12311 ? -256 : 256);
        GameAI.m_ballStorage[1] = m_ballOutOfPlayPosition[1];
        GameAI.m_ballStorage[2] = 0;
        GameAI.objectResetVelocity(GameAI.m_ballStorage);
        m_setPieceTaker = GameLogic.nearestPlayerData(GameAI.m_ballStorage, m_possession, 0);
        GameAI.playerSetState(m_setPieceTaker, GameAI.m_ballStorage[0], GameAI.m_ballStorage[1], 11);
        int[] nArray = GameLogic.nearestPlayerData(GameAI.m_ballStorage, m_possession, 1, m_setPieceTaker, null);
        int n4 = DDMath.calcAngle(GameAI.m_ballStorage[0], GameAI.m_ballStorage[1], 12311, 32015);
        int n5 = DDMath.calcAngle(GameAI.m_ballStorage[0], GameAI.m_ballStorage[1], 12311, 0);
        GameAI.playerSetState(nArray, GameAI.m_ballStorage[0] + (DDMath.sin(n4) * 3840 >> 16), GameAI.m_ballStorage[1] + (DDMath.cos(n4) * 3840 >> 16), 186);
        GameAI.setPassTarget(m_setPieceTaker, nArray);
        m_setPieceTargetPlayer = nArray[9];
        nArray = GameLogic.nearestPlayerData(GameAI.m_ballStorage, m_possession, 1, m_setPieceTaker, nArray);
        GameAI.playerSetState(nArray, GameAI.m_ballStorage[0] + (DDMath.sin(n5) * 3840 >> 16), GameAI.m_ballStorage[1] + (DDMath.cos(n5) * 3840 >> 16), 186);
        m_setPieceMode = 1;
        GameLogic.managerTipCheckandShowForThrowIn();
    }

    public static void setSubStateThrowInAim(int n2, int n3) {
        int[] nArray = GameLogic.setPieceGetCurrentTarget();
        GameLogic.setPieceSelectionInit(m_possession, m_setPieceTaker);
        m_setPieceTargetPlayer = nArray[9];
        GameLogic.m_setPieceTaker[32] = nArray[9];
        m_trajectoryType = 2;
        int[] nArray2 = GameAI.getPassTarget(m_setPieceTaker);
        GameLogic.m_setPieceTargetObject[0] = nArray2[0];
        GameLogic.m_setPieceTargetObject[1] = nArray2[1];
    }

    public static void setSubStateThrowInMicroGame(int n2, int n3) {
    }

    public static void setSubStateThrowInPerform(int n2, int n3) {
        XMLMenuSystem.setSoftKeys(9, 9);
        m_stateTimer = 5;
    }

    public static void setStateMatchStatePenalty(int n2, int n3) {
        XMLMenuSystem.setSoftKeys(9, 9);
        switch (m_matchSubState) {
            case 54: {
                if (SKIPHINT) {
                    MainFrame.setMasterState(7);
                    XMLMenuSystem.m_globalArray[1] = 0;
                    break;
                }
                MainFrame.setMasterState(6);
                break;
            }
            case 12: {
                m_stateDelayedInitialisation = true;
                GameRender.fadeSet(false);
            }
            case 13: {
                GameLogic.setSubStatePenaltyAim(n2, n3);
                break;
            }
            case 14: {
                GameLogic.setSubStatePenaltyMicroGame(n2, n3);
                break;
            }
            case 15: {
                GameLogic.setSubStatePenaltyPerformKick(n2, n3);
            }
        }
    }

    public static void setSubStatePenaltyHint() {
        if (!SKIPHINT) {
            GameLogic.setState(8, 12, 8, 13);
        }
    }

    public static void setSubStatePenaltyInit(int n2, int n3) {
        m_stateDelayedInitialisation = false;
        m_setPieceType = 4;
        m_setPieceTimer = NUMBER_OF_SECONDS_TO_KEEP_PENALTY_KICK_AWARENESS;
        m_stateTimer = 22;
        if (m_gameMode != 99 && (m_gameMode != 1 || m_matchPeriod != 4)) {
            GameFormation.updateLevel1();
        }
        GameFormation.keeperUpdateLevel1(m_possession ^ 1, GameAI.m_playerStorage[m_possession ^ 1][0]);
        GameLogic.resetHumanControlPlayer();
        GameAI.m_ballStorage[0] = 12311;
        GameAI.m_ballStorage[1] = m_gameMode == 99 || m_gameMode == 1 && m_matchPeriod == 4 ? 28926 : (GameAI.teamGetPitchSide(m_fouledPlayer[12] ^ 1) == 0 ? 3089 : 28926);
        GameAI.m_ballStorage[6] = 0;
        GameAI.m_ballStorage[2] = 0;
        GameAI.objectResetVelocity(GameAI.m_ballStorage);
        int[] nArray = m_gameMode == 99 || m_gameMode == 1 && m_matchPeriod == 4 ? GameAI.m_playerStorage[m_possession][m_penaltyTakers[m_possession]] : GameAI.teamFindSetPeiceTaker(2, m_possession);
        m_setPieceTaker = nArray;
        if (m_setPieceTaker[28] != 12) {
            GameAI.playerSetState(m_setPieceTaker, GameAI.m_ballStorage[0], GameAI.m_ballStorage[1] + (GameAI.m_ballStorage[1] > 16007 ? -1280 : 1280), 11);
        }
        GameLogic.m_setPieceTargetObject[0] = 12311;
        GameLogic.m_setPieceGKTargetObject[0] = 12311;
        GameLogic.m_setPieceTargetObject[2] = 312;
        GameLogic.m_setPieceGKTargetObject[2] = 312;
        if (m_gameMode == 99 || m_gameMode == 1 && m_matchPeriod == 4 || GameAI.m_ballStorage[1] > 16007) {
            GameLogic.m_setPieceTargetObject[1] = 32015;
            GameLogic.m_setPieceGKTargetObject[1] = 32015;
        } else {
            GameLogic.m_setPieceTargetObject[1] = 0;
            GameLogic.m_setPieceGKTargetObject[1] = 0;
        }
    }

    public static void setSubStatePenaltyAim(int n2, int n3) {
        XMLMenuSystem.setSoftKeys(9, 9);
        if (GameAI.teamGetControlType(m_possession) == 0) {
            m_setPieceTargetObject[0] = m_setPieceTargetObject[0] + DDMath.getRandom() % m_goalWidth / 2;
            m_setPieceTargetObject[2] = m_setPieceTargetObject[2] + DDMath.getRandom() % 624 / 2;
        } else {
            m_setPieceGKTargetObject[0] = m_setPieceGKTargetObject[0] + DDMath.getRandom() % m_goalWidth / 2;
            m_setPieceGKTargetObject[2] = m_setPieceGKTargetObject[2] + DDMath.getRandom() % 624 / 2;
        }
    }

    public static void setSubStatePenaltyMicroGame(int n2, int n3) {
        if (m_possession == GameLogic.getPlayerTeam()) {
            // empty if block
        }
        if (m_gameMode == 99 || m_gameMode == 1 && m_matchPeriod == 4) {
            if (XMLMenuSystem.m_globalArray[101] >= 0 && GameLogic.getPlayerTeam() == m_possession && XMLMenuSystem.m_menuMatchType != 4) {
                GameRender.tutorialDrawSnazzyInfo(1011, 1);
                XMLMenuSystem.m_globalArray[101] = 1;
            }
        } else if (XMLMenuSystem.m_globalArray[103] == 0 && GameLogic.getPlayerTeam() == m_possession && XMLMenuSystem.m_menuMatchType != 4) {
            GameRender.tutorialDrawSnazzyInfo(1011, 1);
            XMLMenuSystem.m_globalArray[103] = 1;
        }
    }

    public static void setSubStatePenaltyPerformKick(int n2, int n3) {
        TouchscreenController.m_touchLayout = 0;
        XMLMenuSystem.setSoftKeys(9, 9);
    }

    public static void setStateMatchStateCorner(int n2, int n3) {
        m_stateTimer = MainFrame.m_inGameFrameRate * 3;
        switch (m_matchSubState) {
            case 16: {
                m_stateDelayedInitialisation = true;
                GameRender.fadeSet(false);
                break;
            }
            case 17: {
                GameLogic.setSubStateCornerAim(n2, n3);
                break;
            }
            case 18: {
                GameLogic.setSubStateCornerMicroGame(n2, n3);
                break;
            }
            case 19: {
                GameLogic.setSubStateCornerPerformKick(n2, n3);
            }
        }
    }

    public static void setSubStateCornerInit(int n2, int n3) {
        m_possession = m_gameMode == 2 ? GameLogic.getPlayerTeam() : m_ballOutOfPlayTeamWithPossessionAsBallWentOut ^ 1;
        m_stateDelayedInitialisation = false;
        m_setPieceType = 2;
        m_setPieceTimer = NUMBER_OF_SECONDS_TO_KEEP_CORNER_KICK_AWARENESS;
        GameAI.ballSetCollision(true);
        GameAI.ballSetToFreeBall();
        XMLMenuSystem.setSoftKeys(9, 9);
        m_controller[0].resetJoystick();
        m_controller[1].resetJoystick();
        m_controller[0].setControlPlayer(null);
        m_controller[1].setControlPlayer(null);
        int[] nArray = m_setPieceTaker;
        m_setPieceTaker = GameAI.teamFindSetPeiceTaker(1, m_possession);
        if (nArray != m_setPieceTaker && nArray != null && (nArray[28] == 11 || nArray[28] == 12)) {
            GameAI.playerSetState(nArray, nArray[25], nArray[26], 71);
        }
        GameAI.m_ballStorage[0] = m_ballOutOfPlayPosition[0] < 12311 ? 150 : 24472;
        GameAI.m_ballStorage[1] = m_ballOutOfPlayPosition[1] < 16007 ? 150 : 31865;
        GameAI.m_ballStorage[2] = 0;
        GameAI.objectResetVelocity(GameAI.m_ballStorage);
        m_setPieceMode = 1;
        GameFormation.updateLevel1();
        GameFormation.setUpPlayersInTheBox();
        if (m_setPieceTaker[28] != 12) {
            GameAI.playerSetState(m_setPieceTaker, GameAI.m_ballStorage[0] + (GameAI.m_ballStorage[0] < 12311 ? -1280 : 1280), GameAI.m_ballStorage[1], 11);
        }
        GameFormation.setGoalKeepersToTheirBaseLine();
        GameLogic.setPieceSelectionInit(m_possession, m_setPieceTaker);
        GameLogic.managerTipCheckandShowForCorner();
    }

    public static void setSubStateCornerAim(int n2, int n3) {
        GameLogic.setPieceSelectionInit(m_possession, m_setPieceTaker);
        GameAI.ballSetCollision(true);
        m_trajectoryType = GameLogic.isSetPiecePassTargetAShortPass(GameLogic.setPieceGetCurrentTarget()) ? 3 : 2;
        if (m_resetSetPieceTakerInfo) {
            GameLogic.setPieceReLoadSavedTargetInfo(true);
        }
        int[] nArray = GameAI.getPassTarget(m_setPieceTaker);
        GameLogic.m_setPieceTargetObject[0] = nArray[0];
        GameLogic.m_setPieceTargetObject[1] = nArray[1];
    }

    public static void setSubStateCornerMicroGame(int n2, int n3) {
        m_controller[m_possession].setControlPlayer(m_setPieceTaker);
    }

    public static void setSubStateCornerPerformKick(int n2, int n3) {
        XMLMenuSystem.setSoftKeys(9, 9);
        m_stateTimer = 5;
    }

    public static void setStateMatchStateGoalKick(int n2, int n3) {
        switch (m_matchSubState) {
            case 40: {
                GameRender.fadeSet(false);
                break;
            }
            case 41: {
                GameLogic.setSubStateGoalKickAim(n2, n3);
                break;
            }
            case 42: {
                GameLogic.setSubStateGoalKickMicroGame(n2, n3);
                break;
            }
            case 43: {
                GameLogic.setSubStateGoalKickPerformKick(n2, n3);
            }
        }
    }

    public static void setSubStateGoalKickInit(int n2, int n3) {
        int[] nArray = GameAI.m_playerStorage[m_possession][0];
        m_setPieceType = 1;
        m_setPieceTimer = NUMBER_OF_SECONDS_TO_KEEP_GOAL_KICK_AWARENESS;
        m_setPieceTaker = null;
        GameLogic.resetHumanControlPlayer();
        GameLogic.refereeUpdateOffsidePlayerFlags(true);
        nArray[33] = -1;
        nArray[33] = -1;
        m_stateTimer = 20;
        if (m_matchState == 17 && m_matchSubState == 40) {
            GameAI.m_ballStorage[0] = 12311 + (m_ballOutOfPlayPosition[0] < 12311 ? -3097 : 3097);
            GameAI.m_ballStorage[1] = m_ballOutOfPlayPosition[1] < 16007 ? 1543 : 30472;
            GameAI.m_ballStorage[2] = 0;
            GameAI.playerSetState(nArray, GameAI.m_ballStorage[0], GameAI.m_ballStorage[1] + (DDMath.cos(nArray[14] + 128) * 1280 >> 16), 11);
        } else if (m_matchState == 14) {
            GameAI.playerSetState(nArray, 0, 0, 12);
        }
        GameAI.objectResetVelocity(GameAI.m_ballStorage);
        GameAI.teamSetState(0, 8);
        GameAI.teamSetState(1, 8);
        int n4 = m_gameMode != 2 ? m_possession : GameLogic.getPlayerTeam();
        int[] nArray2 = GameLogic.nearestPlayerData(GameAI.m_ballStorage, n4, 1);
        GameAI.setPassTarget(nArray, nArray2);
        GameAI.playerSetState(nArray2, nArray2[25], nArray2[26] + (-DDMath.cos(nArray2[14]) * 3840 >> 16), 17);
        GameLogic.m_setPieceTargetObject[0] = GameAI.m_ballStorage[0] + DDMath.getRandom() % 2560;
        GameLogic.m_setPieceTargetObject[1] = 16007 + DDMath.getPositiveRandom() % 1280;
        int[] nArray3 = GameLogic.nearestPlayerData(m_setPieceTargetObject, n4, 1);
        int[] nArray4 = GameLogic.nearestPlayerData(m_setPieceTargetObject, n4 ^ 1, 1);
        GameAI.setPassTargetLong(nArray, nArray3);
        GameAI.playerSetState(nArray3, m_setPieceTargetObject[0], m_setPieceTargetObject[1], 151);
        if (m_gameMode != 2) {
            GameAI.playerSetState(nArray4, m_setPieceTargetObject[0], m_setPieceTargetObject[1], 147);
            nArray4[54] = nArray3[9];
        } else if (m_gameMode == 2 && m_matchNextState != 9 && XMLMenuSystem.m_currTutorial != 6) {
            if ((XMLMenuSystem.m_currTutorial == 2 || XMLMenuSystem.m_currTutorial == 4 || XMLMenuSystem.m_currTutorial == 5) && XMLMenuSystem.m_tutorialComplete[XMLMenuSystem.m_tutorialIndex + XMLMenuSystem.m_currSubTutorial]) {
                XMLMenuSystem.tutorialComplete();
            } else {
                XMLMenuSystem.tutorialReset();
            }
        }
    }

    public static void setSubStateGoalKickAim(int n2, int n3) {
    }

    public static void setSubStateGoalKickMicroGame(int n2, int n3) {
    }

    public static void setSubStateGoalKickPerformKick(int n2, int n3) {
    }

    public static void setStateMatchStateEndOfPeriod(int n2, int n3) {
        m_stateTimer = 36;
        if (m_matchPeriod == 0 || m_matchPeriod == 2 || GameAI.m_teamStorage[0][6] == GameAI.m_teamStorage[1][6]) {
            GameAI.teamSetState(0, 6);
            GameAI.teamSetState(1, 6);
        } else if (GameAI.m_teamStorage[0][6] > GameAI.m_teamStorage[1][6]) {
            GameAI.teamSetState(0, 6);
            GameAI.teamSetState(1, 7);
        } else {
            GameAI.teamSetState(0, 7);
            GameAI.teamSetState(1, 6);
        }
        GameLogic.requestSound(1);
        if (m_gameMode != 99 && (m_gameMode != 1 || m_matchPeriod != 4)) {
            if (m_matchPeriod == 0) {
                GameRender.commentarySet(true, 1);
            } else if (m_matchPeriod == 1) {
                GameRender.commentarySet(true, 3);
            }
        }
        GameRender.replayRecordBufferFlush();
    }

    public static void setStateMatchStateEndOfMatch(int n2, int n3) {
        m_stateTimer = 30;
        XMLMenuSystem.setSoftKeys(9, 9);
        if (GameAI.m_teamStorage[GameLogic.getPlayerTeam()][6] > GameAI.m_teamStorage[GameLogic.getOpponentTeam()][6]) {
            GameLogic.requestSound(2);
        }
    }

    public static void setStateMatchStateReplay(int n2, int n3) {
        if (!m_replayDoNotTrigger && XMLMenuSystem.m_menuMatchType != 4) {
            GameAI.m_playerStorage[0][0][2] = 0;
            GameAI.m_playerStorage[1][0][2] = 0;
            switch (m_matchSubState) {
                case 33: {
                    XMLMenuSystem.m_inGamePrevMenu = XMLMenuSystem.m_currMenu;
                    XMLMenuSystem.setMenu(37);
                    GameRender.replaySetState(true, 0, -1);
                    break;
                }
                case 35: {
                    GameRender.replaySetState(true, 1, 5);
                    break;
                }
                case 36: {
                    GameRender.replaySetState(true, 1, 0);
                    break;
                }
                case 37: {
                    GameRender.replaySetState(true, 1, 1);
                    break;
                }
                case 38: {
                    GameRender.replaySetState(true, 1, 3);
                    break;
                }
                case 39: {
                    GameRender.replaySetState(true, 1, 4);
                    break;
                }
                case 34: {
                    GameRender.replaySetState(true, 2, -1);
                }
            }
        } else if (XMLMenuSystem.m_menuMatchType == 4) {
            GameLogic.setState(m_matchNextState, m_matchNextSubState, -1, -1);
        } else {
            m_matchState = m_matchPrevState;
            m_matchSubState = m_matchPrevSubState;
            m_matchNextState = m_matchPrevNextState;
            m_matchNextSubState = m_matchPrevNextSubState;
        }
        m_replayDoNotTrigger = false;
    }

    public static void setStateMatchStateWaitRefCard(int n2, int n3) {
        GameAI.teamSetState(0, 0);
        GameAI.teamSetState(1, 0);
        short[] sArray = GameAI.m_teamStorage[m_fouledPlayersTeam ^ 1];
        sArray[12] = (short)(sArray[12] + 1);
        GameLogic.matchEventAdd(m_foulingPlayer[12], m_foulingPlayer[11], m_matchTimer, 1);
        GameLogic.m_foulingPlayer[49] = m_foulingPlayer[58];
        if (m_foulingPlayer[49] == 2) {
            short[] sArray2 = GameAI.m_teamStorage[m_fouledPlayersTeam ^ 1];
            sArray2[11] = (short)(sArray2[11] + 1);
            GameAI.playerSetState(m_foulingPlayer, 0, 16007, 75);
            GameLogic.matchEventAdd(m_foulingPlayer[12], m_foulingPlayer[11], m_matchTimer, 2);
        } else {
            GameAI.playerSetState(m_foulingPlayer, 0, 0, 76);
        }
    }

    public static void setStateMatchStateSubstitutions(int n2, int n3) {
        int n4 = 0;
        m_controller[0].resetAllActions();
        m_controller[1].resetAllActions();
        if (m_matchSubState == 50) {
            for (int i2 = 0; i2 < 2; ++i2) {
                if (XMLMenuSystem.m_subsCompletedCount[i2] == XMLMenuSystem.m_subsRequestCount[i2]) continue;
                XMLMenuSystem.m_subsCurrentTeamProcessing = i2;
                n4 = i2 == 0 ? GameLogic.getPlayerTeam() : GameLogic.getOpponentTeam();
                break;
            }
            GameAI.m_playerSubOn = GameAI.m_playerStorage[XMLMenuSystem.m_subsCurrentTeamProcessing][XMLMenuSystem.getSubOnLineupId(XMLMenuSystem.m_subsCurrentTeamProcessing, XMLMenuSystem.m_subsCompletedCount[XMLMenuSystem.m_subsCurrentTeamProcessing])];
            GameAI.m_playerSubOff = GameAI.m_playerStorage[XMLMenuSystem.m_subsCurrentTeamProcessing][XMLMenuSystem.getSubOffLineupId(XMLMenuSystem.m_subsCurrentTeamProcessing, XMLMenuSystem.m_subsCompletedCount[XMLMenuSystem.m_subsCurrentTeamProcessing])];
            XMLMenuSystem.setMenu(22);
            XMLMenuSystem.setSubsMenu();
            GameAI.m_playerSubOn[0] = -512;
            GameAI.m_playerSubOn[1] = 16224;
            GameAI.m_playerSubOn[21] = 64;
            GameAI.m_playerSubOn[22] = 64;
            GameAI.m_playerSubOn[15] = GameAI.m_playerSubOff[0];
            GameAI.m_playerSubOn[16] = GameAI.m_playerSubOff[1];
            GameAI.m_playerSubOn[29] = GameAI.m_playerSubOff[29];
            GameAI.playerSetState(GameAI.m_playerSubOn, 0, 0, 122);
            if (GameAI.m_playerSubOff == GameAI.m_playerInjured) {
                GameAI.m_playerSubOff[0] = -512;
                GameAI.m_playerSubOff[1] = 15790;
            } else {
                GameAI.m_playerSubOff[0] = 8207;
                GameAI.m_playerSubOff[1] = 15790;
            }
            GameAI.playerSetState(GameAI.m_playerSubOff, -512, 15790, 121);
        } else if (m_matchSubState == 53) {
            m_stateTimer = 3;
        } else if (m_matchSubState == 51) {
            m_stateTimer = 3 * MainFrame.m_inGameFrameRate;
        }
    }

    public static void substitutionStart(int n2, int n3, int n4, int n5) {
        m_substitutionState = n2;
        m_substitutionSubState = n3;
        m_substitutionNextState = n4;
        m_substitutionNextSubState = n5;
        if (GameAI.m_playerInjured != null) {
            GameLogic.setState(18, 48, -1, -1);
        } else {
            GameLogic.setState(18, 49, -1, -1);
        }
    }

    private static void substitutionComplete() {
        int n2 = GameAI.m_playerSubOff[12];
        int n3 = n2 == GameLogic.getPlayerTeam() ? 0 : 1;
        GameAI.m_playerSubOn[6] = GameAI.m_playerSubOn[6] & 0xFFDFFFFF;
        GameAI.m_playerSubOff[6] = GameAI.m_playerSubOff[6] & 0xFFEFFFFF;
        GameAI.m_playerSubOff[6] = GameAI.m_playerSubOff[6] | 0x400000;
        GameAI.m_playerSubOn[48] = GameAI.m_playerSubOff[48];
        XMLMenuSystem.swapPlayerAttribute(GameAI.m_playerSubOn, GameAI.m_playerSubOff, 9);
        XMLMenuSystem.swapPlayerAttribute(GameAI.m_playerSubOn, GameAI.m_playerSubOff, 52);
        GameAI.m_playerStorage[n2][GameAI.m_playerSubOn[9]] = GameAI.m_playerSubOn;
        GameAI.m_playerStorage[n2][GameAI.m_playerSubOff[9]] = GameAI.m_playerSubOff;
        XMLMenuSystem.m_currentLineup[n3][GameAI.m_playerSubOn[9]] = GameAI.m_playerSubOn[11];
        XMLMenuSystem.m_currentLineup[n3][GameAI.m_playerSubOff[9]] = GameAI.m_playerSubOff[11];
        if (m_setPieceTaker == GameAI.m_playerSubOff) {
            m_setPieceTaker = GameAI.m_playerSubOn;
        }
        GameFormation.jumpPlayersToTheirPositions();
        if (GameAI.m_playerSubOff == GameAI.m_playerInjured) {
            GameAI.m_playerInjured = null;
        }
        GameAI.m_playerSubOn = null;
        GameAI.m_playerSubOff = null;
        int n4 = n2;
        XMLMenuSystem.m_subsCompletedCount[n4] = XMLMenuSystem.m_subsCompletedCount[n4] + 1;
    }

    public static void ballUpdate() {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n9 = n8 = GameAI.m_ballStorage[0];
        int n10 = n7 = GameAI.m_ballStorage[1];
        int n11 = n6 = GameAI.m_ballStorage[2];
        n9 = DDMath.max(n9, 0);
        n10 = DDMath.max(n10, 0);
        n11 = DDMath.max(n11, 0);
        n9 = DDMath.min(n9, 24621);
        n10 = DDMath.min(n10, 32014);
        GameLogic.ballUpdateMovement();
        int n12 = GameAI.m_ballStorage[0];
        int n13 = GameAI.m_ballStorage[1];
        int n14 = GameAI.m_ballStorage[2];
        int n15 = 0;
        GameLogic.ballUpdateBallToGoalMarkerRunToPos();
        GameLogic.ballUpdateMarkerRunPosWideAndSideGrapple();
        if (m_refereeDecision == 6 && n12 > 12311 - m_goalWidth / 2 && n12 < 12311 + m_goalWidth / 2 && (n13 < 102 && n13 >= -986 || n13 > 31913 && n13 <= 33001) && n14 <= 522) {
            GameAI.m_ballStorage[6] = GameAI.m_ballStorage[6] | 0x40;
        }
        if (!GameAI.ballIsInTheGoal()) {
            n5 = 1;
            if (m_matchPeriod == 6 && m_freeKickChallengeBallOutOfPlay) {
                n5 = 0;
            }
            bl = true;
            if (m_matchState == 2 || m_matchState == 4) {
                int n16;
                int n17;
                if (GameLogic.ballCheckCollisionWithLeftPitchEdge(n9, n12)) {
                    n15 = 1;
                }
                if (GameLogic.ballCheckCollisionWithRightPitchEdge(n9, n12)) {
                    n15 = 2;
                }
                if (GameLogic.ballCheckCollisionWithBottomPitchEdge(n10, n13)) {
                    n4 = n13 - n10;
                    n3 = n4 != 0 ? (n12 - n9 << 8) / n4 : 0;
                    n2 = ((0 - n10) * n3 >> 8) + n9;
                    n17 = n13 - n10 != 0 ? (n14 - n11 << 8) / (n13 - n10) : 0;
                    n16 = ((0 - n10) * n17 >> 8) + n11;
                    if (n5 != 0 && GameLogic.ballCheckCollisionWithGoalPosts(n2, n13, n16)) {
                        if (GameAI.ballGetLastTouchPlayer()[28] != 29) {
                            GameAI.m_ballStorage[0] = n2;
                            GameAI.m_ballStorage[2] = n16;
                            int n18 = n2 > 12311 ? 12311 + m_goalWidth / 2 + 19 : 12311 - m_goalWidth / 2 - 19;
                            int n19 = 0;
                            GameAI.ballSetToFreeBall();
                            GameLogic.ballAndPostCollisionReaction(n18, n19, GameAI.m_ballStorage[0], GameAI.m_ballStorage[1]);
                            bl3 = true;
                            if (m_gameMode == 99 || m_gameMode == 1 && m_matchPeriod == 4) {
                                n15 = 4;
                            }
                        }
                    } else if (n5 != 0 && GameLogic.ballCheckCollisionWithCrossBar(n2, n13, n16)) {
                        if (GameAI.ballGetLastTouchPlayer()[28] != 29) {
                            GameAI.m_ballStorage[0] = n2;
                            GameAI.m_ballStorage[2] = n16;
                            GameAI.ballSetToFreeBall();
                            GameLogic.ballAndBarCollisionReaction(643, 0, GameAI.m_ballStorage[2], GameAI.m_ballStorage[1]);
                            bl3 = true;
                            if (m_gameMode == 99 || m_gameMode == 1 && m_matchPeriod == 4) {
                                n15 = 4;
                            }
                        }
                    } else if (n5 != 0 && GameLogic.ballCheckCollisionWithGoal(n2, n13, n16)) {
                        GameAI.m_ballStorage[0] = DDMath.min(GameAI.m_ballStorage[0], 12311 + m_goalWidth / 2);
                        GameAI.m_ballStorage[0] = DDMath.max(GameAI.m_ballStorage[0], 12311 - m_goalWidth / 2);
                        n12 = GameAI.m_ballStorage[0];
                        bl2 = true;
                        bl = false;
                        if (GameLogic.ballCheckItsFullyOverTheGoalLine(n12, n13, n14)) {
                            GameAI.m_ballStorage[6] = GameAI.m_ballStorage[6] | 0x40;
                        }
                    } else {
                        n15 = 8;
                        bl = true;
                    }
                }
                if (GameLogic.ballCheckCollisionWithTopPitchEdge(n10, n13)) {
                    n3 = n13 - n10 > 0 ? (n12 - n9 << 8) / (n13 - n10) : 0;
                    n2 = ((32015 - n10) * n3 >> 8) + n9;
                    if (GameLogic.ballCheckCollisionWithGoalPosts(n2, n13, n16 = ((32015 - n10) * (n17 = n13 - n10 > 0 ? (n14 - n11 << 8) / (n13 - n10) : 0) >> 8) + n11)) {
                        if (GameAI.ballGetLastTouchPlayer()[28] != 29) {
                            GameAI.m_ballStorage[0] = n2;
                            GameAI.m_ballStorage[2] = n16;
                            GameAI.m_ballStorage[1] = 32010;
                            bl3 = true;
                            n4 = n2 > 12311 ? 12311 + m_goalWidth / 2 + 19 : 12311 - m_goalWidth / 2 - 19;
                            GameLogic.ballAndPostCollisionReaction(n4, 32015, GameAI.m_ballStorage[0], GameAI.m_ballStorage[1]);
                            if (m_gameMode == 99 || m_gameMode == 1 && m_matchPeriod == 4) {
                                n15 = 4;
                            }
                        }
                    } else if (GameLogic.ballCheckCollisionWithCrossBar(n2, n13, n16)) {
                        if (GameAI.ballGetLastTouchPlayer()[28] != 29) {
                            GameAI.m_ballStorage[0] = n2;
                            GameAI.m_ballStorage[2] = n16;
                            GameLogic.ballAndBarCollisionReaction(643, 32015, GameAI.m_ballStorage[2], GameAI.m_ballStorage[1]);
                            bl3 = true;
                            if (m_gameMode == 99 || m_gameMode == 1 && m_matchPeriod == 4) {
                                n15 = 4;
                            }
                        }
                    } else if (GameLogic.ballCheckCollisionWithGoal(n2, n13, n16)) {
                        GameAI.m_ballStorage[0] = DDMath.min(GameAI.m_ballStorage[0], 12311 + m_goalWidth / 2);
                        GameAI.m_ballStorage[0] = DDMath.max(GameAI.m_ballStorage[0], 12311 - m_goalWidth / 2);
                        n12 = GameAI.m_ballStorage[0];
                        bl2 = true;
                        bl = false;
                        if (GameLogic.ballCheckItsFullyOverTheGoalLine(n12, n13, n14)) {
                            GameAI.m_ballStorage[6] = GameAI.m_ballStorage[6] | 0x40;
                        }
                        if (m_gameMode == 4) {
                            m_gameModeResetTimer = 20;
                        }
                    } else {
                        n15 = 4;
                        bl = true;
                    }
                }
            } else if ((n13 <= 1 && n13 > -884 || n13 > 32014 && n13 <= 32899) && GameAI.m_ballStorage[2] <= 624) {
                bl = true;
            }
        } else {
            DDDebug.msg("SW ******************** BALL IS IN THE GOAL *********************************");
            bl2 = true;
        }
        if (bl3) {
            GameRender.replaySetEventTag(32763);
            MainFrame.vibratePlay(200);
        }
        if (bl2 && !bl3) {
            GameAI.m_ballStorage[3] = GameAI.m_ballStorage[3] * 244 >> 8;
            GameAI.m_ballStorage[4] = GameAI.m_ballStorage[4] * 244 >> 8;
            GameAI.m_ballStorage[5] = GameAI.m_ballStorage[5] * 244 >> 8;
            if (n13 <= 0 || n13 >= 32015) {
                if (n10 <= 32899 && n13 > 32899) {
                    GameAI.m_ballStorage[1] = 32898;
                    GameAI.m_ballStorage[3] = GameAI.m_ballStorage[3] * 76 >> 8;
                    GameAI.m_ballStorage[4] = -(GameAI.m_ballStorage[4] * 76) >> 8;
                }
                if (n10 >= -884 && n13 < -884) {
                    GameAI.m_ballStorage[1] = -883;
                    GameAI.m_ballStorage[3] = GameAI.m_ballStorage[3] * 76 >> 8;
                    GameAI.m_ballStorage[4] = -(GameAI.m_ballStorage[4] * 76) >> 8;
                }
                n5 = n9 - 12311;
                n4 = n12 - 12311;
                if (n5 >= -m_goalWidth / 2 && n4 < -m_goalWidth / 2) {
                    GameAI.m_ballStorage[0] = 12311 - m_goalWidth / 2 + 1;
                    GameAI.m_ballStorage[3] = -(GameAI.m_ballStorage[3] * 76) >> 8;
                    GameAI.m_ballStorage[4] = GameAI.m_ballStorage[4] * 76 >> 8;
                }
                if (n5 <= m_goalWidth / 2 && n4 > m_goalWidth / 2) {
                    GameAI.m_ballStorage[0] = 12311 + m_goalWidth / 2 - 1;
                    GameAI.m_ballStorage[3] = -(GameAI.m_ballStorage[3] * 76) >> 8;
                    GameAI.m_ballStorage[4] = GameAI.m_ballStorage[4] * 76 >> 8;
                }
                if (n11 <= 624 && n14 > 624) {
                    GameAI.m_ballStorage[2] = 624;
                }
            }
        }
        if (bl && !bl3) {
            n5 = 12311 - m_goalWidth / 2;
            if (n8 <= n5 && n12 > n5) {
                n3 = n12 - n9 > 0 ? (n13 - n10 << 8) / (n12 - n9) : 0;
                n2 = ((n5 - n9) * n3 >> 8) + n10;
                if ((n13 <= 1 && n13 > -884 || n13 >= 32014 && n13 <= 32899) && GameAI.m_ballStorage[2] <= 624) {
                    if (Trajectory.isBallUnderTrajectoryControl()) {
                        Trajectory.removeFromTrajectory(GameAI.m_ballStorage, 0);
                        GameAI.ballSetToFreeBall();
                    }
                    n15 = 0;
                    GameAI.m_ballStorage[6] = GameAI.m_ballStorage[6] & 0xFFFFFFBF;
                    GameAI.m_ballStorage[0] = n5;
                    GameAI.m_ballStorage[3] = GameAI.m_ballStorage[3] >> 1;
                    GameAI.m_ballStorage[3] = GameAI.m_ballStorage[3] * -1;
                    GameAI.m_ballStorage[4] = GameAI.m_ballStorage[4] >> 1;
                }
            }
            if (n8 >= (n5 = 12311 + m_goalWidth / 2) && n12 < n5) {
                n3 = n12 - n9 > 0 ? (n13 - n10 << 8) / (n12 - n9) : 0;
                n2 = ((n5 - n9) * n3 >> 8) + n10;
                if ((n13 <= 1 && n13 > -884 || n13 >= 32014 && n13 <= 32899) && GameAI.m_ballStorage[2] <= 624) {
                    if (Trajectory.isBallUnderTrajectoryControl()) {
                        GameAI.ballSetToFreeBall();
                        Trajectory.removeFromTrajectory(GameAI.m_ballStorage, 0);
                    }
                    n15 = 0;
                    GameAI.m_ballStorage[6] = GameAI.m_ballStorage[6] & 0xFFFFFFBF;
                    GameAI.m_ballStorage[0] = n5;
                    GameAI.m_ballStorage[3] = GameAI.m_ballStorage[3] >> 1;
                    GameAI.m_ballStorage[3] = GameAI.m_ballStorage[3] * -1;
                    GameAI.m_ballStorage[4] = GameAI.m_ballStorage[4] >> 1;
                }
            }
            if (n12 >= 12311 - m_goalWidth / 2 && n12 < 12311 + m_goalWidth / 2 && (n7 > 32899 && n13 <= 32899 || n7 < -884 && n13 >= -884)) {
                if (Trajectory.isBallUnderTrajectoryControl()) {
                    Trajectory.removeFromTrajectory(GameAI.m_ballStorage, 0);
                    GameAI.ballSetToFreeBall();
                }
                GameAI.m_ballStorage[6] = GameAI.m_ballStorage[6] & 0xFFFFFFBF;
                GameAI.m_ballStorage[1] = GameAI.m_ballStorage[1] > 32015 ? 32900 : -885;
                GameAI.m_ballStorage[3] = GameAI.m_ballStorage[3] >> 1;
                GameAI.m_ballStorage[4] = GameAI.m_ballStorage[4] >> 1;
                GameAI.m_ballStorage[4] = GameAI.m_ballStorage[4] * -1;
            }
            if (n6 >= 624 && n14 < 624 && n12 > 12311 - m_goalWidth / 2 && n12 < 12311 + m_goalWidth / 2 && (n13 < 1 && n13 >= -884 || n13 > 32014 && n13 <= 32899)) {
                if (Trajectory.isBallUnderTrajectoryControl()) {
                    Trajectory.removeFromTrajectory(GameAI.m_ballStorage, 0);
                    GameAI.ballSetToFreeBall();
                }
                n15 = 0;
                GameAI.m_ballStorage[6] = GameAI.m_ballStorage[6] & 0xFFFFFFBF;
                GameAI.m_ballStorage[2] = 624;
                if (GameAI.m_ballStorage[5] < 0) {
                    GameAI.m_ballStorage[5] = -(GameAI.m_ballStorage[5] * 107) >> 8;
                }
            }
            if (m_gameMode != 2) {
                if ((n13 + GameAI.m_ballStorage[4] < -1561 && n13 >= -1561 && GameAI.m_ballStorage[4] < 0 || n13 + GameAI.m_ballStorage[4] > 33576 && n13 <= 33576 && GameAI.m_ballStorage[4] > 0) && GameAI.m_ballStorage[2] < 205) {
                    GameAI.m_ballStorage[4] = -GameAI.m_ballStorage[4] / 3;
                    GameAI.m_ballStorage[5] = GameAI.m_ballStorage[5] + DDMath.abs(GameAI.m_ballStorage[4]) / 3 * 2;
                }
                if ((n12 + GameAI.m_ballStorage[3] < -1561 && n12 >= -1561 && GameAI.m_ballStorage[3] < 0 && GameAI.m_ballStorage[2] < 205 || n12 + GameAI.m_ballStorage[3] > 25902 && n12 <= 25902 && GameAI.m_ballStorage[3] > 0 && GameAI.m_ballStorage[2] < 205) && (n13 > -795 && n13 < 14947 || n13 > 15212 && n13 < 32810)) {
                    GameAI.m_ballStorage[3] = -GameAI.m_ballStorage[3] / 3;
                    GameAI.m_ballStorage[5] = GameAI.m_ballStorage[5] + DDMath.abs(GameAI.m_ballStorage[3]) / 3 * 2;
                }
            }
        }
        if (m_matchState == 2) {
            if (n15 != 0) {
                GameLogic.ballSetOutOfPitchSide(n15);
            } else if (!GameAI.ballIsPossessed() && GameAI.m_ballStorage[2] > 0) {
                GameLogic.ballCalculateFutureBouncePosition();
            }
        }
        if ((GameAI.m_ballStorage[6] & 0x80) == 0 && (m_matchState == 2 || m_matchState == 17 && m_matchSubState == 43 || m_matchState == 9 && m_matchSubState == 29 || m_matchState == 9 && m_matchSubState == 30 || m_matchState == 6 && m_matchSubState == 19 || m_matchState == 8 && m_matchSubState == 15)) {
            GameLogic.Object_AddToCollisionList(GameAI.m_ballStorage, 30);
        }
    }

    private static final void ballUpdatePossessedLastFrame() {
        GameAI.m_ballStorage[6] = GameAI.ballIsPossessed() ? GameAI.m_ballStorage[6] | 0x4000 : GameAI.m_ballStorage[6] & 0xFFFFBFFF;
    }

    private static final void ballUpdatePossessedByDistanceFromLTPDribbler() {
        int[] nArray = GameAI.ballGetLastTouchPlayer();
        if (nArray[28] == 9 && DDMath.calcHorizontalDistSquared(nArray, GameAI.m_ballStorage) > 0x900000) {
            GameAI.ballSetToFreeBall();
            GameAI.m_playerWithBall = null;
            m_controller[nArray[12]].setControlPlayer(null);
            GameAI.playerSetState(nArray, 0, 0, 34);
        }
    }

    private static final void ballUpdatePossessedByLTPState() {
        int[] nArray = GameAI.ballGetLastTouchPlayer();
        switch (nArray[28]) {
            case 0: 
            case 1: 
            case 13: 
            case 71: 
            case 89: 
            case 93: 
            case 105: {
                boolean bl = false;
                GameAI.ballSetToFreeBall();
                GameAI.m_playerWithBall = null;
            }
        }
    }

    public static final void ballUpdateMovement() {
        int n2;
        int n3;
        int n4 = GameAI.m_ballStorage[0];
        int n5 = GameAI.m_ballStorage[1];
        int n6 = GameAI.m_ballStorage[2];
        n4 = DDMath.max(n4, 0);
        n5 = DDMath.max(n5, 0);
        n6 = DDMath.max(n6, 0);
        n4 = DDMath.min(n4, 24621);
        n5 = DDMath.min(n5, 32014);
        int n7 = n4 - GameAI.m_passTargetObject[0];
        int n8 = n5 - GameAI.m_passTargetObject[1];
        int n9 = n7 * n7 + n8 * n8;
        if ((GameAI.m_ballStorage[6] & 4) != 0) {
            n3 = DDMath.atan(GameAI.m_ballStorage[3], GameAI.m_ballStorage[4]);
            if (DDMath.abs(DDMath.calcTurnAngle(n3, n2 = DDMath.calcAngle(GameAI.m_ballStorage, GameAI.m_passTargetObject))) > 21 && n9 > 262144) {
                GameAI.ballClearAllPassFlags();
            }
            if (GameAI.m_ballStorage[3] * GameAI.m_ballStorage[3] + GameAI.m_ballStorage[4] * GameAI.m_ballStorage[4] < 6400) {
                GameAI.ballClearAllPassFlags();
            }
        } else if ((GameAI.m_ballStorage[6] & 0x10) != 0 && DDMath.abs(DDMath.calcTurnAngle(n3 = DDMath.atan(GameAI.m_ballStorage[3], GameAI.m_ballStorage[4]), n2 = DDMath.calcAngle(GameAI.m_ballStorage, GameAI.m_shotTargetObject))) > 10) {
            GameAI.m_ballStorage[6] = GameAI.m_ballStorage[6] & 0xFFFFFFEF;
        }
        if (Trajectory.isBallUnderTrajectoryControl()) {
            Trajectory.updateTrajectory(GameAI.m_ballStorage, 0);
        } else {
            if (GameAI.m_ballStorage[2] > 0 || GameAI.m_ballStorage[5] != 0) {
                GameAI.m_ballStorage[5] = GameAI.m_ballStorage[5] - GRAVITY_PER_FRAME;
            }
            GameAI.m_ballStorage[0] = GameAI.m_ballStorage[0] + GameAI.m_ballStorage[3];
            GameAI.m_ballStorage[1] = GameAI.m_ballStorage[1] + GameAI.m_ballStorage[4];
            GameAI.m_ballStorage[2] = GameAI.m_ballStorage[2] + GameAI.m_ballStorage[5];
            if (GameAI.m_ballStorage[2] < 0) {
                GameAI.m_crossIsCornerKick = false;
                n3 = -GameAI.m_ballStorage[5];
                if (n3 <= BALL_BOUNCE_THRESHOLD_VELOCITY) {
                    GameAI.m_ballStorage[5] = 0;
                    GameAI.m_ballStorage[2] = 0;
                    if (m_gameMode == 2 && XMLMenuSystem.m_currTutorial == 2 && !XMLMenuSystem.m_tutorialComplete[XMLMenuSystem.m_tutorialIndex + XMLMenuSystem.m_currSubTutorial]) {
                        XMLMenuSystem.tutorialReset();
                    }
                } else {
                    GameAI.m_ballStorage[3] = GameAI.m_ballStorage[3] * 192 >> 8;
                    GameAI.m_ballStorage[4] = GameAI.m_ballStorage[4] * 192 >> 8;
                    GameAI.m_ballStorage[5] = n3 * 107 >> 8;
                    n2 = (n6 << 8) / n3;
                    int n10 = 256 - n2;
                    GameAI.m_ballStorage[2] = GameAI.m_ballStorage[5] * n10 / 256;
                    GameAI.m_ballStorage[6] = GameAI.m_ballStorage[6] & 0xFFFFFFF7;
                    GameAI.m_ballStorage[6] = GameAI.m_ballStorage[6] & 0xFFFFEFFF;
                    GameAI.m_playerRunningOntoBall = null;
                }
            }
            if (GameAI.m_ballStorage[2] >= 0 && (GameAI.m_ballStorage[6] & 0x400) == 0) {
                if (GameAI.m_ballStorage[2] == 0) {
                    GameAI.m_ballStorage[3] = GameAI.m_ballStorage[3] * m_friction / 256;
                    GameAI.m_ballStorage[4] = GameAI.m_ballStorage[4] * m_friction / 256;
                } else {
                    GameAI.m_ballStorage[3] = GameAI.m_ballStorage[3] * AIR_RESISTANCE / 256;
                    GameAI.m_ballStorage[4] = GameAI.m_ballStorage[4] * AIR_RESISTANCE / 256;
                }
                n3 = 614 / MainFrame.m_inGameFrameRate;
                if (DDMath.sqrtRout(GameAI.m_ballStorage[3] * GameAI.m_ballStorage[3] + GameAI.m_ballStorage[4] * GameAI.m_ballStorage[4]) < n3) {
                    GameAI.m_ballStorage[3] = 0;
                    GameAI.m_ballStorage[4] = 0;
                }
            }
        }
    }

    private static void ballUpdateBallToGoalMarkerRunToPos() {
        int n2;
        int n3 = 12311;
        int n4 = GameAI.teamGetPitchSide(m_possession) == 0 ? 32015 : 0;
        int n5 = DDMath.calcAngle(GameAI.m_ballStorage[0], GameAI.m_ballStorage[1], n3, n4);
        int n6 = GameAI.teamGetControlType(m_possession ^ 1) == 2 ? 0 : XMLMenuSystem.teamTacticalOptionsMarkingStyleGet(m_possession ^ 1);
        int n7 = 0;
        for (n2 = 0; n2 < 11; ++n2) {
            int[] nArray = GameAI.m_playerStorage[m_possession ^ 1][n2];
            if (nArray[28] != 93) continue;
            int n8 = GameAI.teamGetControlType(m_possession ^ 1) == 2 ? 1 : GameFormation.getPlayerType(nArray[52]);
            block0 : switch (n8) {
                case 1: {
                    switch (n6) {
                        case 2: {
                            n7 = 1536;
                            break;
                        }
                        case 1: {
                            n7 = 1088;
                            break;
                        }
                        case 0: {
                            n7 = 640;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n6) {
                        case 2: {
                            n7 = 1920;
                            break;
                        }
                        case 1: {
                            n7 = 1536;
                            break;
                        }
                        case 0: {
                            n7 = 1152;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (n6) {
                        case 2: {
                            n7 = 2176;
                            break block0;
                        }
                        case 1: {
                            n7 = 1664;
                            break block0;
                        }
                        case 0: {
                            n7 = 1408;
                        }
                    }
                }
            }
            n7 = n7 * m_difficultySettingMarkingBallToGoalsideJockeyRuntoDistanceMultiplier / 100;
        }
        GameAI.m_ballToGoalMarkerRunToPosJockeyX = GameAI.m_ballStorage[0] + (DDMath.sin(n5) * n7 >> 16);
        GameAI.m_ballToGoalMarkerRunToPosJockeyY = GameAI.m_ballStorage[1] + (DDMath.cos(n5) * n7 >> 16);
        n2 = n7 * 140 / 100;
        GameAI.m_ballToGoalMarkerRunToPosX = GameAI.m_ballStorage[0] + (DDMath.sin(n5) * n2 >> 16);
        GameAI.m_ballToGoalMarkerRunToPosY = GameAI.m_ballStorage[1] + (DDMath.cos(n5) * n2 >> 16);
    }

    private static void ballUpdateMarkerRunPosWideAndSideGrapple() {
        int n2;
        int n3;
        GameAI.m_MarkerRunWidePosToUseX = -1;
        GameAI.m_MarkerRunWidePosToUseY = -1;
        GameAI.m_MarkerRunWidePosToDiscardX = -1;
        GameAI.m_MarkerRunWidePosToDiscardY = -1;
        GameAI.m_MarkerRunSideGrapplePosX = -1;
        GameAI.m_MarkerRunSideGrapplePosY = -1;
        GameAI.m_markTargetFacingAwayFromGoalRunToPosX = -1;
        GameAI.m_markTargetFacingAwayFromGoalRunToPosY = -1;
        int[] nArray = null;
        for (int i2 = 0; i2 < 11 && (nArray = GameAI.m_playerStorage[m_possession ^ 1][i2])[28] != 93; ++i2) {
            nArray = null;
        }
        if (nArray == null) {
            return;
        }
        int[] nArray2 = GameAI.playerGetMarkTarget(nArray);
        if (nArray2 == null) {
            return;
        }
        int n4 = GameAI.m_ballStorage[0] + (DDMath.sin(nArray2[22] + 35) * 1536 >> 16);
        int n5 = GameAI.m_ballStorage[1] + (DDMath.cos(nArray2[22] + 35) * 1536 >> 16);
        int n6 = GameAI.m_ballStorage[0] + (DDMath.sin(nArray2[22] - 35) * 1536 >> 16);
        int n7 = GameAI.m_ballStorage[1] + (DDMath.cos(nArray2[22] - 35) * 1536 >> 16);
        int n8 = 12311;
        int n9 = GameAI.teamGetPitchSide(m_possession) == 0 ? 32015 : 0;
        int n10 = DDMath.calcHorizontalDistSquared(n4, n5, n8, n9);
        if (n10 < (n3 = DDMath.calcHorizontalDistSquared(n6, n7, n8, n9))) {
            GameAI.m_MarkerRunWidePosToUseX = n4;
            GameAI.m_MarkerRunWidePosToUseY = n5;
            GameAI.m_MarkerRunWidePosToDiscardX = n6;
            GameAI.m_MarkerRunWidePosToDiscardY = n7;
            n2 = 1;
        } else {
            GameAI.m_MarkerRunWidePosToUseX = n6;
            GameAI.m_MarkerRunWidePosToUseY = n7;
            GameAI.m_MarkerRunWidePosToDiscardX = n4;
            GameAI.m_MarkerRunWidePosToDiscardY = n5;
            n2 = -1;
        }
        GameAI.m_MarkerRunSideGrapplePosX = GameAI.m_ballStorage[0] + (DDMath.sin(nArray2[22] + 39 * n2) * 153 >> 16);
        GameAI.m_MarkerRunSideGrapplePosY = GameAI.m_ballStorage[1] + (DDMath.cos(nArray2[22] + 39 * n2) * 153 >> 16);
        GameAI.m_markTargetFacingAwayFromGoalRunToPosX = GameAI.m_ballStorage[0] + (GameAI.m_ballStorage[0] - nArray2[0]) * 2;
        GameAI.m_markTargetFacingAwayFromGoalRunToPosY = GameAI.m_ballStorage[1] + (GameAI.m_ballStorage[1] - nArray2[1]) * 2;
    }

    public static final boolean ballCheckCollisionWithLeftPitchEdge(int n2, int n3) {
        return n2 >= 0 && n3 < 0;
    }

    public static final boolean ballCheckCollisionWithRightPitchEdge(int n2, int n3) {
        return n2 < 24622 && n3 >= 24622;
    }

    public static final boolean ballCheckCollisionWithBottomPitchEdge(int n2, int n3) {
        return n2 >= 0 && n3 < 0;
    }

    public static final boolean ballCheckCollisionWithTopPitchEdge(int n2, int n3) {
        return n2 < 32015 && n3 >= 32015;
    }

    public static final boolean ballCheckCollisionWithGoalPosts(int n2, int n3, int n4) {
        return (n2 > 12311 - m_goalWidth / 2 - 38 && n2 < 12311 - m_goalWidth / 2 || n2 < 12311 + m_goalWidth / 2 + 38 && n2 > 12311 + m_goalWidth / 2) && n4 < 624;
    }

    public static final boolean ballCheckCollisionWithCrossBar(int n2, int n3, int n4) {
        return n2 > 12311 - m_goalWidth / 2 && n2 < 12311 + m_goalWidth / 2 && n4 < 662 && n4 > 624;
    }

    public static final boolean ballCheckCollisionWithGoal(int n2, int n3, int n4) {
        System.out.println("x ---:" + n2 + "----y---:" + n3);
        minigame_bonus = 0;
        if (m_matchPeriod == 6) {
            if (n3 > -350 && n3 < -250 && n2 > 11500 && n2 < 12500 && GameRender.temp_string.toString().equalsIgnoreCase(XMLMenuSystem.getMenuStringCoded(GameRender.temp_string, 0, 1060, 0).toString())) {
                m_freeKickChallengePoints += 1000;
                minigame_bonus = 1000;
                MIDDLE_SUCCESS = true;
            } else if (n3 > -500 && n3 < -325 && n2 > 12500 && n2 < 14000 && GameRender.temp_string.toString().equals(XMLMenuSystem.getMenuStringCoded(GameRender.temp_string, 0, 1056, 0).toString())) {
                m_freeKickChallengePoints += 3000;
                minigame_bonus = 3000;
                TL_CORNER_SUCCESS = true;
            } else if (n3 > -150 && n3 < -100 && n2 > 12000 && n2 < 13200 && GameRender.temp_string.toString().equals(XMLMenuSystem.getMenuStringCoded(GameRender.temp_string, 0, 1057, 0).toString())) {
                m_freeKickChallengePoints += 2000;
                minigame_bonus = 2000;
                BL_CORNER_SUCCESS = true;
            } else if (n3 > -500 && n3 < -325 && n2 > 10949 && n2 < 12000 && GameRender.temp_string.toString().equals(XMLMenuSystem.getMenuStringCoded(GameRender.temp_string, 0, 1058, 0).toString())) {
                m_freeKickChallengePoints += 2000;
                minigame_bonus = 3000;
                TR_CORNER_SUCCESS = true;
            } else if (n3 > -200 && n3 < -50 && n2 > 11000 && n2 < 12000 && GameRender.temp_string.toString().equals(XMLMenuSystem.getMenuStringCoded(GameRender.temp_string, 0, 1059, 0).toString())) {
                m_freeKickChallengePoints += 2000;
                minigame_bonus = 2000;
                BR_CORNER_SUCCESS = true;
            }
        }
        if (m_matchPeriod == 4 && m_gameMode == 99 && !GameRender.AI_TURN_SHOOTOUT) {
            int n5 = 12311 - m_goalWidth / 2;
            int n6 = 12311 + m_goalWidth / 2;
            int n7 = n6 >> 1;
            if (n3 == 32143 && n2 > 11826 && n2 < 12826) {
                if (MIDDLE_HITTED) {
                    stay = true;
                    penaltyGoalScore += 10000;
                }
            } else if ((n3 == 32632 || n3 == 32529 || n3 == 32358 || n3 == 32295) && n2 > n5 && n2 < 11700) {
                if (TL_CORNER_HITTED) {
                    stay = true;
                    penaltyGoalScore += 30000;
                }
            } else if ((n3 == 32632 || n3 == 32529 || n3 == 32358 || n3 == 32295) && n2 > 12807 && n2 < n6) {
                if (TR_CORNER_HITTED) {
                    stay = true;
                    penaltyGoalScore += 30000;
                }
            } else if (n3 > 32143 && n3 < 32500 && n2 > n5 && n2 < 11700) {
                if (BL_CORNER_HITTED) {
                    stay = true;
                    penaltyGoalScore += 20000;
                }
            } else if (n3 > 32143 && n3 < 32500 && n2 > 12800 && n2 < n6 && BR_CORNER_HITTED) {
                stay = true;
                penaltyGoalScore += 20000;
            }
        }
        return n2 > 12311 - m_goalWidth / 2 && n2 < 12311 + m_goalWidth / 2 && n4 < 624;
    }

    public static final boolean ballCheckItsFullyOverTheGoalLine(int n2, int n3, int n4) {
        return n3 < -102 || n3 > 32117;
    }

    public static final void ballAndPostCollisionReaction(int n2, int n3, int n4, int n5) {
        int n6 = DDMath.sqrtRout(361 - (n2 - n4) * (n2 - n4));
        n5 = n5 > 16007 ? 32015 - n6 : n6;
        GameLogic.ballCylindricalCollisionReaction(n2, n3, n4, n5, 165);
    }

    public static final void ballAndBarCollisionReaction(int n2, int n3, int n4, int n5) {
        int n6 = DDMath.sqrtRout(361 - (n2 - n4) * (n2 - n4));
        n5 = n5 > 16007 ? 32015 - n6 : n6;
        GameLogic.ballCylindricalCollisionReactionBar(n2, n3, n4, n5, 116);
    }

    public static final void ballCylindricalCollisionReaction(int n2, int n3, int n4, int n5, int n6) {
        int n7 = DDMath.atan(n4 - n2, n5 - n3);
        int n8 = DDMath.atan(GameAI.m_ballStorage[3], GameAI.m_ballStorage[4]);
        n8 = n8 + 128 & 0xFF;
        int n9 = DDMath.calcTurnAngle(n7, n8);
        int n10 = DDMath.min(DDMath.abs(n9), 49);
        n8 = n9 > 0 ? n7 + n10 : n7 - n10;
        int n11 = DDMath.CalcModDifference(n7, n8);
        n11 = DDMath.min(n11, 56);
        n11 = n7 - DDMath.calcTurnAngle(n7, n8);
        int n12 = DDMath.sqrtRout(GameAI.m_ballStorage[3] * GameAI.m_ballStorage[3] + GameAI.m_ballStorage[4] * GameAI.m_ballStorage[4]);
        n12 = n12 * n6 >> 8;
        n12 = DDMath.max(n12, MIN_POST_REBOUND_SPEED);
        GameAI.m_ballStorage[3] = DDMath.sin(n11 &= 0xFF) * n12 >> 16;
        GameAI.m_ballStorage[4] = DDMath.cos(n11) * n12 >> 16;
        n12 = 38;
        GameAI.m_ballStorage[0] = n2 + (DDMath.sin(n7) * n12 >> 16);
        GameAI.m_ballStorage[1] = n3 + (DDMath.cos(n7) * n12 >> 16);
    }

    public static final void ballCylindricalCollisionReactionBar(int n2, int n3, int n4, int n5, int n6) {
        int n7 = DDMath.atan(n4 - n2, n5 - n3);
        int n8 = DDMath.atan(GameAI.m_ballStorage[5], GameAI.m_ballStorage[4]);
        n8 = n8 + 128 & 0xFF;
        int n9 = DDMath.calcTurnAngle(n7, n8);
        int n10 = DDMath.min(DDMath.abs(n9), 49);
        n8 = n9 > 0 ? n7 + n10 : n7 - n10;
        int n11 = DDMath.CalcModDifference(n7, n8);
        n11 = n7 - DDMath.calcTurnAngle(n7, n8);
        int n12 = DDMath.sqrtRout(GameAI.m_ballStorage[5] * GameAI.m_ballStorage[5] + GameAI.m_ballStorage[4] * GameAI.m_ballStorage[4]);
        n12 = n12 * n6 >> 8;
        n12 = DDMath.max(n12, MIN_POST_REBOUND_SPEED);
        GameAI.m_ballStorage[5] = DDMath.sin(n11 &= 0xFF) * n12 >> 16;
        GameAI.m_ballStorage[4] = DDMath.cos(n11) * n12 >> 16;
        n12 = 38;
        GameAI.m_ballStorage[2] = n2 + (DDMath.sin(n7) * n12 >> 16);
        GameAI.m_ballStorage[1] = n3 + (DDMath.cos(n7) * n12 >> 16);
    }

    public static final void ballSetOutOfPitchSide(int n2) {
        if (m_gameMode == 4) {
            m_gameModeResetTimer = MainFrame.m_inGameFrameRate * 1;
        } else if (m_gameMode == 99 || m_gameMode == 1 && m_matchPeriod == 4) {
            if (m_gameModeResetTimer <= 0) {
                GameLogic.penaltyShootOutUpdateScores(n2 == 16);
            }
            GameLogic.setState(3, -1, 3, -1);
        } else if (m_gameMode == 5 && GameRender.m_fadeState == 2 && !m_freeKickChallengeRoundComplete && MainFrame.m_masterState == 6) {
            m_freeKickChallengeBallOutOfPlay = true;
            if ((n2 & 0xF) != 0) {
                GameLogic.freeKickChallengeFadeOut(false);
            } else {
                GameLogic.freeKickChallengeFadeOut(true);
            }
        }
        int n3 = GameAI.m_ballStorage[10];
        if (GameAI.m_playerStorage[n3 & 1][n3 >> 1][28] == 9) {
            GameAI.playerSetState(GameAI.m_playerStorage[n3 & 1][n3 >> 1], 0, 0, 0);
            m_replayDoNotTrigger = true;
        }
        if ((n2 & 3) != 0) {
            if (GameAI.m_playerWithBall != null) {
                GameAI.playerSetState(GameAI.m_playerWithBall, GameAI.m_playerWithBall[25], GameAI.m_playerWithBall[26], 1);
                GameAI.m_playerWithBall = null;
                m_controller[0].setControlPlayer(null);
                m_controller[1].setControlPlayer(null);
            }
            GameLogic.setState(3, -1, 5, 44);
        }
        if ((n2 & 0xC) != 0) {
            if (GameAI.m_playerWithBall != null) {
                GameAI.playerSetState(GameAI.m_playerWithBall, GameAI.m_playerWithBall[25], GameAI.m_playerWithBall[26], 1);
                GameAI.m_playerWithBall = null;
            }
            if (m_gameMode == 1 && m_matchPeriod != 4 || m_gameMode == 4) {
                GameRender.replaySetEventTag(32764);
                if (GameAI.teamGetPitchSide(m_possession) == 0 && n2 == 8 || GameAI.teamGetPitchSide(m_possession) == 1 && n2 == 4) {
                    GameLogic.setState(3, -1, 6, 16);
                } else {
                    GameLogic.setState(3, -1, 17, 40);
                }
            } else if (m_gameMode == 2) {
                if (n2 == 8) {
                    GameLogic.setState(3, -1, 17, 40);
                } else {
                    GameLogic.setState(3, -1, 6, 16);
                }
            }
        }
        if ((n2 & 0x30) != 0) {
            int[] nArray = GameAI.ballGetLastTouchPlayer();
            if (nArray[9] == 0) {
                if (nArray[28] == 29 || nArray[28] == 47 || nArray[28] == 40) {
                    return;
                }
                if (m_shootingPlayer != null) {
                    GameAI.ballSetLastTouchPlayer(m_shootingPlayer);
                }
            }
            int[] nArray2 = GameAI.ballGetLastTouchPlayer();
            m_scorerTeam = GameAI.ballGetLastTouchPlayerTeam();
            m_scorerID = GameAI.ballGetLastTouchPlayerID();
            if (m_gameMode == 1 || m_gameMode == 99) {
                GameLogic.requestSound(2);
            }
            if (m_gameMode != 99 && (m_gameMode != 1 || m_matchPeriod != 4) && m_gameMode != 5) {
                if (GameLogic.objectGetCurrentPitchSide(GameAI.m_ballStorage) == 0 && GameAI.teamGetPitchSide(GameAI.ballGetLastTouchPlayerTeam()) == 0 || GameLogic.objectGetCurrentPitchSide(GameAI.m_ballStorage) == 1 && GameAI.teamGetPitchSide(GameAI.ballGetLastTouchPlayerTeam()) == 1) {
                    GameLogic.setState(1, 20, 1, 9);
                    int[] nArray3 = GameAI.m_playerStorage[m_scorerTeam][nArray2[11]];
                    nArray3[70] = nArray3[70] + 1;
                    GameLogic.beAProCheckIfBAPStatAchieved(11, GameAI.m_playerStorage[m_scorerTeam][nArray2[11]], null);
                } else {
                    GameLogic.setState(1, 20, 1, 8);
                }
                if (m_scorerTeam == 0) {
                    GameRender.replaySetEventTag(32766);
                } else {
                    GameRender.replaySetEventTag(32765);
                }
            }
            if (m_gameMode != 5) {
                GameLogic.resetHumanControlPlayer();
            }
        }
    }

    public static final void ballCalculateFutureBouncePosition() {
        if (Trajectory.isBallUnderTrajectoryControl()) {
            GameLogic.m_futureBallObject[0] = Trajectory.getEndX(0);
            GameLogic.m_futureBallObject[1] = Trajectory.getEndY(0);
            GameLogic.m_futureBallObject[2] = Trajectory.getEndZ(0);
            if (m_futureBallObject[2] > 0) {
                GameLogic.m_futureBallObject[3] = Trajectory.getEndVelocityX(0);
                GameLogic.m_futureBallObject[4] = Trajectory.getEndVelocityY(0);
                GameLogic.m_futureBallObject[5] = Trajectory.getEndVelocityZ(0);
                m_futureBallHasBounced = false;
                while (!m_futureBallHasBounced) {
                    GameLogic.ballCalculateFuturePositionStepOneFrameAhead();
                }
            }
        } else {
            GameLogic.ballCalculateFuturePositionSetCurrentBallPosition();
            while (!m_futureBallHasBounced) {
                GameLogic.ballCalculateFuturePositionStepOneFrameAhead();
            }
        }
        m_ballBouncePositionX = m_futureBallObject[0];
        m_ballBouncePositionY = m_futureBallObject[1];
        m_ballBouncePositionZ = m_futureBallObject[2];
    }

    public static final void ballCalculateFutureBallPosition(int n2) {
        if (Trajectory.isBallUnderTrajectoryControl()) {
            if (Trajectory.getTimeToTarget(0) > n2) {
                Trajectory.calculateTrajectoryPosition(GameAI.m_tempStorage, 0, Trajectory.m_trajectoryParams[0][7] + n2);
                GameLogic.m_futureBallObject[0] = GameAI.m_tempStorage[0];
                GameLogic.m_futureBallObject[1] = GameAI.m_tempStorage[1];
                GameLogic.m_futureBallObject[2] = GameAI.m_tempStorage[2];
            } else {
                n2 -= Trajectory.getTimeToTarget(0);
                GameLogic.m_futureBallObject[0] = Trajectory.getEndX(0);
                GameLogic.m_futureBallObject[1] = Trajectory.getEndY(0);
                GameLogic.m_futureBallObject[2] = Trajectory.getEndZ(0);
                GameLogic.m_futureBallObject[3] = Trajectory.getEndVelocityX(0);
                GameLogic.m_futureBallObject[4] = Trajectory.getEndVelocityY(0);
                GameLogic.m_futureBallObject[5] = Trajectory.getEndVelocityZ(0);
                for (int i2 = 0; i2 < n2; ++i2) {
                    GameLogic.ballCalculateFuturePositionStepOneFrameAhead();
                }
            }
        } else {
            GameLogic.ballCalculateFuturePositionSetCurrentBallPosition();
            for (int i3 = 0; i3 < n2; ++i3) {
                GameLogic.ballCalculateFuturePositionStepOneFrameAhead();
            }
        }
    }

    public static final void ballCalculateFuturePositionStepOneFrameAhead() {
        int n2;
        int n3 = m_futureBallObject[0];
        int n4 = m_futureBallObject[1];
        int n5 = m_futureBallObject[2];
        n3 = DDMath.max(n3, 0);
        n4 = DDMath.max(n4, 0);
        n5 = DDMath.max(n5, 0);
        n3 = DDMath.min(n3, 24621);
        n4 = DDMath.min(n4, 32014);
        if (m_futureBallObject[2] > 0 || m_futureBallObject[5] != 0) {
            m_futureBallObject[5] = m_futureBallObject[5] - GRAVITY_PER_FRAME;
        }
        m_futureBallObject[0] = m_futureBallObject[0] + m_futureBallObject[3];
        m_futureBallObject[1] = m_futureBallObject[1] + m_futureBallObject[4];
        m_futureBallObject[2] = m_futureBallObject[2] + m_futureBallObject[5];
        if (m_futureBallObject[2] < 0) {
            n2 = -m_futureBallObject[5];
            m_futureBallHasBounced = true;
            if (n2 <= BALL_BOUNCE_THRESHOLD_VELOCITY) {
                GameLogic.m_futureBallObject[5] = 0;
                GameLogic.m_futureBallObject[2] = 0;
            } else {
                GameLogic.m_futureBallObject[3] = m_futureBallObject[3] * 192 / 256;
                GameLogic.m_futureBallObject[4] = m_futureBallObject[4] * 192 / 256;
                GameLogic.m_futureBallObject[5] = n2 * 107 / 256;
                int n6 = (n5 << 8) / n2;
                int n7 = 256 - n6;
                GameLogic.m_futureBallObject[2] = m_futureBallObject[5] * n7 >> 8;
                m_futureBallObject[6] = m_futureBallObject[6] & 0xFFFFEFF7;
            }
        } else if (m_futureBallObject[2] == 0 && m_futureBallObject[5] == 0) {
            m_futureBallHasBounced = true;
        }
        if (m_futureBallObject[2] >= 0 && (m_futureBallObject[6] & 0x400) == 0) {
            if (m_futureBallObject[2] == 0) {
                GameLogic.m_futureBallObject[3] = m_futureBallObject[3] * m_friction / 256;
                GameLogic.m_futureBallObject[4] = m_futureBallObject[4] * m_friction / 256;
            } else {
                GameLogic.m_futureBallObject[3] = m_futureBallObject[3] * AIR_RESISTANCE / 256;
                GameLogic.m_futureBallObject[4] = m_futureBallObject[4] * AIR_RESISTANCE / 256;
            }
            n2 = 614 / MainFrame.m_inGameFrameRate;
            if (DDMath.sqrtRout(m_futureBallObject[3] * m_futureBallObject[3] + m_futureBallObject[4] * m_futureBallObject[4]) < n2) {
                GameLogic.m_futureBallObject[3] = 0;
                GameLogic.m_futureBallObject[4] = 0;
            }
        }
    }

    public static final void ballCalculateFuturePositionSetCurrentBallPosition() {
        GameAI.objectCopyValues(GameAI.m_ballStorage, m_futureBallObject, 0, 9);
        m_futureBallHasBounced = false;
    }

    public static boolean isFreeBallSituation() {
        int n2 = GameAI.m_ballStorage[10];
        int[] nArray = GameAI.m_playerStorage[n2 & 1][n2 >> 1];
        if (nArray[28] == 71 && (GameAI.m_ballStorage[6] & 0x1C) == 0) {
            GameAI.ballSetToFreeBall();
        }
        return !GameAI.ballIsInTheGoal() && !GameAI.ballIsPossessed() && !GameAI.ballIsInAPass() && !GameAI.ballIsInAShot();
    }

    public static final int[] nearestPlayerData(int[] nArray, int n2, int n3) {
        int n4 = Integer.MAX_VALUE;
        int[] nArray2 = null;
        for (int i2 = 1; i2 < 11; ++i2) {
            int n5;
            int n6;
            if (GameAI.m_playerStorage[n2][i2] == nArray || GameAI.m_playerStorage[n2][i2][49] == 2 || GameAI.m_playerStorage[n2][i2][28] == 117) continue;
            if ((n3 & 1) != 0) {
                n6 = GameAI.m_playerStorage[n2][i2][25] - nArray[0];
                n5 = GameAI.m_playerStorage[n2][i2][26] - nArray[1];
            } else {
                n6 = GameAI.m_playerStorage[n2][i2][0] - nArray[0];
                n5 = GameAI.m_playerStorage[n2][i2][1] - nArray[1];
            }
            if (n6 * n6 + n5 * n5 >= n4) continue;
            if ((n3 & 4) != 0) {
                int n7;
                int n8 = DDMath.atan(n6, n5);
                if (DDMath.CalcModDifference(n8, n7 = nArray[22]) >= 49) continue;
                n4 = n6 * n6 + n5 * n5;
                nArray2 = GameAI.m_playerStorage[n2][i2];
                continue;
            }
            n4 = n6 * n6 + n5 * n5;
            nArray2 = GameAI.m_playerStorage[n2][i2];
        }
        m_nearestPlayerDistanceSquaredStore = n4 >> 8;
        return nArray2;
    }

    public static final int[] nearestPlayerData(int[] nArray, int n2, int n3, int[] nArray2, int[] nArray3) {
        int n4 = Integer.MAX_VALUE;
        int[] nArray4 = null;
        boolean bl = false;
        for (int i2 = 1; i2 < 11; ++i2) {
            int n5;
            int n6;
            if (n3 == 2) {
                bl = false;
                if (n2 == 0 && GameAI.m_playerStorage[n2][i2][1] > 28541 || n2 == 1 && GameAI.m_playerStorage[n2][i2][1] < 3474) {
                    bl = true;
                }
            }
            if (GameAI.m_playerStorage[n2][i2] == nArray || GameAI.m_playerStorage[n2][i2] == nArray2 || GameAI.m_playerStorage[n2][i2] == nArray3 || bl || GameAI.m_playerStorage[n2][i2][49] == 2) continue;
            if ((n3 & 1) != 0) {
                n6 = GameAI.m_playerStorage[n2][i2][25] - nArray[0];
                n5 = GameAI.m_playerStorage[n2][i2][26] - nArray[1];
            } else {
                n6 = GameAI.m_playerStorage[n2][i2][0] - nArray[0];
                n5 = GameAI.m_playerStorage[n2][i2][1] - nArray[1];
            }
            if ((n3 & 4) != 0) {
                int n7;
                int n8 = DDMath.atan(n6, n5);
                if (DDMath.CalcModDifference(n8, n7 = nArray[22]) >= 49) continue;
                n4 = n6 * n6 + n5 * n5;
                nArray4 = GameAI.m_playerStorage[n2][i2];
                continue;
            }
            if (n6 * n6 + n5 * n5 >= n4) continue;
            n4 = n6 * n6 + n5 * n5;
            nArray4 = GameAI.m_playerStorage[n2][i2];
        }
        m_nearestPlayerDistanceSquaredStore = n4 >> 8;
        return nArray4;
    }

    public static final int[] nearestPlayerData(int n2, int n3, int n4, int n5, int[] nArray) {
        int n6 = 0x40000000;
        int[] nArray2 = null;
        boolean bl = false;
        for (int i2 = 1; i2 < 11; ++i2) {
            int n7;
            int n8;
            if (n5 == 2) {
                bl = false;
                if (n4 == 0 && GameAI.m_playerStorage[n4][i2][1] > 28541 || n4 == 1 && GameAI.m_playerStorage[n4][i2][1] < 3474) {
                    bl = true;
                }
            }
            if (GameAI.m_playerStorage[n4][i2] == nArray || bl || GameAI.m_playerStorage[n4][i2][49] == 2) continue;
            if ((n5 & 1) != 0) {
                n8 = GameAI.m_playerStorage[n4][i2][25] - n2;
                n7 = GameAI.m_playerStorage[n4][i2][26] - n3;
            } else {
                n8 = GameAI.m_playerStorage[n4][i2][0] - n2;
                n7 = GameAI.m_playerStorage[n4][i2][1] - n3;
            }
            if (n8 * n8 + n7 * n7 >= n6) continue;
            n6 = n8 * n8 + n7 * n7;
            nArray2 = GameAI.m_playerStorage[n4][i2];
        }
        m_nearestPlayerDistanceSquaredStore = n6 >> 8;
        return nArray2;
    }

    public static final byte findNearestPlayerInDirection(int n2, int[] nArray, int[] nArray2) {
        int n3 = 0x40000000;
        byte by = -1;
        for (int i2 = 1; i2 < 11; ++i2) {
            int[] nArray3 = GameAI.m_playerStorage[m_possession][i2];
            if (nArray3 == nArray || nArray3 == nArray2 || nArray3[49] == 2 || m_matchState == 5 && DDMath.calcHorizontalDistSquared(m_setPieceTaker, nArray3) > 58982400) continue;
            int n4 = nArray3[0] - nArray[0];
            int n5 = nArray3[1] - nArray[1];
            int n6 = n4 * n4 + n5 * n5 >> 8;
            int n7 = DDMath.atan(n4, n5);
            if (n2 == 0) {
                if (n4 >= 0 || (n6 *= 1 + (DDMath.CalcModDifference(192, n7) << 4)) >= n3 || DDMath.CalcModDifference(192, n7) > 60) continue;
                n3 = n6;
                by = (byte)i2;
                continue;
            }
            if (n2 == 1) {
                if (n4 <= 0 || (n6 *= 1 + DDMath.CalcModDifference(64, n7) << 4) >= n3 || DDMath.CalcModDifference(64, n7) > 60) continue;
                n3 = n6;
                by = (byte)i2;
                continue;
            }
            if (n2 == 2) {
                if (n5 <= 0 || (n6 *= 1 + DDMath.CalcModDifference(0, n7) << 4) >= n3 || DDMath.CalcModDifference(0, n7) > 60) continue;
                n3 = n6;
                by = (byte)i2;
                continue;
            }
            if (n2 != 3 || n5 >= 0 || (n6 *= 1 + DDMath.CalcModDifference(128, n7) << 4) >= n3 || DDMath.CalcModDifference(128, n7) > 60) continue;
            n3 = n6;
            by = (byte)i2;
        }
        return by;
    }

    public static final void offsideLineUpdate() {
        for (int i2 = 0; i2 < 2; ++i2) {
            int n2 = GameAI.teamGetPitchSide(i2);
            GameLogic.m_offsideline[i2] = GameAI.m_ballStorage[1];
            for (int i3 = 1; i3 < 11; ++i3) {
                int[] nArray = GameAI.m_playerStorage[i2][i3];
                GameLogic.m_offsideline[i2] = n2 == 1 ? DDMath.max(m_offsideline[i2], nArray[1] + 512) : DDMath.min(m_offsideline[i2], nArray[1] - 512);
            }
        }
        if (m_gameMode == 2) {
            GameLogic.m_offsideline[1] = DDMath.max(GameAI.m_ballStorage[1], 16007);
        }
    }

    public static final boolean isPlayerOffside(int[] nArray) {
        return GameLogic.isPlayerOffside(nArray, 0);
    }

    public static final boolean isPlayerOffside(int[] nArray, int n2) {
        int n3 = nArray[1];
        int n4 = nArray[12];
        int n5 = m_offsideline[n4 ^ 1];
        if (GameLogic.isObjectInOwnHalf(n4, nArray)) {
            return false;
        }
        if (GameAI.teamGetPitchSide(n4) == 1) {
            n3 = 32015 - n3;
            n5 = 32015 - n5;
        }
        return n3 + n2 > n5;
    }

    public static final boolean isPlayerAheadOfBall(int[] nArray) {
        return GameAI.teamGetPitchSide(nArray[12]) == 1 && nArray[1] < GameAI.m_ballStorage[1] || GameAI.teamGetPitchSide(nArray[12]) == 0 && nArray[1] > GameAI.m_ballStorage[1];
    }

    public static final boolean isBallInCrossingZone(int n2) {
        int n3 = GameAI.m_ballStorage[0];
        int n4 = GameAI.m_ballStorage[1];
        if (n2 == 0) {
            n4 = GameLogic.flipCoordinatePitchSide(n4);
        }
        return (n3 >= 0 && n3 <= 10240 || n3 <= 24622 && n3 >= 14382) && n4 < 6912;
    }

    public static final boolean isObjectInFinalThird(int[] nArray, int n2) {
        int n3 = nArray[1];
        if (n2 == 0) {
            n3 = 32015 - n3;
        }
        return n3 >= 0 && n3 <= 10671;
    }

    public static final boolean isObjectInFinalThird(int n2, int n3, int n4) {
        if (n4 == 0) {
            n3 = 32015 - n3;
        }
        return n3 >= 0 && n3 <= 10671;
    }

    public static final boolean isAttackingFreeKick() {
        int n2 = m_foulxpos;
        int n3 = m_foulypos;
        if (GameAI.teamGetPitchSide(m_possession) == 0) {
            n3 = 32015 - n3;
        }
        return (n2 = m_foulxpos - 12311) * n2 + (n3 -= 0) * n3 < 0x6400000;
    }

    public static final boolean isObjectInFinalQuarter(int[] nArray) {
        int n2 = nArray[1];
        if (GameAI.teamGetPitchSide(m_possession) == 0) {
            n2 = 32015 - n2;
        }
        return n2 >= 0 && n2 <= 8003;
    }

    public static final boolean isObjectIn5YardBox(int[] nArray, int n2) {
        int n3 = nArray[0] - 12311;
        int n4 = nArray[1];
        return n3 > -3097 && n3 < 3097 && (n2 == 0 && n4 > 0 && n4 < 1543 || n2 == 1 && n4 > 30472 && n4 < 32015);
    }

    public static final boolean isObjectIn18YardBox(int[] nArray, int n2) {
        int n3 = nArray[0] - 12311;
        int n4 = nArray[1];
        return n3 > -5670 && n3 < 5670 && (n2 == 0 && n4 > 0 && n4 < 4633 || n2 == 1 && n4 > 27382 && n4 < 32015);
    }

    public static final boolean isBallCloseEnoughToGoalieToRush(int[] nArray, int n2) {
        int n3 = nArray[0] - 12311;
        int n4 = nArray[1];
        return n3 > -4939 && n3 < 4939 && (n2 == 0 && n4 > 0 && n4 < 4035 || n2 == 1 && n4 > 27980 && n4 < 32015);
    }

    public static final boolean isObjectInOwnHalf(int n2, int[] nArray) {
        int n3 = nArray[1];
        if (GameAI.teamGetPitchSide(n2) == 1) {
            n3 = 32015 - n3;
        }
        return n3 <= 16007;
    }

    public static final boolean isBallInShootingRange(int n2) {
        int n3 = GameAI.m_ballStorage[0];
        int n4 = GameAI.m_ballStorage[1];
        if (n2 == 0) {
            n4 = 32015 - n4;
        }
        return (n3 -= 12311) * n3 + (n4 -= 0) * n4 < 80281600;
    }

    public static final boolean isBallInFinishingZone(int n2) {
        int n3 = 12311 - GameAI.m_ballStorage[0];
        int n4 = n2 == 0 ? 32015 - GameAI.m_ballStorage[1] : GameAI.m_ballStorage[1];
        return n3 <= 5760 && n4 <= 4608;
    }

    public static final boolean isBallInRangeForDefensiveHeader(int n2) {
        int n3 = GameAI.m_ballStorage[1];
        if (GameAI.teamGetPitchSide(n2) == 1) {
            n3 = 32015 - n3;
        }
        return n3 <= 18007;
    }

    public static final boolean isDefensiveHeaderAllowed(int n2) {
        return (GameAI.ballIsInACross() || GameAI.ballIsInAHighPass() || GameAI.ballIsInAShot()) && GameLogic.isBallInRangeForDefensiveHeader(n2) && m_possession != n2;
    }

    public static final int objectGetCurrentPitchSide(int[] nArray) {
        if (nArray[1] < 16007) {
            return 0;
        }
        return 1;
    }

    public static final boolean objectsAreAtTheSamePosition(int[] nArray, int[] nArray2) {
        return DDMath.calcHorizontalDistSquared(nArray, nArray2) < 36864;
    }

    private static void prematchLineupInit() {
        m_prematchLineupCurrentRow = -1;
        m_prematchLineupTimer = m_prematchLineupTimerFrames;
    }

    private static void prematchLineupUpdate() {
        if (m_matchState == 1 && m_matchSubState == 2 && m_prematchLineupCurrentTeam < 2 && m_prematchLineupCurrentRow != 7 && m_prematchLineupCurrentRow != -1 && m_matchPeriod == 0 && m_prematchLineupTimer > m_prematchLineupTimerFrames / 2 && XMLMenuSystem.m_menuTextBlockStart + XMLMenuSystem.m_menuTextBlockStep < XMLMenuSystem.m_menuTextBlockNumLines) {
            XMLMenuSystem.m_menuTextBlockStart += XMLMenuSystem.m_menuTextBlockStep;
        }
        if (m_matchPeriod == 0) {
            if (m_gameMode == 1 || m_gameMode == 6) {
                XMLMenuSystem.setSoftKeys(9, 9);
            }
            if (GameLogic.m_controller[0].m_buttonThrough || GameLogic.m_controller[1].m_buttonThrough) {
                GameLogic.prematchLineupButtonThrough(true);
                m_prematchLineupTimer = 0;
                GameLogic.m_controller[1].m_joystick = 0;
                GameLogic.m_controller[0].m_joystick = 0;
            } else if (++m_prematchLineupTimer > m_prematchLineupTimerFrames) {
                GameLogic.prematchLineupButtonThrough(false);
                m_prematchLineupTimer = 0;
            }
        }
    }

    private static void prematchLineupButtonThrough(boolean bl) {
        int n2 = GameLogic.prematchLineupUpdateCommentaryFormation(bl);
        if ((n2 & 7) != 7) {
            GameRender.commentarySet(true, 9);
        } else {
            GameRender.commentarySet(false, 9);
            GameRender.boxClose();
        }
    }

    private static int prematchLineupUpdateCommentaryFormation(boolean bl) {
        if (m_prematchLineupCurrentRow == -1) {
            m_prematchLineupCurrentRow = 7;
            m_prematchLineupCurrentTeam = 0;
        } else {
            if (m_prematchLineupCurrentRow == 7) {
                m_prematchLineupCurrentRow = -1;
            }
            if (++m_prematchLineupCurrentRow > 3 || bl) {
                m_prematchLineupCurrentRow = 7;
                ++m_prematchLineupCurrentTeam;
                GameRender.commentarySet(false, -1);
            }
            if (m_prematchLineupCurrentTeam < 2 && m_prematchLineupCurrentRow != 7) {
                GameRender.hudPrematchLineupPrepareCommentary(m_prematchLineupCurrentTeam, m_prematchLineupCurrentRow);
            }
        }
        return m_prematchLineupCurrentTeam << 3 | m_prematchLineupCurrentRow;
    }

    public static boolean prematchLineupAvailable() {
        return true;
    }

    public static void setPieceSelectionLoad() {
        setPieceSelection = new byte[44];
    }

    public static void setPieceSelectionInit(int n2, int[] nArray) {
        int n3;
        for (n3 = 1; n3 < 44; ++n3) {
            GameLogic.setPieceSelection[n3] = -1;
        }
        for (n3 = 1; n3 < 11; ++n3) {
            GameLogic.setPieceSelection[n3 * 4 + 0] = GameLogic.findNearestPlayerInDirection(0, GameAI.m_playerStorage[m_possession][n3], nArray);
            GameLogic.setPieceSelection[n3 * 4 + 1] = GameLogic.findNearestPlayerInDirection(1, GameAI.m_playerStorage[m_possession][n3], nArray);
            GameLogic.setPieceSelection[n3 * 4 + 2] = GameLogic.findNearestPlayerInDirection(2, GameAI.m_playerStorage[m_possession][n3], nArray);
            GameLogic.setPieceSelection[n3 * 4 + 3] = GameLogic.findNearestPlayerInDirection(3, GameAI.m_playerStorage[m_possession][n3], nArray);
        }
        int[] nArray2 = GameLogic.nearestPlayerData(GameAI.m_ballStorage, m_possession, 0, nArray, null);
        GameAI.setPassTarget(m_setPieceTaker, nArray2);
        m_setPieceTargetPlayer = nArray2[9];
    }

    public static void setPieceCycleTarget(int n2) {
        int n3 = m_setPieceTargetPlayer;
        if (n2 == 6) {
            if (setPieceSelection[m_setPieceTargetPlayer * 4 + 0] != -1) {
                m_setPieceTargetPlayer = setPieceSelection[m_setPieceTargetPlayer * 4 + 0];
            }
        } else if (n2 == 2) {
            if (setPieceSelection[m_setPieceTargetPlayer * 4 + 1] != -1) {
                m_setPieceTargetPlayer = setPieceSelection[m_setPieceTargetPlayer * 4 + 1];
            }
        } else if (n2 == 0) {
            if (setPieceSelection[m_setPieceTargetPlayer * 4 + 2] != -1) {
                m_setPieceTargetPlayer = setPieceSelection[m_setPieceTargetPlayer * 4 + 2];
            }
        } else if (n2 == 4 && setPieceSelection[m_setPieceTargetPlayer * 4 + 3] != -1) {
            m_setPieceTargetPlayer = setPieceSelection[m_setPieceTargetPlayer * 4 + 3];
        }
        GameLogic.m_setPieceTaker[32] = m_setPieceTargetPlayer;
        int[] nArray = GameAI.m_playerStorage[m_possession][m_setPieceTargetPlayer];
        int[] nArray2 = GameAI.m_playerStorage[m_possession][n3];
        if (GameLogic.isSetPiecePassTargetAShortPass(nArray)) {
            m_trajectoryType = 3;
        } else if (GameLogic.isSetPiecePassTargetAShortPass(nArray2)) {
            m_trajectoryType = 2;
        }
    }

    public static void setPieceSetTarget(int n2) {
        int n3 = m_setPieceTargetPlayer;
        GameLogic.m_setPieceTaker[32] = m_setPieceTargetPlayer = n2;
        int[] nArray = GameAI.m_playerStorage[m_possession][m_setPieceTargetPlayer];
        int[] nArray2 = GameAI.m_playerStorage[m_possession][n3];
        if (GameLogic.isSetPiecePassTargetAShortPass(nArray)) {
            m_trajectoryType = 3;
        } else if (GameLogic.isSetPiecePassTargetAShortPass(nArray2)) {
            m_trajectoryType = 2;
        }
    }

    public static int[] setPieceGetCurrentTarget() {
        if (m_setPieceTargetPlayer >= 0) {
            return GameAI.m_playerStorage[m_possession][m_setPieceTargetPlayer];
        }
        return null;
    }

    public static void setPieceUpdateTargets(int n2, int[] nArray) {
        int n3 = MainFrame.m_inGameFrameRate * 2;
        if (--setPieceUpdateTimer <= 0) {
            setPieceUpdateTimer = n3;
            int[] nArray2 = GameLogic.setPieceGetCurrentTarget();
            if (m_gameMode != 5) {
                GameLogic.setPieceSelectionInit(n2, nArray);
                m_setPieceTargetPlayer = nArray2[9];
                GameLogic.m_setPieceTaker[32] = nArray2[9];
            }
        }
    }

    public static void setPieceSaveTargetInfo() {
        m_resetSetPieceTakerInfo = true;
        m_resetSetPieceTakerTrajectory = m_trajectoryType;
        m_resetSetPieceTakerMode = m_setPieceMode;
        m_resetSetPieceTakerTarget = m_setPieceTargetPlayer;
    }

    public static void setPieceReLoadSavedTargetInfo(boolean bl) {
        if (m_resetSetPieceTakerInfo) {
            if (bl) {
                m_resetSetPieceTakerInfo = false;
            }
            m_trajectoryType = m_resetSetPieceTakerTrajectory;
            m_setPieceMode = m_resetSetPieceTakerMode;
            if (m_resetSetPieceTakerTarget > 0) {
                m_setPieceTargetPlayer = m_resetSetPieceTakerTarget;
                if (m_setPieceTaker != null) {
                    GameLogic.m_setPieceTaker[32] = m_setPieceTargetPlayer;
                }
            }
        }
    }

    public static void requestSound(int n2) {
        if (MainFrame.m_masterState == 5) {
            return;
        }
        int n3 = 1;
        if (n2 == 0) {
            n3 = 6;
        }
        MainFrame.soundPlay(n2, n3);
    }

    private static void resetSubsData() {
        XMLMenuSystem.initSubsData();
    }

    private static void setupMatchPeriodLengths() {
        m_injuryTime = XMLMenuSystem.m_menuMatchType == 4 ? 2 : 1 + DDMath.getPositiveRandom() % 3;
        m_matchPeriodLengths = new byte[7];
        for (int i2 = 0; i2 < 7; ++i2) {
            GameLogic.m_matchPeriodLengths[i2] = MATCH_PERIOD_LENGTHS[i2];
            if (XMLMenuSystem.m_menuMatchType == 4 || MATCH_PERIOD_LENGTH_ADJUST_RANGES[i2] <= 0) continue;
            int n2 = i2;
            m_matchPeriodLengths[n2] = (byte)(m_matchPeriodLengths[n2] + (byte)DDMath.abs(DDMath.getRandom() % (MATCH_PERIOD_LENGTH_ADJUST_RANGES[i2] + 1)));
        }
    }

    public static void setupMatchTime(int n2) {
        m_matchTimerRealMins = n2;
        m_matchTimerSecond = n2 * 256 * 1000 / 90 >> 8;
        m_matchTimerMinute = n2 * 60 * 256 / 90 * 1000 >> 8;
        m_matchTimerCurrentSecond = 0;
        m_matchTimer = 0;
        m_interruptTimeLastFramesDifference = 0;
        m_matchTimerCount = (int)System.currentTimeMillis();
        if (XMLMenuSystem.m_menuMatchType != 4) {
            GameLogic.interruptContinueMatchTimer();
        }
    }

    public static void interruptContinueMatchTimer() {
        m_matchTimerCount = (int)System.currentTimeMillis() - m_interruptTimeLastFramesDifference;
        GameLogic.updateMatchTimer();
    }

    private static int updateMatchTimer() {
        int n2;
        m_interruptTimeLastFramesDifference = n2 = (int)System.currentTimeMillis() - m_matchTimerCount;
        m_matchTimer = n2 / (m_matchTimerSecond + 1) / 60;
        m_matchTimerCurrentSecond = n2 / (m_matchTimerSecond + 1) % 60;
        if (m_matchTimer > m_matchPeriodLength) {
            return 1;
        }
        return 0;
    }

    public static void setMatchPeriod(int n2) {
        int n3;
        int n4;
        m_matchPeriod = n2;
        m_matchPeriodLength = m_matchPeriodLengths[m_matchPeriod];
        m_potentialPeriodTicks = m_matchTimerRealMins * 60 / (90 / MATCH_PERIOD_LENGTHS[n2]) * MainFrame.m_inGameFrameRate / MATCH_PERIOD_LENGTHS[n2];
        m_fatigueEffect = XMLMenuSystem.getSprintControlType(GameLogic.getPlayerTeam()) == 0 ? 128 / m_potentialPeriodTicks : 256 / m_potentialPeriodTicks;
        m_secondsFactor = MATCH_PERIOD_LENGTHS[n2] * 60 / (m_matchTimerRealMins * 60 / (90 / MATCH_PERIOD_LENGTHS[n2]));
        GameAI.objectResetVelocity(GameAI.m_ballStorage);
        m_matchTimer = 0;
        m_matchTimerCurrentSecond = 0;
        m_interruptTimeLastFramesDifference = 0;
        m_possession = (n2 + 0) % 2;
        for (n4 = 0; n4 < 2; ++n4) {
            short[] sArray = GameAI.m_teamStorage[n4];
            sArray[0] = (short)(sArray[0] & 0xFFFFFFFA);
            short[] sArray2 = GameAI.m_teamStorage[n4];
            sArray2[0] = (short)(sArray2[0] | (short)((m_possession == n4 ? 4 : 0) | (m_possession == n4 ? 0 : 1)));
            for (n3 = 0; n3 < 18; ++n3) {
                GameAI.m_playerStorage[n4][n3][14] = GameAI.teamGetPitchSide(n4) == 0 ? 0 : 128;
            }
        }
        switch (n2) {
            case 0: {
                if (m_gameMode == 1) {
                    GameLogic.setState(1, 11, -1, -1);
                    break;
                }
                GameLogic.setState(1, 11, -1, -1);
                GameLogic.buttonThroughToKickOff();
                for (n4 = 0; n4 < 2; ++n4) {
                    GameLogic.m_controller[n4].m_joystick = 0;
                }
                MainFrame.setMasterState(7);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                GameLogic.setState(1, 1, -1, -1);
                break;
            }
            case 4: {
                if (m_gameMode == 99) {
                    SKIPHINT = true;
                }
                GameLogic.penaltyShootOut_Init();
                break;
            }
            case 6: {
                SKIPHINT = true;
                m_possession = 0;
                for (n4 = 0; n4 < 2; ++n4) {
                    short[] sArray = GameAI.m_teamStorage[n4];
                    sArray[0] = (short)(sArray[0] & 0xFFFFFFFA);
                    short[] sArray3 = GameAI.m_teamStorage[n4];
                    sArray3[0] = (short)(sArray3[0] | (short)((m_possession == n4 ? 4 : 0) | (m_possession == n4 ? 1 : 0)));
                    for (n3 = 0; n3 < 18; ++n3) {
                        GameAI.m_playerStorage[n4][n3][14] = GameAI.teamGetPitchSide(n4) == 0 ? 0 : 128;
                    }
                }
                GameLogic.freeKickChallengeSetupNewFreeKick();
            }
        }
    }

    public static final boolean updateTheGameTimer() {
        if (m_gameMode == 4 || m_gameMode == 2 || m_gameMode == 5 || m_gameMode == 99 || m_gameMode == 1 && m_matchPeriod == 4) {
            return false;
        }
        return m_matchState == 2;
    }

    private static void penaltyShootOut_Init() {
        int n2;
        int n3;
        penaltyGoalScore = 0;
        m_penaltyTakers = new int[2];
        m_penaltiesResults = new boolean[2][5];
        m_penaltesBonus = new boolean[5];
        GameLogic.m_penaltyTakers[0] = 11;
        GameLogic.m_penaltyTakers[1] = 11;
        m_penaltiesCount = 0;
        for (n3 = 0; n3 < 2; ++n3) {
            GameAI.m_teamStorage[n3][15] = 0;
            for (n2 = 0; n2 < 5; ++n2) {
                GameLogic.m_penaltiesResults[n3][n2] = false;
            }
        }
        GameRender.commentarySet(true, 7);
        GameLogic.penaltyShootOutInitNextPenalty();
        GameLogic.resetHumanControlPlayer();
        for (n3 = 0; n3 < 2; ++n3) {
            GameAI.m_playerStorage[n3][0][22] = 128;
            GameAI.m_playerStorage[n3][0][14] = 128;
            for (n2 = 1; n2 < 11; ++n2) {
                GameAI.m_playerStorage[n3][n2][22] = 0;
                GameAI.m_playerStorage[n3][n2][14] = 0;
            }
        }
    }

    private static void penaltyShootOut_Unload() {
        if (!XMLMenuSystem.m_inGameFlag) {
            m_penaltyTakers = null;
            m_penaltiesResults = null;
            m_penaltesBonus = null;
        }
    }

    private static void penaltyShootOutInitNextPenalty() {
        m_possession = m_penaltiesCount & 1;
        m_penaltySavedInShootout = false;
        do {
            int n2 = m_possession;
            m_penaltyTakers[n2] = m_penaltyTakers[n2] - 1;
            if (m_penaltyTakers[m_possession] >= 1) continue;
            GameLogic.m_penaltyTakers[GameLogic.m_possession] = 10;
        } while (GameAI.m_playerStorage[m_possession][m_penaltyTakers[m_possession]][49] == 2);
        GameAI.playerSetState(GameAI.m_playerStorage[0][0], 0, 0, 0);
        GameAI.playerSetState(GameAI.m_playerStorage[1][0], 0, 0, 0);
        GameLogic.setState(8, 54, 8, 12);
        GameFormation.setKickOffPositionsPenalty();
        GameFormation.keeperUpdateLevel1(m_possession ^ 1, GameAI.m_playerStorage[m_possession ^ 1][0]);
        GameAI.teamSetState(0, 5);
        GameAI.teamSetState(1, 5);
        GameLogic.requestSound(1);
    }

    public static void penaltyShootOutUpdateScores(boolean bl) {
        if (bl && stay) {
            GameLogic.m_penaltesBonus[(GameLogic.m_penaltiesCount >> 1) % 5] = bl;
            GameRender.boxSetState(0, 3, 2, 62, 0, 1, 1, true);
            System.out.println("1. penaltyGoalScore--------------->" + penaltyGoalScore);
        }
        GameLogic.m_penaltiesResults[GameLogic.m_penaltiesCount & 1][(GameLogic.m_penaltiesCount >> 1) % 5] = bl;
        m_gameModeResetTimer = 20;
        if (bl) {
            short[] sArray = GameAI.m_teamStorage[m_penaltiesCount & 1];
            sArray[15] = (short)(sArray[15] + 1);
        }
        stay = false;
    }

    private static void penaltyShootOutUpdate() {
        GameRender.fadeSet(false);
        if (GameRender.m_fadeState == 1) {
            ++m_penaltiesCount;
            if (m_gameMode == 99 || m_gameMode == 1 && m_matchPeriod == 4) {
                GameAI.m_teamStorage[0][6] = GameAI.m_teamStorage[0][15];
                GameAI.m_teamStorage[1][6] = GameAI.m_teamStorage[1][15];
            }
            if (m_penaltiesCount >= 10 && (m_penaltiesCount & 1) == 0 && GameAI.m_teamStorage[0][15] != GameAI.m_teamStorage[1][15] || m_penaltiesCount < 10 && (GameAI.m_teamStorage[0][15] > GameAI.m_teamStorage[1][15] + (5 - m_penaltiesCount / 2) || GameAI.m_teamStorage[1][15] > GameAI.m_teamStorage[0][15] + (5 - (m_penaltiesCount + 1) / 2))) {
                GameRender.commentarySet(true, 8);
                GameLogic.setState(15, -1, -1, -1);
                penalty_highscore_state = true;
                GameRender.fadeSet(true);
                return;
            }
            GameAI.m_ballStorage[0] = 12311;
            GameAI.m_ballStorage[1] = 28926;
            GameAI.m_ballStorage[6] = 0;
            GameAI.objectResetVelocity(GameAI.m_ballStorage);
            GameLogic.penaltyShootOutInitNextPenalty();
        } else {
            m_gameModeResetTimer = 1;
        }
    }

    public static void debugPlacePlayerInPathOfBall() {
    }

    private static void debugBallPosition() {
        for (int i2 = 0; i2 < 2; ++i2) {
            for (int i3 = 0; i3 < 11; ++i3) {
                GameAI.m_playerStorage[i2][i3][0] = 0;
                GameAI.m_playerStorage[i2][i3][1] = 0;
                GameAI.m_playerStorage[i2][i3][2] = 0;
            }
            m_controller[i2].setControlPlayer(GameAI.m_playerStorage[i2][0]);
        }
        GameAI.m_playerStorage[0][0][0] = 12311;
        GameAI.m_playerStorage[0][0][1] = 16007;
        GameAI.m_playerStorage[0][0][2] = 0;
        GameAI.m_playerStorage[0][0][60] = m_playerAnim;
        GameAI.m_playerStorage[0][0][59] = m_playerAnimFrame;
        GameAI.m_playerWithBall = null;
        GameAI.objectResetVelocity(GameAI.m_ballStorage);
        GameAI.m_ballStorage[0] = 12311 + m_ballHoffset;
        GameAI.m_ballStorage[1] = 32015 + m_ballVoffset;
        GameAI.m_ballStorage[2] = m_ballZoffset;
        GameAI.ballSetCollision(false);
        if ((MainFrame.m_joystick & 4) != 0) {
            m_ballHoffset -= 16;
        }
        if ((MainFrame.m_joystick & 8) != 0) {
            m_ballHoffset += 16;
        }
        if ((MainFrame.m_joystick & 1) != 0) {
            m_ballVoffset -= 16;
        }
        if ((MainFrame.m_joystick & 2) != 0) {
            m_ballVoffset += 16;
        }
        if ((MainFrame.m_joystick & 0x2000) != 0) {
            m_ballZoffset -= 16;
            m_ballZoffset = DDMath.max(m_ballZoffset, 0);
        }
        if ((MainFrame.m_joystick & 0x800) != 0) {
            m_ballZoffset += 16;
        }
        if (m_downAnimType) {
            m_playerAnim = DDMath.max(m_playerAnim - 1, 0);
            m_playerAnimFrame = 0;
        }
        if (m_upAnimType) {
            m_playerAnim = DDMath.min(m_playerAnim + 1, 96);
            m_playerAnimFrame = 0;
        }
        if (m_downAnimFrame) {
            m_playerAnimFrame = DDMath.max(m_playerAnimFrame - 1, 0);
        }
        if (m_upAnimFrame) {
            // empty if block
        }
        if (m_upDirection) {
            m_upDirection = false;
        }
        m_upAnimType = false;
        m_downAnimType = false;
        m_upAnimFrame = false;
        m_downAnimFrame = false;
    }

    private static void debugBallPositonShootout() {
        for (int i2 = 0; i2 < 2; ++i2) {
            for (int i3 = 0; i3 < 11; ++i3) {
                GameAI.m_playerStorage[i2][i3][0] = 0;
                GameAI.m_playerStorage[i2][i3][1] = 0;
                GameAI.m_playerStorage[i2][i3][2] = 0;
            }
        }
        GameAI.m_playerStorage[0][0][0] = 12311;
        GameAI.m_playerStorage[0][0][1] = 32015;
        GameAI.m_playerStorage[0][0][2] = 0;
        GameAI.m_playerStorage[0][0][60] = m_playerAnim = DDMath.max(m_playerAnim, 60);
        GameAI.m_playerStorage[0][0][59] = m_playerAnimFrame;
        GameAI.m_playerWithBall = null;
        GameAI.objectResetVelocity(GameAI.m_ballStorage);
        GameAI.m_ballStorage[0] = 12311 + m_ballHoffset;
        GameAI.m_ballStorage[1] = 32015;
        GameAI.m_ballStorage[2] = m_ballVoffset;
        GameAI.ballSetCollision(false);
        if ((MainFrame.m_joystick & 4) != 0) {
            m_ballVoffset += 16;
        }
        if ((MainFrame.m_joystick & 8) != 0) {
            m_ballVoffset -= 16;
            m_ballVoffset = DDMath.max(m_ballVoffset, 0);
        }
        if ((MainFrame.m_joystick & 1) != 0) {
            m_ballHoffset -= 16;
        }
        if ((MainFrame.m_joystick & 2) != 0) {
            m_ballHoffset += 16;
        }
        if (m_downAnimType) {
            m_playerAnim = DDMath.max(m_playerAnim - 1, 60);
            m_playerAnimFrame = 0;
        }
        if (m_upAnimType) {
            m_playerAnim = DDMath.min(m_playerAnim + 1, 96);
            m_playerAnimFrame = 0;
        }
        if (m_downAnimFrame) {
            m_playerAnimFrame = DDMath.max(m_playerAnimFrame - 1, 0);
        }
        if (m_upAnimFrame) {
            // empty if block
        }
        if (m_upDirection) {
            m_upDirection = false;
        }
        m_upAnimType = false;
        m_downAnimType = false;
        m_upAnimFrame = false;
        m_downAnimFrame = false;
    }

    private static void debugScenarioUpdate() {
        if (!DDDebug.DEBUG_SCENARIO) {
            return;
        }
        if (!debugScenarioTriggered && m_matchTimer == 999) {
            GameLogic.debugScenarioTrigger();
            debugScenarioTriggered = true;
        }
    }

    private static void debugScenarioTrigger() {
        if (!DDDebug.DEBUG_SCENARIO) {
            return;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < 2; ++i2) {
            for (int i3 = 0; i3 < 11; ++i3) {
                if (debugScenarioData[n2 * 7 + 0] == 1) {
                    int[] nArray = GameAI.m_playerStorage[i2][i3];
                    GameAI.playerSetState(nArray, 0, 0, debugScenarioData[n2 * 7 + 1]);
                    nArray[0] = debugScenarioData[n2 * 7 + 2];
                    nArray[1] = debugScenarioData[n2 * 7 + 3];
                    nArray[2] = debugScenarioData[n2 * 7 + 4];
                    nArray[3] = 0;
                    nArray[4] = 0;
                    nArray[5] = 0;
                }
                ++n2;
            }
        }
        if (debugScenarioData[n2 * 7 + 0] == 1) {
            GameAI.m_ballStorage[0] = debugScenarioData[n2 * 7 + 2];
            GameAI.m_ballStorage[1] = debugScenarioData[n2 * 7 + 3];
            GameAI.m_ballStorage[2] = debugScenarioData[n2 * 7 + 4];
            GameAI.m_ballStorage[3] = 0;
            GameAI.m_ballStorage[4] = 0;
            GameAI.m_ballStorage[5] = 0;
        }
    }

    public static int debugScenarioGetData(int n2, int n3, int n4) {
        int n5 = n3 * 11 + n2;
        return debugScenarioData[n5 * 7 + n4];
    }

    public static int debugScenarioGetData(int[] nArray, int n2) {
        return GameLogic.debugScenarioGetData(nArray[9], nArray[12], n2);
    }

    public static void updateformationPositonsOnly() {
        GameFormation.updateLevel1();
        GameLogic.offsideLineUpdate();
        for (int i2 = 0; i2 < 2; ++i2) {
            for (int i3 = 0; i3 < 11; ++i3) {
                int[] nArray = GameAI.m_playerStorage[i2][i3];
                short[] sArray = GameAI.m_teamStorage[m_possession];
                sArray[0] = (short)(sArray[0] | 4);
                short[] sArray2 = GameAI.m_teamStorage[m_possession ^ 1];
                sArray2[0] = (short)(sArray2[0] & 0xFFFFFFFB);
                nArray[28] = 71;
                nArray[17] = 66;
                nArray[23] = 360;
                int n2 = GameAI.m_ballStorage[0] - nArray[0];
                int n3 = GameAI.m_ballStorage[1] - nArray[1];
                nArray[35] = DDMath.atan(n2, n3) & 0xFF;
                nArray[36] = DDMath.sqrtRout(n2 * n2 + n3 * n3 >> 16);
                GameAI.playerUpdateDirection(nArray);
                GameAI.playerUpdateVelocity(nArray);
                GameAI.playerUpdatePosition(nArray);
            }
        }
    }

    public static boolean humanPlayerHasBall() {
        return GameLogic.m_controller[GameLogic.m_possession].m_controlPlayer != null && GameAI.teamGetControlType(m_possession) == 2;
    }

    public static void resetHumanControlPlayer() {
        for (int i2 = 0; i2 < 2; ++i2) {
            m_controller[i2].setControlPlayer(null);
        }
    }

    public static void calculateNearFarGoalPostPositions(int n2) {
        m_nearGoalPostX = 12311 + (GameAI.m_ballStorage[0] > 12311 ? m_goalWidth / 2 : -m_goalWidth / 2);
        m_farGoalPostX = 12311 + (GameAI.m_ballStorage[0] > 12311 ? -m_goalWidth / 2 : m_goalWidth / 2);
        m_nearGoalPostY = n2 == 0 ? 0 : 32015;
        m_farGoalPostY = n2 == 0 ? 0 : 32015;
    }

    public static final int flipCoordinatePitchSide(int n2) {
        return 32015 - n2;
    }

    public static int getSetPiecePassFlags() {
        int n2 = 0;
        switch (m_trajectoryType) {
            case 3: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 4;
                break;
            }
            case 0: {
                n2 = 4;
                break;
            }
            case 1: {
                n2 = 4;
            }
        }
        return n2;
    }

    public static int getPlayerTeam() {
        return m_teamUnderControl;
    }

    public static int getOpponentTeam() {
        return m_teamUnderControl ^ 1;
    }

    public static void setTeamUnderControl(int n2) {
        m_teamUnderControl = n2;
    }

    public static boolean isSetPiecePassTargetAShortPass(int[] nArray) {
        int[] nArray2 = GameAI.m_ballStorage;
        int n2 = DDMath.calcHorizontalDist(nArray2, nArray);
        return n2 < 4250;
    }

    public static void Object_AddToCollisionList(int[] nArray, int n2) {
        byte by = (byte)n2;
        int n3 = nArray[1] + nArray[7] >> 11;
        n3 = DDMath.max(n3, 0);
        n3 = DDMath.min(n3, 19);
        int n4 = nArray[1] - nArray[7] >> 11;
        n4 = DDMath.max(n4, 0);
        n4 = DDMath.min(n4, 19);
        int n5 = nArray[0] - nArray[7] >> 11;
        n5 = DDMath.max(n5, 0);
        n5 = DDMath.min(n5, 11);
        int n6 = nArray[0] + nArray[7] >> 11;
        n6 = DDMath.max(n6, 0);
        n6 = DDMath.min(n6, 11);
        int n7 = nArray[0] >> 11;
        n7 = DDMath.max(n7, 0);
        n7 = DDMath.min(n7, 11);
        int n8 = nArray[1] >> 11;
        n8 = DDMath.max(n8, 0);
        if ((n8 = DDMath.min(n8, 19)) != n3 && collisionList[n7][n3][0] < 9) {
            byte[] byArray = collisionList[n7][n3];
            byte by2 = byArray[0];
            byArray[0] = (byte)(by2 + 1);
            GameLogic.collisionList[n7][n3][by2 + 1] = by;
        }
        if (n8 != n4 && collisionList[n7][n4][0] < 9) {
            byte[] byArray = collisionList[n7][n4];
            byte by3 = byArray[0];
            byArray[0] = (byte)(by3 + 1);
            GameLogic.collisionList[n7][n4][by3 + 1] = by;
        }
        if (n7 != n5 && collisionList[n5][n8][0] < 9) {
            byte[] byArray = collisionList[n5][n8];
            byte by4 = byArray[0];
            byArray[0] = (byte)(by4 + 1);
            GameLogic.collisionList[n5][n8][by4 + 1] = by;
        }
        if (n7 != n6 && collisionList[n6][n8][0] < 9) {
            byte[] byArray = collisionList[n6][n8];
            byte by5 = byArray[0];
            byArray[0] = (byte)(by5 + 1);
            GameLogic.collisionList[n6][n8][by5 + 1] = by;
        }
        if (n8 != n3 && n7 != n5 && collisionList[n5][n3][0] < 9) {
            byte[] byArray = collisionList[n5][n3];
            byte by6 = byArray[0];
            byArray[0] = (byte)(by6 + 1);
            GameLogic.collisionList[n5][n3][by6 + 1] = by;
        }
        if (n8 != n4 && n7 != n5 && collisionList[n5][n4][0] < 9) {
            byte[] byArray = collisionList[n5][n4];
            byte by7 = byArray[0];
            byArray[0] = (byte)(by7 + 1);
            GameLogic.collisionList[n5][n4][by7 + 1] = by;
        }
        if (n8 != n3 && n7 != n6 && collisionList[n6][n3][0] < 9) {
            byte[] byArray = collisionList[n6][n3];
            byte by8 = byArray[0];
            byArray[0] = (byte)(by8 + 1);
            GameLogic.collisionList[n6][n3][by8 + 1] = by;
        }
        if (n8 != n4 && n7 != n6 && collisionList[n6][n4][0] < 9) {
            byte[] byArray = collisionList[n6][n4];
            byte by9 = byArray[0];
            byArray[0] = (byte)(by9 + 1);
            GameLogic.collisionList[n6][n4][by9 + 1] = by;
        }
        if (collisionList[n7][n8][0] < 9) {
            byte[] byArray = collisionList[n7][n8];
            byte by10 = byArray[0];
            byArray[0] = (byte)(by10 + 1);
            GameLogic.collisionList[n7][n8][by10 + 1] = by;
        }
    }

    public static void Object_checkCollisions() {
        for (int i2 = 0; i2 < 13; ++i2) {
            for (int i3 = 0; i3 < 21; ++i3) {
                int n2 = collisionList[i2][i3][0];
                GameLogic.collisionList[i2][i3][0] = 0;
                if (n2 <= 1) continue;
                for (int i4 = 1; i4 < n2; ++i4) {
                    for (int i5 = i4 + 1; i5 <= n2; ++i5) {
                        int n3;
                        int n4;
                        boolean bl;
                        int n5;
                        int[] nArray;
                        byte by = collisionList[i2][i3][i4];
                        byte by2 = collisionList[i2][i3][i5];
                        if (by < 30 && by2 < 30) {
                            nArray = GameAI.m_playerStorage[by & 1][by >> 1];
                            int[] nArray2 = GameAI.m_playerStorage[by2 & 1][by2 >> 1];
                            if (!GameLogic.Object_checkCicularCollision(nArray, nArray2)) continue;
                            GameLogic.Object_CollisionResponse(nArray, nArray2);
                            if ((by & 1) != (by2 & 1)) {
                                if (nArray[28] == 145) {
                                    nArray[15] = nArray[0];
                                    nArray[16] = nArray[1];
                                } else if (nArray2[28] == 145) {
                                    nArray2[15] = nArray2[0];
                                    nArray2[16] = nArray2[1];
                                }
                                if ((nArray[28] == 9 || nArray2[28] == 9) && nArray[23] != 0 && nArray2[23] != 0 && nArray[28] != 91 && nArray[28] != 14 && nArray[28] != 138 && nArray[28] != 139 && nArray2[28] != 14 && nArray2[28] != 91 && nArray2[28] != 138 && nArray2[28] != 139 && (n5 = DDMath.CalcModDifference(nArray[22], nArray2[22])) < 96) {
                                    nArray[6] = nArray[6] | 0x2000;
                                    nArray2[6] = nArray2[6] | 0x2000;
                                    nArray[54] = by2 >> 1;
                                    nArray2[54] = by >> 1;
                                }
                            }
                            if ((nArray2[28] == 91 || nArray2[28] == 59) && (nArray2[6] & 0x2000000) == 0 && GameAI.m_targetPlayer != null && nArray == GameAI.m_targetPlayer) {
                                nArray2[6] = nArray2[6] | 0x2000000;
                            } else if ((nArray[28] == 91 || nArray[28] == 59) && (nArray[6] & 0x2000000) == 0 && GameAI.m_targetPlayer != null && nArray2 == GameAI.m_targetPlayer) {
                                nArray[6] = nArray[6] | 0x2000000;
                            }
                            if (nArray[28] == 9) {
                                if (nArray2[28] != 91) continue;
                                nArray2[6] = nArray2[6] | 0x400;
                                continue;
                            }
                            if (nArray2[28] != 9) continue;
                            nArray2[23] = nArray2[23] - 6;
                            nArray2[23] = DDMath.max(nArray2[23], 96);
                            if (nArray[28] == 91) {
                                nArray[6] = nArray[6] | 0x400;
                                continue;
                            }
                            nArray[6] = nArray[6] | 0x800;
                            continue;
                        }
                        if (by != 30 && by2 != 30) continue;
                        int[] nArray3 = nArray = by == 30 ? GameAI.m_playerStorage[by2 & 1][by2 >> 1] : GameAI.m_playerStorage[by & 1][by >> 1];
                        if ((nArray[6] & 0x40) != 0) {
                            if (GameAI.diveAtFeetDribbler == null || GameAI.diveAtFeetDribbler != nArray) continue;
                            GameAI.diveAtFeetDribbler = null;
                        }
                        boolean bl2 = bl = nArray[48] == 0 && Trajectory.isObjectUnderTrajectoryControl(nArray);
                        if (bl || !GameLogic.Object_checkCicularCollision(GameAI.m_ballStorage, nArray)) continue;
                        if ((nArray[28] == 91 || nArray[28] == 59) && (nArray[6] & 0x1000000) == 0 && (nArray[6] & 0x2000000) == 0) {
                            nArray[6] = nArray[6] | 0x1000000;
                        }
                        if (nArray == GameAI.m_playerWithBall) {
                            nArray[6] = nArray[6] | 0x20;
                            continue;
                        }
                        if (GameAI.ballIsInAShot() && GameFormation.getPlayerType(nArray[52]) != 0 && !GameAI.ballIsDeflectedEnoughToCountAsAShotCollision(nArray)) {
                            return;
                        }
                        GameLogic.Object_CollisionResponse(GameAI.m_ballStorage, nArray);
                        boolean bl3 = false;
                        if (nArray[9] != 0 && nArray[28] != 34 && nArray != GameAI.ballGetLastTouchPlayer() && (nArray != GameAI.m_playerRunningOntoBall || GameAI.m_runOntoBallAction == 5) && (n4 = (n3 = GameAI.m_ballStorage[3]) * n3 + (n5 = GameAI.m_ballStorage[4]) * n5) > BALL_PLAYER_REBOUND_THRESHOLD_HIGH_SQUARED && nArray[28] != 10) {
                            bl3 = true;
                        }
                        if (bl3) {
                            GameAI.ballSetLastTouchPlayer(nArray);
                            GameAI.ballSetToFreeBall();
                            GameLogic.ballCylindricalCollisionReaction(nArray[0], nArray[1], GameAI.m_ballStorage[0], GameAI.m_ballStorage[1], 192);
                            if (GameAI.m_ballStorage[2] > 243 && GameAI.m_ballStorage[2] < 486) {
                                GameAI.m_ballStorage[3] = GameAI.m_ballStorage[3] >> 1;
                                GameAI.m_ballStorage[4] = GameAI.m_ballStorage[4] >> 1;
                                GameAI.m_ballStorage[5] = DDMath.abs(GameAI.m_ballStorage[5] >> 1);
                                continue;
                            }
                            if (GameAI.m_ballStorage[2] >= 243) continue;
                            GameAI.m_ballStorage[3] = GameAI.m_ballStorage[3] >> 2;
                            GameAI.m_ballStorage[4] = GameAI.m_ballStorage[4] >> 2;
                            GameAI.m_ballStorage[5] = DDMath.abs(GameAI.m_ballStorage[5] >> 1);
                            continue;
                        }
                        if (!(m_matchState == 2 || m_matchState == 17 && nArray[9] == 0 || m_matchState == 9 && nArray[28] == 141 || m_matchState == 9 && nArray[28] == 142 || m_matchState == 6 && nArray[28] == 18) && (m_matchState != 8 || nArray[28] != 63)) continue;
                        nArray[6] = nArray[6] | 0x20;
                    }
                }
            }
        }
    }

    public static void Object_CollisionResponse(int[] nArray, int[] nArray2) {
        int n2;
        int n3;
        int n4 = nArray[0] - nArray2[0];
        int n5 = nArray[1] - nArray2[1];
        int n6 = DDMath.sqrtRout(n4 * n4 + n5 * n5);
        n6 = nArray[7] + nArray2[7] - n6;
        if ((nArray[6] & 1) != 0 || nArray2 == GameAI.m_ballStorage) {
            n3 = 0;
            n2 = n6;
        } else if ((nArray2[6] & 1) != 0 || nArray == GameAI.m_ballStorage) {
            n3 = n6;
            n2 = 0;
        } else {
            n3 = n6 >> 1;
            n2 = n6 >> 1;
        }
        int n7 = DDMath.atan(n4, n5);
        if (n3 == 0 && n2 == 0) {
            n3 = 2;
        }
        nArray2[0] = nArray2[0] - (DDMath.sin(n7) * n2 >> 16);
        nArray2[1] = nArray2[1] - (DDMath.cos(n7) * n2 >> 16);
        nArray[0] = nArray[0] + (DDMath.sin(n7) * n3 >> 16);
        nArray[1] = nArray[1] + (DDMath.cos(n7) * n3 >> 16);
    }

    private static boolean Object_checkCicularCollision(int[] nArray, int[] nArray2) {
        int n2 = nArray[0] - nArray2[0];
        n2 *= n2;
        int n3 = nArray[1] - nArray2[1];
        n3 *= n3;
        int n4 = nArray[7] + nArray2[7];
        if (n2 + n3 <= (n4 *= n4)) {
            int n5 = nArray[2];
            int n6 = nArray[8];
            int n7 = nArray2[2];
            int n8 = nArray2[8];
            if (n5 <= n7 && n5 + n6 >= n7 || n7 <= n5 && n7 + n8 >= n5) {
                return true;
            }
        }
        return false;
    }

    private static void buttonThroughToKickOff() {
        XMLMenuSystem.setSoftKeys(9, 9);
        GameAI.teamSetState(0, 1);
        GameAI.teamSetState(1, 1);
        GameFormation.exclusionFromArea(12311, 16007, 3353);
        for (int i2 = 0; i2 < 2; ++i2) {
            for (int i3 = 0; i3 < 11; ++i3) {
                int[] nArray = GameAI.m_playerStorage[i2][i3];
                nArray[0] = nArray[25];
                nArray[1] = nArray[26];
            }
        }
        GameFormation.kickOffByPass();
        GameRender.boxClose();
        GameLogic.setState(1, 3, -1, -1);
    }

    public static void managerTipCheckandShowForAttackingFreeKick() {
        if (XMLMenuSystem.m_globalArray[105] == 0 && GameLogic.getPlayerTeam() == m_possession && XMLMenuSystem.m_menuMatchType != 4) {
            GameRender.tutorialDrawSnazzyInfo(1011, 1);
            XMLMenuSystem.m_globalArray[105] = 1;
        }
    }

    public static void managerTipCheckandShowForNormalFreeKick() {
        if (XMLMenuSystem.m_globalArray[107] == 0 && GameLogic.getPlayerTeam() == m_possession && XMLMenuSystem.m_menuMatchType != 4) {
            GameRender.tutorialDrawSnazzyInfo(1014, 0);
            XMLMenuSystem.m_globalArray[107] = 1;
        }
    }

    public static void managerTipCheckandShowForCorner() {
        if (XMLMenuSystem.m_globalArray[106] == 0 && GameLogic.getPlayerTeam() == m_possession && XMLMenuSystem.m_menuMatchType != 4) {
            GameRender.tutorialDrawSnazzyInfo(1013, 0);
            XMLMenuSystem.m_globalArray[106] = 1;
        }
    }

    public static void managerTipCheckandShowForPenalty() {
        if (m_gameMode == 99 || m_gameMode == 1 && m_matchPeriod == 4) {
            if (XMLMenuSystem.m_globalArray[100] >= 0 && GameLogic.getPlayerTeam() == m_possession) {
                GameRender.tutorialDrawSnazzyInfo(1011, 0);
                XMLMenuSystem.m_globalArray[100] = 1;
            } else if (XMLMenuSystem.m_globalArray[108] >= 0 && GameLogic.getPlayerTeam() != m_possession) {
                GameRender.tutorialDrawSnazzyInfo(1049, 0);
                XMLMenuSystem.m_globalArray[108] = 1;
            }
        } else if (XMLMenuSystem.m_globalArray[102] == 0 && GameLogic.getPlayerTeam() == m_possession) {
            GameRender.tutorialDrawSnazzyInfo(1011, 0);
            XMLMenuSystem.m_globalArray[102] = 1;
        } else if (XMLMenuSystem.m_globalArray[108] == 0 && GameLogic.getPlayerTeam() != m_possession) {
            GameRender.tutorialDrawSnazzyInfo(1049, 0);
            XMLMenuSystem.m_globalArray[108] = 1;
        }
    }

    public static void managerTipCheckandShowForThrowIn() {
    }

    private static void refereeInit() {
        m_refereeJumpPlayersToFreeKickPositionsAfterBooking = false;
        GameLogic.refereeSetDecision(0);
    }

    public static void refereeUpdateOffsidePlayerFlags(boolean bl) {
        int n2 = GameAI.m_ballStorage[10];
        int n3 = n2 & 1;
        for (int i2 = 0; i2 < 2; ++i2) {
            boolean bl2 = false;
            if (i2 != n3) {
                bl2 = true;
            }
            for (int i3 = 1; i3 < 11; ++i3) {
                GameAI.m_playerStorage[i2][i3][37] = bl || bl2 ? 0 : ((GameAI.teamGetPitchSide(i2) == 1 && GameAI.m_playerStorage[i2][i3][1] < m_offsideline[i2 ^ 1] || GameAI.teamGetPitchSide(i2) == 0 && GameAI.m_playerStorage[i2][i3][1] > m_offsideline[i2 ^ 1]) && !GameLogic.isObjectInOwnHalf(i2, GameAI.m_playerStorage[i2][i3]) && i3 != n2 ? 1 : 0);
            }
        }
    }

    public static void refereeCheckOffside(int[] nArray) {
        if (m_matchState == 2 && m_refereeDecision == 0 && m_gameMode != 2 && GameAI.ballGetLastTouchPlayerID() != 0 && nArray[9] != GameAI.ballGetLastTouchPlayerID() && nArray[37] == 1) {
            if (GameAI.teamGetPitchSide(nArray[12] ^ 1) == 1 ? nArray[1] < 12311 : nArray[1] > 12311) {
                return;
            }
            m_offsideLinePosition = m_offsideline[nArray[12] ^ 1];
            m_foulxpos = nArray[0];
            m_foulypos = nArray[1];
            m_fouledPlayersTeam = nArray[12] ^ 1;
            m_fouledPlayer = null;
            m_foulingPlayer = nArray;
            GameLogic.refereeSetDecision(6);
        }
    }

    public static void refereeCheckTackle(int[] nArray, int n2, int[] nArray2) {
        long l2;
        int n3 = GameLogic.m_controller[n2].m_microGame.getResult();
        int n4 = 0;
        int n5 = DDMath.calcHorizontalDistSquared(nArray, nArray2);
        if (n5 > 200000) {
            return;
        }
        if (m_matchState != 2) {
            return;
        }
        if (m_refereeDecision == 0) {
            int n6;
            if (GameLogic.m_controller[n2].m_microGameTackle && (GameAI.teamGetControlType(n2) == 2 && n3 == 1 && !m_refereeNextHumanSlideTackleIsOK || GameAI.teamGetControlType(n2) == 0 && (GameLogic.m_controller[n2].m_aiTackleResult == 1 || GameLogic.m_controller[n2].m_aiTackleResult == 1))) {
                m_foulxpos = nArray[0];
                m_foulypos = nArray[1];
                m_fouledPlayersTeam = n2 ^ 1;
                m_foulingPlayer = nArray;
                m_fouledPlayer = nArray2;
                int n7 = DDMath.abs(DDMath.getRandom() % 100);
                if (n7 < 20 + (XMLMenuSystem.m_matchDifficulty - 1) * 10 && (XMLMenuSystem.m_menuMatchType != 1 || XMLMenuSystem.m_menuSeasonType != 2 || m_foulingPlayer[11] != XMLMenuSystem.m_beAProPlayerIndex)) {
                    n4 = 0;
                    for (n6 = 0; n6 < 11; ++n6) {
                        if (GameAI.m_playerStorage[n2][n6][58] <= 0) continue;
                        ++n4;
                    }
                    if (n4 <= 3) {
                        GameLogic.refereeSetDecision(4);
                    } else {
                        GameLogic.refereeSetDecision(3);
                    }
                } else {
                    GameLogic.refereeSetDecision(3);
                }
            } else if (!GameLogic.m_controller[n2].m_microGameTackle || GameAI.teamGetControlType(n2) == 2 && n3 == 3 || GameAI.teamGetControlType(n2) == 0 && (GameLogic.m_controller[n2].m_aiTackleResult == 1 || GameLogic.m_controller[n2].m_aiTackleResult == 3)) {
                int n8;
                n6 = 1;
                int n9 = DDMath.calcHorizontalDistSquared(GameAI.m_ballStorage, nArray2);
                if (n9 > 100000) {
                    n6 = 0;
                } else {
                    n8 = DDMath.abs(DDMath.getRandom() % 100);
                    if (n8 > 30) {
                        n6 = 0;
                    }
                }
                if (n6 != 0 && GameAI.teamGetControlType(n2) == 2 && n3 == 3 || GameAI.teamGetControlType(n2) == 0 && GameLogic.m_controller[n2].m_aiTackleResult == 3) {
                    n8 = (int)(3840.0 / (double)MainFrame.m_inGameFrameRate);
                    m_possession = n2;
                    GameAI.m_ballStorage[3] = DDMath.sin(nArray[22]) * n8 >> 16;
                    GameAI.m_ballStorage[4] = DDMath.cos(nArray[22]) * n8 >> 16;
                    GameAI.playerSetState(nArray, 0, 0, 60);
                    nArray[29] = 0;
                    GameAI.playerSetState(nArray2, 0, 0, 60);
                    nArray2[29] = 0;
                    GameAI.ballSetToFreeBall();
                    return;
                }
                if (GameLogic.m_controller[n2].m_microGameTackle && DDMath.abs(GameLogic.m_controller[n2].m_microGame.getDistToGreenZone()) <= 5 || GameAI.ballIsCloseEnoughToPlayerForAssumedCollision(nArray)) {
                    if (!GameLogic.m_controller[n2].m_microGameTackle && m_gameMode == 2) {
                        XMLMenuSystem.m_tutorialComplete[3] = true;
                        XMLMenuSystem.m_tutorialTimer = 3 * MainFrame.m_inGameFrameRate;
                    } else if (m_gameMode == 2) {
                        XMLMenuSystem.m_tutorialComplete[2] = true;
                    }
                    m_foulxpos = nArray[0];
                    m_foulypos = nArray[1];
                    m_fouledPlayersTeam = n2 ^ 1;
                    m_foulingPlayer = nArray;
                    m_fouledPlayer = nArray2;
                    GameLogic.refereeSetDecision(3);
                }
                int n10 = nArray[0] + (DDMath.sin(nArray[22]) * 256 >> 16) - nArray2[0];
                int n11 = nArray[1] + (DDMath.cos(nArray[22]) * 256 >> 16) - nArray2[1];
                int n12 = DDMath.atan(n10, n11);
                int n13 = DDMath.CalcModDifference(nArray2[22], n12);
                if (GameAI.teamGetControlType(n2) == 0 && (nArray[6] & 0x400) != 0) {
                    n13 += 23;
                }
                if (n13 > 71) {
                    m_foulxpos = nArray[0];
                    m_foulypos = nArray[1];
                    m_foulingPlayer = nArray;
                    m_fouledPlayer = nArray2;
                    m_fouledPlayersTeam = nArray2[12];
                    int n14 = DDMath.abs(DDMath.getRandom() % 100);
                    if (n14 < 20 + (XMLMenuSystem.m_matchDifficulty - 1) * 10 && (XMLMenuSystem.m_menuMatchType != 1 || XMLMenuSystem.m_menuSeasonType != 2 || m_foulingPlayer[11] != XMLMenuSystem.m_beAProPlayerIndex)) {
                        n4 = 0;
                        for (int i2 = 0; i2 < 11; ++i2) {
                            if (GameAI.m_playerStorage[n2][i2][58] <= 0) continue;
                            ++n4;
                        }
                        if (n4 <= 3) {
                            GameLogic.refereeSetDecision(4);
                        } else {
                            GameLogic.refereeSetDecision(3);
                        }
                    } else {
                        GameLogic.refereeSetDecision(3);
                    }
                } else if (nArray2[36] > 1) {
                    m_foulxpos = nArray[0];
                    m_foulypos = nArray[1];
                    m_fouledPlayersTeam = n2 ^ 1;
                    m_foulingPlayer = nArray;
                    m_fouledPlayer = nArray2;
                    GameLogic.refereeSetDecision(3);
                } else {
                    if (!GameLogic.m_controller[n2].m_microGameTackle && m_gameMode == 2) {
                        XMLMenuSystem.m_tutorialComplete[3] = true;
                        XMLMenuSystem.m_tutorialTimer = 3 * MainFrame.m_inGameFrameRate;
                    } else if (m_gameMode == 2) {
                        XMLMenuSystem.m_tutorialComplete[2] = true;
                    }
                    GameLogic.refereeSetDecision(1);
                }
            } else {
                if (GameLogic.m_controller[n2].m_microGameTackle && GameLogic.getPlayerTeam() == n2) {
                    XMLMenuSystem.m_tutorialComplete[2] = true;
                }
                GameLogic.refereeSetDecision(1);
            }
        }
        if (m_refereeDecision == 1 && m_gameMode == 2 && XMLMenuSystem.m_currTutorial == 1 && !XMLMenuSystem.m_tutorialComplete[2 + XMLMenuSystem.m_currSubTutorial]) {
            XMLMenuSystem.tutorialReset();
        }
        if (m_refereeDecision == 1) {
            if (GameLogic.checkIfTackleWon(nArray, nArray2)) {
                short[] sArray = GameAI.m_teamStorage[n2];
                sArray[17] = (short)(sArray[17] + 1);
            }
            GameLogic.checkIfTackleLost(nArray2);
            GameLogic.beAProCheckIfBAPStatAchieved(5, nArray, nArray2);
            GameLogic.beAProCheckIfBAPStatAchieved(12, nArray2, nArray);
        }
        if ((m_refereeDecision == 3 || m_refereeDecision == 4) && (l2 = System.currentTimeMillis()) - bapStatTimeDelay > 2000L) {
            bapStatTimeDelay = l2;
            nArray[68] = nArray[68] + 1;
            GameLogic.beAProCheckIfBAPStatAchieved(8, nArray, null);
            MainFrame.vibratePlay(200);
            if (m_refereeDecision == 4) {
                nArray[69] = nArray[69] + 1;
                if (nArray[69] == 1) {
                    GameLogic.beAProCheckIfBAPStatAchieved(9, nArray, null);
                } else {
                    GameLogic.beAProCheckIfBAPStatAchieved(10, nArray, null);
                }
            }
        }
        GameLogic.m_controller[n2].m_microGameTackle = false;
        m_refereeNextHumanSlideTackleIsOK = false;
    }

    public static void refereeSetDecision(int n2) {
        m_foulxpos = DDMath.min(m_foulxpos, 24366);
        m_foulypos = DDMath.min(m_foulypos, 31759);
        m_foulxpos = DDMath.max(m_foulxpos, 256);
        m_foulypos = DDMath.max(m_foulypos, 256);
        if (n2 != 3 && n2 != 4 && n2 != 5 || n2 == m_refereeDecision || m_fouledPlayer[12] != GameLogic.getOpponentTeam() || m_matchState == 2) {
            // empty if block
        }
        if ((m_refereeDecision = n2) == 6) {
            m_refereeTimer = DDMath.getPositiveRandom() % REFEREE_MAX_TIMER;
            m_refereeTimer = DDMath.max(m_refereeTimer, REFEREE_MIN_TIMER);
        } else {
            m_refereeTimer = REFEREE_STANDARD_TIMER;
        }
        m_refereeTimer = DDMath.max(m_refereeTimer, REFEREE_MIN_TIMER);
        if (m_refereeDecision == 4 || m_refereeDecision == 5 || m_refereeDecision == 6) {
            m_refereeJumpPlayersToFreeKickPositionsAfterBooking = true;
        }
        if (m_refereeDecision == 4) {
            XMLMenuSystem.givePlayerYellowCard(m_foulingPlayer);
        }
    }

    private static void refereeUpdate() {
        if (m_refereeDecision == 0 || m_refereeTimer <= 0) {
            if (m_refereeDecision != 0) {
                GameLogic.refereeSetDecision(0);
            }
            return;
        }
        m_offsideLinePosition = m_refereeDecision == 6 ? (GameAI.teamGetPitchSide(m_fouledPlayersTeam) == 0 ? 32015 - m_offsideline[m_fouledPlayersTeam] : m_offsideline[m_fouledPlayersTeam]) : (GameAI.teamGetPitchSide(m_possession) == 0 ? m_offsideline[m_possession ^ 1] : 32015 - m_offsideline[m_possession ^ 1]);
        if (--m_refereeTimer == 0) {
            switch (m_refereeDecision) {
                case 2: {
                    break;
                }
                case 6: {
                    if (m_gameMode != 2 && GameLogic.quickPlayMomentIsQuickFreekickAvailable()) {
                        GameLogic.quickPlayEnableQuickPlayMoment();
                        m_quickPlayMomentTeam = m_possession ^ 1;
                    }
                    GameLogic.setState(3, -1, 1, 32);
                    GameLogic.resetHumanControlPlayer();
                    if (m_quickPlayMomentAvailable) break;
                    GameAI.teamSetState(0, 0);
                    GameAI.teamSetState(1, 0);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    if (m_gameMode != 2 && GameLogic.quickPlayMomentIsQuickFreekickAvailable()) {
                        GameLogic.quickPlayEnableQuickPlayMoment();
                        m_quickPlayMomentTeam = m_possession;
                    }
                    GameLogic.setState(3, -1, 1, 31);
                    GameLogic.requestSound(1);
                    GameLogic.resetHumanControlPlayer();
                    if (m_quickPlayMomentAvailable) break;
                    GameAI.teamSetState(0, 0);
                    GameAI.teamSetState(1, 0);
                }
            }
        }
    }

    public static void setFouled(int n2, boolean bl) {
        int n3 = m_foulxpos;
        int n4 = m_foulypos;
        if (GameAI.teamGetPitchSide(m_fouledPlayersTeam) == 0) {
            n4 = 32015 - n4;
        }
        m_possession = m_fouledPlayersTeam ^ 1;
        if (n2 == 6) {
            short[] sArray = GameAI.m_teamStorage[m_fouledPlayersTeam ^ 1];
            sArray[13] = (short)(sArray[13] + 1);
        } else {
            short[] sArray = GameAI.m_teamStorage[m_fouledPlayersTeam ^ 1];
            sArray[10] = (short)(sArray[10] + 1);
        }
        if (n4 <= 4633 && n3 >= 6641 && n3 <= 17981) {
            GameLogic.setState(3, -1, 8, 12);
        } else {
            if (m_fouledPlayer != null && m_fouledPlayer[28] == 81) {
                GameRender.commentarySet(true, 5);
            }
            GameLogic.setState(3, -1, 9, 25);
        }
    }

    public static void setupFrameRate(int n2, boolean bl) {
        if (XMLMenuSystem.m_menuMatchType == 4) {
            n2 = 12;
        }
        SDKConfig.setMaxFPS(n2);
        MainFrame.m_inGameFrameRate = n2;
        MainFrame.m_bluetoothWaitNumFrames = 3 * n2;
        AI_DRIBBLE_WITH_BALL_MAX_TIME_OFFENSIVE = 563 * MainFrame.m_inGameFrameRate >> 8;
        AI_DRIBBLE_WITH_BALL_MIN_TIME_OFFENSIVE = 64 * MainFrame.m_inGameFrameRate >> 8;
        AI_DRIBBLE_WITH_BALL_MAX_TIME_DEFENSIVE = 128 * MainFrame.m_inGameFrameRate >> 8;
        AI_DRIBBLE_WITH_BALL_MIN_TIME_DEFENSIVE = 64 * MainFrame.m_inGameFrameRate >> 8;
        AI_DRIBBLE_WITH_BALL_MAX_TIME_DEFAULT = 256 * MainFrame.m_inGameFrameRate >> 8;
        AI_DRIBBLE_WITH_BALL_MIN_TIME_DEFAULT = 64 * MainFrame.m_inGameFrameRate >> 8;
        MIN_AI_AVOID_DEFENDER_TIME = MainFrame.m_inGameFrameRate / 2;
        MIN_AI_RUN_TIME = MainFrame.m_inGameFrameRate * 1;
        MIN_AI_SPRINT_TIME = m_difficultySettingAIPlayerSprintWithBallTimeMin * MainFrame.m_inGameFrameRate >> 8;
        MAX_AI_SPRINT_TIME = m_difficultySettingAIPlayerSprintWithBallTimeMax * MainFrame.m_inGameFrameRate >> 8;
        MIN_STOP_BALL_TIME_BEFORE_NEXT_MOVE = MainFrame.m_inGameFrameRate * 2;
        AI_GRAPPLE_WITH_BALL_MIN_TIME_DEFAULT = MainFrame.m_inGameFrameRate * 2;
        RUN_ONTO_BALL_TIMEOUT = MainFrame.m_inGameFrameRate * 2;
        ABSOLUTE_SPEED_RUN_ONTO_PITCH = 1792 / MainFrame.m_inGameFrameRate;
        PLAYER_KICK_BALL_FORWARDS_BALL_SPEED = 4608 / MainFrame.m_inGameFrameRate;
        THROUGHBALL_MAX_UNAVAILABLE_DURATION = MainFrame.m_inGameFrameRate;
        m_moveOutOfTunnelTime = 70 * n2 / 24;
        m_prematchLineupTimerFrames = 48 * n2 / 24;
        GameRender.m_hudTextOverlayGoalStateAnimNumFrames = 8 * n2 / 24;
        GameRender.m_hudTextOverlayGoalStatePauseNumFrames = 48 * n2 / 24;
        GameRender.m_hudTextOverlayGoalStateOffscreenNumFrames = 144 * n2 / 24;
        GOAL_KICK_MAX_DELAY = MainFrame.m_inGameFrameRate * 10;
        REFEREE_STANDARD_TIMER = n2;
        REFEREE_MIN_TIMER = REFEREE_STANDARD_TIMER / 6;
        REFEREE_MAX_TIMER = REFEREE_STANDARD_TIMER;
        KEEPER_PARRY_ULTRA_HORIZONTAL_VELOCITY_X = 4864 / MainFrame.m_inGameFrameRate;
        KEEPER_PARRY_ULTRA_HORIZONTAL_VELOCITY_Y = 2560 / MainFrame.m_inGameFrameRate;
        KEEPER_PARRY_HORIZONTAL_VELOCITY = 2688 / MainFrame.m_inGameFrameRate;
        KEEPER_PARRY_VERTICAL_VELOCITY = 1024 / MainFrame.m_inGameFrameRate;
        KEEPER_PARRY_ULTRA_VERTICAL_VELOCITY = 3072 / MainFrame.m_inGameFrameRate;
        KEEPER_PARRY_BACK_INTO_PLAY_SPEED = 1792 / MainFrame.m_inGameFrameRate;
        MAX_PARRY_VERICAL_SPEED = 1536 / MainFrame.m_inGameFrameRate;
        LOOSE_BALL_PREDICTION_FRAMES = MainFrame.m_inGameFrameRate * 5 / 2;
        AERIAL_PASS_AVERAGE_SPEED_SHORT = 5632 / MainFrame.m_inGameFrameRate;
        AERIAL_PASS_AVERAGE_SPEED_MEDIUM = 7168 / MainFrame.m_inGameFrameRate;
        AERIAL_PASS_AVERAGE_SPEED_LONG = 8704 / MainFrame.m_inGameFrameRate;
        THROW_IN_AVERAGE_SPEED = 6400 / MainFrame.m_inGameFrameRate;
        PASS_INTO_SPACE_MAX_RUN_DIST = 9216 / MainFrame.m_inGameFrameRate;
        GROUND_PASS_AVERAGE_SPEED = 13056 / MainFrame.m_inGameFrameRate;
        GROUND_PASS_FINAL_SPEED = 5120 / MainFrame.m_inGameFrameRate;
        GROUND_PASS_AVERAGE_SPEED_FOR_ONE_TWO_INITIAL_PASS = 5120 / MainFrame.m_inGameFrameRate;
        GROUND_PASS_FINAL_SPEED_FOR_ONE_TWO_INITIAL_PASS = 2560 / MainFrame.m_inGameFrameRate;
        THROUGH_BALL_FINAL_SPEED = 5376 / MainFrame.m_inGameFrameRate;
        JUMPING_CHEST_CONTROLLED_BALL_SPEED = 768 / MainFrame.m_inGameFrameRate;
        JUMPING_CHEST_CONTROL_FRAMES_TO_LAND_THE_JUMP = MainFrame.m_inGameFrameRate / 2 + 3;
        STANDING_CHEST_CONTROLLED_BALL_SPEED = 512 / MainFrame.m_inGameFrameRate;
        PASS_TARGET_UPDATE_DELAY = MainFrame.m_inGameFrameRate / 2;
        BALL_PLAYER_REBOUND_THRESHOLD_HIGH_PER_FRAME = 7680 / MainFrame.m_inGameFrameRate;
        BALL_PLAYER_REBOUND_THRESHOLD_HIGH_SQUARED = BALL_PLAYER_REBOUND_THRESHOLD_HIGH_PER_FRAME * BALL_PLAYER_REBOUND_THRESHOLD_HIGH_PER_FRAME;
        GRAVITY_PER_FRAME = 3278 / (MainFrame.m_inGameFrameRate * MainFrame.m_inGameFrameRate);
        PLAYER_JUMP_VELOCITY = GRAVITY_PER_FRAME * 3 / 2;
        KEEPER_JUMP_VELOCITY = GRAVITY_PER_FRAME * 3;
        BALL_BOUNCE_THRESHOLD_VELOCITY = 13 + GRAVITY_PER_FRAME;
        int n3 = AIR_RESISTANCE = n2 == 12 ? 254 : 255;
        if (n2 == 12) {
            m_friction -= 15;
        }
        NUMBER_OF_SECONDS_TO_KEEP_FREE_KICK_AWARENESS = 10 * MainFrame.m_inGameFrameRate;
        NUMBER_OF_SECONDS_TO_KEEP_GOAL_KICK_AWARENESS = 10 * MainFrame.m_inGameFrameRate;
        NUMBER_OF_SECONDS_TO_KEEP_CORNER_KICK_AWARENESS = 10 * MainFrame.m_inGameFrameRate;
        NUMBER_OF_SECONDS_TO_KEEP_PENALTY_KICK_AWARENESS = 10 * MainFrame.m_inGameFrameRate;
        NUMBER_OF_SECONDS_TO_KEEP_THROWIN_AWARENESS = 10 * MainFrame.m_inGameFrameRate;
        SET_PIECE_MANUAL_CAMERA_GROUND_SPEED = 2800 / MainFrame.m_inGameFrameRate;
        SET_PIECE_MANUAL_CAMERA_PAUSE = MainFrame.m_inGameFrameRate * 3;
        GOAL_FAST_VELOCITY_THRESHOLD = 3072 / MainFrame.m_inGameFrameRate;
        MIN_POST_REBOUND_SPEED = 1024 / MainFrame.m_inGameFrameRate;
        SHOT_LOB_MAX_FRAMES = (int)((double)(512 * MainFrame.m_inGameFrameRate) / 256.0);
        SHOT_SPEED_MAXIMUM_FROM_LONG_DISTANCE = 9984 / MainFrame.m_inGameFrameRate;
        SHOT_SPEED_MAXIMUM_FROM_MEDIUM_DISTANCE = 9984 / MainFrame.m_inGameFrameRate;
        SHOT_SPEED_MAXIMUM_FROM_SHORT_DISTANCE = 9984 / MainFrame.m_inGameFrameRate;
        SHOT_SPEED_MINIMIUM_FROM_LONG_DISTANCE = 8192 / MainFrame.m_inGameFrameRate;
        SHOT_SPEED_MINIMIUM_FROM_MEDIUM_DISTANCE = 8192 / MainFrame.m_inGameFrameRate;
        SHOT_SPEED_MINIMIUM_FROM_SHORT_DISTANCE = 8192 / MainFrame.m_inGameFrameRate;
        GRAPPLE_KICK_BALL_SPEED = 4096 / MainFrame.m_inGameFrameRate;
        KEEPER_CLEARANCE_BALL_SPEED = 6400 / MainFrame.m_inGameFrameRate;
        PLAYER_CLEARANCE_BALL_SPEED = 5888 / MainFrame.m_inGameFrameRate;
        PLAYER_CLEARANCE_TACKLE_BALL_SPEED = 2560 / MainFrame.m_inGameFrameRate;
        PLAYER_CLEARANCE_HEADER_BALL_SPEED = 3840 / MainFrame.m_inGameFrameRate;
        PLAYER_CLEARANCE_STANDING_TACKLE_BALL_SPEED = 1536 / MainFrame.m_inGameFrameRate;
        MARKER_DELAY_DURING_GRAPPLE_BREAK_AWAY = 435 * MainFrame.m_inGameFrameRate / 256;
        PLAYER_CLEARANCE_CONTROL_BALL_SPEED = 2560 / MainFrame.m_inGameFrameRate;
        TACKLE_SLIDE_SPEED = 4096 / MainFrame.m_inGameFrameRate;
        GameRender.BOX_SPINNING_LOGO_WIDTH_INCREMENT_PERCENT = 240 / n2;
        GameRender.REFEREE_ANIM_SPEED = n2 / 4;
        if (bl) {
            for (int i2 = 0; i2 < 2; ++i2) {
                for (int i3 = 0; i3 < 18; ++i3) {
                    GameAI.m_playerStorage[i2][i3][47] = GameAI.m_playerStorage[i2][i3][47] * 12 / MainFrame.m_inGameFrameRate;
                    GameAI.m_playerStorage[i2][i3][42] = GameAI.m_playerStorage[i2][i3][42] * 12 / MainFrame.m_inGameFrameRate;
                    GameAI.m_playerStorage[i2][i3][46] = 255 - GameAI.m_playerStorage[i2][i3][47] >> 3;
                    GameAI.m_playerStorage[i2][i3][47] = DDMath.min(GameAI.m_playerStorage[i2][i3][47], 280);
                }
            }
        }
    }

    public static void rematchSetup() {
    }

    public static void sendRematchPacket(boolean bl) {
    }

    private static void matchEventsInit() {
        int n2;
        for (n2 = 0; n2 < 20; ++n2) {
            GameLogic.m_matchEvents[n2] = 0;
        }
        for (n2 = 0; n2 < 9; ++n2) {
            GameLogic.m_matchEventsStringParams[n2] = 0;
        }
        m_matchEventOff = 0;
    }

    public static void matchEventAdd(int n2, int n3, int n4, int n5) {
        n4 = DDMath.min(MATCH_PERIOD_START_TIMES[m_matchPeriod] + n4, MATCH_PERIOD_START_TIMES[m_matchPeriod] + MATCH_PERIOD_LENGTHS[m_matchPeriod]);
        if (m_matchEventOff < 19) {
            GameLogic.m_matchEvents[GameLogic.m_matchEventOff] = n2 << 0 | n5 << 1 | n4 << 3 | n3 << 10;
            ++m_matchEventOff;
        }
    }

    public static void matchEventMakeString() {
        String[] stringArray = new String[]{"[", "\\", "]", "^"};
        XMLMenuSystem.tmpBuffer.setLength(0);
        for (int i2 = 0; i2 < m_matchEventOff; ++i2) {
            int n2 = m_matchEvents[i2] & 1;
            int n3 = m_matchEvents[i2] >> 1 & 3;
            int n4 = m_matchEvents[i2] >> 3 & 0x7F;
            int n5 = m_matchEvents[i2] >> 10;
            try {
                XMLMenuSystem.tmpBuffer.append(stringArray[n3] + " ");
                XMLMenuSystem.tmpBuffer.append(XMLMenuSystem.m_playerNameSDKStrings[n2][n5].toSDKString());
                XMLMenuSystem.tmpBuffer.append(" " + n4 + ", ");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (XMLMenuSystem.tmpBuffer.length() > 0) {
            XMLMenuSystem.tmpBuffer.setLength(XMLMenuSystem.tmpBuffer.length() - 2);
        }
        m_matchEventsString = XMLMenuSystem.tmpBuffer.toSDKString();
    }

    public static void setMatchDifficultyVariables(int n2) {
        if (n2 < 0) {
            n2 = 2;
        }
        switch (n2) {
            case 3: {
                m_difficultySettingGrappleSecondsBeforeAITackle_Default = 1408 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingGrappleSecondsBeforeAITackle_LB_RB = 1536 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingGrappleSecondsBeforeAITackle_LCB_RCB = 1408 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingGrappleSecondsBeforeAITackle_CB = 1408 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingTackleTime_Default = 1024 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingTackleTime_LB_RB = 896 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingTackleTime_LCB_RCB = 768 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingTackleTime_CB = 768 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingNumFramesAIConfusedForAfterQPM = 64;
                m_difficultySetttingMicroGameGreenZoneScale = 120;
                m_difficultySetttingAISprintingPercentage = 0;
                m_difficultySettingHumanSavePercantage = 150;
                m_difficultySettingAISavePercentage = 50;
                m_difficultySettingAIPlayerGoingOnARunPercentage = 10;
                m_difficultySettingAIPlayerSprintingJustOncePercentage = 30;
                m_difficultySettingAIPlayerSprintWithBallTimeMin = 128;
                m_difficultySettingAIPlayerSprintWithBallTimeMax = 512;
                m_difficultySettingAIPlayerInterceptSpeedAdjust = 50;
                m_difficultySettingHumanPlayerInterceptSpeedAdjust = 268;
                m_difficultySettingLongPassingRandomRangeHuman = 1;
                m_difficultySettingLongPassingRandomRangeAI = 24;
                m_difficultySettingMarkingBallToGoalsideJockeyRuntoDistanceMultiplier = 125;
                m_difficultySettingMarkingOneInXChanceOfSettingPlayerToMarkMultiplier = 133;
                m_difficultySettingDefensiveHeaderMinDistanceToAttacker = 5;
                m_difficultySettingDefensiveHeaderMinBallHeight = 520;
                m_difficultySettingDefensiveHeaderMaxBallHeight = 760;
                m_difficultySettingDefensiveHeaderMaxHorizontalDistance = 536;
                m_difficultySettingDefensiveHeaderMinDistanceToAttackerHuman = 4;
                m_difficultySettingDefensiveHeaderMinBallHeightHuman = 500;
                m_difficultySettingDefensiveHeaderMaxBallHeightHuman = 780;
                m_difficultySettingDefensiveHeaderMaxHorizontalDistanceHuman = 536;
                m_difficultySettingAIOneInNPassBallAwayWhenBeingForcedOutOfPitch = 24;
                break;
            }
            case 2: {
                m_difficultySettingGrappleSecondsBeforeAITackle_Default = 768 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingGrappleSecondsBeforeAITackle_LB_RB = 896 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingGrappleSecondsBeforeAITackle_LCB_RCB = 768 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingGrappleSecondsBeforeAITackle_CB = 768 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingTackleTime_Default = 640 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingTackleTime_LB_RB = 512 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingTackleTime_LCB_RCB = 384 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingTackleTime_CB = 384 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingNumFramesAIConfusedForAfterQPM = 56;
                m_difficultySetttingMicroGameGreenZoneScale = 100;
                m_difficultySetttingAISprintingPercentage = 0;
                m_difficultySettingHumanSavePercantage = 100;
                m_difficultySettingAISavePercentage = 100;
                m_difficultySettingAIPlayerGoingOnARunPercentage = 15;
                m_difficultySettingAIPlayerSprintingJustOncePercentage = 40;
                m_difficultySettingAIPlayerSprintWithBallTimeMin = 128;
                m_difficultySettingAIPlayerSprintWithBallTimeMax = 768;
                m_difficultySettingAIPlayerInterceptSpeedAdjust = 191;
                m_difficultySettingHumanPlayerInterceptSpeedAdjust = 190;
                m_difficultySettingLongPassingRandomRangeHuman = 7;
                m_difficultySettingLongPassingRandomRangeAI = 16;
                m_difficultySettingMarkingBallToGoalsideJockeyRuntoDistanceMultiplier = 100;
                m_difficultySettingMarkingOneInXChanceOfSettingPlayerToMarkMultiplier = 100;
                m_difficultySettingDefensiveHeaderMinDistanceToAttacker = 4;
                m_difficultySettingDefensiveHeaderMinBallHeight = 500;
                m_difficultySettingDefensiveHeaderMaxBallHeight = 780;
                m_difficultySettingDefensiveHeaderMaxHorizontalDistance = 536;
                m_difficultySettingDefensiveHeaderMinDistanceToAttackerHuman = 4;
                m_difficultySettingDefensiveHeaderMinBallHeightHuman = 500;
                m_difficultySettingDefensiveHeaderMaxBallHeightHuman = 780;
                m_difficultySettingDefensiveHeaderMaxHorizontalDistanceHuman = 536;
                m_difficultySettingAIOneInNPassBallAwayWhenBeingForcedOutOfPitch = 12;
                break;
            }
            case 1: {
                m_difficultySettingGrappleSecondsBeforeAITackle_Default = 384 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingGrappleSecondsBeforeAITackle_LB_RB = 512 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingGrappleSecondsBeforeAITackle_LCB_RCB = 384 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingGrappleSecondsBeforeAITackle_CB = 384 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingTackleTime_Default = 307 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingTackleTime_LB_RB = 230 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingTackleTime_LCB_RCB = 192 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingTackleTime_CB = 192 * MainFrame.m_inGameFrameRate / 256;
                m_difficultySettingNumFramesAIConfusedForAfterQPM = 48;
                m_difficultySetttingMicroGameGreenZoneScale = 50;
                m_difficultySetttingAISprintingPercentage = 0;
                m_difficultySettingHumanSavePercantage = 65;
                m_difficultySettingAISavePercentage = 135;
                m_difficultySettingAIPlayerGoingOnARunPercentage = 20;
                m_difficultySettingAIPlayerSprintingJustOncePercentage = 50;
                m_difficultySettingAIPlayerSprintWithBallTimeMin = 128;
                m_difficultySettingAIPlayerSprintWithBallTimeMax = 1024;
                m_difficultySettingAIPlayerInterceptSpeedAdjust = 268;
                m_difficultySettingHumanPlayerInterceptSpeedAdjust = 49;
                m_difficultySettingLongPassingRandomRangeHuman = 20;
                m_difficultySettingLongPassingRandomRangeAI = 8;
                m_difficultySettingMarkingBallToGoalsideJockeyRuntoDistanceMultiplier = 75;
                m_difficultySettingMarkingOneInXChanceOfSettingPlayerToMarkMultiplier = 50;
                m_difficultySettingDefensiveHeaderMinDistanceToAttacker = 3;
                m_difficultySettingDefensiveHeaderMinBallHeight = 400;
                m_difficultySettingDefensiveHeaderMaxBallHeight = 780;
                m_difficultySettingDefensiveHeaderMaxHorizontalDistance = 740;
                m_difficultySettingDefensiveHeaderMinDistanceToAttackerHuman = 4;
                m_difficultySettingDefensiveHeaderMinBallHeightHuman = 500;
                m_difficultySettingDefensiveHeaderMaxBallHeightHuman = 780;
                m_difficultySettingDefensiveHeaderMaxHorizontalDistanceHuman = 536;
                m_difficultySettingAIOneInNPassBallAwayWhenBeingForcedOutOfPitch = 0;
            }
        }
    }

    public static void playerStatsAddGoal(int[] nArray) {
        int n2 = GameAI.m_goalScorer[11];
        int n3 = XMLMenuSystem.m_gmodePlayerStats[20 + n2] & 0xFF;
        int n4 = 20 + n2;
        XMLMenuSystem.m_gmodePlayerStats[n4] = XMLMenuSystem.m_gmodePlayerStats[n4] & 0xFFFFFF00;
        int n5 = 20 + n2;
        XMLMenuSystem.m_gmodePlayerStats[n5] = XMLMenuSystem.m_gmodePlayerStats[n5] | ++n3;
        GameAI.m_goalScorer[66] = GameAI.m_goalScorer[66] + 1;
        GameLogic.beAProCheckIfBAPStatAchieved(0, nArray, null);
        if (GameLogic.beAProIsPlayerBAPPlayer(nArray)) {
            if (++XMLMenuSystem.m_goalsScoredCounter >= 40 && !XMLMenuSystem.isTrophyAcquired(11)) {
                XMLMenuSystem.addTrophyInGame(11);
            }
            ++XMLMenuSystem.m_bapScored;
        } else {
            GameLogic.beAProTeamStatAchieved(17);
        }
    }

    public static boolean beAProIsPlayerBAPPlayer(int[] nArray) {
        if (XMLMenuSystem.m_menuSeasonType == 2) {
            return GameAI.m_playerStorage[GameLogic.getPlayerTeam()][XMLMenuSystem.m_beAProPlayerIndex] == nArray;
        }
        return false;
    }

    public static void beAProTeamStatAchieved(int n2) {
        if (XMLMenuSystem.m_menuSeasonType == 2) {
            GameLogic.beAProUpdateBAPPoints(BE_A_PRO_STAT_POINTS[n2]);
        }
    }

    public static void beAProCheckIfBAPStatAchieved(int n2, int[] nArray, int[] nArray2) {
        if (XMLMenuSystem.m_menuSeasonType == 2 && (nArray == null || GameLogic.beAProIsPlayerBAPPlayer(nArray))) {
            boolean bl = false;
            switch (n2) {
                case 0: {
                    bl = true;
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
                case 2: {
                    bl = true;
                    m_beAProPassPlayed = false;
                    break;
                }
                case 3: {
                    if (!m_beAProPassPlayed || GameLogic.beAProIsPlayerBAPPlayer(nArray2) || nArray2[12] != GameLogic.getPlayerTeam()) break;
                    bl = true;
                    m_beAProPassPlayed = false;
                    break;
                }
                case 4: {
                    bl = true;
                    m_beAProPassPlayed = false;
                    break;
                }
                case 5: {
                    if (nArray2[28] == 14 || nArray2[28] == 72) break;
                    nArray[78] = nArray[78] + 1;
                    bl = true;
                    break;
                }
                case 6: {
                    bl = true;
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    bl = true;
                    break;
                }
                case 9: {
                    bl = true;
                    break;
                }
                case 10: {
                    bl = true;
                    break;
                }
                case 11: {
                    bl = true;
                    break;
                }
                case 12: {
                    if (m_matchState == 9 || nArray[28] == 14 || nArray[28] == 72) break;
                    nArray[77] = nArray[77] + 1;
                    bl = true;
                    break;
                }
                case 13: {
                    if (!m_beAProPassPlayed) break;
                    bl = true;
                    m_beAProPassPlayed = false;
                    break;
                }
                case 14: {
                    bl = true;
                    m_beAProPassPlayed = false;
                    break;
                }
                case 15: {
                    bl = true;
                    m_beAProPassPlayed = false;
                }
            }
            if (bl) {
                GameLogic.beAProUpdateBAPPoints(BE_A_PRO_STAT_POINTS[n2]);
            }
        }
    }

    private static void beAProUpdateBAPPoints(int n2) {
        m_beAProRating += n2;
        m_beAProRating = DDMath.min(m_beAProRating, 1000);
        m_beAProRating = DDMath.max(m_beAProRating, 0);
        GameRender.beAProGlowEffectInit(n2);
    }

    public static int beAProGetBAPStatPoints() {
        int n2 = m_beAProRating / 200;
        if (m_beAProRating % 200 >= 100) {
            ++n2;
        }
        return n2;
    }

    public static boolean checkIfTackleWon(int[] nArray, int[] nArray2) {
        if (nArray2[28] != 14 && nArray2[28] != 72) {
            nArray[67] = nArray[67] + 1;
            return true;
        }
        return false;
    }

    public static boolean checkIfTackleLost(int[] nArray) {
        if (m_matchState != 9 && nArray[28] != 14 && nArray[28] != 72) {
            nArray[63] = nArray[63] + 1;
            return true;
        }
        return false;
    }

    public static void CommentaryCheckGoalScorerForSpecialCase(int[] nArray) {
        if (GameAI.m_goalScorer[66] == 3 && m_matchSubState != 9) {
            GameRender.commentarySet(true, 16);
            if (GameAI.m_goalScorer[11] == XMLMenuSystem.m_beAProPlayerIndex) {
                XMLMenuSystem.addTrophyInGame(3);
            }
        } else if (GameAI.m_goalScorer[66] == 2 && m_matchSubState != 9) {
            GameRender.commentarySet(true, 25);
        } else if (GameLogic.getPlayerTeam() == nArray[12] && m_matchSubState != 9) {
            GameRender.commentarySet(true, 10);
        } else if (GameLogic.getPlayerTeam() == GameAI.m_goalScorer[12] || m_matchSubState == 9) {
            if (GameAI.m_goalScorer[53] == 0 && m_matchSubState != 9) {
                GameRender.commentarySet(true, 29);
            } else {
                GameRender.commentarySet(true, 17);
            }
        } else {
            GameRender.commentarySet(true, 11);
        }
    }

    public static void CelebrationsInit(int n2) {
        if (GameAI.ballGetLastTouchPlayerTeam() == n2) {
            int n3;
            int n4 = (DDMath.getRandom() & 0xFF) % 5;
            int n5 = GameAI.m_teamStorage[n2][6] - GameAI.m_teamStorage[n2 ^ 1][6];
            int n6 = GameAI.m_goalScorer[0] > 12311 ? 23084 : 1538;
            int n7 = 16007;
            if (n5 == 0 || n5 == -1) {
                n3 = (n4 & 1) == 0 ? 101 : 129;
            } else if (n5 > 0) {
                n4 = 0;
                switch (n4) {
                    case 0: {
                        n3 = 127;
                        break;
                    }
                    case 1: {
                        n3 = 101;
                        break;
                    }
                    case 2: {
                        n3 = 99;
                        break;
                    }
                    default: {
                        n3 = 129;
                        break;
                    }
                }
            } else {
                n3 = 127;
            }
            GameAI.playerSetState(GameAI.m_goalScorer, n6, n7, n3);
        }
    }

    public static int[] getNearestCornerFlag(int[] nArray) {
        GameLogic.m_cornerFlagObject[0] = nArray[0] > 12311 ? 24622 : 0;
        GameLogic.m_cornerFlagObject[1] = nArray[1] > 16007 ? 32015 : 0;
        return m_cornerFlagObject;
    }

    private static void initMatchVars() {
        int n2;
        m_refereeTimer = 0;
        m_refereeDecision = 0;
        m_gameModeResetTimer = 0;
        m_nearGoalPostX = 0;
        m_nearGoalPostY = 0;
        m_farGoalPostX = 0;
        m_farGoalPostY = 0;
        for (n2 = 0; n2 < 9; ++n2) {
            GameLogic.m_ballOutOfPlayPosition[n2] = 0;
            GameLogic.m_setPieceTargetObject[n2] = 0;
            GameLogic.m_cornerFlagObject[n2] = 0;
            GameLogic.m_futureBallObject[n2] = 0;
            GameLogic.m_setPieceGKTargetObject[n2] = 0;
        }
        m_ballBouncePositionX = 0;
        m_ballBouncePositionY = 0;
        m_ballBouncePositionZ = 0;
        m_lockPassTargetsPlayer = null;
        m_nearestPlayerDistanceSquaredStore = 0;
        for (n2 = 0; n2 < 44; ++n2) {
            GameLogic.setPieceSelection[n2] = 0;
        }
        m_resetSetPieceTakerInfo = false;
        m_resetSetPieceTakerTrajectory = 0;
        m_resetSetPieceTakerMode = 0;
        m_resetSetPieceTakerTarget = 0;
        m_replayDoNotTrigger = false;
        for (int i2 = 0; i2 < 13; ++i2) {
            for (n2 = 0; n2 < 21; ++n2) {
                GameLogic.collisionList[i2][n2][0] = 0;
            }
        }
        m_futureBallHasBounced = false;
        m_scorerTeam = 0;
        m_scorerID = 0;
        m_shootingPlayerShotType = 0;
        m_fouledPlayersTeam = 0;
        m_foulxpos = 0;
        m_foulypos = 0;
        m_foulingPlayer = null;
        m_fouledPlayer = null;
        m_setPieceTaker = null;
        m_setPieceTargetPlayer = 0;
        m_trajectoryType = 2;
        m_setPieceMode = 0;
        m_setPieceType = 0;
        m_setPieceTimer = 0;
        XMLMenuSystem.m_trophiesInGameData = 0;
    }

    private static void freeKickChallengeLoad() {
        m_freeKickChallengeGiveCard = false;
        m_freeKickChallengeTimeElapsed = 0;
        m_freeKickChallengeUpdateTime = false;
        m_freeKickChallengePoints = 0;
        m_freeKickChallengeStorage = new int[4];
        GameAI.m_setPieceTakers[1] = 1;
        m_trajectoryType = 3;
        m_freeKickChallengeCurrentRound = 0;
        m_freeKickChallengeRoundCompleted = false;
        m_freeKickChallengePlayer = 10;
    }

    private static int[] freeKickChallengeStorageGenerate() {
        int n2 = m_freeKickChallengeCurrentRound >= 14 ? 2 : (m_freeKickChallengeCurrentRound >= 2 ? 1 : 0);
        int n3 = m_freeKickChallengeCurrentRound >= 9 ? 2 : (m_freeKickChallengeCurrentRound >= 6 ? 1 : 0);
        int n4 = m_freeKickChallengeCurrentRound >= 1 ? 1 : 0;
        int n5 = m_freeKickChallengeCurrentRound >= 13 ? 4 : (m_freeKickChallengeCurrentRound >= 9 ? 3 : (m_freeKickChallengeCurrentRound >= 5 ? 2 : (m_freeKickChallengeCurrentRound >= 2 ? 1 : 0)));
        return new int[]{n2, n3, n4, n5};
    }

    private static void freeKickChallengeUpdate() {
        int n2 = (int)MainFrame.m_canvas.getAppTime();
        if (m_freeKickChallengeSetupNewFreekick) {
            if (GameRender.m_fadeState == 1) {
                if (m_freeKickChallengeRoundCompleted) {
                    GameLogic.freeKickChallengeCalculatePoints();
                    m_freeKickChallengeTimeElapsed -= GameLogic.freeKickChallengeBonusTimeForRound(m_freeKickChallengeCurrentRound) * 1000;
                }
                GameLogic.freeKickChallengeSetupNewFreeKick();
                m_freeKickChallengeRoundCompleted = false;
                GameRender.fadeSet(true);
            }
        } else if (m_freeKickChallengeRoundComplete && GameRender.m_boxState == 5) {
            m_freeKickChallengeRoundComplete = false;
            ++m_freeKickChallengeCurrentRound;
            m_freeKickChallengeSetupNewFreekick = true;
            m_freeKickChallengeRoundCompleted = true;
            GameLogic.freeKickChallengeInit();
            GameRender.fadeSet(false);
        }
        if (m_freeKickChallengeUpdateTime) {
            m_freeKickChallengeTimeElapsed += n2 - m_freeKickChallengeTimeLastUpdate;
            m_freeKickChallengeTimeLastUpdate = n2;
        } else if (m_matchState == 9 && m_matchSubState == 27 && GameRender.m_fadeState == 2 && GameRender.canMoveAimLine() || GameRender.m_fadeState == 2 && m_matchSubState == 28) {
            m_freeKickChallengeUpdateTime = true;
            m_freeKickChallengeTimeLastUpdate = (int)MainFrame.m_canvas.getAppTime();
        }
        if (m_freeKickChallengeUpdateTime && (m_possession == 1 && GameAI.ObjectIsStationary(GameAI.m_ballStorage) || !Trajectory.isBallUnderTrajectoryControl() && GameAI.ObjectIsStationary(GameAI.m_ballStorage) && m_matchState == 2 && m_setPieceTaker[28] != 38) && GameRender.m_fadeState == 2) {
            GameLogic.freeKickChallengeFadeOut(false);
        }
        if (m_freeKickChallengeTimeElapsed >= 30000 && m_matchState == 9) {
            m_freeKickChallengeGiveCard = true;
            GameRender.fadeSet(false);
            m_freeKickChallengeUpdateTime = false;
        }
        if (GameRender.m_fadeState == 1 && m_freeKickChallengeGiveCard) {
            m_freeKickChallengeGiveCard = false;
            m_foulingPlayer = GameAI.m_playerStorage[0][m_freeKickChallengePlayer];
            GameLogic.m_foulingPlayer[58] = 2;
            GameLogic.setState(1, 5, -1, -1);
            XMLMenuSystem.setSoftKeys(0, 0);
            GameAI.playerSetState(GameAI.m_playerStorage[0][m_freeKickChallengePlayer], 0, 0, 0);
        }
    }

    public static int freeKickChallengeBonusTimeForRound(int n2) {
        if (n2 <= 2) {
            return 10;
        }
        return 5;
    }

    public static void freeKickChallengeInit() {
        m_freeKickChallengeStorage = GameLogic.freeKickChallengeStorageGenerate();
        m_freeKickChallengeShowRoundInfo = true;
    }

    public static int freeKickChallengeGetPlayersInWall() {
        return m_freeKickChallengeStorage[3];
    }

    public static int freeKickChallengeGetMaxTimer() {
        return 30;
    }

    public static boolean freeKickChallengeGetKeeperActive() {
        return m_freeKickChallengeStorage[2] == 1;
    }

    public static int freeKickChallengeGetPoints() {
        return m_freeKickChallengePoints;
    }

    public static void freeKickChallengeFadeOut(boolean bl) {
        boolean bl2 = true;
        m_freeKickChallengeUpdateTime = false;
        if (bl) {
            m_freeKickChallengeSetupNewFreekick = false;
            m_freeKickChallengeRoundComplete = true;
            GameLogic.m_controller[GameLogic.m_possession].m_controlPlayer = null;
            bl2 = false;
            XMLMenuSystem.m_s_codedTextArray[0][0] = XMLMenuSystem.createSDKString(XMLMenuSystem.m_s_codedTextArray[0][0], "" + (m_freeKickChallengeCurrentRound + 1));
            GameRender.boxSetState(0, 24, 2, 1048, 0, 1, 1, true);
            GameAI.m_playerStorage[0][GameLogic.m_freeKickChallengePlayer][28] = 193;
        }
        if (bl2) {
            GameRender.fadeSet(false);
            m_freeKickChallengeSetupNewFreekick = true;
        }
    }

    private static void freeKickChallengeSetupNewFreeKick() {
        int n2;
        int n3 = 0;
        int n4 = 0;
        m_freeKickChallengeSetupNewFreekick = false;
        m_difficultySetttingMicroGameGreenZoneScale = 120 - m_freeKickChallengeCurrentRound * 5;
        for (int i2 = 0; i2 < 2; ++i2) {
            for (n2 = 0; n2 < 18; ++n2) {
                GameAI.m_playerStorage[i2][n2][49] = 2;
                GameAI.m_playerStorage[i2][n2][28] = 0;
            }
        }
        if (m_freeKickChallengeStorage[2] == 1) {
            GameAI.m_playerStorage[1][0][49] = 0;
            GameAI.m_playerStorage[1][0][28] = 0;
        }
        for (n2 = 0; n2 < m_freeKickChallengeStorage[3]; ++n2) {
            GameAI.m_playerStorage[1][1 + n2][49] = 0;
            GameAI.m_playerStorage[1][1 + n2][28] = 193;
        }
        GameAI.m_playerStorage[0][GameLogic.m_freeKickChallengePlayer][58] = 1;
        GameAI.m_playerStorage[0][GameLogic.m_freeKickChallengePlayer][49] = 0;
        GameAI.m_playerStorage[0][GameLogic.m_freeKickChallengePlayer][28] = 193;
        switch (m_freeKickChallengeStorage[0]) {
            case 0: {
                n3 = 6186;
                n4 = 7466;
                break;
            }
            case 1: {
                n3 = 7466;
                n4 = 8746;
                break;
            }
            case 2: {
                n3 = 8746;
                n4 = 10026;
            }
        }
        if (m_freeKickChallengeRoundCompleted || m_freeKickChallengeCurrentRound == 0) {
            m_freeKickChallengeDistance = DDMath.getRandom(n3, n4);
            if (m_freeKickChallengeStorage[1] == 0) {
                m_freeKickChallengeAngleUnmodified = 234 + DDMath.getRandom(0, 42) & 0xFF;
            } else {
                m_freeKickChallengeAngleUnmodified = m_freeKickChallengeStorage[1] == 1 ? DDMath.getRandom(220, 234) : DDMath.getRandom(213, 220);
                if ((DDMath.getPositiveRandom() & 1) == 0) {
                    m_freeKickChallengeAngleUnmodified = 255 - m_freeKickChallengeAngleUnmodified;
                }
            }
            m_freeKickChallengeAngle = m_freeKickChallengeAngleUnmodified;
            if (m_freeKickChallengeAngle > 128) {
                m_freeKickChallengeAngle = 255 - m_freeKickChallengeAngle;
            }
            m_freeKickChallengeAngle = 64 - m_freeKickChallengeAngle;
        }
        m_freeKickChallengeBallOutOfPlay = false;
        int n5 = 12311 + (DDMath.sin(m_freeKickChallengeAngleUnmodified) * m_freeKickChallengeDistance >> 16);
        int n6 = DDMath.cos(m_freeKickChallengeAngleUnmodified) * m_freeKickChallengeDistance >> 16;
        GameAI.m_ballStorage[0] = m_foulxpos = n5;
        GameAI.m_ballStorage[1] = m_foulypos = n6;
        GameAI.m_ballStorage[2] = 0;
        GameAI.objectResetVelocity(GameAI.m_ballStorage);
        GameAI.m_playerStorage[1][0][25] = 12311;
        GameAI.m_playerStorage[1][0][26] = 0;
        m_setPieceTaker = GameAI.m_playerStorage[0][m_freeKickChallengePlayer];
        GameAI.m_playerStorage[0][GameLogic.m_freeKickChallengePlayer][28] = 0;
        GameLogic.calculateNearFarGoalPostPositions(GameAI.teamGetPitchSide(m_possession ^ 1));
        n5 = m_nearGoalPostX - m_foulxpos >> 8;
        n6 = m_nearGoalPostY - m_foulypos >> 8;
        int n7 = DDMath.atan(n5, n6);
        GameAI.objectSetPosition(m_setPieceTaker, m_foulxpos - ((DDMath.sin(n7) >> 8) * 1280 >> 8), m_foulypos - ((DDMath.cos(n7) >> 8) * 1280 >> 8), 0);
        GameLogic.setState(3, -1, -1, -1);
        GameLogic.setState(9, 55, -1, 25);
    }

    public static void freeKickChallengeCalculatePoints() {
        int n2 = 0;
        n2 += (m_freeKickChallengeDistance >> 8) * 20;
        int n3 = m_freeKickChallengeAngle;
        n3 = n3 * 360 / 256;
        n2 += (90 - n3) * 30;
        n2 += m_freeKickChallengeStorage[2] * 40;
        m_freeKickChallengePoints += (n2 += m_freeKickChallengeStorage[3] * 80);
    }

    public static boolean isShootoutViewEnabled() {
        if (m_gameMode == 99) {
            // empty if block
        }
        return false;
    }

    public static boolean inShootoutView() {
        if (!GameLogic.isShootoutViewEnabled()) {
            return false;
        }
        boolean bl = m_matchState == 7 || m_matchState == 16 || m_matchState == 19 ? false : (MainFrame.m_masterState == 5 ? false : (m_gameMode == 1 && m_matchPeriod != 4 ? m_matchState == 8 && (m_matchSubState == 13 || m_matchSubState == 14) : (m_gameMode == 99 || m_gameMode == 1 && m_matchPeriod == 4 ? m_matchSubState != 12 : false)));
        if (GameRender.m_stadiumPlayersEyeView != bl) {
            GameRender.stadiumRendererPitchMapGenerate(bl);
            if (!bl && GameRender.m_landscapeMode != 0) {
                GameLogic.setupFrameRate(12, false);
            } else {
                GameLogic.setupFrameRate(24, false);
            }
            GameRender.m_cameraJumpToPosition = true;
        }
        m_goalWidth = bl ? 2329 : 2725;
        return bl;
    }

    public static boolean isPrematchActive() {
        return m_matchState == 1 && (m_matchSubState == 11 || m_matchSubState == 1 || m_matchSubState == 2 || m_matchSubState == 3 || m_matchSubState == 4);
    }

    private static void updatePKVibration() {
        int n2 = (int)MainFrame.m_canvas.getAppTime();
        if (DDMath.abs(n2 - m_lastVibrateTime) > 1000) {
            MainFrame.vibratePlay(500);
            m_lastVibrateTime = n2;
        }
    }

    private static boolean canWinOrLosePKShootout() {
        if (m_gameMode == 99 || m_matchPeriod == 4) {
            if (GameAI.m_teamStorage[0][15] + 1 > GameAI.m_teamStorage[1][15] + (5 - (m_penaltiesCount + 1) / 2) || GameAI.m_teamStorage[1][15] + 1 > GameAI.m_teamStorage[0][15] + (5 - (m_penaltiesCount + 1 + 1) / 2)) {
                return true;
            }
            return m_penaltiesCount >= 10;
        }
        return true;
    }

    static {
        m_interruptTimeLastFramesDifference = 0;
        m_resetSetPieceTakerInfo = false;
        m_resetSetPieceTakerTrajectory = 0;
        m_resetSetPieceTakerMode = 0;
        m_resetSetPieceTakerTarget = 0;
        m_trajectoryType = 2;
        m_cheatCodesIndex = new int[33];
        m_updateFrameCounter = 0;
        m_bluetoothLandscape = new int[2];
        m_fatigueEffect = 0;
        m_ballVoffset = 0;
        m_ballHoffset = 0;
        m_ballZoffset = 0;
        m_playerAnim = 0;
        m_playerAnimFrame = 0;
        m_upAnimType = false;
        m_downAnimType = false;
        m_upAnimFrame = false;
        m_downAnimFrame = false;
        m_upDirection = false;
        m_matchEvents = new int[20];
        m_matchEventsStringParams = new int[9];
        m_quickPlayMomentAvailable = false;
        m_quickPlayMomentTriggered = false;
        m_moveOutOfTunnelTime = 0;
        SKIPHINT = true;
        lskWasReleased = false;
        m_manOfTheMatchDelay = -1L;
        stay = false;
        BL_CORNER_HITTED = false;
        BR_CORNER_HITTED = false;
        TL_CORNER_HITTED = false;
        TR_CORNER_HITTED = false;
        MIDDLE_HITTED = false;
        minigame_bonus = 0;
        setPieceUpdateTimer = 0;
        penaltyGoalScore = 0;
        penalty_highscore_state = false;
        debugScenarioTriggered = false;
        debugScenarioData = new int[]{0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 34, 14080, 24320, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 14016, 25856, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 14080, 24320, 0, 0, 0};
        bapStatTimeDelay = 0L;
        BE_A_PRO_STAT_POINTS = new int[]{200, 25, 25, 25, 50, 50, 25, 25, -100, -100, -300, -200, -50, -50, -50, -50, 50, 50, -100};
        m_beAProPassPlayed = false;
        BL_CORNER_SUCCESS = false;
        BR_CORNER_SUCCESS = false;
        TL_CORNER_SUCCESS = false;
        TR_CORNER_SUCCESS = false;
        MIDDLE_SUCCESS = false;
    }
}

