/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Controller;
import com.ea.game.DDDebug;
import com.ea.game.DDMath;
import com.ea.game.GameAI;
import com.ea.game.GameFormation;
import com.ea.game.GameLogic;
import com.ea.game.GameRender;
import com.ea.game.MainFrame;
import com.ea.game.Trajectory;
import com.ea.game.XMLMenuSystem;

public class HumanController
extends Controller {
    private static boolean DebugKeyPresses = false;
    protected static int HUMAN_CONTROL_INPUT_TIMEOUT;
    protected static final int CMD_WATCH_CMD1_EVENT_TIME = 0;
    protected static final int CMD_WATCH_CMD2_EVENT_TIME = 1;
    protected static final int CMD_WATCH_KEY_REPEAT_COUNT = 2;
    protected static final int CMD_WATCH_CURRENT_KEY = 3;
    protected static final int CMD_WATCH_ARRAY_LENGTH = 4;
    protected static final int DIRECTION_LONG_PRESS = 3;
    public static final int OUTER_PLAYER_SELECT = 25;
    public static final int INNER_PLAYER_SELECT = 12;
    public static final int FRONT_PLAYER_SELECT_ANGLE = 64;
    public static final int CLOSE_PLAYER_SWITCH = 5;
    protected static final int LONG_PRESS_REPEATS = 5;
    protected static final int MAX_TIME_FOR_DOUBLE_TAP = 5;
    protected static final int MAX_TIME_FOR_DOUBLE_TAP_PASS = 5;
    protected static final int DEFENSIVE_HEADER_TRIGGER_RESET_FRAMES = 3;
    private int[] m_cmdLookup = new int[12];
    private int[][] m_cmdWatchList;
    public static final int HUMAN_CONTROL_LOCK_ON_BALL_DISTANCE = 15;

    public void setupControls(int n2) {
        switch (n2) {
            case 0: {
                this.m_cmdLookup[0] = 2;
                this.m_cmdLookup[1] = 10;
                this.m_cmdLookup[2] = 8;
                this.m_cmdLookup[3] = 9;
                this.m_cmdLookup[4] = 1;
                this.m_cmdLookup[5] = 5;
                this.m_cmdLookup[6] = 4;
                this.m_cmdLookup[7] = 6;
                this.m_cmdLookup[8] = 16;
                this.m_cmdLookup[9] = 128;
                this.m_cmdLookup[10] = 256;
                this.m_cmdLookup[11] = 32768;
                break;
            }
            case 1: {
                this.m_cmdLookup[0] = 8;
                this.m_cmdLookup[1] = 9;
                this.m_cmdLookup[2] = 1;
                this.m_cmdLookup[3] = 5;
                this.m_cmdLookup[4] = 4;
                this.m_cmdLookup[5] = 6;
                this.m_cmdLookup[6] = 2;
                this.m_cmdLookup[7] = 10;
                this.m_cmdLookup[8] = 16;
                this.m_cmdLookup[9] = 128;
                this.m_cmdLookup[10] = 256;
                this.m_cmdLookup[11] = 32768;
                break;
            }
            case 2: {
                this.m_cmdLookup[0] = 4;
                this.m_cmdLookup[1] = 6;
                this.m_cmdLookup[2] = 2;
                this.m_cmdLookup[3] = 10;
                this.m_cmdLookup[4] = 8;
                this.m_cmdLookup[5] = 9;
                this.m_cmdLookup[6] = 1;
                this.m_cmdLookup[7] = 5;
                this.m_cmdLookup[8] = 16;
                this.m_cmdLookup[9] = 128;
                this.m_cmdLookup[10] = 256;
                this.m_cmdLookup[11] = 32768;
            }
        }
        this.m_cmdWatchList = new int[12][4];
        for (int i2 = 0; i2 < 12; ++i2) {
            this.resetCommandWatchList(i2);
        }
        HUMAN_CONTROL_INPUT_TIMEOUT = MainFrame.m_inGameFrameRate / 3;
        this.m_homeInOnBall = false;
    }

    public HumanController(int n2) {
        super(n2);
    }

    public void setJoystick(int n2) {
        this.m_joystick = n2;
    }

    public void update() {
        int n2;
        this.updateSkipKey();
        if (this.m_defensiveHeaderClearance) {
            ++this.m_framesSinceDefensiveHeaderTriggered;
            if (this.m_framesSinceDefensiveHeaderTriggered > 3) {
                this.m_defensiveHeaderClearance = false;
            }
        }
        if (GameLogic.m_gameMode == 5 && this.m_microGame.inProgress() && (n2 = DDMath.max(GameLogic.freeKickChallengeGetMaxTimer() * 1000 - GameLogic.m_freeKickChallengeTimeElapsed, 0)) < 100) {
            this.m_microGame.cancelMicroGame();
        }
        if ((GameLogic.m_matchState == 13 || GameLogic.m_matchState == 7 || GameLogic.m_matchState == 16 || XMLMenuSystem.m_currMenu == 31 || XMLMenuSystem.m_currMenu == 10 || XMLMenuSystem.m_currMenu == -31 || XMLMenuSystem.m_currMenu == -30) && (this.m_joystick & 0x10) != 0 && (this.m_lastJoystickWatchValue & 0x10) == 0) {
            return;
        }
        if (this.updateProcessLskBackKey()) {
            return;
        }
        if (this.updateProcessRskKey()) {
            return;
        }
        --this.m_controlPlayerMoveTimer;
        this.updateProcessCommandWatchlist();
        this.updateInstantActions();
        this.m_lastJoystickWatchValue = this.m_joystick;
        this.updateMicrogame();
        if (GameLogic.m_matchState == 2) {
            int[] nArray;
            if (this.m_homeInOnBall && this.m_controlPlayer != null && GameLogic.m_possession != this.m_teamID && DDMath.calcHorizontalDistSquared(this.m_controlPlayer, nArray = GameAI.m_playerStorage[GameAI.m_ballStorage[10] & 1][GameAI.m_ballStorage[10] >> 1]) < 0x640000 && GameAI.ballIsPossessed()) {
                this.m_homeInOnBall = false;
                this.m_microGame.init(this.m_controlPlayer, 5, 3500, 0, this.m_controlPlayer[44]);
                this.microGameUpdate();
            }
            if (this.m_controlPlayer != null && this.m_controlPlayer[28] == 71) {
                this.m_controlPlayer = null;
            }
        } else {
            this.m_homeInOnBall = false;
        }
    }

    private boolean updateProcessLskBackKey() {
        if (((this.m_joystick & 0x40) != 0 || (this.m_joystick & 0x200) != 0) && (this.m_lastJoystickWatchValue & 0x40) == 0 && (this.m_lastJoystickWatchValue & 0x200) == 0) {
            this.setSkipKey();
            if (GameLogic.m_matchState == 13 && MainFrame.m_masterState != 7) {
                XMLMenuSystem.m_globalArray[1] = 0;
                if (XMLMenuSystem.replayEnteredFromPauseMenu) {
                    GameLogic.m_controller[1].m_goIntoPause = true;
                    GameLogic.m_controller[0].m_goIntoPause = true;
                    XMLMenuSystem.replayEnteredFromPauseMenu = false;
                }
                this.m_skipReplay = true;
                this.m_joystick = 0;
                this.m_lastJoystickWatchValue |= 0x40;
            } else if (GameLogic.m_matchState == 19) {
                this.m_buttonThrough = true;
            } else if (GameLogic.m_matchState != 13 && GameLogic.m_matchState != 7 && GameLogic.m_matchState != 16 && GameLogic.m_matchState != 15) {
                int n2;
                if (GameLogic.m_gameMode == 5 && (GameLogic.m_freeKickChallengeRoundComplete || !GameLogic.m_freeKickChallengeUpdateTime && (GameRender.canMoveAimLine() || GameLogic.m_matchState == 1 && GameLogic.m_matchSubState == 5))) {
                    return true;
                }
                if (GameLogic.m_gameMode == 5 && (n2 = GameLogic.freeKickChallengeGetMaxTimer() * 1000 - GameLogic.m_freeKickChallengeTimeElapsed) < 100) {
                    return true;
                }
                if (!GameLogic.lskWasReleased) {
                    return true;
                }
                XMLMenuSystem.m_globalArray[1] = 0;
                this.m_goIntoPause = true;
                XMLMenuSystem.m_inGamePrevMenu = XMLMenuSystem.m_currMenu;
                this.m_joystick = 0;
                this.m_lastJoystickWatchValue |= 0x40;
            }
            return true;
        }
        return false;
    }

    private boolean updateProcessRskKey() {
        if ((this.m_joystick & 0x20) != 0 && (this.m_lastJoystickWatchValue & 0x20) == 0) {
            this.setSkipKey();
            this.m_joystick = 0;
            this.m_lastJoystickWatchValue |= 0x20;
            if (GameLogic.m_matchState == 1 && (GameLogic.m_matchSubState == 11 || GameLogic.m_matchSubState == 2 || GameLogic.m_matchSubState == 1)) {
                this.m_skipToKickOff = true;
            }
            if ((GameLogic.m_matchState == 9 || GameLogic.m_matchState == 6 || GameLogic.m_matchState == 8) && GameLogic.m_possession == this.m_teamID) {
                if (GameLogic.m_matchSubState == 28) {
                    if (!this.m_microGame.inProgress()) {
                        GameLogic.setPieceSaveTargetInfo();
                        GameLogic.setState(9, GameLogic.m_setPieceMode == 1 ? 26 : 27, -1, -1);
                    }
                } else if (GameLogic.m_matchSubState == 14) {
                    if (!this.m_microGame.inProgress()) {
                        GameLogic.setPieceSaveTargetInfo();
                        GameLogic.setState(8, 13, -1, -1);
                    }
                } else if (GameLogic.m_matchSubState != 19 && GameLogic.m_matchSubState != 29 && GameLogic.m_matchSubState != 30 && GameLogic.m_matchSubState != 15 && GameLogic.m_matchState != 8 && GameLogic.m_gameMode != 99 && (GameLogic.m_gameMode != 1 || GameLogic.m_matchPeriod != 4) && (GameLogic.m_gameMode != 5 || !GameLogic.m_freeKickChallengeRoundComplete && GameLogic.m_freeKickChallengeUpdateTime)) {
                    int n2;
                    if (GameLogic.m_gameMode == 5 && (n2 = GameLogic.freeKickChallengeGetMaxTimer() * 1000 - GameLogic.m_freeKickChallengeTimeElapsed) < 100) {
                        return true;
                    }
                    if (!(GameLogic.m_setPieceMode != 0 && GameLogic.isSetPiecePassTargetAShortPass(GameLogic.setPieceGetCurrentTarget()) || XMLMenuSystem.m_menuMatchType == 4)) {
                        XMLMenuSystem.m_globalArray[1] = 0;
                        this.m_gotoSetPieceMenu = true;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void updateProcessCommandWatchlist() {
        int n2;
        int n3 = GameLogic.m_updateFrameCounter;
        if ((this.m_joystick & 0x40) != 0) {
            n2 = 5;
        }
        for (int i2 = 0; i2 < 12; ++i2) {
            int n4 = this.m_cmdLookup[i2];
            boolean bl = this.checkCommandActive(i2, this.m_joystick);
            boolean bl2 = this.checkCommandActive(i2, this.m_lastJoystickWatchValue);
            int n5 = i2 == 8 || i2 == 9 || i2 == 10 ? 5 : 5;
            n2 = this.m_cmdWatchList[i2][0];
            int n6 = this.m_cmdWatchList[i2][1];
            if (bl) {
                if (!bl2) {
                    if (i2 == 8) {
                        this.m_controlPlayerMarkingHoldFrames = 0;
                    }
                    this.m_cmdWatchList[i2][this.m_cmdWatchList[i2][3]] = n3;
                    this.m_cmdWatchList[i2][2] = 0;
                    int[] nArray = this.m_cmdWatchList[i2];
                    nArray[3] = nArray[3] ^ 1;
                    n2 = this.m_cmdWatchList[i2][0];
                    n6 = this.m_cmdWatchList[i2][1];
                    if (n2 != 0 && n6 != 0 && DDMath.abs(n2 - n6) < n5) {
                        this.processCommandAction(i2, 1);
                        this.processCommandAction(i2, 3);
                        this.resetCommandWatchList(i2);
                    }
                } else {
                    if (i2 == 8) {
                        ++this.m_controlPlayerMarkingHoldFrames;
                    }
                    int n7 = i2 < 8 ? 3 : 5;
                    int[] nArray = this.m_cmdWatchList[i2];
                    nArray[2] = nArray[2] + 1;
                    if (this.m_cmdWatchList[i2][2] == n7) {
                        this.processCommandAction(i2, 2);
                        this.resetCommandWatchList(i2);
                        if (i2 != 8 && i2 != 9) {
                            this.m_cmdWatchList[i2][2] = 0;
                        }
                    }
                }
            } else if (bl2) {
                this.processCommandAction(i2, 3);
                n2 = this.m_cmdWatchList[i2][0];
                n6 = this.m_cmdWatchList[i2][1];
            }
            n2 = this.m_cmdWatchList[i2][0];
            n6 = this.m_cmdWatchList[i2][1];
            int n8 = n5 = i2 < 8 ? 3 : n5;
            if (n2 == 0 || DDMath.abs(n3 - n2) < n5) continue;
            this.processCommandAction(i2, 0);
            this.processCommandAction(i2, 3);
            this.resetCommandWatchList(i2);
        }
    }

    private void updateInstantActions() {
        if (this.m_teamID == GameLogic.m_possession) {
            if ((this.checkCommandActive(8, this.m_joystick) || this.checkCommandActive(9, this.m_joystick)) && this.m_teamID == GameLogic.m_possession && this.m_controlPlayer != null) {
                this.m_controlPlayer[34] = GameLogic.PASS_TARGET_UPDATE_DELAY;
            }
        } else if (this.checkCommandActive(8, this.m_joystick) && this.isFireHeldLongEnoughForTackleMicrogame() && GameLogic.m_matchState == 2 && !this.m_microGame.inProgress()) {
            this.updatePlayerSelect(false);
            this.homeInOnBall();
        }
    }

    private void updateMicrogame() {
        if (this.m_microGame.inProgress()) {
            if (this.m_microGame.m_type == 1 || this.checkCommandActive(8, this.m_joystick)) {
                this.microGameUpdate();
            } else {
                this.m_microGame.cancelMicroGame();
            }
        }
    }

    private void resetCommandWatchList(int n2) {
        this.m_cmdWatchList[n2][0] = 0;
        this.m_cmdWatchList[n2][1] = 0;
        this.m_cmdWatchList[n2][3] = 0;
    }

    private boolean checkCommandActive(int n2, int n3) {
        int n4 = this.m_cmdLookup[n2];
        boolean bl = (n3 & n4) == n4;
        switch (n2) {
            case 2: 
            case 6: {
                if ((n3 & (this.m_cmdLookup[4] | this.m_cmdLookup[0])) == 0) break;
                bl = false;
                break;
            }
            case 0: 
            case 4: {
                if ((n3 & (this.m_cmdLookup[6] | this.m_cmdLookup[2])) == 0) break;
                bl = false;
                break;
            }
            case 5: {
                if ((n3 & this.m_cmdLookup[6]) == 0 || (n3 & this.m_cmdLookup[4]) == 0) break;
                bl = true;
                break;
            }
            case 7: {
                if ((n3 & this.m_cmdLookup[6]) == 0 || (n3 & this.m_cmdLookup[0]) == 0) break;
                bl = true;
                break;
            }
            case 3: {
                if ((n3 & this.m_cmdLookup[2]) == 0 || (n3 & this.m_cmdLookup[4]) == 0) break;
                bl = true;
                break;
            }
            case 1: {
                if ((n3 & this.m_cmdLookup[2]) == 0 || (n3 & this.m_cmdLookup[0]) == 0) break;
                bl = true;
            }
        }
        return bl;
    }

    protected void processCommandAction(int n2, int n3) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.processCommandActionDirection(n2, n3);
                break;
            }
            case 8: {
                this.processCommandActionPrimaryFire(n2, n3);
                break;
            }
            case 9: {
                this.processCommandActionSecondaryFire(n2, n3);
                break;
            }
            case 10: {
                this.processCommandActionStar(n2, n3);
                break;
            }
            case 11: {
                this.processCommandActionHash(n2, n3);
            }
        }
        if (GameLogic.m_gameMode == 2) {
            XMLMenuSystem.tutorialProcessCommand(n2, n3, this);
        }
    }

    protected void processCommandActionDirection(int n2, int n3) {
        if (this.m_controlPlayer != null && n3 != 3 && GameLogic.m_matchState == 2 && (this.m_controlPlayer[23] != 0 || n3 == 2)) {
            this.m_controlPlayerMoveTimer = HUMAN_CONTROL_INPUT_TIMEOUT;
        }
        switch (n3) {
            case 0: {
                this.processCommandActionDirectionSingleTap(n2, n3);
                break;
            }
            case 1: {
                this.processCommandActionDirectionDoubleTap(n2, n3);
                break;
            }
            case 2: {
                this.processCommandActionDirectionLongPress(n2, n3);
                break;
            }
            case 3: {
                this.processCommandActionDirectionReleased(n2, n3);
            }
        }
    }

    protected void processCommandActionDirectionSingleTap(int n2, int n3) {
        if ((GameLogic.m_matchState == 9 && GameLogic.m_matchSubState == 26 || GameLogic.m_matchState == 6 && GameLogic.m_matchSubState == 17 || GameLogic.m_matchState == 5 && GameLogic.m_matchSubState == 45) && GameLogic.m_possession == this.m_teamID) {
            GameLogic.setPieceCycleTarget(n2);
        } else if (GameLogic.m_matchState == 9 && GameLogic.m_matchSubState == 27 && GameLogic.m_possession == this.m_teamID || GameLogic.m_matchState == 8 && GameLogic.m_matchSubState == 13) {
            int n4 = GameLogic.m_targetMoveAmountsX[n2];
            int n5 = GameLogic.m_targetMoveAmountsZ[n2];
            if (MainFrame.m_inGameFrameRate == 12) {
                n4 *= 2;
                n5 *= 2;
            }
            int[] nArray = GameLogic.m_possession == this.m_teamID ? GameLogic.m_setPieceTargetObject : GameLogic.m_setPieceGKTargetObject;
            nArray[0] = nArray[1] < 16007 ? nArray[0] - n4 : nArray[0] + n4;
            nArray[2] = nArray[2] + n5;
            nArray[0] = DDMath.max(nArray[0], 12311 - GameLogic.m_goalWidth / 2);
            nArray[0] = DDMath.min(nArray[0], 12311 + GameLogic.m_goalWidth / 2);
            nArray[2] = DDMath.max(nArray[2], 0);
            nArray[2] = DDMath.min(nArray[2], 624);
        }
        if (!(this.m_controlPlayer == null || this.m_homeInOnBall || this.m_microGame.inProgress() && this.m_microGame.m_type == 0)) {
            this.humanDirectionalControl(this.getAngleFromCmdDirection(n2), n3);
        }
        switch (n2) {
            case 4: {
                GameRender.m_replayPlaybackControlsLeftTap = true;
                break;
            }
            case 0: {
                GameRender.m_replayPlaybackControlsRightTap = true;
            }
        }
    }

    protected void processCommandActionDirectionDoubleTap(int n2, int n3) {
        int n4;
        if ((GameLogic.m_matchState == 9 && GameLogic.m_matchSubState == 26 || GameLogic.m_matchState == 6 && GameLogic.m_matchSubState == 17 || GameLogic.m_matchState == 5 && GameLogic.m_matchSubState == 45) && GameLogic.m_possession == this.m_teamID) {
            GameLogic.setPieceCycleTarget(n2);
        }
        if (this.m_controlPlayer == null || DDMath.abs(DDMath.calcTurnAngle(n4 = GameLogic.m_possession == this.m_teamID ? GameAI.m_ballStorage[11] : this.m_controlPlayer[22], DDMath.getPitchAngleFromCmdDir(n2))) <= 32) {
            // empty if block
        }
        if (GameLogic.m_matchState == 9 && GameLogic.m_matchSubState == 27 && GameLogic.m_possession == this.m_teamID || GameLogic.m_matchState == 8 && GameLogic.m_matchSubState == 13) {
            n4 = GameLogic.m_targetMoveAmountsX[n2];
            int n5 = GameLogic.m_targetMoveAmountsZ[n2];
            if (MainFrame.m_inGameFrameRate == 12) {
                n4 *= 2;
                n5 *= 2;
            }
            int[] nArray = GameLogic.m_possession == this.m_teamID ? GameLogic.m_setPieceTargetObject : GameLogic.m_setPieceGKTargetObject;
            nArray[0] = nArray[1] < 16007 ? nArray[0] - n4 : nArray[0] + n4;
            nArray[2] = nArray[2] + n5;
            nArray[0] = DDMath.max(nArray[0], 12311 - GameLogic.m_goalWidth / 2);
            nArray[0] = DDMath.min(nArray[0], 12311 + GameLogic.m_goalWidth / 2);
            nArray[2] = DDMath.max(nArray[2], 0);
            nArray[2] = DDMath.min(nArray[2], 624);
        }
        switch (n2) {
            case 4: {
                GameRender.m_replayPlaybackControlsLeftTap = true;
                break;
            }
            case 0: {
                GameRender.m_replayPlaybackControlsRightTap = true;
            }
        }
    }

    protected void processCommandActionDirectionLongPress(int n2, int n3) {
        if (!(this.m_controlPlayer == null || this.m_hcpSprint || this.m_homeInOnBall || this.m_microGame.inProgress() && this.m_microGame.m_type == 0)) {
            this.humanDirectionalControl(this.getAngleFromCmdDirection(n2), n3);
        }
        if (GameLogic.m_matchState == 9 && GameLogic.m_matchSubState == 27 && GameLogic.m_possession == this.m_teamID || GameLogic.m_matchState == 8 && GameLogic.m_matchSubState == 13) {
            int n4 = GameLogic.m_targetMoveAmountsX[n2] * 3;
            int n5 = GameLogic.m_targetMoveAmountsZ[n2] * 3;
            int[] nArray = GameLogic.m_possession == this.m_teamID ? GameLogic.m_setPieceTargetObject : GameLogic.m_setPieceGKTargetObject;
            nArray[0] = nArray[1] < 16007 ? nArray[0] - n4 : nArray[0] + n4;
            nArray[2] = nArray[2] + n5;
            nArray[0] = DDMath.max(nArray[0], 12311 - GameLogic.m_goalWidth / 2);
            nArray[0] = DDMath.min(nArray[0], 12311 + GameLogic.m_goalWidth / 2);
            nArray[2] = DDMath.max(nArray[2], 0);
            nArray[2] = DDMath.min(nArray[2], 624);
        }
        if ((GameLogic.m_matchState == 9 && GameLogic.m_matchSubState == 26 || GameLogic.m_matchState == 6 && GameLogic.m_matchSubState == 17 || GameLogic.m_matchState == 5 && GameLogic.m_matchSubState == 45) && GameLogic.m_possession == this.m_teamID) {
            GameLogic.setPieceCycleTarget(n2);
        }
        switch (n2) {
            case 4: {
                GameRender.m_replayPlaybackControlsLeftHold = true;
                break;
            }
            case 0: {
                GameRender.m_replayPlaybackControlsRightHold = true;
            }
        }
    }

    protected void processCommandActionDirectionReleased(int n2, int n3) {
        switch (n2) {
            case 4: {
                GameRender.m_replayPlaybackControlsLeftHold = false;
                break;
            }
            case 0: {
                GameRender.m_replayPlaybackControlsRightHold = false;
            }
        }
        this.m_hcpSprint = false;
        this.m_hcpSprintTimer = 0;
        GameLogic.m_movingSetPieceTarget = -1;
    }

    protected void processCommandActionPrimaryFire(int n2, int n3) {
        this.m_ishumankey = true;
        switch (n3) {
            case 0: {
                this.processCommandActionPrimaryFireSingleTap(n2, n3);
                break;
            }
            case 1: {
                this.processCommandActionPrimaryFireDoubleTap(n2, n3);
                break;
            }
            case 2: {
                this.processCommandActionPrimaryFireLongPress(n2, n3);
                break;
            }
            case 3: {
                this.processCommandActionPrimaryFireReleased(n2, n3);
            }
        }
        this.m_ishumankey = false;
    }

    protected void processCommandActionPrimaryFireSingleTap(int n2, int n3) {
        this.setSkipKey();
        if (GameLogic.m_possession != this.m_teamID && GameLogic.m_matchState == 2) {
            boolean bl = this.m_forcePlayerSelect = !this.m_hashBeenPressed;
        }
        if (GameRender.m_fadeState == 2 && (GameLogic.m_matchState == 12 || GameLogic.m_matchState == 3 || GameLogic.m_matchState == 9 || GameLogic.m_matchState == 17 || GameLogic.m_matchState == 6 || GameLogic.m_matchState == 19 || GameLogic.m_matchState == 8 && GameLogic.m_matchSubState == 12 || GameLogic.m_matchState == 1 && (GameLogic.m_matchSubState == 11 || GameLogic.m_matchSubState == 1 || GameLogic.m_matchSubState == 2 || GameLogic.m_matchSubState == 3 || GameLogic.m_matchSubState == 4 || GameLogic.m_matchSubState == 8 || GameLogic.m_matchSubState == 9) || GameLogic.m_matchState == 18)) {
            if ((GameLogic.m_matchState != 1 || GameLogic.m_matchSubState != 2 && GameLogic.m_matchSubState != 3 || GameLogic.m_prematchLineupCurrentTeam >= 2) && !GameLogic.m_quickPlayMomentAvailable && HumanController.bluetoothSafeToHardSetStateTimerToZero() && GameLogic.m_stateTimer > 1) {
                GameLogic.m_stateTimer = 1;
            }
            boolean bl = this.m_buttonThrough = !this.m_hashBeenPressed;
        }
        if (this.m_controlPlayer != null && (this.m_controlPlayer[28] == 153 || this.m_controlPlayer[28] == 192 || this.m_controlPlayer[28] == 163 || this.m_controlPlayer[28] == 164 || this.m_controlPlayer[28] == 165)) {
            this.m_passBall = true;
        } else if (!(GameLogic.isFreeBallSituation() && GameLogic.m_matchState == 2 || GameLogic.m_possession != this.m_teamID || GameLogic.m_matchState == 2 && this.m_controlPlayer == null)) {
            if (GameLogic.m_gameMode != 2 || XMLMenuSystem.m_currTutorial != 2) {
                if (GameLogic.m_matchState == 2) {
                    if (this.m_controlPlayer != null && (GameAI.m_ballStorage[6] & 0x10) == 0) {
                        if ((GameAI.m_ballStorage[6] & 4) != 0) {
                            this.m_controlPlayer[32] = GameAI.findAlternativePassTarget(this.m_controlPlayer, this.m_teamID);
                            this.m_firstTimePass = true;
                        }
                        this.initPass(0, this.m_controlPlayer);
                        if (this.m_passBall || this.m_crossBall) {
                            GameAI.setupRunOntoBall(this.m_controlPlayer, this.m_passBall ? 3 : 2);
                        }
                    }
                } else {
                    if (this.m_hashBeenPressed) {
                        return;
                    }
                    if (GameLogic.m_matchState == 5 && GameLogic.m_matchSubState == 45) {
                        int[] nArray = GameAI.getPassTarget(GameLogic.m_setPieceTaker);
                        if (nArray == null) {
                            nArray = GameLogic.nearestPlayerData(GameLogic.m_setPieceTaker, this.m_teamID, 0);
                            GameAI.setPassTarget(GameLogic.m_setPieceTaker, nArray);
                        }
                        this.m_passBall = true;
                    } else if (GameLogic.m_matchState == 17 && GameLogic.m_matchSubState == 40 || GameLogic.m_matchState == 14) {
                        if (GameLogic.m_setPieceTaker != null && GameLogic.m_setPieceTaker[28] == 12 && GameLogic.m_setPieceTaker[32] != -1) {
                            if (GameLogic.m_matchState == 14) {
                                if (GameLogic.quickPlayMomentIsKeeperThrowoutShortTargetGood()) {
                                    GameLogic.m_setPieceTaker[33] = -1;
                                } else {
                                    GameLogic.m_setPieceTaker[32] = GameLogic.m_setPieceTaker[33];
                                }
                            } else {
                                GameLogic.m_setPieceTaker[33] = -1;
                            }
                            this.m_passBall = true;
                        }
                    } else if (!this.processCornerFreeKickAimMode() && GameLogic.m_matchState == 8 && GameLogic.m_setPieceTaker[28] == 12 && GameLogic.m_setPieceTaker != null && GameLogic.m_matchSubState == 13) {
                        GameLogic.setState(8, 14, 2, -1);
                    }
                }
            }
        } else if (GameLogic.m_matchState == 8 && GameLogic.m_matchSubState == 13 && GameLogic.m_possession != this.m_teamID && XMLMenuSystem.m_menuMatchType != 4) {
            GameLogic.m_setPieceShotType = true;
            GameLogic.m_controller[this.m_teamID ^ 1].m_shootBall = true;
            GameAI.m_idealShotType = 3;
            GameLogic.m_useGKDivePosition = true;
        } else {
            this.m_forcePlayerSelect = true;
        }
    }

    protected void processCommandActionPrimaryFireDoubleTap(int n2, int n3) {
        if (GameRender.m_fadeState == 2 && (GameLogic.m_matchState == 12 || GameLogic.m_matchState == 3 || GameLogic.m_matchState == 9 || GameLogic.m_matchState == 17 || GameLogic.m_matchState == 19) || GameLogic.m_matchState == 1 && (GameLogic.m_matchSubState == 11 || GameLogic.m_matchSubState == 1 || GameLogic.m_matchSubState == 2 || GameLogic.m_matchSubState == 3 || GameLogic.m_matchSubState == 4 || GameLogic.m_matchSubState == 8 || GameLogic.m_matchSubState == 9) || GameLogic.m_matchState == 18 || GameLogic.m_matchState == 6 && GameLogic.m_matchSubState == 16 || GameLogic.m_matchState == 8 && GameLogic.m_matchSubState == 12) {
            if ((GameLogic.m_matchState != 1 || GameLogic.m_matchSubState != 2 && GameLogic.m_matchSubState != 3 || GameLogic.m_prematchLineupCurrentTeam >= 2) && HumanController.bluetoothSafeToHardSetStateTimerToZero() && GameLogic.m_stateTimer > 1) {
                GameLogic.m_stateTimer = 1;
            }
            this.m_buttonThrough = true;
        }
        if (this.m_controlPlayer != null) {
            if (this.m_controlPlayer[28] == 153 || this.m_controlPlayer[28] == 192 || this.m_controlPlayer[28] == 163 || this.m_controlPlayer[28] == 164 || this.m_controlPlayer[28] == 165) {
                this.m_passBall = true;
            } else if (GameLogic.m_possession == this.m_teamID) {
                if (GameLogic.m_matchState == 2 && (GameAI.m_ballStorage[6] & 0x10) == 0) {
                    this.initPass(1, this.m_controlPlayer);
                    if (this.m_passBallAndRun || this.m_crossBall) {
                        GameAI.setupRunOntoBall(this.m_controlPlayer, this.m_passBallAndRun ? 3 : 2);
                    }
                }
            } else {
                this.m_forcePlayerSelect = true;
            }
        }
    }

    protected void processCommandActionPrimaryFireLongPress(int n2, int n3) {
        if (GameRender.m_fadeState == 2 && (GameLogic.m_matchState == 12 || GameLogic.m_matchState == 3 || GameLogic.m_matchState == 9 || GameLogic.m_matchState == 17 || GameLogic.m_matchState == 19) || GameLogic.m_matchState == 1 && (GameLogic.m_matchSubState == 11 || GameLogic.m_matchSubState == 1 || GameLogic.m_matchSubState == 2 || GameLogic.m_matchSubState == 3 || GameLogic.m_matchSubState == 4 || GameLogic.m_matchSubState == 8 || GameLogic.m_matchSubState == 9) || GameLogic.m_matchState == 18 || GameLogic.m_matchState == 6 && GameLogic.m_matchSubState == 16 || GameLogic.m_matchState == 8 && GameLogic.m_matchSubState == 12) {
            if ((GameLogic.m_matchState != 1 || GameLogic.m_matchSubState != 2 && GameLogic.m_matchSubState != 3 || GameLogic.m_prematchLineupCurrentTeam >= 2) && HumanController.bluetoothSafeToHardSetStateTimerToZero() && GameLogic.m_stateTimer > 1) {
                GameLogic.m_stateTimer = 1;
            }
            boolean bl = this.m_buttonThrough = !this.m_hashBeenPressed;
        }
        if (this.m_controlPlayer != null && (this.m_controlPlayer[28] == 153 || this.m_controlPlayer[28] == 192 || this.m_controlPlayer[28] == 163 || this.m_controlPlayer[28] == 164 || this.m_controlPlayer[28] == 165)) {
            this.m_passBall = true;
        } else if (GameLogic.m_possession == this.m_teamID) {
            if (!this.m_hashBeenPressed && GameLogic.m_matchState == 8 && GameLogic.m_setPieceTaker[28] == 12) {
                if (GameLogic.m_setPieceTaker != null && GameLogic.m_matchSubState == 13) {
                    GameLogic.setState(8, 14, 2, -1);
                }
            } else if (!(!this.m_hashBeenPressed && GameLogic.m_matchState == 5 || !this.m_hashBeenPressed && this.processGoalKickAlternatePassTarget())) {
                if (!this.m_hashBeenPressed && GameLogic.m_matchState == 9 && GameLogic.m_matchSubState == 28) {
                    if (GameLogic.m_setPieceMode == 1 && !GameLogic.isSetPiecePassTargetAShortPass(GameLogic.setPieceGetCurrentTarget()) && GameLogic.m_setPieceTaker != null) {
                        this.m_passBallUseAlternateTarget = false;
                        this.initPass(2, GameLogic.m_setPieceTaker);
                        this.m_setPieceLongPass = true;
                        if (GameLogic.m_matchState == 9 && GameLogic.m_matchSubState == 28) {
                            this.initPass(3, GameLogic.m_setPieceTaker);
                        } else {
                            this.initPass(3, this.m_controlPlayer);
                        }
                        if (this.m_passBall || this.m_crossBall) {
                            GameAI.setupRunOntoBall(this.m_controlPlayer, this.m_passBall ? 3 : 2);
                        }
                        this.m_longPass = true;
                    }
                } else if ((this.m_hashBeenPressed || !this.processCornerFreeKickAimMode()) && this.m_controlPlayer != null && GameAI.ballWasPossessedLastFrame() && (GameAI.m_ballStorage[6] & 0x10) == 0) {
                    this.m_passBallUseAlternateTarget = false;
                    this.initPass(2, this.m_controlPlayer);
                    if (!this.m_kickBallForwards && (this.m_passBallUseAlternateTarget || this.m_controlPlayer[32] != 0)) {
                        if (!this.m_hashBeenPressed && GameLogic.m_matchState == 9 && GameLogic.m_matchSubState == 28) {
                            this.initPass(3, GameLogic.m_setPieceTaker);
                        } else {
                            this.initPass(3, this.m_controlPlayer);
                        }
                        if (this.m_passBall || this.m_crossBall) {
                            GameAI.setupRunOntoBall(this.m_controlPlayer, this.m_passBall ? 3 : 2);
                        }
                    } else {
                        GameLogic.m_lockPassTargetsPlayer = null;
                    }
                }
            }
        }
        if (GameLogic.m_possession != this.m_teamID && GameLogic.m_matchState == 2) {
            this.updatePlayerSelect(false);
            this.homeInOnBall();
        }
    }

    protected void processCommandActionPrimaryFireReleased(int n2, int n3) {
        if (this.m_microGame.inProgress() && !this.m_hashBeenPressed) {
            if (this.m_controlPlayer != null) {
                if (this.m_microGame.m_type == 0) {
                    if (!this.isFireHeldLongEnoughForTackleMicrogame()) {
                        this.m_microGame.cancelMicroGame();
                    } else if (GameLogic.m_possession != this.m_teamID) {
                        this.m_microGame.setMark();
                        if (this.m_controlPlayer[36] <= 2) {
                            if (this.m_microGame.getResult() == 1 && DDMath.getPositiveRandom() % 100 < 70) {
                                GameAI.playerSetState(this.m_controlPlayer, 0, 0, 60);
                            } else {
                                this.m_microGameTackle = true;
                                GameAI.playerSetState(this.m_controlPlayer, 0, 0, 59);
                                this.m_controlPlayer[6] = this.m_controlPlayer[6] | 0x20;
                            }
                        } else {
                            this.m_microGameTackle = true;
                            GameAI.playerSetState(this.m_controlPlayer, 0, 0, 91);
                        }
                    }
                }
            } else {
                this.m_microGame.cancelMicroGame();
            }
        } else if (GameLogic.isDefensiveHeaderAllowed(this.m_teamID)) {
            this.m_defensiveHeaderClearance = true;
            this.m_framesSinceDefensiveHeaderTriggered = 0;
        }
        if (this.m_homeInOnBall) {
            this.m_homeInOnBall = false;
        }
    }

    protected void processCommandActionSecondaryFire(int n2, int n3) {
        switch (n3) {
            case 0: {
                this.processCommandActionSecondaryFireSingleTap(n2, n3);
                break;
            }
            case 1: {
                this.processCommandActionSecondaryFireDoubleTap(n2, n3);
                break;
            }
            case 2: {
                this.processCommandActionSecondaryFireLongPress(n2, n3);
                break;
            }
            case 3: {
                this.processCommandActionSecondaryFireReleased(n2, n3);
            }
        }
    }

    protected void processCommandActionSecondaryFireSingleTap(int n2, int n3) {
        if (GameLogic.m_gameMode == 2 && XMLMenuSystem.m_currTutorial == 2 && XMLMenuSystem.m_currSubTutorial != 1) {
            return;
        }
        if (GameLogic.m_matchState == 8 && GameLogic.m_setPieceTaker != null && GameLogic.m_setPieceTaker[28] == 12 && GameLogic.m_possession == this.m_teamID) {
            if (GameLogic.m_matchSubState == 13) {
                GameLogic.setState(8, 14, 2, -1);
            }
        } else if (this.m_controlPlayer != null && GameLogic.m_matchState != 13 && GameLogic.m_matchState != 9) {
            if (GameLogic.m_possession == this.m_teamID || GameLogic.isFreeBallSituation()) {
                if ((GameAI.m_ballStorage[6] & 8) != 0) {
                    this.m_shootBall = true;
                    GameAI.m_idealShotType = 2;
                } else if (GameLogic.m_gameMode != 2 || XMLMenuSystem.m_currTutorial != 5) {
                    if (!GameLogic.isObjectInOwnHalf(this.m_teamID, GameAI.m_ballStorage)) {
                        this.m_shootBall = true;
                        GameAI.m_idealShotType = 2;
                        GameAI.setupRunOntoBall(this.m_controlPlayer, 0);
                    } else {
                        this.m_clearBall = true;
                        GameAI.setupRunOntoBall(this.m_controlPlayer, 1);
                    }
                }
            }
        } else if (!this.processCornerFreeKickAimMode() && GameLogic.m_matchState == 8 && GameLogic.m_matchSubState == 13 && GameLogic.m_possession != this.m_teamID && XMLMenuSystem.m_menuMatchType != 4) {
            GameLogic.m_setPieceShotType = true;
            GameLogic.m_controller[this.m_teamID ^ 1].m_shootBall = true;
            GameAI.m_idealShotType = 3;
            GameLogic.m_useGKDivePosition = true;
        }
    }

    protected void processCommandActionSecondaryFireDoubleTap(int n2, int n3) {
        if (GameLogic.m_gameMode == 2 && XMLMenuSystem.m_currTutorial == 2 && XMLMenuSystem.m_currSubTutorial != 2) {
            return;
        }
        if (GameLogic.m_matchState == 8 && GameLogic.m_setPieceTaker != null && GameLogic.m_setPieceTaker[28] == 12 && GameLogic.m_possession == this.m_teamID) {
            if (GameLogic.m_matchSubState == 13) {
                GameLogic.setState(8, 14, 2, -1);
                return;
            }
        } else if (this.processCornerFreeKickAimMode()) {
            return;
        }
        if (this.m_controlPlayer != null && (GameLogic.m_possession == this.m_teamID || GameLogic.isFreeBallSituation())) {
            if ((GameAI.m_ballStorage[6] & 8) != 0) {
                if (!GameLogic.isObjectInOwnHalf(this.m_teamID, GameAI.m_ballStorage)) {
                    this.m_shootBall = true;
                } else {
                    this.m_clearBall = true;
                }
            } else if (!GameLogic.isObjectInOwnHalf(this.m_teamID, GameAI.m_ballStorage)) {
                if (GameLogic.m_matchState == 2) {
                    this.m_shootBall = true;
                    GameAI.m_idealShotType = 1;
                    GameAI.setupRunOntoBall(this.m_controlPlayer, 0);
                }
            } else {
                this.m_clearBall = true;
            }
        }
    }

    protected void processCommandActionSecondaryFireLongPress(int n2, int n3) {
        if (GameLogic.m_gameMode == 2 && XMLMenuSystem.m_currTutorial == 2 && XMLMenuSystem.m_currSubTutorial != 0) {
            return;
        }
        if (GameLogic.m_matchState == 8 && GameLogic.m_setPieceTaker != null && GameLogic.m_setPieceTaker[28] == 12 && GameLogic.m_possession == this.m_teamID) {
            if (GameLogic.m_matchSubState == 13) {
                GameLogic.setState(8, 14, 2, -1);
                return;
            }
        } else if (this.longFreeKickAimMode()) {
            return;
        }
        if (GameLogic.m_possession == this.m_teamID || GameLogic.isFreeBallSituation()) {
            if (GameLogic.m_gameMode == 99 || GameLogic.m_gameMode == 1 && GameLogic.m_matchPeriod == 4) {
                this.m_controlPlayer = null;
            }
            if (GameLogic.m_matchState == 2) {
                if (this.m_controlPlayer != null) {
                    if (GameAI.ballIsInACross()) {
                        this.m_shootBall = true;
                    } else {
                        int n4 = GameLogic.m_possession;
                        if (GameAI.teamGetControlType(GameLogic.m_possession) == 0) {
                            n4 = GameLogic.m_possession ^ 1;
                        }
                        if (!(GameLogic.isObjectInOwnHalf(n4, GameAI.m_ballStorage) || GameLogic.m_gameMode != 1 && GameLogic.m_gameMode != 2)) {
                            GameAI.m_idealShotType = 0;
                            this.m_microGame.init(this.m_controlPlayer, 3, 3000, 1, this.m_controlPlayer[38]);
                            this.microGameUpdate();
                        } else {
                            this.m_clearBall = true;
                            GameAI.setupRunOntoBall(this.m_controlPlayer, 1);
                        }
                    }
                } else {
                    this.m_controlPlayer = null;
                }
            } else if (GameLogic.m_setPieceTaker != null && GameLogic.m_possession == this.m_teamID) {
                if (GameLogic.m_matchState == 8 && GameLogic.m_setPieceTaker[28] == 12) {
                    if (GameLogic.m_matchSubState == 14) {
                        GameLogic.m_useGKDivePosition = true;
                        GameAI.m_idealShotType = 3;
                        this.m_microGame.init(GameLogic.m_setPieceTaker, 3, 9999999, 1, 0);
                        this.microGameUpdate();
                    }
                } else if (GameLogic.m_matchState == 9 && GameLogic.m_matchSubState == 28 && GameLogic.m_setPieceTaker[28] == 12 && !this.m_blockShoot && GameLogic.m_setPieceMode == 0) {
                    GameLogic.m_useGKDivePosition = false;
                    GameAI.m_idealShotType = 3;
                    this.m_microGame.init(GameLogic.m_setPieceTaker, 3, 3000, 1, 0);
                    this.microGameUpdate();
                }
            }
        }
    }

    protected void processCommandActionSecondaryFireReleased(int n2, int n3) {
        this.m_blockShoot = false;
        if (this.m_microGame.inProgress()) {
            this.m_microGame.setMark();
            if (GameLogic.m_possession == this.m_teamID || GameLogic.isFreeBallSituation()) {
                this.m_shootBall = true;
                GameAI.setupRunOntoBall(this.m_controlPlayer, 0);
            }
        } else if (!this.processGoalKickAlternatePassTarget() && GameLogic.isDefensiveHeaderAllowed(this.m_teamID)) {
            this.m_defensiveHeaderClearance = true;
            this.m_framesSinceDefensiveHeaderTriggered = 0;
        }
    }

    protected void processCommandActionHash(int n2, int n3) {
        if (XMLMenuSystem.m_tacticsPassing != 0) {
            this.m_hashBeenPressed = true;
            this.m_ishumankey = true;
            switch (n3) {
                case 0: {
                    this.processCommandActionHashSingleTap(n2, n3);
                    break;
                }
                case 1: {
                    this.processCommandActionHashDoubleTap(n2, n3);
                    break;
                }
                case 2: {
                    this.processCommandActionHashLongPress(n2, n3);
                    break;
                }
                case 3: {
                    this.processCommandActionHashReleased(n2, n3);
                }
            }
            this.m_hashBeenPressed = false;
            this.m_ishumankey = false;
        }
    }

    protected void processCommandActionHashSingleTap(int n2, int n3) {
        this.processCommandActionPrimaryFireSingleTap(n2, n3);
    }

    protected void processCommandActionHashDoubleTap(int n2, int n3) {
    }

    protected void processCommandActionHashLongPress(int n2, int n3) {
        this.processCommandActionPrimaryFireLongPress(n2, n3);
    }

    protected void processCommandActionHashReleased(int n2, int n3) {
        this.processCommandActionPrimaryFireReleased(n2, n3);
    }

    protected void processCommandActionStar(int n2, int n3) {
        switch (n3) {
            case 0: {
                this.processCommandActionStarSingleTap(n2, n3);
                break;
            }
            case 1: {
                this.processCommandActionStarDoubleTap(n2, n3);
                break;
            }
            case 2: {
                this.processCommandActionStarLongPress(n2, n3);
                break;
            }
            case 3: {
                this.processCommandActionStarReleased(n2, n3);
            }
        }
    }

    protected void processCommandActionStarSingleTap(int n2, int n3) {
        if (GameLogic.m_matchState == 2) {
            if (!this.m_hcpSprint && this.m_controlPlayer != null && (this.m_controlPlayer[17] & 0x200) == 0) {
                this.m_controlPlayer[75] = this.m_controlPlayer[75] + 1;
                GameLogic.beAProCheckIfBAPStatAchieved(7, this.m_controlPlayer, null);
                this.m_hcpSprint = true;
            } else {
                this.m_hcpSprint = false;
            }
        }
    }

    protected void processCommandActionStarDoubleTap(int n2, int n3) {
    }

    protected void processCommandActionStarLongPress(int n2, int n3) {
        if (GameLogic.m_matchState == 2) {
            if (!this.m_hcpSprint && this.m_controlPlayer != null && (this.m_controlPlayer[17] & 0x200) == 0) {
                this.m_controlPlayer[75] = this.m_controlPlayer[75] + 1;
                GameLogic.beAProCheckIfBAPStatAchieved(7, this.m_controlPlayer, null);
            }
            this.m_hcpSprint = true;
        } else {
            this.m_movingCameraAlongTheTrajectoryLine = true;
        }
    }

    protected void processCommandActionStarReleased(int n2, int n3) {
        this.m_hcpSprint = false;
        this.m_movingCameraAlongTheTrajectoryLine = false;
    }

    protected boolean longFreeKickAimMode() {
        if (GameLogic.m_matchState == 9 || GameLogic.m_matchState == 6) {
            if (this.m_teamID != GameLogic.m_possession) {
                return true;
            }
            if (GameLogic.m_matchSubState == 26 || GameLogic.m_matchSubState == 27 && GameRender.canMoveAimLine() || GameLogic.m_matchSubState == 17) {
                if (GameLogic.m_matchSubState == 26 || GameLogic.m_matchSubState == 27) {
                    GameLogic.setState(9, 28, -1, -1);
                } else {
                    GameLogic.setState(6, 18, -1, -1);
                }
                return true;
            }
        }
        return false;
    }

    protected boolean processCornerFreeKickAimMode() {
        if (GameLogic.m_matchState == 9 || GameLogic.m_matchState == 6) {
            if (this.m_teamID != GameLogic.m_possession) {
                return true;
            }
            if (GameLogic.m_matchSubState == 26 || GameLogic.m_matchSubState == 27 && GameRender.canMoveAimLine() || GameLogic.m_matchSubState == 17) {
                if (GameLogic.m_matchSubState == 26 || GameLogic.m_matchSubState == 27) {
                    GameLogic.setState(9, 28, -1, -1);
                } else {
                    GameLogic.setState(6, 18, -1, -1);
                }
            } else if (GameLogic.m_matchSubState == 28) {
                this.m_passBall = true;
            }
            return true;
        }
        return false;
    }

    protected boolean processGoalKickAlternatePassTarget() {
        if ((GameLogic.m_matchState == 17 && GameLogic.m_matchSubState == 40 || GameLogic.m_matchState == 14) && GameLogic.m_setPieceTaker != null && GameLogic.m_setPieceTaker[28] == 12 && GameLogic.m_setPieceTaker[33] != -1) {
            GameFormation.jumpPlayersToTheirPositions();
            this.m_passBall = true;
            this.m_longGoalKick = true;
            return true;
        }
        return false;
    }

    public void updatePlayerSelect(boolean bl) {
        int[] nArray = new int[]{1000, -1};
        int[] nArray2 = new int[]{1000, -1};
        int[] nArray3 = new int[]{1000, -1};
        int[] nArray4 = new int[]{1000, -1};
        int n2 = Trajectory.isBallUnderTrajectoryControl() ? DDMath.atan(GameAI.m_ballStorage[3], GameAI.m_ballStorage[4]) : GameAI.m_ballStorage[11];
        for (int i2 = 1; i2 < 11; ++i2) {
            int n3;
            int n4;
            int[] nArray5 = GameAI.m_playerStorage[this.m_teamID][i2];
            if (nArray5[30] > 0 && nArray5[28] != 93 && nArray5[28] != 0 && nArray5[28] != 71 && nArray5[28] != 139 && nArray5[28] != 69 || nArray5[28] == 38 || nArray5[28] == 191 || nArray5[28] == 190 || nArray5[49] == 2 || bl && this.m_controlPlayer != null && i2 == this.m_controlPlayer[9]) {
                DDDebug.msg("Selection: Player Ignored; Player ID = " + i2 + ", State = " + nArray5[28] + ", OOP Timer: " + nArray5[30]);
                continue;
            }
            if (Trajectory.isBallUnderTrajectoryControl() && Trajectory.getPercentageCompleted(0) > 40) {
                int n5 = Trajectory.getEndX(0) - nArray5[0] >> 8;
                int n6 = Trajectory.getEndY(0) - nArray5[1] >> 8;
                n4 = DDMath.sqrtRout(n5 * n5 + n6 * n6);
                n3 = DDMath.atan(n5, n6);
            } else {
                n4 = nArray5[36];
                n3 = nArray5[35] + 128 & 0xFF;
            }
            int n7 = DDMath.CalcModDifference(n3, n2);
            DDDebug.msg("Selection: Player: " + i2 + " Dist = " + n4 + ", Angle = " + n7 + ", Player Ball DIR = " + n3 + ", balldir = " + n2);
            if (n4 < nArray[0] && n4 < 25 && n7 < 32) {
                nArray[0] = n4;
                nArray[1] = i2;
            } else if (n4 < 12 && n4 < nArray2[0]) {
                nArray2[0] = n4;
                nArray2[1] = i2;
            } else if (n4 < 25 && n4 < nArray3[0]) {
                nArray3[0] = n4;
                nArray3[1] = i2;
            }
            if (n4 >= nArray4[0]) continue;
            nArray4[0] = n4;
            nArray4[1] = i2;
        }
        if (nArray4[1] > 0 && nArray4[0] < 5) {
            this.m_controlPlayer = GameAI.m_playerStorage[this.m_teamID][nArray4[1]];
        } else if (nArray[1] > 0) {
            this.m_controlPlayer = GameAI.m_playerStorage[this.m_teamID][nArray[1]];
        } else if (nArray2[1] > 0) {
            this.m_controlPlayer = GameAI.m_playerStorage[this.m_teamID][nArray2[1]];
        } else if (nArray3[1] > 0) {
            this.m_controlPlayer = GameAI.m_playerStorage[this.m_teamID][nArray3[1]];
        } else if (nArray4[1] > 0) {
            this.m_controlPlayer = GameAI.m_playerStorage[this.m_teamID][nArray4[1]];
        }
        if (this.m_controlPlayer != null && this.m_controlPlayer[28] != 13 && this.m_controlPlayer[28] != 139 && this.m_controlPlayer[28] != 10) {
            GameAI.playerSetState(this.m_controlPlayer, 0, 0, 13);
        }
        this.m_forcePlayerSelect = false;
    }

    public boolean assessNeedForPlayerSelect() {
        if (this.m_microGame.inProgress()) {
            return false;
        }
        if (GameLogic.m_gameMode == 2 && this.m_controlPlayer != null && this.m_controlPlayer[28] == 91) {
            return false;
        }
        if (this.m_controlPlayer != null && (this.m_controlPlayer[28] == 9 || this.m_controlPlayer[28] == 138 || this.m_controlPlayer[28] == 139 || this.m_controlPlayer[28] == 32 || this.m_controlPlayer[28] == 140)) {
            if (this.m_forcePlayerSelect) {
                if (this.m_controlPlayer[28] == 138) {
                    DDDebug.msg("Selection: Human Controlled Player is in PSTATE_GRAPPLING_AND_HAS_BALL! NOT CHANGING MAN");
                } else if (this.m_controlPlayer[28] == 139) {
                    DDDebug.msg("Selection: Human Controlled Player is in PSTATE_GRAPPLING_DOESNT_HAVE_BALL! NOT CHANGING MAN");
                } else {
                    DDDebug.msg("Selection: Human Controlled Player is in PSTATE_DRIBBLE! NOT CHANGING MAN");
                }
            }
            return false;
        }
        if (GameAI.ballIsPossessed() && GameAI.ballGetLastTouchPlayerID() == 0) {
            return false;
        }
        if (this.m_controlPlayer != null && (this.m_controlPlayer[28] == 153 || this.m_controlPlayer[28] == 10 || this.m_controlPlayer[28] == 163 || this.m_controlPlayer[28] == 165 || this.m_controlPlayer[28] == 164 || this.m_controlPlayer[28] == 70 || this.m_controlPlayer[28] == 170 || this.m_controlPlayer[28] == 169 || this.m_controlPlayer[28] == 192 || this.m_controlPlayer[28] == 184)) {
            return false;
        }
        return this.m_forcePlayerSelect || this.m_controlPlayer == null || this.m_controlPlayer[30] > 0 && this.m_controlPlayer[28] != 32 && this.m_controlPlayer[28] != 138 && this.m_controlPlayer[28] != 139;
    }

    public void humanDirectionalControl(int n2, int n3) {
        int[] nArray = this.m_controlPlayer;
        if (this.m_passBall || this.m_crossBall || this.m_throughBall) {
            return;
        }
        if (nArray[28] == 9 || nArray[28] == 138 || nArray[28] == 10) {
            int n4;
            int n5;
            int n6;
            int n7;
            int[] nArray2;
            if (nArray[28] == 138 && (nArray2 = GameAI.playerGetMarkTarget(nArray)) != null) {
                n7 = DDMath.calcAngle(nArray, nArray2);
                if (DDMath.calcHorizontalDistSquared(nArray, nArray2) < 262144) {
                    n7 = nArray[22] + (DDMath.calcTurnAngle(nArray[22], n7) > 0 ? 1 : -1) * 64;
                }
                if (DDMath.angleRangeCheck(n2, n6 = n7 - 49 & 0xFF, n5 = n7 + 49 & 0xFF)) {
                    n4 = GameAI.m_ballStorage[11];
                    n2 = DDMath.CalcModDifference(n6, n4) < DDMath.CalcModDifference(n5, n4) ? n6 : n5;
                }
            }
            int n8 = n5 = (n6 = DDMath.abs(n7 = DDMath.calcTurnAngle(GameAI.m_ballStorage[11], n2))) < 96 ? 1 : 0;
            if (n5 != 0) {
                this.m_180turn = false;
            }
            if (n3 == 2) {
                if (n5 == 0 && nArray[60] != 48 && nArray[60] != 75 && nArray[53] > 5) {
                    GameAI.m_plrRunOntoBallDir = -1;
                    this.m_quickStop = false;
                    this.m_180turn = true;
                }
            } else if (n5 == 0) {
                this.m_180turn = false;
                this.m_quickStop = false;
                GameAI.m_plrRunOntoBallDir = -1;
                if (nArray[23] != 0) {
                    this.m_quickStop = true;
                    n2 = GameAI.m_ballStorage[11];
                } else if (nArray[60] != 48 && nArray[60] != 75) {
                    this.m_180turn = true;
                }
            }
            if (n5 != 0 && nArray[28] == 10) {
                GameAI.m_plrRunOntoBallDir = n2;
            } else if (n5 != 0 && nArray[23] > 0) {
                n4 = DDMath.calcTurnAngle(GameAI.m_ballStorage[11], n2);
                if (DDMath.abs(n4) > 19) {
                    if (n4 > 0) {
                        GameAI.ballSetDribbleDirection(GameAI.m_ballStorage[11] + 19);
                    } else {
                        GameAI.ballSetDribbleDirection(GameAI.m_ballStorage[11] - 19);
                    }
                } else {
                    GameAI.ballSetDribbleDirection(n2);
                }
            } else {
                GameAI.ballSetDribbleDirection(n2);
            }
        } else if (nArray[28] == 13) {
            int[] nArray3 = GameAI.ballGetLastTouchPlayer();
            int n9 = DDMath.calcTurnAngle(nArray[35], n2);
            int n10 = DDMath.abs(n9);
            if (n10 < 16 && nArray[36] < 15) {
                if ((GameAI.m_ballStorage[6] & 0x20) != 0 && nArray3[28] == 9 && nArray3[36] < nArray[36]) {
                    int n11;
                    int n12;
                    int n13 = DDMath.calcTurnAngle(nArray[35], nArray3[22]);
                    if (n13 > 0) {
                        n12 = nArray3[0] + (DDMath.sin(nArray3[22] + 16) * 2 >> 8) - nArray[0];
                        n11 = nArray3[1] + (DDMath.cos(nArray3[22] + 16) * 2 >> 8) - nArray[1];
                    } else {
                        n12 = nArray3[0] + (DDMath.sin(nArray3[22] - 16) * 2 >> 8) - nArray[0];
                        n11 = nArray3[1] + (DDMath.cos(nArray3[22] - 16) * 2 >> 8) - nArray[1];
                    }
                    n2 = DDMath.atan(n12, n11);
                } else {
                    n2 = nArray[35];
                }
                nArray[17] = Trajectory.isBallUnderTrajectoryControl() ? 264 : 260;
            } else {
                nArray[17] = 4352;
            }
            nArray[21] = n2;
        } else if (nArray[28] == 139) {
            int[] nArray4 = GameAI.m_playerStorage[GameLogic.m_possession][nArray[54]];
            int n14 = DDMath.calcAngle(nArray, nArray4);
            int n15 = DDMath.calcHorizontalDistSquared(nArray, nArray4);
            int n16 = n14 - 49 & 0xFF;
            int n17 = n14 + 49 & 0xFF;
            if (DDMath.calcHorizontalDistSquared(nArray, nArray4) < 262144 && DDMath.angleRangeCheck(n2, n16, n17)) {
                this.m_bargePlayer = true;
            } else {
                if (n15 < 188498) {
                    n14 = nArray4[22];
                }
                if (DDMath.CalcModDifference(n2, n14) > 71) {
                    this.m_forceBreakAway = true;
                }
            }
        } else if (nArray[28] != 12 && nArray[28] == 10) {
            int n18 = DDMath.calcTurnAngle(nArray[35], n2);
            int n19 = DDMath.abs(n18);
            nArray[22] = n19 < 64 ? n2 : nArray[35] + (n18 > 0 ? 64 : -64);
            nArray[21] = nArray[22];
            GameAI.m_ballStorage[11] = n2;
        }
    }

    public int getAngleFromCmdDirection(int n2) {
        return n2 << 5;
    }

    private static boolean bluetoothSafeToHardSetStateTimerToZero() {
        return true;
    }

    public boolean isFireHeldLongEnoughForTackleMicrogame() {
        return this.m_controlPlayerMarkingHoldFrames >= 5;
    }

    private void homeInOnBall() {
        if (this.m_controlPlayer != null) {
            if (this.m_controlPlayer[23] < 256) {
                this.m_controlPlayer[6] = this.m_controlPlayer[6] | 0x8000;
                this.m_controlPlayer[17] = this.m_controlPlayer[17] | 0x200;
            }
            this.m_homeInOnBall = true;
        }
    }
}

