/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.DDMath;
import com.ea.game.GameAI;
import com.ea.game.GameLogic;
import com.ea.game.GameRender;
import com.ea.game.HumanController;
import com.ea.game.MainFrame;
import com.ea.game.XMLMenuSystem;

public class TouchscreenController
extends HumanController {
    public static int m_touchState;
    public static int m_touchSubState;
    public static int m_touchTargetMoveSpeed;
    public static int m_touchTargetMoveDirection;
    public static int m_touchLayout;
    public static int m_touchDpadX;
    public static int m_touchDpadY;
    public static int m_lastJoystick;
    private static int m_buttonPressTimer;
    private static int m_frameSincePlayerTouchMove;
    private static boolean m_touchStartedInDeadZone;
    private static final int MAX_TIME_FOR_SINGLE_TAP = 3;
    public static boolean prevPointerPressed;
    private static final int NEW_ZONESIZE_PERCENT_DEAD_SIZE = 12;
    private static final int NEW_ZONESIZE_PERCENT_RUN_SIZE = 44;
    private static final int NEW_ZONESIZE_PERCENT_SPRINT_SIZE = 44;
    private static final int NEW_ZONESIZE_PERCENT_DEAD_START = 0;
    private static final int NEW_ZONESIZE_PERCENT_DEAD_END = 12;
    private static final int NEW_ZONESIZE_PERCENT_RUN_START = 12;
    private static final int NEW_ZONESIZE_PERCENT_RUN_END = 56;
    private static final int NEW_ZONESIZE_PERCENT_SPRINT_START = 56;
    private static final int NEW_ZONESIZE_PERCENT_SPRINT_END = 100;
    public static final int RADIUS_TOUCH_AREA = 12;
    public static final int RADIUS_TOUCH_AREA_SQD = 144;
    public static int[] player2DCoords;

    public TouchscreenController(int n2) {
        super(n2);
    }

    public void update() {
        if (MainFrame.m_pointerPressedProcessed && MainFrame.m_pointerReleasedToProcess) {
            MainFrame.m_pointerPressed = false;
            MainFrame.m_pointerCurrentPosX = MainFrame.m_pointerReleasedToProcessX;
            MainFrame.m_pointerCurrentPosY = MainFrame.m_pointerReleasedToProcessY;
            MainFrame.m_pointerReleasedToProcess = false;
        }
        int n2 = MainFrame.m_joystick;
        int n3 = MainFrame.m_pointerCurrentPosX;
        int n4 = MainFrame.m_pointerCurrentPosY;
        boolean bl = false;
        if (!MainFrame.m_pointerPressed && m_buttonPressTimer > 0) {
            bl = true;
        }
        if (MainFrame.m_pointerPressed && !MainFrame.m_pointerPressedProcessed && m_buttonPressTimer == 0) {
            m_touchStartedInDeadZone = false;
        }
        ++m_buttonPressTimer;
        m_touchSubState = 0;
        if (m_touchTargetMoveSpeed > 0 && ++m_frameSincePlayerTouchMove > 10) {
            m_touchTargetMoveSpeed -= 22;
        }
        this.updateTouchLayout();
        int n5 = n3 - m_touchDpadX;
        int n6 = n4 - m_touchDpadY;
        this.newUpdate();
        n2 = this.processTouchState(n3, n4, n5, n6, n2, bl);
        if (!MainFrame.m_pointerPressed) {
            TouchscreenController.setTouchState(0);
        }
        if (m_touchTargetMoveSpeed < 47) {
            m_touchTargetMoveSpeed = 0;
        }
        super.setJoystick(n2);
        super.setLastJoystick(m_lastJoystick);
        m_lastJoystick = n2;
        super.update();
        if (!MainFrame.m_pointerPressedProcessed) {
            MainFrame.m_pointerPressedProcessed = true;
        }
        prevPointerPressed = MainFrame.m_pointerPressed;
    }

    private void updateTouchLayout() {
        if (GameLogic.m_quickPlayMomentAvailable) {
            m_touchLayout = 7;
        } else if (GameRender.m_replayInProgress) {
            m_touchLayout = GameLogic.m_matchState == 16 || GameLogic.m_matchState == 7 ? 5 : 4;
        } else if (GameLogic.m_matchState == 1 && (GameLogic.m_matchSubState == 11 || GameLogic.m_matchSubState == 1 || GameLogic.m_matchSubState == 2 || GameLogic.m_matchSubState == 3 || GameLogic.m_matchSubState == 4)) {
            m_touchLayout = 2;
        } else if (GameLogic.getPlayerTeam() == GameLogic.m_possession) {
            if (GameLogic.m_matchState != 2) {
                m_touchTargetMoveSpeed = 0;
                m_touchLayout = this.m_controlPlayer == GameLogic.m_setPieceTaker ? (GameLogic.m_matchState == 8 && (GameLogic.m_matchSubState == 13 || GameLogic.m_matchSubState == 14) || GameLogic.m_matchState == 9 && GameLogic.m_setPieceMode == 0 ? 3 : (GameLogic.m_matchState != 8 ? 2 : 5)) : 0;
            } else {
                m_touchLayout = 0;
            }
        } else {
            m_touchLayout = GameLogic.m_matchState == 8 && GameLogic.m_matchSubState == 13 && GameLogic.m_possession != GameLogic.getPlayerTeam() ? 3 : 1;
        }
    }

    private int processTouchState(int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (MainFrame.m_pointerPressed) {
            this.processTouchStateIdle(n2, n3);
            n6 = this.processTouchStatesExceptIdle(n2, n3, n4, n5, n6, bl);
            if (n6 == 0) {
                this.setSkipKey();
                if (GameLogic.isPrematchActive()) {
                    this.m_buttonThrough = true;
                }
            }
        } else if (prevPointerPressed != MainFrame.m_pointerPressed) {
            if (GameLogic.m_matchState == 13 || GameLogic.m_matchState == 16 || GameLogic.m_matchState == 7) {
                if (XMLMenuSystem.touchIsLskSelected(MainFrame.m_pointerCurrentPosX, MainFrame.m_pointerCurrentPosY)) {
                    MainFrame.m_keysPressedThisFrame |= 0x20;
                    MainFrame.m_keyState |= 0x20;
                    GameLogic.lskWasReleased = false;
                } else if (XMLMenuSystem.touchIsRskSelected(MainFrame.m_pointerCurrentPosX, MainFrame.m_pointerCurrentPosY)) {
                    MainFrame.m_keysPressedThisFrame |= 0x40;
                    MainFrame.m_keyState |= 0x40;
                }
            }
        } else {
            GameLogic.lskWasReleased = true;
            if (m_touchLayout == 1) {
                if (bl) {
                    this.processCommandAction(8, 0);
                }
            } else if (m_touchLayout == 4) {
                if (GameRender.touchIsButtonFfwdSelected(n2, n3)) {
                    GameRender.m_replayPlaybackControlsRightHold = false;
                } else if (GameRender.touchIsButtonRewindSelected(n2, n3)) {
                    GameRender.m_replayPlaybackControlsLeftHold = false;
                }
            }
        }
        return n6;
    }

    private void processTouchStateIdle(int n2, int n3) {
        if (m_touchState == 0) {
            m_buttonPressTimer = 0;
            if (GameRender.touchIsButtonBallSelected(n2, n3)) {
                if (TouchscreenController.getTouchButtonAAction() == 3) {
                    TouchscreenController.setTouchState(2);
                } else if (TouchscreenController.getTouchButtonBAction() == 5) {
                    TouchscreenController.setTouchState(3);
                } else {
                    TouchscreenController.setTouchState(1);
                }
            } else if (GameLogic.m_matchState == 9 && GameLogic.m_matchSubState == 28 && this.newClosestPlayerAtXYWithinRadius(n2, n3, 40) == GameLogic.m_setPieceTaker[9]) {
                TouchscreenController.setTouchState(3);
            } else if (GameRender.touchIsButtonQPMSelected(n2, n3)) {
                TouchscreenController.setTouchState(2);
            } else if (GameRender.touchIsButtonCskSelected(n2, n3)) {
                TouchscreenController.setTouchState(4);
            } else if (GameRender.touchIsButtonLskSelected(n2, n3)) {
                TouchscreenController.setTouchState(5);
                MainFrame.ignorePtrRelease = true;
            } else if (GameRender.touchIsButtonPlaySelected(n2, n3)) {
                if (MainFrame.m_framesSinceReplayControlUsed >= 5) {
                    TouchscreenController.setTouchState(7);
                }
            } else if (GameRender.touchIsButtonFfwdSelected(n2, n3)) {
                TouchscreenController.setTouchState(8);
            } else if (GameRender.touchIsButtonRewindSelected(n2, n3)) {
                TouchscreenController.setTouchState(9);
            } else if (m_touchLayout == 2 || m_touchLayout == 3) {
                TouchscreenController.setTouchState(6);
            } else {
                TouchscreenController.setTouchState(1);
            }
        }
    }

    private int processTouchStatesExceptIdle(int n2, int n3, int n4, int n5, int n6, boolean bl) {
        switch (m_touchState) {
            case 1: {
                n6 = this.newProcessNewTouchscreenControlSystem(n4, n5, n6, bl);
                break;
            }
            case 2: {
                if (GameRender.touchIsButtonBallSelected(n2, n3) || GameRender.touchIsButtonQPMSelected(n2, n3)) {
                    n6 |= 0x10;
                    m_touchSubState = 1;
                    break;
                }
                m_touchSubState = 0;
                break;
            }
            case 3: {
                if (GameRender.touchIsButtonBallSelected(n2, n3) || GameLogic.m_matchState == 9 && GameLogic.m_matchSubState == 28 && this.newClosestPlayerAtXYWithinRadius(n2, n3, 40) == GameLogic.m_setPieceTaker[9]) {
                    m_touchSubState = 1;
                    if (TouchscreenController.getTouchButtonBAction() == 6) {
                        if (m_buttonPressTimer <= 3) break;
                        n6 |= 0x10;
                        break;
                    }
                    n6 |= 0x80;
                    if (m_touchLayout != 3) break;
                    n6 |= 0x10;
                    break;
                }
                m_touchSubState = 0;
                break;
            }
            case 4: {
                if (GameRender.touchIsButtonCskSelected(n2, n3)) {
                    m_touchSubState = 1;
                    if (m_touchLayout == 4) {
                        n6 |= 0x40;
                        break;
                    }
                    n6 |= 0x20;
                    break;
                }
                m_touchSubState = 0;
                break;
            }
            case 5: {
                if (GameRender.touchIsButtonLskSelected(n2, n3)) {
                    m_touchSubState = 1;
                    n6 |= 0x40;
                    break;
                }
                m_touchSubState = 0;
                break;
            }
            case 6: {
                int n7;
                if (GameLogic.m_matchState == 17 || GameLogic.m_matchState == 14) {
                    int n8 = this.newClosestPassMarkerAtXYWithinRadius(MainFrame.m_pointerCurrentPosX, MainFrame.m_pointerCurrentPosY, 40);
                    if (n8 == -1) break;
                    if (n8 == 2) {
                        this.processCommandAction(8, 2);
                        this.processCommandAction(8, 3);
                        break;
                    }
                    if (n8 != 1) break;
                    this.processCommandAction(8, 0);
                    break;
                }
                if (!(GameLogic.m_matchState == 9 && (GameLogic.m_matchSubState == 26 || GameLogic.m_matchSubState == 27) || GameLogic.m_matchState == 6 && GameLogic.m_matchSubState == 17 || GameLogic.m_matchState == 5 && GameLogic.m_matchSubState == 45) && (GameLogic.m_matchState != 8 || GameLogic.m_matchSubState != 13)) break;
                m_touchSubState = 0;
                if (GameRender.touchIsButtonUpSelected(n2, n3)) {
                    m_touchSubState = 4;
                } else if (GameRender.touchIsButtonDownSelected(n2, n3)) {
                    m_touchSubState = 8;
                } else if (GameRender.touchIsButtonLeftSelected(n2, n3)) {
                    m_touchSubState = 1;
                } else if (GameRender.touchIsButtonRightSelected(n2, n3)) {
                    m_touchSubState = 2;
                }
                n6 |= m_touchSubState;
                if (GameLogic.m_matchState == 9 && GameLogic.m_matchSubState == 28 || m_touchSubState != 0 || m_buttonPressTimer != 0 || (n7 = this.newClosestPlayerAtXYWithinRadius(MainFrame.m_pointerCurrentPosX, MainFrame.m_pointerCurrentPosY, 40)) <= 0) break;
                if (n7 == GameLogic.m_setPieceTargetPlayer) {
                    GameLogic.m_setPieceMode = 1;
                    n6 |= 0x10;
                    break;
                }
                if (GameLogic.m_gameMode == 5 || GameLogic.m_matchState == 5 && GameLogic.m_matchSubState == 45 && (GameLogic.m_matchState != 5 || GameLogic.m_matchSubState != 45 || GameLogic.setPieceSelection[n7] == -1) || n7 == GameLogic.m_setPieceTaker[9]) break;
                GameLogic.setPieceSetTarget(n7);
                if (GameLogic.m_matchState != 9 || GameLogic.m_matchSubState != 27) break;
                GameLogic.setState(9, 26, -1, -1);
                GameLogic.m_setPieceMode = 1;
                break;
            }
            case 7: {
                if (GameRender.touchIsButtonPlaySelected(n2, n3)) {
                    if (MainFrame.m_framesSinceReplayControlUsed < 5) break;
                    MainFrame.m_framesSinceReplayControlUsed = 0;
                    m_touchSubState = 1;
                    n6 |= 0x10;
                    break;
                }
                m_touchSubState = 0;
                break;
            }
            case 8: {
                if (GameRender.touchIsButtonFfwdSelected(n2, n3)) {
                    m_touchSubState = 1;
                    GameRender.m_replayPlaybackControlsRightHold = true;
                    break;
                }
                m_touchSubState = 0;
                break;
            }
            case 9: {
                if (GameRender.touchIsButtonRewindSelected(n2, n3)) {
                    m_touchSubState = 1;
                    GameRender.m_replayPlaybackControlsLeftHold = true;
                    break;
                }
                m_touchSubState = 0;
            }
        }
        GameLogic.lskWasReleased = true;
        return n6;
    }

    private static final void setTouchState(int n2) {
        m_buttonPressTimer = 0;
        m_touchState = n2;
    }

    public static int getTouchButtonAAction() {
        if (GameLogic.m_matchState != 1 || GameLogic.m_matchSubState != 8 && GameLogic.m_matchSubState != 9) {
            if (m_touchLayout == 7 || m_touchLayout == 2) {
                return 3;
            }
            if (m_touchLayout == 1) {
                if (GameLogic.isFreeBallSituation()) {
                    return 5;
                }
                return 4;
            }
        }
        return -1;
    }

    public static int getTouchButtonAState() {
        if (m_touchState == 2) {
            return m_touchSubState;
        }
        if (m_touchState != 0) {
            return 2;
        }
        return 0;
    }

    public static int getTouchButtonBAction() {
        if (GameLogic.m_matchState != 1 || GameLogic.m_matchSubState != 8 && GameLogic.m_matchSubState != 9) {
            if (m_touchLayout == 0 || m_touchLayout == 3) {
                return 5;
            }
            if (m_touchLayout == 1) {
                if (GameLogic.isFreeBallSituation()) {
                    return 5;
                }
                return 6;
            }
        }
        return -1;
    }

    public static int getTouchButtonBState() {
        if (m_touchState == 3) {
            return m_touchSubState;
        }
        if (m_touchState != 0) {
            return 2;
        }
        return 0;
    }

    public static int getTouchButtonRskAction() {
        int n2;
        if (GameLogic.m_gameMode == 5 && (n2 = DDMath.max(GameLogic.freeKickChallengeGetMaxTimer() * 1000 - GameLogic.m_freeKickChallengeTimeElapsed, 0)) < 200) {
            return -1;
        }
        if ((m_touchLayout == 2 || m_touchLayout == 3) && (GameLogic.m_matchState == 9 && (GameLogic.m_matchSubState == 26 || GameLogic.m_matchSubState == 27) || GameLogic.m_matchState == 6 && GameLogic.m_matchSubState == 17)) {
            return 7;
        }
        if (GameLogic.m_matchState == 1 && (GameLogic.m_matchSubState == 11 || GameLogic.m_matchSubState == 1 || GameLogic.m_matchSubState == 2) || GameLogic.m_matchState == 9 && GameLogic.m_matchSubState == 28 || GameLogic.m_matchState == 8 && GameLogic.m_matchSubState == 14) {
            return 8;
        }
        return -1;
    }

    public static int getTouchButtonRskState() {
        if (m_touchState == 4) {
            return m_touchSubState;
        }
        if (m_touchState != 0) {
            return 2;
        }
        return 0;
    }

    public static int getTouchButtonLskAction() {
        if (GameLogic.m_matchState != 13 && GameLogic.m_matchState != 7 && GameLogic.m_matchState != 16) {
            return 9;
        }
        return -1;
    }

    public static int getTouchButtonLskState() {
        if (m_touchState == 5) {
            return m_touchSubState;
        }
        if (m_touchState != 0) {
            return 2;
        }
        return 0;
    }

    public static int getTouchButtonPlayAction() {
        if (m_touchLayout == 4) {
            return 0;
        }
        return -1;
    }

    public static int getTouchButtonPlayState() {
        if (m_touchState == 7) {
            return m_touchSubState;
        }
        if (!GameRender.m_replayPlaybackPaused) {
            return 1;
        }
        if (m_touchState != 0) {
            return 2;
        }
        return 0;
    }

    public static int getTouchButtonFfwdAction() {
        if (m_touchLayout == 4) {
            return 1;
        }
        return -1;
    }

    public static int getTouchButtonFfwdState() {
        if (m_touchState == 8) {
            return m_touchSubState;
        }
        if (m_touchState != 0) {
            return 2;
        }
        return 0;
    }

    public static int getTouchButtonRewindAction() {
        if (m_touchLayout == 4) {
            return 2;
        }
        return -1;
    }

    public static int getTouchButtonRewindState() {
        if (m_touchState == 9) {
            return m_touchSubState;
        }
        if (m_touchState != 0) {
            return 2;
        }
        return 0;
    }

    private final void newUpdate() {
        this.newDPadPositionUpdate();
        TouchscreenController.newUpdatePlayer2DCoords();
    }

    private final void newDPadPositionUpdate() {
        if (TouchscreenController.newPlayerDirectionalControlIsAvailable() && this.m_controlPlayer != null) {
            GameRender.pitchProjectObject(this.m_controlPlayer[0], this.m_controlPlayer[1], 0);
            m_touchDpadX = GameRender.pitchProjPos[0] - GameRender.m_scrollX;
            m_touchDpadY = GameRender.pitchProjPos[1] - GameRender.m_scrollY + -12;
        }
    }

    public static boolean newPlayerDirectionalControlIsAvailable() {
        return (GameAI.ballIsPossessed() || GameAI.ballGetSpeed() <= 1) && (!GameAI.ballIsPossessed() || GameLogic.m_possession == GameLogic.getPlayerTeam());
    }

    public static boolean newPlayerSwitchIsAvailable() {
        return TouchscreenController.getTouchButtonAAction() == 4;
    }

    public static boolean newPlayerTackleIsAvailable() {
        return TouchscreenController.getTouchButtonBAction() == 6;
    }

    private int newClosestPassMarkerAtXYWithinRadius(int n2, int n3, int n4) {
        int n5 = -1;
        int n6 = 102400;
        int n7 = n4 * n4;
        for (int i2 = 0; i2 < 4; ++i2) {
            int n8;
            int n9;
            int n10;
            if (i2 != 1 && i2 != 2 || (n10 = DDMath.calcHorizontalDistSquared(n2, n3, n9 = GameRender.m_hudPointerTouchscreenProjPos[i2 * 2 + 0], n8 = GameRender.m_hudPointerTouchscreenProjPos[i2 * 2 + 1])) >= n6 || n10 >= n7) continue;
            n6 = n10;
            n5 = i2;
        }
        return n5;
    }

    private int newClosestPlayerAtXYWithinRadius(int n2, int n3, int n4) {
        int n5 = -1;
        int n6 = 102400;
        int n7 = n4 * n4;
        for (int i2 = 0; i2 < 11; ++i2) {
            int n8 = DDMath.calcHorizontalDistSquared(n2, n3, player2DCoords[i2 * 2 + 0], player2DCoords[i2 * 2 + 1]);
            if (n8 >= n6 || n8 >= n7) continue;
            n6 = n8;
            n5 = i2;
        }
        return n5;
    }

    public static void newUpdatePlayer2DCoords() {
        for (int i2 = 0; i2 < 11; ++i2) {
            int[] nArray = GameAI.m_playerStorage[GameLogic.getPlayerTeam()][i2];
            GameRender.pitchProjectObject(nArray[0], nArray[1], nArray[2]);
            int n2 = GameRender.pitchProjPos[0] - GameRender.m_scrollX;
            int n3 = GameRender.pitchProjPos[1] - GameRender.m_scrollY + -12;
            TouchscreenController.player2DCoords[i2 * 2 + 0] = n2;
            TouchscreenController.player2DCoords[i2 * 2 + 1] = n3;
        }
    }

    private int newProcessNewTouchscreenControlSystem(int n2, int n3, int n4, boolean bl) {
        if (GameLogic.m_matchState != 2) {
            return n4;
        }
        if (TouchscreenController.newPlayerDirectionalControlIsAvailable()) {
            if (m_buttonPressTimer == 0) {
                int n5 = this.newClosestPlayerAtXYWithinRadius(MainFrame.m_pointerCurrentPosX, MainFrame.m_pointerCurrentPosY, 40);
                int n6 = this.newClosestPassMarkerAtXYWithinRadius(MainFrame.m_pointerCurrentPosX, MainFrame.m_pointerCurrentPosY, 40);
                if (n6 != -1) {
                    if (n6 == 2) {
                        this.processCommandAction(8, 2);
                        this.processCommandAction(8, 3);
                    } else if (n6 == 1) {
                        this.processCommandAction(8, 0);
                        if (GameLogic.m_gameMode == 2 && XMLMenuSystem.m_currTutorial == 3) {
                            XMLMenuSystem.m_tutorialComplete[7] = true;
                            XMLMenuSystem.setTutorialDelay(MainFrame.m_inGameFrameRate * 1 / 2);
                        }
                    }
                } else if (this.m_controlPlayer != null && n5 != -1 && GameAI.m_playerStorage[GameLogic.getPlayerTeam()][n5] != this.m_controlPlayer) {
                    GameAI.setPassTarget(this.m_controlPlayer, GameAI.m_playerStorage[GameLogic.getPlayerTeam()][n5]);
                    this.processCommandAction(8, 0);
                    if (GameLogic.m_gameMode == 2 && XMLMenuSystem.m_currTutorial == 3) {
                        XMLMenuSystem.m_tutorialComplete[7] = true;
                        XMLMenuSystem.setTutorialDelay(MainFrame.m_inGameFrameRate * 1 / 2);
                    }
                } else {
                    n4 = this.newProcessInputAsPlayerDirectionalControl(n2, n3, n4);
                }
            } else {
                n4 = this.newProcessInputAsPlayerDirectionalControl(n2, n3, n4);
            }
        } else if (GameLogic.m_possession != GameLogic.getPlayerTeam()) {
            if (GameAI.ballIsInACross()) {
                this.processCommandAction(9, 0);
            } else {
                n4 |= 0x10;
            }
        } else if (GameAI.ballIsInACross() || GameAI.ballIsInAPass() && GameAI.m_passType == 6 && this.m_controlPlayer[9] == GameLogic.m_setPieceTargetPlayer && this.m_controlPlayer[28] == 10 && GameLogic.isObjectIn18YardBox(this.m_controlPlayer, GameAI.teamGetPitchSide(this.m_controlPlayer[12] ^ 1))) {
            this.processCommandAction(9, 0);
            GameLogic.m_setPieceTargetPlayer = -1;
        }
        return n4;
    }

    private int newProcessInputAsPlayerDirectionalControl(int n2, int n3, int n4) {
        int n5 = DDMath.sqrtRout(n2 * n2 + n3 * n3);
        m_frameSincePlayerTouchMove = 0;
        if (n5 < 35) {
            n3 = 0;
            n2 = 0;
            m_touchTargetMoveSpeed = 0;
            if (m_buttonPressTimer == 0) {
                m_touchStartedInDeadZone = true;
            }
        } else if (n5 < 70) {
            m_touchTargetMoveSpeed = n5 * 256 / 70;
            if (GameLogic.m_gameMode == 2) {
                XMLMenuSystem.m_tutorialComplete[0] = true;
                XMLMenuSystem.setTutorialDelay(1);
            }
        } else {
            m_touchTargetMoveSpeed = 360;
            n4 |= 0x100;
        }
        if (this.m_controlPlayer != null) {
            if (m_touchStartedInDeadZone) {
                n4 |= 0x80;
            } else {
                this.humanDirectionalControl(DDMath.atan(n3, n2), m_buttonPressTimer < 3 ? 0 : 2);
            }
        }
        return n4;
    }

    static {
        m_frameSincePlayerTouchMove = 0;
        prevPointerPressed = false;
        player2DCoords = new int[22];
    }
}

