/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Controller;
import com.ea.game.DDDebug;
import com.ea.game.DDMath;
import com.ea.game.GameAI;
import com.ea.game.GameFormation;
import com.ea.game.GameLogic;
import com.ea.game.GameRender;
import com.ea.game.MainFrame;

public class AIController
extends Controller {
    public static final int AI_ACTION_NONE = 0;
    public static final int AI_ACTION_LONG_PASS = 1;
    public static final int AI_ACTION_SHORT_PASS = 2;
    public static final int AI_ACTION_CROSSED_PASS = 3;
    public static final int AI_ACTION_SHOOT_BALL = 4;
    public static final int AI_ACTION_LOB_BALL = 5;
    public static final int AI_ACTION_CLEARANCE = 6;
    public static final int AI_ACTION_180_TURN = 7;
    public static final int AI_ACTION_STOP_THE_BALL = 8;
    public static final int AI_STATE_IDLE = 0;
    public static final int AI_STATE_RUN_INTO_SPACE = 1;
    public static final int AI_STATE_SPRINT_INTO_SPACE = 2;
    public static final int AI_STATE_SLOW_DOWN_BECAUSE_THREATENED = 3;
    public static final int AI_STATE_SHIELD_BALL = 4;
    public static final int AI_STATE_STOP_BALL = 5;
    public static final int AI_STATE_WHILE_GRAPPLING = 6;
    public static final int AI_STATE_AVOID_DEFENDER = 7;
    public static final int AI_STATE_PERFORM_ONE_TWO = 8;
    public static final int AI_STATE_RUN_TOWARD_THE_GOAL = 9;
    public static final int AI_STATE_FIRST_TIME_PASS = 10;
    public static final int AI_STATE_CLEAR_THE_BALL = 11;
    public static final int AI_STATE_BREAK_AWAY_USING_180 = 12;
    public static final int AI_STATE_IN_CROSSING_ZONE = 13;
    public static final int AI_STATE_WAS_IN_CROSSING_ZONE_NOW_CUTTING_INTO_GOAL = 14;
    public static final int RUN_INTO_SPACE_CLEAR = 0;
    public static final int RUN_INTO_SPACE_NEAR_TOP_OF_PITCH = 1;
    public static final int RUN_INTO_SPACE_NEAR_SIDE_OF_PITCH = 2;
    public static int m_actionType = 0;
    public static int m_state = 0;
    public static int m_stateTimer = 0;

    public void setupControls(int n2) {
    }

    public AIController(int n2) {
        super(n2);
    }

    public void updatePlayerSelect(boolean bl) {
    }

    public boolean assessNeedForPlayerSelect() {
        return false;
    }

    public boolean isFireHeldLongEnoughForTackleMicrogame() {
        return false;
    }

    public void update() {
        int n2;
        --m_stateTimer;
        if (GameLogic.m_matchState == 7 || GameLogic.m_matchState == 16 || GameLogic.m_matchState == 2 || this.m_teamID != GameLogic.m_possession) {
            return;
        }
        if (GameLogic.m_matchState == 5 && GameLogic.m_matchSubState == 45 && GameLogic.m_setPieceTaker != null && GameLogic.m_setPieceTaker[28] == 12) {
            if (GameLogic.m_setPieceTaker[32] != -1 || GameLogic.m_setPieceTaker[33] != -1) {
                int n3 = n2 = (DDMath.getRandom() & 1) == 0 ? 1 : 0;
                if (n2 != 0 || GameLogic.m_setPieceTaker[33] == -1) {
                    this.initPass(0, GameLogic.m_setPieceTaker);
                } else {
                    this.initPass(2, GameLogic.m_setPieceTaker);
                    this.initPass(3, GameLogic.m_setPieceTaker);
                }
            } else {
                int n4 = GameLogic.m_setPieceTaker[21] + (DDMath.getRandom() & 0x3F);
                GameLogic.m_setPieceTaker[21] = GameLogic.m_setPieceTaker[21] & 0xFF;
                if (GameLogic.m_setPieceTaker[0] < 12311) {
                    n4 = DDMath.max(n4, 128);
                    n4 = DDMath.min(n4, 255);
                } else {
                    n4 = DDMath.max(n4, 0);
                    n4 = DDMath.min(n4, 128);
                }
                GameLogic.m_setPieceTaker[21] = n4;
                GameAI.playerUpdatePassTargets(GameLogic.m_setPieceTaker);
            }
        }
        if (GameLogic.m_matchState == 9 && GameLogic.m_setPieceTaker != null && GameLogic.m_setPieceTaker[28] == 12) {
            if (GameLogic.m_setPieceMode == 0) {
                GameLogic.m_setPieceTargetObject[1] = GameAI.teamGetPitchSide(this.m_teamID) == 1 ? 100 : 8195740;
            } else {
                int[] nArray = GameLogic.nearestPlayerData(GameLogic.m_setPieceTaker, this.m_teamID, 4);
                if (nArray == null) {
                    nArray = GameLogic.nearestPlayerData(GameLogic.m_setPieceTaker, this.m_teamID, 0);
                }
                GameLogic.m_setPieceTaker[32] = nArray[9];
            }
            if (--GameLogic.m_stateTimer <= 0) {
                n2 = GameAI.m_ballStorage[1];
                if (GameAI.teamGetPitchSide(this.m_teamID) == 0) {
                    n2 = 32015 - n2;
                }
                if (GameLogic.m_setPieceMode == 0) {
                    int n5 = DDMath.getRandom() % 2560;
                    n5 = n5 > 0 ? DDMath.max(n5, 1280) : DDMath.min(n5, -1280);
                    GameLogic.m_setPieceShotType = true;
                    GameLogic.m_setPieceTargetObject[0] = 12311 + n5;
                    GameLogic.m_setPieceTargetObject[1] = GameAI.teamGetPitchSide(this.m_teamID) == 1 ? 100 : 8195740;
                    GameLogic.m_setPieceTargetObject[2] = 312 + DDMath.getRandom() % 768;
                    this.m_shootBall = true;
                    GameLogic.m_useGKDivePosition = false;
                    GameAI.m_idealShotType = 3;
                    GameLogic.setState(9, 28, -1, -1);
                } else {
                    this.m_passBall = true;
                    this.m_passFromFreeKickByAI = true;
                    GameLogic.setState(9, 28, -1, -1);
                }
            }
        }
        if ((GameLogic.m_matchState == 17 && GameLogic.m_matchSubState == 40 || GameLogic.m_matchState == 14) && --GameLogic.m_stateTimer <= 0 && GameLogic.m_setPieceTaker != null) {
            if (GameLogic.m_gameMode == 1) {
                if (GameLogic.m_setPieceTaker[33] != -1) {
                    if (GameLogic.m_matchState == 14) {
                        GameFormation.jumpPlayersToTheirPositions();
                    }
                    this.m_passBall = true;
                    this.m_longGoalKick = true;
                }
            } else if (GameLogic.m_gameMode == 2 && GameLogic.m_setPieceTaker[33] != -1) {
                this.m_passBall = true;
                this.m_longGoalKick = true;
            }
        }
        if (GameLogic.m_matchState == 6 && (GameLogic.m_matchSubState == 17 || GameLogic.m_matchSubState == 16 || GameLogic.m_matchSubState == 18) && GameLogic.m_setPieceTaker != null && GameLogic.m_setPieceTaker[28] == 12 && GameLogic.m_setPieceTargetObject != null) {
            GameLogic.m_setPieceTargetObject[0] = (DDMath.getRandom() % 20 << 8) + 12311;
            GameLogic.m_setPieceTargetObject[0] = DDMath.max(GameLogic.m_setPieceTargetObject[0], 3840);
            GameLogic.m_setPieceTargetObject[0] = DDMath.min(GameLogic.m_setPieceTargetObject[0], 20782);
            if (GameAI.m_ballStorage[1] < 16007) {
                GameLogic.m_setPieceTargetObject[1] = (DDMath.getRandom() % 10 << 8) + 3089;
                GameLogic.m_setPieceTargetObject[1] = DDMath.min(GameLogic.m_setPieceTargetObject[1], 6400);
                GameLogic.m_setPieceTargetObject[1] = DDMath.max(GameLogic.m_setPieceTargetObject[1], 512);
            } else {
                GameLogic.m_setPieceTargetObject[1] = (DDMath.getRandom() % 10 << 8) + 28926;
                GameLogic.m_setPieceTargetObject[1] = DDMath.min(GameLogic.m_setPieceTargetObject[1], 31503);
                GameLogic.m_setPieceTargetObject[1] = DDMath.max(GameLogic.m_setPieceTargetObject[1], 25615);
            }
            int[] nArray = GameLogic.nearestPlayerData(GameLogic.m_setPieceTargetObject, this.m_teamID, 0);
            GameAI.setPassTarget(GameLogic.m_setPieceTaker, nArray);
            if (nArray != null) {
                GameLogic.m_setPieceTargetPlayer = nArray[9];
                this.m_passBall = true;
            }
            if (m_stateTimer > 100 || m_stateTimer < -100) {
                m_stateTimer = MainFrame.m_inGameFrameRate;
            }
            if (m_stateTimer <= 0) {
                if (GameRender.m_fadeState == 2) {
                    if (GameLogic.m_matchSubState != 18 && GameLogic.m_matchSubState != 19) {
                        GameLogic.setState(6, 18, -1, -1);
                    }
                } else if (GameRender.m_fadeState == 1) {
                    GameRender.fadeSet(true);
                }
            }
        }
    }

    public void performAction(int[] nArray, int n2) {
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                this.initPass(2, nArray);
                this.initPass(3, nArray);
                break;
            }
            case 2: {
                this.initPass(0, nArray);
                break;
            }
            case 3: {
                this.initPass(2, nArray);
                this.initPass(3, nArray);
                break;
            }
            case 4: {
                this.m_shootBall = true;
                if (GameLogic.isBallInFinishingZone(GameAI.teamGetPitchSide(nArray[12]))) {
                    GameAI.m_idealShotType = 2;
                    if (!GameAI.playerCheckOpenGoal(nArray)) break;
                    GameAI.playerSetState(nArray, 0, 0, 38);
                    break;
                }
                this.m_controlPlayer = nArray;
                this.m_microGame.init(this.m_controlPlayer, 3, 3000, 1, this.m_controlPlayer[38]);
                this.microGameUpdate();
                int n3 = DDMath.getPositiveRandom() % 100 < 10 ? 1 : 2;
                int n4 = 0;
                do {
                    this.m_microGame.m_markerPosition = DDMath.getPositiveRandom() % 100;
                    this.m_microGame.setState(0);
                } while (GameLogic.m_controller[this.m_teamID].m_microGame.getResult() != n3 && ++n4 < 1000);
                this.m_microGame.setMark();
                GameAI.m_idealShotType = 0;
                break;
            }
            case 5: {
                this.m_shootBall = true;
                GameAI.m_idealShotType = 1;
                break;
            }
            case 6: {
                this.m_clearBall = true;
                break;
            }
            case 7: {
                this.m_180turn = true;
            }
        }
    }

    public boolean playerCheckIfCanPass(int[] nArray, int n2, int n3) {
        int n4 = nArray[0] - nArray[25];
        int n5 = nArray[1] - nArray[26];
        int n6 = n4 * n4 + n5 * n5;
        boolean bl = false;
        if (GameLogic.isBallInCrossingZone(GameAI.teamGetPitchSide(nArray[12])) && (AIController.playerIsUnderPressure(nArray) || n3 > 30471)) {
            m_actionType = 3;
            return true;
        }
        if (nArray[28] == 10 && nArray[31] % 100 < 20) {
            return true;
        }
        switch (nArray[52]) {
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                if (n6 <= 0xE10000 && nArray[53] <= GameLogic.AI_DRIBBLE_WITH_BALL_MAX_TIME_DEFAULT || !(n5 < 0 && GameAI.teamGetPitchSide(this.m_teamID) == 1 || n5 > 0 && GameAI.teamGetPitchSide(this.m_teamID) == 0) && nArray[53] <= GameLogic.AI_DRIBBLE_WITH_BALL_MAX_TIME_OFFENSIVE || nArray[53] <= GameLogic.AI_DRIBBLE_WITH_BALL_MIN_TIME_OFFENSIVE) break;
                bl = true;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (nArray[53] <= GameLogic.AI_DRIBBLE_WITH_BALL_MIN_TIME_DEFENSIVE) break;
                bl = true;
                break;
            }
            default: {
                if (n6 <= 0x1900000 && (nArray[53] <= GameLogic.AI_DRIBBLE_WITH_BALL_MAX_TIME_DEFAULT || nArray != GameAI.ballGetLastTouchPlayer()) || !(n5 < 0 && GameAI.teamGetPitchSide(this.m_teamID) == 1 || n5 > 0 && GameAI.teamGetPitchSide(this.m_teamID) == 0) && nArray[53] <= GameLogic.AI_DRIBBLE_WITH_BALL_MAX_TIME_DEFAULT || nArray[53] <= GameLogic.AI_DRIBBLE_WITH_BALL_MIN_TIME_DEFAULT) break;
                bl = true;
            }
        }
        if (!bl && AIController.playerIsUnderPressure(nArray)) {
            bl = true;
        }
        if (bl && (GameAI.getPassTarget(nArray) != null || GameAI.getPassTargetAlternate(nArray) != null)) {
            m_actionType = AIController.playerCalculatePassType(nArray);
            return true;
        }
        return false;
    }

    public boolean playerCheckIfCanShoot(int[] nArray, int n2, int n3) {
        int n4;
        int n5;
        if (n3 < AIController.playerCalculateShotRange(nArray) && n3 < 6120) {
            if (n3 > 4121 && n3 < 5401) {
                int[] nArray2 = GameAI.m_playerStorage[GameLogic.m_possession ^ 1][0];
                int n6 = n5 = GameAI.teamGetPitchSide(GameLogic.m_possession) == 1 ? nArray2[1] : 32015 - nArray2[1];
                if (n5 > 700) {
                    m_actionType = 5;
                    return true;
                }
            }
            n4 = DDMath.getPositiveRandom() % 100;
            if (!(AIController.playerIsUnderPressure(nArray) && !GameAI.playerCheckOpenGoal(nArray) && n4 >= 20 || GameLogic.isBallInCrossingZone(GameAI.teamGetPitchSide(this.m_teamID)))) {
                m_actionType = 4;
                return true;
            }
        }
        n5 = 0;
        n4 = GameAI.m_ballStorage[0] - 12311;
        if (n4 > -4096 && n4 < 4096) {
            n5 = 1;
        }
        if (!(n5 == 0 || GameLogic.isObjectInOwnHalf(nArray[12], GameAI.m_ballStorage) || GameAI.ballIsInAShot() || GameAI.m_ballStorage[2] != 0 || GameAI.m_ballStorage[1] >= 6172 && GameAI.m_ballStorage[1] <= 25843)) {
            m_actionType = 4;
            return true;
        }
        return false;
    }

    public boolean playerCheckIfCanSprint(int[] nArray, int n2, int n3) {
        if (GameLogic.m_gameMode == 2) {
            return false;
        }
        switch (nArray[52]) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                if (GameLogic.isBallInCrossingZone(GameAI.teamGetPitchSide(nArray[12])) || nArray[79] <= 10000) break;
                if (nArray[31] % 100 < GameLogic.m_difficultySettingAIPlayerGoingOnARunPercentage) {
                    if (AIController.playerIsUnderPressure(nArray)) break;
                    return true;
                }
                if (nArray[31] % 100 < GameLogic.m_difficultySettingAIPlayerGoingOnARunPercentage + GameLogic.m_difficultySettingAIPlayerSprintingJustOncePercentage) {
                    if (AIController.playerIsUnderPressure(nArray)) break;
                    nArray[31] = 99;
                    return true;
                }
                if (DDMath.getPositiveRandom() % 100 >= 10 || AIController.playerIsUnderPressure(nArray)) break;
                nArray[31] = 99;
                return true;
            }
        }
        return false;
    }

    public boolean playerCheckIfNeedsTo180(int[] nArray, int n2, int n3) {
        if (AIController.playerIsUnderPressure(nArray) && nArray[28] == 138 && nArray[53] > GameLogic.AI_DRIBBLE_WITH_BALL_MIN_TIME_DEFAULT) {
            nArray[53] = 0;
            switch (nArray[52]) {
                default: {
                    m_actionType = 2;
                    return true;
                }
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
            }
            if (DDMath.getPositiveRandom() % 3 == 1) {
                m_actionType = 2;
                return true;
            }
            m_actionType = 7;
            return true;
        }
        return false;
    }

    public boolean playerCheckIfNeedsToFullStop(int[] nArray, int n2, int n3) {
        if (DDMath.getPositiveRandom() % 25 == 1) {
            GameLogic.m_controller[GameLogic.m_possession].m_quickStop = true;
        }
        return false;
    }

    public boolean playerCheckIfNeedsToClear(int[] nArray, int n2, int n3) {
        if (AIController.playerIsUnderPressure(nArray) && GameLogic.isBallInCrossingZone(nArray[12] ^ 1) && AIController.playerFacingUpPitch(nArray)) {
            m_actionType = 6;
            return true;
        }
        boolean bl = false;
        int n4 = GameAI.m_ballStorage[0] - 12311;
        if (n4 > -3097 && n4 < 3097) {
            bl = true;
        }
        if (bl && GameLogic.isObjectInOwnHalf(nArray[12], GameAI.m_ballStorage) && !GameAI.ballIsInAShot() && GameAI.m_ballStorage[2] == 0 && (GameAI.m_ballStorage[1] < 3086 || GameAI.m_ballStorage[1] > 28929)) {
            m_actionType = 6;
            return true;
        }
        return false;
    }

    public boolean playerCheckIfCanOneTwo(int[] nArray, int n2, int n3) {
        return false;
    }

    public boolean playerCheckIfCanFirstTimePass(int[] nArray) {
        return (AIController.playerIsUnderPressure(nArray) || GameLogic.m_matchTimerMinute < 1) && DDMath.getPositiveRandom() < nArray[43];
    }

    public static int playerCalculateRunIntoSpaceDirection(int[] nArray) {
        int n2 = GameAI.teamGetPitchSide(nArray[12]);
        DDDebug.msg("AI STATES:\n\n\t start run into space direction");
        int n3 = nArray[22];
        DDDebug.msg("AI STATES: start direction " + n3);
        DDDebug.msg("AI STATES: start direction " + n3);
        if (AIController.isPlayerFurthestForwardOnHisTeam(nArray) && !GameLogic.isObjectInFinalThird(nArray, GameAI.teamGetPitchSide(nArray[12]))) {
            nArray[16] = n2 == 1 ? 32015 : 0;
        } else {
            n3 = AIController.playerCalculateRunDirectionByFormationType(nArray, n3);
            n3 = AIController.playerCalculateRunDirecitonAvoidingSideOfPitch(nArray, n3);
            n3 = AIController.playerCalculateRunDirecitonAvoidingTopEdgeOfPitch(nArray, n3);
            DDDebug.msg("AI STATES: final new direction  " + n3 + " \n");
        }
        return n3;
    }

    public static boolean isPlayerFurthestForwardOnHisTeam(int[] nArray) {
        int n2 = GameAI.teamGetPitchSide(nArray[12]);
        for (int i2 = 10; i2 >= 0; --i2) {
            int[] nArray2 = GameAI.m_playerStorage[nArray[12]][i2];
            if (!(n2 == 0 ? nArray2[1] > nArray[1] : nArray2[1] < nArray[1])) continue;
            return false;
        }
        return true;
    }

    public static int playerCalculateRunDirecitonAvoidingTopEdgeOfPitch(int[] nArray, int n2) {
        int n3 = nArray[0] + (DDMath.sin(n2) * 15 >> 8);
        int n4 = nArray[1] + (DDMath.cos(n2) * 15 >> 8);
        if (n4 < 0 || n4 > 32015) {
            DDDebug.msg("AI STATES: avoid the top edge of the pitch new dir ");
            n2 = nArray[14] == 0 && n3 < 12311 || nArray[14] == 128 && n3 > 12311 ? n2 + 32 & 0xFF : n2 - 32 & 0xFF;
            DDDebug.msg("AI STATES: avoid the top edge of the pitch new dir " + n2);
            AIController.setAIState(nArray, 13);
        }
        return n2;
    }

    public static int playerCalculateRunDirecitonAvoidingSideOfPitch(int[] nArray, int n2) {
        int n3 = nArray[0] + (DDMath.sin(n2) * 15 >> 8);
        if (n3 < 0 || n3 > 24622) {
            DDDebug.msg("AI STATES: avoid the side of the pitch");
            n2 = nArray[14] == 0 && n3 < 0 || nArray[14] == 128 && n3 > 24622 ? n2 + 64 & 0xFF : n2 - 64 & 0xFF;
            DDDebug.msg("AI STATES: avoid the edge of the pitch new dir " + n2);
        }
        return n2;
    }

    public static int playerCalculateRunDirectionByFormationType(int[] nArray, int n2) {
        int n3 = nArray[25];
        int n4 = nArray[1] + (512 * DDMath.cos(nArray[14]) >> 8);
        switch (nArray[52]) {
            default: {
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 13: {
                DDDebug.msg("AI STATES: midifelder");
                n3 = nArray[25] > 12311 ? 24110 : 512;
                break;
            }
            case 15: 
            case 17: {
                DDDebug.msg("AI STATES: striker ");
                if (nArray[0] < 8207 || nArray[0] > 16414) {
                    n3 = nArray[25] > 12311 ? 24110 : 512;
                    break;
                }
                n3 = nArray[25];
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                DDDebug.msg("AI STATES: defender ");
                if (nArray[0] <= 6155 || nArray[0] >= 18466) break;
                if (DDMath.CalcModDifference(nArray[14], nArray[22]) < 32 || DDMath.CalcModDifference(nArray[14] + 128 & 0xFF, nArray[22]) < 32) {
                    n3 = nArray[25] > 12311 ? 24110 : 512;
                    n4 = nArray[1];
                    break;
                }
                n3 = nArray[0] + (DDMath.sin(n2) * 512 >> 8);
                n4 = nArray[1] + (DDMath.cos(n2) * 512 >> 8);
            }
        }
        return DDMath.atan(n3 - nArray[0], n4 - nArray[1]);
    }

    public static int playerCalculatePassType(int[] nArray) {
        if (GameAI.getPassTargetAlternate(nArray) != null) {
            if (GameLogic.isBallInCrossingZone(GameAI.teamGetPitchSide(nArray[12]))) {
                if (GameAI.isPlayerValidCrossingTarget(nArray, GameAI.getPassTargetAlternate(nArray))) {
                    return 3;
                }
                return 2;
            }
            if (GameLogic.isPlayerAheadOfBall(GameAI.getPassTargetAlternate(nArray)) && !GameLogic.isPlayerOffside(GameAI.getPassTargetAlternate(nArray))) {
                return 1;
            }
        }
        return 2;
    }

    public static int playerCalculateShotRange(int[] nArray) {
        if (nArray[39] < 60) {
            return 6400;
        }
        if (nArray[39] < 70) {
            return 8960;
        }
        return 10240;
    }

    public static boolean playerCanPerformLongPass(int[] nArray) {
        switch (nArray[52]) {
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                int[] nArray2;
                if (!AIController.playerFacingAcrossPitch(nArray) || (nArray2 = GameAI.getPassTargetAlternate(nArray)) == null || nArray2[9] == 0) break;
                return true;
            }
        }
        return false;
    }

    public static boolean playerIsUnderPressure(int[] nArray) {
        int[] nArray2 = AIController.playerGetOpponentWhoseCausingThePressure(nArray);
        return GameLogic.m_nearestPlayerDistanceSquaredStore < AIController.playerGetUnComfortZoneDistance(nArray) && nArray2[28] != 14 && nArray2[28] != 72;
    }

    public static int[] playerGetOpponentWhoseCausingThePressure(int[] nArray) {
        return GameLogic.nearestPlayerData(nArray, GameLogic.m_possession ^ 1, 4);
    }

    public static boolean playerFacingAcrossPitch(int[] nArray) {
        int n2 = DDMath.calcAngle(nArray[0], nArray[1], 12311, nArray[1]);
        return DDMath.CalcModDifference(n2, nArray[22]) < 21;
    }

    public static boolean playerFacingUpPitch(int[] nArray) {
        return DDMath.CalcModDifference(nArray[22], nArray[14]) < 32;
    }

    public static int playerGetUnComfortZoneDistance(int[] nArray) {
        int n2 = nArray[1];
        if (GameAI.teamGetPitchSide(nArray[12]) == 1) {
            n2 = 32015 - n2;
        }
        return 1280 + ((n2 << 8) / 32015 * 5120 >> 8);
    }

    public static void setAIState(int[] nArray, int n2) {
        int n3 = m_state;
        m_state = n2;
        switch (n2) {
            case 1: {
                m_stateTimer = GameLogic.MIN_AI_RUN_TIME;
                break;
            }
            case 2: {
                m_stateTimer = GameLogic.MIN_AI_SPRINT_TIME + (GameLogic.MAX_AI_SPRINT_TIME - GameLogic.MIN_AI_SPRINT_TIME) * nArray[41];
                break;
            }
            case 7: {
                m_stateTimer = GameLogic.MIN_AI_AVOID_DEFENDER_TIME;
                break;
            }
            case 5: {
                m_stateTimer = GameLogic.MIN_STOP_BALL_TIME_BEFORE_NEXT_MOVE;
                break;
            }
            case 13: {
                boolean bl = false;
                for (int i2 = 0; i2 < 11; ++i2) {
                    int[] nArray2;
                    if (i2 == nArray[9] || !GameLogic.isObjectInFinalThird((nArray2 = GameAI.m_playerStorage[nArray[12]][i2])[15], nArray2[16], GameAI.teamGetPitchSide(nArray2[12]))) continue;
                    bl = true;
                }
                if (!bl) {
                    m_state = 14;
                }
                m_stateTimer = GameLogic.MIN_AI_RUN_TIME;
                break;
            }
        }
    }

    public void updateAIState(int[] nArray) {
        int n2 = DDMath.abs(GameAI.m_ballStorage[0] - 12311);
        int n3 = GameAI.teamGetPitchSide(nArray[12]) == 1 ? GameAI.m_ballStorage[1] : 32015 - GameAI.m_ballStorage[1];
        m_actionType = 0;
        switch (m_state) {
            case 0: {
                DDDebug.msg("AI STATES: idle start");
                if (nArray[28] == 10) {
                    DDDebug.msg("AI STATES: idle 1");
                    if (this.playerCheckIfCanShoot(nArray, n2, n3)) {
                        DDDebug.msg("AI STATES: idle 2");
                        this.performAction(nArray, 4);
                    } else if (this.playerCheckIfCanPass(nArray, n2, n3)) {
                        DDDebug.msg("AI STATES: idle 3");
                        this.performAction(nArray, m_actionType);
                    }
                    DDDebug.msg("AI STATES: idle 4");
                    break;
                }
                if (nArray[28] == 9) {
                    DDDebug.msg("AI STATES: idle 5");
                    if (this.playerCheckIfCanOneTwo(nArray, n2, n3)) {
                        DDDebug.msg("AI STATES: idle 6");
                        AIController.setAIState(nArray, 8);
                        break;
                    }
                    if (this.playerCheckIfCanShoot(nArray, n2, n3)) {
                        DDDebug.msg("AI STATES: idle 7");
                        this.performAction(nArray, m_actionType);
                        break;
                    }
                    if (this.playerCheckIfNeedsToClear(nArray, n2, n3)) {
                        DDDebug.msg("AI STATES: idle 8");
                        this.performAction(nArray, m_actionType);
                        break;
                    }
                    if (this.playerCheckIfCanPass(nArray, n2, n3)) {
                        DDDebug.msg("AI STATES: idle 9");
                        this.performAction(nArray, m_actionType);
                        break;
                    }
                    if (this.playerCheckIfNeedsTo180(nArray, n2, n3)) {
                        DDDebug.msg("AI STATES: idle 10");
                        AIController.setAIState(nArray, 12);
                        break;
                    }
                    if (this.playerCheckIfNeedsToFullStop(nArray, n2, n3)) {
                        DDDebug.msg("AI STATES: idle 11");
                        AIController.setAIState(nArray, 5);
                        break;
                    }
                    if (this.playerCheckIfCanSprint(nArray, n2, n3)) {
                        DDDebug.msg("AI STATES: idle 12");
                        AIController.setAIState(nArray, 2);
                        break;
                    }
                    DDDebug.msg("AI STATES: idle 13");
                    AIController.setAIState(nArray, 1);
                    break;
                }
                if (nArray[28] != 138) break;
                DDDebug.msg("AI STATES: idle 14");
                AIController.setAIState(nArray, 6);
                break;
            }
            case 14: {
                nArray[15] = 12311;
                int n4 = nArray[16] = nArray[14] == 0 ? 27382 : 4633;
                if (this.playerCheckIfCanShoot(nArray, n2, n3)) {
                    this.performAction(nArray, m_actionType);
                }
            }
            case 13: {
                nArray[15] = nArray[0];
                int n5 = nArray[16] = nArray[14] == 0 ? 27382 : 4633;
                if (this.playerCheckIfCanPass(nArray, n2, n3)) {
                    this.performAction(nArray, m_actionType);
                }
                if (!GameLogic.isBallInCrossingZone(GameAI.teamGetPitchSide(nArray[12]))) {
                    AIController.setAIState(nArray, 14);
                    break;
                }
                AIController.setAIState(nArray, 13);
                break;
            }
            case 2: {
                this.m_hcpSprint = true;
            }
            case 1: {
                DDDebug.msg("AI STATES: run into space start");
                if (AIController.playerIsUnderPressure(nArray) && AIController.playerGetOpponentWhoseCausingThePressure(nArray) != null) {
                    DDDebug.msg("AI STATES: run into space 1");
                    AIController.setAIState(nArray, 7);
                } else {
                    DDDebug.msg("AI STATES: run into space 2");
                    GameAI.ballSetDribbleDirection(AIController.playerCalculateRunIntoSpaceDirection(nArray));
                }
                if (--m_stateTimer > 0) break;
                DDDebug.msg("AI STATES: run into space 3");
                AIController.setAIState(nArray, 0);
                break;
            }
            case 3: {
                DDDebug.msg("AI STATES: slow down because threatened");
                break;
            }
            case 4: {
                DDDebug.msg("AI STATES: shield ball");
                if (AIController.playerIsUnderPressure(nArray)) {
                    int[] nArray2 = AIController.playerGetOpponentWhoseCausingThePressure(nArray);
                    DDDebug.msg("AI STATES: shield ball 1");
                    GameAI.ballSetDribbleDirection(nArray2[35]);
                    break;
                }
                DDDebug.msg("AI STATES: shield ball 2");
                AIController.setAIState(nArray, 0);
                break;
            }
            case 5: {
                DDDebug.msg("AI STATES: stop ball");
                if (--m_stateTimer > 0) break;
                DDDebug.msg("AI STATES: stop ball 1");
                AIController.setAIState(nArray, 0);
                break;
            }
            case 6: {
                DDDebug.msg("AI STATES: grappling 1");
                int[] nArray3 = GameAI.playerGetMarkTarget(nArray);
                if (nArray3 != null) {
                    DDDebug.msg("AI STATES: grappling 2");
                    nArray[22] = GameAI.grappleCalculateAIDribbleDirection(nArray, nArray3);
                    GameAI.ballSetDribbleDirection(nArray[22]);
                    DDDebug.msg("AI STATES: grappling 3");
                    if (this.playerCheckIfCanShoot(nArray, n2, n3)) {
                        DDDebug.msg("AI STATES: grappling 4");
                        this.performAction(nArray, 4);
                        break;
                    }
                    if (nArray[53] <= GameLogic.AI_GRAPPLE_WITH_BALL_MIN_TIME_DEFAULT) break;
                    DDDebug.msg("AI STATES: grappling 5");
                    AIController.setAIState(nArray, 12);
                    break;
                }
                DDDebug.msg("AI STATES: grappling 6");
                AIController.setAIState(nArray, 0);
                break;
            }
            case 7: {
                DDDebug.msg("AI STATES: avoid defender");
                if (AIController.playerIsUnderPressure(nArray)) {
                    int n6 = nArray[22];
                    int[] nArray4 = AIController.playerGetOpponentWhoseCausingThePressure(nArray);
                    int n7 = nArray4[35] + 128 & 0xFF;
                    int n8 = DDMath.calcTurnAngle(n6, n7);
                    int n9 = n8 > 0 ? 1 : -1;
                    GameAI.m_ballStorage[11] = n6 + 14 * (-1 * n9) & 0xFF;
                    m_stateTimer = GameLogic.MIN_AI_AVOID_DEFENDER_TIME;
                } else if (--m_stateTimer <= 0) {
                    DDDebug.msg("AI STATES: avoid defender 2");
                    AIController.setAIState(nArray, 0);
                }
                DDDebug.msg("AI STATES: avoid defender 3");
                if (!this.playerCheckIfCanShoot(nArray, n2, n3)) break;
                DDDebug.msg("AI STATES: avoid defender 4");
                this.performAction(nArray, m_actionType);
                break;
            }
            case 12: {
                DDDebug.msg("AI STATES: break away 0");
                this.performAction(nArray, 7);
                DDDebug.msg("AI STATES: break away  1");
                AIController.setAIState(nArray, 1);
                break;
            }
            case 8: {
                DDDebug.msg("AI STATES: perform one two");
                break;
            }
            case 9: {
                DDDebug.msg("AI STATES: arun towards goal.");
                break;
            }
            case 10: {
                DDDebug.msg("AI STATES: first time pass");
                break;
            }
            case 11: {
                DDDebug.msg("AI STATES: clear the ball");
            }
        }
    }
}

