/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.DDMath;
import com.ea.game.GameAI;
import com.ea.game.GameLogic;
import com.ea.game.XMLMenuSystem;

public class GameFormation {
    public static int[][] m_formationGlobalZones;
    public static int[][] m_menuStrategyZones;
    public static int[] m_debugViewZones;
    public static int[][] m_formationsList;
    public static int[][] m_freeKickWallPositions;
    public static final int FZONE_DEFENCE = 0;
    public static final int FZONE_MID_FIELD = 1;
    public static final int FZONE_FORWARDS = 2;
    public static final int NUM_ZONES = 3;
    public static final int FZONE_YSTART = 0;
    public static final int FZONE_YEND = 1;
    public static final int FZONE_COLOUR = 2;
    public static final int FZONE_SIZE = 3;
    public static final int PTYPE_GOALIE = 0;
    public static final int PTYPE_DEFENDER = 1;
    public static final int PTYPE_MIDFIELDER = 2;
    public static final int PTYPE_FORWARD = 3;
    public static final int PTYPE_FORWARD_2 = 4;
    public static final int TFORM_4_4_2 = 0;
    public static final int TFORM_4_2_2_2 = 1;
    public static final int TFORM_4_1_3_2 = 2;
    public static final int TFORM_4_4_2_Diamond = 3;
    public static final int TFORM_4_5_1 = 4;
    public static final int TFORM_4_2_3_1 = 5;
    public static final int TFORM_4_3_2_1 = 6;
    public static final int TFORM_4_4_1_1 = 7;
    public static final int TFORM_4_3_3 = 8;
    public static final int TFORM_5_4_1 = 9;
    public static final int TFORM_5_3_2 = 10;
    public static final int TFORM_3_5_2 = 11;
    public static final int TFORM_3_4_3 = 12;
    public static final int NUM_FORMATIONS = 13;
    public static final int PP_GK = 0;
    public static final int PP_RB = 1;
    public static final int PP_RCB = 2;
    public static final int PP_CB = 3;
    public static final int PP_LCB = 4;
    public static final int PP_LB = 5;
    public static final int PP_RM = 6;
    public static final int PP_RCM = 7;
    public static final int PP_CM = 8;
    public static final int PP_LCM = 9;
    public static final int PP_LM = 10;
    public static final int PP_ARM = 11;
    public static final int PP_ACM = 12;
    public static final int PP_ALM = 13;
    public static final int PP_DCM = 14;
    public static final int PP_RS = 15;
    public static final int PP_CS = 16;
    public static final int PP_LS = 17;
    public static final int PP_MAX_POSITIONS = 18;
    public static final int PP_SUB = 18;
    public static final int PP_RES = 19;
    public static final int TSTRATEGY_DEFENSIVE = 0;
    public static final int TSTRATEGY_NEUTRAL = 1;
    public static final int TSTRATEGY_ATTACKING = 2;
    public static final int GOALIE_XMULT = 29;
    public static final int GOALIE_YMULT = 30;
    public static final int GOAL_KEEPER_PENALTY_YPOS = 51;
    private static final int PENALTY_EXCLUSION_ZONE_WIDTH = 1024;
    private static final int PENALTY_EXCLUSION_ZONE_HEIGHT = 4889;
    public static final int[] m_posFormationExample;
    public static final int[] m_posFormationIndexExample;
    public static final int[][] playerFormationPlayerTypes;
    private static int teamX;
    private static int[][] zoneYLine;
    public static int[][] zoneHeight;
    public static int[][] m_playerList;
    public static int[][] mf_selctorder;
    private static int m_markingStyleBiasMinDistanceSqdFromTarget;
    private static int m_markingStyleBiasMaxDistanceSqdFromTarget;
    private static int m_markingStyleBiasTargetX;
    private static int m_markingStyleBiasTargetY;
    private static int m_markingStyleBiasPercentToMoveTowardsTarget;
    private static int m_markingStyleNumSupportingPlayers;
    public static final int CALC_FORMATION_DATA_X = 0;
    public static final int CALC_FORMATION_DATA_Y = 1;
    public static final int CALC_FORMATION_DATA_TYPE = 2;
    public static final int CALC_FORMATION_DATA_SIZE = 3;
    public static final int CALC_FORMATION_ORIENTATION_VERTICAL = 0;
    public static final int CALC_FORMATION_ORIENTATION_HORIZONTAL = 1;
    public static int m_interceptionLocalX;
    public static int m_interceptionLocalY;
    private static final int RUSH_INTO_SHOOT_ZONE_Y_OFFSET = 1024;
    private static final int RUSH_INTO_SHOOT_ZONE_UPFIELD_LS_X = 10763;
    private static final int RUSH_INTO_SHOOT_ZONE_UPFIELD_ALM_X = 9214;
    private static final int RUSH_INTO_SHOOT_ZONE_UPFIELD_LCM_X = 10763;
    private static final int RUSH_INTO_SHOOT_ZONE_UPFIELD_RS_X = 13859;
    private static final int RUSH_INTO_SHOOT_ZONE_UPFIELD_ARM_X = 15408;
    private static final int RUSH_INTO_SHOOT_ZONE_UPFIELD_RCM_X = 13859;
    private static final int RUSH_INTO_SHOOT_ZONE_UPFIELD_CS_X = 12311;
    private static final int RUSH_INTO_SHOOT_ZONE_UPFIELD_LS_Y = 29448;
    private static final int RUSH_INTO_SHOOT_ZONE_UPFIELD_ALM_Y = 28677;
    private static final int RUSH_INTO_SHOOT_ZONE_UPFIELD_LCM_Y = 27905;
    private static final int RUSH_INTO_SHOOT_ZONE_UPFIELD_RS_Y = 29448;
    private static final int RUSH_INTO_SHOOT_ZONE_UPFIELD_ARM_Y = 28677;
    private static final int RUSH_INTO_SHOOT_ZONE_UPFIELD_RCM_Y = 27905;
    private static final int RUSH_INTO_SHOOT_ZONE_UPFIELD_CS_Y = 28677;
    private static final int RUSH_INTO_SHOOT_ZONE_DOWNFIELD_LS_X = 13859;
    private static final int RUSH_INTO_SHOOT_ZONE_DOWNFIELD_ALM_X = 15408;
    private static final int RUSH_INTO_SHOOT_ZONE_DOWNFIELD_LCM_X = 13859;
    private static final int RUSH_INTO_SHOOT_ZONE_DOWNFIELD_RS_X = 10763;
    private static final int RUSH_INTO_SHOOT_ZONE_DOWNFIELD_ARM_X = 9214;
    private static final int RUSH_INTO_SHOOT_ZONE_DOWNFIELD_RCM_X = 10763;
    private static final int RUSH_INTO_SHOOT_ZONE_DOWNFIELD_CS_X = 12311;
    private static final int RUSH_INTO_SHOOT_ZONE_DOWNFIELD_LS_Y = 2567;
    private static final int RUSH_INTO_SHOOT_ZONE_DOWNFIELD_ALM_Y = 3338;
    private static final int RUSH_INTO_SHOOT_ZONE_DOWNFIELD_LCM_Y = 4110;
    private static final int RUSH_INTO_SHOOT_ZONE_DOWNFIELD_RS_Y = 2567;
    private static final int RUSH_INTO_SHOOT_ZONE_DOWNFIELD_ARM_Y = 3338;
    private static final int RUSH_INTO_SHOOT_ZONE_DOWNFIELD_RCM_Y = 4110;
    private static final int RUSH_INTO_SHOOT_ZONE_DOWNFIELD_CS_Y = 3338;
    private static final int OVERLAPPING_RUN_AHEAD_OF_DRIBBLER_DISTANCE = 15;

    public static void initFormations() {
        m_formationGlobalZones = new int[18][3];
        m_debugViewZones = new int[18];
        m_menuStrategyZones = new int[18][3];
        zoneYLine = new int[2][18];
    }

    public static int getBallFreeKickZone(int[] nArray) {
        int n2 = nArray[0];
        int n3 = nArray[1];
        boolean bl = false;
        if (GameAI.teamGetPitchSide(GameLogic.m_possession) == 0) {
            n3 = 32015 - n3;
        }
        for (int i2 = 0; i2 < 9; ++i2) {
            if (n2 < m_freeKickWallPositions[i2][0] || n2 > m_freeKickWallPositions[i2][2] || n3 < m_freeKickWallPositions[i2][1] || n3 > m_freeKickWallPositions[i2][3]) continue;
            return i2;
        }
        return 0;
    }

    public static void updateLevel1() {
        GameFormation.updateLevel1ZoneYLine();
        GameFormation.updateLevel1MarkingStyleBiasSettings();
        GameFormation.updateLevel1FormationPositions();
        GameFormation.exclusionZonesAdjustment();
    }

    public static void updateLevel1ZoneYLine() {
        int n2 = 0;
        teamX = 0;
        for (int i2 = 0; i2 < 2; ++i2) {
            if (GameLogic.m_matchState == 17 || GameLogic.m_matchState == 10 || GameLogic.m_matchState == 14 || GameLogic.m_matchState == 1 && GameLogic.m_matchSubState == 6) {
                n2 = 16007;
            } else if (GameLogic.m_matchState == 6) {
                n2 = GameAI.m_ballStorage[1] < 16007 ? 4001 : 28014;
            } else if (GameLogic.m_matchState == 9) {
                n2 = 16007;
            } else {
                teamX = GameAI.m_ballStorage[0];
                n2 = GameAI.m_ballStorage[1];
            }
            teamX = DDMath.max(teamX, 256);
            teamX = DDMath.min(teamX, 24366);
            n2 = DDMath.max(n2, 256);
            n2 = DDMath.min(n2, 31759);
            if (GameAI.teamGetPitchSide(i2) == 1) {
                n2 = 32015 - n2;
            }
            for (int i3 = 1; i3 < 18; ++i3) {
                GameFormation.zoneHeight[i2][i3] = m_formationGlobalZones[i3][1] - m_formationGlobalZones[i3][0];
                int n3 = (zoneHeight[i2][i3] << 8) / 32015;
                GameFormation.zoneYLine[i2][i3] = m_formationGlobalZones[i3][0] + (n2 * n3 >> 8);
            }
        }
    }

    private static void updateLevel1MarkingStyleBiasSettings() {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        switch (XMLMenuSystem.teamTacticalOptionsMarkingStyleGet(GameLogic.m_possession ^ 1)) {
            case 2: {
                m_markingStyleNumSupportingPlayers = 1;
                n2 = 2560;
                n3 = 3840;
                n4 = 25;
                m_markingStyleBiasPercentToMoveTowardsTarget = 25;
                break;
            }
            case 1: {
                m_markingStyleNumSupportingPlayers = 2;
                n2 = 1280;
                n3 = 6400;
                n4 = 25;
                m_markingStyleBiasPercentToMoveTowardsTarget = 40;
                break;
            }
            case 0: {
                m_markingStyleNumSupportingPlayers = 2;
                n2 = 256;
                n3 = 8960;
                n4 = 10;
                m_markingStyleBiasPercentToMoveTowardsTarget = 95;
            }
        }
        m_markingStyleBiasMinDistanceSqdFromTarget = n2 * n2;
        m_markingStyleBiasMaxDistanceSqdFromTarget = n3 * n3;
        int n5 = GameAI.teamGetPitchSide(GameLogic.m_possession) == 1 ? 32015 : 0;
        int n6 = GameAI.m_ballStorage[0] - 12311;
        int n7 = GameAI.m_ballStorage[1] - n5;
        m_markingStyleBiasTargetX = GameAI.m_ballStorage[0] + n6 * n4 / 100;
        m_markingStyleBiasTargetY = GameAI.m_ballStorage[1] + n7 * n4 / 100;
    }

    public static void updateLevel1FormationPositions() {
        for (int i2 = 0; i2 < 2; ++i2) {
            int n2 = 1;
            short s = GameAI.m_teamStorage[i2][4];
            int n3 = GameAI.teamGetPitchSide(i2);
            int n4 = m_formationsList[s][0];
            int n5 = GameAI.m_teamStorage[i2][0] & 4;
            boolean[] blArray = new boolean[]{true, true, true};
            if (GameAI.m_ballStorage[1] > zoneYLine[i2][1]) {
                blArray[0] = false;
            } else {
                blArray[2] = false;
            }
            int n6 = i2 == GameLogic.m_possession ? 0x3200000 : 0x1880000;
            for (int i3 = 1; i3 < n4 + 1; ++i3) {
                int n7;
                int n8 = n7 = m_formationsList[s][i3];
                int n9 = n7 - 1;
                while (n9 >= 0) {
                    int n10;
                    int n11;
                    int n12 = n7;
                    int n13 = n9;
                    int[] nArray = GameAI.m_playerStorage[i2][n2];
                    nArray[48] = i3;
                    if (GameLogic.m_matchState == 2 && (n11 = nArray[0] - nArray[25]) * n11 + (n10 = nArray[1] - nArray[26]) * n10 < n6) {
                        n12 = n8;
                    }
                    nArray[25] = n13 * (24622 / n12) + 24622 / (n12 << 1);
                    n11 = 290;
                    if (n12 == 2) {
                        n11 = 128;
                    }
                    nArray[25] = nArray[25] - 12311;
                    nArray[25] = nArray[25] * n11;
                    nArray[25] = nArray[25] / 256;
                    nArray[25] = nArray[25] + 12311;
                    int n14 = zoneYLine[i2][nArray[52]];
                    n14 += GameFormation.updateLevel1FormationPositionsGetPlayerStrategyBias(nArray);
                    n14 = GameFormation.updateLevel1FormationPositionsKeepPlayersOnside(i2, n14, n3);
                    nArray[26] = n14 = DDMath.restrictRange(n14, 0, 32015);
                    if (n3 != 0) {
                        nArray[25] = 24622 - nArray[25];
                    }
                    int n15 = nArray[0] - GameAI.m_ballStorage[0];
                    n14 = nArray[1] - GameAI.m_ballStorage[1];
                    n10 = DDMath.sqrtRout(n15 * n15 + n14 * n14);
                    int n16 = DDMath.atan(n15, n14);
                    n15 = nArray[25] - GameAI.m_ballStorage[0];
                    n14 = nArray[26] - GameAI.m_ballStorage[1];
                    int n17 = DDMath.atan(n15, n14);
                    int n18 = DDMath.sqrtRout(n15 * n15 + n14 * n14);
                    if (i2 == GameLogic.m_possession && GameLogic.m_matchState == 2 && (nArray[36] << 8 < 1280 || n18 < 1280)) {
                        n10 = DDMath.max(n10, 2560);
                        n18 = DDMath.max(n18, 2560);
                        n10 = DDMath.min(n10, n18);
                        nArray[25] = GameAI.m_ballStorage[0] + (DDMath.sin(n16 -= DDMath.calcTurnAngle(n17, n16) > 0 ? 5 : -5) * n10 >> 16);
                        nArray[26] = GameAI.m_ballStorage[1] + (DDMath.cos(n16) * n10 >> 16);
                    }
                    if (n5 == 0) {
                        nArray[25] = ((nArray[25] - 12311) * 3 >> 2) + 12311;
                    }
                    --n9;
                    ++n2;
                }
            }
            GameFormation.updateLevel1FormationPositionsProvideSupportPlayersToMarkingTeam();
            GameFormation.updateLevel1FormationPositionsDefendersTrackback(i2);
        }
    }

    private static int updateLevel1FormationPositionsGetPlayerStrategyBias(int[] nArray) {
        if ((GameLogic.m_matchState != 1 || GameLogic.m_matchSubState != 11 && GameLogic.m_matchSubState != 1 && GameLogic.m_matchSubState != 2 && GameLogic.m_matchSubState != 4 && GameLogic.m_matchSubState != 3) && (GameLogic.m_matchState != 10 && GameLogic.m_matchState != 11 && GameLogic.m_matchState != 14 && GameLogic.m_matchState != 17 || nArray[52] != 1 && nArray[52] != 2 && nArray[52] != 3 && nArray[52] != 4 && nArray[52] != 5)) {
            switch (XMLMenuSystem.teamTacticalOptionsTacticsGet(nArray[12])) {
                case 0: {
                    return -1792;
                }
                case 2: {
                    return 3072;
                }
            }
        }
        return 0;
    }

    private static int updateLevel1FormationPositionsKeepPlayersOnside(int n2, int n3, int n4) {
        if (GameLogic.m_gameMode != 2 && (GameLogic.m_matchState == 2 || GameLogic.m_matchState == 9 || GameLogic.m_matchState == 6 || GameLogic.m_matchState == 5)) {
            if (n4 == 1) {
                n3 = 32015 - n3;
                n3 = DDMath.max(n3, GameLogic.m_offsideline[n2 ^ 1] + 1280);
            } else {
                n3 = DDMath.min(n3, GameLogic.m_offsideline[n2 ^ 1] - 1280);
            }
        } else if (n4 == 1) {
            n3 = 32015 - n3;
        }
        return n3;
    }

    private static void updateLevel1FormationPositionsDefendersTrackback(int n2) {
        int n3 = GameFormation.getDefenders(n2, m_playerList);
        if (GameLogic.m_matchState == 2) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4;
                if (GameAI.teamGetPitchSide(n2) == 0) {
                    n4 = DDMath.max(GameAI.m_ballStorage[1] - 1280, 256);
                    GameFormation.m_playerList[i2][26] = DDMath.min(n4, m_playerList[i2][26]);
                } else {
                    n4 = DDMath.min(GameAI.m_ballStorage[1] + 1280, 31759);
                    GameFormation.m_playerList[i2][26] = DDMath.max(n4, m_playerList[i2][26]);
                }
                n4 = teamX - m_playerList[i2][25];
                int n5 = DDMath.abs(n4);
                n5 = DDMath.max(n5, 19941);
                n5 = DDMath.min(n5, 104561);
                n4 = n4 * (256 - (n5 << 8) / 104561) >> 8;
                GameFormation.m_playerList[i2][25] = teamX - n4;
            }
        }
    }

    private static void updateLevel1FormationPositionsProvideSupportPlayersToMarkingTeam() {
        int[] nArray;
        int n2;
        int n3;
        if (GameLogic.m_matchState != 2) {
            return;
        }
        int[] nArray2 = new int[11];
        int[] nArray3 = new int[11];
        int[] nArray4 = new int[11];
        int[] nArray5 = new int[11];
        for (n3 = 0; n3 < 11; ++n3) {
            nArray5[n3] = 1024960225;
        }
        n3 = 0;
        for (n2 = 1; n2 < 11; ++n2) {
            nArray = GameAI.m_playerStorage[GameLogic.m_possession ^ 1][n2];
            if (nArray[28] == 93) continue;
            nArray2[n2] = m_markingStyleBiasTargetX - nArray[25];
            nArray3[n2] = m_markingStyleBiasTargetY - nArray[26];
            nArray4[n2] = nArray2[n2] * nArray2[n2] + nArray3[n2] * nArray3[n2];
            if (nArray4[n2] < m_markingStyleBiasMinDistanceSqdFromTarget || nArray4[n2] > m_markingStyleBiasMaxDistanceSqdFromTarget) continue;
            nArray5[n3++] = nArray4[n2];
        }
        DDMath.sort(nArray5);
        for (int i2 = 0; i2 < n3 && i2 < m_markingStyleNumSupportingPlayers; ++i2) {
            n2 = nArray5[i2];
            for (int i3 = 1; i3 < 11; ++i3) {
                if (nArray4[i3] != n2) continue;
                nArray = GameAI.m_playerStorage[GameLogic.m_possession ^ 1][i3];
                nArray[25] = nArray[25] + nArray2[i3] * m_markingStyleBiasPercentToMoveTowardsTarget / 100;
                nArray[26] = nArray[26] + nArray3[i3] * m_markingStyleBiasPercentToMoveTowardsTarget / 100;
            }
        }
    }

    public static void updateLevel2() {
        GameFormation.updateLevel2Marking();
        GameFormation.updateLevel2OverlappingRunAndRushIntoShootZone();
    }

    private static void updateLevel2Marking() {
        int[] nArray;
        if (GameLogic.isFreeBallSituation()) {
            return;
        }
        int n2 = -1;
        int n3 = 0x40000000;
        boolean bl = false;
        int[] nArray2 = GameAI.teamFindPlayerInState(GameLogic.m_possession ^ 1, 93);
        for (int i2 = 1; i2 < 11; ++i2) {
            int n4;
            nArray = GameAI.m_playerStorage[GameLogic.m_possession ^ 1][i2];
            if (nArray[48] == 0 || ((n4 = nArray[28]) != 71 && n4 != 0 && n4 != 93 && n4 != 91 && n4 != 59 && n4 != 139 || nArray == GameLogic.m_controller[GameLogic.m_possession ^ 1].m_controlPlayer) && n4 != 139) continue;
            int n5 = GameAI.m_ballStorage[0] + GameAI.m_ballStorage[3] * 8 - nArray[0];
            int n6 = GameAI.m_ballStorage[1] + GameAI.m_ballStorage[4] * 8 - nArray[1];
            if (nArray[48] == 1 && (nArray2 == null || nArray2 != null && nArray2[48] != 1)) {
                n5 = n5 * 60 / 100;
                n6 = n6 * 60 / 100;
                if (GameLogic.isObjectIn18YardBox(GameAI.m_ballStorage, GameAI.teamGetPitchSide(GameLogic.m_possession ^ 1))) {
                    n5 /= 20;
                    n6 /= 20;
                }
            }
            if (nArray[28] == 139) {
                n5 = 0;
                n6 = 0;
            }
            if (nArray[28] == 93 || nArray[28] == 13) {
                n5 = n5 * 245 >> 8;
                n6 = n6 * 245 >> 8;
            }
            if (n2 != -1 && n5 * n5 + n6 * n6 >= n3) continue;
            n3 = n5 * n5 + n6 * n6;
            n2 = i2;
        }
        if (n2 != -1) {
            int[] nArray3 = GameAI.m_playerStorage[GameLogic.m_possession ^ 1][n2];
            if (GameAI.m_playerWithBall != null && GameLogic.isObjectIn18YardBox(GameAI.m_playerWithBall, GameAI.teamGetPitchSide(GameLogic.m_possession ^ 1)) && nArray3 != nArray2 && nArray3[48] == 1 && (nArray2 == null || nArray2 != null && nArray2[48] != 1 && (GameAI.teamGetPitchSide(GameLogic.m_possession) == 0 && nArray2[1] < nArray3[1] || GameAI.teamGetPitchSide(GameLogic.m_possession) == 1 && nArray2[1] > nArray3[1]) && DDMath.calcHorizontalDistSquared(nArray2, GameAI.m_playerWithBall) >= 16384)) {
                if (nArray2 != null) {
                    GameAI.playerSetState(nArray2, 0, 0, 71);
                }
                bl = true;
            }
            if (GameAI.teamFindPlayerInState(GameLogic.m_possession ^ 1, 93) == null || bl) {
                for (int i3 = 0; i3 < 11; ++i3) {
                    nArray = GameAI.m_playerStorage[GameLogic.m_possession ^ 1][i3];
                    if (i3 == n2) {
                        if (nArray[28] == 93 || nArray[28] == 139 || nArray[28] == 91 || nArray[28] == 59 || nArray[28] == 13 || !GameAI.ballIsPossessed() || GameAI.teamGetControlType(nArray[12]) == 2 && nArray[48] != 1 && nArray[52] != 14) continue;
                        int n7 = GameAI.markingGetOneInXChanceOfSettingPlayerIntoMarking(GameLogic.m_possession ^ 1, nArray);
                        if ((GameLogic.m_quickPlayMomentConfusedAITimer > 0 || DDMath.getPositiveRandom() % n7 != 0) && !bl) continue;
                        GameAI.playerSetState(nArray, 0, 0, 93);
                        continue;
                    }
                    if (nArray[28] != 93 || GameLogic.m_controller[GameLogic.m_possession ^ 1].m_microGame.inProgress()) continue;
                    GameAI.playerSetState(nArray, 0, 0, 0);
                }
            }
        }
    }

    private static void updateLevel2OverlappingRunAndRushIntoShootZone() {
        int n2 = GameAI.m_ballStorage[10];
        int[] nArray = GameAI.m_playerStorage[n2 & 1][n2 >> 1];
        for (int i2 = 0; i2 < 2; ++i2) {
            block7: for (int i3 = 0; i3 < 11; ++i3) {
                int[] nArray2 = GameAI.m_playerStorage[i2][i3];
                if (nArray == nArray2 || nArray2[28] != 0 && nArray2[28] != 71) continue;
                switch (nArray2[52]) {
                    case 0: {
                        continue block7;
                    }
                    case 1: 
                    case 5: {
                        GameFormation.overlappingRunUpdate(nArray2, i2, nArray);
                        continue block7;
                    }
                    case 14: {
                        if (GameLogic.m_possession != i2) continue block7;
                        continue block7;
                    }
                    case 7: 
                    case 9: 
                    case 11: 
                    case 13: 
                    case 15: 
                    case 16: 
                    case 17: {
                        GameFormation.rushIntoShootZoneUpdate(nArray2, i2);
                    }
                }
            }
        }
    }

    public static int[][] calcFormation(int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int[][] nArray = new int[11][3];
        int n13 = m_formationsList[n2][0];
        if (n7 == 0) {
            n12 = 0;
            n11 = 1;
        } else {
            n12 = 1;
            n11 = 0;
            n10 = n4;
            n4 = n5;
            n5 = n10;
        }
        int n14 = 0;
        nArray[n14][n12] = 12311;
        nArray[n14][n11] = 0;
        n14 = 1;
        for (n9 = 1; n9 < n13 + 1; ++n9) {
            n10 = m_formationsList[n2][n9];
            n8 = n10 - 1;
            while (n8 >= 0) {
                nArray[n14][n12] = n8 * (24622 / n10) + 24622 / (n10 * 2);
                nArray[n14][n11] = n9 * (32015 / (n13 + 1));
                --n8;
                ++n14;
            }
        }
        n9 = n4 * n6 / 100;
        n8 = n5 * n6 / 100;
        for (n14 = 0; n14 < 11; ++n14) {
            nArray[n14][2] = GameFormation.getPlayerType(playerFormationPlayerTypes[n2][n14]);
            nArray[n14][n12] = nArray[n14][n12] / (24622 / (n4 - n9 * 2));
            nArray[n14][n11] = nArray[n14][n11] / (32015 / (n5 - n8 * 2));
            int[] nArray2 = nArray[n14];
            int n15 = n12;
            nArray2[n15] = nArray2[n15] + n9;
            int[] nArray3 = nArray[n14];
            int n16 = n11;
            nArray3[n16] = nArray3[n16] + n8;
            if (n14 > 0) {
                if (n3 == 0) {
                    int[] nArray4 = nArray[n14];
                    int n17 = n11;
                    nArray4[n17] = nArray4[n17] - n8 / 2;
                } else if (n3 == 2) {
                    int[] nArray5 = nArray[n14];
                    int n18 = n11;
                    nArray5[n18] = nArray5[n18] + n8 / 2;
                }
            }
            if (n7 != 0) continue;
            nArray[n14][n12] = n4 - nArray[n14][n12];
        }
        return nArray;
    }

    public static void setUpWalls() {
        block2: {
            int n2;
            int n3 = GameAI.m_ballStorage[0];
            int n4 = GameAI.m_ballStorage[1];
            if (GameLogic.m_gameMode == 5 && GameLogic.freeKickChallengeGetPlayersInWall() == 0) {
                return;
            }
            if (!GameLogic.isAttackingFreeKick()) break block2;
            GameLogic.calculateNearFarGoalPostPositions(GameAI.teamGetPitchSide(GameLogic.m_possession ^ 1));
            int n5 = DDMath.atan(GameLogic.m_nearGoalPostX - n3, GameLogic.m_nearGoalPostY - n4);
            int n6 = DDMath.atan(GameLogic.m_farGoalPostX - n3, GameLogic.m_farGoalPostY - n4);
            int n7 = n3 + (DDMath.sin(n5) * 2688 >> 16);
            int n8 = n4 + (DDMath.cos(n5) * 2688 >> 16);
            int n9 = n5 + (DDMath.calcTurnAngle(n5, n6) > 0 ? 64 : -64);
            n7 += (DDMath.sin((n9 &= 0xFF) + 128) & 0xFF) * 384 >> 16;
            n8 += (DDMath.cos(n9 + 128) & 0xFF) * 384 >> 16;
            int n10 = 0;
            int n11 = 11;
            do {
                int n12 = n7 + (DDMath.sin(n9) * (384 * n10) >> 16);
                int n13 = n8 + (DDMath.cos(n9) * (384 * n10) >> 16);
                n11 = GameFormation.getNextWallPlayerID(GameLogic.m_possession ^ 1, n11);
                GameAI.playerSetState(GameAI.m_playerStorage[GameLogic.m_possession ^ 1][n11], n12, n13, 20);
                n2 = DDMath.atan(n12 - n3, n13 - n4);
            } while (GameLogic.m_gameMode != 5 ? DDMath.CalcModDifference(n5, n6) > DDMath.CalcModDifference(n5, n2) : ++n10 != GameLogic.freeKickChallengeGetPlayersInWall());
        }
    }

    public static int getNextWallPlayerID(int n2, int n3) {
        for (int i2 = 0; i2 < 11; ++i2) {
            int[] nArray;
            if (--n3 < 1) {
                n3 = 10;
            }
            if ((nArray = GameAI.m_playerStorage[n2][n3])[49] == 2) continue;
            return n3;
        }
        return n3;
    }

    public static void exclusionZonesAdjustment() {
        int[] nArray;
        int n2;
        int n3;
        if (GameLogic.m_matchState == 1 && (GameLogic.m_matchSubState == 1 || GameLogic.m_matchSubState == 11 || GameLogic.m_matchSubState == 2 || GameLogic.m_matchSubState == 3 || GameLogic.m_matchSubState == 4)) {
            for (n3 = 0; n3 < 2; ++n3) {
                for (n2 = 0; n2 < 11; ++n2) {
                    nArray = GameAI.m_playerStorage[n3][n2];
                    nArray[26] = GameAI.teamGetPitchSide(n3) == 0 ? DDMath.min(nArray[26], 15239) : DDMath.max(nArray[26], 16775);
                }
            }
            GameFormation.exclusionFromArea(12311, 16007, 3353);
        }
        if (GameLogic.m_matchState == 8) {
            for (n3 = 0; n3 < 2; ++n3) {
                for (n2 = 0; n2 < 11; ++n2) {
                    nArray = GameAI.m_playerStorage[n3][n2];
                    if (12311 - nArray[25] < 1024 && 12311 - nArray[25] > -1024) {
                        nArray[25] = 11287;
                    }
                    nArray[26] = GameAI.m_ballStorage[1] < 16007 ? DDMath.max(nArray[26], 4889) : DDMath.min(nArray[26], 27126);
                }
            }
        }
        if (GameLogic.m_matchState == 9) {
            GameFormation.exclusionFromArea(GameAI.m_ballStorage[0], GameAI.m_ballStorage[1], 2688);
        }
        if (GameLogic.m_matchState == 9) {
            GameFormation.exclusionFromArea(GameAI.m_ballStorage[0], GameAI.m_ballStorage[1], 2688);
        }
        if (GameLogic.m_matchState == 5) {
            GameFormation.exclusionFromArea(GameAI.m_ballStorage[0], GameAI.m_ballStorage[1], 2688);
        }
        if (GameLogic.m_gameMode == 2 && XMLMenuSystem.m_currTutorial == 6) {
            for (int i2 = 1; i2 < 11; ++i2) {
                nArray = GameAI.m_playerStorage[1][i2];
                nArray[1] = DDMath.min(nArray[1], 27382);
            }
        }
    }

    public static void exclusionFromArea(int n2, int n3, int n4) {
        for (int i2 = 0; i2 < 2; ++i2) {
            for (int i3 = 0; i3 < 11; ++i3) {
                int[] nArray = GameAI.m_playerStorage[i2][i3];
                int n5 = n2 - nArray[25];
                int n6 = n3 - nArray[26];
                if (n5 * n5 + n6 * n6 >= n4 * n4) continue;
                int n7 = DDMath.atan(n5, n6);
                nArray[25] = n2 + ((DDMath.sin(n7 + 128) >> 8) * n4 >> 8);
                nArray[26] = n3 + ((DDMath.cos(n7 + 128) >> 8) * n4 >> 8);
            }
        }
    }

    public static void setKickOffPositions() {
        GameFormation.updateLevel1();
        for (int i2 = 0; i2 < 2; ++i2) {
            for (int i3 = 0; i3 < 11; ++i3) {
                int n2 = GameAI.m_playerStorage[i2][i3][26];
                if (GameAI.teamGetPitchSide(i2) == 1) {
                    n2 = 32015 - n2;
                }
                n2 = n2 * 240 >> 8;
                n2 = DDMath.min(n2, 15751);
                if (GameAI.teamGetPitchSide(i2) == 1) {
                    n2 = 32015 - n2;
                }
                GameAI.m_playerStorage[i2][i3][26] = n2;
            }
        }
        GameFormation.exclusionZonesAdjustment();
    }

    public static void setKickOffPositionsPenalty() {
        for (int i2 = 0; i2 < 2; ++i2) {
            for (int i3 = 0; i3 < 11; ++i3) {
                int[] nArray = GameAI.m_playerStorage[i2][i3];
                nArray[25] = nArray[0] = 6155 + i2 * 8207 + (DDMath.getRandom() & 0xFFFF) % 3077;
                nArray[26] = nArray[1] = 16007 + (DDMath.getRandom() & 0xFFFF) % 3077;
                nArray[27] = 0;
            }
        }
    }

    public static void kickOffByPass() {
        for (int i2 = 0; i2 < 2; ++i2) {
            for (int i3 = 0; i3 < 11; ++i3) {
                int[] nArray = GameAI.m_playerStorage[i2][i3];
                int n2 = nArray[0] - nArray[25];
                int n3 = nArray[1] - nArray[26];
                if (n2 * n2 + n3 * n3 > 753424) {
                    nArray[0] = nArray[25];
                    nArray[1] = nArray[26];
                    nArray[15] = nArray[25];
                    nArray[16] = nArray[26];
                }
                nArray[30] = (4 - nArray[48]) * 8;
            }
        }
        GameFormation.setGoalKeepersToTheirBaseLine();
    }

    public static void jumpPlayersToTheirPositions() {
        int[] nArray;
        int n2;
        int n3;
        if (GameLogic.m_stateTimer > 2 || GameLogic.m_stateTimer < 0) {
            GameLogic.m_stateTimer = 2;
        }
        for (n3 = 0; n3 < 2; ++n3) {
            for (n2 = 0; n2 < 11; ++n2) {
                nArray = GameAI.m_playerStorage[n3][n2];
                if (GameLogic.m_setPieceWideTargetObject != null && nArray == GameLogic.m_setPieceWideTargetObject) continue;
                int n4 = nArray[28];
                if (n4 == 0 || n4 == 71 || n4 == 26) {
                    nArray[0] = nArray[25];
                    nArray[1] = nArray[26];
                    continue;
                }
                if (n4 == 81) {
                    if (n3 == 1) {
                        nArray[0] = nArray[25];
                        nArray[1] = nArray[26];
                        GameAI.playerSetState(nArray, 0, 0, 0);
                        continue;
                    }
                    if (nArray[0] < 12311) {
                        nArray[0] = -1024;
                        continue;
                    }
                    nArray[0] = 24622;
                    continue;
                }
                nArray[0] = nArray[15];
                nArray[1] = nArray[16];
            }
        }
        GameLogic.offsideLineUpdate();
        for (n3 = 0; n3 < 2; ++n3) {
            for (n2 = 1; n2 < 11; ++n2) {
                nArray = GameAI.m_playerStorage[n3][n2];
                if (nArray[28] == 12 || nArray[28] == 11) continue;
                nArray[1] = GameAI.teamGetPitchSide(n3) == 0 ? DDMath.min(nArray[1], GameLogic.m_offsideline[n3 ^ 1] - 512) : DDMath.max(nArray[1], GameLogic.m_offsideline[n3 ^ 1] + 512);
            }
        }
    }

    public static void keeperUpdateLevel1(int n2, int[] nArray) {
        int n3;
        int n4;
        int n5 = (GameAI.m_ballStorage[0] * 29 >> 8) + (12311 - GameLogic.m_goalWidth / 2);
        int n6 = GameAI.teamGetPitchSide(n2) == 0 ? 51 : 31964;
        n5 = DDMath.max(n5, 0);
        n5 = DDMath.min(n5, 24622);
        n6 = DDMath.max(n6, 0);
        n6 = DDMath.min(n6, 32015);
        if (GameLogic.m_matchState == 6) {
            nArray[25] = 12311;
            nArray[26] = n6;
            return;
        }
        if (!(GameLogic.m_gameMode != 99 && GameLogic.m_matchPeriod != 4 || GameLogic.m_matchState != 8 && GameLogic.m_matchNextState != 8)) {
            if (n2 == GameLogic.m_possession && GameLogic.m_penaltiesCount == 0) {
                return;
            }
            n6 = 16007;
            if ((GameLogic.m_penaltiesCount & 1) == (n2 ^ 1)) {
                n6 = 31964;
            }
            n5 = 12311;
            n4 = 0;
            n3 = 0;
        } else {
            if (GameLogic.m_matchState == 8) {
                nArray[25] = 12311;
                nArray[26] = n6;
                return;
            }
            int n7 = GameAI.m_ballStorage[0] - n5;
            int n8 = GameAI.m_ballStorage[1] - n6;
            n4 = DDMath.atan(n7, n8);
            n3 = n8 * 30 >> 8;
            n3 = DDMath.abs(n3);
        }
        nArray[25] = n5 + (DDMath.sin(n4) * n3 >> 16);
        nArray[26] = n6 + (DDMath.cos(n4) * n3 >> 16);
        nArray[26] = DDMath.min(nArray[26], 31759);
        nArray[26] = DDMath.max(nArray[26], 256);
    }

    public static void keeperUpdateLevel2(int n2, int[] nArray) {
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl;
        boolean bl2 = bl = nArray[1] < 16007 && GameAI.m_ballStorage[1] < 16007 || nArray[1] > 16007 && GameAI.m_ballStorage[1] > 16007;
        if (GameLogic.m_matchState == 2 && GameLogic.m_matchPeriod != 4 && GameLogic.m_gameMode != 99 && bl && GameLogic.isFreeBallSituation() && GameAI.ballIsHeadingTowardsTheGoal(nArray)) {
            n6 = DDMath.m_intersectionPointObject[0];
            n5 = DDMath.m_intersectionPointObject[1];
            if (DDMath.abs(12311 - n6) < GameLogic.m_goalWidth / 2 + 256) {
                GameAI.playerSetState(nArray, n6, n5, 102);
            } else if (n2 == GameAI.ballGetLastTouchPlayerTeam()) {
                GameLogic.nearestPlayerData(DDMath.m_intersectionPointObject, n2 ^ 1, 0);
                n4 = n6 - nArray[0];
                n3 = n5 - nArray[1];
                if (GameLogic.m_nearestPlayerDistanceSquaredStore < n4 * n4 + n3 * n3) {
                    GameAI.playerSetState(nArray, n6, n5, 103);
                }
            }
        }
        n6 = GameLogic.isBallCloseEnoughToGoalieToRush(GameAI.m_ballStorage, GameAI.teamGetPitchSide(n2));
        if (GameLogic.m_matchState == 2 && GameLogic.isFreeBallSituation()) {
            if (GameFormation.isKeeperTheBestPlayerToPickUpTheFreeBall(nArray) && (nArray[28] == 0 || nArray[28] == 26 || nArray[28] == 103 || nArray[28] == 102)) {
                GameAI.playerSetState(nArray, GameAI.m_ballStorage[0], GameAI.m_ballStorage[1], 79);
            }
        } else if (GameAI.m_playerWithBall != null && GameAI.m_playerWithBall[12] != n2) {
            n5 = DDMath.abs(GameAI.m_ballStorage[0] - 12311);
            n4 = 1;
            if (n5 < 5670) {
                for (n3 = 1; n3 < m_formationsList[GameAI.m_teamStorage[n2][4]][1]; ++n3) {
                    int n7 = GameAI.m_playerStorage[n2][n3][0] - 12311;
                    int n8 = GameAI.m_ballStorage[1] - GameAI.m_playerStorage[n2][n3][1];
                    if (GameAI.teamGetPitchSide(n2) == 1) {
                        n8 = -n8;
                    }
                    if (n8 <= 0 || n7 >= 5670) continue;
                    n4 = 0;
                }
            } else {
                n4 = 0;
            }
            if ((n4 != 0 || nArray[36] < 8) && n6 != 0 && GameAI.m_playerWithBall[28] == 9 && nArray[28] != 27) {
                GameAI.playerSetState(nArray, 0, 0, 27);
            }
        }
    }

    public static void resetFormations() {
    }

    public static String getPlayerType(int[] nArray) {
        String[] stringArray = new String[]{"PP_GK\t", "PP_RB\t", "PP_RCB\t", "PP_CB\t", "PP_LCB\t", "PP_LB\t", "PP_RM\t", "PP_RCM\t", "PP_CM\t", "PP_LCM\t", "PP_LM\t", "PP_ARM\t", "PP_ACM\t", "PP_ALM\t", "PP_DRM\t", "PP_DCM\t", "PP_DLM\t", "PP_RS\t", "PP_CS\t", "PP_LS\t"};
        return stringArray[nArray[52]];
    }

    public static void setFormation(int n2, int n3) {
        GameFormation.initialiseFormationZoneValues();
        for (int i2 = 0; i2 < 11; ++i2) {
            GameAI.m_playerStorage[n2][i2][52] = playerFormationPlayerTypes[n3][i2];
        }
        GameAI.m_teamStorage[n2][4] = (short)n3;
    }

    public static void initialiseFormationZoneValues() {
        GameFormation.m_formationGlobalZones[1][0] = 2048;
        GameFormation.m_formationGlobalZones[1][1] = 16896;
        GameFormation.m_formationGlobalZones[2][0] = 2048;
        GameFormation.m_formationGlobalZones[2][1] = 15360;
        GameFormation.m_formationGlobalZones[3][0] = 2048;
        GameFormation.m_formationGlobalZones[3][1] = 15360;
        GameFormation.m_formationGlobalZones[4][0] = 2048;
        GameFormation.m_formationGlobalZones[4][1] = 15360;
        GameFormation.m_formationGlobalZones[5][0] = 2048;
        GameFormation.m_formationGlobalZones[5][1] = 16896;
        GameFormation.m_formationGlobalZones[6][0] = 5120;
        GameFormation.m_formationGlobalZones[6][1] = 28160;
        GameFormation.m_formationGlobalZones[7][0] = 5120;
        GameFormation.m_formationGlobalZones[7][1] = 23040;
        GameFormation.m_formationGlobalZones[8][0] = 5120;
        GameFormation.m_formationGlobalZones[8][1] = 23040;
        GameFormation.m_formationGlobalZones[9][0] = 5120;
        GameFormation.m_formationGlobalZones[9][1] = 23040;
        GameFormation.m_formationGlobalZones[10][0] = 5120;
        GameFormation.m_formationGlobalZones[10][1] = 28160;
        GameFormation.m_formationGlobalZones[11][0] = 7680;
        GameFormation.m_formationGlobalZones[11][1] = 28160;
        GameFormation.m_formationGlobalZones[12][0] = 7680;
        GameFormation.m_formationGlobalZones[12][1] = 28160;
        GameFormation.m_formationGlobalZones[13][0] = 7680;
        GameFormation.m_formationGlobalZones[13][1] = 28160;
        GameFormation.m_formationGlobalZones[14][0] = 3840;
        GameFormation.m_formationGlobalZones[14][1] = 17920;
        GameFormation.m_formationGlobalZones[15][0] = 15360;
        GameFormation.m_formationGlobalZones[15][1] = 30720;
        GameFormation.m_formationGlobalZones[16][0] = 15360;
        GameFormation.m_formationGlobalZones[16][1] = 30720;
        GameFormation.m_formationGlobalZones[17][0] = 15360;
        GameFormation.m_formationGlobalZones[17][1] = 30720;
        GameFormation.m_debugViewZones[0] = 0;
        GameFormation.m_debugViewZones[1] = 0;
        GameFormation.m_debugViewZones[2] = 1;
        GameFormation.m_debugViewZones[3] = 0;
        GameFormation.m_debugViewZones[4] = 0;
        GameFormation.m_debugViewZones[5] = 0;
        GameFormation.m_debugViewZones[6] = 0;
        GameFormation.m_debugViewZones[7] = 0;
        GameFormation.m_debugViewZones[8] = 0;
        GameFormation.m_debugViewZones[9] = 0;
        GameFormation.m_debugViewZones[10] = 0;
        GameFormation.m_debugViewZones[14] = 0;
        GameFormation.m_debugViewZones[11] = 0;
        GameFormation.m_debugViewZones[12] = 0;
        GameFormation.m_debugViewZones[13] = 0;
        GameFormation.m_debugViewZones[15] = 0;
        GameFormation.m_debugViewZones[16] = 0;
        GameFormation.m_debugViewZones[17] = 0;
    }

    public static void setUpDefenceForFreeKick() {
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray = new int[]{2, 2, 2, 2, 2, 2, 2, 2};
        short s = GameAI.m_teamStorage[GameLogic.m_possession ^ 1][5];
        int[][] nArrayArray = new int[11][];
        int n6 = GameFormation.getDefenders(GameLogic.m_possession ^ 1, nArrayArray);
        for (n5 = 0; n5 < n6; ++n5) {
            if (nArrayArray[n5][28] != 20 && nArrayArray[n5][28] != 21) continue;
            for (n4 = n5; n4 < n6; ++n4) {
                nArrayArray[n4] = nArrayArray[n4 + 1];
            }
            --n6;
            --n5;
        }
        int n7 = 11340 / (n6 + 1);
        for (n5 = 0; n5 < n6; ++n5) {
            n3 = 6641 + n7 + n5 * n7;
            n3 -= 12311;
            n3 = n3 * 192 >> 8;
            n2 = GameAI.teamGetPitchSide(GameLogic.m_possession ^ 1) == 0 ? 1280 : 30735;
            GameAI.playerSetState(nArrayArray[n5], n3 += 12311, n2, 1);
            nArrayArray[n5][29] = 22;
        }
        n6 = GameFormation.getMidfielders(GameLogic.m_possession ^ 1, nArrayArray);
        for (n5 = 0; n5 < n6; ++n5) {
            if (nArrayArray[n5][28] != 20 && nArrayArray[n5][28] != 21) continue;
            for (n4 = n5; n4 < n6; ++n4) {
                nArrayArray[n4] = nArrayArray[n4 + 1];
            }
            --n6;
            --n5;
        }
        n6 = DDMath.min(nArray[s], n6);
        n7 = 11340 / (n6 + 1);
        for (n5 = 0; n5 < n6; ++n5) {
            n3 = 6641 + n7 + n5 * n7;
            n3 -= 12311;
            n3 = n3 * 192 >> 8;
            n2 = GameAI.teamGetPitchSide(GameLogic.m_possession ^ 1) == 0 ? 3840 : 28175;
            GameAI.playerSetState(nArrayArray[n5], n3 += 12311, n2, 1);
            nArrayArray[n5][29] = 143;
        }
        for (n5 = 0; n5 < 11; ++n5) {
            if (nArrayArray[n5] == null) continue;
            nArrayArray[n5] = null;
        }
    }

    public static void setUpAttackersForFreeKick() {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int[][] nArrayArray = new int[11][];
        int[] nArray = new int[]{3, 3, 3, 3, 3, 3, 3, 3};
        int[] nArray2 = new int[]{2, 2, 2, 2, 2, 2, 2, 2};
        short s = GameAI.m_teamStorage[GameLogic.m_possession][5];
        for (n5 = 1; n5 < 11; ++n5) {
            if (n5 == 2 || n5 == 3 || GameAI.m_playerStorage[GameLogic.m_possession][n5] == GameLogic.m_setPieceTaker) continue;
            nArrayArray[n6] = GameAI.m_playerStorage[GameLogic.m_possession][n5];
            ++n6;
        }
        GameFormation.sortPlayersByStat(GameLogic.m_possession, 40, nArrayArray, n6, true);
        int n7 = nArray[s];
        int n8 = 11340 / (n7 + 1);
        n5 = 0;
        int n9 = 0;
        n5 = 0;
        for (n9 = 0; n5 < nArray[s] && n9 < n6; ++n5, ++n9) {
            n4 = 6641 + n8 + n5 * n8;
            n4 -= 12311;
            n4 = n4 * 140 >> 8;
            n3 = GameAI.teamGetPitchSide(GameLogic.m_possession) == 1 ? 2048 : 29967;
            GameAI.playerSetState(nArrayArray[n9], n4 += 12311, n3, 1);
            nArrayArray[n9][29] = 116;
        }
        n5 = 0;
        while (n5 < 1 && n5 < n6) {
            n4 = 12311 - GameLogic.m_setPieceTaker[0];
            n3 = 16007 - GameLogic.m_setPieceTaker[1];
            n2 = DDMath.atan(n4, n3);
            n4 = GameLogic.m_setPieceTaker[0] + (DDMath.sin(n2) * 3404 >> 16);
            n3 = GameLogic.m_setPieceTaker[1] + (DDMath.cos(n2) * 3404 >> 16);
            GameAI.playerSetState(nArrayArray[n9], n4, n3, 1);
            nArrayArray[n9][29] = 144;
            ++n5;
            ++n9;
        }
        n7 = DDMath.min(nArray2[s], n6 - n9);
        n8 = 11340 / (n7 + 1);
        for (n5 = 0; n5 < nArray2[s] && n9 < n6; ++n5, ++n9) {
            n4 = 6641 + n8 + n5 * n8;
            n4 -= 12311;
            n4 = n4 * 217 >> 8;
            n2 = 3840 + DDMath.getRandom() % 512;
            n3 = GameAI.teamGetPitchSide(GameLogic.m_possession) == 1 ? n2 : 32015 - n2;
            GameAI.playerSetState(nArrayArray[n9], n4 += 12311, n3, 1);
            nArrayArray[n9][29] = 145;
        }
        for (n2 = 0; n2 < 11; ++n2) {
            if (nArrayArray[n2] == null) continue;
            nArrayArray[n2] = null;
        }
    }

    public static void setUpAttackersForLongRangeFreeKick() {
        int n2;
        int n3 = 0;
        int[][] nArrayArray = new int[11][];
        for (n2 = 5; n2 < 11; ++n2) {
            if (GameAI.m_playerStorage[GameLogic.m_possession][n2] == GameLogic.m_setPieceTaker) continue;
            nArrayArray[n3] = GameAI.m_playerStorage[GameLogic.m_possession][n2];
            ++n3;
        }
        GameFormation.sortPlayersByStat(GameLogic.m_possession, 40, nArrayArray, n3, true);
        int n4 = 10894;
        int n5 = GameAI.teamGetPitchSide(GameLogic.m_possession) == 1 ? 4608 : 27407;
        GameAI.playerSetState(nArrayArray[0], n4, n5, 1);
        nArrayArray[0][29] = 116;
        n4 = 13728;
        n2 = 5376 + DDMath.getRandom() % 512;
        n5 = GameAI.teamGetPitchSide(GameLogic.m_possession) == 1 ? n2 : 32015 - n2;
        GameAI.playerSetState(nArrayArray[1], n4, n5, 1);
        nArrayArray[1][29] = 145;
        for (int i2 = 0; i2 < 11; ++i2) {
            if (nArrayArray[i2] == null) continue;
            nArrayArray[i2] = null;
        }
    }

    public static void setUpDefenceForLongRangeFreeKick() {
        int n2;
        int n3;
        int[][] nArrayArray = new int[11][];
        int n4 = GameFormation.getDefenders(GameLogic.m_possession ^ 1, nArrayArray);
        for (n3 = 0; n3 < n4; ++n3) {
            if (nArrayArray[n3][28] != 20 && nArrayArray[n3][28] != 21) continue;
            for (n2 = n3; n2 < n4; ++n2) {
                nArrayArray[n2] = nArrayArray[n2 + 1];
            }
            --n4;
            --n3;
        }
        int n5 = 11340 / n4;
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = 6641 + n5 + n3 * n5;
            n6 -= 12311;
            n6 = n6 * 192 >> 8;
            int n7 = GameAI.teamGetPitchSide(GameLogic.m_possession ^ 1) == 0 ? 3584 : 28431;
            GameAI.playerSetState(nArrayArray[n3], n6 += 12311, n7, 1);
            nArrayArray[n3][29] = 22;
        }
        n4 = GameFormation.getMidfielders(GameLogic.m_possession ^ 1, nArrayArray);
        for (n3 = 0; n3 < n4; ++n3) {
            if (nArrayArray[n3][28] != 20 && nArrayArray[n3][28] != 21) continue;
            for (n2 = n3; n2 < n4; ++n2) {
                nArrayArray[n2] = nArrayArray[n2 + 1];
            }
            --n4;
            --n3;
        }
        for (n3 = 0; n3 < 11; ++n3) {
            if (nArrayArray[n3] == null) continue;
            nArrayArray[n3] = null;
        }
    }

    public static void setUpPlayersInTheBox() {
        if (GameLogic.m_matchState != 6) {
            GameFormation.setUpWalls();
        }
        GameFormation.setUpDefenceForFreeKick();
        GameFormation.setUpAttackersForFreeKick();
    }

    public static int getDefenders(int n2, int[][] nArray) {
        int n3 = 0;
        for (int i2 = 0; i2 < 11; ++i2) {
            int[] nArray2 = GameAI.m_playerStorage[n2][i2];
            if (nArray2[52] != 5 && nArray2[52] != 4 && nArray2[52] != 3 && nArray2[52] != 2 && nArray2[52] != 1) continue;
            nArray[n3] = nArray2;
            ++n3;
        }
        return n3;
    }

    public static int getMidfielders(int n2, int[][] nArray) {
        int n3 = 0;
        for (int i2 = 0; i2 < 11; ++i2) {
            int[] nArray2 = GameAI.m_playerStorage[n2][i2];
            if (nArray2[52] != 10 && nArray2[52] != 9 && nArray2[52] != 8 && nArray2[52] != 7 && nArray2[52] != 6 && nArray2[52] != 13 && nArray2[52] != 12 && nArray2[52] != 11 && nArray2[52] != 14) continue;
            nArray[n3] = nArray2;
            ++n3;
        }
        return n3;
    }

    public static void sortPlayersByStat(int n2, int n3, int[][] nArray, int n4, boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        int n5 = 0;
        int n6 = n4;
        do {
            bl2 = false;
            for (int i2 = n5; i2 < n6 - 1; ++i2) {
                if ((!bl || nArray[i2][n3] >= nArray[i2 + 1][n3]) && (bl || nArray[i2][n3] <= nArray[i2 + 1][n3])) continue;
                int[] nArray2 = nArray[i2];
                nArray[i2] = nArray[i2 + 1];
                nArray[i2] = nArray2;
                bl2 = true;
            }
            ++n5;
            --n6;
        } while (bl2);
    }

    public static void setGoalKeepersToTheirBaseLine() {
        for (int i2 = 0; i2 < 2; ++i2) {
            int[] nArray = GameAI.m_playerStorage[i2][0];
            nArray[0] = 12311;
            nArray[1] = GameAI.teamGetPitchSide(i2) == 0 ? 128 : 31887;
            nArray[25] = nArray[0];
            nArray[26] = nArray[1];
            nArray[28] = 26;
        }
    }

    public static boolean isKeeperTheBestPlayerToPickUpTheFreeBall(int[] nArray) {
        int n2 = nArray[12];
        if (GameLogic.m_matchState == 2 && GameLogic.isFreeBallSituation()) {
            int n3;
            int[] nArray2 = GameLogic.nearestPlayerData(GameAI.m_ballStorage, n2 ^ 1, 0);
            int n4 = GameLogic.m_nearestPlayerDistanceSquaredStore;
            int[] nArray3 = GameLogic.nearestPlayerData(GameAI.m_ballStorage, n2, 0);
            int n5 = GameLogic.m_nearestPlayerDistanceSquaredStore;
            int n6 = (nArray[36] * nArray[36] << 8) / 360;
            if (nArray2 != null) {
                n3 = nArray2[23];
                n3 = DDMath.max(n3, 180);
                n4 /= n3;
            }
            if (nArray3 != null) {
                n3 = nArray3[23];
                n3 = DDMath.max(n3, 180);
                n5 /= n3;
            }
            if (GameLogic.isObjectInFinalThird(GameAI.m_ballStorage, GameAI.teamGetPitchSide(n2 ^ 1)) && GameAI.m_ballStorage[2] < 384 && (GameAI.m_ballStorage[6] & 0x40) == 0 && n4 > n6 && n5 > n6) {
                return true;
            }
        }
        return false;
    }

    public static boolean playerIsDefender(int n2, int n3) {
        switch (playerFormationPlayerTypes[n2][n3]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean playerIsMidfielder(int n2, int n3) {
        switch (playerFormationPlayerTypes[n2][n3]) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public static boolean playerIsAttacker(int n2, int n3) {
        switch (playerFormationPlayerTypes[n2][n3]) {
            case 15: 
            case 16: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    public static void interceptionCheckIfGoalKeeperCanInterceptAPass() {
        int n2 = GameAI.m_ballStorage[0];
        int n3 = GameAI.m_ballStorage[1];
        int n4 = GameAI.m_passTargetObject[0];
        int n5 = GameAI.m_passTargetObject[1];
        int n6 = DDMath.sqrtRout((n4 - n2) * (n4 - n2) + (n5 - n3) * (n5 - n3));
        int n7 = DDMath.atan(n4 - n2, n5 - n3);
        int[] nArray = GameAI.m_playerStorage[GameLogic.m_possession ^ 1][0];
        GameFormation.interceptionConvertPositionToLocalPassCoords(nArray, n7, n2, n3);
        if (m_interceptionLocalY > 512 && m_interceptionLocalY <= n6 - 512) {
            int n8 = (m_interceptionLocalY << 8) / n6;
            int n9 = GameAI.ballGetSpeed();
            int n10 = (n6 << 8) / n9 * n8 >> 16;
            int n11 = 256;
            int n12 = (DDMath.abs(m_interceptionLocalX) << 8) / n11 >> 8;
            if (m_interceptionLocalX > -5120 && m_interceptionLocalX < 5120 && n12 + 4 < n10) {
                int n13 = n2 + (DDMath.sin(n7) * m_interceptionLocalY >> 16);
                int n14 = n3 + (DDMath.cos(n7) * m_interceptionLocalY >> 16);
                GameLogic.ballCalculateFutureBallPosition(n10);
                if (DDMath.abs(n13 - 12311) < 8505 && (n14 > 28541 || n14 < 3474) && GameLogic.m_futureBallObject[2] <= 640) {
                    GameAI.playerSetState(nArray, n13, n14, 177);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void interceptionCheckIfPlayersCanInterceptAPass() {
        void var14_21;
        int n2;
        int n3;
        int n4 = GameAI.m_ballStorage[0];
        int n5 = GameAI.m_ballStorage[1];
        int n6 = GameAI.m_passTargetObject[0];
        int n7 = GameAI.m_passTargetObject[1];
        int n8 = GameAI.m_passTargetObject[2];
        int n9 = DDMath.sqrtRout((n6 - n4) * (n6 - n4) + (n7 - n5) * (n7 - n5));
        int n10 = DDMath.atan(n6 - n4, n7 - n5);
        int[] nArray = null;
        int n11 = Integer.MAX_VALUE;
        int n12 = Integer.MAX_VALUE;
        int[] nArray2 = null;
        int n13 = Integer.MAX_VALUE;
        int n14 = Integer.MAX_VALUE;
        for (int i2 = 1; i2 < 11; ++i2) {
            int[] nArray3 = GameAI.m_playerStorage[GameLogic.m_possession ^ 1][i2];
            GameFormation.interceptionConvertPositionToLocalPassCoords(nArray3, n10, n4, n5);
            if (m_interceptionLocalY <= 1792 || m_interceptionLocalY > n9 - 1792) continue;
            n3 = (m_interceptionLocalY << 8) / n9;
            n2 = GameAI.ballGetSpeed();
            int n15 = (n9 << 8) / n2 * n3 >> 16;
            int n16 = 180;
            n16 = GameAI.teamGetControlType(GameLogic.m_possession) == 2 ? n16 * GameLogic.m_difficultySettingAIPlayerInterceptSpeedAdjust >> 8 : n16 * GameLogic.m_difficultySettingHumanPlayerInterceptSpeedAdjust >> 8;
            int n17 = (DDMath.abs(m_interceptionLocalX) << 8) / n16 >> 8;
            if (m_interceptionLocalX <= -3840 || m_interceptionLocalX >= 3840 || n17 + 4 >= n15) continue;
            GameLogic.ballCalculateFutureBallPosition(n15);
            if (GameLogic.m_futureBallObject[2] >= 486 + GameLogic.PLAYER_JUMP_VELOCITY) continue;
            if (m_interceptionLocalY < 5120) {
                if (DDMath.abs(m_interceptionLocalX) >= DDMath.abs(n11)) continue;
                nArray = nArray3;
                n11 = m_interceptionLocalX;
                n12 = m_interceptionLocalY;
                continue;
            }
            if (DDMath.abs(m_interceptionLocalX) >= DDMath.abs(n13)) continue;
            nArray2 = nArray3;
            n13 = m_interceptionLocalX;
            n14 = m_interceptionLocalY;
        }
        if (nArray != null) {
            n12 = DDMath.min(n12, 3328);
            var14_21 = nArray[42] + nArray[47] + nArray[45] + nArray[46] >> 2;
            if (DDMath.getRandom(1, 100) < var14_21 * 50 / 100) {
                GameAI.playerSetState(nArray, n4 + (DDMath.sin(n10) * n12 >> 16), n5 + (DDMath.cos(n10) * n12 >> 16), 33);
            }
        }
        if (n8 > 384) {
            n3 = GameAI.ballCurrentDirection();
            n2 = 217;
            int[] nArray4 = nArray2 != null ? nArray2 : GameLogic.nearestPlayerData(GameAI.m_passTargetObject, GameLogic.m_possession ^ 1, 0);
            var14_21 = nArray4[42] + nArray4[47] + nArray4[45] + nArray4[46] >> 2;
            if (DDMath.getRandom(1, 100) < var14_21 * 50 / 100) {
                GameAI.playerSetState(nArray4, GameAI.m_passTargetObject[0] + (DDMath.sin(n3) * n2 >> 16), GameAI.m_passTargetObject[1] + (DDMath.cos(n3) * n2 >> 16), 184);
            }
        } else if (nArray2 != null) {
            n14 = DDMath.max(n14, 6912);
            var14_21 = nArray2[42] + nArray2[47] + nArray2[45] + nArray2[46] >> 2;
            if (DDMath.getRandom(1, 100) < var14_21 * 50 / 100) {
                GameAI.playerSetState(nArray2, n4 + (DDMath.sin(n10) * n14 >> 16), n5 + (DDMath.cos(n10) * n14 >> 16), 33);
            }
        }
    }

    public static final void interceptionConvertPositionToLocalPassCoords(int[] nArray, int n2, int n3, int n4) {
        int n5 = nArray[0];
        int n6 = nArray[1];
        m_interceptionLocalX = ((n5 -= n3) * DDMath.cos(n2) >> 16) - ((n6 -= n4) * DDMath.sin(n2) >> 16);
        m_interceptionLocalY = (n6 * DDMath.cos(n2) >> 16) + (n5 * DDMath.sin(n2) >> 16);
    }

    public static int getPlayerType(int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (n2 < 6) {
            return 1;
        }
        if (n2 < 15) {
            return 2;
        }
        return 3;
    }

    private static void rushIntoShootZoneUpdate(int[] nArray, int n2) {
        if (GameLogic.m_possession != n2) {
            return;
        }
        if (!GameLogic.isObjectInFinalThird(GameAI.m_ballStorage, GameAI.teamGetPitchSide(n2))) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = nArray[52];
        if (n5 == 16 || !GameLogic.isObjectInOwnHalf(n2, nArray) && (GameAI.m_ballStorage[0] < 10240 || GameAI.m_ballStorage[0] > 14382) && (GameAI.m_ballStorage[0] < 12311 && nArray[0] > 12311 || GameAI.m_ballStorage[0] > 12311 && nArray[0] < 12311)) {
            if (nArray[14] == 0) {
                switch (n5) {
                    case 17: {
                        n3 = 10763;
                        n4 = 29448;
                        break;
                    }
                    case 9: {
                        n3 = 10763;
                        n4 = 27905;
                        break;
                    }
                    case 13: {
                        n3 = 9214;
                        n4 = 28677;
                        break;
                    }
                    case 16: {
                        n3 = 12311;
                        n4 = 28677;
                        break;
                    }
                    case 15: {
                        n3 = 13859;
                        n4 = 29448;
                        break;
                    }
                    case 7: {
                        n3 = 13859;
                        n4 = 27905;
                        break;
                    }
                    case 11: {
                        n3 = 15408;
                        n4 = 28677;
                    }
                }
            } else {
                switch (n5) {
                    case 17: {
                        n3 = 13859;
                        n4 = 2567;
                        break;
                    }
                    case 9: {
                        n3 = 13859;
                        n4 = 4110;
                        break;
                    }
                    case 13: {
                        n3 = 15408;
                        n4 = 3338;
                        break;
                    }
                    case 16: {
                        n3 = 12311;
                        n4 = 3338;
                        break;
                    }
                    case 15: {
                        n3 = 10763;
                        n4 = 2567;
                        break;
                    }
                    case 7: {
                        n3 = 10763;
                        n4 = 4110;
                        break;
                    }
                    case 11: {
                        n3 = 9214;
                        n4 = 3338;
                    }
                }
            }
            GameAI.playerSetState(nArray, n3, n4, 69);
        }
    }

    private static void overlappingRunUpdate(int[] nArray, int n2, int[] nArray2) {
        if (GameLogic.m_possession != n2) {
            return;
        }
        switch (nArray2[52]) {
            case 6: 
            case 10: 
            case 11: 
            case 13: {
                return;
            }
        }
        if (nArray[25] < 8207 && nArray2[0] < 8207 || nArray[25] > 16414 && nArray2[0] > 16414) {
            int n3 = nArray[25] > 12311 ? 24622 - (24622 - nArray2[0] >> 2) : nArray2[0] >> 2;
            GameAI.playerSetState(nArray, n3, nArray2[1] + (DDMath.cos(nArray2[14]) * 15 >> 8), 89);
        }
    }

    static {
        m_formationsList = new int[][]{{3, 4, 4, 2, 0}, {4, 4, 2, 2, 2}, {4, 4, 1, 3, 2}, {5, 4, 1, 2, 1, 2}, {3, 4, 5, 1, 0}, {4, 4, 2, 3, 1}, {5, 4, 1, 2, 2, 1}, {4, 4, 4, 1, 1}, {3, 4, 3, 3, 0}, {3, 5, 4, 1, 0}, {3, 5, 3, 2, 0}, {3, 3, 5, 2, 0}, {3, 3, 4, 3, 0}};
        m_posFormationExample = new int[]{0, 0, 10, 0, 0, 0, 0, 10, 0, 0, 5, 5, 5, 2, 8, 8, 8};
        m_posFormationIndexExample = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
        playerFormationPlayerTypes = new int[][]{{0, 1, 2, 4, 5, 6, 7, 9, 10, 15, 17}, {0, 1, 2, 4, 5, 7, 9, 11, 13, 15, 17}, {0, 1, 2, 4, 5, 14, 6, 8, 10, 15, 17}, {0, 1, 2, 4, 5, 14, 6, 10, 12, 15, 17}, {0, 1, 2, 4, 5, 6, 7, 8, 9, 10, 16}, {0, 1, 2, 4, 5, 7, 9, 11, 12, 13, 16}, {0, 1, 2, 4, 5, 14, 7, 9, 11, 13, 16}, {0, 1, 2, 4, 5, 6, 7, 9, 10, 12, 16}, {0, 1, 2, 4, 5, 7, 8, 9, 15, 16, 17}, {0, 1, 2, 3, 4, 5, 6, 7, 9, 10, 16}, {0, 1, 2, 3, 4, 5, 7, 8, 9, 15, 17}, {0, 2, 3, 4, 6, 7, 8, 9, 10, 15, 17}, {0, 2, 3, 4, 6, 7, 9, 10, 15, 16, 17}};
        zoneHeight = new int[2][18];
        m_playerList = new int[11][];
        mf_selctorder = new int[][]{{-1, -1, -1, -1, -1}, {0, -1, -1, -1, -1}, {0, 1, -1, -1, -1}, {1, 0, 2, -1, -1}, {1, 2, 0, 3, -1}, {2, 1, 3, 0, 4}};
    }
}

