/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.graphics.Rendering2D;
import sk.inlogic.screen.IScreen;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;
import sk.inlogic.util.Tools;

public class ScreenSelectLevel
implements IScreen {
    MainCanvas mc;
    int mode;
    long modeDelay;
    private static final int ITEM_PACK_NAME = 0;
    private static final int ITEM_BACK = 1;
    private static final int ITEM_SELECT = 2;
    Rectangle[] rectControlItems = new Rectangle[3];
    Rectangle[] rectLevelItems = new Rectangle[20];
    char[] packCharArr;
    char[] starsForPackCharArr;
    char[][] numCharArr = new char[20][];
    char[][] starsCharArr = new char[20][];
    char[][] unlockStarsCharArr = new char[20][];
    private boolean itemHolding = false;
    private int holdingLevelIndex = -1;
    private int holdingControlIndex = -1;

    public ScreenSelectLevel(MainCanvas _canvas) {
        this.mc = _canvas;
    }

    public void beforeShow() {
        int i;
        int oneLevelTableW;
        int oneLevelTableH;
        Resources.loadImages(new int[]{40, 8, 14, 15, 25, 11});
        Resources.loadSprites(new int[]{11});
        Resources.loadText(0);
        this.rectControlItems[0] = new Rectangle(MainCanvas.WIDTH - MainCanvas.mainTableSize >> 1, 0 + MainCanvas.mainUIOffset, MainCanvas.mainTableSize, MainCanvas.arrowBackgroundSize);
        this.rectControlItems[2] = new Rectangle(MainCanvas.mainUIOffset, MainCanvas.HEIGHT - (MainCanvas.mainUIOffset + MainCanvas.arrowBackgroundSize), MainCanvas.arrowBackgroundSize, MainCanvas.arrowBackgroundSize);
        this.rectControlItems[1] = new Rectangle(MainCanvas.WIDTH - (MainCanvas.mainUIOffset + 3 * Resources.resImgsW[8] / 2), MainCanvas.HEIGHT - (MainCanvas.mainUIOffset + MainCanvas.arrowBackgroundSize), 3 * Resources.resImgsW[8] / 2, MainCanvas.arrowBackgroundSize);
        this.packCharArr = ("" + (this.mc.selectedPack + 1)).toCharArray();
        this.starsForPackCharArr = (this.mc.packStars[this.mc.selectedPack] + "/60").toCharArray();
        if (MainCanvas.WIDTH == 128) {
            oneLevelTableH = (MainCanvas.HEIGHT - this.rectControlItems[0].height - MainCanvas.arrowBackgroundSize - 7 * MainCanvas.mainUIOffset) / 5;
            oneLevelTableW = (MainCanvas.WIDTH - 5 * MainCanvas.mainUIOffset) / 4;
        } else if (MainCanvas.WIDTH == 176) {
            oneLevelTableH = (MainCanvas.HEIGHT - this.rectControlItems[0].height - MainCanvas.arrowBackgroundSize - 5 * MainCanvas.mainUIOffset) / 5;
            oneLevelTableW = (MainCanvas.WIDTH - 5 * MainCanvas.mainUIOffset) / 4;
        } else {
            oneLevelTableH = (MainCanvas.HEIGHT - this.rectControlItems[0].height - MainCanvas.arrowBackgroundSize - 8 * MainCanvas.mainUIOffset) / 5;
            oneLevelTableW = (MainCanvas.WIDTH - 5 * MainCanvas.mainUIOffset) / 4;
        }
        int topOfAreaForLevelTables = this.rectControlItems[0].getBottom() + MainCanvas.mainUIOffset;
        int allStars = this.mc.getAllEarnedStars();
        for (i = 0; i < 20; ++i) {
            int idx = i + this.mc.selectedPack * 20;
            this.starsCharArr[i] = (this.mc.starsForLevel[idx] + "/3").toCharArray();
            this.mc.allowedLevels[idx] = false;
            this.unlockStarsCharArr[i] = (idx * 2 - this.mc.getAllEarnedStars() - 1 + "").toCharArray();
            if (idx == 0) {
                this.mc.allowedLevels[idx] = true;
                continue;
            }
            if (idx == 1) {
                if (allStars < 1) continue;
                this.mc.allowedLevels[idx] = true;
                continue;
            }
            if (allStars < idx * 2 - 1) continue;
            this.mc.allowedLevels[idx] = true;
        }
        for (i = 0; i < 20; ++i) {
            int row = i / 4;
            int col = i % 4;
            this.numCharArr[i] = ("" + (i + 1)).toCharArray();
            this.rectLevelItems[i] = MainCanvas.WIDTH == 128 ? new Rectangle(MainCanvas.mainUIOffset + col * (oneLevelTableW + MainCanvas.mainUIOffset), topOfAreaForLevelTables + row * (oneLevelTableH + MainCanvas.mainUIOffset2), oneLevelTableW, oneLevelTableH) : (MainCanvas.WIDTH == 176 ? new Rectangle(MainCanvas.mainUIOffset + col * (oneLevelTableW + MainCanvas.mainUIOffset), topOfAreaForLevelTables + row * (oneLevelTableH + MainCanvas.mainUIOffset2), oneLevelTableW, oneLevelTableH) : new Rectangle(MainCanvas.mainUIOffset + col * (oneLevelTableW + MainCanvas.mainUIOffset), topOfAreaForLevelTables + row * (oneLevelTableH + MainCanvas.mainUIOffset), oneLevelTableW, oneLevelTableH));
        }
        this.mc.selectedLevel = 0 + this.mc.selectedPack * 20;
        if (!MainCanvas.touchActivated) {
            this.holdingLevelIndex = 0;
        }
        this.repaint();
    }

    public void repaint() {
        this.mc.paint();
    }

    public void afterHide() {
        Resources.freeImages(new int[]{40, 8, 14, 15, 25, 11});
        Resources.freeSprites(new int[]{11});
    }

    public void update(long lastRunLenght) {
    }

    public void paint(Graphics g) {
        Tools.setFullClip(g);
        g.drawImage(Resources.resImgs[40], 0, 0, 20);
        Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], this.rectControlItems[0]);
        if (this.holdingControlIndex == 1) {
            Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[14], this.rectControlItems[1]);
        } else {
            Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], this.rectControlItems[1]);
        }
        if (!MainCanvas.touchActivated) {
            Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], this.rectControlItems[2]);
            g.drawImage(Resources.resImgs[15], this.rectControlItems[2].getCenterX() - (Resources.resImgsW[8] >> 1), this.rectControlItems[2].getCenterY() - (Resources.resImgsH[15] >> 1), 20);
        }
        g.drawImage(Resources.resImgs[8], this.rectControlItems[1].getCenterX() - (Resources.resImgsW[15] >> 1), this.rectControlItems[1].getCenterY() - (Resources.resImgsH[8] >> 1), 20);
        if (MainCanvas.WIDTH == 480 || MainCanvas.WIDTH == 360) {
            g.drawImage(Resources.resImgs[14], this.rectControlItems[0].x + MainCanvas.mainUIOffset, this.rectControlItems[0].getCenterY() - (Resources.resImgsH[14] >> 1), 0);
        } else {
            g.drawImage(Resources.resImgs[14], this.rectControlItems[0].x + (MainCanvas.mainUIOffset << 1), this.rectControlItems[0].getCenterY() - (Resources.resImgsH[14] >> 1), 0);
        }
        if (MainCanvas.WIDTH == 176) {
            this.mc.mainFont.drawString(g, this.packCharArr, this.rectControlItems[0].x + (MainCanvas.mainUIOffset << 2) + Resources.resImgsW[14], this.rectControlItems[0].getCenterY() - (this.mc.mainFont.getHeight() >> 1), 20);
            this.mc.mainFont.drawString(g, this.starsForPackCharArr, this.rectControlItems[0].getRight() - (MainCanvas.mainUIOffset << 2) - this.mc.mainFont.stringWidth(this.starsForPackCharArr), this.rectControlItems[0].getCenterY() - (this.mc.mainFont.getHeight() >> 1), 20);
        } else if (MainCanvas.WIDTH == 240) {
            this.mc.mainFont.drawString(g, this.packCharArr, this.rectControlItems[0].x + (MainCanvas.mainUIOffset << 2) + Resources.resImgsW[14], this.rectControlItems[0].getCenterY() - (this.mc.mainFont.getHeight() >> 1), 20);
            this.mc.mainFont.drawString(g, this.starsForPackCharArr, this.rectControlItems[0].getRight() - (MainCanvas.mainUIOffset << 2) - this.mc.mainFont.stringWidth(this.starsForPackCharArr), this.rectControlItems[0].getCenterY() - (this.mc.mainFont.getHeight() >> 1), 20);
        } else if (MainCanvas.WIDTH == 128) {
            this.mc.mainFont.drawString(g, this.packCharArr, this.rectControlItems[0].x + (MainCanvas.mainUIOffset << 2) + Resources.resImgsW[14], this.rectControlItems[0].getCenterY() - (this.mc.mainFont.getHeight() >> 1), 20);
            this.mc.mainFont.drawString(g, this.starsForPackCharArr, this.rectControlItems[0].getRight() - MainCanvas.mainUIOffset - this.mc.mainFont.stringWidth(this.starsForPackCharArr), this.rectControlItems[0].getCenterY() - (this.mc.mainFont.getHeight() >> 1), 20);
        } else {
            this.mc.mainFont.drawString(g, this.packCharArr, this.rectControlItems[0].x + (MainCanvas.mainUIOffset << 1) + Resources.resImgsW[14], this.rectControlItems[0].getCenterY() - (this.mc.mainFont.getHeight() >> 1), 20);
            this.mc.mainFont.drawString(g, this.starsForPackCharArr, this.rectControlItems[0].getRight() - MainCanvas.mainUIOffset - this.mc.mainFont.stringWidth(this.starsForPackCharArr), this.rectControlItems[0].getCenterY() - (this.mc.mainFont.getHeight() >> 1), 20);
        }
        if (MainCanvas.WIDTH == 128) {
            g.drawImage(Resources.resImgs[25], this.rectControlItems[0].getRight() - MainCanvas.mainUIOffset - this.mc.mainFont.stringWidth(this.starsForPackCharArr) - MainCanvas.mainUIOffset - Resources.resImgsW[25], this.rectControlItems[0].getCenterY() - (Resources.resImgsH[25] >> 1) + 1, 0);
        } else if (MainCanvas.WIDTH == 176) {
            g.drawImage(Resources.resImgs[25], this.rectControlItems[0].getRight() - (MainCanvas.mainUIOffset << 2) - this.mc.mainFont.stringWidth(this.starsForPackCharArr) - MainCanvas.mainUIOffset - Resources.resImgsW[25], this.rectControlItems[0].getCenterY() - (Resources.resImgsH[25] >> 1), 0);
        } else if (MainCanvas.WIDTH == 240) {
            g.drawImage(Resources.resImgs[25], this.rectControlItems[0].getRight() - (MainCanvas.mainUIOffset << 2) - this.mc.mainFont.stringWidth(this.starsForPackCharArr) - MainCanvas.mainUIOffset - Resources.resImgsW[25], this.rectControlItems[0].getCenterY() - (Resources.resImgsH[25] >> 1), 0);
        } else {
            g.drawImage(Resources.resImgs[25], this.rectControlItems[0].getRight() - MainCanvas.mainUIOffset - this.mc.mainFont.stringWidth(this.starsForPackCharArr) - MainCanvas.mainUIOffset - Resources.resImgsW[25], this.rectControlItems[0].getCenterY() - (Resources.resImgsH[25] >> 1), 0);
        }
        for (int i = 0; i < 20; ++i) {
            if (this.holdingLevelIndex == i) {
                Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[14], this.rectLevelItems[i]);
            } else {
                Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], this.rectLevelItems[i]);
            }
            int itemCenterYWithOffset = this.rectLevelItems[i].getCenterY() + MainCanvas.mainUIOffset2;
            if (MainCanvas.WIDTH == 128) {
                if (this.mc.allowedLevels[i + this.mc.selectedPack * 20]) {
                    this.mc.mainFont.drawString(g, this.numCharArr[i], this.rectLevelItems[i].getCenterX() - (this.mc.mainFont.stringWidth(this.numCharArr[i]) >> 1), itemCenterYWithOffset - this.mc.mainFont.getHeight() + 1, 20);
                    this.mc.mainFont.drawString(g, this.starsCharArr[i], this.rectLevelItems[i].getCenterX() - (this.mc.mainFont.stringWidth(this.starsCharArr[i]) + MainCanvas.mainUIOffset4 + Resources.resImgsW[25] >> 1) + (MainCanvas.mainUIOffset4 + Resources.resImgsW[25]), itemCenterYWithOffset - 2, 20);
                    g.drawImage(Resources.resImgs[25], this.rectLevelItems[i].getCenterX() - (this.mc.mainFont.stringWidth(this.starsCharArr[i]) + MainCanvas.mainUIOffset4 + Resources.resImgsW[25] >> 1), itemCenterYWithOffset + MainCanvas.mainUIOffset4 + (this.mc.mainFont.getHeight() >> 1) - (Resources.resImgsH[25] >> 1) - 1, 0);
                    continue;
                }
                g.drawImage(Resources.resImgs[11], this.rectLevelItems[i].getCenterX() - (Resources.resImgsW[11] >> 1), itemCenterYWithOffset - Resources.resImgsH[11], 0);
                this.mc.mainFont.drawString(g, this.unlockStarsCharArr[i], this.rectLevelItems[i].getCenterX() - (this.mc.mainFont.stringWidth(this.unlockStarsCharArr[i]) + MainCanvas.mainUIOffset4 + Resources.resImgsW[25] >> 1), itemCenterYWithOffset - 2, 20);
                g.drawImage(Resources.resImgs[25], this.rectLevelItems[i].getCenterX() - (this.mc.mainFont.stringWidth(this.unlockStarsCharArr[i]) + MainCanvas.mainUIOffset4 + Resources.resImgsW[25] >> 1) + this.mc.mainFont.stringWidth(this.unlockStarsCharArr[i]) + MainCanvas.mainUIOffset4, itemCenterYWithOffset + MainCanvas.mainUIOffset4 + (this.mc.mainFont.getHeight() >> 1) - (Resources.resImgsH[25] >> 1) - 1, 0);
                continue;
            }
            if (MainCanvas.WIDTH == 176) {
                if (this.mc.allowedLevels[i + this.mc.selectedPack * 20]) {
                    this.mc.mainFont.drawString(g, this.numCharArr[i], this.rectLevelItems[i].getCenterX() - (this.mc.mainFont.stringWidth(this.numCharArr[i]) >> 1), itemCenterYWithOffset - this.mc.mainFont.getHeight() + 2, 20);
                    this.mc.mainFont.drawString(g, this.starsCharArr[i], this.rectLevelItems[i].getCenterX() - (this.mc.mainFont.stringWidth(this.starsCharArr[i]) + MainCanvas.mainUIOffset4 + Resources.resImgsW[25] >> 1) + (MainCanvas.mainUIOffset4 + Resources.resImgsW[25]), itemCenterYWithOffset - 1, 20);
                    g.drawImage(Resources.resImgs[25], this.rectLevelItems[i].getCenterX() - (this.mc.mainFont.stringWidth(this.starsCharArr[i]) + MainCanvas.mainUIOffset4 + Resources.resImgsW[25] >> 1), itemCenterYWithOffset + MainCanvas.mainUIOffset4 + (this.mc.mainFont.getHeight() >> 1) - (Resources.resImgsH[25] >> 1), 0);
                    continue;
                }
                g.drawImage(Resources.resImgs[11], this.rectLevelItems[i].getCenterX() - (Resources.resImgsW[11] >> 1), itemCenterYWithOffset - Resources.resImgsH[11], 0);
                this.mc.mainFont.drawString(g, this.unlockStarsCharArr[i], this.rectLevelItems[i].getCenterX() - (this.mc.mainFont.stringWidth(this.unlockStarsCharArr[i]) + MainCanvas.mainUIOffset4 + Resources.resImgsW[25] >> 1), itemCenterYWithOffset - 1, 20);
                g.drawImage(Resources.resImgs[25], this.rectLevelItems[i].getCenterX() - (this.mc.mainFont.stringWidth(this.unlockStarsCharArr[i]) + MainCanvas.mainUIOffset4 + Resources.resImgsW[25] >> 1) + this.mc.mainFont.stringWidth(this.unlockStarsCharArr[i]) + MainCanvas.mainUIOffset4, itemCenterYWithOffset + MainCanvas.mainUIOffset4 + (this.mc.mainFont.getHeight() >> 1) - (Resources.resImgsH[25] >> 1), 0);
                continue;
            }
            if (this.mc.allowedLevels[i + this.mc.selectedPack * 20]) {
                this.mc.mainFont.drawString(g, this.numCharArr[i], this.rectLevelItems[i].getCenterX() - (this.mc.mainFont.stringWidth(this.numCharArr[i]) >> 1), itemCenterYWithOffset - this.mc.mainFont.getHeight() - MainCanvas.mainUIOffset4, 20);
                this.mc.mainFont.drawString(g, this.starsCharArr[i], this.rectLevelItems[i].getCenterX() - (this.mc.mainFont.stringWidth(this.starsCharArr[i]) + MainCanvas.mainUIOffset4 + Resources.resImgsW[25] >> 1) + (MainCanvas.mainUIOffset4 + Resources.resImgsW[25]), itemCenterYWithOffset + MainCanvas.mainUIOffset4, 20);
                g.drawImage(Resources.resImgs[25], this.rectLevelItems[i].getCenterX() - (this.mc.mainFont.stringWidth(this.starsCharArr[i]) + MainCanvas.mainUIOffset4 + Resources.resImgsW[25] >> 1), itemCenterYWithOffset + MainCanvas.mainUIOffset4 + (this.mc.mainFont.getHeight() >> 1) - (Resources.resImgsH[25] >> 1), 0);
                continue;
            }
            g.drawImage(Resources.resImgs[11], this.rectLevelItems[i].getCenterX() - (Resources.resImgsW[11] >> 1), itemCenterYWithOffset - Resources.resImgsH[11] - MainCanvas.mainUIOffset4, 0);
            this.mc.mainFont.drawString(g, this.unlockStarsCharArr[i], this.rectLevelItems[i].getCenterX() - (this.mc.mainFont.stringWidth(this.unlockStarsCharArr[i]) + MainCanvas.mainUIOffset4 + Resources.resImgsW[25] >> 1), itemCenterYWithOffset + MainCanvas.mainUIOffset4, 20);
            g.drawImage(Resources.resImgs[25], this.rectLevelItems[i].getCenterX() - (this.mc.mainFont.stringWidth(this.unlockStarsCharArr[i]) + MainCanvas.mainUIOffset4 + Resources.resImgsW[25] >> 1) + this.mc.mainFont.stringWidth(this.unlockStarsCharArr[i]) + MainCanvas.mainUIOffset4, itemCenterYWithOffset + MainCanvas.mainUIOffset4 + (this.mc.mainFont.getHeight() >> 1) - (Resources.resImgsH[25] >> 1), 0);
        }
    }

    public void keyPressed(int keyCode) {
        this.repaint();
    }

    public void keyReleased(int keyCode) {
        if (Keys.isActionGeneratedByKey(3, keyCode)) {
            --this.holdingLevelIndex;
        } else if (Keys.isActionGeneratedByKey(4, keyCode)) {
            ++this.holdingLevelIndex;
        } else if (Keys.isActionGeneratedByKey(1, keyCode)) {
            this.holdingLevelIndex -= 4;
        } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
            this.holdingLevelIndex += 4;
        } else if (Keys.isFKLeft(keyCode) || Keys.isActionGeneratedByKey(5, keyCode)) {
            if (this.mc.allowedLevels[this.holdingLevelIndex + this.mc.selectedPack * 20]) {
                this.mc.selectedLevel = this.mc.selectedPack * 20 + this.holdingLevelIndex;
                this.mc.setActiveScreen(4, null);
            }
        } else if (Keys.isFKRight(keyCode)) {
            this.mc.setActiveScreen(7, null);
        }
        if (this.holdingLevelIndex < 0) {
            this.holdingLevelIndex = 20 + this.holdingLevelIndex;
        }
        if (this.holdingLevelIndex > 19) {
            this.holdingLevelIndex -= 20;
        }
        this.repaint();
    }

    public void pointerPressed(int x, int y) {
        int i;
        this.itemHolding = true;
        for (i = 0; i < 20; ++i) {
            if (!this.rectLevelItems[i].contains(x, y)) continue;
            this.holdingLevelIndex = i;
            this.mc.selectedLevel = this.mc.selectedPack * 20 + i;
            break;
        }
        if (this.holdingLevelIndex == -1) {
            for (i = 0; i < this.rectControlItems.length; ++i) {
                if (!this.rectControlItems[i].contains(x, y)) continue;
                this.holdingControlIndex = i;
                break;
            }
        }
        this.repaint();
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        if (this.rectControlItems[1].contains(x, y) && this.holdingControlIndex == 1) {
            this.mc.setActiveScreen(7, null);
        }
        for (int i = 0; i < 20; ++i) {
            if (!this.rectLevelItems[i].contains(x, y)) continue;
            if (this.holdingLevelIndex == i) {
                this.mc.selectedLevel = this.mc.selectedPack * 20 + i;
                if (!this.mc.allowedLevels[this.mc.selectedLevel]) break;
                this.mc.setActiveScreen(4, null);
                break;
            }
            this.holdingLevelIndex = -1;
            break;
        }
        this.itemHolding = false;
        this.holdingLevelIndex = -1;
        this.holdingControlIndex = -1;
        this.repaint();
    }

    void tr(String s) {
        System.out.println(s);
    }
}

