/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.screen.IScreen;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenLanguages
implements IScreen {
    MainCanvas mc;
    int mode;
    long modeDelay;
    private static int[] imgsForCompId = new int[]{17, 18, 19, 21, 22, 24};
    private static String[] langCodes = new String[]{"en", "de", "fr", "es", "pt", "sk"};
    Rectangle[] rectItems = new Rectangle[imgsForCompId.length];
    Rectangle rectSelector;
    private int selectedCompId;
    int c = 0;

    public ScreenLanguages(MainCanvas mainCanvas) {
        this.mc = mainCanvas;
    }

    public void beforeShow() {
        Resources.loadImages(new int[]{17, 18, 19, 21, 22, 24, 5});
        this.calculatePositions();
        this.selectedCompId = 0;
        this.calculateSelectorPos();
    }

    public void afterHide() {
        Resources.freeImages(new int[]{17, 18, 19, 21, 22, 24, 5});
    }

    public void beforeInteruption() {
    }

    public void afterInteruption() {
    }

    private void calculatePositions() {
        int btnWidth = Resources.resImgs[17].getWidth();
        int btnHeight = Resources.resImgs[17].getHeight();
        int spaceX = (MainCanvas.WIDTH - btnWidth * 2) / 3;
        int spaceY = (MainCanvas.HEIGHT - btnHeight * 4) / 5;
        for (int i = 0; i < imgsForCompId.length; ++i) {
            this.rectItems[i] = new Rectangle(spaceX + i % 2 * (btnWidth + spaceX), spaceY + i / 2 * (btnHeight + spaceY), btnWidth, btnHeight);
        }
        this.rectSelector = new Rectangle(0, 0, Resources.resImgs[5].getWidth(), Resources.resImgs[5].getHeight());
    }

    private void calculateSelectorPos() {
        if (MainCanvas.touchActivated) {
            return;
        }
        if (this.selectedCompId >= this.rectItems.length) {
            this.selectedCompId = this.rectItems.length - 1;
        }
        this.rectSelector.x = this.rectItems[this.selectedCompId].getCenterX();
        this.rectSelector.y = this.rectItems[this.selectedCompId].getCenterY();
    }

    public void update(long lastRunLenght) {
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        if (Keys.isActionGeneratedByKey(3, keyCode)) {
            if (this.selectedCompId % 2 == 1) {
                --this.selectedCompId;
                this.calculateSelectorPos();
            }
        } else if (Keys.isActionGeneratedByKey(4, keyCode)) {
            if (this.selectedCompId % 2 == 0) {
                ++this.selectedCompId;
                this.calculateSelectorPos();
            }
        } else if (Keys.isActionGeneratedByKey(1, keyCode)) {
            if (this.selectedCompId / 2 > 0) {
                this.selectedCompId -= 2;
                this.calculateSelectorPos();
            }
        } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
            if (this.selectedCompId / 2 < 3) {
                this.selectedCompId += 2;
                this.calculateSelectorPos();
            }
        } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
            Resources.initLangDirs(langCodes[this.selectedCompId]);
            this.c = 55555555;
            this.mc.setActiveScreen(1, null);
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        ScreenLanguages.tr("lang paint");
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        g.setColor(0);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        for (int i = 0; i < imgsForCompId.length; ++i) {
            g.drawImage(Resources.resImgs[imgsForCompId[i]], this.rectItems[i].x, this.rectItems[i].y, 20);
        }
        if (!MainCanvas.touchActivated) {
            g.drawImage(Resources.resImgs[5], this.rectSelector.x, this.rectSelector.y, 20);
        }
    }

    public void repaint() {
        this.mc.paint();
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this.rectItems.length; ++i) {
            if (!this.rectItems[i].contains(x, y)) continue;
            this.selectedCompId = i;
            this.c = i;
            switch (this.selectedCompId) {
                default: 
            }
            Keys.keyPressed(53);
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.rectItems[this.selectedCompId].contains(x, y)) {
            switch (this.selectedCompId) {
                default: 
            }
            Keys.keyReleased(53);
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this.selectedCompId) {
            default: 
        }
        if (Keys.isKeyPressed(53)) {
            this.keyReleased(53);
            Keys.keyReleased(53);
        }
    }

    public static void tr(String _s) {
        System.out.println(_s);
    }
}

