/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import sk.inlogic.PointerController;
import sk.inlogic.Resources;
import sk.inlogic.ScreenAbout;
import sk.inlogic.ScreenGame;
import sk.inlogic.ScreenInstructions;
import sk.inlogic.ScreenLanguages;
import sk.inlogic.ScreenLogos;
import sk.inlogic.ScreenMainMenu;
import sk.inlogic.ScreenQuit;
import sk.inlogic.ScreenSelectLevel;
import sk.inlogic.ScreenSelectPack;
import sk.inlogic.ScreenSounds;
import sk.inlogic.ScreenSplash;
import sk.inlogic.Sounds;
import sk.inlogic.fx.SoundManager;
import sk.inlogic.graphics.GFont;
import sk.inlogic.graphics.Rendering2D;
import sk.inlogic.rms.RMSConnect;
import sk.inlogic.rms.RMSHandler;
import sk.inlogic.screen.IScreen;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class MainCanvas
extends GameCanvas
implements Runnable,
RMSHandler {
    public static final int runLen = 40;
    public static int WIDTH = 0;
    public static int HEIGHT = 0;
    public static int WIDTH2 = 0;
    public static int HEIGHT2 = 0;
    public static int WIDTH_FROM_DC = 0;
    public static int HEIGHT_FROM_DC = 0;
    private static Thread mainThread;
    public static IScreen activeScreen;
    public long lLastRun;
    public static final int SCREEN_LANGUAGES = 0;
    public static final int SCREEN_SOUNDS = 1;
    public static final int SCREEN_SPLASH = 2;
    public static final int SCREEN_MENU = 3;
    public static final int SCREEN_GAME = 4;
    public static final int SCREEN_INSTRUCTIONS = 5;
    public static final int SCREEN_LOGOS = 6;
    public static final int SCREEN_SELECT_PACK = 7;
    public static final int SCREEN_SELECT_LEVEL = 8;
    public static final int SCREEN_ABOUT = 9;
    public static final int SCREEN_QUIT = 10;
    public static final int TOTAL_SCREENS = 11;
    public IScreen[] screens = new IScreen[11];
    private boolean interuptionIn;
    private boolean paintIn;
    private boolean paintPaused;
    private boolean bScreenSizeAdjusted;
    public static int mainTableSize;
    public static int arrowBackgroundSize;
    public static int mainUIOffset;
    public static int mainUIOffset2;
    public static int mainUIOffset4;
    public static int emptySpaceOnSides4;
    public int selectedPack = 0;
    public int selectedLevel = 0;
    public int[] packStars = new int[3];
    public static SoundManager soundManager;
    public GFont mainFont = null;
    public static boolean touchActivated;
    public byte[] starsForLevel = new byte[60];
    public boolean[] allowedLevels = new boolean[60];
    public static RMSConnect mainRms;
    public static Rectangle selectItemWithLoading;
    public static boolean loading;
    public static int tutorial;
    public int interuption = 0;
    public static boolean t1;
    public static boolean t2;
    public static boolean t3;
    public static boolean t4;
    public static boolean t5;
    public static boolean t6;
    public static boolean t7;
    public static boolean t8;
    public static boolean freezed;
    public static int beforeAfter;
    public static Font sf;
    private int loadingCounter = 0;
    public static boolean check;
    int kontrola = 0;
    String res = "";

    private static void initUIdetails() {
        if (WIDTH == 480 || WIDTH == 360) {
            mainTableSize = WIDTH * 3 / 5;
            arrowBackgroundSize = 7 * (WIDTH - mainTableSize >> 1) / 10;
            emptySpaceOnSides4 = WIDTH - mainTableSize >> 2;
            mainUIOffset = (WIDTH - mainTableSize >> 1) - emptySpaceOnSides4 - (arrowBackgroundSize >> 1);
        } else {
            mainTableSize = WIDTH * 4 / 6;
            arrowBackgroundSize = 9 * (WIDTH - mainTableSize >> 1) / 10;
            emptySpaceOnSides4 = WIDTH - mainTableSize >> 2;
            mainUIOffset = (WIDTH - mainTableSize >> 1) - emptySpaceOnSides4 - (arrowBackgroundSize >> 1);
        }
        mainUIOffset2 = mainUIOffset >> 1;
        mainUIOffset4 = mainUIOffset2 >> 1;
    }

    private void initLogger() {
    }

    public static void mlog(String s) {
        System.out.println("\t[MLOG]" + s);
    }

    public MainCanvas() {
        super(false);
        this.initCanvas();
        this.initLogger();
        Keys.canvas = this;
        soundManager = new SoundManager(1);
        soundManager.LoadPlayList(Sounds.GAME_SOUND_FILES, Sounds.GAME_SOUND_TYPES, Sounds.GAME_SOUND_FLAGS);
        soundManager.SetVolume(60);
        Resources.loadGFonts(new int[]{0});
        this.mainFont = Resources.resGFonts[0];
        Resources.loadSprite(12);
        Resources.loadSprite(14);
        Resources.loadSprite(20);
        for (int i = 0; i < 60; ++i) {
            this.starsForLevel[i] = 0;
        }
        mainRms = new RMSConnect("mainRms", this);
        if (!mainRms.exist()) {
            mainRms.create();
        } else {
            mainRms.load();
        }
        this.repaint();
        MainCanvas.tr("mc init paint");
    }

    private void initCanvas() {
        super.setFullScreenMode(true);
        mainThread = new Thread(this);
        mainThread.start();
        this.interuptionIn = false;
        this.paintIn = false;
        this.paintPaused = false;
        this.bScreenSizeAdjusted = false;
        this.lLastRun = 0L;
    }

    private IScreen createScreen(int screenType, Object params) {
        switch (screenType) {
            case 4: {
                return new ScreenGame(this);
            }
            case 0: {
                return new ScreenLanguages(this);
            }
            case 6: {
                return new ScreenLogos(this);
            }
            case 3: {
                return new ScreenMainMenu(this);
            }
            case 7: {
                return new ScreenSelectPack(this);
            }
            case 8: {
                return new ScreenSelectLevel(this);
            }
            case 5: {
                return new ScreenInstructions(this);
            }
            case 1: {
                return new ScreenSounds(this);
            }
            case 2: {
                return new ScreenSplash(this);
            }
            case 9: {
                return new ScreenAbout(this);
            }
            case 10: {
                return new ScreenQuit(this);
            }
        }
        return null;
    }

    public void setActiveScreen(int screenType, Object params) {
        Keys.resetAllPressedKeysAndActions();
        if (screenType == 4) {
            loading = true;
        }
        boolean outOfMemory = false;
        try {
            if (this.screens[screenType] == null) {
                this.screens[screenType] = this.createScreen(screenType, params);
            } else if (screenType == 4) {
                this.screens[screenType] = null;
                this.screens[screenType] = this.createScreen(screenType, params);
            }
        }
        catch (OutOfMemoryError e) {
            outOfMemory = true;
        }
        if (outOfMemory) {
            for (int i = 0; i < 11; ++i) {
                this.screens[i] = null;
            }
            System.gc();
            this.screens[screenType] = this.createScreen(screenType, params);
        }
        this.paintPaused = true;
        if (activeScreen != null) {
            while (this.paintIn) {
                System.out.println("wait");
            }
            activeScreen.afterHide();
            activeScreen = null;
            System.gc();
        }
        this.screens[screenType].beforeShow();
        activeScreen = this.screens[screenType];
        this.paintPaused = false;
        if (screenType == 4) {
            loading = false;
        }
        this.repaint();
    }

    public void refreshLoading() {
        ++this.loadingCounter;
        if (this.loadingCounter > 2) {
            this.loadingCounter = 0;
        }
    }

    public void repaintLoading() {
        this.refreshLoading();
        this.repaint(MainCanvas.selectItemWithLoading.x, MainCanvas.selectItemWithLoading.y, MainCanvas.selectItemWithLoading.width, MainCanvas.selectItemWithLoading.height);
        this.serviceRepaints();
    }

    public void paintLoading(Graphics g) {
        Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], selectItemWithLoading);
        for (int i = 0; i < 3; ++i) {
            if (i == this.loadingCounter) {
                Resources.resSprs[20].setFrame(1);
            } else {
                Resources.resSprs[20].setFrame(0);
            }
            switch (i) {
                case 0: {
                    Resources.resSprs[20].setPosition(selectItemWithLoading.getCenterX() - (Resources.resSprsW[20] >> 1) - Resources.resSprsW[20], selectItemWithLoading.getCenterY());
                    break;
                }
                case 1: {
                    Resources.resSprs[20].setPosition(selectItemWithLoading.getCenterX() - (Resources.resSprsW[20] >> 1), selectItemWithLoading.getCenterY());
                    break;
                }
                case 2: {
                    Resources.resSprs[20].setPosition(selectItemWithLoading.getCenterX() + (Resources.resSprsW[20] >> 1), selectItemWithLoading.getCenterY());
                }
            }
            Resources.resSprs[20].paint(g);
        }
    }

    public void hideNotify() {
        check = soundManager.IsSoundOn();
        if (this.interuptionIn) {
            return;
        }
        this.interuptionIn = true;
        soundManager.Stop();
        this.repaint();
        ScreenGame.pauseGame();
        PointerController.angle = 270;
        PointerController.resetAngleIfNeeded();
        PointerController.resetMovingSpeed();
        PointerController.resetStrength();
        Keys.resetAllPressedKeysAndActions();
        beforeAfter = ScreenGame.mode;
    }

    public void nokiaSounds() {
        if (activeScreen != null && (activeScreen == this.screens[3] || activeScreen == this.screens[9] || activeScreen == this.screens[8] || activeScreen == this.screens[5] || activeScreen == this.screens[7]) && soundManager.IsSoundOn() && this.interuption == 0) {
            soundManager.SetVolume(60);
            soundManager.Stop();
            soundManager.Play(Sounds.SOUND_MENU, -1);
        }
    }

    public void showNotify() {
        if (!this.interuptionIn) {
            return;
        }
        this.interuptionIn = false;
        if (activeScreen != null) {
            if (activeScreen == this.screens[3] || activeScreen == this.screens[9] || activeScreen == this.screens[2] || activeScreen == this.screens[8] || activeScreen == this.screens[5] || activeScreen == this.screens[7]) {
                if (soundManager.IsSoundOn()) {
                    this.kontrola = 1;
                    soundManager.Play(Sounds.SOUND_MENU, -1);
                }
            } else if (activeScreen == this.screens[4] && soundManager.IsSoundOn()) {
                if (this.selectedPack == 0) {
                    soundManager.Play(Sounds.SOUND_GAME_1, -1);
                } else if (this.selectedPack == 1) {
                    soundManager.Play(Sounds.SOUND_GAME_2, -1);
                } else if (this.selectedPack == 2) {
                    soundManager.Play(Sounds.SOUND_GAME_3, -1);
                }
            }
            if (activeScreen == this.screens[4] && (beforeAfter == 4 || beforeAfter == 5)) {
                ScreenGame.mode = beforeAfter;
            }
        }
        ScreenGame.repaintTopHUD = true;
        ScreenGame.repaintBottomHUD = true;
    }

    public void run() {
        while (Thread.currentThread() == mainThread) {
            Thread.yield();
            if (System.currentTimeMillis() - this.lLastRun < 40L) continue;
            if (activeScreen != null) {
                activeScreen.update(System.currentTimeMillis() - this.lLastRun);
            }
            this.lLastRun = System.currentTimeMillis();
        }
    }

    public void paintX(Graphics g) {
        if (WIDTH_FROM_DC < HEIGHT_FROM_DC && WIDTH > HEIGHT || WIDTH_FROM_DC > HEIGHT_FROM_DC && WIDTH < HEIGHT) {
            g.drawString("koooooooooooooooooooooookooooooooooooooooooooooooooooooootooooooooooooooooooooooooooo", 10, 10, 4);
            this.paintResRotation(g);
            g.drawString("koooooooooooooooooooooookooooooooooooooooooooooooooooooootooooooooooooooooooooooooooo", 10, 10, 4);
            int h = HEIGHT;
            HEIGHT = WIDTH;
            WIDTH = h;
            return;
        }
        if (activeScreen != null) {
            this.paintIn = true;
            activeScreen.paint(g);
            this.paintIn = false;
        }
    }

    public void paint(Graphics g) {
        if (loading) {
            this.paintLoading(g);
            return;
        }
        if (this.paintPaused) {
            return;
        }
        if (WIDTH_FROM_DC < HEIGHT_FROM_DC && this.getWidth() > this.getHeight() || WIDTH_FROM_DC > HEIGHT_FROM_DC && this.getWidth() < this.getHeight()) {
            this.paintResRotation(g);
            int h = this.getHeight();
            HEIGHT = this.getWidth();
            WIDTH = h;
            return;
        }
        if (!this.bScreenSizeAdjusted) {
            HEIGHT = g.getClipHeight();
            WIDTH = g.getClipWidth();
            WIDTH2 = WIDTH >> 1;
            HEIGHT2 = HEIGHT >> 1;
            this.bScreenSizeAdjusted = true;
            MainCanvas.initUIdetails();
            this.setActiveScreen(6, null);
        } else if (WIDTH_FROM_DC < HEIGHT_FROM_DC && WIDTH > HEIGHT || WIDTH_FROM_DC > HEIGHT_FROM_DC && WIDTH < HEIGHT) {
            this.paintResRotation(g);
            int h = HEIGHT;
            HEIGHT = WIDTH;
            WIDTH = h;
            return;
        }
        this.paintX(g);
        if (WIDTH_FROM_DC < HEIGHT_FROM_DC && WIDTH > HEIGHT || WIDTH_FROM_DC > HEIGHT_FROM_DC && WIDTH < HEIGHT) {
            this.paintResRotation(g);
            int h = HEIGHT;
            HEIGHT = WIDTH;
            WIDTH = h;
            return;
        }
    }

    public final void paint() {
        this.repaint();
    }

    public void paintResRotation(Graphics g) {
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        g.setColor(0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (Resources.resImgs[6] == null) {
            Resources.loadImage(6);
        } else {
            g.drawImage(Resources.resImgs[6], this.getWidth() / 2, this.getHeight() / 2, 3);
        }
    }

    private int modifyKeyCode(int keyCode) {
        return keyCode;
    }

    protected void keyPressed(int keyCode) {
        if ((keyCode = this.modifyKeyCode(keyCode)) != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
            Keys.keyPressed(keyCode);
            if (activeScreen != null) {
                activeScreen.keyPressed(keyCode);
            }
            System.out.println("stlacene 1");
        }
    }

    private void onKeyReleased(int keyCode) {
        if (activeScreen != null) {
            activeScreen.keyReleased(keyCode);
        }
        Keys.keyReleased(keyCode);
        System.out.println("stlacene 3");
    }

    protected void keyReleased(int keyCode) {
        keyCode = this.modifyKeyCode(keyCode);
        System.out.println("stlacene 5");
        if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
            this.onKeyReleased(keyCode);
        }
    }

    protected void pointerPressed(int x, int y) {
    }

    protected void pointerDragged(int x, int y) {
    }

    protected void pointerReleased(int x, int y) {
    }

    public static int getStarsNeededForLevel(int idx) {
        if (idx == 0) {
            return 0;
        }
        if (idx == 1) {
            return 1;
        }
        return idx * 2 - 1;
    }

    public int getAllEarnedStars() {
        int val = 0;
        for (int i = 0; i < this.starsForLevel.length; ++i) {
            val += this.starsForLevel[i];
        }
        return val;
    }

    public int getSelectedLevelLocal() {
        return this.selectedLevel % 20;
    }

    public int getSelectedLevelGlobal() {
        return this.selectedPack * 20 + this.getSelectedLevelLocal();
    }

    public void save(DataOutputStream dos, String rmsName) throws IOException {
        MainCanvas.tr("saving");
        dos.writeBoolean(true);
        for (int i = 0; i < 60; ++i) {
            MainCanvas.tr("saving: " + this.starsForLevel[i]);
            dos.writeByte(this.starsForLevel[i]);
        }
    }

    public void load(DataInputStream dis, String rmsName) throws IOException {
        MainCanvas.tr("loading");
        soundManager.SetSoundOn(dis.readBoolean());
        for (int i = 0; i < 60; ++i) {
            this.starsForLevel[i] = dis.readByte();
        }
    }

    public void setDefault(DataOutputStream dos, String rmsName) throws IOException {
        MainCanvas.tr("creating");
        dos.writeBoolean(true);
        for (int i = 0; i < 60; ++i) {
            dos.writeByte(0);
        }
    }

    public static void tr(String _s) {
        System.out.println(_s);
    }

    static {
        mainTableSize = 0;
        arrowBackgroundSize = 0;
        mainUIOffset = 0;
        mainUIOffset2 = 0;
        mainUIOffset4 = 0;
        emptySpaceOnSides4 = 0;
        touchActivated = false;
        mainRms = null;
        selectItemWithLoading = null;
        loading = false;
        tutorial = 0;
        t1 = false;
        t2 = false;
        t3 = false;
        t4 = false;
        t5 = false;
        t6 = false;
        t7 = false;
        t8 = false;
        freezed = false;
        beforeAfter = 9999;
        String fullCanvasSize = "176x204";
        try {
            WIDTH = WIDTH_FROM_DC = Integer.valueOf(fullCanvasSize.substring(0, fullCanvasSize.indexOf("x"))).intValue();
            HEIGHT = HEIGHT_FROM_DC = Integer.valueOf(fullCanvasSize.substring(fullCanvasSize.indexOf("x") + 1)).intValue();
            WIDTH2 = WIDTH >> 1;
            HEIGHT2 = HEIGHT >> 1;
            MainCanvas.initUIdetails();
        }
        catch (Exception exception) {
            // empty catch block
        }
        sf = Font.getFont((int)0, (int)0, (int)8);
    }
}

