/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Collisions;
import sk.inlogic.GridController;
import sk.inlogic.GridItemTypes;
import sk.inlogic.MainCanvas;
import sk.inlogic.PointerController;
import sk.inlogic.Projectile;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.graphics.Rendering2D;
import sk.inlogic.screen.IScreen;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.CMathFP;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Particles;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;
import sk.inlogic.util.Tools;

public class ScreenGame
implements IScreen {
    public static boolean arrowUP = false;
    public static boolean arrowDOWN = true;
    private static final int ITEM_HUD = 0;
    private static final int ITEM_OPEN_GAME_MENU = 1;
    private static final int ITEM_CONTINUE = 2;
    private static final int ITEM_RESTART = 3;
    private static final int ITEM_SOUNDS = 4;
    private static final int ITEM_HELP = 5;
    private static final int ITEM_QUIT_TO_MENU = 6;
    private static final int ITEM_RESULT_TABLE = 7;
    private static final int ITEM_RESULT_EXIT = 8;
    private static final int ITEM_RESULT_RESTART = 9;
    private static final int ITEM_RESULT_NEXT_LEVEL = 10;
    private static final int ITEM_HUD_CONTROLS = 11;
    private static final int ITEM_HUD_CONTROLS_LEFT_ARROW = 12;
    private static final int ITEM_HUD_CONTROLS_RIGHT_ARROW = 13;
    private static final int ITEM_HUD_CONTROLS_FIRE_BUTTON = 14;
    private static final int ITEM_HUD_CONTROLS_POWER_BAR = 15;
    private Rectangle leftArrowBiggerRect = null;
    private Rectangle rightArrowBiggerRect = null;
    private Rectangle fireButtonBiggerRect = null;
    private Rectangle openGameMenuBiggerRect = null;
    private Rectangle tutorialRect;
    public static boolean paintTop = true;
    Rectangle[] controlItems = new Rectangle[16];
    Rectangle rectBoard = null;
    private static final int MODE_PLAYING = 1;
    private static final int MODE_GAME_MENU = 2;
    private static final int MODE_LEVEL_END = 3;
    public static final int MODE_TUTORIAL = 4;
    public static final int MODE_TUTORIAL_2 = 5;
    private static final int MODE_HELP = 6;
    private final int ACORN;
    private final int BOMB;
    private final int COCONUT;
    private final int FREEZE;
    private final int FRUIT_1;
    private final int FRUIT_2;
    private final int HONEY;
    private final int ICE;
    private final int MARSHMALLOW;
    private final int ROCK;
    private final int TRIPLE_SHOT;
    MainCanvas mc;
    static int mode = 1;
    long modeDelay;
    private int levelIndex;
    private int oneStarSuccess = 0;
    private int twoStarSuccess = 0;
    private int threeStarSuccess = 0;
    private int stars = 0;
    private int levelPointerX;
    private int levelPointerY;
    private int pointerX = 0;
    private int pointerY = 0;
    private Sprite acorn = null;
    private Sprite bomb = null;
    private Sprite wood = null;
    private Sprite freeze = null;
    private Sprite fruit_1 = null;
    private Sprite fruit_2 = null;
    private Sprite honey = null;
    private Sprite ice = null;
    private Sprite marshmallow = null;
    private Sprite rock = null;
    private Sprite triple_shot = null;
    private Image bg = null;
    private Sprite worm = null;
    private Image resultBarEmpty = null;
    private Image resultBarFull = null;
    private Image upperHUDbg = null;
    private Image bottomHUDbg = null;
    private int upperHUDbgH = 0;
    private int bottomHUDbgH = 0;
    public static Sprite stone_particles = null;
    public static Sprite wood_particles = null;
    private static int resultBarX = -1;
    private static int resultBarY = -1;
    private int resultBarW = -1;
    private int resultBarH = -1;
    private int resultBarW2 = -1;
    private int resultBarH2 = -1;
    private int resultBarW3 = -1;
    private int wormW = -1;
    private int wormH = -1;
    private int wormW2 = -1;
    private int wormH2 = -1;
    private int acornW = -1;
    private int acornH = -1;
    private int acornW2 = -1;
    private int acornH2 = -1;
    private int itemW = -1;
    private int itemH = -1;
    private int itemW2 = -1;
    private int itemH2 = -1;
    private int gridW = -1;
    private int gridH = -1;
    private int[] itemsCenterOffsetX;
    private int[] itemsCenterOffsetY;
    private int[] gridCentersX;
    private int[] gridCentersY;
    private boolean selectingStrength = false;
    private int selectedItemInGameMenu = 2;
    private static int projectilesForLevel = 0;
    public static int projectilesFired = 0;
    public static int importantItemsShooted = 0;
    public static int importantItemsForLevel = 0;
    public static char[] numberOfShotsCharArr = null;
    private boolean levelEnded = false;
    private boolean levelSucceed = false;
    private int resultButtonW = 0;
    private int resultButtonH = 0;
    public static int[] smokeFrames = null;
    public static int[] smokeBombFrames = null;
    private int smokeSpriteW = -1;
    private int smokeSpriteH = -1;
    private int smokeSpriteW2 = -1;
    private int smokeSpriteH2 = -1;
    public static int[] crackedStoneFrameCounter = null;
    public static int[] crackedWoodFrameCounter = null;
    private Image powerBar = null;
    private Image powerBarBg = null;
    private boolean powerBarHidden = true;
    private static final int POWER_BAR_STILL = 0;
    private static final int POWER_BAR_SHOWING = 1;
    private static final int POWER_BAR_HIDING = 2;
    private static final int POWER_BAR_ANIMATION_SPEED = 16;
    private int powerBarState = 0;
    private int resultTextsCenterY = -1;
    private char[] resultTextCharArr = null;
    private char[] winTextCharArr = null;
    private int starResultCounter = 0;
    private static final int showStarTime = 10;
    private static int particlesVelX = 20;
    private static int particlesVelY = -50;
    private static int particlesAccX = 1;
    private static int particlesAccY = 12;
    private static int particleCol = 16766720;
    private static int particleSize = 4;
    private static int particleLife = 40;
    private static int holdingItemIndex = -1;
    private int powerBarOffset = 0;
    public static boolean repaintBottomHUD = true;
    public static boolean repaintTopHUD = true;
    private Rectangle touchControlBottomHudRect = null;
    PreparedText pt = null;
    PreparedText textTutorial = null;
    PreparedText textHelp = null;
    PreparedText resultText = null;
    Rectangle rectText = null;
    private static final int ITEM_BACK = 0;
    private static final int ITEM_UP = 1;
    private static final int ITEM_DOWN = 2;
    Rectangle[] rectItems = new Rectangle[3];
    private int ptYOffset = 0;
    int t = 0;
    boolean allowChecking = false;
    boolean allowNextLevel = false;
    boolean gameEnd = false;
    int i = 0;
    int bombSpriteCounter = 0;
    int bombSpriteSpeed = 1;
    int randomBlinkNum = 0;
    boolean blink = false;
    public static final int CRACKED_SHOW_TIME = 5;
    boolean firstPaint = true;
    public static boolean repaintBuffer = true;
    boolean repaintPowerBarAnimation = false;
    int tmpOffset = 0;
    int pressOnX;
    int pressOnY;
    int draggedOnX;
    int draggedOnY;
    boolean holdingFireButton = false;
    boolean holdingPointerLeftArrow = false;
    boolean holdingPointerRightArrow = false;

    public ScreenGame(MainCanvas mainCanvas) {
        this.ACORN = 0;
        this.BOMB = 1;
        this.COCONUT = 2;
        this.FREEZE = 3;
        this.FRUIT_1 = 4;
        this.FRUIT_2 = 5;
        this.HONEY = 6;
        this.ICE = 7;
        this.MARSHMALLOW = 8;
        this.ROCK = 9;
        this.TRIPLE_SHOT = 10;
        this.mc = mainCanvas;
    }

    public void beforeShow() {
        Resources.loadText(0);
        this.winTextCharArr = Resources.resTexts[0].getHashedString(7).toCharArray();
        this.gameEnd = false;
        this.stars = 0;
        PointerController.destroyAllProjectiles();
        int bgIdx = -1;
        int stickIdx = -1;
        switch (this.mc.selectedPack) {
            case 0: {
                bgIdx = 2;
                break;
            }
            case 1: {
                bgIdx = 3;
                break;
            }
            case 2: {
                bgIdx = 4;
            }
        }
        System.out.println("som TU 1");
        Resources.loadImages(new int[]{7, 8, bgIdx, 42, 27, 39, stickIdx, 28, 32, 34, 35, 33, 15, 36, 16, 26, 25, 29, 38});
        System.out.println("som TU 2");
        Resources.loadSprites(new int[]{23, 15, 16, 19, 4, 5, 22, 0, 1, 2, 3, 6, 7, 8, 9, 10, 13, 17, 18});
        stone_particles = Resources.resSprs[17];
        wood_particles = Resources.resSprs[18];
        this.resultBarEmpty = Resources.resImgs[32];
        this.resultBarFull = Resources.resImgs[33];
        this.resultBarW = Resources.resImgsW[32];
        this.resultBarH = Resources.resImgsH[32];
        this.resultBarW2 = this.resultBarW >> 1;
        this.resultBarH2 = this.resultBarH >> 1;
        this.resultBarW3 = this.resultBarW / 3;
        this.resultButtonW = (MainCanvas.mainTableSize - (MainCanvas.mainUIOffset2 << 1)) / 3;
        this.resultButtonH = Resources.resImgsH[36] + (MainCanvas.mainUIOffset << 1);
        this.bg = Resources.resImgs[bgIdx];
        this.worm = Resources.resSprs[15];
        this.wormW = Resources.resSprsW[15];
        this.wormH = Resources.resSprsH[15];
        this.wormW2 = this.wormW >> 1;
        this.wormH2 = this.wormH >> 1;
        this.acornW = Resources.resSprsW[0];
        this.acornH = Resources.resSprsH[0];
        this.acornW2 = this.acornW >> 1;
        this.acornH2 = this.acornH >> 1;
        PointerController.setWormSprite();
        Projectile.frameCount = this.worm.getRawFrameCount();
        GridController.setCanvasSize(MainCanvas.WIDTH, MainCanvas.HEIGHT);
        PointerController.setBounds(MainCanvas.WIDTH / 2, MainCanvas.HEIGHT, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        PointerController.setPointerDotImage();
        PointerController.setPosition(MainCanvas.WIDTH2, MainCanvas.HEIGHT2);
        this.acorn = Resources.resSprs[0];
        this.bomb = Resources.resSprs[1];
        this.wood = Resources.resSprs[2];
        this.freeze = Resources.resSprs[3];
        this.fruit_1 = Resources.resSprs[4];
        this.fruit_2 = Resources.resSprs[5];
        this.honey = Resources.resSprs[6];
        this.ice = Resources.resSprs[7];
        this.marshmallow = Resources.resSprs[8];
        this.rock = Resources.resSprs[9];
        this.triple_shot = Resources.resSprs[10];
        try {
            InputStream is = this.getClass().getResourceAsStream("/" + this.mc.selectedLevel + ".b");
            DataInputStream dis = new DataInputStream(is);
            this.levelIndex = dis.readInt();
            ScreenGame.tr("index: " + this.levelIndex);
            int pointerX = dis.readInt();
            int pointerY = dis.readInt();
            ScreenGame.tr("xOffset: " + GridController.xOffset);
            ScreenGame.tr("yOffset: " + GridController.yOffset);
            int fpPX = CMathFP.toFP(pointerX);
            int fpPY = CMathFP.toFP(pointerY);
            int fp480 = CMathFP.toFP(480);
            int fpWidth = 0;
            fpWidth = MainCanvas.WIDTH_FROM_DC == 320 && MainCanvas.HEIGHT_FROM_DC < 320 ? CMathFP.toFP(176) : (MainCanvas.WIDTH_FROM_DC == 220 && MainCanvas.HEIGHT_FROM_DC < 230 ? CMathFP.toFP(128) : (MainCanvas.WIDTH_FROM_DC == 480 && MainCanvas.HEIGHT_FROM_DC < 400 ? CMathFP.toFP(240) : CMathFP.toFP(MainCanvas.WIDTH)));
            int fpPointerRatio = CMathFP.div(fp480, fpWidth);
            int fpPointerX = CMathFP.div(fpPX, fpPointerRatio);
            int fpPointerY = CMathFP.div(fpPY, fpPointerRatio);
            pointerX = CMathFP.toInt(fpPointerX);
            pointerY = CMathFP.toInt(fpPointerY);
            PointerController.setPosition(pointerX + GridController.xOffset, pointerY + GridController.yOffset);
            this.oneStarSuccess = dis.readInt();
            this.twoStarSuccess = dis.readInt();
            this.threeStarSuccess = dis.readInt();
            projectilesForLevel = dis.readInt();
            int gridLen = GridController.grid.length;
            for (int i = 0; i < gridLen; ++i) {
                GridController.grid[i] = dis.readInt();
                int y = i / GridController.getGridWidth();
                int x = i - y * GridController.getGridWidth();
                if (GridController.grid[i] != 0) {
                    Collisions.setCollision(x, y, true);
                    continue;
                }
                Collisions.setCollision(x, y, false);
            }
            dis.close();
            is.close();
        }
        catch (Exception e) {
            ScreenGame.tr("exception in loading level: " + e);
        }
        numberOfShotsCharArr = (projectilesForLevel + "/" + projectilesForLevel).toCharArray();
        this.itemW = GridController.getGridSizeW();
        this.itemH = GridController.getGridSizeH();
        this.itemW2 = this.itemW >> 1;
        this.itemH2 = this.itemH >> 1;
        this.gridW = GridController.getGridWidth();
        this.gridH = GridController.getGridHeight();
        this.itemsCenterOffsetX = new int[11];
        this.itemsCenterOffsetY = new int[11];
        this.itemsCenterOffsetX[4] = Resources.resSprsW[4] >> 1;
        this.itemsCenterOffsetY[4] = Resources.resSprsH[4] >> 1;
        this.itemsCenterOffsetX[5] = Resources.resSprsW[5] >> 1;
        this.itemsCenterOffsetY[5] = Resources.resSprsH[5] >> 1;
        this.itemsCenterOffsetX[0] = Resources.resSprsW[0] >> 1;
        this.itemsCenterOffsetY[0] = Resources.resSprsH[0] >> 1;
        this.itemsCenterOffsetX[1] = Resources.resSprsW[1] >> 1;
        this.itemsCenterOffsetY[1] = Resources.resSprsH[1] >> 1;
        this.itemsCenterOffsetX[2] = Resources.resSprsW[2] >> 1;
        this.itemsCenterOffsetY[2] = Resources.resSprsH[2] >> 1;
        this.itemsCenterOffsetX[6] = Resources.resSprsW[6] >> 1;
        this.itemsCenterOffsetY[6] = Resources.resSprsH[6] >> 1;
        this.itemsCenterOffsetX[9] = Resources.resSprsW[9] >> 1;
        this.itemsCenterOffsetY[9] = Resources.resSprsH[9] >> 1;
        this.itemsCenterOffsetX[7] = Resources.resSprsW[7] >> 1;
        this.itemsCenterOffsetY[7] = Resources.resSprsH[7] >> 1;
        this.itemsCenterOffsetX[8] = Resources.resSprsW[8] >> 1;
        this.itemsCenterOffsetY[8] = Resources.resSprsH[8] >> 1;
        this.itemsCenterOffsetX[10] = Resources.resSprsW[10] >> 1;
        this.itemsCenterOffsetY[10] = Resources.resSprsH[10] >> 1;
        this.itemsCenterOffsetX[3] = Resources.resSprsW[3] >> 1;
        this.itemsCenterOffsetY[3] = Resources.resSprsH[3] >> 1;
        this.gridCentersX = new int[this.gridW * this.gridH];
        this.gridCentersY = new int[this.gridW * this.gridH];
        smokeFrames = new int[this.gridW * this.gridH];
        smokeBombFrames = new int[this.gridW * this.gridH];
        crackedStoneFrameCounter = new int[this.gridW * this.gridH];
        crackedWoodFrameCounter = new int[this.gridW * this.gridH];
        this.smokeSpriteW = Resources.resSprsW[16];
        this.smokeSpriteH = Resources.resSprsH[16];
        this.smokeSpriteW2 = this.smokeSpriteW >> 1;
        this.smokeSpriteH2 = this.smokeSpriteH >> 1;
        for (int y = 0; y < this.gridH; ++y) {
            for (int x = 0; x < this.gridW; ++x) {
                int idx = y * this.gridW + x;
                ScreenGame.smokeFrames[idx] = -1;
                ScreenGame.smokeBombFrames[idx] = -1;
                ScreenGame.crackedStoneFrameCounter[idx] = -1;
                ScreenGame.crackedWoodFrameCounter[idx] = -1;
                this.gridCentersX[idx] = GridController.xOffset + x * this.itemW + this.itemW2;
                this.gridCentersY[idx] = GridController.yOffset + y * this.itemH + this.itemH2;
            }
        }
        int tmpOffset = 0;
        int tmpOffset2 = 0;
        if (MainCanvas.WIDTH == 128 || MainCanvas.WIDTH_FROM_DC == 220 && MainCanvas.HEIGHT_FROM_DC < 230) {
            this.controlItems[0] = new Rectangle(-1, -1, MainCanvas.WIDTH + 2, Resources.resImgsH[25] + (MainCanvas.mainUIOffset << 1) + 2);
            tmpOffset = -1;
            tmpOffset2 = 2;
        } else if (MainCanvas.WIDTH == 176 || MainCanvas.WIDTH_FROM_DC == 320 && MainCanvas.HEIGHT_FROM_DC < 320) {
            this.controlItems[0] = new Rectangle(-1, -1, MainCanvas.WIDTH + 2, Resources.resImgsH[33] + (MainCanvas.mainUIOffset << 2) + 2);
            tmpOffset = -1;
            tmpOffset2 = 4;
        } else if (MainCanvas.WIDTH == 240) {
            this.controlItems[0] = new Rectangle(-2, -2, MainCanvas.WIDTH + 4, Resources.resImgsH[25] + (MainCanvas.mainUIOffset << 2) + 4);
            tmpOffset = 0;
            tmpOffset2 = 4;
            if (MainCanvas.touchActivated) {
                tmpOffset2 = 3;
            }
        } else if (MainCanvas.WIDTH_FROM_DC == 480 && MainCanvas.HEIGHT_FROM_DC < 400) {
            this.controlItems[0] = new Rectangle(-2, -2, MainCanvas.WIDTH + 4, Resources.resImgsH[25] + (MainCanvas.mainUIOffset << 2) + 4);
            tmpOffset = 0;
            tmpOffset2 = 4;
        } else {
            this.controlItems[0] = new Rectangle(-2, -2, MainCanvas.WIDTH + 4, MainCanvas.arrowBackgroundSize + 4);
            tmpOffset = 0;
            tmpOffset2 = 4;
        }
        if (MainCanvas.WIDTH == 480 && MainCanvas.HEIGHT > 480 || MainCanvas.WIDTH == 360 && MainCanvas.HEIGHT > 400) {
            tmpOffset2 = 3;
        }
        int controlBarsH = 0;
        controlBarsH = MainCanvas.touchActivated ? (MainCanvas.WIDTH == 240 && MainCanvas.HEIGHT > 350 ? Resources.resSprsH[22] * 2 + (MainCanvas.mainUIOffset2 << 1) : (MainCanvas.WIDTH == 240 && MainCanvas.HEIGHT > 319 ? 3 * Resources.resSprsH[22] / 2 + (MainCanvas.mainUIOffset2 << 1) : Resources.resSprsH[22] + (MainCanvas.mainUIOffset2 << 1))) : (MainCanvas.WIDTH == 128 || MainCanvas.WIDTH_FROM_DC == 220 && MainCanvas.HEIGHT_FROM_DC < 230 ? Resources.resImgsH[34] + (MainCanvas.mainUIOffset << 1) : (MainCanvas.WIDTH == 176 || MainCanvas.WIDTH_FROM_DC == 320 && MainCanvas.HEIGHT_FROM_DC < 320 ? Resources.resImgsH[34] + (MainCanvas.mainUIOffset << 1) + 2 : (MainCanvas.WIDTH_FROM_DC == 480 && MainCanvas.HEIGHT_FROM_DC < 400 ? Resources.resImgsH[34] + (MainCanvas.mainUIOffset << 2) : Resources.resImgsH[34] + (MainCanvas.mainUIOffset << 2))));
        this.controlItems[14] = new Rectangle(MainCanvas.WIDTH - Resources.resImgsW[38] - (MainCanvas.mainUIOffset << 2) - 2, MainCanvas.HEIGHT - controlBarsH - 1, Resources.resImgsW[38] + (MainCanvas.mainUIOffset << 2) + 4, controlBarsH + 2);
        this.fireButtonBiggerRect = new Rectangle(this.controlItems[14]);
        this.fireButtonBiggerRect.height = 2 * this.fireButtonBiggerRect.height;
        this.fireButtonBiggerRect.y = MainCanvas.HEIGHT - this.fireButtonBiggerRect.height;
        this.controlItems[1] = MainCanvas.WIDTH == 480 || MainCanvas.WIDTH == 360 && (MainCanvas.WIDTH_FROM_DC != 480 || MainCanvas.HEIGHT_FROM_DC >= 400) ? new Rectangle(this.controlItems[0].getRight() - MainCanvas.mainUIOffset - Resources.resImgsW[36], this.controlItems[0].getCenterY() - (Resources.resImgsH[36] >> 1), Resources.resImgsW[36], Resources.resImgsH[36]) : (MainCanvas.touchActivated ? new Rectangle(this.controlItems[0].getRight() - MainCanvas.mainUIOffset * 4 - Resources.resImgsW[36], this.controlItems[0].getCenterY() - (Resources.resImgsH[36] >> 1), Resources.resImgsW[36], Resources.resImgsH[36]) : new Rectangle(MainCanvas.WIDTH - Resources.resImgsW[36] - (MainCanvas.mainUIOffset << 2) - 2, MainCanvas.HEIGHT - (Resources.resImgsH[36] + (MainCanvas.mainUIOffset2 << 1)) - 1, Resources.resImgsW[36] + (MainCanvas.mainUIOffset << 2) + 4, Resources.resImgsH[36] + (MainCanvas.mainUIOffset2 << 1) + 2));
        this.openGameMenuBiggerRect = new Rectangle(this.controlItems[1]);
        this.openGameMenuBiggerRect.height = 2 * this.openGameMenuBiggerRect.height;
        this.openGameMenuBiggerRect.width = 2 * this.openGameMenuBiggerRect.width;
        this.openGameMenuBiggerRect.y = this.controlItems[1].y;
        this.openGameMenuBiggerRect.x = this.controlItems[1].getCenterX() - (this.openGameMenuBiggerRect.width >> 1);
        this.controlItems[11] = MainCanvas.touchActivated ? (MainCanvas.WIDTH == 480 || MainCanvas.WIDTH == 360 ? new Rectangle(-2, MainCanvas.HEIGHT - controlBarsH - 1, MainCanvas.WIDTH - (this.controlItems[14].width - 4) + 4, controlBarsH + 2) : new Rectangle(-1, MainCanvas.HEIGHT - controlBarsH - 1, MainCanvas.WIDTH - (this.controlItems[14].width - 2) + 2, controlBarsH + 2)) : new Rectangle(-1, MainCanvas.HEIGHT - controlBarsH - 1, MainCanvas.WIDTH + 2, controlBarsH + 2);
        int gameArrowWidth = this.controlItems[11].width - 4 >> 1;
        this.controlItems[12] = new Rectangle(this.controlItems[11].x + 1, this.controlItems[11].y, gameArrowWidth + 2, this.controlItems[11].height);
        this.leftArrowBiggerRect = new Rectangle(this.controlItems[12]);
        this.leftArrowBiggerRect.height = 2 * this.leftArrowBiggerRect.height;
        this.leftArrowBiggerRect.y = MainCanvas.HEIGHT - this.leftArrowBiggerRect.height;
        this.controlItems[13] = new Rectangle(this.controlItems[11].x + (this.controlItems[11].width >> 1) - 3, this.controlItems[11].y, gameArrowWidth + 6, this.controlItems[11].height);
        this.rightArrowBiggerRect = new Rectangle(this.controlItems[13]);
        this.rightArrowBiggerRect.height = 2 * this.rightArrowBiggerRect.height;
        this.rightArrowBiggerRect.y = MainCanvas.HEIGHT - this.rightArrowBiggerRect.height;
        this.touchControlBottomHudRect = new Rectangle(this.controlItems[12].x, this.controlItems[12].y, MainCanvas.WIDTH, this.controlItems[12].height);
        this.controlItems[3] = new Rectangle(MainCanvas.WIDTH - MainCanvas.mainTableSize >> 1, MainCanvas.HEIGHT2 - MainCanvas.mainUIOffset2 - MainCanvas.arrowBackgroundSize, MainCanvas.mainTableSize, MainCanvas.arrowBackgroundSize);
        this.controlItems[2] = new Rectangle(MainCanvas.WIDTH - MainCanvas.mainTableSize >> 1, this.controlItems[3].y - MainCanvas.mainUIOffset - MainCanvas.arrowBackgroundSize, MainCanvas.mainTableSize, MainCanvas.arrowBackgroundSize);
        this.controlItems[4] = new Rectangle(MainCanvas.WIDTH - MainCanvas.mainTableSize >> 1, this.controlItems[3].getBottom() + MainCanvas.mainUIOffset, MainCanvas.mainTableSize, MainCanvas.arrowBackgroundSize);
        this.controlItems[5] = new Rectangle(MainCanvas.WIDTH - MainCanvas.mainTableSize >> 1, this.controlItems[4].getBottom() + MainCanvas.mainUIOffset, MainCanvas.mainTableSize, MainCanvas.arrowBackgroundSize);
        this.controlItems[6] = new Rectangle(MainCanvas.WIDTH - MainCanvas.mainTableSize >> 1, this.controlItems[5].getBottom() + MainCanvas.mainUIOffset, MainCanvas.mainTableSize, MainCanvas.arrowBackgroundSize);
        this.controlItems[7] = new Rectangle(MainCanvas.WIDTH - MainCanvas.mainTableSize >> 1, MainCanvas.HEIGHT - MainCanvas.mainTableSize >> 1, MainCanvas.mainTableSize, MainCanvas.mainTableSize);
        this.controlItems[8] = new Rectangle(this.controlItems[7].x, this.controlItems[7].getBottom() + MainCanvas.mainUIOffset2, this.resultButtonW, this.resultButtonH);
        this.controlItems[9] = new Rectangle(this.controlItems[8].getRight() + MainCanvas.mainUIOffset2, this.controlItems[7].getBottom() + MainCanvas.mainUIOffset2, this.resultButtonW, this.resultButtonH);
        this.controlItems[10] = new Rectangle(this.controlItems[9].getRight() + MainCanvas.mainUIOffset2, this.controlItems[7].getBottom() + MainCanvas.mainUIOffset2, this.resultButtonW, this.resultButtonH);
        this.rectItems[1] = new Rectangle(MainCanvas.WIDTH - MainCanvas.arrowBackgroundSize >> 1, MainCanvas.mainUIOffset, MainCanvas.arrowBackgroundSize, MainCanvas.arrowBackgroundSize);
        this.rectItems[2] = new Rectangle(MainCanvas.WIDTH - MainCanvas.arrowBackgroundSize >> 1, MainCanvas.HEIGHT - MainCanvas.mainUIOffset - MainCanvas.arrowBackgroundSize, MainCanvas.arrowBackgroundSize, MainCanvas.arrowBackgroundSize);
        this.rectItems[0] = new Rectangle(MainCanvas.WIDTH - (MainCanvas.mainUIOffset + 3 * Resources.resImgsW[8] / 2), MainCanvas.HEIGHT - (MainCanvas.mainUIOffset + MainCanvas.arrowBackgroundSize), 3 * Resources.resImgsW[8] / 2, MainCanvas.arrowBackgroundSize);
        this.powerBar = Resources.resImgs[34];
        this.powerBarBg = Resources.resImgs[35];
        this.powerBarState = 0;
        this.powerBarHidden = true;
        this.controlItems[15] = new Rectangle(this.controlItems[11].x, MainCanvas.HEIGHT, this.controlItems[11].width, this.controlItems[11].height);
        this.tutorialRect = new Rectangle(0, 0 + this.controlItems[2].height + 4, MainCanvas.WIDTH, MainCanvas.HEIGHT - 2 * this.controlItems[2].height - (this.controlItems[2].height / 2 - 4));
        if (!MainCanvas.touchActivated) {
            this.revealPowerBar();
        }
        int tmpInt = this.controlItems[7].height - MainCanvas.mainUIOffset - Resources.resImgsH[28] >> 1;
        this.resultTextsCenterY = MainCanvas.WIDTH == 480 || MainCanvas.WIDTH == 360 ? this.controlItems[7].y + Resources.resImgsH[28] + tmpInt : this.controlItems[7].y + MainCanvas.mainUIOffset + Resources.resImgsH[28] + tmpInt;
        resultBarX = this.controlItems[1].x - MainCanvas.mainUIOffset - this.resultBarW - (Resources.resImgsW[25] >> 1);
        resultBarY = MainCanvas.WIDTH == 240 || MainCanvas.WIDTH_FROM_DC == 480 && MainCanvas.HEIGHT_FROM_DC < 400 ? this.controlItems[0].getCenterY() - (this.resultBarH >> 1) - 1 : (MainCanvas.WIDTH == 176 || MainCanvas.WIDTH_FROM_DC == 320 && MainCanvas.HEIGHT_FROM_DC < 320 ? this.controlItems[0].getCenterY() - (this.resultBarH >> 1) - 1 : (MainCanvas.WIDTH_FROM_DC == 220 && MainCanvas.HEIGHT_FROM_DC < 230 ? this.controlItems[0].getCenterY() - (this.resultBarH >> 1) : (MainCanvas.WIDTH == 480 || MainCanvas.WIDTH == 360 ? this.controlItems[0].getCenterY() - (this.resultBarH >> 1) - 1 : this.controlItems[0].getCenterY() - (this.resultBarH >> 1))));
        mode = this.mc.selectedLevel == 0 || this.mc.selectedLevel == 5 || this.mc.selectedLevel == 10 || this.mc.selectedLevel == 15 || this.mc.selectedLevel == 20 || this.mc.selectedLevel == 25 || this.mc.selectedLevel == 30 || this.mc.selectedLevel == 35 ? (!MainCanvas.t1 && this.mc.selectedLevel == 0 ? 4 : (!MainCanvas.t2 && this.mc.selectedLevel == 5 ? 4 : (!MainCanvas.t3 && this.mc.selectedLevel == 10 ? 4 : (!MainCanvas.t4 && this.mc.selectedLevel == 15 ? 4 : (!MainCanvas.t5 && this.mc.selectedLevel == 20 ? 4 : (!MainCanvas.t6 && this.mc.selectedLevel == 25 ? 4 : (!MainCanvas.t7 && this.mc.selectedLevel == 30 ? 4 : (!MainCanvas.t8 && this.mc.selectedLevel == 35 ? 4 : 1)))))))) : 1;
        this.levelSucceed = false;
        this.levelEnded = false;
        this.allowChecking = false;
        this.allowNextLevel = false;
        importantItemsShooted = 0;
        importantItemsForLevel = GridController.getImportantItemsCount();
        projectilesFired = 0;
        this.stars = 0;
        PointerController.nextShotTriple = false;
        this.starResultCounter = 0;
        Particles.resetParticles();
        int powerBarBufferOffsetX = 0;
        int powerBarBufferOffsetY = 0;
        int powerBarBufferOffsetW = 0;
        if (MainCanvas.WIDTH_FROM_DC == 480 && MainCanvas.HEIGHT_FROM_DC < 400) {
            this.powerBarOffset = 5;
        } else if (MainCanvas.WIDTH == 480 || MainCanvas.WIDTH == 360) {
            this.powerBarOffset = 16;
            powerBarBufferOffsetX = 1;
            powerBarBufferOffsetY = -1;
            powerBarBufferOffsetW = -2;
            if (MainCanvas.WIDTH == 360) {
                powerBarBufferOffsetX = 1;
                powerBarBufferOffsetY = -1;
                powerBarBufferOffsetW = -3;
                this.powerBarOffset = 6;
            }
        } else {
            this.powerBarOffset = MainCanvas.WIDTH_FROM_DC == 320 && MainCanvas.HEIGHT_FROM_DC < 320 ? 4 : (MainCanvas.WIDTH == 240 || MainCanvas.WIDTH == 320 ? 5 : (MainCanvas.WIDTH == 176 ? 4 : (MainCanvas.WIDTH_FROM_DC == 220 && MainCanvas.HEIGHT_FROM_DC < 230 ? 4 : 4)));
        }
        this.upperHUDbg = Image.createImage((int)this.controlItems[0].width, (int)this.controlItems[0].height);
        Graphics g = this.upperHUDbg.getGraphics();
        g.setColor(0);
        g.fillRect(0, 0, this.upperHUDbg.getWidth(), this.upperHUDbg.getHeight());
        Rectangle tmpRect = new Rectangle(0, tmpOffset, this.controlItems[0].width, this.controlItems[0].height);
        Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], tmpRect);
        g = null;
        tmpRect = null;
        System.gc();
        this.upperHUDbgH = this.upperHUDbg.getHeight();
        this.bottomHUDbg = Image.createImage((int)(this.controlItems[15].width + powerBarBufferOffsetW), (int)this.controlItems[15].height);
        Graphics g2 = this.bottomHUDbg.getGraphics();
        g2.setColor(0);
        g2.fillRect(0, 0, this.bottomHUDbg.getWidth(), this.bottomHUDbg.getHeight());
        Rectangle tmpRect2 = new Rectangle(powerBarBufferOffsetX, powerBarBufferOffsetY, this.controlItems[15].width + 2 + powerBarBufferOffsetW, this.controlItems[15].height);
        Rendering2D.paintImageFromSkin3HV(g2, Resources.resSprs[12], tmpRect2);
        g2.drawImage(this.powerBarBg, this.bottomHUDbg.getWidth() - Resources.resImgsW[34] >> 1, this.bottomHUDbg.getHeight() - Resources.resImgsH[34] - this.powerBarOffset, 0);
        g2 = null;
        tmpRect2 = null;
        System.gc();
        this.bottomHUDbgH = this.bottomHUDbg.getHeight();
        this.firstPaint = true;
        if (MainCanvas.touchActivated) {
            this.rectBoard = new Rectangle(0, this.controlItems[0].getBottom(), MainCanvas.WIDTH, MainCanvas.HEIGHT - this.controlItems[0].height - this.controlItems[11].height + tmpOffset2);
        } else {
            this.rectBoard = new Rectangle(0, this.controlItems[0].getBottom(), MainCanvas.WIDTH, MainCanvas.HEIGHT - this.controlItems[0].height - this.powerBarBg.getHeight() - (tmpOffset2 >> 1) - tmpOffset2);
            this.rectBoard = new Rectangle(0, -10, MainCanvas.WIDTH, MainCanvas.HEIGHT - this.controlItems[0].height - this.powerBarBg.getHeight() / 4 + 10);
        }
        this.rectText = new Rectangle(this.controlItems[7].x + MainCanvas.mainUIOffset, this.controlItems[7].getBottom() - (this.mc.mainFont.getHeight() << 1) - MainCanvas.mainUIOffset, this.controlItems[7].width - (MainCanvas.mainUIOffset << 1), this.mc.mainFont.getHeight() << 1);
        this.pt = new PreparedText(this.mc.mainFont);
        this.pt.prepareText(Resources.resTexts[0].getHashedString(7), this.rectText.width);
        this.textTutorial = new PreparedText(this.mc.mainFont);
        this.textHelp = new PreparedText(this.mc.mainFont);
        this.resultText = new PreparedText(this.mc.mainFont);
        String controls = "";
        controls = Resources.resTexts[0].getHashedString(14);
        this.textHelp.prepareText(Resources.resTexts[0].getHashedString(2) + "\n\n" + controls, this.tutorialRect.width);
        this.firstPaint = true;
        repaintBottomHUD = true;
        repaintTopHUD = true;
        repaintBuffer = true;
        this.playGameMusic();
    }

    public void playGameMusic() {
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
            if (this.mc.selectedPack == 0) {
                MainCanvas.soundManager.Play(Sounds.SOUND_GAME_1, -1);
            } else if (this.mc.selectedPack == 1) {
                MainCanvas.soundManager.Play(Sounds.SOUND_GAME_2, -1);
            } else if (this.mc.selectedPack == 2) {
                MainCanvas.soundManager.Play(Sounds.SOUND_GAME_3, -1);
            }
        }
    }

    private final void loadDataForLevel(int _level) {
        block21: {
            block20: {
                this.gameEnd = false;
                this.firstPaint = true;
                repaintBottomHUD = true;
                repaintTopHUD = true;
                repaintBuffer = true;
                int bgIdx = -1;
                switch (this.mc.selectedPack) {
                    case 0: {
                        bgIdx = 2;
                        break;
                    }
                    case 1: {
                        bgIdx = 3;
                        break;
                    }
                    case 2: {
                        bgIdx = 4;
                    }
                }
                this.bg = null;
                Resources.freeImage(bgIdx);
                this.mc.selectedPack = _level / 20;
                this.playGameMusic();
                switch (this.mc.selectedPack) {
                    case 0: {
                        bgIdx = 2;
                        break;
                    }
                    case 1: {
                        bgIdx = 3;
                        break;
                    }
                    case 2: {
                        bgIdx = 4;
                    }
                }
                Resources.loadImage(bgIdx);
                this.bg = Resources.resImgs[bgIdx];
                PointerController.destroyAllProjectiles();
                try {
                    InputStream is = this.getClass().getResourceAsStream("/" + _level + ".b");
                    DataInputStream dis = new DataInputStream(is);
                    this.levelIndex = dis.readInt();
                    ScreenGame.tr("index: " + this.levelIndex);
                    int pointerX = dis.readInt();
                    int pointerY = dis.readInt();
                    int fpPX = CMathFP.toFP(pointerX);
                    int fpPY = CMathFP.toFP(pointerY);
                    int fp480 = CMathFP.toFP(480);
                    int fpWidth = 0;
                    fpWidth = MainCanvas.WIDTH_FROM_DC == 320 && MainCanvas.HEIGHT_FROM_DC < 320 ? CMathFP.toFP(176) : (MainCanvas.WIDTH_FROM_DC == 220 && MainCanvas.HEIGHT_FROM_DC < 230 ? CMathFP.toFP(128) : (MainCanvas.WIDTH_FROM_DC == 480 && MainCanvas.HEIGHT_FROM_DC < 400 ? CMathFP.toFP(240) : CMathFP.toFP(MainCanvas.WIDTH)));
                    int fpPointerRatio = CMathFP.div(fp480, fpWidth);
                    int fpPointerX = CMathFP.div(fpPX, fpPointerRatio);
                    int fpPointerY = CMathFP.div(fpPY, fpPointerRatio);
                    pointerX = CMathFP.toInt(fpPointerX);
                    pointerY = CMathFP.toInt(fpPointerY);
                    PointerController.setPosition(pointerX + GridController.xOffset, pointerY + GridController.yOffset);
                    this.oneStarSuccess = dis.readInt();
                    this.twoStarSuccess = dis.readInt();
                    this.threeStarSuccess = dis.readInt();
                    projectilesForLevel = dis.readInt();
                    int gridLen = GridController.grid.length;
                    for (int i = 0; i < gridLen; ++i) {
                        GridController.grid[i] = dis.readInt();
                        int y = i / GridController.getGridWidth();
                        int x = i - y * GridController.getGridWidth();
                        if (GridController.grid[i] != 0) {
                            Collisions.setCollision(x, y, true);
                            continue;
                        }
                        Collisions.setCollision(x, y, false);
                    }
                    dis.close();
                    is.close();
                }
                catch (Exception e) {
                    ScreenGame.tr("exception in loading level: " + e);
                }
                mode = this.mc.selectedLevel == 0 || this.mc.selectedLevel == 5 || this.mc.selectedLevel == 10 || this.mc.selectedLevel == 15 || this.mc.selectedLevel == 20 || this.mc.selectedLevel == 25 || this.mc.selectedLevel == 30 || this.mc.selectedLevel == 35 ? (!MainCanvas.t1 && this.mc.selectedLevel == 0 ? 4 : (!MainCanvas.t2 && this.mc.selectedLevel == 5 ? 4 : (!MainCanvas.t3 && this.mc.selectedLevel == 10 ? 4 : (!MainCanvas.t4 && this.mc.selectedLevel == 15 ? 4 : (!MainCanvas.t5 && this.mc.selectedLevel == 20 ? 4 : (!MainCanvas.t6 && this.mc.selectedLevel == 25 ? 4 : (!MainCanvas.t7 && this.mc.selectedLevel == 30 ? 4 : (!MainCanvas.t8 && this.mc.selectedLevel == 35 ? 4 : 1)))))))) : 1;
                if (MainCanvas.beforeAfter == 4) break block20;
                if (MainCanvas.beforeAfter != 5) break block21;
            }
            mode = MainCanvas.beforeAfter;
        }
        this.levelSucceed = false;
        this.levelEnded = false;
        this.allowChecking = false;
        this.allowNextLevel = false;
        importantItemsShooted = 0;
        projectilesFired = 0;
        this.stars = 0;
        PointerController.nextShotTriple = false;
        this.starResultCounter = 0;
        smokeFrames = new int[this.gridW * this.gridH];
        smokeBombFrames = new int[this.gridW * this.gridH];
        crackedStoneFrameCounter = new int[this.gridW * this.gridH];
        crackedWoodFrameCounter = new int[this.gridW * this.gridH];
        for (int y = 0; y < this.gridH; ++y) {
            for (int x = 0; x < this.gridW; ++x) {
                int idx = y * this.gridW + x;
                ScreenGame.smokeFrames[idx] = -1;
                ScreenGame.smokeBombFrames[idx] = -1;
                ScreenGame.crackedStoneFrameCounter[idx] = -1;
                ScreenGame.crackedWoodFrameCounter[idx] = -1;
            }
        }
        this.powerBarState = 0;
        this.powerBarHidden = true;
        if (!MainCanvas.touchActivated) {
            this.revealPowerBar();
        }
        numberOfShotsCharArr = (projectilesForLevel + "/" + projectilesForLevel).toCharArray();
        importantItemsForLevel = GridController.getImportantItemsCount();
    }

    public void afterHide() {
        this.acorn = null;
        this.bomb = null;
        this.wood = null;
        this.freeze = null;
        this.fruit_1 = null;
        this.fruit_2 = null;
        this.honey = null;
        this.ice = null;
        this.marshmallow = null;
        this.rock = null;
        this.triple_shot = null;
        this.bg = null;
        this.worm = null;
        this.resultBarEmpty = null;
        this.resultBarFull = null;
        stone_particles = null;
        wood_particles = null;
        this.powerBar = null;
        this.powerBarBg = null;
        for (int i = 0; i < this.controlItems.length; ++i) {
            this.controlItems[i] = null;
        }
        this.controlItems = null;
        int bgIdx = -1;
        switch (this.mc.selectedPack) {
            case 0: {
                bgIdx = 2;
                break;
            }
            case 1: {
                bgIdx = 3;
                break;
            }
            case 2: {
                bgIdx = 4;
            }
        }
        Resources.freeImages(new int[]{bgIdx, 42, 7, 8, 27, 39, 28, 32, 34, 35, 33, 15, 36, 16, 26, 25, 29, 38});
        Resources.freeSprites(new int[]{23, 15, 16, 19, 4, 5, 22, 0, 1, 2, 3, 6, 7, 8, 9, 10, 13, 17, 18});
    }

    public static void pauseGame() {
        if (mode != 3 && mode != 4 && mode != 5) {
            mode = 2;
            holdingItemIndex = 2;
            if (!MainCanvas.touchActivated) {
                // empty if block
            }
        }
    }

    public void update(long lastRunLenght) {
        if (mode == 1) {
            if (Keys.isActionPressed(3)) {
                PointerController.moveToLeft();
            }
            if (Keys.isActionPressed(4)) {
                PointerController.moveToRight();
            }
            if (this.holdingPointerLeftArrow) {
                ScreenGame.tr("holding left arrow");
                repaintBottomHUD = true;
                PointerController.moveToLeft();
            } else if (this.holdingPointerRightArrow) {
                repaintBottomHUD = true;
                PointerController.moveToRight();
            }
            if (this.holdingFireButton) {
                repaintBottomHUD = true;
                PointerController.raiseStrengthCounter();
            }
            PointerController.update();
            if (projectilesForLevel - projectilesFired == 0 && PointerController.projCount == 0) {
                this.levelEnded = true;
                ScreenGame.tr("level ENDED");
                if (importantItemsShooted >= this.oneStarSuccess) {
                    this.levelSucceed = true;
                    this.allowChecking = true;
                    ScreenGame.tr("level SUCCEED");
                }
                if (importantItemsShooted < this.oneStarSuccess) {
                    this.pt.prepareText(this.oneStarSuccess - importantItemsShooted + " " + Resources.resTexts[0].getHashedString(8), this.rectText.width);
                    this.stars = 0;
                }
                if (importantItemsShooted >= this.oneStarSuccess && importantItemsShooted < this.twoStarSuccess) {
                    this.pt.prepareText(this.twoStarSuccess - importantItemsShooted + " " + Resources.resTexts[0].getHashedString(9), this.rectText.width);
                    this.stars = 1;
                }
                if (importantItemsShooted >= this.twoStarSuccess && importantItemsShooted < this.threeStarSuccess) {
                    this.pt.prepareText(this.threeStarSuccess - importantItemsShooted + " " + Resources.resTexts[0].getHashedString(10), this.rectText.width);
                    this.stars = 2;
                }
                if (importantItemsShooted >= this.threeStarSuccess) {
                    this.pt.prepareText(Resources.resTexts[0].getHashedString(11), this.rectText.width);
                    this.stars = 3;
                }
                mode = 3;
                if (!MainCanvas.touchActivated) {
                    holdingItemIndex = 10;
                    if (this.mc.selectedLevel != 59) {
                        if (!this.levelSucceed || this.mc.getAllEarnedStars() < MainCanvas.getStarsNeededForLevel(this.mc.selectedLevel + 1)) {
                            holdingItemIndex = 9;
                        }
                    } else {
                        this.gameEnd = true;
                        holdingItemIndex = 8;
                        if (MainCanvas.soundManager.IsSoundOn()) {
                            MainCanvas.soundManager.Stop();
                            MainCanvas.soundManager.Play(Sounds.SOUND_WIN, 1);
                        }
                    }
                } else if (this.mc.selectedLevel == 59) {
                    this.gameEnd = true;
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.Stop();
                        MainCanvas.soundManager.Play(Sounds.SOUND_WIN, 1);
                    }
                }
            }
        } else if (mode == 2) {
            // empty if block
        }
        if (mode == 3 && this.levelSucceed && this.allowChecking) {
            this.allowChecking = false;
            if (importantItemsShooted >= this.oneStarSuccess && this.mc.starsForLevel[this.mc.selectedLevel] <= 1) {
                this.mc.starsForLevel[this.mc.selectedLevel] = 1;
            }
            if (importantItemsShooted >= this.twoStarSuccess && this.mc.starsForLevel[this.mc.selectedLevel] < 2) {
                this.mc.starsForLevel[this.mc.selectedLevel] = 2;
            }
            if (importantItemsShooted >= this.threeStarSuccess && this.mc.starsForLevel[this.mc.selectedLevel] < 3) {
                this.mc.starsForLevel[this.mc.selectedLevel] = 3;
            }
            if (!this.gameEnd && this.mc.getAllEarnedStars() >= MainCanvas.getStarsNeededForLevel(this.mc.selectedLevel + 1)) {
                this.allowNextLevel = true;
            }
            MainCanvas.mainRms.save();
        }
        this.repaint();
    }

    public void repaint() {
        this.mc.paint();
    }

    public void setLevelData(int _index, int _oneStarSuccess, int _twoStarSuccess, int _threeStarSuccess, int _pointerX, int _pointerY, int _numberOfShots, int[] _levelData) {
        this.stars = 0;
        this.levelIndex = _index;
        this.oneStarSuccess = _oneStarSuccess;
        this.twoStarSuccess = _twoStarSuccess;
        this.threeStarSuccess = _threeStarSuccess;
        this.levelPointerX = _pointerX;
        this.levelPointerY = _pointerY;
        projectilesForLevel = _numberOfShots;
        for (int i = 0; i < _levelData.length; ++i) {
            GridController.setGridItemOn(i, _levelData[i]);
        }
        this.powerBarState = 0;
        this.powerBarHidden = true;
    }

    /*
     * Unable to fully structure code
     */
    public void paint(Graphics g) {
        ScreenGame.repaintTopHUD = true;
        if (this.bombSpriteCounter > this.bombSpriteSpeed) {
            this.bombSpriteCounter = 0;
        }
        ++this.bombSpriteCounter;
        this.paintGridItemsWithHUDs(g);
        g.setClip(this.rectBoard.x, this.rectBoard.y, this.rectBoard.width, this.rectBoard.height);
        for (i = 0; i < 50; ++i) {
            if (PointerController.projectiles[i] == null) continue;
            if (PointerController.projectiles[i].getType() == 0) {
                this.worm.setFrame(PointerController.projectiles[i].frame);
                this.worm.setPosition(PointerController.projectiles[i].getPositionX() - this.wormW2, PointerController.projectiles[i].getPositionY() - this.wormH2);
                this.worm.paint(g);
                continue;
            }
            if (PointerController.projectiles[i].getType() != 3) continue;
            this.acorn.setFrame(2);
            this.acorn.setPosition(PointerController.projectiles[i].getPositionX() - this.acornW2, PointerController.projectiles[i].getPositionY() - this.acornH2);
            this.acorn.paint(g);
        }
        if (this.mc.selectedPack != 2) {
            // empty if block
        }
        PointerController.paint(g);
        if (MainCanvas.touchActivated) {
            if (ScreenGame.repaintBottomHUD) {
                g.setClip(this.touchControlBottomHudRect.x, this.touchControlBottomHudRect.y, this.touchControlBottomHudRect.width, this.touchControlBottomHudRect.height);
            }
        } else if (ScreenGame.repaintBottomHUD) {
            g.setClip(this.controlItems[15].x, this.controlItems[15].y, this.controlItems[15].width, this.controlItems[15].height);
            g.drawImage(this.bottomHUDbg, this.controlItems[15].x, this.controlItems[15].y, 0);
            if (ScreenGame.mode != 4) {
                g.drawImage(Resources.resImgs[36], this.controlItems[1].getCenterX() - (Resources.resImgsW[36] >> 1), this.controlItems[15].y + (this.bottomHUDbgH >> 1) - (Resources.resImgsH[36] >> 1), 0);
            }
        }
        if (ScreenGame.repaintBottomHUD) {
            if (MainCanvas.touchActivated) {
                if (this.holdingFireButton) {
                    Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[14], this.controlItems[14]);
                } else {
                    Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], this.controlItems[14]);
                }
                g.drawImage(Resources.resImgs[38], this.controlItems[14].getCenterX() - (Resources.resImgsW[38] >> 1), this.controlItems[14].getCenterY() - (Resources.resImgsH[38] >> 1), 0);
                if (this.holdingPointerLeftArrow) {
                    Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[14], this.controlItems[12]);
                } else {
                    Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], this.controlItems[12]);
                }
                if (this.holdingPointerRightArrow) {
                    Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[14], this.controlItems[13]);
                } else {
                    Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], this.controlItems[13]);
                }
                Resources.resSprs[22].setFrame(0);
                Resources.resSprs[22].setPosition(this.controlItems[12].getCenterX() - (Resources.resSprsW[22] >> 1), this.controlItems[12].getCenterY() - (Resources.resSprsH[22] >> 1));
                Resources.resSprs[22].paint(g);
                Resources.resSprs[22].setFrame(1);
                Resources.resSprs[22].setPosition(this.controlItems[13].getCenterX() - (Resources.resSprsW[22] >> 1), this.controlItems[13].getCenterY() - (Resources.resSprsH[22] >> 1));
                Resources.resSprs[22].paint(g);
            }
            ScreenGame.repaintBottomHUD = false;
        }
        this.paintPowerBar(g);
        switch (ScreenGame.mode) {
            case 1: {
                break;
            }
            case 2: {
                block21: for (i = 2; i < 7; ++i) {
                    if (i == ScreenGame.holdingItemIndex) {
                        Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[14], this.controlItems[i]);
                    } else {
                        Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], this.controlItems[i]);
                    }
                    switch (i) {
                        case 2: {
                            g.drawImage(Resources.resImgs[15], this.controlItems[2].getCenterX() - (Resources.resImgsW[15] >> 1), this.controlItems[2].getCenterY() - (Resources.resImgsH[15] >> 1), 0);
                            continue block21;
                        }
                        case 3: {
                            g.drawImage(Resources.resImgs[16], this.controlItems[3].getCenterX() - (Resources.resImgsW[16] >> 1), this.controlItems[3].getCenterY() - (Resources.resImgsH[16] >> 1), 0);
                            continue block21;
                        }
                        case 4: {
                            if (MainCanvas.soundManager.IsSoundOn()) {
                                Resources.resSprs[13].setFrame(0);
                            } else {
                                Resources.resSprs[13].setFrame(1);
                            }
                            Resources.resSprs[13].setPosition(this.controlItems[4].getCenterX() - (Resources.resSprsW[13] >> 1), this.controlItems[4].getCenterY() - (Resources.resSprsH[13] >> 1));
                            Resources.resSprs[13].paint(g);
                            continue block21;
                        }
                        case 5: {
                            g.drawImage(Resources.resImgs[7], this.controlItems[5].getCenterX() - (Resources.resImgsW[7] >> 1), this.controlItems[5].getCenterY() - (Resources.resImgsH[7] >> 1), 0);
                            continue block21;
                        }
                        case 6: {
                            g.drawImage(Resources.resImgs[36], this.controlItems[6].getCenterX() - (Resources.resImgsW[36] >> 1), this.controlItems[6].getCenterY() - (Resources.resImgsH[36] >> 1), 0);
                        }
                    }
                }
                g.setClip(this.controlItems[15].x, this.controlItems[15].y, this.controlItems[15].width, this.controlItems[15].height);
                g.drawImage(this.bottomHUDbg, this.controlItems[15].x, this.controlItems[15].y, 0);
                break;
            }
            case 6: {
                this.paintHelp(g);
                break;
            }
            case 3: {
                st = 0;
                Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], this.controlItems[7]);
                if (this.allowNextLevel) {
                    if (ScreenGame.holdingItemIndex == 10) {
                        Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[14], this.controlItems[10]);
                    } else {
                        Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], this.controlItems[10]);
                    }
                }
                if (ScreenGame.holdingItemIndex == 9) {
                    Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[14], this.controlItems[9]);
                } else {
                    Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], this.controlItems[9]);
                }
                if (ScreenGame.holdingItemIndex == 8) {
                    Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[14], this.controlItems[8]);
                } else {
                    Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], this.controlItems[8]);
                }
                if (this.levelSucceed) {
                    if (!this.gameEnd) {
                        if (this.allowNextLevel) {
                            g.drawImage(Resources.resImgs[15], this.controlItems[10].getCenterX() - (Resources.resImgsW[15] >> 1), this.controlItems[10].getCenterY() - (Resources.resImgsH[15] >> 1), 20);
                        }
                        g.drawImage(Resources.resImgs[28], this.controlItems[7].getCenterX() - (Resources.resImgsW[28] >> 1), this.resultTextsCenterY - Resources.resImgsH[29] - Resources.resImgsH[28] - MainCanvas.mainUIOffset * 2, 0);
                    } else {
                        g.drawImage(Resources.resImgs[39], this.controlItems[7].getCenterX() - (Resources.resImgsW[39] >> 1), this.controlItems[7].y + (MainCanvas.mainUIOffset << 1), 0);
                        for (i = 0; i < this.mc.starsForLevel.length; ++i) {
                            st += this.mc.starsForLevel[i];
                        }
                        if (this.mc.selectedLevel != 59) {
                            this.mc.mainFont.drawString(g, this.winTextCharArr, this.controlItems[7].getCenterX() - (this.mc.mainFont.stringWidth(this.winTextCharArr) >> 1), this.controlItems[7].y + (MainCanvas.mainUIOffset << 2) + Resources.resImgsH[39], 20);
                        }
                    }
                } else {
                    g.drawImage(Resources.resImgs[27], this.controlItems[7].getCenterX() - (Resources.resImgsW[27] >> 1), this.resultTextsCenterY - Resources.resImgsH[29] - Resources.resImgsH[28] - MainCanvas.mainUIOffset * 2, 0);
                }
                g.drawImage(Resources.resImgs[16], this.controlItems[9].getCenterX() - (Resources.resImgsW[16] >> 1), this.controlItems[9].getCenterY() - (Resources.resImgsH[16] >> 1), 20);
                g.drawImage(Resources.resImgs[36], this.controlItems[8].getCenterX() - (Resources.resImgsW[36] >> 1), this.controlItems[8].getCenterY() - (Resources.resImgsH[36] >> 1), 20);
                if (this.starResultCounter < 50) {
                    ++this.starResultCounter;
                }
                switch (this.stars) {
                    case 0: {
                        g.drawImage(Resources.resImgs[29], this.controlItems[7].getCenterX() - (Resources.resImgsW[29] >> 1) - (Resources.resImgsW[29] + MainCanvas.mainUIOffset), this.resultTextsCenterY - Resources.resImgsH[29], 20);
                        g.drawImage(Resources.resImgs[29], this.controlItems[7].getCenterX() - (Resources.resImgsW[29] >> 1), this.resultTextsCenterY - Resources.resImgsH[29], 20);
                        g.drawImage(Resources.resImgs[29], this.controlItems[7].getCenterX() + (Resources.resImgsW[29] >> 1) + MainCanvas.mainUIOffset, this.resultTextsCenterY - Resources.resImgsH[29], 20);
                        break;
                    }
                    case 1: {
                        if (this.starResultCounter == 10) {
                            this.createResultStarParticles(this.controlItems[7].getCenterX() - (Resources.resImgsW[29] + MainCanvas.mainUIOffset), this.resultTextsCenterY - (Resources.resImgsH[29] >> 1));
                        }
                        if (this.starResultCounter < 10) {
                            g.drawImage(Resources.resImgs[29], this.controlItems[7].getCenterX() - (Resources.resImgsW[29] >> 1) - (Resources.resImgsW[29] + MainCanvas.mainUIOffset), this.resultTextsCenterY - Resources.resImgsH[29], 20);
                        } else {
                            g.drawImage(Resources.resImgs[25], this.controlItems[7].getCenterX() - (Resources.resImgsW[25] >> 1) - (Resources.resImgsW[25] + MainCanvas.mainUIOffset), this.resultTextsCenterY - Resources.resImgsH[25], 20);
                        }
                        g.drawImage(Resources.resImgs[29], this.controlItems[7].getCenterX() - (Resources.resImgsW[29] >> 1), this.resultTextsCenterY - Resources.resImgsH[29], 20);
                        g.drawImage(Resources.resImgs[29], this.controlItems[7].getCenterX() + (Resources.resImgsW[29] >> 1) + MainCanvas.mainUIOffset, this.resultTextsCenterY - Resources.resImgsH[29], 20);
                        break;
                    }
                    case 2: {
                        if (this.starResultCounter == 10) {
                            this.createResultStarParticles(this.controlItems[7].getCenterX() - (Resources.resImgsW[29] + MainCanvas.mainUIOffset), this.resultTextsCenterY - (Resources.resImgsH[29] >> 1));
                        }
                        if (this.starResultCounter == 20) {
                            this.createResultStarParticles(this.controlItems[7].getCenterX(), this.resultTextsCenterY - (Resources.resImgsH[29] >> 1));
                        }
                        if (this.starResultCounter < 10) {
                            g.drawImage(Resources.resImgs[29], this.controlItems[7].getCenterX() - (Resources.resImgsW[29] >> 1) - (Resources.resImgsW[29] + MainCanvas.mainUIOffset), this.resultTextsCenterY - Resources.resImgsH[29], 20);
                        } else {
                            g.drawImage(Resources.resImgs[25], this.controlItems[7].getCenterX() - (Resources.resImgsW[25] >> 1) - (Resources.resImgsW[25] + MainCanvas.mainUIOffset), this.resultTextsCenterY - Resources.resImgsH[25], 20);
                        }
                        if (this.starResultCounter < 20) {
                            g.drawImage(Resources.resImgs[29], this.controlItems[7].getCenterX() - (Resources.resImgsW[29] >> 1), this.resultTextsCenterY - Resources.resImgsH[29], 20);
                        } else {
                            g.drawImage(Resources.resImgs[25], this.controlItems[7].getCenterX() - (Resources.resImgsW[25] >> 1), this.resultTextsCenterY - Resources.resImgsH[25], 20);
                        }
                        g.drawImage(Resources.resImgs[29], this.controlItems[7].getCenterX() + (Resources.resImgsW[29] >> 1) + MainCanvas.mainUIOffset, this.resultTextsCenterY - Resources.resImgsH[29], 20);
                        break;
                    }
                    case 3: {
                        if (this.mc.selectedLevel != 59 || st != 180) ** GOTO lbl160
                        this.resultText.prepareText(Resources.resTexts[0].getHashedString(28), this.controlItems[7].width);
                        this.resultText.drawText(g, this.controlItems[7], 0, 3);
                        ** GOTO lbl183
lbl160:
                        // 1 sources

                        if (this.mc.selectedLevel == 59 && st != 180) {
                            this.resultText.prepareText(Resources.resTexts[0].getHashedString(29), this.controlItems[7].width);
                            this.resultText.drawText(g, this.controlItems[7], 0, 3);
                        } else {
                            if (this.starResultCounter == 10) {
                                this.createResultStarParticles(this.controlItems[7].getCenterX() - (Resources.resImgsW[29] + MainCanvas.mainUIOffset), this.resultTextsCenterY - (Resources.resImgsH[29] >> 1));
                            }
                            if (this.starResultCounter == 20) {
                                this.createResultStarParticles(this.controlItems[7].getCenterX(), this.resultTextsCenterY - (Resources.resImgsH[29] >> 1));
                            }
                            if (this.starResultCounter == 30) {
                                this.createResultStarParticles(this.controlItems[7].getCenterX() + (Resources.resImgsW[29] + MainCanvas.mainUIOffset), this.resultTextsCenterY - (Resources.resImgsH[29] >> 1));
                            }
                            if (this.starResultCounter < 10) {
                                g.drawImage(Resources.resImgs[29], this.controlItems[7].getCenterX() - (Resources.resImgsW[29] >> 1) - (Resources.resImgsW[29] + MainCanvas.mainUIOffset), this.resultTextsCenterY - Resources.resImgsH[29], 20);
                            } else {
                                g.drawImage(Resources.resImgs[25], this.controlItems[7].getCenterX() - (Resources.resImgsW[25] >> 1) - (Resources.resImgsW[25] + MainCanvas.mainUIOffset), this.resultTextsCenterY - Resources.resImgsH[25], 20);
                            }
                            if (this.starResultCounter < 20) {
                                g.drawImage(Resources.resImgs[29], this.controlItems[7].getCenterX() - (Resources.resImgsW[29] >> 1), this.resultTextsCenterY - Resources.resImgsH[29], 20);
                            } else {
                                g.drawImage(Resources.resImgs[25], this.controlItems[7].getCenterX() - (Resources.resImgsW[25] >> 1), this.resultTextsCenterY - Resources.resImgsH[25], 20);
                            }
                            if (this.starResultCounter < 30) {
                                g.drawImage(Resources.resImgs[29], this.controlItems[7].getCenterX() + (Resources.resImgsW[29] >> 1) + MainCanvas.mainUIOffset, this.resultTextsCenterY - Resources.resImgsH[29], 20);
                                break;
                            }
                            g.drawImage(Resources.resImgs[25], this.controlItems[7].getCenterX() + (Resources.resImgsW[25] >> 1) + MainCanvas.mainUIOffset, this.resultTextsCenterY - Resources.resImgsH[25], 20);
                            break;
                        }
                    }
lbl183:
                    // 3 sources

                    case 4: {
                        this.paintTutorial(g, this.mc.selectedLevel);
                    }
                }
                if (!this.gameEnd && this.stars != 3) {
                    this.pt.drawText(g, this.rectText, 0, 17);
                }
                g.setClip(this.controlItems[15].x, this.controlItems[15].y, this.controlItems[15].width, this.controlItems[15].height);
                g.drawImage(this.bottomHUDbg, this.controlItems[15].x, this.controlItems[15].y, 0);
            }
        }
        g.setClip(this.rectBoard.x, this.rectBoard.y, this.rectBoard.width, this.rectBoard.height);
        Particles.paintParticles(g, false);
        this.paintTutorial(g, this.mc.selectedLevel);
    }

    /*
     * Unable to fully structure code
     */
    private void paintTutorial(Graphics g, int level) {
        block14: {
            block13: {
                firstRect = this.tutorialRect;
                tutRect2 = new Rectangle(this.mc.getWidth() / 2 - this.tutorialRect.width / 4, this.mc.getHeight() / 2 - this.tutorialRect.width / 4, this.tutorialRect.width / 2, this.tutorialRect.height / 2 + 2 * this.mc.mainFont.getHeight());
                if (ScreenGame.mode != 4) break block13;
                g.drawImage(this.bg, 0, 0, 0);
                switch (level) {
                    case 0: {
                        ballons = Resources.resImgs[42];
                        r = new Rectangle(this.tutorialRect.x, this.tutorialRect.y + 2 * ballons.getHeight(), this.tutorialRect.width, this.tutorialRect.height - ballons.getHeight());
                        h = this.tutorialRect.height;
                        this.tutorialRect.height += this.mc.mainFont.getHeight();
                        this.textTutorial.prepareText(Resources.resTexts[0].getHashedString(17), tutRect2.width);
                        Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], this.tutorialRect);
                        if (MainCanvas.WIDTH <= 240 && MainCanvas.HEIGHT <= 300 || MainCanvas.WIDTH == 320 && MainCanvas.HEIGHT == 240) ** GOTO lbl19
                        g.setColor(16374279);
                        g.fillRect(this.tutorialRect.width / 2 - ballons.getWidth() / 2 - 1, this.tutorialRect.y + ballons.getHeight() - ballons.getHeight() / 2 - 1, ballons.getWidth() + 2, ballons.getHeight() + 2);
                        g.drawImage(ballons, this.tutorialRect.width / 2 - ballons.getWidth() / 2, this.tutorialRect.y + ballons.getHeight(), 6);
                        this.textTutorial.drawText(g, r, 0, 17);
                        ** GOTO lbl32
lbl19:
                        // 1 sources

                        if (MainCanvas.WIDTH != 128) ** GOTO lbl-1000
                        if (MainCanvas.HEIGHT == 160) {
                            this.tutorialRect.height = MainCanvas.HEIGHT;
                            tutRect2.width = this.tutorialRect.width = MainCanvas.WIDTH;
                            this.textTutorial.prepareText(Resources.resTexts[0].getHashedString(17), tutRect2.width);
                            Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], this.tutorialRect);
                            this.textTutorial.drawText(g, this.tutorialRect, 0, 20);
                            tutRect2.width = this.tutorialRect.width / 2;
                        } else lbl-1000:
                        // 2 sources

                        {
                            this.textTutorial.drawText(g, this.tutorialRect, 0, 1);
                        }
lbl32:
                        // 3 sources

                        this.tutorialRect.height = h;
                        MainCanvas.t1 = true;
                        break;
                    }
                    case 5: {
                        tutRect = MainCanvas.WIDTH < 240 && MainCanvas.HEIGHT < 300 || MainCanvas.WIDTH == 320 && MainCanvas.HEIGHT == 240 ? this.tutorialRect : tutRect2;
                        this.textTutorial.prepareText(Resources.resTexts[0].getHashedString(20), tutRect.width);
                        Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], tutRect);
                        this.textTutorial.drawText(g, tutRect, 0, 3);
                        object = Resources.resSprs[2];
                        g.setColor(16374279);
                        g.fillRect(tutRect.x + tutRect.width / 2 - object.getWidth() / 2 - 1, tutRect.y + object.getHeight() - 1, object.getWidth() + 2, object.getHeight() + 2);
                        object.setFrame(0);
                        object.setPosition(tutRect.x + tutRect.width / 2 - object.getWidth() / 2, tutRect.y + object.getHeight());
                        object.paint(g);
                        MainCanvas.t2 = true;
                        break;
                    }
                    case 10: {
                        tutRect = MainCanvas.WIDTH < 240 && MainCanvas.HEIGHT < 300 || MainCanvas.WIDTH == 320 && MainCanvas.HEIGHT == 240 ? this.tutorialRect : tutRect2;
                        this.textTutorial.prepareText(Resources.resTexts[0].getHashedString(21), tutRect.width);
                        Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], tutRect);
                        this.textTutorial.drawText(g, tutRect, 0, 3);
                        object = Resources.resSprs[9];
                        g.setColor(16374279);
                        g.fillRect(tutRect.x + tutRect.width / 2 - object.getWidth() / 2 - 1, tutRect.y + object.getHeight() - 1, object.getWidth() + 2, object.getHeight() + 2);
                        object.setFrame(0);
                        object.setPosition(tutRect.x + tutRect.width / 2 - object.getWidth() / 2, tutRect.y + object.getHeight());
                        object.paint(g);
                        MainCanvas.t3 = true;
                        break;
                    }
                    case 15: {
                        tutRect = MainCanvas.WIDTH < 240 && MainCanvas.HEIGHT < 300 || MainCanvas.WIDTH == 320 && MainCanvas.HEIGHT == 240 ? this.tutorialRect : tutRect2;
                        this.textTutorial.prepareText(Resources.resTexts[0].getHashedString(22), tutRect.width);
                        Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], tutRect);
                        this.textTutorial.drawText(g, tutRect, 0, 3);
                        object = Resources.resSprs[1];
                        g.setColor(16374279);
                        g.fillRect(tutRect.x + tutRect.width / 2 - object.getWidth() / 2 - 1, tutRect.y + object.getHeight() - 1, object.getWidth() + 2, object.getHeight() + 2);
                        object.setFrame(0);
                        object.setPosition(tutRect.x + tutRect.width / 2 - object.getWidth() / 2, tutRect.y + object.getHeight());
                        object.paint(g);
                        MainCanvas.t4 = true;
                        break;
                    }
                    case 20: {
                        tutRect = MainCanvas.WIDTH < 240 && MainCanvas.HEIGHT < 300 || MainCanvas.WIDTH == 320 && MainCanvas.HEIGHT == 240 ? this.tutorialRect : tutRect2;
                        this.textTutorial.prepareText(Resources.resTexts[0].getHashedString(23), tutRect.width);
                        Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], tutRect);
                        this.textTutorial.drawText(g, tutRect, 0, 3);
                        object = Resources.resSprs[0];
                        g.setColor(16374279);
                        g.fillRect(tutRect.x + tutRect.width / 2 - object.getWidth() / 2 - 1, tutRect.y + object.getHeight() - 1, object.getWidth() + 2, object.getHeight() + 2);
                        object.setFrame(0);
                        object.setPosition(tutRect.x + tutRect.width / 2 - object.getWidth() / 2, tutRect.y + object.getHeight());
                        object.paint(g);
                        MainCanvas.t5 = true;
                        break;
                    }
                    case 25: {
                        tutRect = MainCanvas.WIDTH < 240 && MainCanvas.HEIGHT < 300 || MainCanvas.WIDTH == 320 && MainCanvas.HEIGHT == 240 ? this.tutorialRect : tutRect2;
                        this.textTutorial.prepareText(Resources.resTexts[0].getHashedString(24), tutRect.width);
                        Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], tutRect);
                        this.textTutorial.drawText(g, tutRect, 0, 3);
                        object = Resources.resSprs[10];
                        g.setColor(16374279);
                        g.fillRect(tutRect.x + tutRect.width / 2 - object.getWidth() / 2 - 1, tutRect.y + object.getHeight() / 2 + 1, object.getWidth() + 2, object.getHeight() - 1);
                        object.setFrame(0);
                        object.setPosition(tutRect.x + tutRect.width / 2 - object.getWidth() / 2, tutRect.y + object.getHeight() / 2);
                        object.paint(g);
                        MainCanvas.t6 = true;
                        break;
                    }
                    case 30: {
                        tutRect = MainCanvas.WIDTH < 240 && MainCanvas.HEIGHT < 300 || MainCanvas.WIDTH == 320 && MainCanvas.HEIGHT == 240 ? this.tutorialRect : tutRect2;
                        this.textTutorial.prepareText(Resources.resTexts[0].getHashedString(25), tutRect.width);
                        Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], tutRect);
                        this.textTutorial.drawText(g, tutRect, 0, 3);
                        object = Resources.resSprs[6];
                        g.setColor(16374279);
                        g.fillRect(tutRect.x + tutRect.width / 2 - object.getWidth() / 2 - 1, tutRect.y + object.getHeight() - 1, object.getWidth() + 2, object.getHeight() + 2);
                        object.setFrame(0);
                        object.setPosition(tutRect.x + tutRect.width / 2 - object.getWidth() / 2, tutRect.y + object.getHeight());
                        object.paint(g);
                        MainCanvas.t7 = true;
                        break;
                    }
                    case 35: {
                        tutRect = MainCanvas.WIDTH < 240 && MainCanvas.HEIGHT < 300 || MainCanvas.WIDTH == 320 && MainCanvas.HEIGHT == 240 ? this.tutorialRect : tutRect2;
                        this.textTutorial.prepareText(Resources.resTexts[0].getHashedString(26), tutRect.width);
                        Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], tutRect);
                        this.textTutorial.drawText(g, tutRect, 0, 3);
                        object = Resources.resSprs[3];
                        g.setColor(16374279);
                        g.fillRect(tutRect.x + tutRect.width / 2 - object.getWidth() / 2 - 1, tutRect.y + object.getHeight() - 1, object.getWidth() + 2, object.getHeight() + 2);
                        object.setFrame(0);
                        object.setPosition(tutRect.x + tutRect.width / 2 - object.getWidth() / 2, tutRect.y + object.getHeight());
                        object.paint(g);
                        MainCanvas.t8 = true;
                    }
                }
                break block14;
            }
            if (ScreenGame.mode == 5) {
                tutRect = MainCanvas.WIDTH < 240 && MainCanvas.HEIGHT < 300 || MainCanvas.WIDTH == 320 && MainCanvas.HEIGHT == 240 ? this.tutorialRect : tutRect2;
                this.textTutorial.prepareText(Resources.resTexts[0].getHashedString(19), tutRect.width);
                Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], tutRect);
                this.textTutorial.drawText(g, tutRect, 0, 3);
                object = Resources.resSprs[8];
                g.setColor(16374279);
                g.fillRect(tutRect.x + tutRect.width / 2 - object.getWidth() / 2 - 1, tutRect.y + object.getHeight() - 1, object.getWidth() + 2, object.getHeight() + 2);
                object.setFrame(0);
                object.setPosition(tutRect.x + tutRect.width / 2 - object.getWidth() / 2, tutRect.y + object.getHeight());
                object.paint(g);
            }
        }
    }

    private void paintHelp(Graphics g) {
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        g.setColor(0);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        g.drawImage(this.bg, 0, 0, 0);
        Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], this.tutorialRect);
        int a = this.tutorialRect.height;
        int y = this.tutorialRect.y;
        int x = this.tutorialRect.x;
        this.tutorialRect.height = a - 4;
        this.tutorialRect.y = y + 2;
        this.tutorialRect.x = x + 2;
        this.textHelp.drawText(g, this.tutorialRect, this.ptYOffset, 20);
        if (this.tutorialRect.height >= this.textHelp.getTextHeight()) {
            arrowUP = false;
            arrowDOWN = false;
        }
        for (int i = 0; i < this.rectItems.length; ++i) {
            if (holdingItemIndex == i) {
                if (i == 1 && !arrowUP || i == 2 && !arrowDOWN) continue;
                Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[14], this.rectItems[i]);
                continue;
            }
            if (i == 1 && !arrowUP || i == 2 && !arrowDOWN) continue;
            Rendering2D.paintImageFromSkin3HV(g, Resources.resSprs[12], this.rectItems[i]);
        }
        g.drawImage(Resources.resImgs[8], this.rectItems[0].getCenterX() - (Resources.resImgsW[8] >> 1), this.rectItems[0].getCenterY() - (Resources.resImgsH[8] >> 1), 20);
        if (arrowUP) {
            Resources.resSprs[23].setPosition(this.rectItems[1].getCenterX() - (Resources.resSprsW[23] >> 1), this.rectItems[1].getCenterY() - (Resources.resSprsH[23] >> 1));
            Resources.resSprs[23].setFrame(0);
            Resources.resSprs[23].paint(g);
        }
        if (arrowDOWN) {
            Resources.resSprs[23].setPosition(this.rectItems[2].getCenterX() - (Resources.resSprsW[23] >> 1), this.rectItems[2].getCenterY() - (Resources.resSprsH[23] >> 1));
            Resources.resSprs[23].setFrame(1);
            Resources.resSprs[23].paint(g);
        }
        this.tutorialRect.height = a;
        this.tutorialRect.y = y;
        this.tutorialRect.x = x;
    }

    private final void paintGridItemsWithHUDs(Graphics g) {
        if (paintTop) {
            if (!this.firstPaint) {
                g.setClip(this.rectBoard.x, this.rectBoard.y, this.rectBoard.width, this.rectBoard.height);
            } else {
                Tools.setFullClip(g);
                this.firstPaint = false;
            }
            g.drawImage(this.bg, 0, 0, 0);
            this.paintGridItems(g);
            if (repaintTopHUD) {
                g.setClip(this.controlItems[0].x, 0, this.controlItems[0].width, this.upperHUDbgH);
                g.drawImage(this.upperHUDbg, this.controlItems[0].x, this.controlItems[0].y, 0);
                this.worm.setFrame(0);
                this.worm.setPosition(MainCanvas.mainUIOffset + GridController.xOffset, this.controlItems[0].getCenterY() - this.wormH2);
                this.worm.paint(g);
                g.drawImage(this.resultBarEmpty, resultBarX, resultBarY, 0);
                if (importantItemsShooted < this.oneStarSuccess) {
                    g.drawRegion(this.resultBarFull, 0, 0, Tools.getBarWidth(this.oneStarSuccess, importantItemsShooted, this.resultBarW3), this.resultBarH, 0, resultBarX, resultBarY, 0);
                    g.drawImage(Resources.resImgs[29], resultBarX + (this.resultBarW3 - this.resultBarW3 / 2) - (Resources.resImgsW[29] >> 1), resultBarY + this.resultBarH2 - (Resources.resImgsW[29] >> 1), 0);
                    g.drawImage(Resources.resImgs[29], resultBarX + (2 * this.resultBarW3 - this.resultBarW3 / 2) - (Resources.resImgsW[29] >> 1), resultBarY + this.resultBarH2 - (Resources.resImgsW[29] >> 1), 0);
                    g.drawImage(Resources.resImgs[29], resultBarX + (3 * this.resultBarW3 - this.resultBarW3 / 2) - (Resources.resImgsW[29] >> 1), resultBarY + this.resultBarH2 - (Resources.resImgsW[29] >> 1), 0);
                } else if (importantItemsShooted >= this.oneStarSuccess && importantItemsShooted < this.twoStarSuccess) {
                    int barClipWidth = this.resultBarW3 + Tools.getBarWidth(this.twoStarSuccess - this.oneStarSuccess, importantItemsShooted - this.oneStarSuccess, this.resultBarW3);
                    g.drawRegion(this.resultBarFull, 0, 0, barClipWidth, this.resultBarH, 0, resultBarX, resultBarY, 0);
                    g.drawImage(Resources.resImgs[25], resultBarX + (this.resultBarW3 - this.resultBarW3 / 2) - (Resources.resImgsW[25] >> 1), resultBarY + this.resultBarH2 - (Resources.resImgsW[29] >> 1), 0);
                    g.drawImage(Resources.resImgs[29], resultBarX + (2 * this.resultBarW3 - this.resultBarW3 / 2) - (Resources.resImgsW[29] >> 1), resultBarY + this.resultBarH2 - (Resources.resImgsW[29] >> 1), 0);
                    g.drawImage(Resources.resImgs[29], resultBarX + (3 * this.resultBarW3 - this.resultBarW3 / 2) - (Resources.resImgsW[29] >> 1), resultBarY + this.resultBarH2 - (Resources.resImgsW[29] >> 1), 0);
                } else if (importantItemsShooted >= this.twoStarSuccess && importantItemsShooted < this.threeStarSuccess) {
                    int barClipWidth = this.resultBarW3 * 2 + Tools.getBarWidth(this.threeStarSuccess - this.twoStarSuccess, importantItemsShooted - this.twoStarSuccess, this.resultBarW3);
                    g.drawRegion(this.resultBarFull, 0, 0, barClipWidth, this.resultBarH, 0, resultBarX, resultBarY, 0);
                    g.drawImage(Resources.resImgs[25], resultBarX + (this.resultBarW3 - this.resultBarW3 / 2) - (Resources.resImgsW[25] >> 1), resultBarY + this.resultBarH2 - (Resources.resImgsW[29] >> 1), 0);
                    g.drawImage(Resources.resImgs[25], resultBarX + (2 * this.resultBarW3 - this.resultBarW3 / 2) - (Resources.resImgsW[25] >> 1), resultBarY + this.resultBarH2 - (Resources.resImgsW[29] >> 1), 0);
                    g.drawImage(Resources.resImgs[29], resultBarX + (3 * this.resultBarW3 - this.resultBarW3 / 2) - (Resources.resImgsW[29] >> 1), resultBarY + this.resultBarH2 - (Resources.resImgsW[29] >> 1), 0);
                } else if (importantItemsShooted >= this.threeStarSuccess) {
                    int barClipWidth = this.resultBarW3 * 3;
                    g.drawRegion(this.resultBarFull, 0, 0, barClipWidth, this.resultBarH, 0, resultBarX, resultBarY, 0);
                    g.drawImage(Resources.resImgs[25], resultBarX + (this.resultBarW3 - this.resultBarW3 / 2) - (Resources.resImgsW[25] >> 1), resultBarY + this.resultBarH2 - (Resources.resImgsW[29] >> 1), 0);
                    g.drawImage(Resources.resImgs[25], resultBarX + (2 * this.resultBarW3 - this.resultBarW3 / 2) - (Resources.resImgsW[25] >> 1), resultBarY + this.resultBarH2 - (Resources.resImgsW[29] >> 1), 0);
                    g.drawImage(Resources.resImgs[25], resultBarX + (3 * this.resultBarW3 - this.resultBarW3 / 2) - (Resources.resImgsW[25] >> 1), resultBarY + this.resultBarH2 - (Resources.resImgsW[29] >> 1), 0);
                }
                this.mc.mainFont.drawString(g, numberOfShotsCharArr, this.wormW + (MainCanvas.mainUIOffset << 1) + GridController.xOffset, this.controlItems[0].getCenterY() - (this.mc.mainFont.getHeight() >> 1), 20);
            }
        } else {
            Tools.setFullClip(g);
            this.firstPaint = false;
            repaintBottomHUD = true;
            g.drawImage(this.bg, 0, 0, 0);
            this.paintGridItems(g);
        }
        if (MainCanvas.touchActivated) {
            if (repaintTopHUD) {
                repaintTopHUD = false;
                g.drawImage(Resources.resImgs[36], this.controlItems[1].getCenterX() - (Resources.resImgsW[36] >> 1), this.controlItems[1].getCenterY() - (Resources.resImgsH[36] >> 1), 0);
            }
        } else if (repaintTopHUD) {
            repaintTopHUD = false;
        }
    }

    private final void paintGridItems(Graphics g) {
        this.randomBlinkNum = RandomNum.getRandomUInt(1000);
        for (int y = 0; y < this.gridH; ++y) {
            for (int x = 0; x < this.gridW; ++x) {
                int idx = y * this.gridW + x;
                if (GridController.grid[idx] == 0) {
                    if (smokeFrames[idx] != -1) {
                        Resources.resSprs[16].setPosition(this.gridCentersX[idx] - this.smokeSpriteW2, this.gridCentersY[idx] - this.smokeSpriteH2);
                        Resources.resSprs[16].setFrame(smokeFrames[idx]);
                        Resources.resSprs[16].paint(g);
                        int n = idx;
                        smokeFrames[n] = smokeFrames[n] + 1;
                        if (smokeFrames[idx] >= 5) {
                            ScreenGame.smokeFrames[idx] = -1;
                        }
                    }
                    if (smokeBombFrames[idx] != -1) {
                        Resources.resSprs[19].setPosition(this.gridCentersX[idx] - this.smokeSpriteW2, this.gridCentersY[idx] - this.smokeSpriteH2);
                        Resources.resSprs[19].setFrame(smokeBombFrames[idx]);
                        Resources.resSprs[19].paint(g);
                        int n = idx;
                        smokeBombFrames[n] = smokeBombFrames[n] + 1;
                        if (smokeBombFrames[idx] >= 5) {
                            ScreenGame.smokeBombFrames[idx] = -1;
                        }
                    }
                    if (crackedWoodFrameCounter[idx] != -1) {
                        this.wood.setFrame(1);
                        this.wood.setPosition(this.gridCentersX[idx] - this.itemsCenterOffsetX[2], this.gridCentersY[idx] - this.itemsCenterOffsetY[2]);
                        this.wood.paint(g);
                        int n = idx;
                        crackedWoodFrameCounter[n] = crackedWoodFrameCounter[n] + 1;
                        if (crackedWoodFrameCounter[idx] >= 5) {
                            ScreenGame.crackedWoodFrameCounter[idx] = -1;
                            ScreenGame.smokeFrames[idx] = 0;
                        }
                    }
                    if (crackedStoneFrameCounter[idx] == -1) continue;
                    this.rock.setFrame(2);
                    this.rock.setPosition(this.gridCentersX[idx] - this.itemsCenterOffsetX[9], this.gridCentersY[idx] - this.itemsCenterOffsetY[9]);
                    this.rock.paint(g);
                    int n = idx;
                    crackedStoneFrameCounter[n] = crackedStoneFrameCounter[n] + 1;
                    if (crackedStoneFrameCounter[idx] < 5) continue;
                    ScreenGame.crackedStoneFrameCounter[idx] = -1;
                    ScreenGame.smokeFrames[idx] = 0;
                    continue;
                }
                if (GridController.flagIsPresent(GridController.grid[idx], GridItemTypes.GIT_FRUIT)) {
                    Sprite tmpSprite = null;
                    tmpSprite = this.randomBlinkNum == idx ? this.fruit_2 : this.fruit_1;
                    tmpSprite.setPosition(this.gridCentersX[idx] - this.itemsCenterOffsetX[4], this.gridCentersY[idx] - this.itemsCenterOffsetY[4]);
                    if (GridController.flagIsPresent(GridController.grid[idx], GridItemTypes.GIT_FRUIT_1)) {
                        tmpSprite.setFrame(0);
                    } else if (GridController.flagIsPresent(GridController.grid[idx], GridItemTypes.GIT_FRUIT_2)) {
                        tmpSprite.setFrame(1);
                    } else if (GridController.flagIsPresent(GridController.grid[idx], GridItemTypes.GIT_FRUIT_3)) {
                        tmpSprite.setFrame(2);
                    } else if (GridController.flagIsPresent(GridController.grid[idx], GridItemTypes.GIT_FRUIT_4)) {
                        tmpSprite.setFrame(3);
                    } else if (GridController.flagIsPresent(GridController.grid[idx], GridItemTypes.GIT_FRUIT_5)) {
                        tmpSprite.setFrame(4);
                    } else if (GridController.flagIsPresent(GridController.grid[idx], GridItemTypes.GIT_FRUIT_6)) {
                        tmpSprite.setFrame(5);
                    }
                    tmpSprite.paint(g);
                } else if (GridController.flagIsPresent(GridController.grid[idx], GridItemTypes.GIT_BOMB)) {
                    if (this.bombSpriteCounter > this.bombSpriteSpeed) {
                        this.bomb.nextFrame();
                        this.bombSpriteCounter = 0;
                    }
                    this.bomb.setPosition(this.gridCentersX[idx] - this.itemsCenterOffsetX[1], this.gridCentersY[idx] - this.itemsCenterOffsetY[1]);
                    this.bomb.paint(g);
                } else if (GridController.flagIsPresent(GridController.grid[idx], GridItemTypes.GIT_FREEZE)) {
                    if (this.randomBlinkNum == idx) {
                        this.freeze.setFrame(1);
                    } else {
                        this.freeze.setFrame(0);
                    }
                    this.freeze.setPosition(this.gridCentersX[idx] - this.itemsCenterOffsetX[3], this.gridCentersY[idx] - this.itemsCenterOffsetY[3]);
                    this.freeze.paint(g);
                } else if (GridController.flagIsPresent(GridController.grid[idx], GridItemTypes.GIT_WOOD)) {
                    this.wood.setFrame(0);
                    this.wood.setPosition(this.gridCentersX[idx] - this.itemsCenterOffsetX[2], this.gridCentersY[idx] - this.itemsCenterOffsetY[2]);
                    this.wood.paint(g);
                } else if (GridController.flagIsPresent(GridController.grid[idx], GridItemTypes.GIT_STRONG_WOOD)) {
                    this.rock.setPosition(this.gridCentersX[idx] - this.itemsCenterOffsetX[9], this.gridCentersY[idx] - this.itemsCenterOffsetY[9]);
                    this.rock.setFrame(0);
                    this.rock.paint(g);
                } else if (GridController.flagIsPresent(GridController.grid[idx], GridItemTypes.GIT_DAMAGED_STRONG_WOOD)) {
                    this.rock.setPosition(this.gridCentersX[idx] - this.itemsCenterOffsetX[9], this.gridCentersY[idx] - this.itemsCenterOffsetY[9]);
                    this.rock.setFrame(1);
                    this.rock.paint(g);
                } else if (GridController.flagIsPresent(GridController.grid[idx], GridItemTypes.GIT_IRON)) {
                    if (this.randomBlinkNum == idx) {
                        this.marshmallow.setFrame(1);
                    } else {
                        this.marshmallow.setFrame(0);
                    }
                    if (GridController.bouncedItem == idx) {
                        this.marshmallow.setFrame(2);
                        GridController.bouncedItem = -1;
                    }
                    this.marshmallow.setPosition(this.gridCentersX[idx] - this.itemsCenterOffsetX[8], this.gridCentersY[idx] - this.itemsCenterOffsetY[8]);
                    this.marshmallow.paint(g);
                } else if (GridController.flagIsPresent(GridController.grid[idx], GridItemTypes.GIT_GLUE)) {
                    this.honey.setFrame(0);
                    if (GridController.honeyItem == idx) {
                        this.honey.setFrame(1);
                    }
                    this.honey.setPosition(this.gridCentersX[idx] - this.itemsCenterOffsetX[6], this.gridCentersY[idx] - this.itemsCenterOffsetY[6]);
                    this.honey.paint(g);
                } else if (GridController.flagIsPresent(GridController.grid[idx], GridItemTypes.GIT_SPIKED_BALL)) {
                    if (this.randomBlinkNum == idx) {
                        this.acorn.setFrame(1);
                    } else {
                        this.acorn.setFrame(0);
                    }
                    this.acorn.setPosition(this.gridCentersX[idx] - this.itemsCenterOffsetX[0], this.gridCentersY[idx] - this.itemsCenterOffsetY[0]);
                    this.acorn.paint(g);
                } else if (GridController.flagIsPresent(GridController.grid[idx], GridItemTypes.GIT_BONUS_TRIPLE_SHOT)) {
                    if (this.randomBlinkNum == idx) {
                        this.triple_shot.setFrame(1);
                    } else {
                        this.triple_shot.setFrame(0);
                    }
                    this.triple_shot.setPosition(this.gridCentersX[idx] - this.itemsCenterOffsetX[10], this.gridCentersY[idx] - this.itemsCenterOffsetY[10]);
                    this.triple_shot.paint(g);
                }
                if (!GridController.flagIsPresent(GridController.grid[idx], GridItemTypes.GIT_FREEZED)) continue;
                this.ice.setPosition(this.gridCentersX[idx] - this.itemsCenterOffsetX[7], this.gridCentersY[idx] - this.itemsCenterOffsetY[7]);
                this.ice.setFrame(0);
                this.ice.paint(g);
            }
        }
    }

    private final void paintPowerBar(Graphics g) {
        if (!this.powerBarHidden) {
            if (this.powerBarState == 1) {
                this.repaintPowerBarAnimation = true;
                this.controlItems[15].y -= 16;
                if (this.controlItems[15].y <= MainCanvas.HEIGHT - this.controlItems[15].height + 2) {
                    this.controlItems[15].y = MainCanvas.HEIGHT - this.controlItems[15].height + 2;
                    this.powerBarState = 0;
                    PointerController.selectingStrength = true;
                }
            } else if (this.powerBarState == 2) {
                this.repaintPowerBarAnimation = true;
                this.controlItems[15].y += 16;
                if (this.controlItems[15].y >= MainCanvas.HEIGHT) {
                    this.controlItems[15].y = MainCanvas.HEIGHT;
                    this.powerBarState = 0;
                    this.powerBarHidden = true;
                    this.repaintPowerBarAnimation = false;
                }
            }
            if (PointerController.strength - PointerController.strengthOffset != 0) {
                if (MainCanvas.touchActivated) {
                    if (this.repaintPowerBarAnimation) {
                        g.setClip(this.touchControlBottomHudRect.x, this.touchControlBottomHudRect.y, this.touchControlBottomHudRect.width, this.touchControlBottomHudRect.height);
                        g.drawImage(this.bottomHUDbg, this.controlItems[15].x, this.controlItems[15].y, 0);
                        g.drawRegion(this.powerBar, 0, 0, this.getPowerBarWidthFromStrength(PointerController.strength - PointerController.strengthOffset, 15), Resources.resImgsH[34], 0, this.controlItems[15].getCenterX() - (Resources.resImgsW[34] >> 1), this.controlItems[15].getBottom() - Resources.resImgsH[34] - this.powerBarOffset, 0);
                        repaintBottomHUD = true;
                    }
                } else {
                    g.drawImage(this.bottomHUDbg, this.controlItems[15].x, this.controlItems[15].y, 0);
                    g.drawRegion(this.powerBar, 0, 0, this.getPowerBarWidthFromStrength(PointerController.strength - PointerController.strengthOffset, 15), Resources.resImgsH[34], 0, this.controlItems[15].getCenterX() - (Resources.resImgsW[34] >> 1), this.controlItems[15].getBottom() - Resources.resImgsH[34] - this.powerBarOffset, 0);
                    g.drawImage(Resources.resImgs[36], this.controlItems[1].getCenterX() - (Resources.resImgsW[36] >> 1), this.controlItems[15].y + (this.bottomHUDbgH >> 1) - (Resources.resImgsH[36] >> 1), 0);
                }
            }
        }
    }

    private void revealPowerBar() {
        PointerController.resetStrength();
        this.powerBarHidden = false;
        this.selectingStrength = true;
        this.powerBarState = 0;
        this.controlItems[15].y = MainCanvas.HEIGHT - this.controlItems[15].height + 2;
        PointerController.selectingStrength = true;
        this.repaintPowerBarAnimation = true;
    }

    private void hidePowerBar() {
        this.powerBarState = 2;
        PointerController.selectingStrength = false;
    }

    private void createResultStarParticles(int x, int y) {
        for (int p = 0; p < 8; ++p) {
            Particles.createParticle(x, y, particlesVelX + RandomNum.getRandomInt(10) * 2, particlesVelY + RandomNum.getRandomInt(particlesVelY), particlesAccX + RandomNum.getRandomInt(particlesVelX), particlesAccY, particleSize, particleCol, particleLife);
        }
    }

    private int getPowerBarWidthFromStrength(int _strength, int _maxStrength) {
        if (_strength == _maxStrength && Resources.resImgsW[34] / _maxStrength * _strength < Resources.resImgsW[34]) {
            return Resources.resImgsW[34];
        }
        return Resources.resImgsW[34] / _maxStrength * _strength;
    }

    public void keyPressed(int keyCode) {
        if (mode == 1 && Keys.isActionGeneratedByKey(5, keyCode)) {
            paintTop = false;
            this.repaint();
            this.holdingFireButton = true;
            repaintBottomHUD = true;
            if (PointerController.projCount == 0) {
                this.revealPowerBar();
            }
        }
    }

    public static void forceLevelEndIfNeeded() {
        if (importantItemsShooted >= importantItemsForLevel) {
            projectilesFired = projectilesForLevel;
        }
    }

    public static void refreshProjectileCountText() {
        numberOfShotsCharArr = (projectilesForLevel - projectilesFired + "/" + projectilesForLevel).toCharArray();
    }

    public void keyReleased(int keyCode) {
        if (mode == 1) {
            if (Keys.isActionGeneratedByKey(5, keyCode)) {
                paintTop = false;
                this.repaint();
                if (PointerController.selectingStrength) {
                    if (PointerController.fire(0)) {
                        ++projectilesFired;
                        repaintTopHUD = true;
                        repaintBuffer = true;
                    }
                    numberOfShotsCharArr = (projectilesForLevel - projectilesFired + "/" + projectilesForLevel).toCharArray();
                    PointerController.selectingStrength = false;
                    PointerController.resetStrength();
                    repaintBottomHUD = true;
                }
            } else if (Keys.isFKRight(keyCode)) {
                paintTop = true;
                this.repaint();
                mode = 2;
                holdingItemIndex = 2;
            }
        } else if (mode == 4) {
            if (Keys.isActionGeneratedByKey(5, keyCode)) {
                if (this.mc.selectedLevel == 0) {
                    mode = 5;
                    this.repaint();
                } else {
                    repaintBottomHUD = true;
                    mode = 1;
                    this.repaint();
                }
                this.mc.repaint();
                ++MainCanvas.tutorial;
            }
        } else if (mode == 5) {
            if (Keys.isActionGeneratedByKey(5, keyCode)) {
                repaintBottomHUD = true;
                mode = 1;
                this.repaint();
            }
            this.mc.repaint();
        } else if (mode == 2) {
            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                if (--holdingItemIndex < 2) {
                    holdingItemIndex = 6;
                }
            } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
                if (++holdingItemIndex > 6) {
                    holdingItemIndex = 2;
                }
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                switch (holdingItemIndex) {
                    case 2: {
                        mode = 1;
                        repaintBottomHUD = true;
                        break;
                    }
                    case 4: {
                        MainCanvas.soundManager.SetSoundOn(!MainCanvas.soundManager.IsSoundOn());
                        this.playGameMusic();
                        break;
                    }
                    case 6: {
                        this.mc.setActiveScreen(3, null);
                        break;
                    }
                    case 5: {
                        mode = 6;
                        break;
                    }
                    case 3: {
                        this.loadDataForLevel(this.mc.selectedLevel);
                    }
                }
            }
        } else if (mode == 6) {
            if (Keys.isFKRight(keyCode)) {
                mode = 2;
                this.ptYOffset = 0;
                arrowDOWN = true;
                arrowUP = false;
            } else if (Keys.isActionGeneratedByKey(1, keyCode)) {
                this.ptYOffset -= this.mc.mainFont.getHeight();
                arrowDOWN = true;
                if (this.ptYOffset < 0) {
                    this.ptYOffset = 0;
                    arrowUP = false;
                    arrowDOWN = true;
                }
                System.out.println("MODE " + mode + " UP " + this.ptYOffset + " font height " + this.mc.mainFont.getHeight());
                this.repaint();
            } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
                int maxOffsetY = this.textHelp.getTextHeight() - this.tutorialRect.height + 4;
                this.ptYOffset += this.mc.mainFont.getHeight();
                arrowUP = true;
                if (maxOffsetY > 0 && this.ptYOffset > maxOffsetY) {
                    this.ptYOffset = maxOffsetY;
                    arrowUP = true;
                    arrowDOWN = false;
                }
                if (this.textHelp.getTextHeight() <= this.tutorialRect.height) {
                    this.ptYOffset = 0;
                }
                System.out.println("MODE " + mode + " DOWN " + this.ptYOffset + " font height " + this.mc.mainFont.getHeight());
                this.repaint();
            }
        } else if (mode == 3) {
            if (Keys.isActionGeneratedByKey(3, keyCode)) {
                --holdingItemIndex;
                System.gc();
                if (this.levelSucceed && this.mc.getAllEarnedStars() >= MainCanvas.getStarsNeededForLevel(this.mc.selectedLevel + 1)) {
                    if (holdingItemIndex < 8) {
                        holdingItemIndex = 10;
                    }
                } else if (holdingItemIndex < 8) {
                    holdingItemIndex = 9;
                }
            } else if (Keys.isActionGeneratedByKey(4, keyCode)) {
                ++holdingItemIndex;
                if (this.levelSucceed && this.mc.getAllEarnedStars() >= MainCanvas.getStarsNeededForLevel(this.mc.selectedLevel + 1)) {
                    if (holdingItemIndex > 10) {
                        holdingItemIndex = 8;
                    }
                } else if (holdingItemIndex > 9) {
                    holdingItemIndex = 8;
                }
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                if (holdingItemIndex == 8) {
                    this.mc.setActiveScreen(3, null);
                } else if (holdingItemIndex == 9) {
                    this.loadDataForLevel(this.mc.selectedLevel);
                } else if (holdingItemIndex == 10 && this.mc.getAllEarnedStars() >= MainCanvas.getStarsNeededForLevel(this.mc.selectedLevel + 1)) {
                    ++this.mc.selectedLevel;
                    this.loadDataForLevel(this.mc.selectedLevel);
                }
            }
        }
        this.holdingFireButton = false;
        PointerController.resetMovingSpeed();
    }

    public void pointerPressed(int x, int y) {
        if (mode == 2) {
            for (int i = 2; i < 7; ++i) {
                if (!this.controlItems[i].contains(x, y)) continue;
                holdingItemIndex = i;
            }
            return;
        }
        if (mode == 4) {
            if (this.mc.selectedLevel == 0) {
                mode = 5;
                this.repaint();
            } else {
                mode = 1;
                this.repaint();
            }
            this.mc.repaint();
            ++MainCanvas.tutorial;
            return;
        }
        if (mode == 5) {
            mode = 1;
            this.mc.repaint();
            return;
        }
        if (mode == 3) {
            for (int i = 8; i < 11; ++i) {
                if (!this.controlItems[i].contains(x, y)) continue;
                holdingItemIndex = i;
            }
            return;
        }
        if (!PointerController.selectingStrength) {
            this.pointerX = x;
            this.pointerY = y;
            this.pressOnX = x;
            this.pressOnY = y;
        }
        System.out.println((this.controlItems[14].contains(x, y) || this.fireButtonBiggerRect.contains(x, y)) + "prve");
        if (mode != 6) {
            if (this.controlItems[12].contains(x, y) || this.leftArrowBiggerRect.contains(x, y)) {
                this.holdingPointerLeftArrow = true;
            } else if (this.controlItems[13].contains(x, y) || this.rightArrowBiggerRect.contains(x, y)) {
                this.holdingPointerRightArrow = true;
            } else if (this.controlItems[14].contains(x, y) || this.fireButtonBiggerRect.contains(x, y)) {
                this.holdingFireButton = true;
                if (PointerController.projCount == 0) {
                    this.revealPowerBar();
                }
            }
        }
    }

    public void pointerDragged(int x, int y) {
        if (this.rectBoard.contains(x, y) && !PointerController.selectingStrength) {
            this.pointerX = x;
            this.pointerY = y;
            this.draggedOnX = x;
            this.draggedOnY = y;
        }
        if (mode == 6) {
            if (y > MainCanvas.HEIGHT / 2 && y < MainCanvas.HEIGHT) {
                if (x >= this.tutorialRect.x && x <= this.tutorialRect.x + this.tutorialRect.width) {
                    this.dragDown();
                }
            } else if (y < MainCanvas.HEIGHT / 2 && y > 0 + Resources.resSprs[23].getHeight() && x >= this.tutorialRect.x && x <= this.tutorialRect.x + this.tutorialRect.width) {
                this.dragUp();
            }
        }
    }

    public void pointerReleased(int x, int y) {
        try {
            if (mode == 2) {
                if (this.controlItems[2].contains(x, y) && holdingItemIndex == 2) {
                    Keys.resetAllPressedKeysAndActions();
                    this.holdingFireButton = false;
                    this.holdingPointerRightArrow = false;
                    this.holdingPointerLeftArrow = false;
                    mode = 1;
                } else if (this.controlItems[4].contains(x, y) && holdingItemIndex == 4) {
                    MainCanvas.soundManager.SetSoundOn(!MainCanvas.soundManager.IsSoundOn());
                    this.playGameMusic();
                } else if (this.controlItems[6].contains(x, y) && holdingItemIndex == 6) {
                    this.mc.setActiveScreen(3, null);
                } else if (this.controlItems[5].contains(x, y) && holdingItemIndex == 5) {
                    mode = 6;
                    this.repaint();
                } else if (this.controlItems[3].contains(x, y) && holdingItemIndex == 3) {
                    this.loadDataForLevel(this.mc.selectedLevel);
                }
                holdingItemIndex = -1;
                return;
            }
            if (mode == 4) {
                // empty if block
            }
            if (mode == 5) {
                // empty if block
            }
            if (mode == 6) {
                if (this.rectItems[0].contains(x, y)) {
                    mode = 2;
                    repaintBottomHUD = true;
                    Keys.resetAllPressedKeysAndActions();
                    this.repaint();
                } else if (this.rectItems[1].contains(x, y)) {
                    this.ptYOffset -= this.mc.mainFont.getHeight();
                    arrowDOWN = true;
                    if (this.ptYOffset < 0) {
                        this.ptYOffset = 0;
                        arrowUP = false;
                        arrowDOWN = true;
                    }
                    this.repaint();
                } else if (this.rectItems[2].contains(x, y)) {
                    int maxOffsetY = this.textHelp.getTextHeight() - this.tutorialRect.height + 4;
                    this.ptYOffset += this.mc.mainFont.getHeight();
                    arrowUP = true;
                    if (maxOffsetY > 0 && this.ptYOffset > maxOffsetY) {
                        this.ptYOffset = maxOffsetY;
                        arrowUP = true;
                        arrowDOWN = false;
                    }
                    this.repaint();
                }
            }
            if (mode == 3) {
                System.out.println("MODE END " + (this.controlItems[10].contains(x, y) && holdingItemIndex == 10) + " x " + x + " y " + y);
                if (this.controlItems[8].contains(x, y) && holdingItemIndex == 8) {
                    this.mc.setActiveScreen(3, null);
                } else if (this.controlItems[9].contains(x, y) && holdingItemIndex == 9) {
                    this.loadDataForLevel(this.mc.selectedLevel);
                } else if (this.controlItems[10].contains(x, y) && holdingItemIndex == 10 && this.allowNextLevel && this.mc.getAllEarnedStars() >= MainCanvas.getStarsNeededForLevel(this.mc.selectedLevel + 1)) {
                    ++this.mc.selectedLevel;
                    this.loadDataForLevel(this.mc.selectedLevel);
                }
                holdingItemIndex = -1;
            }
            if ((this.controlItems[1].contains(x, y) || this.openGameMenuBiggerRect.contains(x, y)) && mode != 3) {
                mode = 2;
            }
            if (mode == 1 && PointerController.selectingStrength) {
                if (PointerController.fire(0)) {
                    ++projectilesFired;
                    repaintTopHUD = true;
                    repaintBuffer = true;
                }
                numberOfShotsCharArr = (projectilesForLevel - projectilesFired + "/" + projectilesForLevel).toCharArray();
                this.hidePowerBar();
            }
            if (mode != 6 && (this.holdingPointerLeftArrow || this.holdingPointerRightArrow || this.holdingFireButton)) {
                repaintBottomHUD = true;
            }
            this.holdingFireButton = false;
            this.holdingPointerLeftArrow = false;
            this.holdingPointerRightArrow = false;
            PointerController.resetMovingSpeed();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dragUp() {
        this.ptYOffset -= this.mc.mainFont.getHeight();
        arrowDOWN = true;
        if (this.ptYOffset < 0) {
            this.ptYOffset = 0;
            arrowUP = false;
            arrowDOWN = true;
        }
        this.repaint();
    }

    public void dragDown() {
        int maxOffsetY = this.textHelp.getTextHeight() - this.tutorialRect.height;
        this.ptYOffset += this.mc.mainFont.getHeight();
        arrowUP = true;
        if (maxOffsetY > 0 && this.ptYOffset > maxOffsetY) {
            this.ptYOffset = maxOffsetY;
            arrowUP = true;
            arrowDOWN = false;
        }
        if (this.textHelp.getTextHeight() <= this.tutorialRect.height) {
            this.ptYOffset = 0;
        }
        this.repaint();
    }

    public static void tr(String _s) {
        System.out.println(_s);
    }
}

