/*
 * Decompiled with CFR 0.152.
 */
package project;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FontClass {
    public static final int CHAR_LEFT = 0;
    public static final int CHAR_TOP = 1;
    public static final int CHAR_WIDTH = 2;
    public static final int CHAR_HEIGHT = 3;
    public static final int CHAR_Y_OFFSET = 4;
    private Image img_font;
    private int[][] location;
    private int c_separ = 1;
    private int height;

    private FontClass(String FileName, int size) throws IOException {
        this.height = size;
        InputStream is = this.getClass().getResourceAsStream(FileName);
        if (is == null) {
            throw new IOException();
        }
        int len = 0;
        try {
            len = is.available();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        byte[] temp = new byte[len];
        try {
            is.read(temp);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.location = new int[256][];
        int i = 0;
        while ((temp[i] & 0xFF) != 137 || (temp[i + 1] & 0xFF) != 80 || (temp[i + 2] & 0xFF) != 78 || (temp[i + 3] & 0xFF) != 71) {
            int num = temp[i] & 0xFF;
            this.location[num] = new int[5];
            this.location[num][0] = temp[i + 1] & 0xFF;
            this.location[num][1] = temp[i + 2] & 0xFF;
            this.location[num][2] = temp[i + 3] & 0xFF;
            this.location[num][3] = temp[i + 4] & 0xFF;
            this.location[num][4] = temp[i + 5] & 0xFF;
            i += 6;
        }
        byte[] PNGbyte = new byte[len - i];
        System.arraycopy(temp, i, PNGbyte, 0, len - i);
        this.img_font = Image.createImage((byte[])PNGbyte, (int)0, (int)PNGbyte.length);
    }

    public static FontClass factory(String FileName, int size) throws IOException {
        return new FontClass(FileName, size);
    }

    public void drawString(Graphics g, String string, int x, int y, int Anchor) {
        this.drawString(g, string, x, y, Anchor, this.c_separ);
    }

    public void drawString(Graphics g, String string, int x, int y, int Anchor, int separ) {
        try {
            this.testAnchor(Anchor);
            this.drawSLT(g, string, x + this.getDX(this.getWidth(string), Anchor), y + this.getDY(this.height, Anchor), separ);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void drawSLT(Graphics g, String string, int x, int y, int separ) throws NullPointerException {
        int[] oc = new int[]{g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight()};
        int stringW = 0;
        int i = 0;
        while (i < string.length()) {
            block12: {
                int c = string.charAt(i) & Integer.MAX_VALUE;
                try {
                    if (c > 255) {
                        if (c == 8217) {
                            c = 39;
                        } else if (c == 8211) {
                            c = 45;
                        } else if (c == 8220) {
                            c = 34;
                        } else {
                            if (c != 8221) break block12;
                            c = 34;
                        }
                    }
                    this.setClip(g, this.getAnd(oc[0], oc[1], oc[2], oc[3], x + stringW, y + this.location[c][4], this.location[c][2], this.location[c][3]));
                    g.drawImage(this.img_font, x + stringW - this.location[c][0], y - this.location[c][1] + this.location[c][4], 20);
                    stringW += this.location[c][2] + separ;
                    if (c == 32) {
                        stringW += 3;
                    }
                }
                catch (NullPointerException e) {
                    System.out.println("'" + string.charAt(i) + "'" + "(" + i + ")" + " cannot be found in the font.");
                }
            }
            ++i;
        }
        g.setClip(oc[0], oc[1], oc[2], oc[3]);
    }

    public int[] getAnd(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        int[] res = new int[4];
        res[0] = x1 > x2 ? x1 : x2;
        res[1] = y1 > y2 ? y1 : y2;
        int i = x1 + w1;
        int j = x2 + w2;
        res[2] = (i < j ? i : j) - res[0];
        i = y1 + h1;
        j = y2 + h2;
        res[3] = (i < j ? i : j) - res[1];
        return res;
    }

    public void setClip(Graphics g, int[] a) {
        g.setClip(a[0], a[1], a[2], a[3]);
    }

    public int getDX(int x2, int Anchor) {
        int dx = 0;
        if ((Anchor & 8) != 0) {
            dx = -x2;
        } else if ((Anchor & 1) != 0) {
            dx = -(x2 >> 1);
        }
        return dx;
    }

    public int getDY(int y2, int Anchor) {
        int dy = 0;
        if ((Anchor & 0x20) != 0) {
            dy = -y2;
        } else if ((Anchor & 2) != 0) {
            dy = -(y2 >> 1);
        }
        return dy;
    }

    public int getCharWidth(char c) {
        try {
            if (c == ' ') {
                return this.location[c][2] + this.c_separ + 3;
            }
            return this.location[c][2] + this.c_separ;
        }
        catch (Exception e) {
            return this.height / 2;
        }
    }

    public int getWidth(String s) {
        int width = 0;
        int i = 0;
        while (i < s.length()) {
            try {
                if ((s.charAt(i) & Integer.MAX_VALUE) > 127) {
                    return this.height;
                }
                width = s.charAt(i) == ' ' ? (width += 3 + this.c_separ) : (width += this.location[s.charAt(i) & Integer.MAX_VALUE][2] + this.c_separ);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            ++i;
        }
        return width - this.c_separ;
    }

    public int getHeight() {
        return this.height;
    }

    public void setSpear(int spear) {
        this.c_separ = spear;
    }

    public int getSepar() {
        return this.c_separ;
    }

    public void testAnchor(int Anchor) {
        int temp = Anchor & 8 | Anchor & 4 | Anchor & 1;
        switch (temp) {
            case 1: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        temp = Anchor & 0x10 | Anchor & 0x20 | Anchor & 2;
        switch (temp) {
            case 2: 
            case 16: 
            case 32: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

