/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class Resources {
    public static String[] texts;
    public static final byte APP_NAME = 0;
    public static final byte VERSION = 1;
    public static final byte TOURNAMENT_LAND_NAME_PLAYER = 2;
    public static final byte TOURNAMENT_OPPONENT_1_LAND_NAME = 3;
    public static final byte TOURNAMENT_OPPONENT_2_LAND_NAME = 4;
    public static final byte TOURNAMENT_OPPONENT_3_LAND_NAME = 5;
    public static final byte TOURNAMENT_OPPONENT_4_LAND_NAME = 6;
    public static final byte TOURNAMENT_OPPONENT_5_LAND_NAME = 7;
    public static final byte TOURNAMENT_OPPONENT_6_LAND_NAME = 8;
    public static final byte TOURNAMENT_OPPONENT_1_NAME = 9;
    public static final byte TOURNAMENT_OPPONENT_2_NAME = 10;
    public static final byte TOURNAMENT_OPPONENT_3_NAME = 11;
    public static final byte TOURNAMENT_OPPONENT_4_NAME = 12;
    public static final byte TOURNAMENT_OPPONENT_5_NAME = 13;
    public static final byte TOURNAMENT_OPPONENT_6_NAME = 14;
    public static final byte TOURNAMENT_OPPONENT_1_LAND_STORY = 15;
    public static final byte TOURNAMENT_OPPONENT_2_LAND_STORY = 16;
    public static final byte TOURNAMENT_OPPONENT_3_LAND_STORY = 17;
    public static final byte TOURNAMENT_OPPONENT_4_LAND_STORY = 18;
    public static final byte TOURNAMENT_OPPONENT_5_LAND_STORY = 19;
    public static final byte TOURNAMENT_OPPONENT_6_LAND_STORY = 20;
    public static final byte TOURNAMENT_OPPONENT_1_GAME_DIALOG_WIN = 21;
    public static final byte TOURNAMENT_OPPONENT_1_GAME_DIALOG_LOSE = 22;
    public static final byte TOURNAMENT_OPPONENT_2_GAME_DIALOG_WIN = 23;
    public static final byte TOURNAMENT_OPPONENT_2_GAME_DIALOG_LOSE = 24;
    public static final byte TOURNAMENT_OPPONENT_3_GAME_DIALOG_WIN = 25;
    public static final byte TOURNAMENT_OPPONENT_3_GAME_DIALOG_LOSE = 26;
    public static final byte TOURNAMENT_OPPONENT_4_GAME_DIALOG_WIN = 27;
    public static final byte TOURNAMENT_OPPONENT_4_GAME_DIALOG_LOSE = 28;
    public static final byte TOURNAMENT_OPPONENT_5_GAME_DIALOG_WIN = 29;
    public static final byte TOURNAMENT_OPPONENT_5_GAME_DIALOG_LOSE = 30;
    public static final byte TOURNAMENT_OPPONENT_6_GAME_DIALOG_WIN = 31;
    public static final byte TOURNAMENT_OPPONENT_6_GAME_DIALOG_LOSE = 32;
    public static final byte TOURNAMENT_START_STORY = 33;
    public static final byte TOURNAMENT_END_STORY_WON = 34;
    public static final byte TOURNAMENT_END_STORY_LOST = 35;
    public static final byte TOURNAMENT_CANT_PLAY_LAND = 36;
    public static final byte TOURNAMENT_MATCH = 37;
    public static final byte TOURNAMENT_WON_GAME = 38;
    public static final byte TOURNAMENT_POINTS = 39;
    public static final byte TOURNAMENT_DRAW_GAME = 40;
    public static final byte TOURNAMENT_LOST_GAME = 41;
    public static final byte TOURNAMENT_CONQUERED_LAND = 42;
    public static final byte TOURNAMENT_LOST_LAND = 43;
    public static final byte SPLASH_MSG_YOU_WIN = 44;
    public static final byte SPLASH_MSG_YOU_LOSE = 45;
    public static final byte SPLASH_MSG_DRAW = 46;
    public static final byte SPLASH_MSG_BLACK_WINS = 47;
    public static final byte SPLASH_MSG_WHITE_WINS = 48;
    public static final byte TEXT_HELP = 49;
    public static final byte TEXT_HELP_CONTROLS = 50;
    public static final byte GAME_SUPPORT_PART1 = 51;
    public static final byte GAME_SUPPORT_PART2 = 52;
    public static final byte GAME_WEB_PART1 = 53;
    public static final byte GAME_WEB_PART2 = 54;
    public static final byte GAME_COPYRIGHT_PART1 = 55;
    public static final byte GAME_COPYRIGHT_PART2 = 56;
    public static final byte HIGHSCORE_TITLE = 57;
    public static final byte NOVICE = 58;
    public static final byte EXPERT = 59;
    public static final byte MASTER = 60;
    public static final byte TWO_PLAYERS = 61;
    public static final byte TOURNAMENT = 62;
    public static final byte CLASSIC_GAME = 63;
    public static final byte PLAYER_BLACK = 64;
    public static final byte PLAYER_WHITE = 65;
    public static final byte NEW_GAME = 66;
    public static final byte HIGHSCORE = 67;
    public static final byte SOUND = 68;
    public static final byte MUSIC = 69;
    public static final byte ON = 70;
    public static final byte OFF = 71;
    public static final byte HELP = 72;
    public static final byte ABOUT = 73;
    public static final byte EXIT = 74;
    public static final byte CONTINUE = 75;
    public static final byte BACK = 76;
    public static final byte MAIN_MENU = 77;
    public static final byte OK = 78;
    public static final byte CANCEL = 79;
    public static final byte SAVE = 80;
    public static final byte NEXT = 81;
    public static final byte CONTINUE_TOURNAMENT = 82;
    public static final byte NEW_TOURNAMENT = 83;
    public static final byte UNDO = 84;
    public static final byte REDO = 85;
    public static final String TEXT_ABOUT;
    public static final int MAX_IMAGES_PLAYERS = 7;
    private static Player soundPlayer;
    public static final int MAX_SOUNDS = 13;
    private static String[] soundFiles;
    private static int previousSound;
    public static boolean isMusicOn;
    public static boolean isSoundOn;
    public static final byte AMR_GRAVITY = 0;
    public static final byte AMR_MENU_SCROLL = 1;
    public static final byte AMR_PLACE_ERROR = 2;
    public static final byte AMR_PLACE_STONE = 3;
    public static final byte AMR_QUAKE = 4;
    public static final byte AMR_SPACE_SHIP_ARRIVE = 5;
    public static final byte AMR_SPACE_SHIP_SHOOT = 6;
    public static final byte MID_GAME_DRAW = 7;
    public static final byte MID_LAND_LOST = 8;
    public static final byte MID_LAND_WON = 9;
    public static final byte MID_PAHTUM_THEME = 10;
    public static final byte MID_TOURNAMENT_LOST = 11;
    public static final byte MID_TOURNAMENT_WON = 12;
    public static final byte SOUND_MUSIC = 10;
    public static Image[] images;
    public static final int MAX_IMAGES = 16;
    public static final byte IMAGE_BOARD_CONTENT = 0;
    public static final byte IMAGE_BOARD = 1;
    public static final byte IMAGE_FLASH = 2;
    public static final byte IMAGE_FRAME = 3;
    public static final byte IMAGE_PLAYER0 = 4;
    public static final byte IMAGE_PLAYER1 = 5;
    public static final byte IMAGE_PLAYER2 = 6;
    public static final byte IMAGE_PLAYER3 = 7;
    public static final byte IMAGE_PLAYER4 = 8;
    public static final byte IMAGE_PLAYER5 = 9;
    public static final byte IMAGE_PLAYER6 = 10;
    public static final byte IMAGE_MAP = 11;
    public static final byte IMAGE_PLAYER_HIGHSCORE = 12;
    public static final byte IMAGE_SPECIAL_ET = 13;
    public static final byte IMAGE_SPLASH1 = 14;
    public static final byte IMAGE_SPLASH2 = 15;
    public static final byte FI_1 = 0;
    public static final byte FI_2 = 4;
    public static final byte FI_3 = 8;
    public static final byte FI_4 = 12;
    public static final byte UPPER_FRAME_INDEX = 16;
    public static final byte MIDDLE_FRAME_INDEX = 20;
    public static final byte LOWER_FRAME_INDEX = 24;
    public static final char[] splashTileMap;
    public static final byte LAND_START = 0;
    public static final byte LAND_ONE = 4;
    public static final byte LAND_TWO = 8;
    public static final byte LAND_THREE = 12;
    public static final byte LAND_FOUR = 16;
    public static final byte LAND_FIVE = 20;
    public static final byte LAND_SIX = 24;
    public static final byte TOURNAMENTTileMapOffsetX = 22;
    public static final byte TOURNAMENTTileMapOffsetY = 16;
    public static final char[] TOURNAMENTTileMap;
    public static final byte[] TOURNAMENTDirectionMap;
    public static final String[] TOURNAMENTLandNames;
    public static final String[] TOURNAMENTLandStory;
    public static final String[] TOURNAMENTOpponentNames;
    public static final String[][] TOURNAMENTOpponentMatchEpilog;
    public static String[] highscoreTitles;
    public static String[] menuText;
    public static int[] coords;
    public static int MAX_HIGHSCORES;
    public static final byte MAX_HIGHSCORE_TYPES = 5;
    public static final byte HIGHSCORE_TYPE_NOVICE = 0;
    public static final byte HIGHSCORE_TYPE_EXPERT = 1;
    public static final byte HIGHSCORE_TYPE_MASTER = 2;
    public static final byte HIGHSCORE_TYPE_2PLAYER = 3;
    public static final byte HIGHSCORE_TYPE_TOURNAMENT = 4;
    public static Vector[] scores;
    public static String highscoreDbName;
    public static String[][] highscores_default;
    public static String settingsDbName;
    public static String tournamentDbName;
    protected static GameCanvas canvas1;
    public static boolean loading;
    public static GameCanvas gamecanvas;
    public static boolean lang;
    public static Game midlet1;

    public static void initImages() throws IOException {
        images = new Image[16];
        Resources.images[14] = Image.createImage((String)"/s2.png");
        Resources.images[15] = Image.createImage((String)"/s1.png");
    }

    public static void loadImages() throws IOException {
        Resources.images[1] = Image.createImage((String)"/bg.png");
        Resources.images[0] = Image.createImage((String)"/b.png");
        Resources.images[2] = Image.createImage((String)"/fl.png");
        Resources.images[4] = Image.createImage((String)"/f0.png");
        Resources.images[5] = Image.createImage((String)"/f1.png");
        Resources.images[6] = Image.createImage((String)"/f2.png");
        Resources.images[7] = Image.createImage((String)"/f3.png");
        Resources.images[8] = Image.createImage((String)"/f4.png");
        Resources.images[9] = Image.createImage((String)"/f5.png");
        Resources.images[10] = Image.createImage((String)"/f6.png");
        Resources.images[3] = Image.createImage((String)"/brd.png");
        Resources.images[11] = Image.createImage((String)"/mp.png");
        Resources.images[12] = Image.createImage((String)"/bh.png");
        Resources.images[13] = Image.createImage((String)"/ET.png");
    }

    public static void loadSoundsNames() {
        try {
            soundFiles = new String[13];
            Resources.soundFiles[0] = "GameDraw.mid";
            Resources.soundFiles[1] = "MenuScroll.amr";
            Resources.soundFiles[2] = "PlaceError.amr";
            Resources.soundFiles[3] = "PlaceStone.amr";
            Resources.soundFiles[4] = "Quake.amr";
            Resources.soundFiles[5] = "SpaceShipArrive.amr";
            Resources.soundFiles[6] = "SpaceShipShoot.amr";
            Resources.soundFiles[7] = "GameDraw.mid";
            Resources.soundFiles[8] = "LandLost.mid";
            Resources.soundFiles[9] = "LandWon.mid";
            Resources.soundFiles[10] = "PahtumTheme.mid";
            Resources.soundFiles[11] = "TournamentLost.mid";
            Resources.soundFiles[12] = "TournamentWon.mid";
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void playFile(int fileID) {
        if ((fileID == 10 && isMusicOn || fileID != 10 && isSoundOn) && (previousSound != 10 || soundPlayer.getState() != 400 && soundPlayer.getState() != 300)) {
            int mediaID = 0;
            try {
                Object o = new Object();
                String[] mediaType = new String[]{"audio/midi", "audio/amr"};
                if (fileID != previousSound) {
                    if (previousSound != -1) {
                        soundPlayer.deallocate();
                        soundPlayer.close();
                    }
                    InputStream inputstream = o.getClass().getResourceAsStream("/" + soundFiles[fileID]);
                    if (soundFiles[fileID].endsWith("mid")) {
                        mediaID = 0;
                    } else if (soundFiles[fileID].endsWith("amr")) {
                        mediaID = 1;
                    }
                    soundPlayer = Manager.createPlayer((InputStream)inputstream, (String)mediaType[mediaID]);
                    soundPlayer.realize();
                    soundPlayer.setLoopCount(1);
                    if (fileID == 10) {
                        soundPlayer.setLoopCount(-1);
                    }
                    if (mediaID == 0) {
                        VolumeControl volume = (VolumeControl)soundPlayer.getControl("javax.microedition.media.control.VolumeControl");
                        volume.setLevel(80);
                    } else if (mediaID == 1) {
                        VolumeControl volume = (VolumeControl)soundPlayer.getControl("javax.microedition.media.control.VolumeControl");
                        volume.setLevel(100);
                    }
                }
                soundPlayer.start();
                previousSound = fileID;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void stopAllSounds() {
        try {
            if (previousSound != -1 && soundPlayer.getState() == 400) {
                soundPlayer.stop();
            }
            soundPlayer.deallocate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadText() throws Exception {
        if (GameCanvas.ii == 0) {
            GameCanvas.languageString = Game.dtr.equalsIgnoreCase("/lang_en.dat") ? "/lang_en.dat" : (Game.dtr.equalsIgnoreCase("/lang_fr.dat") ? "/lang_fr.dat" : (Game.dtr.equalsIgnoreCase("/lang_de.dat") ? "/lang_de.dat" : (Game.dtr.equalsIgnoreCase("/lang_it.dat") ? "/lang_it.dat" : (Game.dtr.equalsIgnoreCase("/lang_sl.dat") ? "/lang_sl.dat" : (Game.dtr.equalsIgnoreCase("/lang_rm.dat") ? "/lang_rm.dat" : "/lang_" + GameCanvas.languageString + ".dat")))));
        } else {
            String str = GameCanvas.languageString;
            GameCanvas.languageString = "/lang_" + str + ".dat";
            GameCanvas.ii = 0;
        }
        InputStream is = new Object().getClass().getResourceAsStream(GameCanvas.languageString);
        DataInputStream dis = new DataInputStream(is);
        if (dis == null) {
            throw new Exception();
        }
        int size = dis.readInt();
        texts = new String[size];
        for (int i = 0; i < size; ++i) {
            Resources.texts[i] = dis.readUTF();
        }
        dis.close();
        dis = null;
        is = null;
    }

    public static String getText(short id) {
        return texts[id];
    }

    public static void loadSettings() {
        RecordStore db = null;
        try {
            db = RecordStore.openRecordStore((String)settingsDbName, (boolean)true);
            RecordEnumeration re = db.enumerateRecords(null, null, false);
            if (re.hasNextElement()) {
                String s = new String(re.nextRecord());
                isMusicOn = s.charAt(0) == '1';
                isSoundOn = s.charAt(1) == '1';
            } else {
                String s = (isMusicOn ? "1" : "0") + (isSoundOn ? "1" : "0");
                db.addRecord(s.getBytes(), 0, s.length());
            }
            db.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void storeSettings() {
        RecordStore db = null;
        try {
            db = RecordStore.openRecordStore((String)settingsDbName, (boolean)true);
            RecordEnumeration re = db.enumerateRecords(null, null, false);
            String s = (isMusicOn ? "1" : "0") + (isSoundOn ? "1" : "0");
            db.setRecord(re.nextRecordId(), s.getBytes(), 0, s.length());
            db.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean loadTournament(short[][] tournament) {
        RecordStore db = null;
        boolean loaded = false;
        try {
            db = RecordStore.openRecordStore((String)tournamentDbName, (boolean)true);
            RecordEnumeration re = db.enumerateRecords(null, null, false);
            if (re.hasNextElement()) {
                byte[] bar = re.nextRecord();
                ByteArrayInputStream bis = new ByteArrayInputStream(bar);
                DataInputStream dis = new DataInputStream(bis);
                for (int i = 0; i < tournament.length; ++i) {
                    for (int j = 0; j < tournament[i].length; ++j) {
                        tournament[i][j] = dis.readShort();
                    }
                }
                loaded = true;
            }
            db.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return loaded;
    }

    public static void storeTournament(short[][] tournament) {
        RecordStore db = null;
        try {
            db = RecordStore.openRecordStore((String)tournamentDbName, (boolean)true);
            RecordEnumeration re = db.enumerateRecords(null, null, false);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            for (int i = 0; i < tournament.length; ++i) {
                for (int j = 0; j < tournament[i].length; ++j) {
                    dos.writeShort(tournament[i][j]);
                }
            }
            if (re.hasNextElement()) {
                db.setRecord(re.nextRecordId(), bos.toByteArray(), 0, bos.size());
            } else {
                db.addRecord(bos.toByteArray(), 0, bos.size());
            }
            db.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Vector[] loadHighscores() {
        try {
            RecordStore db = RecordStore.openRecordStore((String)highscoreDbName, (boolean)true);
            RecordEnumeration r = db.enumerateRecords(null, null, false);
            if (!r.hasNextElement()) {
                for (int hst = 0; hst < 5; ++hst) {
                    Resources.scores[hst] = new Vector(MAX_HIGHSCORES);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(bos);
                    dos.writeByte(hst);
                    for (int i = 0; i < MAX_HIGHSCORES; ++i) {
                        dos.writeUTF(highscores_default[hst][i]);
                        scores[hst].addElement(highscores_default[hst][i]);
                    }
                    db.addRecord(bos.toByteArray(), 0, bos.size());
                }
            } else {
                for (int hst = 0; hst < 5; ++hst) {
                    ByteArrayInputStream bis = new ByteArrayInputStream(r.nextRecord());
                    DataInputStream dis = new DataInputStream(bis);
                    byte hstb = dis.readByte();
                    Resources.scores[hstb] = new Vector(MAX_HIGHSCORES);
                    for (int i = 0; i < MAX_HIGHSCORES; ++i) {
                        String s = new String(dis.readUTF());
                        scores[hstb].addElement(s);
                    }
                }
            }
            db.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return scores;
    }

    public static void storeHighscore(byte _scoreType, byte _playerType, String _sName, int _iValue) {
        RecordStore db = null;
        String r = _sName + "-" + _playerType + "=" + _iValue;
        if (scores[_scoreType].size() == 0) {
            scores[_scoreType].addElement(r);
        } else {
            scores[_scoreType].insertElementAt(r, Resources.isQualified(_scoreType, _iValue, _playerType));
            if (scores[_scoreType].size() > MAX_HIGHSCORES) {
                scores[_scoreType].removeElementAt(scores[_scoreType].size() - 1);
            }
        }
        try {
            db = RecordStore.openRecordStore((String)highscoreDbName, (boolean)true);
            RecordEnumeration re = db.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                int reid = re.nextRecordId();
                ByteArrayInputStream bis = new ByteArrayInputStream(db.getRecord(reid));
                DataInputStream dis = new DataInputStream(bis);
                byte hstb = dis.readByte();
                if (hstb != _scoreType) continue;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(bos);
                dos.writeByte(_scoreType);
                for (int i = 0; i < MAX_HIGHSCORES; ++i) {
                    String s = (String)scores[_scoreType].elementAt(i);
                    dos.writeUTF(s);
                }
                db.setRecord(reid, bos.toByteArray(), 0, bos.size());
            }
            db.closeRecordStore();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static int isQualified(byte scoreType, int value, byte player) {
        int i;
        for (i = 0; i < scores[scoreType].size(); ++i) {
            int v = Resources.getHighScoreValue((String)scores[scoreType].elementAt(i));
            byte p = Resources.getHighScorePlayer((String)scores[scoreType].elementAt(i));
            if (value > v || value == v && player < p) break;
        }
        if (i > scores[scoreType].size() || i >= MAX_HIGHSCORES) {
            return -1;
        }
        return i;
    }

    public static int getHighScoreValue(String _sEncodedValue) {
        int iNumber = 0;
        String rA = _sEncodedValue.substring(_sEncodedValue.indexOf("=") + 1, _sEncodedValue.length());
        iNumber = 0;
        try {
            iNumber = Integer.parseInt(rA);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return iNumber;
    }

    public static String getHighScoreName(String _sEncodedValue) {
        String sName = null;
        sName = _sEncodedValue.substring(0, _sEncodedValue.indexOf("-"));
        return sName;
    }

    public static byte getHighScorePlayer(String _sEncodedValue) {
        String sP = _sEncodedValue.substring(_sEncodedValue.indexOf("-") + 1, _sEncodedValue.indexOf("-") + 2);
        return (byte)(!sP.equals("0") ? 1 : 0);
    }

    static {
        try {
            Resources.loadText();
        }
        catch (Exception exception) {
            // empty catch block
        }
        TEXT_ABOUT = "" + Resources.getText((short)0) + " v" + Resources.getText((short)1) + "           " + Resources.getText((short)55) + "  " + Resources.getText((short)56) + "   " + Resources.getText((short)51) + "" + Resources.getText((short)52) + "   " + Resources.getText((short)53) + " " + Resources.getText((short)54) + " ";
        previousSound = -1;
        isMusicOn = true;
        isSoundOn = true;
        splashTileMap = new char[]{'\u0000', '\u0000', '\u008c', '\u0002', '\u0000', '\u0002', '\u008c', '\u0006', '\u0000', '\b', '\u008c', '\n', '\u0000', '\u0012', '\u008c', '\u0010', '\u0000', '\"', '\u008c', '\u0005', '\u0000', '\'', '\u008c', '\n', '\u0000', '1', '\u008c', '\u0005'};
        TOURNAMENTTileMap = new char[]{'\u0000', '\u0000', '\"', '\"', '#', '\u0000', '7', '.', '\u0000', '\"', '\"', ':', '[', '\u0000', '(', '6', '\u0000', ']', 'Z', '(', '[', '7', '(', 'M', '#', '.', '7', '.'};
        TOURNAMENTDirectionMap = new byte[]{0, 1, 0, 2, 1, 3, 2, 4, 3, 5, 4, 5, 5, 6};
        TOURNAMENTLandNames = new String[]{Resources.getText((short)2), Resources.getText((short)3), Resources.getText((short)4), Resources.getText((short)5), Resources.getText((short)6), Resources.getText((short)7), Resources.getText((short)8)};
        TOURNAMENTLandStory = new String[]{"", Resources.getText((short)15), Resources.getText((short)16), Resources.getText((short)17), Resources.getText((short)18), Resources.getText((short)19), Resources.getText((short)20)};
        TOURNAMENTOpponentNames = new String[]{"", Resources.getText((short)9), Resources.getText((short)10), Resources.getText((short)11), Resources.getText((short)12), Resources.getText((short)13), Resources.getText((short)14)};
        TOURNAMENTOpponentMatchEpilog = new String[][]{{"", ""}, {Resources.getText((short)21), Resources.getText((short)22)}, {Resources.getText((short)23), Resources.getText((short)24)}, {Resources.getText((short)25), Resources.getText((short)26)}, {Resources.getText((short)27), Resources.getText((short)28)}, {Resources.getText((short)29), Resources.getText((short)30)}, {Resources.getText((short)31), Resources.getText((short)32)}};
        highscoreTitles = new String[]{Resources.getText((short)58), Resources.getText((short)59), Resources.getText((short)60), Resources.getText((short)61), Resources.getText((short)62)};
        menuText = new String[]{Resources.getText((short)66), Resources.getText((short)67), Resources.getText((short)68) + Resources.getText((short)70), Resources.getText((short)68) + Resources.getText((short)71), Resources.getText((short)69) + Resources.getText((short)70), Resources.getText((short)69) + Resources.getText((short)71), Resources.getText((short)72), Resources.getText((short)73), Resources.getText((short)74), Resources.getText((short)58), Resources.getText((short)59), Resources.getText((short)60), Resources.getText((short)64), Resources.getText((short)65), Resources.getText((short)75), Resources.getText((short)76), Resources.getText((short)77), Resources.getText((short)63), Resources.getText((short)62), Resources.getText((short)61), Resources.getText((short)82), Resources.getText((short)79), Resources.getText((short)80), Resources.getText((short)81), Resources.getText((short)81), Resources.getText((short)79), Resources.getText((short)79), "", Resources.getText((short)9), Resources.getText((short)10), Resources.getText((short)11), Resources.getText((short)12), Resources.getText((short)13), Resources.getText((short)14), Resources.getText((short)84), Resources.getText((short)85), Resources.getText((short)83), Resources.getText((short)75)};
        MAX_HIGHSCORES = 7;
        scores = new Vector[5];
        highscoreDbName = "PTHH";
        highscores_default = new String[][]{{"PAH -0=27", " TUM-1=27", "PAH -0=17", " TUM-1=17", "PAH -0=7", " TUM-1=7", "PAH -0=1"}, {"PAH -0=17", " TUM-1=17", "PAH -0=10", " TUM-1=10", "PAH -0=3", " TUM-1=3", "PAH -0=1"}, {"PAH -0=7", " TUM-1=7", "PAH -0=4", " TUM-1=4", "PAH -0=3", " TUM-1=3", "PAH -0=1"}, {"PAH -0=77", " TUM-1=77", "PAH -0=27", " TUM-1=27", "PAH -0=7", " TUM-1=7", "PAH -0=3"}, {"PAH -0=77", " TUM-1=77", "PAH -0=47", " TUM-1=47", "PAH -0=27", " TUM-1=27", "PAH -0=17"}};
        settingsDbName = "PTST";
        tournamentDbName = "PTTR";
        loading = false;
        lang = false;
    }
}

