/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Tournament {
    protected byte tournamentState = 0;
    protected static final byte TOURNAMENT_STATE_START_STORY = 0;
    protected static final byte TOURNAMENT_STATE_CHOOSE_OPPONENT = 1;
    protected static final byte TOURNAMENT_STATE_CHOOSE_OPPONENT_MENU = 2;
    protected static final byte TOURNAMENT_STATE_CHOOSE_DISABLED = 3;
    protected static final byte TOURNAMENT_STATE_ADVANCE_STORY = 4;
    protected static final byte TOURNAMENT_STATE_MATCH_SPLASH = 5;
    protected static final byte TOURNAMENT_STATE_GAME = 6;
    protected static final byte TOURNAMENT_STATE_GAME_END = 7;
    protected static final byte TOURNAMENT_STATE_MATCH_END = 8;
    protected static final byte TOURNAMENT_STATE_MATCH_EPILOG = 9;
    protected static final byte TOURNAMENT_STATE_END_STORY_WON = 10;
    protected static final byte TOURNAMENT_STATE_END_STORY_LOST = 11;
    protected static final byte TOURNAMENT_STATE_IN_GAME_MENU = 12;
    protected static final byte TOURNAMENT_END = 13;
    protected static final byte INDEX_TOTAL_MATCH_SCORE = 0;
    protected static final byte INDEX_AI_TYPE = 1;
    protected static final byte INDEX_PLAYER_COLOR = 2;
    protected static final byte INDEX_OPPONENT = 3;
    protected static final byte INDEX_OWNED = 4;
    protected static final byte INDEX_SPECIAL = 5;
    protected static final byte INDEX_SEQ = 6;
    protected static final byte WORLD_PARAMS = 7;
    protected static final byte WORLDS = 7;
    protected static final byte COLOR_MAP_SELECTED_DISABLED = 2;
    protected static final byte COLOR_MAP_SELECTED = 1;
    protected static final byte COLOR_MAP_OWNED = 0;
    protected static final int[][] mapRectColorMap = new int[][]{{8280330, 15182634, 8280330}, {8260106, 15182634, 8260106}, {0x333333, 0x777777, 0x333333}};
    protected short[][] TOURNAMENT = null;
    protected GameCanvas canvas;
    protected byte gamesPlayed = 0;
    protected byte landsToConquer;
    protected byte selectedLandIndex = 1;
    protected boolean bKeyPressed = false;

    public Tournament(GameCanvas _gameCanvas) {
        this.canvas = _gameCanvas;
        this.initialize();
    }

    public void initialize() {
        this.TOURNAMENT = new short[7][7];
        for (int i = 0; i < 7; ++i) {
            this.TOURNAMENT[i][3] = (byte)i;
        }
        this.TOURNAMENT[0][1] = 0;
        Board cfr_ignored_0 = this.canvas.board;
        this.TOURNAMENT[0][2] = 3;
        this.TOURNAMENT[1][1] = 1;
        Board cfr_ignored_1 = this.canvas.board;
        this.TOURNAMENT[1][2] = 1;
        this.TOURNAMENT[2][1] = 1;
        Board cfr_ignored_2 = this.canvas.board;
        this.TOURNAMENT[2][2] = 0;
        this.TOURNAMENT[3][1] = 2;
        Board cfr_ignored_3 = this.canvas.board;
        this.TOURNAMENT[3][2] = 1;
        this.TOURNAMENT[4][1] = 2;
        Board cfr_ignored_4 = this.canvas.board;
        this.TOURNAMENT[4][2] = 0;
        this.TOURNAMENT[5][1] = 3;
        Board cfr_ignored_5 = this.canvas.board;
        this.TOURNAMENT[5][2] = 1;
        this.TOURNAMENT[6][1] = 3;
        Board cfr_ignored_6 = this.canvas.board;
        this.TOURNAMENT[6][2] = 0;
        Board cfr_ignored_7 = this.canvas.board;
        this.TOURNAMENT[0][5] = 3;
        Board cfr_ignored_8 = this.canvas.board;
        this.TOURNAMENT[1][5] = 3;
        Board cfr_ignored_9 = this.canvas.board;
        this.TOURNAMENT[2][5] = 4;
        Board cfr_ignored_10 = this.canvas.board;
        this.TOURNAMENT[3][5] = 5;
        Board cfr_ignored_11 = this.canvas.board;
        this.TOURNAMENT[4][5] = 6;
        Board cfr_ignored_12 = this.canvas.board;
        this.TOURNAMENT[5][5] = 3;
        Board cfr_ignored_13 = this.canvas.board;
        this.TOURNAMENT[6][5] = 3;
        this.TOURNAMENT[0][4] = 1;
        this.landsToConquer = (byte)6;
        this.gamesPlayed = 0;
        this.canvas.playerMatch = 0;
        this.canvas.computerMatch = 0;
        this.canvas.menu.setMenu(this.canvas.menu.tournamentStoryMenu, true);
        this.setState((byte)0);
    }

    public void update() {
        if (this.canvas.messageBox == null) {
            this.canvas.messageBox = new MessageBox(this.canvas);
        }
        if (this.tournamentState == 6) {
            if (!this.canvas.isGameInProgress()) {
                short[] sArray = this.TOURNAMENT[this.selectedLandIndex];
                sArray[0] = (short)(sArray[0] + this.canvas.playerScore);
                short[] sArray2 = this.TOURNAMENT[this.selectedLandIndex];
                sArray2[0] = (short)(sArray2[0] - this.canvas.computerScore);
                this.setState((byte)7);
                this.canvas.menu.setMenu(this.canvas.menu.tournamentGameMenu, true);
            }
        } else if (!this.bKeyPressed) {
            if (this.canvas.messageBox != null && this.canvas.messageBox.isShrunk() && this.tournamentState != 12) {
                this.canvas.mpmIndex = 0;
                this.canvas.mpmLength = 0;
                this.canvas.mpmDrawnChars = 0;
                this.canvas.messageBox.startAnimationUp();
            }
        } else if (this.canvas.messageBox != null && this.canvas.messageBox.isExtended()) {
            this.canvas.messageBox.startAnimationDown();
        } else if (this.canvas.messageBox != null && this.canvas.messageBox.isShrunk()) {
            this.canvas.mpmIndex = 0;
            this.canvas.mpmLength = 0;
            this.canvas.mpmDrawnChars = 0;
            switch (this.tournamentState) {
                case 0: {
                    this.selectedLandIndex = 1;
                    this.canvas.menu.setMenu(this.canvas.menu.tournamentStoryMenu, true);
                    byte opponent = (byte)this.TOURNAMENT[this.selectedLandIndex][3];
                    byte[] byArray = this.canvas.menu.currentMenu;
                    this.canvas.menu.getClass();
                    byArray[0] = (byte)(27 + opponent);
                    this.setState((byte)1);
                    break;
                }
                case 4: {
                    this.canvas.ai.setAi((byte)this.TOURNAMENT[this.selectedLandIndex][1]);
                    this.canvas.setAiImage(this.TOURNAMENT[this.selectedLandIndex][3]);
                    this.canvas.board.setPlayer((byte)this.TOURNAMENT[this.selectedLandIndex][2]);
                    this.canvas.newGame(this.canvas.menu.tournamentStoryMenu, (byte)7);
                    this.canvas.menu.setMenu(this.canvas.menu.tournamentGameMenu, true);
                    this.setState((byte)5);
                    break;
                }
                case 5: {
                    this.canvas.ai.setAi((byte)this.TOURNAMENT[this.selectedLandIndex][1]);
                    this.canvas.setAiImage(this.TOURNAMENT[this.selectedLandIndex][3]);
                    this.canvas.menu.setMenu(this.canvas.menu.inGameMenu, true);
                    Resources.stopAllSounds();
                    this.setState((byte)6);
                    break;
                }
                case 7: {
                    this.gamesPlayed = (byte)(this.gamesPlayed + 1);
                    if (this.gamesPlayed >= 3 && this.canvas.playerMatch != this.canvas.computerMatch || this.gamesPlayed == 2 && Math.abs(this.canvas.playerMatch - this.canvas.computerMatch) > 2) {
                        this.setState((byte)8);
                        break;
                    }
                    this.canvas.ai.setAi((byte)this.TOURNAMENT[this.selectedLandIndex][1]);
                    this.canvas.setAiImage(this.TOURNAMENT[this.selectedLandIndex][3]);
                    if (this.canvas.playerScore > this.canvas.computerScore) {
                        Board cfr_ignored_0 = this.canvas.board;
                        this.canvas.board.setPlayer((byte)0);
                    } else if (this.canvas.playerScore == this.canvas.computerScore) {
                        this.canvas.board.setPlayer((byte)this.TOURNAMENT[this.selectedLandIndex][2]);
                    } else {
                        Board cfr_ignored_1 = this.canvas.board;
                        this.canvas.board.setPlayer((byte)1);
                    }
                    this.canvas.newGame(this.canvas.menu.tournamentStoryMenu, (byte)7);
                    this.canvas.menu.setMenu(this.canvas.menu.tournamentGameMenu, true);
                    this.setState((byte)5);
                    break;
                }
                case 11: {
                    this.canvas.ai.setAi((byte)this.TOURNAMENT[this.selectedLandIndex][1]);
                    this.canvas.setAiImage(this.TOURNAMENT[this.selectedLandIndex][3]);
                    this.canvas.board.setPlayer((byte)this.TOURNAMENT[this.selectedLandIndex][2]);
                    this.canvas.newGame(this.canvas.menu.mainMenu, (byte)7);
                    this.setState((byte)13);
                    break;
                }
                case 10: {
                    this.canvas.ai.setAi((byte)this.TOURNAMENT[this.selectedLandIndex][1]);
                    this.canvas.setAiImage(this.TOURNAMENT[this.selectedLandIndex][3]);
                    this.canvas.board.setPlayer((byte)this.TOURNAMENT[this.selectedLandIndex][2]);
                    this.canvas.newGame(this.canvas.menu.mainMenu, (byte)7);
                    this.setState((byte)13);
                    break;
                }
                case 1: {
                    if (this.fromLandsOwned(this.selectedLandIndex)) {
                        this.canvas.playerMatch = 0;
                        this.canvas.computerMatch = 0;
                        Resources.playFile(3);
                        this.canvas.menu.setMenu(this.canvas.menu.tournamentStoryMenu, true);
                        this.setState((byte)4);
                        break;
                    }
                    Resources.playFile(2);
                    this.canvas.menu.setMenu(this.canvas.menu.tournamentStoryMenu, true);
                    this.setState((byte)3);
                    break;
                }
                case 3: {
                    this.canvas.menu.setMenu(this.canvas.menu.tournamentStoryMenu, true);
                    byte opponent = (byte)this.TOURNAMENT[this.selectedLandIndex][3];
                    byte[] byArray = this.canvas.menu.currentMenu;
                    this.canvas.menu.getClass();
                    byArray[0] = (byte)(27 + opponent);
                    this.setState((byte)1);
                    break;
                }
                case 8: {
                    this.gamesPlayed = 0;
                    if (this.canvas.playerMatch > this.canvas.computerMatch) {
                        Resources.playFile(9);
                        this.landsToConquer = (byte)(this.landsToConquer - 1);
                        this.TOURNAMENT[this.selectedLandIndex][4] = 1;
                        this.TOURNAMENT[this.selectedLandIndex][6] = this.landsToConquer;
                    } else {
                        Resources.playFile(8);
                        this.landsToConquer = (byte)(this.landsToConquer + 1);
                        byte attackedFromLand = this.getFromLand(this.selectedLandIndex);
                        byte attackedToLand = this.selectedLandIndex;
                        this.TOURNAMENT[attackedFromLand][4] = 0;
                        this.TOURNAMENT[attackedFromLand][3] = this.TOURNAMENT[attackedToLand][3];
                        this.TOURNAMENT[attackedFromLand][2] = this.TOURNAMENT[attackedToLand][2];
                        this.TOURNAMENT[attackedFromLand][1] = this.TOURNAMENT[attackedToLand][1];
                        this.TOURNAMENT[attackedFromLand][0] = 0;
                        this.TOURNAMENT[attackedFromLand][6] = 0;
                    }
                    this.canvas.board.newGame();
                    this.canvas.menu.setMenu(this.canvas.menu.tournamentStoryMenu, true);
                    this.setState((byte)9);
                    break;
                }
                case 9: {
                    Resources.playFile(10);
                    if (this.canvas.playerMatch > this.canvas.computerMatch) {
                        if (this.landsToConquer > 0) {
                            this.selectNextLand();
                        }
                    } else {
                        this.selectedLandIndex = this.getFromLand(this.selectedLandIndex);
                    }
                    if (this.landsToConquer > 0) {
                        if (this.landsToConquer < 7 && this.TOURNAMENT[0][4] == 1) {
                            this.canvas.menu.setMenu(this.canvas.menu.tournamentStoryMenu, true);
                            byte opponent = (byte)this.TOURNAMENT[this.selectedLandIndex][3];
                            byte[] byArray = this.canvas.menu.currentMenu;
                            this.canvas.menu.getClass();
                            byArray[0] = (byte)(27 + opponent);
                            Resources.storeTournament(this.TOURNAMENT);
                            this.setState((byte)1);
                            break;
                        }
                        Resources.playFile(11);
                        this.canvas.menu.setMenu(this.canvas.menu.tournamentStoryMenu, true);
                        this.setState((byte)11);
                        break;
                    }
                    Resources.playFile(12);
                    this.canvas.menu.setMenu(this.canvas.menu.tournamentStoryMenu, true);
                    this.setState((byte)10);
                }
            }
            this.bKeyPressed = false;
        }
    }

    public boolean isGameState() {
        return this.tournamentState == 6;
    }

    public boolean isEndState() {
        return this.tournamentState == 13;
    }

    public void keyPress(int _key) {
        if (_key == -6 || _key == -7) {
            return;
        }
        switch (this.tournamentState) {
            case 1: {
                switch (_key) {
                    case -4: 
                    case -2: 
                    case 5: 
                    case 6: 
                    case 54: 
                    case 56: {
                        Resources.playFile(1);
                        do {
                            this.selectedLandIndex = (byte)(this.selectedLandIndex + 1);
                            this.selectedLandIndex = (byte)(this.selectedLandIndex % 7);
                        } while (this.TOURNAMENT[this.selectedLandIndex][4] == 1);
                        byte opponent = (byte)this.TOURNAMENT[this.selectedLandIndex][3];
                        byte[] byArray = this.canvas.menu.currentMenu;
                        this.canvas.menu.getClass();
                        byArray[0] = (byte)(27 + opponent);
                        break;
                    }
                    case -3: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 50: 
                    case 52: {
                        Resources.playFile(1);
                        do {
                            this.selectedLandIndex = (byte)(this.selectedLandIndex - 1);
                            if (this.selectedLandIndex >= 0) continue;
                            this.selectedLandIndex = (byte)6;
                        } while (this.TOURNAMENT[this.selectedLandIndex][4] == 1);
                        byte opponent = (byte)this.TOURNAMENT[this.selectedLandIndex][3];
                        byte[] byArray = this.canvas.menu.currentMenu;
                        this.canvas.menu.getClass();
                        byArray[0] = (byte)(27 + opponent);
                        break;
                    }
                    case -7: 
                    case -6: 
                    case 8: 
                    case 20: 
                    case 35: 
                    case 42: 
                    case 53: {
                        byte[] byArray = this.canvas.menu.currentMenu;
                        this.canvas.menu.getClass();
                        byArray[0] = 24;
                        this.canvas.menu.setMenu(this.canvas.menu.currentMenu, true);
                        if (this.fromLandsOwned(this.selectedLandIndex)) {
                            Resources.playFile(3);
                        } else {
                            Resources.playFile(2);
                        }
                        this.bKeyPressed = true;
                    }
                }
                break;
            }
            case 6: {
                this.canvas.keyPressedGame(_key);
                break;
            }
            default: {
                this.canvas.menu.keyPressed(_key);
            }
        }
        this.canvas.requestPaint(this.canvas.PREQ_TOURNAMENT_DRAW_MSGBOX);
        this.canvas.requestPaint(this.canvas.PREQ_CANVAS_AITHNIKING);
        this.canvas.requestPaint(this.canvas.PREQ_BOARD_BACKGROUND);
        this.canvas.requestPaint(this.canvas.PREQ_BOARD_GAMEBOARD);
        this.canvas.requestPaint(this.canvas.PREQ_MSGBOX_PAINT);
        this.canvas.requestPaint(this.canvas.PREQ_MSGBOX_TEXT_PAINT);
        this.canvas.requestPaint(this.canvas.PREQ_MENU_PAINT);
        this.canvas.requestPaint(this.canvas.PREQ_CANVAS_SCORE);
        this.canvas.requestPaint(this.canvas.PREQ_CANVAS_PLAYERLOCATION);
    }

    public void drawMessageBox(Graphics _g, String _sValue, byte _alignType, int _x, int _y, int _w, int _h) {
        if (this.canvas.paintRequested[this.canvas.PREQ_TOURNAMENT_DRAW_MSGBOX] && this.canvas.messageBox != null) {
            this.canvas.requestPaint(this.canvas.PREQ_MSGBOX_PAINT);
            this.canvas.messageBoxPaint(_g, _x, _y, _w, _h);
            if (this.canvas.messageBox.isExtended()) {
                this.canvas.donePaint(this.canvas.PREQ_TOURNAMENT_DRAW_MSGBOX);
                this.canvas.abc.setAlign(_alignType);
                this.canvas.mpmLength = _sValue.length();
                if (this.canvas.mpmIndex > this.canvas.mpmLength) {
                    this.canvas.mpmDrawnChars = 0;
                } else {
                    int textY = _y + 2;
                    if (_h == this.canvas.splashHeight) {
                        textY = _y + 6;
                    }
                    this.canvas.mpmDrawnChars = this.canvas.abc.drawString(_g, _sValue.substring(this.canvas.mpmIndex, this.canvas.mpmLength), _x + 6 + 20, textY, _w - 30, _h - 20, -1);
                }
            }
        }
    }

    public void paint(Graphics _g) {
        int shiftAi = -1;
        String sMessage = null;
        if (this.tournamentState == 6) {
            this.canvas.paintGame(_g);
        } else {
            this.canvas.board.drawBackground(_g, this.canvas.screenXOrigin, this.canvas.screenYOrigin, this.canvas.getWidth(), this.canvas.getHeight());
            this.canvas.board.drawGameBoard(_g, this.canvas.getMode(), this.canvas.boardX - 13, this.canvas.boardY - 11, this.canvas.getWidth(), 162);
            switch (this.tournamentState) {
                case 0: {
                    this.drawMessageBox(_g, Resources.getText((short)33), (byte)3, this.canvas.msgboxX, this.canvas.msgboxY, this.canvas.msgboxWidth, this.canvas.msgboxHeight);
                    this.canvas.setAiImage(0);
                    break;
                }
                case 4: {
                    if (this.selectedLandIndex == 1) {
                        this.drawMessageBox(_g, Resources.getText((short)15), (byte)3, this.canvas.msgboxX, this.canvas.msgboxY, this.canvas.msgboxWidth, this.canvas.msgboxHeight - 100);
                    } else if (this.selectedLandIndex == 2) {
                        this.drawMessageBox(_g, Resources.getText((short)16), (byte)3, this.canvas.msgboxX, this.canvas.msgboxY, this.canvas.msgboxWidth, this.canvas.msgboxHeight - 100);
                    } else if (this.selectedLandIndex == 3) {
                        this.drawMessageBox(_g, Resources.getText((short)17), (byte)3, this.canvas.msgboxX, this.canvas.msgboxY, this.canvas.msgboxWidth, this.canvas.msgboxHeight - 100);
                    } else if (this.selectedLandIndex == 4) {
                        this.drawMessageBox(_g, Resources.getText((short)18), (byte)3, this.canvas.msgboxX, this.canvas.msgboxY, this.canvas.msgboxWidth, this.canvas.msgboxHeight - 100);
                    } else if (this.selectedLandIndex == 5) {
                        this.drawMessageBox(_g, Resources.getText((short)19), (byte)3, this.canvas.msgboxX, this.canvas.msgboxY, this.canvas.msgboxWidth, this.canvas.msgboxHeight - 100);
                    } else if (this.selectedLandIndex == 6) {
                        this.drawMessageBox(_g, Resources.getText((short)20), (byte)3, this.canvas.msgboxX, this.canvas.msgboxY, this.canvas.msgboxWidth, this.canvas.msgboxHeight - 100);
                    }
                    this.canvas.setAiImage(0);
                    break;
                }
                case 3: {
                    this.drawMessageBox(_g, Resources.getText((short)36), (byte)3, this.canvas.msgboxX, this.canvas.msgboxY, this.canvas.msgboxWidth, this.canvas.msgboxHeight);
                    this.canvas.setAiImage(0);
                    break;
                }
                case 5: {
                    this.drawMessageBox(_g, Resources.getText((short)37) + "  " + (this.gamesPlayed + 1), (byte)4, this.canvas.splashX, this.canvas.splashY + 78, this.canvas.splashWidth, this.canvas.splashHeight);
                    this.canvas.setAiImage(0);
                    break;
                }
                case 7: {
                    sMessage = this.canvas.playerScore > this.canvas.computerScore ? Resources.getText((short)38) + Math.abs(this.canvas.playerScore - this.canvas.computerScore) + Resources.getText((short)39) : (this.canvas.playerScore == this.canvas.computerScore ? Resources.getText((short)40) : Resources.getText((short)41) + Math.abs(this.canvas.playerScore - this.canvas.computerScore) + Resources.getText((short)39));
                    this.canvas.setAiImage(0);
                    this.drawMessageBox(_g, sMessage, (byte)3, this.canvas.msgboxX, this.canvas.msgboxY, this.canvas.msgboxWidth, this.canvas.msgboxHeight);
                    _g.setColor(0);
                    _g.setClip(0, 0, 176, 220);
                    break;
                }
                case 8: {
                    sMessage = this.canvas.playerMatch > this.canvas.computerMatch ? Resources.getText((short)42) + Resources.TOURNAMENTLandNames[this.selectedLandIndex] + "." : Resources.getText((short)43) + Resources.TOURNAMENTLandNames[this.getFromLand(this.selectedLandIndex)] + ".";
                    this.drawMessageBox(_g, sMessage, (byte)3, this.canvas.msgboxX, this.canvas.msgboxY, this.canvas.msgboxWidth, this.canvas.msgboxHeight);
                    this.canvas.setAiImage(0);
                    break;
                }
                case 10: {
                    this.canvas.setAiImage(0);
                    this.drawMessageBox(_g, Resources.getText((short)34), (byte)3, this.canvas.msgboxX, this.canvas.msgboxY, this.canvas.msgboxWidth, this.canvas.msgboxHeight);
                    break;
                }
                case 11: {
                    this.drawMessageBox(_g, Resources.getText((short)35), (byte)3, this.canvas.msgboxX, this.canvas.msgboxY, this.canvas.msgboxWidth, this.canvas.msgboxHeight);
                    this.canvas.setAiImage(0);
                    break;
                }
                case 9: {
                    short opponent = this.TOURNAMENT[this.selectedLandIndex][3];
                    this.canvas.setAiImage(this.TOURNAMENT[this.selectedLandIndex][3]);
                    if (this.canvas.playerMatch > this.canvas.computerMatch) {
                        sMessage = Resources.TOURNAMENTOpponentMatchEpilog[opponent][1];
                        shiftAi = 2;
                    } else {
                        sMessage = Resources.TOURNAMENTOpponentMatchEpilog[opponent][0];
                        shiftAi = 0;
                    }
                    this.drawMessageBox(_g, sMessage, (byte)3, this.canvas.msgboxX, this.canvas.msgboxY, this.canvas.msgboxWidth, this.canvas.msgboxHeight);
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    if (this.canvas.messageBox == null) break;
                    this.canvas.messageBoxPaint(_g, this.canvas.msgboxX, this.canvas.msgboxY, this.canvas.msgboxWidth, this.canvas.msgboxHeight);
                    if (!this.canvas.messageBox.isExtended()) break;
                    _g.drawImage(Resources.images[11], 22, 16, 20);
                    this.canvas.menu.paint(_g, this.canvas.menuX, this.canvas.menuY, this.canvas.menuWidth - 10, this.canvas.menuHeight);
                    System.out.println("dddddddddddddddd");
                    for (int i = 0; i < 7; ++i) {
                        int tilemapLandIndex = i * 4;
                        if (this.TOURNAMENT[i][4] == 1 || i == this.selectedLandIndex) {
                            int colorMapIndex = 0;
                            if (i == this.selectedLandIndex) {
                                colorMapIndex = 1;
                                if (!this.fromLandsOwned(this.selectedLandIndex)) {
                                    colorMapIndex = 2;
                                }
                            }
                            _g.setColor(mapRectColorMap[colorMapIndex][0]);
                            _g.drawRect(22 + Resources.TOURNAMENTTileMap[tilemapLandIndex], 16 + Resources.TOURNAMENTTileMap[tilemapLandIndex + 1], Resources.TOURNAMENTTileMap[tilemapLandIndex + 2] - 2, Resources.TOURNAMENTTileMap[tilemapLandIndex + 3] - 2);
                            _g.setColor(mapRectColorMap[colorMapIndex][1]);
                            _g.drawRect(23 + Resources.TOURNAMENTTileMap[tilemapLandIndex], 17 + Resources.TOURNAMENTTileMap[tilemapLandIndex + 1], Resources.TOURNAMENTTileMap[tilemapLandIndex + 2] - 4, Resources.TOURNAMENTTileMap[tilemapLandIndex + 3] - 4);
                        }
                        if (i != this.selectedLandIndex) continue;
                        _g.setColor(0);
                        _g.fillRect(this.canvas.drawScoreX, this.canvas.drawScoreY + 20, 100, 10);
                        _g.setClip(0, 0, 176, 220);
                        this.canvas.setAiImage(this.TOURNAMENT[i][3]);
                        this.canvas.abc.setAlign((byte)2);
                        this.canvas.abc.drawString(_g, Resources.TOURNAMENTLandNames[i], this.canvas.drawScoreX, this.canvas.drawScoreY + 13, this.canvas.drawScoreWidth, this.canvas.drawScoreHeight, -1);
                    }
                    break;
                }
            }
            this.canvas.requestPaint(this.canvas.PREQ_CANVAS_AITHNIKING);
            if (shiftAi == -1) {
                shiftAi = 0;
            }
            if (this.tournamentState != 12) {
                this.canvas.drawAiThinking(_g, shiftAi);
            }
            if (this.tournamentState != 1) {
                System.out.println("fffffffffffffffffff");
                this.canvas.menu.paint(_g, this.canvas.menuX, this.canvas.menuY, this.canvas.menuWidth, this.canvas.menuHeight);
            }
            this.canvas.requestPaint(this.canvas.PREQ_CANVAS_SCORE);
        }
    }

    public void selectNextLand() {
        do {
            this.selectedLandIndex = (byte)(this.selectedLandIndex + 1);
            this.selectedLandIndex = (byte)(this.selectedLandIndex % 7);
            if (this.selectedLandIndex != 0) continue;
            this.selectedLandIndex = (byte)(this.selectedLandIndex + 1);
        } while (!this.fromLandsOwned(this.selectedLandIndex) || this.TOURNAMENT[this.selectedLandIndex][4] == 1);
    }

    public boolean fromLandsOwned(int selectedLandIndex) {
        boolean fromLandsOwned = true;
        for (int i = 1; i < Resources.TOURNAMENTDirectionMap.length; i += 2) {
            byte toLand = Resources.TOURNAMENTDirectionMap[i];
            byte fromLand = Resources.TOURNAMENTDirectionMap[i - 1];
            if (toLand != selectedLandIndex || this.TOURNAMENT[fromLand][4] != 0) continue;
            fromLandsOwned = false;
        }
        return fromLandsOwned;
    }

    public byte getFromLand(byte selectedLand) {
        int fromLand = 0;
        int fromlandcnt = 0;
        int i = 0;
        while (i + 1 < Resources.TOURNAMENTDirectionMap.length) {
            if (Resources.TOURNAMENTDirectionMap[i + 1] == selectedLand) {
                fromlandcnt = (byte)(fromlandcnt + 1);
                fromLand = Resources.TOURNAMENTDirectionMap[i];
            }
            i += 2;
        }
        if (fromlandcnt > 1) {
            short selectedseq = 2;
            for (int i2 = 1; i2 < 7; i2 = (int)((byte)(i2 + 1))) {
                if (this.TOURNAMENT[i2][6] != selectedseq) continue;
                fromLand = i2;
                break;
            }
        }
        return (byte)fromLand;
    }

    public void setState(byte newstate) {
        this.tournamentState = newstate;
    }
}

