/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class Alphabet {
    public int gliphWidth;
    public int gliphHeight;
    public static final byte gliphVerticalSpacing = 0;
    public static final byte gliphHeightCompensation = -2;
    public static final byte ALIGN_LEFT = 0;
    public static final byte ALIGN_RIGHT = 1;
    public static final byte ALIGN_CENTER = 2;
    public static final byte ALIGN_EQUALLY_SPACED = 3;
    private byte alignType = 0;

    public void setAlign(byte _alignType) {
        this.alignType = _alignType;
    }

    public boolean isLetter(char _c) {
        return _c >= 'A' && _c <= 'Z' || _c >= 'a' && _c <= 'z';
    }

    public boolean isDigit(char _c) {
        return _c >= '0' && _c <= '9';
    }

    public boolean isSpace(char _c) {
        return _c == ' ';
    }

    public int drawInt(Graphics _g, int _nValue, int _nX, int _nY, int _nWidth, int _nHeight) {
        String _sValue = Integer.toString(_nValue);
        return this.drawString(_g, _sValue, _nX, _nY, _nWidth, _nHeight, -1);
    }

    public int drawString(Graphics _g, String _sValue, int _nX, int _nY, int _nWidth, int _nHeight, int nBlinkingChar) {
        _g.setFont(Font.getFont((int)32, (int)0, (int)8));
        this.gliphWidth = 8;
        this.gliphHeight = _g.getFont().getHeight();
        if (_sValue.length() * this.gliphWidth < _nWidth) {
            if (nBlinkingChar != -1) {
                for (int i = 0; i < _sValue.length(); ++i) {
                    _g.drawChar(_sValue.charAt(i), _nX + i * (this.gliphWidth + 10), _nY + 2, 0x10 | 4);
                }
                _g.setColor(0);
                _g.fillRect(_nX + (this.gliphWidth + 10) * nBlinkingChar - 1, _nY + 2, this.gliphWidth + 10, this.gliphHeight);
            } else {
                _g.setColor(0xDDDDCC);
                switch (this.alignType) {
                    case 1: {
                        _nX = _nX + _nWidth - this.gliphWidth - 1;
                        _g.drawString(_sValue, _nX, _nY + 2, 0x10 | 8);
                        break;
                    }
                    case 2: {
                        _g.drawString(_sValue, _nX += _nWidth / 2, _nY + 2, 0x10 | 1);
                        break;
                    }
                    case 0: 
                    case 3: {
                        _g.drawString(_sValue, _nX, _nY + 2, 0x10 | 4);
                    }
                }
            }
            return 0;
        }
        int maxGliphsInRow = _nWidth / this.gliphWidth - 1;
        int maxGliphsInColumns = _nHeight / (this.gliphHeight + 0);
        String charsTodo = "";
        int alignedXPosition = 0;
        int alignedYPosition = _nY + 2;
        int charIndex = 0;
        int realXGliphPos = 0;
        int realYGliphPos = alignedYPosition;
        int i = 0;
        int skipLine = 0;
        int lines = 0;
        for (i = 0; i < _sValue.length() && lines <= maxGliphsInColumns; ++i) {
            char c = _sValue.charAt(i);
            switch (this.alignType) {
                case 3: {
                    charIndex = i == skipLine + 1 && i < _sValue.length() - 1 ? 0 : i;
                    break;
                }
                default: {
                    charIndex = i % maxGliphsInRow;
                }
            }
            if (charIndex == 0) {
                switch (this.alignType) {
                    case 1: {
                        alignedXPosition = _nX;
                        if (i + maxGliphsInRow < _sValue.length()) break;
                        alignedXPosition += (maxGliphsInRow - (_sValue.length() - i)) * this.gliphWidth;
                        break;
                    }
                    case 2: {
                        alignedXPosition = _nX;
                        if (i + maxGliphsInRow < _sValue.length()) break;
                        alignedXPosition += _nWidth - (_sValue.length() - i) * this.gliphWidth >> 1;
                        break;
                    }
                    case 0: {
                        alignedXPosition = _nX;
                        break;
                    }
                    case 3: {
                        alignedXPosition = _nX;
                        i = this.isSpace(c) ? i + 1 : i;
                        c = _sValue.charAt(i);
                        int nLastCharIndex = i + maxGliphsInRow;
                        if (i + maxGliphsInRow >= _sValue.length()) {
                            nLastCharIndex = _sValue.length() - 1;
                        }
                        skipLine = nLastCharIndex;
                        if (!this.isSpace(_sValue.charAt(nLastCharIndex))) {
                            skipLine = _sValue.substring(0, nLastCharIndex).lastIndexOf(32);
                        }
                        if (skipLine < 0) {
                            skipLine = nLastCharIndex;
                        }
                        while (this.isSpace(_sValue.charAt(skipLine)) && skipLine > i) {
                            --skipLine;
                        }
                        if (skipLine > nLastCharIndex) {
                            skipLine = nLastCharIndex;
                            break;
                        }
                        if (i >= skipLine) {
                            skipLine = nLastCharIndex;
                            break;
                        }
                        if (skipLine >= i) break;
                        skipLine = nLastCharIndex;
                    }
                }
            }
            if (charIndex == 0) {
                realXGliphPos = alignedXPosition;
                if (i > 0) {
                    _g.setColor(0xDDDDCC);
                    _g.drawString(charsTodo, _nX + 3, realYGliphPos, 0x10 | 4);
                    charsTodo = "";
                    realYGliphPos = realYGliphPos + this.gliphHeight + 0;
                    ++lines;
                }
            } else {
                realXGliphPos = c == ' ' ? (realXGliphPos += this.gliphWidth) : (realXGliphPos += this.gliphWidth);
            }
            if (lines > maxGliphsInColumns) continue;
            charsTodo = charsTodo + c;
        }
        _g.setColor(0xDDDDCC);
        _g.drawString(charsTodo, _nX + 10 - 10, realYGliphPos, 0x10 | 4);
        if (i < _sValue.length()) {
            _g.drawChar('>', _nX + _nWidth - 2, realYGliphPos - this.gliphHeight, 0x10 | 4);
        }
        return i < _sValue.length() ? i - 1 : 0;
    }
}

