/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;

public class Ai {
    public static final byte NONE = 0;
    public static final byte NOVICE = 1;
    public static final byte EXPERT = 2;
    public static final byte MASTER = 3;
    private static final int INF = Integer.MAX_VALUE;
    public byte nType;

    public void setAi(byte _nType) {
        this.nType = _nType;
    }

    public byte[] bestMove(Board board, byte player) {
        Random rnd = new Random(System.currentTimeMillis());
        byte opponent = (byte)((player + 1) % 2);
        Vector<byte[]> bestMoves = new Vector<byte[]>();
        int maxValue = -2147483647;
        for (byte j = 0; j < 7; j = (byte)((byte)(j + 1))) {
            for (byte i = 0; i < 7; i = (byte)((byte)(i + 1))) {
                if (board.getValue(i, j) < 3) continue;
                int fieldEval = 0;
                fieldEval += board.evalMove(i, j) * 7;
                if (this.nType == 1) {
                    fieldEval += rnd.nextInt() % 20;
                }
                if (this.nType == 2) {
                    fieldEval += rnd.nextInt() % 10;
                }
                if (this.nType > 1) {
                    fieldEval += board.evalLiberties(i, j);
                    fieldEval += board.evalLines(i, j, player) * 5;
                    fieldEval += board.evalLines(i, j, opponent) * 5;
                    fieldEval += board.intersect(i, j, player) * 2;
                    fieldEval += board.intersect(i, j, opponent) * 2;
                }
                if (fieldEval < maxValue) continue;
                byte[] bestMove = new byte[]{i, j};
                if (fieldEval > maxValue) {
                    bestMoves.removeAllElements();
                }
                bestMoves.addElement(bestMove);
                maxValue = fieldEval;
            }
        }
        int chosenValue = 0;
        if (bestMoves.size() > 1) {
            chosenValue = Math.abs(rnd.nextInt()) % bestMoves.size();
        }
        return (byte[])bestMoves.elementAt(chosenValue);
    }
}

