/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MessageBox {
    protected int x;
    protected int y;
    protected int w;
    protected int h;
    protected GameCanvas canvas;
    protected final byte MESSAGEBOX_ANIMATION_UP;
    protected final byte MESSAGEBOX_ANIMATION_DOWN;
    protected final byte MESSAGEBOX_EXTENDED = (byte)2;
    protected final byte MESSAGEBOX_SHRINK = (byte)3;
    protected final byte MESSAGEBOX_ANIMATION_FLIP_UP = (byte)4;
    protected final byte MESSAGEBOX_ANIMATION_FLIP_DOWN = (byte)5;
    protected byte messageBoxAnimationState = (byte)4;
    protected boolean bMessageBoxAnimation = false;
    protected int nFrameIndex;
    protected int nMaxFrames;

    public MessageBox(GameCanvas _canvas) {
        this.MESSAGEBOX_ANIMATION_UP = 0;
        this.MESSAGEBOX_ANIMATION_DOWN = 1;
        this.canvas = _canvas;
        this.nFrameIndex = 0;
        this.nMaxFrames = 5;
        this.bMessageBoxAnimation = false;
        this.messageBoxAnimationState = (byte)3;
    }

    public void startAnimationUp() {
        this.bMessageBoxAnimation = true;
        this.messageBoxAnimationState = (byte)4;
        this.nFrameIndex = 0;
    }

    public void startAnimationDown() {
        this.bMessageBoxAnimation = true;
        this.messageBoxAnimationState = (byte)5;
    }

    public void update() {
        block14: {
            block16: {
                block15: {
                    if ((this.canvas.messageBox == null || this.canvas.messageBox.isShrunk() || this.messageBoxAnimationState != 1) && this.messageBoxAnimationState != 5) break block14;
                    if (this.canvas.getMode() == 7) break block15;
                    if (this.canvas.getMode() == 1) break block15;
                    if (this.canvas.getMode() != 8) break block16;
                }
                this.canvas.requestPaint(this.canvas.PREQ_CANVAS_AITHNIKING);
                this.canvas.requestPaint(this.canvas.PREQ_BOARD_BACKGROUND);
                this.canvas.requestPaint(this.canvas.PREQ_BOARD_GAMEBOARD);
                this.canvas.requestPaint(this.canvas.PREQ_CANVAS_PLAYERLOCATION);
            }
            this.canvas.requestPaint(this.canvas.PREQ_CANVAS_SPLASH);
            this.canvas.requestPaint(this.canvas.PREQ_MENU_PAINT);
            this.canvas.requestPaint(this.canvas.PREQ_TOURNAMENT_DRAW_MSGBOX);
        }
        if (this.bMessageBoxAnimation) {
            switch (this.messageBoxAnimationState) {
                case 0: {
                    this.messageBoxAnimationState = (byte)2;
                    this.nFrameIndex = this.nMaxFrames;
                    if (this.canvas.messageBox == null || this.canvas.messageBox.isExtended()) break;
                    this.canvas.requestPaint(this.canvas.PREQ_MSGBOX_PAINT);
                    break;
                }
                case 1: {
                    this.nFrameIndex = 12;
                    this.messageBoxAnimationState = (byte)5;
                    if (this.canvas.messageBox == null || this.canvas.messageBox.isExtended()) break;
                    this.canvas.requestPaint(this.canvas.PREQ_MSGBOX_PAINT);
                    break;
                }
                case 2: {
                    this.nFrameIndex = this.nMaxFrames;
                    if (this.canvas.messageBox != null && this.canvas.messageBox.isExtended()) {
                        this.canvas.requestPaint(this.canvas.PREQ_MSGBOX_PAINT);
                        this.canvas.requestPaint(this.canvas.PREQ_MSGBOX_TEXT_PAINT);
                        this.canvas.requestPaint(this.canvas.PREQ_HIGHSCORE_PAINT);
                    }
                    this.bMessageBoxAnimation = false;
                    break;
                }
                case 3: {
                    this.bMessageBoxAnimation = false;
                    if (this.canvas.messageBox == null || this.canvas.messageBox.isExtended()) break;
                    this.canvas.requestPaint(this.canvas.PREQ_MSGBOX_PAINT);
                    break;
                }
                case 4: {
                    this.messageBoxAnimationState = 0;
                    this.nFrameIndex = 1;
                    if (this.canvas.messageBox == null || this.canvas.messageBox.isExtended()) break;
                    this.canvas.requestPaint(this.canvas.PREQ_MSGBOX_PAINT);
                    break;
                }
                case 5: {
                    this.nFrameIndex = 0;
                    this.messageBoxAnimationState = (byte)3;
                    if (this.canvas.messageBox == null || this.canvas.messageBox.isExtended()) break;
                    this.canvas.requestPaint(this.canvas.PREQ_MSGBOX_PAINT);
                }
            }
            if (this.canvas.messageBox != null && !this.canvas.messageBox.isExtended() && this.messageBoxAnimationState == 0 || this.messageBoxAnimationState == 4) {
                this.canvas.requestPaint(this.canvas.PREQ_TOURNAMENT_DRAW_MSGBOX);
            }
        }
    }

    public boolean isShrunk() {
        return this.messageBoxAnimationState == 3;
    }

    public boolean isExtended() {
        return this.messageBoxAnimationState == 2;
    }

    private int drawPart(Graphics _g, Image _image, int _xPos, int _yPos, int _partIndex) {
        char pictureY = Resources.splashTileMap[_partIndex + 1];
        char pictureH = Resources.splashTileMap[_partIndex + 3];
        _g.setClip(this.x, _yPos, this.w, (int)pictureH);
        _g.drawImage(_image, _xPos, _yPos - pictureY, 17);
        _g.setClip(this.x, this.y, 240, 320);
        return _yPos + pictureH;
    }

    public void paint(Graphics _g, int _x, int _y, int _w, int _h) {
        this.x = _x;
        this.y = _y;
        this.w = _w;
        this.h = _h;
        int aboutBoxX = 0;
        int aboutBoxY = 0;
        switch (this.messageBoxAnimationState) {
            case 4: 
            case 5: {
                aboutBoxX = _x + (_w >> 1);
                aboutBoxY = _y + (_h >> 1) - (Resources.splashTileMap[this.nFrameIndex + 3] >> 1);
                this.drawPart(_g, Resources.images[3], aboutBoxX, aboutBoxY, this.nFrameIndex);
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                this.nMaxFrames = _h - Resources.splashTileMap[19] - Resources.splashTileMap[27];
                this.nMaxFrames /= Resources.splashTileMap[23];
                aboutBoxX = _x + (_w >> 1);
                aboutBoxY = _y + (_h >> 1) - Resources.splashTileMap[19] - (this.nFrameIndex * Resources.splashTileMap[23] >> 1);
                aboutBoxY = this.drawPart(_g, Resources.images[3], aboutBoxX, aboutBoxY, 16);
                for (int i = 0; i < this.nFrameIndex; ++i) {
                    aboutBoxY = this.drawPart(_g, Resources.images[3], aboutBoxX, aboutBoxY, 20);
                }
                if (aboutBoxY + Resources.splashTileMap[27] < _y + _h && this.nFrameIndex == this.nMaxFrames) {
                    aboutBoxY = _y - Resources.splashTileMap[27] - Resources.splashTileMap[23];
                    aboutBoxY = this.drawPart(_g, Resources.images[3], aboutBoxX, aboutBoxY, 20);
                }
                aboutBoxY = this.drawPart(_g, Resources.images[3], aboutBoxX, aboutBoxY, 24);
            }
        }
    }
}

