/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class ScreenMenu
implements IScreen {
    final int MODE_LOADING_RES;
    final int MODE_MENU;
    final int MODE_CONTINUE_QUICK;
    final int MODE_CONTINUE_CAREER;
    final int MODE_OPTIONS;
    final int MODE_INSTRUCTIONS;
    final int MODE_TOP_SCORE;
    final int MODE_LINK;
    final int MENUITEM_QUICKGAME;
    final int MENUITEM_CAREER;
    final int MENUITEM_INSTRUCTIONS;
    final int MENUITEM_OPTIONS;
    final int MENUITEM_TOPSCORE;
    final int MENUITEM_QUIT;
    final int MENUITEM_LINK;
    final int OPTIONSITEM_MUSIC;
    final int OPTIONSITEM_VIBRATION;
    Canvas canvas;
    int mode;
    long modeDelay;
    int modeState;
    int nextMode;
    int modeTransition;
    private Vector vecMenuItem;
    private int iMenuItemIdx = 0;
    private int iMenuSize = 0;
    private int iMenuPosY = 0;
    private int iMenuSpcY = 0;
    private int iOldItem = -1;

    ScreenMenu(Canvas canvas) {
        this.MODE_LOADING_RES = 0;
        this.MODE_MENU = 1;
        this.MODE_CONTINUE_QUICK = 2;
        this.MODE_CONTINUE_CAREER = 3;
        this.MODE_OPTIONS = 4;
        this.MODE_INSTRUCTIONS = 5;
        this.MODE_TOP_SCORE = 6;
        this.MODE_LINK = 7;
        this.MENUITEM_QUICKGAME = 0;
        this.MENUITEM_CAREER = 1;
        this.MENUITEM_INSTRUCTIONS = 2;
        this.MENUITEM_OPTIONS = 3;
        this.MENUITEM_TOPSCORE = 4;
        this.MENUITEM_QUIT = 5;
        this.MENUITEM_LINK = 6;
        this.OPTIONSITEM_MUSIC = 0;
        this.OPTIONSITEM_VIBRATION = 1;
        this.canvas = canvas;
        this.iMenuItemIdx = 0;
        this.nextMode = this.mode = 0;
        this.modeTransition = 0;
        this.createMenu();
    }

    public int getActualMode() {
        return this.mode;
    }

    public String getActualModeName() {
        return "Screen menu";
    }

    public void createMenu() {
        this.vecMenuItem = new Vector();
        this.vecMenuItem.addElement(X.texts.getHashedString("QUICK_GAME").toUpperCase());
        this.vecMenuItem.addElement(X.texts.getHashedString("CAREER").toUpperCase());
        this.vecMenuItem.addElement(X.texts.getHashedString("INSTRUCTIONS").toUpperCase());
        this.vecMenuItem.addElement(X.texts.getHashedString("OPTIONS").toUpperCase());
        this.vecMenuItem.addElement(X.texts.getHashedString("TOP_SCORE").toUpperCase());
        this.vecMenuItem.addElement(X.texts.getHashedString("QUIT").toUpperCase());
        this.iMenuSize = this.vecMenuItem.size();
        this.calculateMenuVar();
        this.iMenuItemIdx = 0;
        this.iOldItem = -1;
    }

    public void createContinueMenu() {
        this.vecMenuItem.setSize(0);
        this.vecMenuItem.addElement(X.texts.getHashedString("CONTINUE").toUpperCase());
        this.vecMenuItem.addElement(X.texts.getHashedString("NEW_GAME").toUpperCase());
        this.iMenuSize = this.vecMenuItem.size();
        this.calculateFirstLineMenu();
        this.iMenuItemIdx = 0;
        this.iOldItem = -1;
    }

    public void createOtionsMenu() {
        this.vecMenuItem.setSize(0);
        if (Settings.bVibration) {
            this.vecMenuItem.addElement(X.texts.getHashedString("VIBRATIONS").toUpperCase() + " ON");
        } else {
            this.vecMenuItem.addElement(X.texts.getHashedString("VIBRATIONS").toUpperCase() + " OFF");
        }
        if (Settings.bMusic) {
            this.vecMenuItem.addElement(X.texts.getHashedString("SOUNDS").toUpperCase() + " ON");
        } else {
            this.vecMenuItem.addElement(X.texts.getHashedString("SOUNDS").toUpperCase() + " OFF");
        }
        this.iMenuSize = this.vecMenuItem.size();
        this.calculateFirstLineMenu();
        this.iOldItem = -1;
    }

    public void callMainMenu() {
        this.createMenu();
        this.mode = 1;
    }

    public void calculateMenuVar() {
        this.iMenuPosY = Defines.HEIGHT - (this.iMenuSize + 2) * Resources.iMiddleSizeH;
        this.iMenuSpcY = this.iMenuPosY / (this.iMenuSize - 1);
        this.iMenuPosY = Resources.iMiddleSizeH;
    }

    public void calculateFirstLineMenu() {
        this.iMenuItemIdx = 0;
        this.iMenuPosY = Defines.HEIGHT - this.iMenuSize * Resources.iMiddleSizeH + (this.iMenuSize - 1) * this.iMenuSpcY >> 1;
    }

    public void animateToNextMode(int nextMode) {
        this.nextMode = nextMode;
        this.mode = nextMode;
    }

    public void update(long tick) {
        switch (this.mode) {
            case 0: {
                Resources.loadMenuResources();
                this.calculateMenuVar();
                Resources.loadInitialResources();
                this.animateToNextMode(1);
                this.canvas.repaint();
                X.soundManager.Stop();
                X.soundManager.Play(X.MUSIC_MENU_ID, -1);
                break;
            }
            case 1: {
                this.canvas.repaint();
                break;
            }
            case 2: {
                this.canvas.repaint();
                break;
            }
            case 3: {
                this.canvas.repaint();
                break;
            }
            case 4: {
                this.canvas.repaint();
            }
        }
    }

    public void paint(Graphics g) {
        Resources.paintBackground(g);
        switch (this.mode) {
            case 0: {
                break;
            }
            case 1: {
                this.paintMenu(g);
                break;
            }
            case 2: {
                this.paintMenu(g);
                Resources.paintRightButton(1, g);
                break;
            }
            case 3: {
                this.paintMenu(g);
                Resources.paintRightButton(1, g);
                break;
            }
            case 4: {
                this.paintMenu(g);
                Resources.paintLeftButton(0, g);
                Resources.paintRightButton(2, g);
                break;
            }
            case 5: {
                this.paintInstructions(g);
                break;
            }
            case 6: {
                break;
            }
        }
    }

    public void paintMenu(Graphics g) {
        for (int i = 0; i < this.iMenuSize; ++i) {
            if (this.iMenuItemIdx == i) {
                Resources.paintMenuItem(this.iMenuPosY + i * (Resources.iMiddleSizeH + this.iMenuSpcY), this.vecMenuItem.elementAt(i).toString(), true, g);
                continue;
            }
            Resources.paintMenuItem(this.iMenuPosY + i * (Resources.iMiddleSizeH + this.iMenuSpcY), this.vecMenuItem.elementAt(i).toString(), false, g);
        }
    }

    public void paintInstructions(Graphics g) {
        int iWindowPosY = Defines.HEIGHT - Resources.iWindowH >> 1;
        Resources.paintWindow(iWindowPosY, g);
        Resources.paintText(g, iWindowPosY + Resources.iMenuItmH);
        Resources.paintRightButton(1, g);
    }

    public void invokeGameMenu() {
    }

    public void keyPressed(int keyCode) {
        switch (this.mode) {
            case 0: {
                break;
            }
            case 1: {
                if (Keys.key_up) {
                    if (--this.iMenuItemIdx < 0) {
                        this.iMenuItemIdx = this.iMenuSize - 1;
                    }
                } else if (Keys.key_down) {
                    if (++this.iMenuItemIdx > this.iMenuSize - 1) {
                        this.iMenuItemIdx = 0;
                    }
                } else if (Keys.key_fire) {
                    if (this.iMenuItemIdx == 0) {
                        if (Common.recordStoreExists("quick")) {
                            this.iMenuItemIdx = 0;
                            this.createContinueMenu();
                            this.mode = 2;
                        } else {
                            ScreenGame.restHelp();
                            X.soundManager.Stop();
                            MainCanvas.scrGame = new ScreenGame(this.canvas, 0);
                            MainCanvas.activeScreen = MainCanvas.scrGame;
                            MainCanvas.scrMenu = null;
                            System.gc();
                            return;
                        }
                    }
                    if (this.iMenuItemIdx == 1) {
                        if (Common.recordStoreExists("career")) {
                            this.iMenuItemIdx = 0;
                            this.createContinueMenu();
                            this.mode = 3;
                        } else {
                            ScreenGame.restHelp();
                            X.soundManager.Stop();
                            MainCanvas.scrGame = new ScreenGame(this.canvas, 1);
                            MainCanvas.activeScreen = MainCanvas.scrGame;
                            MainCanvas.scrMenu = null;
                            System.gc();
                            return;
                        }
                    }
                    if (this.iMenuItemIdx == 3) {
                        this.mode = 4;
                        this.createOtionsMenu();
                    }
                    if (this.iMenuItemIdx == 2) {
                        Resources.prepareText(X.texts.getHashedString("INSTRUCTIONS_TEXT").toUpperCase());
                        this.mode = 5;
                    }
                    if (this.iMenuItemIdx == 4) {
                        X.singleton.startScoreCanvas(true);
                    }
                    if (this.iMenuItemIdx == 5) {
                        X.quitApp();
                        return;
                    }
                }
                this.canvas.repaint();
                break;
            }
            case 2: {
                if (Keys.key_up) {
                    if (--this.iMenuItemIdx < 0) {
                        this.iMenuItemIdx = this.iMenuSize - 1;
                    }
                } else if (Keys.key_down) {
                    if (++this.iMenuItemIdx > this.iMenuSize - 1) {
                        this.iMenuItemIdx = 0;
                    }
                } else {
                    if (Keys.key_fire) {
                        boolean bContinue;
                        boolean bl = bContinue = this.iMenuItemIdx == 0;
                        if (!bContinue) {
                            Common.deleteRecordStore("quick");
                        }
                        X.soundManager.Stop();
                        MainCanvas.scrGame = new ScreenGame(this.canvas, 0);
                        MainCanvas.scrGame.bContinue = bContinue;
                        MainCanvas.activeScreen = MainCanvas.scrGame;
                        MainCanvas.scrMenu = null;
                        System.gc();
                        return;
                    }
                    if (Keys.key_fn2) {
                        this.callMainMenu();
                    }
                }
                this.canvas.repaint();
                break;
            }
            case 3: {
                if (Keys.key_up) {
                    if (--this.iMenuItemIdx < 0) {
                        this.iMenuItemIdx = this.iMenuSize - 1;
                    }
                } else if (Keys.key_down) {
                    if (++this.iMenuItemIdx > this.iMenuSize - 1) {
                        this.iMenuItemIdx = 0;
                    }
                } else {
                    if (Keys.key_fire) {
                        boolean bContinue;
                        boolean bl = bContinue = this.iMenuItemIdx == 0;
                        if (!bContinue) {
                            Common.deleteRecordStore("career");
                        }
                        X.soundManager.Stop();
                        MainCanvas.scrGame = new ScreenGame(this.canvas, 1);
                        MainCanvas.scrGame.bContinue = bContinue;
                        MainCanvas.activeScreen = MainCanvas.scrGame;
                        MainCanvas.scrMenu = null;
                        System.gc();
                        return;
                    }
                    if (Keys.key_fn2) {
                        this.callMainMenu();
                    }
                }
                this.canvas.repaint();
                break;
            }
            case 4: {
                if (Keys.key_up) {
                    if (--this.iMenuItemIdx < 0) {
                        this.iMenuItemIdx = this.iMenuSize - 1;
                    }
                } else if (Keys.key_down) {
                    if (++this.iMenuItemIdx > this.iMenuSize - 1) {
                        this.iMenuItemIdx = 0;
                    }
                } else if (Keys.key_fire) {
                    if (this.iMenuItemIdx == 0) {
                        boolean bl = Settings.bVibration = !Settings.bVibration;
                        if (!Settings.bVibration) {
                            this.vecMenuItem.setElementAt(X.texts.getHashedString("VIBRATIONS").toUpperCase() + " OFF", 0);
                        } else {
                            this.vecMenuItem.setElementAt(X.texts.getHashedString("VIBRATIONS").toUpperCase() + " ON", 0);
                        }
                    }
                    if (this.iMenuItemIdx == 1) {
                        boolean bl = Settings.bMusic = !Settings.bMusic;
                        if (!Settings.bMusic) {
                            X.soundManager.SetSoundOn(false);
                            X.soundManager.Stop();
                            this.vecMenuItem.setElementAt(X.texts.getHashedString("SOUNDS").toUpperCase() + " OFF", 1);
                        } else {
                            X.soundManager.Stop();
                            X.soundManager.SetSoundOn(true);
                            X.soundManager.Play(X.MUSIC_MENU_ID, -1);
                            this.vecMenuItem.setElementAt(X.texts.getHashedString("SOUNDS").toUpperCase() + " ON", 1);
                        }
                    }
                } else if (Keys.key_fn1) {
                    Settings.saveSettings();
                    if (Settings.bMusic) {
                        X.soundManager.SetSoundOn(true);
                        X.soundManager.Play(X.MUSIC_MENU_ID, -1);
                    } else {
                        X.soundManager.SetSoundOn(false);
                        X.soundManager.Stop();
                    }
                    this.callMainMenu();
                } else if (Keys.key_fn2) {
                    Settings.loadSettings();
                    if (Settings.bMusic) {
                        X.soundManager.SetSoundOn(true);
                        X.soundManager.Play(X.MUSIC_MENU_ID, -1);
                    } else {
                        X.soundManager.SetSoundOn(false);
                        X.soundManager.Stop();
                    }
                    this.callMainMenu();
                }
                this.canvas.repaint();
                break;
            }
            case 5: {
                if (Keys.key_fn2) {
                    this.mode = 1;
                }
                if (Keys.key_down) {
                    Resources.scrollTextDown();
                }
                if (Keys.key_up) {
                    Resources.scrollTextUp();
                }
                this.canvas.repaint();
                break;
            }
            case 6: {
                if (Keys.key_fn2) {
                    this.mode = 1;
                }
                this.canvas.repaint();
            }
        }
    }

    public void keyReleased(int keyCode) {
    }

    public void pointerDragged(int x, int y) {
        switch (this.mode) {
            case 5: {
                if (!Resources.dragText(y)) break;
                this.canvas.repaint();
            }
        }
    }

    public void pointerPressed(int x, int y) {
        switch (this.mode) {
            case 5: {
                Resources.pickText(y);
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (Resources.isLeftSoftButton(x, y)) {
            Keys.key_fn1 = true;
            this.keyPressed(Keys.iLeftKey);
            Keys.key_fn1 = false;
            return;
        }
        if (Resources.isRightSoftButton(x, y)) {
            Keys.key_fn2 = true;
            this.keyPressed(Keys.iRightKey);
            Keys.key_fn2 = false;
            return;
        }
        switch (this.mode) {
            case 1: {
                this.pressButton(this.getSelectedMenuItem(x, y));
                break;
            }
            case 4: {
                this.pressButton(this.getSelectedMenuItem(x, y));
                break;
            }
            case 2: {
                this.pressButton(this.getSelectedMenuItem(x, y));
                break;
            }
            case 3: {
                this.pressButton(this.getSelectedMenuItem(x, y));
                break;
            }
        }
    }

    public int getSelectedMenuItem(int x, int y) {
        int iMenuY1 = this.iMenuPosY;
        int iMenuY2 = this.iMenuPosY + this.iMenuSize * (Resources.iMiddleSizeH + this.iMenuSpcY);
        int iSelectedItem = -1;
        if (y > iMenuY1 && y < iMenuY2) {
            iSelectedItem = (y - iMenuY1) / (Resources.iMiddleSizeH + this.iMenuSpcY);
        }
        return iSelectedItem;
    }

    public void pressButton(int idx) {
        if (idx == -1) {
            return;
        }
        this.iMenuItemIdx = idx;
        if (idx == this.iOldItem) {
            Keys.key_fire = true;
            this.keyPressed(8);
            Keys.key_fire = false;
        } else {
            this.iOldItem = idx;
        }
    }
}

