/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Robot {
    public static Robot sInstance = null;
    public static final int[] iRaysColors = new int[]{16711170, 16690878, 16671234};
    public static final int ARMS_IDLE = 0;
    public static final int ARMS_PULL_OUT = 1;
    public static final int ARMS_PULL_IN = 2;
    static int UFO_COCPIT_DIFF = 0;
    static int ANIMAL_IN_RAY = 0;
    static int ROBOT_TRUNK_DIFF_Y = 0;
    static int ROBOT_GEARS_REAR_X = 0;
    static int ROBOT_GEARS_REAR_Y = 0;
    static int ROBOT_GEARS_FRONT_X = 0;
    static int ROBOT_GEARS_FRONT_Y = 0;
    static int ROBOT_ARMS_A_X = 0;
    static int ROBOT_ARMS_A_Y = 0;
    static int ROBOT_ARMS_L_X = 0;
    static int ROBOT_ARMS_R_X = 0;
    static int ROBOT_ARMS_C_X = 0;
    static int ROBOT_MIDDLE_ARMS_DIFF_Y = 0;
    static int ROBOT_MIDDLE_ARMS_CLIP = 0;
    static int ROBOT_HEAD_X = 0;
    static int ROBOT_HEAD_Y = 0;
    static int WIDTH_ROBOT = 0;
    static int HEIGHT_ROBOT = 0;
    final int DSPY_ARMS_C;
    private int robotPowerUpFrameIdx;
    public int iPosY;
    public int iCocpitFrame = 0;
    public int iCocpitFrameInc = 0;
    private int iBlockPos;
    private int iRealBlockPos;
    private static int iLevitationY = 0;
    private static int iLevitationInc = 1;
    private GameStateCommon gssCommon = GameStateCommon.CreateInstance();
    private static int iRotatorFrame = 0;

    public static void setRobotResolution(int w, int h) {
        if (w == 128 && h == 160) {
            UFO_COCPIT_DIFF = 1;
            HEIGHT_ROBOT = 15;
            ANIMAL_IN_RAY = 10;
        }
        if (w == 176 && h == 220) {
            UFO_COCPIT_DIFF = 5;
            HEIGHT_ROBOT = 20;
            ANIMAL_IN_RAY = 7;
        }
        if (w == 240 && h == 320) {
            UFO_COCPIT_DIFF = 10;
            HEIGHT_ROBOT = 30;
            ANIMAL_IN_RAY = 8;
        }
        if (w == 360 && h == 640) {
            UFO_COCPIT_DIFF = 15;
            HEIGHT_ROBOT = 80;
            ANIMAL_IN_RAY = 0;
        }
        if (w == 480 && h == 800) {
            UFO_COCPIT_DIFF = 22;
            HEIGHT_ROBOT = 80;
            ANIMAL_IN_RAY = 30;
        }
    }

    public static Robot CreateInstance() {
        if (sInstance != null) {
            return sInstance;
        }
        sInstance = new Robot();
        return sInstance;
    }

    public static void ReleaseInstance() {
        if (sInstance == null) {
            return;
        }
        sInstance.release();
        sInstance = null;
        System.gc();
    }

    Robot() {
        this.DSPY_ARMS_C = 3;
        this.gssCommon.initData();
        this.robotPowerUpFrameIdx = 0;
        this.iPosY = Defines.HEIGHT - HEIGHT_ROBOT - 8;
    }

    public void loadResources() {
        GameStateCommon gssCommon = GameStateCommon.sInstance;
        Resources.loadUfoResources();
    }

    public void release() {
        Resources.releaseRobotResources();
    }

    public void update() {
        Blocks blocks = Blocks.sInstance;
        GameStateCommon gssCommon = GameStateCommon.sInstance;
        if (gssCommon.iMoveProgress > 0) {
            gssCommon.iMoveProgress = gssCommon.iMoveProgress - (gssCommon.iBatteryPower > 0 ? gssCommon.iGearsSpeed : gssCommon.iGearsSpeed / 4);
            if (gssCommon.iMoveProgress < 0) {
                gssCommon.iMoveProgress = 0;
            }
        }
        if (gssCommon.iArmsState == 1) {
            if (gssCommon.iArmsElevation < 100) {
                gssCommon.iArmsElevation += gssCommon.iArmsSpeed;
                if (gssCommon.iArmsElevation > 100) {
                    gssCommon.iArmsElevation = 100;
                }
            } else {
                blocks.manipulateBlocks(gssCommon.iRobotPosIdx);
                gssCommon.iArmsState = 2;
            }
        }
        if (gssCommon.iArmsState == 2) {
            if (gssCommon.iArmsElevation > 0) {
                gssCommon.iArmsElevation -= 2 * gssCommon.iArmsSpeed;
            } else {
                gssCommon.iArmsState = 0;
            }
        }
        this.updateCocpitMovement();
        this.updateLevitation();
    }

    public void upadeRotator() {
        if (this.gssCommon.iRotator == 0) {
            return;
        }
        if (++iRotatorFrame > 7) {
            iRotatorFrame = 0;
        }
    }

    public void updateLevitation() {
        if (Math.abs(iLevitationY += iLevitationInc) == 4) {
            iLevitationInc *= -1;
        }
    }

    public void updateCocpitMovement() {
        this.upadeRotator();
        if (this.gssCommon.iMoveProgress == 0) {
            this.iCocpitFrameInc = 0;
            this.iCocpitFrame = 0;
            return;
        }
        if (this.gssCommon.iMoveProgress < 75) {
            this.iCocpitFrameInc = 1;
        }
    }

    public int getPosX() {
        Blocks blocks = Blocks.sInstance;
        int iScale = blocks.iBlockWidth;
        int iRetVal = this.gssCommon.iRobotPosIdx * iScale + 1;
        iRetVal = this.gssCommon.iMoveDirection == 3 ? (iRetVal += Common.barValue(this.gssCommon.iMoveProgress, 100, iScale)) : (iRetVal -= Common.barValue(this.gssCommon.iMoveProgress, 100, iScale));
        return iRetVal + Blocks.DSPY_BLOCK_X_SHIFT;
    }

    public int getPosY() {
        return Defines.HEIGHT - this.iPosY;
    }

    public void paint(Graphics g) {
        int iRealArmPosY;
        Blocks blocks = Blocks.sInstance;
        int iPosX = this.getPosX();
        int iDiffX = Resources.sprUfoRotator.getWidth() - blocks.iBlockWidth >> 1;
        int iCocpitPosX = Resources.sprUfoRotator.getWidth() - Resources.sprUfoCocpit.getWidth() >> 1;
        int iCocpitH = Resources.sprUfoCocpit.getHeight();
        int iArmsPosY = this.iPosY + 2;
        int iLaserPosYInit = iRealArmPosY = Defines.HEIGHT - this.iPosY - UFO_COCPIT_DIFF + 4;
        int iPickedBlocksCnt = Arrays.intsInArray(blocks.iaPickedBlocks);
        int iBlocksHeight = iPickedBlocksCnt > 0 ? blocks.iBlockHeight + (iPickedBlocksCnt - 1) * blocks.getBlockHeightWShift() : 0;
        int iArmsPosYMax = iArmsPosY - iBlocksHeight;
        int iBottomPartLaserY = 0;
        int iLaserPosX = Resources.sprUfoRotator.getWidth() - Resources.sprUfoLaser.getWidth() >> 1;
        if (this.gssCommon.iArmsState != 0) {
            int iLaserLength = Common.barValue(this.gssCommon.iArmsElevation, 100, this.iRealBlockPos - iRealArmPosY - blocks.iBlockHeight);
            iRealArmPosY += iLaserLength;
            int iArmsLength = Common.barValue(this.gssCommon.iArmsElevation, 100, iArmsPosY - this.iBlockPos);
            iArmsPosY -= iArmsLength;
            g.setColor(iRaysColors[this.gssCommon.iLaser]);
            if (this.gssCommon.iArmsElevation >= 0) {
                g.fillRect(iPosX + iLaserPosX - iDiffX, iLaserPosYInit, Resources.iLaserW, iRealArmPosY);
                Resources.sprUfoLaser.setFrame(this.gssCommon.iLaser << 1);
                Resources.sprUfoLaser.setPosition(iPosX + iLaserPosX - iDiffX, iLaserPosYInit + iRealArmPosY);
                Resources.sprUfoLaser.paint(g);
                iBottomPartLaserY = iLaserPosYInit + iRealArmPosY;
            }
        } else if (iBlocksHeight != 0) {
            int iDiffY = blocks.iBlockHeight - blocks.getBlockHeightWShift() - ANIMAL_IN_RAY;
            g.setColor(iRaysColors[this.gssCommon.iLaser]);
            g.fillRect(iPosX + iLaserPosX - iDiffX, iLaserPosYInit, Resources.iLaserW, iLaserPosYInit + iRealArmPosY);
            Resources.sprUfoLaser.setFrame(this.gssCommon.iLaser << 1);
            Resources.sprUfoLaser.setPosition(iPosX + iLaserPosX - iDiffX, (iLaserPosYInit << 1) + iRealArmPosY);
            Resources.sprUfoLaser.paint(g);
            iBottomPartLaserY = iLaserPosYInit + iRealArmPosY + Resources.sprUfoLaser.getHeight() + iLevitationY + iDiffY;
        }
        if (this.gssCommon.bonusTakenTime > 0) {
            Resources.sprTakeBonus.setFrame(this.gssCommon.bonusTakenTime % 3);
            Resources.sprTakeBonus.setPosition(iPosX - 2, Defines.HEIGHT - this.iPosY - 11);
            Resources.sprTakeBonus.paint(g);
            --this.gssCommon.bonusTakenTime;
        }
        if (iPickedBlocksCnt > 0 && iArmsPosY > iArmsPosYMax) {
            iArmsPosY = iArmsPosYMax;
            if (this.gssCommon.iArmsState == 2) {
                this.gssCommon.iArmsState = 0;
            }
        }
        if (iPickedBlocksCnt > 0) {
            for (int i = iPickedBlocksCnt - 1; i >= 0; --i) {
                blocks.paintBlock(g, Arrays.intInArray(blocks.iaPickedBlocks, i), iPosX - 1, iBottomPartLaserY - (i - 1) * blocks.getBlockHeightWShift() - blocks.iBlockHeight, false, false);
            }
        }
        Resources.sprUfoRotator.setFrame((this.gssCommon.iRotator << 1) - (iRotatorFrame >> 2));
        Resources.sprUfoRotator.setPosition(iPosX - iDiffX, Defines.HEIGHT - this.iPosY - UFO_COCPIT_DIFF - 2);
        Resources.sprUfoRotator.paint(g);
        Resources.sprUfoCocpit.setFrame(this.gssCommon.iCocpit * 5 + this.iCocpitFrame + this.iCocpitFrameInc);
        Resources.sprUfoCocpit.setPosition(iPosX + iCocpitPosX - iDiffX, Defines.HEIGHT - this.iPosY - iCocpitH);
        Resources.sprUfoCocpit.paint(g);
    }

    public void keyPressed(int keyCode) {
        Blocks blocks = Blocks.sInstance;
        if (Keys.key_left && this.gssCommon.iMoveProgress == 0 && this.gssCommon.iArmsState != 1 && this.gssCommon.iRobotPosIdx > -1) {
            if (this.gssCommon.iRobotPosIdx == 0) {
                this.gssCommon.iRobotPosIdx = 7;
            }
            --this.gssCommon.iRobotPosIdx;
            this.gssCommon.iMoveProgress = 100;
            this.gssCommon.iMoveDirection = 3;
            this.gssCommon.iHeadAngleDest = -8;
            this.iCocpitFrame = 3;
        }
        if (Keys.key_right && this.gssCommon.iMoveProgress == 0 && this.gssCommon.iArmsState != 1 && this.gssCommon.iRobotPosIdx < 7) {
            if (this.gssCommon.iRobotPosIdx == 6) {
                this.gssCommon.iRobotPosIdx = -1;
            }
            ++this.gssCommon.iRobotPosIdx;
            this.gssCommon.iMoveProgress = 100;
            this.gssCommon.iMoveDirection = 2;
            this.gssCommon.iHeadAngleDest = 8;
            this.iCocpitFrame = 1;
        }
        if (Keys.key_fire && this.gssCommon.iArmsState == 0) {
            int iPickedBlocksCnt;
            this.gssCommon.iHeadAngleDest = 0;
            if (this.gssCommon.iBonusPowerUpTime == 0) {
                // empty if block
            }
            if ((iPickedBlocksCnt = Arrays.intsInArray(blocks.iaPickedBlocks)) > 0 && !blocks.canDropBlocks(this.gssCommon.iRobotPosIdx)) {
                return;
            }
            this.gssCommon.iArmsState = 1;
            int iBlocksHeight = iPickedBlocksCnt > 0 ? blocks.iBlockHeight + (iPickedBlocksCnt - 1) * blocks.getBlockHeightWShift() : 0;
            this.iBlockPos = blocks.getLastBlockPos(this.gssCommon.iRobotPosIdx);
            this.iRealBlockPos = Defines.HEIGHT - this.iBlockPos - blocks.getBlockHeightWShift() - Resources.sprUfoLaser.getHeight();
            this.gssCommon.iArmsElevation = Common.barValue(iBlocksHeight, this.iBlockPos, 100);
        }
    }
}

