/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class GameStateCareer {
    public static GameStateCareer sInstance = null;
    private final int TOTAL_LEVELS;
    public int iCredits;
    public int[] iMapLevel = new int[]{-2, -2, -2};
    public int iMapSelIdx;

    public static GameStateCareer CreateInstance() {
        if (sInstance != null) {
            return sInstance;
        }
        sInstance = new GameStateCareer();
        return sInstance;
    }

    public static void ReleaseInstance() {
        if (sInstance == null) {
            return;
        }
        sInstance = null;
        System.gc();
    }

    GameStateCareer() {
        this.TOTAL_LEVELS = 60;
        this.defaultData();
    }

    public int getCreditsForLevel() {
        switch (this.iMapSelIdx) {
            case 0: {
                return 100 + this.iMapLevel[0] * 200;
            }
            case 1: {
                return 1000 + this.iMapLevel[1] * 200;
            }
            case 2: {
                return 2000 + this.iMapLevel[2] * 200;
            }
        }
        return 0;
    }

    private void defaultData() {
        this.iCredits = 0;
        this.iMapSelIdx = 0;
        this.iMapLevel[0] = -2;
        this.iMapLevel[1] = -2;
        this.iMapLevel[2] = -2;
    }

    public void loadData(DataInputStream data) throws IOException {
        try {
            this.iCredits = data.readInt();
            for (int i = 0; i < 3; ++i) {
                this.iMapLevel[i] = data.readInt();
            }
            this.iMapSelIdx = data.readInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveData(DataOutputStream data) throws IOException {
        try {
            data.writeInt(this.iCredits);
            for (int i = 0; i < 3; ++i) {
                data.writeInt(this.iMapLevel[i]);
            }
            data.writeInt(this.iMapSelIdx);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

