/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class ScreenGame
implements IScreen {
    static final int MODE_LOADING_RES = 0;
    static final int MODE_PLAYING = 1;
    static final int MODE_LEVEL_DONE = 2;
    static final int MODE_GAME_OVER = 3;
    static final int MODE_LOADING_STAGE_RES = 4;
    static final int MODE_DEMO_OVER = 5;
    static boolean bPointerPushed = false;
    private Canvas canvas;
    private int mode;
    private int iGameType;
    public boolean bContinue;
    static int iSinY = 0;
    static int iIncY = 1;
    static boolean bMoveLeft = true;
    static boolean bMoveRight = true;
    static boolean bMoveFire = true;
    static boolean bMenuPress = true;
    static long T1 = 0L;
    static long T2 = -1L;
    static int iTick = 0;
    static int iStartPosY = 0;
    Level level;

    ScreenGame(Canvas canvas, int iGameType) {
        Debug.traceIn("> ScreenGame.ScreenGame()");
        this.canvas = canvas;
        this.iGameType = iGameType;
        this.bContinue = false;
        bPointerPushed = false;
        this.mode = 0;
        Debug.traceOut("< ScreenGame.ScreenGame()");
    }

    public int getActualMode() {
        return this.mode;
    }

    public String getActualModeName() {
        return "Screen game";
    }

    public static void restHelp() {
        bMoveLeft = true;
        bMoveRight = true;
        bMoveFire = true;
        bMenuPress = true;
        T1 = 0L;
        T2 = -1L;
        iTick = 0;
    }

    private void release() {
        Debug.traceIn("> ScreenGame.release()");
        Resources.releaseGameResources();
        System.gc();
        Debug.traceOut("< ScreenGame.release()");
    }

    public void update(long tick) {
        switch (this.mode) {
            case 0: {
                Debug.traceIn("> ScreenGame.update(MODE_LOADING_RES)");
                Resources.loadGameResources();
                this.level = Level.CreateInstance(this.iGameType);
                if (this.bContinue) {
                    this.level.loadGame();
                } else {
                    this.level.newGame();
                }
                Resources.loadStageBackground(GameStateCommon.sInstance.iStage);
                Robot.sInstance.loadResources();
                Blocks.sInstance.loadResources();
                this.mode = 1;
                this.canvas.repaint();
                Debug.traceOut("< ScreenGame.update(MODE_LOADING_RES)");
                break;
            }
            case 1: {
                if (iTick <= 8) {
                    T1 = System.currentTimeMillis() / 1000L;
                    if (T1 != T2) {
                        T2 = T1;
                        ++iTick;
                    }
                } else {
                    bMenuPress = false;
                }
                this.level.update();
                if (this.level.failed()) {
                    X.soundManager.Play(X.SOUND_FAILED_ID, 1);
                    this.mode = 3;
                    this.canvas.repaint();
                    return;
                }
                if (this.level.completed()) {
                    X.soundManager.Play(X.SOUND_COMPLETED_ID, 1);
                    this.mode = 2;
                }
                if (Math.abs(iSinY += iIncY) == 8) {
                    iIncY *= -1;
                }
                this.canvas.repaint();
                break;
            }
            case 4: {
                Resources.releaseBlocksResources();
                Resources.releaseRobotResources();
                Resources.loadStageBackground(GameStateCommon.sInstance.iStage);
                Resources.loadBlocksResources(GameStateCommon.sInstance.iStage);
                Resources.loadUfoResources();
                this.mode = 1;
                this.canvas.repaint();
            }
        }
    }

    public void invokeGameMenu() {
        if (this.mode == 1) {
            this.level.saveGame();
            MainCanvas.scrMenu = new ScreenMenu(this.canvas);
            MainCanvas.activeScreen = MainCanvas.scrMenu;
            MainCanvas.scrGame = null;
            Level.ReleaseInstance();
            this.release();
            System.gc();
            Resources.imgBackground = Common.createImage(MainCanvas.strResolution + "s.png");
            this.canvas.repaint();
        }
    }

    public void keyPressed(int keyCode) {
        switch (this.mode) {
            case 1: {
                Robot.sInstance.keyPressed(keyCode);
                if (!Keys.key_fn2) break;
                this.level.saveGame();
                MainCanvas.scrMenu = new ScreenMenu(this.canvas);
                MainCanvas.activeScreen = MainCanvas.scrMenu;
                MainCanvas.scrGame = null;
                Level.ReleaseInstance();
                this.release();
                System.gc();
                Resources.imgBackground = Common.createImage(MainCanvas.strResolution + "s.png");
                this.canvas.repaint();
                break;
            }
            case 2: {
                if (!Keys.key_fire && !Keys.key_fn2) break;
                if (this.iGameType == 0) {
                    this.mode = 1;
                    if (this.level.nextLevelQuickGame()) {
                        this.mode = 4;
                    }
                    this.level.saveGame();
                    break;
                }
                this.level.saveGame();
                MainCanvas.scrMap = new ScreenMap(this.canvas);
                MainCanvas.activeScreen = MainCanvas.scrMap;
                MainCanvas.scrGame = null;
                Resources.releaseRobotResources();
                Resources.releaseBlocksResources();
                System.gc();
                break;
            }
            case 3: {
                if (!Keys.key_fire && !Keys.key_fn2) break;
                if (this.iGameType == 0) {
                    int playerScore = GameStateCommon.sInstance.iScore;
                    Common.deleteRecordStore("quick");
                    MainCanvas.scrMenu = new ScreenMenu(this.canvas);
                    MainCanvas.activeScreen = MainCanvas.scrMenu;
                    MainCanvas.scrGame = null;
                    Level.ReleaseInstance();
                    this.release();
                    System.gc();
                    Resources.imgBackground = Common.createImage(MainCanvas.strResolution + "s.png");
                    X.singleton.startScoreCanvas(false);
                    if (X.scoreCanvas.isScoreForTable(playerScore)) {
                        X.singleton.startScoreCanvas(true);
                        X.scoreCanvas.prepareForGetNewName(playerScore);
                    } else {
                        X.singleton.stopScoreCanvas();
                    }
                    this.canvas.repaint();
                } else {
                    this.level.saveGame();
                    Resources.releaseRobotResources();
                    Resources.releaseBlocksResources();
                    MainCanvas.scrMap = new ScreenMap(this.canvas);
                    MainCanvas.activeScreen = MainCanvas.scrMap;
                    MainCanvas.scrGame = null;
                }
                System.gc();
            }
        }
    }

    public void keyReleased(int keyCode) {
    }

    public void paint(Graphics g) {
        String str = "";
        switch (this.mode) {
            case 0: {
                g.setColor(0);
                g.fillRect(0, 0, Defines.HEIGHT, Defines.WIDTH);
                g.setColor(0xFFFFFF);
                Fonts.drawCenterString(X.texts.getHashedString("PLEASE_WAIT"), Defines.HEIGHT - 1, g, this.canvas);
                break;
            }
            case 1: {
                this.level.paint(g);
                Resources.paintRightButton(3, g);
                break;
            }
            case 5: {
                break;
            }
            case 2: {
                this.level.paint(g);
                Resources.paintWindow(Defines.HEIGHT - Resources.iWindowH >> 1, g);
                if (this.iGameType == 0) {
                    str = X.texts.getHashedString("LEVEL") + " " + (GameStateCommon.sInstance.iLevel + 1) + " " + X.texts.getHashedString("COMPLETED");
                    Resources.prepareText(str);
                } else {
                    str = X.texts.getHashedString("ORDER_COMPLETED");
                    Resources.prepareText(str);
                }
                int iTextPosY = Defines.HEIGHT - (Resources.textVec.size() - 2) * Fonts.iFontHeight >> 1;
                Resources.paintText(g, iTextPosY);
                Resources.paintRightButton(0, g);
                break;
            }
            case 3: {
                this.level.paint(g);
                int iWindowPosY = Defines.HEIGHT - Resources.iWindowH >> 1;
                Resources.paintWindow(iWindowPosY, g);
                Resources.paintRightButton(0, g);
                str = this.iGameType == 0 ? X.texts.getHashedString("GAME_OVER") : X.texts.getHashedString("ORDER_INCOMPLETED");
                Resources.prepareText(str);
                Resources.paintText(g, Defines.HEIGHT - (Resources.textVec.size() - 2) * Fonts.iFontHeight >> 1);
            }
        }
    }

    private boolean isInMenuBtn(int pointerX, int pointerY) {
        int h = Resources.sprBtnsEnds.getHeight();
        return pointerY > 0 && pointerY < h && pointerX > 0 && pointerX < Defines.WIDTH;
    }

    private boolean bUfoMove(int x, int y, boolean left) {
        if (y >= 0 && y < Robot.sInstance.getPosY() + (Resources.sprUfoRotator.getHeight() << 2)) {
            if (x > 0 && x < Robot.sInstance.getPosX() && left) {
                return true;
            }
            if (x > Robot.sInstance.getPosX() + Robot.WIDTH_ROBOT && x < Defines.WIDTH && !left) {
                return true;
            }
        }
        return false;
    }

    public void pointerDragged(int x, int y) {
        switch (this.mode) {
            case 1: {
                if (Math.abs(y - iStartPosY) < Blocks.sInstance.iBlockHeight) {
                    return;
                }
                if (y > iStartPosY) {
                    Keys.key_fire = true;
                    Robot.sInstance.keyPressed(8);
                    Keys.key_fire = false;
                    bMoveFire = false;
                    break;
                }
                if (y >= iStartPosY) break;
                Keys.key_num0 = true;
            }
        }
    }

    public void pointerPressed(int x, int y) {
        switch (this.mode) {
            case 1: {
                iStartPosY = y;
            }
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this.mode) {
            case 1: {
                if (Resources.isRightSoftButton(x, y)) {
                    Keys.key_fn2 = true;
                    this.keyPressed(Keys.iRightKey);
                    Keys.key_fn2 = false;
                    return;
                }
                if (this.bUfoMove(x, y, true)) {
                    Keys.key_left = true;
                    Robot.sInstance.keyPressed(2);
                    Keys.key_left = false;
                    bMoveLeft = false;
                }
                if (!this.bUfoMove(x, y, false)) break;
                Keys.key_right = true;
                Robot.sInstance.keyPressed(5);
                Keys.key_right = false;
                bMoveRight = false;
                break;
            }
            case 2: 
            case 3: {
                Keys.key_fire = true;
                this.keyPressed(8);
                Keys.key_fire = false;
            }
        }
    }
}

