/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class ScoreCanvas
extends GameCanvas
implements Runnable {
    public static final String RMS_SCORE = "S";
    public static final int MODE_EDIT_LENGTH = 8;
    public static final int TABLE_COUNT = 9;
    public static final int TABLE_LOCAL_COUNT = 3;
    public static final int MODE_NONE = -1;
    public static final int MODE_GET_NAME = 0;
    public static final int MODE_GET_NAME_PASS = 1;
    public static final int MODE_SHOW_SCORES = 2;
    public static final int MODE_VERIFY_ACCOUNT = 3;
    public static final int MODE_ENTER_PASS_DLG = 4;
    public static final int MODE_SENDING_SCORE = 5;
    public static final int MODE_ERROR_CONNECT = 6;
    public static final int MODE_WRONG_PASS = 7;
    public static final int MODE_SYNCHRO = 8;
    private static final int EDIT_NAME = 0;
    private static final int EDIT_PASS = 1;
    private Graphics scoreCanvas = null;
    private Thread blinkThread = null;
    private Font font = null;
    private Vector dlgStrings = null;
    private ScoreCanvasRendererInterface renderer = null;
    private StringBuffer name = new StringBuffer();
    private StringBuffer pass = new StringBuffer();
    private boolean blink = false;
    private String chars = null;
    private String gameName = null;
    public int activeEdit = 0;
    private int activeTable = 0;
    private int activeCharIndex = 0;
    private int activeItem = 0;
    private int charOffsetIndex = 0;
    private int countOfTables = 0;
    private int fnKeyLeft = 0;
    private int fnKeyRight = 0;
    public int editBoxHeight = 0;
    public int editNameTextY = 0;
    public int editNameTextX = 0;
    public int editNameColor = 0;
    public int editNameBoxY = 0;
    public int editNameBoxX = 0;
    public int editNameBoxWidth = 0;
    public int editNameMaxChar = 0;
    public int editPassTextY = 0;
    public int editPassTextX = 0;
    public int editPassColor = 0;
    public int editPassBoxY = 0;
    public int editPassBoxX = 0;
    public int editPassBoxWidth = 0;
    public int editPassMaxChar = 0;
    private int mode = 0;
    public int screenWidth = 0;
    public int screenHeight = 0;
    private int scrollOffset = 0;
    public int scrollBarX = 0;
    public int scrollBarY = 0;
    public int scrollBarWidth = 0;
    public int scrollBarColor = 0xFFFFFF;
    private int sizeScrollBox = 0;
    private int stringPos = 0;
    private int tableOffsetY = 5;
    private int tableX = 0;
    private int tableY = 0;
    private int tableWidth = 0;
    private int tableHeight = 0;
    private int stringIdLeftKey = 0;
    private long lastKeyPressTime = 0L;
    private int[][] tableId = null;
    private int[][] tablePos = null;
    private boolean[][] tableIsLocal = null;
    private boolean[][] tableIsSent = null;
    private String[][] tableName = null;
    private String[][] tablePass = null;
    private int[][] tableScore = null;
    private static String lastEditedName = "";
    boolean bLeft = false;
    boolean bRight = false;
    public static int STRING_OK = 0;
    public static int STRING_BACK = 1;
    public static virtualKeyboard vKeyboard = new virtualKeyboard();
    private static String SERVICE_URL = "http://www.inlogic.sk/scoreservice.php?a=";
    private static String SERVICE_RESULT_OK = "ss:OK";
    private static String SERVICE_RESULT_NO = "ss:NO";
    private static String SERVICE_RESULT_ER = "ss:ER";
    private static final String HISCORE_STORE = "HS";
    private int[] RMSId = null;

    private int getLocalCount() {
        int localCount = 0;
        for (int cnt = 8; cnt >= 0; --cnt) {
            if (!this.tableIsLocal[this.activeTable][cnt]) continue;
            ++localCount;
        }
        return localCount;
    }

    public boolean isScoreForTable(int sc) {
        return (this.tableScore[this.activeTable][8] < sc || this.getLocalCount() < 3) && sc > 0;
    }

    public ScoreCanvas(String gameName, ScoreCanvasRendererInterface renderer, Font font, int leftFnKeyCode, int rightFnKeyCode, int countOfTables, int tableX, int tableY, int tableWidth, int tableHeight, int screenWidth, int screenHeight) {
        super(false);
        int i;
        int j;
        this.setFullScreenMode(true);
        this.gameName = gameName;
        this.renderer = renderer;
        this.font = font;
        this.mode = 2;
        this.countOfTables = countOfTables;
        this.tableX = tableX;
        this.tableY = tableY;
        this.tableWidth = tableWidth;
        this.tableHeight = tableHeight;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.stringIdLeftKey = STRING_BACK;
        this.fnKeyLeft = Math.abs(leftFnKeyCode);
        this.fnKeyRight = Math.abs(rightFnKeyCode);
        this.chars = "";
        this.sizeScrollBox = this.getWidth() / 50 * 5;
        this.RMSId = new int[countOfTables];
        this.tableId = new int[countOfTables][9];
        this.tablePos = new int[countOfTables][9];
        this.tableIsLocal = new boolean[countOfTables][9];
        this.tableIsSent = new boolean[countOfTables][9];
        this.tableName = new String[countOfTables][9];
        this.tablePass = new String[countOfTables][9];
        this.tableScore = new int[countOfTables][9];
        for (j = 0; j < countOfTables; ++j) {
            this.RMSId[j] = -1;
            for (i = 0; i < 9; ++i) {
                this.tableId[j][i] = -1;
                this.tablePos[j][i] = i + 1;
                this.tableName[j][i] = "Inlogic";
                this.tablePass[j][i] = "";
                this.tableScore[j][i] = (9 - i) * 200;
                this.tableIsLocal[j][i] = false;
                this.tableIsSent[j][i] = true;
            }
        }
        this.loadRMS();
        j = 1;
        while (j < countOfTables) {
            this.activeTable = j++;
            this.loadRMS();
        }
        this.activeTable = 0;
        this.editBoxHeight = font.getHeight() + renderer.getBorderEditSize() * 2;
        this.setNameTextX(10);
        this.setNameTextY(0);
        this.setPassTextX(10);
        this.setPassTextY(this.editNameBoxY + this.editBoxHeight);
        int endDialogPix = this.editPassBoxY + this.editBoxHeight;
        if (endDialogPix < tableY + tableHeight) {
            i = (tableY + tableHeight - endDialogPix) / 3;
            this.setNameTextY(i);
            this.setPassTextY(2 * i + this.editBoxHeight + font.getHeight());
        }
        this.editNameColor = 0xFFFFFF;
        this.editNameBoxWidth = tableWidth - 2 * this.editNameBoxX;
        this.editPassColor = 0xFFFFFF;
        this.editPassBoxWidth = tableWidth - 2 * this.editPassBoxX;
        this.scrollBarX = this.sizeScrollBox + 2;
        this.scrollBarY = screenHeight - (this.sizeScrollBox << 1) - 2;
        this.scrollBarWidth = screenWidth - (this.sizeScrollBox << 1) - 4;
    }

    public void prepareForGetNewName(int sc) {
        if (this.isScoreForTable(sc)) {
            this.setMode(0);
            this.insertScoreToTable(-1, lastEditedName, "", sc, true, false);
            this.setEditComponents(this.tableName[this.activeTable][this.activeItem], this.tablePass[this.activeTable][this.activeItem], 0);
            this.stringIdLeftKey = STRING_OK;
        }
    }

    public void repaintX() {
        this.scoreCanvas = this.getGraphics();
        this.paintX(this.scoreCanvas);
        this.flushGraphics();
    }

    private void paintX(Graphics g) {
        switch (this.mode) {
            case 0: 
            case 1: {
                this.renderer.paintScoreBackground(g, this);
                g.setFont(this.font);
                this.paintEnterNameComponent(g, this.activeEdit == 0);
                if (this.mode == 1) {
                    g.setFont(this.font);
                    this.paintEnterPassComponent(g, this.activeEdit == 1);
                }
                g.setClip(0, 0, Defines.WIDTH, Defines.HEIGHT);
                Resources.paintLeftButton(0, g);
                Resources.paintRightButton(this.activeCharIndex == 0 ? 1 : 2, g);
                break;
            }
            case 2: {
                this.renderer.paintScoreBackground(g, this);
                this.paintScoreTable(g);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                this.renderer.paintScoreBackground(g, this);
                this.paintDlgTextToCenter(g);
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                this.renderer.paintScoreBackground(g, this);
                this.paintDlgTextToCenter(g);
                g.setClip(this.scrollBarX, this.scrollBarY, this.scrollBarWidth, this.sizeScrollBox);
                boolean yes = true;
                g.setColor(this.scrollBarColor);
                for (int i = 0; i <= this.screenWidth / this.sizeScrollBox; ++i) {
                    if (yes) {
                        g.fillRect(this.sizeScrollBox * i + this.scrollOffset, this.scrollBarY, this.sizeScrollBox, this.sizeScrollBox);
                    }
                    yes = !yes;
                }
                break;
            }
        }
    }

    private void paintScoreTable(Graphics g) {
        int itemWidth = this.tableWidth;
        int itemHeight = this.renderer.getBorderScoreItemSize() * 2 + this.font.getHeight();
        int playerNamePosX = this.renderer.getBorderScoreItemSize() + this.font.stringWidth("999") + 3;
        int y = 0;
        int translateY = 0;
        if (itemHeight * (this.activeItem + 1) > this.tableHeight) {
            translateY += this.tableHeight - itemHeight * (this.activeItem + 1);
        }
        g.translate(this.tableX, this.tableY + translateY);
        g.setFont(this.font);
        g.setClip(0, -translateY, this.tableWidth, this.tableHeight);
        boolean isDots = false;
        boolean noSentButton = false;
        int scoreLength = 0;
        int scorePosX = this.tableWidth - this.renderer.getBorderScoreItemSize() - 3;
        String scoreText = null;
        for (int i = 0; i < 9; ++i) {
            y = itemHeight * i;
            if (!(isDots || i >= 8 || this.tablePos[this.activeTable][i + 1] != -1 && this.tablePos[this.activeTable][i + 1] <= this.tablePos[this.activeTable][i] + 1)) {
                this.renderer.paintBorderScoreItem(g, 0, y, itemWidth, itemHeight, i, false, i == this.activeItem, this);
                g.drawString("...", playerNamePosX, y + this.renderer.getBorderScoreItemSize(), 20);
                isDots = true;
                noSentButton = i == this.activeItem;
                continue;
            }
            this.renderer.paintBorderScoreItem(g, 0, itemHeight * i, itemWidth, itemHeight, i, this.tableIsLocal[this.activeTable][i], i == this.activeItem, this);
            scoreText = String.valueOf(this.tableScore[this.activeTable][i]);
            scoreLength = this.font.stringWidth(scoreText);
            if (this.tablePos[this.activeTable][i] != -1) {
                g.drawString(String.valueOf(this.tablePos[this.activeTable][i]), playerNamePosX - 3, y + this.renderer.getBorderScoreItemSize(), 24);
            }
            g.drawString(this.getPlayerName(this.tableName[this.activeTable][i], scorePosX - scoreLength - playerNamePosX), playerNamePosX, y + this.renderer.getBorderScoreItemSize(), 20);
            g.drawString(scoreText, scorePosX, y + this.renderer.getBorderScoreItemSize(), 24);
        }
        g.translate(-this.tableX, -this.tableY - translateY);
        g.setClip(0, 0, this.screenWidth, this.screenHeight);
        String str = X.texts.getHashedString("SC_BACK");
        if (this.stringIdLeftKey == STRING_OK) {
            str = X.texts.getHashedString("SC_OK");
        }
        Resources.paintLeftButton(1, g);
    }

    public String getPlayerName(String name, int maxWidth) {
        int length = name.length();
        String newName = null;
        for (int i = 0; i < length; ++i) {
            int scoreNameLength;
            newName = name.substring(0, length - i);
            if (i > 0) {
                newName = newName.concat("...");
            }
            if ((scoreNameLength = this.font.stringWidth(newName)) >= maxWidth) continue;
            return newName;
        }
        return name.substring(0, length < 3 ? length : 3);
    }

    private void paintDlgTextToCenter(Graphics g) {
        int y = (this.screenHeight >> 1) - (this.dlgStrings.size() * this.font.getHeight() >> 1);
        g.setFont(this.font);
        for (int i = 0; i < this.dlgStrings.size(); ++i) {
            g.drawString((String)this.dlgStrings.elementAt(i), this.screenWidth >> 1, y, 17);
            y += this.font.getHeight();
        }
    }

    private void paintEnterNameComponent(Graphics g, boolean active) {
        g.setColor(this.editNameColor);
        g.drawString(X.texts.getHashedString("SC_ENTER_NAME"), this.editNameTextX, this.editNameTextY, 20);
        this.renderer.paintBorderEdit(g, this.editNameBoxX, this.editNameBoxY, this.editNameBoxWidth, this.editBoxHeight, this);
        g.drawString(this.name.toString(), this.editNameBoxX + this.renderer.getBorderEditSize(), this.editNameBoxY + this.renderer.getBorderEditSize(), 20);
        if (active && this.blink) {
            int posX = this.editNameBoxX + this.renderer.getBorderEditSize() + this.font.stringWidth(this.name.toString());
            g.drawLine(posX, this.editNameBoxY + this.renderer.getBorderEditSize(), posX, this.editNameBoxY + this.renderer.getBorderEditSize() + this.font.getHeight());
        }
    }

    private void paintEnterPassComponent(Graphics g, boolean active) {
        g.setColor(this.editPassColor);
        g.drawString(X.texts.getHashedString("SC_ENTER_PASS"), this.editPassTextX, this.editPassTextY, 20);
        this.renderer.paintBorderEdit(g, this.editPassBoxX, this.editPassBoxY, this.editPassBoxWidth, this.editBoxHeight, this);
        g.drawString(this.pass.toString(), this.editPassBoxX + this.renderer.getBorderEditSize(), this.editPassBoxY + this.renderer.getBorderEditSize(), 20);
        if (active && this.blink) {
            int posX = this.editPassBoxX + this.renderer.getBorderEditSize() + this.font.stringWidth(this.pass.toString());
            g.drawLine(posX, this.editPassBoxY + this.renderer.getBorderEditSize(), posX, this.editPassBoxY + this.renderer.getBorderEditSize() + this.font.getHeight());
        }
    }

    public void setNameTextY(int y) {
        this.editNameTextY = y;
        this.editNameBoxY = this.editNameTextY + this.font.getHeight();
    }

    public void setNameTextX(int x) {
        this.editNameBoxX = x;
        this.editNameTextX = this.editNameBoxX + this.renderer.getBorderEditSize();
    }

    public void setPassTextY(int y) {
        this.editPassTextY = y;
        this.editPassBoxY = this.editPassTextY + this.font.getHeight();
    }

    public void setPassTextX(int x) {
        this.editPassBoxX = x;
        this.editPassTextX = this.editPassBoxX + this.renderer.getBorderEditSize();
    }

    protected void pointerReleased(int x, int y) {
        if (Resources.isLeftSoftButton(x, y)) {
            this.keyPressed(this.fnKeyLeft);
            return;
        }
        if (Resources.isRightSoftButton(x, y)) {
            this.keyPressed(this.fnKeyRight);
            return;
        }
        VKey.keyReleased();
        switch (this.mode) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (y <= this.tableY || y >= this.tableY + this.tableHeight) break;
                if (y < this.tableY + this.tableHeight >> 1) {
                    this.keyPressed(50);
                }
                if (y <= this.tableY + this.tableHeight >> 1) break;
                this.keyPressed(56);
            }
        }
    }

    protected void pointerPressed(int x, int y) {
        this.chars = null;
        switch (this.mode) {
            case 0: 
            case 1: {
                this.bLeft = false;
                this.bRight = false;
                VKey.keyPressed();
                if (VKey.isVKeyLeft(x, y)) {
                    this.bLeft = true;
                    return;
                }
                if (VKey.isVKeyRight(x, y)) {
                    this.bRight = true;
                    return;
                }
                if (VKey.isVKeySelect(x, y)) {
                    this.chars = VKey.getString();
                    this.charOffsetIndex = 0;
                    this.setCharToComponent(this.activeEdit, true);
                    return;
                }
                this.repaintX();
            }
        }
        this.repaint();
    }

    protected void keyReleased(int keyCode) {
        VKey.keyReleased();
    }

    protected void keyPressed(int keyCode) {
        switch (this.mode) {
            case 0: 
            case 1: {
                int gameAction1 = 9999;
                if (Math.abs(keyCode) != this.fnKeyLeft && Math.abs(keyCode) != this.fnKeyRight) {
                    gameAction1 = this.getGameAction(keyCode);
                }
                if (gameAction1 == 5 || gameAction1 == 54) {
                    this.bLeft = false;
                    this.bRight = false;
                    this.bRight = true;
                }
                if (gameAction1 == 2 || gameAction1 == 52) {
                    this.bLeft = false;
                    this.bRight = false;
                    this.bLeft = true;
                }
                if (gameAction1 == 8 && VKey.canBeAdded()) {
                    this.bLeft = false;
                    this.bRight = false;
                    this.chars = VKey.getString();
                    this.charOffsetIndex = 0;
                    this.setCharToComponent(this.activeEdit, true);
                }
                if (Math.abs(keyCode) == this.fnKeyRight) {
                    if (this.name.length() != 0) {
                        this.removeCharFromComponent(this.activeEdit);
                    }
                    if (this.name.length() == 0) {
                        this.setMode(2);
                        this.repaintX();
                    }
                }
                if (Math.abs(keyCode) == this.fnKeyLeft) {
                    this.setMode(2);
                    this.repaintX();
                }
                VKey.keyPressed();
                if (this.lastKeyPressTime + 500L < System.currentTimeMillis()) {
                    int gameAction = 9999;
                    if (Math.abs(keyCode) != this.fnKeyLeft && Math.abs(keyCode) != this.fnKeyRight) {
                        gameAction = this.getGameAction(keyCode);
                    }
                    if (this.activeCharIndex == 0 && Math.abs(keyCode) == this.fnKeyRight) {
                        this.setMode(2);
                        this.repaintX();
                    } else if ((this.activeCharIndex != 0 || gameAction != 2) && Math.abs(keyCode) != this.fnKeyRight) {
                        if (gameAction == 6) {
                            if (this.mode == 1 && this.activeEdit == 0) {
                                this.setEditComponents(this.name.toString(), this.pass.toString(), 1);
                            }
                        } else if (gameAction == 1) {
                            if (this.mode == 1 && this.activeEdit == 1) {
                                this.setEditComponents(this.name.toString(), this.pass.toString(), 0);
                            }
                        } else if (Math.abs(keyCode) == this.fnKeyLeft) {
                            if (this.mode == 1) {
                                lastEditedName = this.tableName[this.activeTable][this.activeItem];
                                this.sendScore();
                            } else {
                                this.mode = -1;
                                this.tableName[this.activeTable][this.activeItem] = this.name.toString();
                                lastEditedName = this.tableName[this.activeTable][this.activeItem];
                                this.saveRMS();
                                this.setMode(2);
                                this.repaintX();
                            }
                        }
                    }
                }
                this.repaintX();
                this.lastKeyPressTime = System.currentTimeMillis();
                break;
            }
            case 2: {
                int gameAction = 9999;
                if (Math.abs(keyCode) != this.fnKeyLeft && Math.abs(keyCode) != this.fnKeyRight) {
                    gameAction = this.getGameAction(keyCode);
                }
                if (Math.abs(keyCode) == this.fnKeyRight) {
                    if (!MainCanvas.bSendScore) break;
                    boolean synchronize = false;
                    if (this.activeItem < 8 && this.tablePos[this.activeTable][this.activeItem] != -1 && this.tablePos[this.activeTable][this.activeItem + 1] == -1) {
                        synchronize = true;
                    }
                    if (!this.tableIsSent[this.activeTable][this.activeItem] && !synchronize) {
                        if (this.tablePass[this.activeTable][this.activeItem].equals("")) {
                            String p = this.getPasswordForUser(this.tableName[this.activeTable][this.activeItem]);
                            if (p == null || p.equals("")) {
                                this.setMode(4);
                                this.repaintX();
                                return;
                            }
                            this.tablePass[this.activeTable][this.activeItem] = p;
                        }
                        this.name = new StringBuffer(this.tableName[this.activeTable][this.activeItem]);
                        this.pass = new StringBuffer(this.tablePass[this.activeTable][this.activeItem]);
                        this.sendScore();
                        break;
                    }
                    this.setMode(8);
                    Thread t = new Thread(){

                        public void run() {
                            ScoreCanvas.this.synchronize();
                            ScoreCanvas.this.saveRMS();
                            ScoreCanvas.this.setMode(2);
                            ScoreCanvas.this.repaintX();
                        }
                    };
                    t.start();
                    break;
                }
                if (Math.abs(keyCode) == this.fnKeyLeft) {
                    this.renderer.hideScoreCanvas();
                    break;
                }
                if (gameAction == 6 || keyCode == 56) {
                    if (this.activeItem >= 8) break;
                    ++this.activeItem;
                    this.repaintX();
                    break;
                }
                if (gameAction == 1 || keyCode == 50) {
                    if (this.activeItem <= 0) break;
                    --this.activeItem;
                    this.repaintX();
                    break;
                }
                if (gameAction == 2) {
                    if (this.activeTable <= 0) break;
                    --this.activeTable;
                    this.repaintX();
                    break;
                }
                if (gameAction != 2 || this.activeTable >= this.countOfTables - 1) break;
                ++this.activeTable;
                this.repaintX();
                break;
            }
            case 4: {
                this.setMode(1);
                this.setEditComponents(this.tableName[this.activeTable][this.activeItem], this.tablePass[this.activeTable][this.activeItem], 1);
                this.repaintX();
                break;
            }
            case 6: {
                this.setMode(2);
                this.repaintX();
                break;
            }
            case 7: {
                this.setMode(4);
                this.repaintX();
            }
        }
    }

    private void setEditComponents(String n, String p, int edit) {
        this.name = new StringBuffer(n);
        this.pass = new StringBuffer(p);
        this.activeEdit = edit;
        this.charOffsetIndex = 0;
        this.activeCharIndex = this.activeEdit == 0 ? this.name.length() : this.pass.length();
    }

    private void sendScore() {
        Thread t = new Thread(){

            public void run() {
                ScoreCanvas.this.setMode(3);
                int res = ScoreCanvas.this.verify(ScoreCanvas.this.name.toString(), ScoreCanvas.this.pass.toString());
                if (res == 0) {
                    ScoreCanvas.this.setMode(5);
                    ((ScoreCanvas)ScoreCanvas.this).tableName[((ScoreCanvas)ScoreCanvas.this).activeTable][((ScoreCanvas)ScoreCanvas.this).activeItem] = ScoreCanvas.this.name.toString();
                    ((ScoreCanvas)ScoreCanvas.this).tablePass[((ScoreCanvas)ScoreCanvas.this).activeTable][((ScoreCanvas)ScoreCanvas.this).activeItem] = ScoreCanvas.this.pass.toString();
                    res = ScoreCanvas.this.send(ScoreCanvas.this.activeItem);
                    if (res == 0) {
                        ((ScoreCanvas)ScoreCanvas.this).tableIsSent[((ScoreCanvas)ScoreCanvas.this).activeTable][((ScoreCanvas)ScoreCanvas.this).activeItem] = true;
                    }
                    ScoreCanvas.this.saveRMS();
                    if (res == 0) {
                        ScoreCanvas.this.setMode(2);
                    }
                }
                if (res > 0) {
                    ScoreCanvas.this.setMode(7);
                } else if (res < 0) {
                    ScoreCanvas.this.setMode(6);
                }
                ScoreCanvas.this.repaintX();
            }
        };
        t.start();
    }

    private boolean setChar(int keyCode) {
        boolean result = true;
        String oldChars = this.chars;
        switch (keyCode) {
            case 49: {
                this.chars = "1";
                break;
            }
            case 50: {
                this.chars = "ABC2";
                break;
            }
            case 51: {
                this.chars = "DEF3";
                break;
            }
            case 52: {
                this.chars = "GHI4";
                break;
            }
            case 53: {
                this.chars = "JKL5";
                break;
            }
            case 54: {
                this.chars = "MNO6";
                break;
            }
            case 55: {
                this.chars = "PQRS7";
                break;
            }
            case 56: {
                this.chars = "TUV8";
                break;
            }
            case 57: {
                this.chars = "WXYZ9";
                break;
            }
            case 48: {
                this.chars = "0";
                break;
            }
            default: {
                result = false;
                this.lastKeyPressTime = 0L;
            }
        }
        if (!oldChars.equals(this.chars)) {
            this.lastKeyPressTime = 0L;
        }
        return result;
    }

    private void setCharToComponent(int component, boolean append) {
        if (append && this.activeCharIndex < 8) {
            ++this.activeCharIndex;
            this.charOffsetIndex = 0;
        } else {
            append = false;
        }
        switch (component) {
            case 0: {
                if (append) {
                    this.name.append(this.chars.charAt(this.charOffsetIndex));
                    break;
                }
                this.name.setCharAt(this.activeCharIndex - 1, this.chars.charAt(this.charOffsetIndex));
                break;
            }
            case 1: {
                if (append) {
                    this.pass.append(this.chars.charAt(this.charOffsetIndex));
                    break;
                }
                this.pass.setCharAt(this.activeCharIndex - 1, this.chars.charAt(this.charOffsetIndex));
            }
        }
    }

    private void removeCharFromComponent(int component) {
        switch (component) {
            case 0: {
                if (this.activeCharIndex <= 0) break;
                --this.activeCharIndex;
                this.name.deleteCharAt(this.activeCharIndex);
                break;
            }
            case 1: {
                if (this.activeCharIndex <= 0) break;
                --this.activeCharIndex;
                this.pass.deleteCharAt(this.activeCharIndex);
            }
        }
    }

    private String getPasswordForUser(String u) {
        String foundPass = null;
        for (int i = 0; i < 9; ++i) {
            if (!this.tableIsLocal[this.activeTable][i] || !this.tableName[this.activeTable][i].equals(u) || this.tablePass[this.activeTable][i].equals("")) continue;
            if (foundPass != null && !foundPass.equals(this.tablePass[this.activeTable][i])) {
                foundPass = null;
                break;
            }
            foundPass = this.tablePass[this.activeTable][i];
        }
        return foundPass;
    }

    public void run() {
        boolean result = false;
        while (this.blinkThread == Thread.currentThread()) {
            Thread.yield();
            VKey.updateKeyboard(this.bLeft, this.bRight);
            this.repaintX();
            switch (this.mode) {
                case 0: 
                case 1: {
                    this.blink = !this.blink;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception e) {}
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    ++this.scrollOffset;
                    if (this.scrollOffset == this.sizeScrollBox * 2) {
                        this.scrollOffset = 0;
                    }
                    try {
                        Thread.sleep(100L);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected void hideNotify() {
        if (this.mode == 3) {
            return;
        }
        this.blinkThread = null;
    }

    protected void showNotify() {
        if (this.mode == 3) {
            return;
        }
        this.setMode(this.mode);
    }

    public void setActiveTable(int tbl) {
        if (tbl >= 0 && tbl < this.countOfTables) {
            this.activeTable = tbl;
        }
    }

    public int getActiveTable() {
        return this.activeTable;
    }

    public int getMode() {
        return this.mode;
    }

    private void setMode(int newMode) {
        this.mode = newMode;
        switch (this.mode) {
            case 0: 
            case 1: {
                this.blinkThread = new Thread(this);
                this.blinkThread.start();
                break;
            }
            case 4: {
                this.dlgStrings = ScoreCanvas.separateText(X.texts.getHashedString("SC_PASS_FOR_USER").toCharArray(), this.font, this.tableWidth - 20);
                this.blinkThread = null;
                break;
            }
            case 3: {
                this.dlgStrings = ScoreCanvas.separateText(X.texts.getHashedString("SC_VERIFICATION").toCharArray(), this.font, this.tableWidth - 20);
                this.blinkThread = new Thread(this);
                this.blinkThread.start();
                break;
            }
            case 5: {
                this.dlgStrings = ScoreCanvas.separateText(X.texts.getHashedString("SC_SEND").toCharArray(), this.font, this.tableWidth - 20);
                this.blinkThread = new Thread(this);
                this.blinkThread.start();
                break;
            }
            case 6: {
                this.dlgStrings = ScoreCanvas.separateText(X.texts.getHashedString("SC_CONNECTION_ERR").toCharArray(), this.font, this.tableWidth - 20);
                this.blinkThread = null;
                break;
            }
            case 7: {
                this.dlgStrings = ScoreCanvas.separateText(X.texts.getHashedString("SC_WRONG_PASS").toCharArray(), this.font, this.tableWidth - 20);
                this.blinkThread = null;
                break;
            }
            case 8: {
                this.dlgStrings = new Vector();
                this.dlgStrings.addElement(X.texts.getHashedString("SC_SYNCRONIZING"));
                this.blinkThread = new Thread(this);
                this.blinkThread.start();
                break;
            }
            default: {
                this.blinkThread = null;
            }
        }
    }

    public static final Vector separateText(char[] str, Font fnt, int width) {
        Vector<String> result = new Vector<String>();
        int len = str.length;
        int startIndex = 0;
        int lastOkIndex = 0;
        for (int i = 0; i < len; ++i) {
            if (str[i] != ' ' && str[i] != '\n') continue;
            if (fnt.charsWidth(str, startIndex, i - startIndex) < width) {
                if (str[i] == '\n') {
                    result.addElement(new String(str, startIndex, i - startIndex));
                    lastOkIndex = startIndex = i + 1;
                    continue;
                }
                lastOkIndex = i;
                continue;
            }
            result.addElement(new String(str, startIndex, lastOkIndex - startIndex));
            startIndex = lastOkIndex + 1;
            lastOkIndex = i;
            if (str[i] != '\n') continue;
            --i;
        }
        if (startIndex < len) {
            if (fnt.charsWidth(str, startIndex, str.length - startIndex) < width) {
                result.addElement(new String(str, startIndex, len - startIndex));
            } else {
                result.addElement(new String(str, startIndex, lastOkIndex - startIndex));
                result.addElement(new String(str, lastOkIndex + 1, str.length - lastOkIndex - 1));
            }
        }
        return result;
    }

    private int verify(String u, String p) {
        String url = SERVICE_URL + ScoreCanvas.chars2Hex(ScoreCanvas.encodeString(("valid," + u + "," + p).toCharArray()));
        String res = this.doComm(url, false);
        if (res == null) {
            return -1;
        }
        if (res.toString().equals(SERVICE_RESULT_OK)) {
            return 0;
        }
        return 1;
    }

    private int send(int item) {
        String url = SERVICE_URL + ScoreCanvas.chars2Hex(ScoreCanvas.encodeString(("add," + this.tableName[this.activeTable][item] + "," + this.tablePass[this.activeTable][item] + "," + this.getGameName() + "," + String.valueOf(this.tableScore[this.activeTable][item])).toCharArray()));
        String res = this.doComm(url, true);
        if (res == null || res.startsWith(SERVICE_RESULT_ER)) {
            return -1;
        }
        if (res.startsWith(SERVICE_RESULT_OK)) {
            try {
                this.tableId[this.activeTable][this.activeItem] = Integer.parseInt(res.substring(SERVICE_RESULT_OK.length()));
            }
            catch (Exception e) {
                // empty catch block
            }
            return 0;
        }
        return 1;
    }

    private int synchronize() {
        String url = SERVICE_URL + ScoreCanvas.chars2Hex(ScoreCanvas.encodeString(("synchronize,,," + this.getGameName()).toCharArray()));
        String res = this.doComm(url, true);
        if (res == null) {
            return -1;
        }
        if (res.startsWith(SERVICE_RESULT_OK)) {
            String table = res.substring(SERVICE_RESULT_OK.length());
            Vector strings = ScoreCanvas.parse(table, '|');
            if (strings.size() == 0) {
                return 1;
            }
            int localCount = this.getLocalCount();
            while (strings.size() > 9 - localCount) {
                strings.removeElementAt(strings.size() - 1);
            }
            int ai = this.activeItem;
            for (int i = 0; i < strings.size(); ++i) {
                Vector v = ScoreCanvas.parse((String)strings.elementAt(i), ',');
                int downId = Integer.parseInt((String)v.elementAt(0));
                String downName = (String)v.elementAt(1);
                int downScore = Integer.parseInt((String)v.elementAt(2));
                int pos = this.checkItemById(downId);
                if (pos != -1) continue;
                this.insertScoreToTable(downId, downName, "", downScore, false, true);
            }
            boolean needGetpos = false;
            url = SERVICE_URL;
            String getposUrl = "getpos";
            Vector<Integer> ids = new Vector<Integer>();
            for (int i = 8; i >= 0; --i) {
                if (this.tablePos[this.activeTable][i] != -1 || this.tableId[this.activeTable][i] == -1) continue;
                getposUrl = getposUrl.concat("," + this.tableId[this.activeTable][i]);
                ids.addElement(new Integer(i));
                needGetpos = true;
            }
            if (needGetpos && (res = this.doComm(url + ScoreCanvas.chars2Hex(ScoreCanvas.encodeString(getposUrl.toCharArray())), true)) != null) {
                String positions = res.substring(SERVICE_RESULT_OK.length());
                strings = ScoreCanvas.parse(positions, ',');
                int newId = 0;
                for (int i = 0; i < strings.size(); ++i) {
                    if (i >= ids.size() || (newId = Integer.parseInt((String)strings.elementAt(i))) <= 0) continue;
                    this.tablePos[this.activeTable][((Integer)ids.elementAt((int)i)).intValue()] = newId;
                }
            }
        }
        return 1;
    }

    private int checkItemById(int itemId) {
        for (int i = 0; i < 9; ++i) {
            if (this.tableId[this.activeTable][i] != itemId) continue;
            return i;
        }
        return -1;
    }

    private void insertScoreToTable(int i, String user, String pass, int sc, boolean local, boolean sent) {
        int pos = this.getPositionForScore(sc);
        int localCount = this.getLocalCount();
        if (local && localCount < 3 || !local && localCount <= 3) {
            int cnt = 8;
            while (this.tableIsLocal[this.activeTable][cnt]) {
                --cnt;
            }
            for (int k = cnt; k < 8; ++k) {
                this.tableId[this.activeTable][k] = this.tableId[this.activeTable][k + 1];
                this.tablePos[this.activeTable][k] = -1;
                this.tableName[this.activeTable][k] = this.tableName[this.activeTable][k + 1];
                this.tablePass[this.activeTable][k] = this.tablePass[this.activeTable][k + 1];
                this.tableScore[this.activeTable][k] = this.tableScore[this.activeTable][k + 1];
                this.tableIsLocal[this.activeTable][k] = this.tableIsLocal[this.activeTable][k + 1];
                this.tableIsSent[this.activeTable][k] = this.tableIsSent[this.activeTable][k + 1];
            }
            this.tableScore[this.activeTable][8] = 0;
            pos = this.getPositionForScore(sc);
        }
        if (pos != -1) {
            for (int k = 7; k >= pos; --k) {
                this.tableId[this.activeTable][k + 1] = this.tableId[this.activeTable][k];
                this.tablePos[this.activeTable][k + 1] = this.tablePos[this.activeTable][k];
                this.tableName[this.activeTable][k + 1] = this.tableName[this.activeTable][k];
                this.tablePass[this.activeTable][k + 1] = this.tablePass[this.activeTable][k];
                this.tableScore[this.activeTable][k + 1] = this.tableScore[this.activeTable][k];
                this.tableIsLocal[this.activeTable][k + 1] = this.tableIsLocal[this.activeTable][k];
                this.tableIsSent[this.activeTable][k + 1] = this.tableIsSent[this.activeTable][k];
            }
            this.tableId[this.activeTable][pos] = i;
            this.tablePos[this.activeTable][pos] = pos + 1;
            this.tableName[this.activeTable][pos] = user;
            this.tablePass[this.activeTable][pos] = pass;
            this.tableScore[this.activeTable][pos] = sc;
            this.tableIsLocal[this.activeTable][pos] = local;
            this.tableIsSent[this.activeTable][pos] = sent;
            this.activeItem = pos;
            boolean flg = false;
            for (int cnt = 8; cnt >= 0; --cnt) {
                this.tablePos[this.activeTable][cnt] = cnt >= 6 && !flg && this.tableIsLocal[this.activeTable][cnt] ? -1 : cnt + 1;
                if (this.tableIsLocal[this.activeTable][cnt]) continue;
                flg = true;
            }
        }
    }

    static final char[] encodeString(char[] string) {
        char b = (char)string.length;
        for (int i = 0; i < string.length; ++i) {
            char a = string[i];
            string[i] = (char)(a ^ b);
            b = a;
        }
        return string;
    }

    static final String chars2Hex(char[] chars) {
        String result = "0x";
        for (int i = 0; i < chars.length; ++i) {
            byte half = (byte)(chars[i] >> 4 & 0xF);
            result = half < 10 ? result + (char)(48 + half) : result + (char)(65 + (half - 10));
            half = (byte)(chars[i] & 0xF);
            result = half < 10 ? result + (char)(48 + half) : result + (char)(65 + (half - 10));
        }
        return result;
    }

    private String getGameName() {
        return this.gameName + (this.activeTable > 0 ? String.valueOf(this.activeTable + 1) : "");
    }

    private int getPositionForScore(int s) {
        for (int i = 0; i < 9; ++i) {
            if (s <= this.tableScore[this.activeTable][i]) continue;
            return i;
        }
        return -1;
    }

    public static Vector parse(String str, char delim) {
        Vector<String> result = new Vector<String>();
        char[] a = str.toCharArray();
        int lastIndex = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != delim) continue;
            String s = new String(a, lastIndex, i - lastIndex);
            lastIndex = i + 1;
            result.addElement(s);
        }
        if (lastIndex < a.length) {
            String s = new String(a, lastIndex, a.length - lastIndex);
            result.addElement(s);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doComm(String url, boolean acceptAll) {
        HttpConnection c = null;
        InputStream is = null;
        StringBuffer result = new StringBuffer();
        try {
            int ch;
            c = (HttpConnection)Connector.open((String)url);
            if (c == null) {
                new Exception();
            }
            c.setRequestMethod("GET");
            is = c.openInputStream();
            while ((ch = is.read()) != -1) {
                if (result.length() >= 5 && !acceptAll) continue;
                result.append((char)ch);
            }
            Thread.yield();
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (IOException e) {}
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRMS() {
        RecordStore state = null;
        try {
            state = RecordStore.openRecordStore((String)(HISCORE_STORE + this.activeTable), (boolean)false);
            RecordEnumeration en = state.enumerateRecords(null, null, false);
            this.RMSId[this.activeTable] = en.nextRecordId();
            byte[] record = state.getRecord(this.RMSId[this.activeTable]);
            DataInputStream data = new DataInputStream(new ByteArrayInputStream(record));
            for (int i = 0; i < 9; ++i) {
                this.tableId[this.activeTable][i] = data.readInt();
                this.tablePos[this.activeTable][i] = data.readInt();
                this.tableName[this.activeTable][i] = data.readUTF();
                this.tablePass[this.activeTable][i] = data.readUTF();
                this.tableScore[this.activeTable][i] = data.readInt();
                this.tableIsLocal[this.activeTable][i] = data.readBoolean();
                this.tableIsSent[this.activeTable][i] = data.readBoolean();
            }
            lastEditedName = data.readUTF();
            state.closeRecordStore();
        }
        catch (Exception e) {
            this.saveRMS();
        }
        finally {
            try {
                state.closeRecordStore();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRMS() {
        RecordStore state = null;
        try {
            state = RecordStore.openRecordStore((String)(HISCORE_STORE + this.activeTable), (boolean)true);
            ByteArrayOutputStream array = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(array);
            for (int i = 0; i < 9; ++i) {
                data.writeInt(this.tableId[this.activeTable][i]);
                data.writeInt(this.tablePos[this.activeTable][i]);
                data.writeUTF(this.tableName[this.activeTable][i]);
                data.writeUTF(this.tablePass[this.activeTable][i]);
                data.writeInt(this.tableScore[this.activeTable][i]);
                data.writeBoolean(this.tableIsLocal[this.activeTable][i]);
                data.writeBoolean(this.tableIsSent[this.activeTable][i]);
            }
            data.writeUTF(lastEditedName);
            if (this.RMSId[this.activeTable] == -1) {
                this.RMSId[this.activeTable] = state.addRecord(array.toByteArray(), 0, array.toByteArray().length);
            } else {
                state.setRecord(this.RMSId[this.activeTable], array.toByteArray(), 0, array.toByteArray().length);
            }
            state.closeRecordStore();
        }
        catch (Exception ex) {
        }
        finally {
            try {
                state.closeRecordStore();
            }
            catch (Throwable t) {}
        }
    }
}

