/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Resources {
    static final int ICON_OK = 0;
    static final int ICON_BACK = 1;
    static final int ICON_NO = 2;
    static final int ICON_MENU = 3;
    public static int MENU_ITEM_HEIGHT = 0;
    public static int MENU_ITEM_WIDTH = 0;
    public static int MENU_ITEM_TXT_DIF = 0;
    public static int DSPH_FONT = 0;
    public static int DSPH_BULLDOZER = 0;
    public static int POSX_MENU_LEFT = 0;
    public static int POSX_MENU_RIGHT = 0;
    public static int DSPX_ARROWS = 0;
    public static int BUTTON_DSP_Y = 0;
    public static StringBuffer stringBuffer = new StringBuffer();
    public static Sprite sprIcons;
    public static Sprite sprMenuItm;
    public static Image imgMiddlePart;
    public static int iMenuItmW;
    public static int iMenuItmH;
    public static int iMiddleSizeW;
    public static int iMiddleSizeH;
    public static int iMenuItemMiddle;
    public static int iSelectedItemDiff;
    public static int iSelectedItemInc;
    public static int iButtonY;
    public static int iLButtonX;
    public static int iRButtonX;
    public static int iRButtonW;
    public static Image imgWindow;
    public static int iWindowW;
    public static int iWindowH;
    public static Image imgMapUfo;
    public static Image imgBackground;
    public static Sprite sprArrows;
    public static boolean bAnimatingArrows;
    public static boolean bArrowLeft;
    public static boolean bArrowRight;
    public static int iArrowLeftOffset;
    public static int iArrowRightOffset;
    public static Sprite sprBtnsLeft;
    public static Sprite sprBtnsRight;
    public static Sprite sprBtnsEnds;
    public static Sprite sprBtnsCenter;
    public static Sprite sprBorders;
    public static int iMenuBottom;
    public static Sprite sprStatBattery;
    public static Sprite sprBlocksDeleting;
    public static Image imgStatDecor;
    public static Sprite sprNumbersSmall;
    public static Sprite sprBonuses;
    public static Sprite sprPower;
    public static Sprite sprRobotPowerUp;
    public static Sprite sprTakeBonus;
    public static Sprite sprBonus;
    public static Sprite sprBuble;
    public static int iBlockH;
    public static Image imgCloud1;
    public static Image imgCloud2;
    public static Image imgCloud3;
    public static int iCloud1W;
    public static int iCloud2W;
    public static int iCloud3W;
    public static int iCloud1H;
    public static int iCloud2H;
    public static int iCloud3H;
    public static Sprite sprRobotGears;
    public static Sprite sprRobotTrunk;
    public static Sprite sprRobotHead;
    public static Sprite sprRobotArmsA;
    public static Sprite sprRobotArmsB;
    public static Sprite sprRobotArmsC;
    public static int iPosOfEndOfLine;
    public static Sprite sprBlocks;
    public static Sprite sprBlockEnd;
    public static Sprite sprBlockExpl;
    public static Sprite sprUfoBig;
    public static Sprite sprShopItems;
    public static Sprite sprShopIcon;
    public static Image imgItemsShadow;
    public static Image imgShopPanelRight;
    public static Sprite sprShopPanelBarEnds;
    public static Image imgShopPanelBarCenter;
    public static Sprite sprShopTopEnds;
    public static Image imgShopTopCenter;
    public static Image imgShopBase;
    public static Image imgShopBaseArrows;
    public static Image imgShopSelector;
    public static Sprite sprShopBuyIcons;
    public static Sprite sprShopBattery;
    public static Sprite sprShopGears1;
    public static Sprite sprShopGears2;
    public static Sprite sprShopTrunk;
    public static Sprite sprShopArms1;
    public static Sprite sprShopArms2;
    public static Sprite sprShopHead;
    public static Image imgShopCable;
    public static Sprite sprShopRobot;
    public static Sprite sprTextArrows;
    public static Image imgRotation;
    public static int iRotationH;
    public static int iRotationW;
    public static Vector textVec;
    public static Vector textLink;
    public static final int TEXT_BORDER = 10;
    public static Image imgMenuIcon;
    public static int iTextStartLine;
    public static int iLineOnScreen;
    public static int iPickPointY;
    public static boolean bScrollNeed;
    public static Image imgHand;
    public static int iHandH;
    public static int iHandW;
    public static Image imgMenu;
    public static int iMenuIcW;
    public static Image imgSky;
    public static Image imgGround;
    public static Sprite sprRoof;
    public static int iRoofW;
    public static int iRoofH;
    public static Sprite sprLvlAnimal;
    public static int iAnimalW;
    public static int iAnimalH;
    public static Sprite sprShadows;
    public static Sprite sprUfoRotator;
    public static Sprite sprUfoCocpit;
    public static Sprite sprUfoLaser;
    public static int iLaserW;
    public static int iLaserH;
    public static String strText1;
    public static String strText2;

    public static void setResolutionVariables(int w, int h) {
        if (w == 128 && h == 160) {
            MENU_ITEM_HEIGHT = 4;
            MENU_ITEM_WIDTH = 6;
            MENU_ITEM_TXT_DIF = 2;
        }
        if (w == 176 && h == 220) {
            MENU_ITEM_HEIGHT = 5;
            MENU_ITEM_WIDTH = 10;
            MENU_ITEM_TXT_DIF = 5;
        }
        if (w == 240 && h == 320) {
            MENU_ITEM_HEIGHT = 5;
            MENU_ITEM_WIDTH = 10;
            MENU_ITEM_TXT_DIF = 5;
        }
        if (w != 240 || h == 400) {
            // empty if block
        }
        if (w == 360 && h == 640) {
            MENU_ITEM_HEIGHT = 8;
            MENU_ITEM_WIDTH = 10;
            MENU_ITEM_TXT_DIF = 5;
        }
        if (w == 480 && h == 800) {
            MENU_ITEM_HEIGHT = 5;
            MENU_ITEM_WIDTH = 10;
            MENU_ITEM_TXT_DIF = 5;
        }
        if (w != 480 || h == 640) {
            // empty if block
        }
        if (w != 480 || h == 854) {
            // empty if block
        }
        if (w != 320 || h == 480) {
            // empty if block
        }
    }

    public static void loadInitialResources() {
        Debug.traceIn("> Resources.loadInitialResources()");
        sprRoof = Common.createSprite(MainCanvas.strPrefix + "roofs.png", 1, 3);
        iRoofW = sprRoof.getWidth();
        iRoofH = sprRoof.getHeight();
        sprTextArrows = Common.createSprite(MainCanvas.strPrefix + "arrows.png", 2, 1);
        imgHand = Common.createImage(MainCanvas.strPrefix + "hnd.png");
        iHandH = imgHand.getHeight();
        iHandW = imgHand.getWidth();
        imgMenu = Common.createImage(MainCanvas.strPrefix + "menuHlp.png");
        iMenuIcW = imgMenu.getWidth();
        Debug.traceOut("< Resources.loadInitialResources()");
    }

    public static void loadRotationIcon() {
    }

    public static void loadMapResources() {
        imgBackground = null;
        System.gc();
        imgMapUfo = Common.createImage(MainCanvas.strResolution + "mapUfo.png");
        imgBackground = Common.createImage(MainCanvas.strResolution + "m.png");
    }

    public static void releaseMapResources() {
        imgBackground = null;
        imgMapUfo = null;
        System.gc();
    }

    public static void loadShopResources() {
        imgBackground = null;
        System.gc();
        imgBackground = Common.createImage(MainCanvas.strResolution + "shpB.png");
        imgItemsShadow = Common.createImage(MainCanvas.strResolution + "shpItemsShd.png");
        sprUfoBig = Common.createSprite(MainCanvas.strResolution + "shpBigItms.png", 3, 3);
        sprShopItems = Common.createSprite(MainCanvas.strResolution + "shpItems.png", 9, 1);
        sprShopIcon = Common.createSprite(MainCanvas.strResolution + "shpIco.png", 2, 1);
    }

    public static void releaseShopResources() {
        imgBackground = null;
        imgItemsShadow = null;
        sprShopIcon = null;
        sprUfoBig = null;
        sprShopItems = null;
        System.gc();
    }

    public static void loadGameResources() {
        Debug.traceIn("> Resources.loadGameResources()");
        imgStatDecor = Common.createImage(MainCanvas.strPrefix + "stDcr.png");
        sprNumbersSmall = Common.createSprite(MainCanvas.strPrefix + "nmbSmall.png", 13, 1);
        sprBonuses = Common.createSprite(MainCanvas.strPrefix + "bns.png", 3, 1);
        sprTakeBonus = Common.createSprite(MainCanvas.strPrefix + "takeBns.png", 3, 1);
        sprBonus = Common.createSprite(MainCanvas.strPrefix + "bonus.png", 6, 1);
        sprLvlAnimal = Common.createSprite(MainCanvas.strPrefix + "levelAnimal.png", 3, 1);
        iAnimalW = sprLvlAnimal.getWidth();
        iAnimalH = sprLvlAnimal.getHeight();
        imgCloud1 = Common.createImage(MainCanvas.strPrefix + "cloud1.png");
        imgCloud2 = Common.createImage(MainCanvas.strPrefix + "cloud2.png");
        imgCloud3 = Common.createImage(MainCanvas.strPrefix + "cloud3.png");
        iCloud1W = imgCloud1.getWidth();
        iCloud2W = imgCloud2.getWidth();
        iCloud3W = imgCloud3.getWidth();
        iCloud1H = imgCloud1.getHeight();
        iCloud2H = imgCloud2.getHeight();
        iCloud3H = imgCloud3.getHeight();
        sprShadows = Common.createSprite(MainCanvas.strPrefix + "shadows.png", 3, 1);
        Debug.traceOut("< Resources.loadGameResources()");
    }

    public static void loadStageBackground(int stage) {
        if (imgBackground != null) {
            imgBackground = null;
            System.gc();
        }
        imgSky = Common.createImage(MainCanvas.strResolution + "bs" + stage + ".png");
        imgGround = Common.createImage(MainCanvas.strResolution + "bg" + stage + ".png");
    }

    public static void releaseStageBackground() {
        imgSky = null;
        imgGround = null;
        System.gc();
    }

    public static void loadUfoResources() {
        sprUfoRotator = Common.createSprite(MainCanvas.strPrefix + "ufo_rotators.png", 5, 1);
        sprUfoCocpit = Common.createSprite(MainCanvas.strPrefix + "ufo_kokpitts.png", 5, 3);
        sprUfoLaser = Common.createSprite(MainCanvas.strPrefix + "ufo_rays.png", 6, 1);
        iLaserW = sprUfoLaser.getWidth();
        iLaserH = sprUfoLaser.getHeight();
    }

    public static void releaseRobotResources() {
        Debug.traceIn("> Resources.releaseRobotResources()");
        sprRobotGears = null;
        sprRobotTrunk = null;
        sprRobotHead = null;
        sprRobotArmsA = null;
        sprRobotArmsB = null;
        sprRobotArmsC = null;
        sprUfoRotator = null;
        sprUfoCocpit = null;
        sprUfoLaser = null;
        Debug.traceOut("< Resources.releaseRobotResources()");
    }

    public static void loadBlocksResources(int stage) {
        Debug.traceIn("> Resources.loadBlocksResources()");
        sprBlocks = Common.createSprite(MainCanvas.strPrefix + "bl" + stage + ".png", 4, 2);
        iBlockH = sprBlocks.getHeight();
        sprBlocksDeleting = Common.createSprite(MainCanvas.strPrefix + "animalDeleting" + stage + ".png", 16, 1);
        Debug.traceOut("< Resources.loadBlocksResources()");
    }

    public static void releaseBlocksResources() {
        Debug.traceIn("> Resources.releaseBlocksResources()");
        sprBlocks = null;
        sprBlocksDeleting = null;
        sprBlockEnd = null;
        sprBlockExpl = null;
        Debug.traceOut("< Resources.releaseBlocksResources()");
    }

    public static void releaseGameResources() {
        Debug.traceIn("> Resources.releaseGameResources()");
        sprStatBattery = null;
        imgStatDecor = null;
        sprNumbersSmall = null;
        sprBonuses = null;
        sprPower = null;
        sprRobotPowerUp = null;
        sprTakeBonus = null;
        imgBackground = null;
        Debug.traceOut("< Resources.releaseGameResources()");
    }

    public static void paintGameBackground(Graphics g) {
        int iLeft = (Defines.WIDTH - imgSky.getWidth()) / 2;
        g.drawImage(imgSky, iLeft, 0, 20);
    }

    public static void paintGameGround(Graphics g, int y) {
        int iLeft = Defines.WIDTH - imgGround.getWidth() >> 1;
        g.drawImage(imgGround, iLeft, y, 20);
    }

    public static void paintBackground(Graphics g) {
        g.setClip(0, 0, Defines.WIDTH, Defines.HEIGHT);
        if (imgBackground == null) {
            return;
        }
        int iLeft = Defines.WIDTH - imgBackground.getWidth() >> 1;
        int iTop = Defines.HEIGHT - imgBackground.getHeight() >> 1;
        g.drawImage(imgBackground, iLeft, iTop, 20);
    }

    public static void paintHand(int x, int y, Graphics g, boolean b) {
    }

    public static void paintShopUfo(Graphics g, int y, int iLaser, int iRotator, int iCocpit) {
        int iUfoPosX = Defines.WIDTH - sprUfoBig.getWidth() >> 1;
        sprUfoBig.setFrame(iLaser + 6);
        sprUfoBig.setPosition(iUfoPosX, y + (sprUfoBig.getHeight() << 1) - sprUfoBig.getHeight() / 3 - (sprUfoBig.getHeight() >> 1));
        sprUfoBig.paint(g);
        sprUfoBig.setFrame(iRotator + 3);
        sprUfoBig.setPosition(iUfoPosX, y + sprUfoBig.getHeight() - (sprUfoBig.getHeight() >> 1) + 5);
        sprUfoBig.paint(g);
        sprUfoBig.setFrame(iCocpit);
        sprUfoBig.setPosition(iUfoPosX, y);
        sprUfoBig.paint(g);
    }

    public static void paintStatusBarNumbers(Graphics g, Level level) {
        int iBlocksToNextLev = level.gssCommon.iBlocksToNextLev;
        if (iBlocksToNextLev < 0) {
            iBlocksToNextLev = 0;
        }
        stringBuffer.setLength(0);
        stringBuffer.append(iBlocksToNextLev);
        while (stringBuffer.length() < 4) {
            stringBuffer.insert(0, "0");
        }
        ScoreLabels.drawNumbers(g, sprNumbersSmall, stringBuffer.toString(), iAnimalW - 5, Defines.HEIGHT - sprNumbersSmall.getHeight());
        stringBuffer.setLength(0);
        stringBuffer.append(level.gssCommon.iScore);
        while (stringBuffer.length() < 5) {
            stringBuffer.insert(0, "0");
        }
        ScoreLabels.drawNumbers(g, sprNumbersSmall, stringBuffer.toString(), Defines.WIDTH >> 1, Defines.HEIGHT - sprNumbersSmall.getHeight());
    }

    public static void paintStatusBar(Graphics g, Level level) {
        Common.saveClipState(g);
        int iSprStatBatteryW = sprStatBattery.getWidth();
        int iLeft = (Defines.WIDTH - (iSprStatBatteryW + iSprStatBatteryW / 4)) / 2 - sprBtnsEnds.getWidth();
        sprBtnsEnds.setFrame(0);
        sprBtnsEnds.setTransform(2);
        sprBtnsEnds.setPosition(iLeft, 0);
        sprBtnsEnds.paint(g);
        sprBtnsEnds.setTransform(0);
        sprBtnsEnds.setPosition(Defines.WIDTH - iLeft - sprBtnsEnds.getWidth(), 0);
        sprBtnsEnds.paint(g);
        int iPosXStatBattery = (Defines.WIDTH - iSprStatBatteryW) / 2;
        int iPosYStatBattery = (sprBtnsEnds.getHeight() - sprStatBattery.getHeight()) / 2;
        sprStatBattery.setFrame(0);
        sprStatBattery.setPosition(iPosXStatBattery, iPosYStatBattery);
        sprStatBattery.paint(g);
        sprStatBattery.setFrame(1);
        g.setClip(iPosXStatBattery, 0, Common.barValue(GameStateCommon.sInstance.iBatteryPower, 100, sprStatBattery.getWidth()), Defines.HEIGHT);
        sprStatBattery.paint(g);
        g.setClip(0, 0, Defines.WIDTH, Defines.HEIGHT);
        int iImgStatDecorW = imgStatDecor.getWidth();
        int iTop = sprBtnsEnds.getHeight() - imgStatDecor.getHeight();
        int iX = Defines.WIDTH - iImgStatDecorW;
        do {
            g.drawImage(imgStatDecor, iX, iTop, 20);
        } while ((iX -= iImgStatDecorW) > -iImgStatDecorW);
        stringBuffer.setLength(0);
        stringBuffer.append(level.gssCommon.iScore);
        while (stringBuffer.length() < 5) {
            stringBuffer.insert(0, "0");
        }
        g.setColor(0xFFFFFF);
        int iClipW = iLeft + sprBtnsEnds.getWidth() / 2;
        g.setClip(0, 0, iClipW, Defines.HEIGHT);
        int iFontHeight = Fonts.iFontHeight - DSPH_FONT;
        Fonts.drawCenterString(stringBuffer.toString(), (sprBtnsEnds.getHeight() + iFontHeight) / 2, g, (Canvas)MainCanvas.canvas);
        int iBlocksToNextLev = level.gssCommon.iBlocksToNextLev;
        if (iBlocksToNextLev < 0) {
            iBlocksToNextLev = 0;
        }
        stringBuffer.setLength(0);
        stringBuffer.append(iBlocksToNextLev);
        while (stringBuffer.length() < 4) {
            stringBuffer.insert(0, "0");
        }
        g.setClip(Defines.WIDTH - iClipW, 0, iClipW, Defines.HEIGHT);
        Fonts.drawCenterString(stringBuffer.toString(), (sprBtnsEnds.getHeight() + iFontHeight) / 2, g, (Canvas)MainCanvas.canvas);
        Common.restoreClipState(g);
        if (GameStateCommon.sInstance.iScoreMul > 0) {
            stringBuffer.setLength(0);
            stringBuffer.append("x");
            stringBuffer.append(GameStateCommon.sInstance.iScoreMul + 1);
            iLeft = Defines.WIDTH - stringBuffer.length() * (sprNumbersSmall.getWidth() + 1);
            ScoreLabels.drawNumbers(g, sprNumbersSmall, stringBuffer.toString(), iLeft, iTop - sprNumbersSmall.getHeight());
            g.setColor(0xFFFF00);
            g.fillRect(1, iTop + 1, Common.barValue(GameStateCommon.sInstance.iScoreMulTime, GameStateCommon.sInstance.getMultiplierTime(), Defines.WIDTH - 2), imgStatDecor.getHeight() - 2);
        }
    }

    public static void prepareText(String text) {
        MainCanvas.cFont.reset();
        textVec = null;
        iTextStartLine = 0;
        iLineOnScreen = (iWindowH - iMenuItmH * 2) / Fonts.iFontHeight;
        textVec = MainCanvas.cFont.preprocessText(text.toUpperCase(), iWindowW);
        bScrollNeed = iLineOnScreen * Fonts.iFontHeight < (textVec.size() - 2) * Fonts.iFontHeight;
    }

    public static void paintText(Graphics g, int iPosY) {
        int x = Defines.WIDTH - iWindowW >> 1;
        MainCanvas.cFont.bCentering = true;
        MainCanvas.cFont.drawLineSeparatedText(textVec, iTextStartLine, x + 4, iPosY, iWindowW, iWindowH - iMenuItmH, g);
        MainCanvas.cFont.bCentering = false;
    }

    public static void scrollTextDown() {
        if (!bScrollNeed) {
            return;
        }
        if (++iTextStartLine > textVec.size() - iLineOnScreen) {
            iTextStartLine = textVec.size() - iLineOnScreen;
        }
    }

    public static void scrollTextUp() {
        if (!bScrollNeed) {
            return;
        }
        if (--iTextStartLine < 0) {
            iTextStartLine = 0;
        }
    }

    public static void pickText(int y) {
        iPickPointY = y;
    }

    public static boolean dragText(int y) {
        int iScroll = iPickPointY - y;
        if (Math.abs(iScroll) >= Fonts.iFontHeight) {
            if (iScroll < 0) {
                Resources.scrollTextUp();
            }
            if (iScroll > 0) {
                Resources.scrollTextDown();
            }
            iPickPointY = y;
            return true;
        }
        return false;
    }

    public static void loadMenuResources() {
        sprIcons = Common.createSprite(MainCanvas.strPrefix + "btns.png", 4, 1);
        sprMenuItm = Common.createSprite(MainCanvas.strPrefix + "menuItm.png", 3, 3);
        iMenuItmW = sprMenuItm.getWidth();
        iMenuItmH = sprMenuItm.getHeight();
        Resources.generateMenuItem();
        Resources.generateWindow();
        iButtonY = Defines.HEIGHT - sprIcons.getHeight() - (iMenuItmW * MENU_ITEM_HEIGHT - sprIcons.getHeight() >> 1);
        iLButtonX = 0;
        iRButtonX = Defines.WIDTH - sprIcons.getWidth();
        iRButtonW = sprIcons.getWidth();
    }

    public static void releaseMenuResources() {
        sprMenuItm = null;
        imgMiddlePart = null;
        System.gc();
    }

    public static void generateMenuItem() {
        iMiddleSizeW = Defines.WIDTH - iMenuItmW * MENU_ITEM_WIDTH;
        iMiddleSizeH = iMenuItmW * MENU_ITEM_HEIGHT;
        int iCnt = iMiddleSizeW / iMenuItmW + 1;
        imgMiddlePart = Image.createImage((int)iMiddleSizeW, (int)iMiddleSizeH);
        Graphics bG = imgMiddlePart.getGraphics();
        for (int i = 0; i < iCnt; ++i) {
            sprMenuItm.setFrame(1);
            sprMenuItm.setPosition(i * iMenuItmW, 0);
            sprMenuItm.paint(bG);
            for (int j = 0; j < MENU_ITEM_HEIGHT - 2; ++j) {
                sprMenuItm.setFrame(4);
                sprMenuItm.setPosition(i * iMenuItmW, (j + 1) * iMenuItmH);
                sprMenuItm.paint(bG);
            }
            sprMenuItm.setFrame(7);
            sprMenuItm.setPosition(i * iMenuItmW, iMenuItmH * (MENU_ITEM_HEIGHT - 1));
            sprMenuItm.paint(bG);
        }
        iMenuItemMiddle = Defines.WIDTH - iMiddleSizeW - (iMenuItmW << 1) >> 1;
    }

    public static void paintMenuItem(int y, String str, boolean bSelected, Graphics g) {
        int x = 0;
        int iDiffY = iMiddleSizeH - Fonts.iFontHeight >> 1;
        int iPosX = 0;
        if (!bSelected) {
            x = iMenuItemMiddle;
            iPosX = Defines.WIDTH - Fonts.strWidth(str) >> 1;
        }
        if (bSelected) {
            if (Math.abs(iSelectedItemDiff += iSelectedItemInc) == MENU_ITEM_TXT_DIF) {
                iSelectedItemInc *= -1;
            }
            x = iMenuItemMiddle + (iMenuItmW << 1);
            iPosX = (Defines.WIDTH - Fonts.strWidth(str) >> 1) + (iMenuItmW << 1) + iSelectedItemDiff;
        }
        sprMenuItm.setFrame(0);
        sprMenuItm.setPosition(x, y);
        sprMenuItm.paint(g);
        sprMenuItm.setFrame(2);
        sprMenuItm.setPosition(x + iMiddleSizeW + iMenuItmW, y);
        sprMenuItm.paint(g);
        for (int i = 0; i < MENU_ITEM_HEIGHT - 2; ++i) {
            sprMenuItm.setFrame(3);
            sprMenuItm.setPosition(x, y + (i + 1) * iMenuItmH);
            sprMenuItm.paint(g);
            sprMenuItm.setFrame(5);
            sprMenuItm.setPosition(x + iMiddleSizeW + iMenuItmW, y + (i + 1) * iMenuItmH);
            sprMenuItm.paint(g);
        }
        sprMenuItm.setFrame(6);
        sprMenuItm.setPosition(x, y + (MENU_ITEM_HEIGHT - 1) * iMenuItmH);
        sprMenuItm.paint(g);
        sprMenuItm.setFrame(8);
        sprMenuItm.setPosition(x + iMiddleSizeW + iMenuItmW, y + (MENU_ITEM_HEIGHT - 1) * iMenuItmH);
        sprMenuItm.paint(g);
        g.drawImage(imgMiddlePart, x + iMenuItmW, y, 0);
        g.setColor(0);
        Fonts.drawStr(str, iPosX, y + iDiffY, g);
    }

    public static void paintLeftButton(int idx, Graphics g) {
        sprIcons.setFrame(idx);
        sprIcons.setPosition(iLButtonX, iButtonY);
        sprIcons.paint(g);
    }

    public static void paintRightButton(int idx, Graphics g) {
        sprIcons.setFrame(idx);
        sprIcons.setPosition(iRButtonX, iButtonY);
        sprIcons.paint(g);
    }

    public static boolean isLeftSoftButton(int x, int y) {
        return y > iButtonY && x > 0 && x < iLButtonX + iRButtonW;
    }

    public static boolean isRightSoftButton(int x, int y) {
        return y > iButtonY && x > iRButtonX && x < Defines.HEIGHT;
    }

    public static void generateWindow() {
        int i;
        iWindowW = Defines.WIDTH - (iMenuItmW << 3);
        iWindowH = (Defines.HEIGHT - (iMenuItmH << 3)) / iMenuItmH * iMenuItmH;
        imgWindow = Image.createImage((int)iWindowW, (int)iWindowH);
        Graphics bG = imgWindow.getGraphics();
        for (i = 0; i < 60; ++i) {
            for (int j = 0; j < 80; ++j) {
                sprMenuItm.setFrame(4);
                sprMenuItm.setPosition(i * iMenuItmW, j * iMenuItmH);
                sprMenuItm.paint(bG);
            }
        }
        for (i = 0; i < 60; ++i) {
            sprMenuItm.setFrame(1);
            sprMenuItm.setPosition(i * iMenuItmW, 0);
            sprMenuItm.paint(bG);
            sprMenuItm.setFrame(7);
            sprMenuItm.setPosition(i * iMenuItmW, iWindowH - iMenuItmH);
            sprMenuItm.paint(bG);
        }
    }

    public static void paintWindow(int y, Graphics g) {
        int iNb = imgWindow.getHeight() / iMenuItmH - 1;
        int x = Defines.WIDTH - imgWindow.getWidth() - (iMenuItmW << 1) >> 1;
        int iPosXX = x + imgWindow.getWidth() + iMenuItmW;
        g.drawImage(imgWindow, x + iMenuItmW, y, 0);
        sprMenuItm.setFrame(2);
        sprMenuItm.setPosition(iPosXX, y);
        sprMenuItm.paint(g);
        sprMenuItm.setFrame(0);
        sprMenuItm.setPosition(x, y);
        sprMenuItm.paint(g);
        for (int i = 1; i < iNb; ++i) {
            sprMenuItm.setFrame(5);
            sprMenuItm.setPosition(iPosXX, y + i * iMenuItmH);
            sprMenuItm.paint(g);
            sprMenuItm.setFrame(3);
            sprMenuItm.setPosition(x, y + i * iMenuItmH);
            sprMenuItm.paint(g);
        }
        sprMenuItm.setFrame(8);
        sprMenuItm.setPosition(iPosXX, y + iNb * iMenuItmH);
        sprMenuItm.paint(g);
        sprMenuItm.setFrame(6);
        sprMenuItm.setPosition(x, y + iNb * iMenuItmH);
        sprMenuItm.paint(g);
    }

    static {
        iMenuItmW = 0;
        iMenuItmH = 0;
        iMiddleSizeW = 0;
        iMiddleSizeH = 0;
        iMenuItemMiddle = 0;
        iSelectedItemDiff = 0;
        iSelectedItemInc = 1;
        iButtonY = 0;
        iLButtonX = 0;
        iRButtonX = 0;
        iRButtonW = 0;
        imgWindow = null;
        iWindowW = 0;
        iWindowH = 0;
        bAnimatingArrows = false;
        bArrowLeft = false;
        bArrowRight = false;
        iArrowLeftOffset = 0;
        iArrowRightOffset = 0;
        iPosOfEndOfLine = 0;
        textVec = null;
        textLink = null;
        iTextStartLine = 0;
        iLineOnScreen = 0;
        iPickPointY = 0;
        bScrollNeed = false;
        iHandH = 0;
        iHandW = 0;
        iMenuIcW = 0;
        iLaserW = 0;
        iLaserH = 0;
        strText1 = null;
        strText2 = null;
    }
}

