/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class GameStateCommon {
    public static GameStateCommon sInstance = null;
    static final int TIME_MULTIPLIER = 3000;
    public int iStage;
    public int iLevel;
    public int iScore;
    public int iScoreMul;
    public int iScoreMulTime;
    public int iBonusComboCnt;
    public int iBonusTime;
    public int iBlocksToNextLev;
    public int iBlocksToBonus;
    public int iNewRows;
    public int iBattery;
    public int iGears;
    public int iTrunk;
    public int iHead;
    public int iArms;
    public int iCocpit;
    public int iRotator;
    public int iLaser;
    public int iBatteryPower;
    public int iGearsSpeed;
    public int iRobotPosIdx;
    public int iMoveProgress;
    public int iMoveDirection;
    public int iHeadAngle;
    public int iHeadAngleDelay;
    public int iHeadAngleDest;
    public int iArmsState;
    public int iArmsSpeed;
    public int iArmsElevation;
    public int iBonusGearsSpeedTime;
    public int iBonusArmsSpeedTime;
    public int iBonusPowerUpTime;
    public int iBonusNoBlockTime;
    public int bonusTakenTime;

    public static GameStateCommon CreateInstance() {
        if (sInstance != null) {
            return sInstance;
        }
        sInstance = new GameStateCommon();
        return sInstance;
    }

    public static void ReleaseInstance() {
        if (sInstance == null) {
            return;
        }
        sInstance = null;
        System.gc();
    }

    public void initData() {
        this.iStage = 0;
        this.iLevel = 0;
        this.iScore = 0;
        this.iBattery = 0;
        this.iGears = 0;
        this.iTrunk = 0;
        this.iHead = 0;
        this.iArms = 0;
        this.iCocpit = 0;
        this.iRotator = 0;
        this.iLaser = 0;
        this.iBatteryPower = 100;
        this.iGearsSpeed = 30;
        this.iArmsSpeed = 8;
        this.iBonusGearsSpeedTime = 0;
        this.iBonusArmsSpeedTime = 0;
        this.iBonusPowerUpTime = 0;
        this.iBonusNoBlockTime = 0;
        this.resetOnLevelStart();
    }

    public void resetOnLevelStart() {
        this.iScoreMul = 0;
        this.iScoreMulTime = 0;
        this.iBonusComboCnt = 0;
        this.iBonusTime = 0;
        this.iNewRows = 0;
        this.iArmsState = 0;
        this.iArmsElevation = 0;
        this.iHeadAngle = 0;
        this.iHeadAngleDelay = 0;
        this.iHeadAngleDest = 0;
        this.iRobotPosIdx = 3;
        this.iBatteryPower = 100;
        this.iBlocksToBonus = Common.getRandomUInt(10);
        this.iBonusGearsSpeedTime = 0;
        this.iBonusArmsSpeedTime = 0;
        this.iBonusPowerUpTime = 0;
        this.iBonusNoBlockTime = 0;
        this.bonusTakenTime = 0;
        this.setRobotGearsSpeed();
        this.setRobotArmsSpeed();
    }

    public void loadData(DataInputStream data) throws IOException {
        this.iStage = data.readInt();
        this.iLevel = data.readInt();
        this.iScore = data.readInt();
        this.iScoreMul = data.readInt();
        this.iScoreMulTime = data.readInt();
        this.iBonusComboCnt = data.readInt();
        this.iBonusTime = data.readInt();
        this.iBlocksToNextLev = data.readInt();
        this.iBlocksToBonus = data.readInt();
        this.iNewRows = data.readInt();
        this.iBattery = data.readInt();
        this.iGears = data.readInt();
        this.iTrunk = data.readInt();
        this.iHead = data.readInt();
        this.iArms = data.readInt();
        this.iBatteryPower = data.readInt();
        this.iGearsSpeed = data.readInt();
        this.iRobotPosIdx = data.readInt();
        this.iMoveProgress = data.readInt();
        this.iMoveDirection = data.readInt();
        this.iHeadAngle = data.readInt();
        this.iHeadAngleDelay = data.readInt();
        this.iHeadAngleDest = data.readInt();
        this.iArmsState = data.readInt();
        this.iArmsSpeed = data.readInt();
        this.iArmsElevation = data.readInt();
        this.iBonusGearsSpeedTime = data.readInt();
        this.iBonusArmsSpeedTime = data.readInt();
        this.iBonusPowerUpTime = data.readInt();
        this.iBonusNoBlockTime = data.readInt();
        this.bonusTakenTime = data.readInt();
        this.iCocpit = data.readInt();
        this.iRotator = data.readInt();
        this.iLaser = data.readInt();
    }

    public void saveData(DataOutputStream data) throws IOException {
        data.writeInt(this.iStage);
        data.writeInt(this.iLevel);
        data.writeInt(this.iScore);
        data.writeInt(this.iScoreMul);
        data.writeInt(this.iScoreMulTime);
        data.writeInt(this.iBonusComboCnt);
        data.writeInt(this.iBonusTime);
        data.writeInt(this.iBlocksToNextLev);
        data.writeInt(this.iBlocksToBonus);
        data.writeInt(this.iNewRows);
        data.writeInt(this.iBattery);
        data.writeInt(this.iGears);
        data.writeInt(this.iTrunk);
        data.writeInt(this.iHead);
        data.writeInt(this.iArms);
        data.writeInt(this.iBatteryPower);
        data.writeInt(this.iGearsSpeed);
        data.writeInt(this.iRobotPosIdx);
        data.writeInt(this.iMoveProgress);
        data.writeInt(this.iMoveDirection);
        data.writeInt(this.iHeadAngle);
        data.writeInt(this.iHeadAngleDelay);
        data.writeInt(this.iHeadAngleDest);
        data.writeInt(this.iArmsState);
        data.writeInt(this.iArmsSpeed);
        data.writeInt(this.iArmsElevation);
        data.writeInt(this.iBonusGearsSpeedTime);
        data.writeInt(this.iBonusArmsSpeedTime);
        data.writeInt(this.iBonusPowerUpTime);
        data.writeInt(this.iBonusNoBlockTime);
        data.writeInt(this.bonusTakenTime);
        data.writeInt(this.iCocpit);
        data.writeInt(this.iRotator);
        data.writeInt(this.iLaser);
    }

    public void upgradeRobotQuick() {
        this.iRotator = this.iLaser = this.iStage;
        this.iCocpit = this.iLaser;
        this.iBattery = this.iLaser;
        this.iArms = this.iLaser;
        this.iHead = this.iLaser;
        this.iTrunk = this.iLaser;
        this.iGears = this.iLaser;
    }

    public void setRobotGearsSpeed() {
        if (this.iGears == 0) {
            this.iGearsSpeed = 30;
        }
        if (this.iGears == 1) {
            this.iGearsSpeed = 50;
        }
        if (this.iGears == 2) {
            this.iGearsSpeed = 70;
        }
    }

    public void setRobotArmsSpeed() {
        if (this.iArms == 0) {
            this.iArmsSpeed = 8;
        }
        if (this.iArms == 1) {
            this.iArmsSpeed = 16;
        }
        if (this.iArms == 2) {
            this.iArmsSpeed = 24;
        }
    }

    public int getMultiplierTime() {
        int tmp = 10 - (this.iScoreMul < 10 ? this.iScoreMul : 10);
        return 3000 + Common.barValue(tmp, 10, 3000);
    }

    public void incMultiplier() {
        this.iScoreMulTime = this.getMultiplierTime();
        ++this.iScoreMul;
    }

    public void updateMultiplier() {
        if (this.iScoreMulTime > 0) {
            this.iScoreMulTime -= 40;
            if (this.iScoreMulTime <= 0) {
                this.iScoreMulTime = 0;
                this.iScoreMul = 0;
            }
        }
    }

    public void updateBonusesTime() {
        if (this.iBonusGearsSpeedTime > 0) {
            --this.iBonusGearsSpeedTime;
            if (this.iBonusGearsSpeedTime == 0) {
                this.setRobotGearsSpeed();
            }
        }
        if (this.iBonusArmsSpeedTime > 0) {
            --this.iBonusArmsSpeedTime;
            if (this.iBonusArmsSpeedTime == 0) {
                this.setRobotArmsSpeed();
            }
        }
        if (this.iBonusPowerUpTime > 0) {
            --this.iBonusPowerUpTime;
        }
        if (this.iBonusNoBlockTime > 0) {
            --this.iBonusNoBlockTime;
        }
    }
}

