/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class ScreenSplash
implements IScreen {
    static final int MODE_SOUNDS_SETUP = 0;
    static final int MODE_COMPANY_LOGO = 1;
    static final int MODE_POW_LOGO = 2;
    static final int MODE_SPLASH = 3;
    Canvas canvas;
    int mode;
    long modeDelay;
    int testicek = 0;

    ScreenSplash(Canvas canvas) {
        this.canvas = canvas;
        this.mode = 0;
        Resources.imgBackground = null;
    }

    public int getActualMode() {
        return this.mode;
    }

    public String getActualModeName() {
        return "Screen splash";
    }

    public void invokeGameMenu() {
    }

    public void update(long tick) {
        switch (this.mode) {
            case 1: 
            case 2: 
            case 3: {
                if (this.modeDelay > 0L) {
                    this.modeDelay -= tick;
                    return;
                }
                this.nextMode();
            }
        }
        this.canvas.repaint();
        this.canvas.serviceRepaints();
    }

    private void nextMode() {
        switch (this.mode) {
            case 0: {
                Resources.imgBackground = Common.createImage(MainCanvas.strPrefix + "inl.png");
                this.modeDelay = 3000L;
                this.mode = 1;
                this.canvas.repaint();
                this.canvas.serviceRepaints();
                break;
            }
            case 1: {
                Resources.imgBackground = Common.createImage(MainCanvas.strResolution + "gi.png");
                this.modeDelay = 3000L;
                this.mode = 2;
                this.canvas.repaint();
                this.canvas.serviceRepaints();
                break;
            }
            case 2: {
                Resources.imgBackground = Common.createImage(MainCanvas.strResolution + "s.png");
                this.modeDelay = 3000L;
                this.mode = 3;
                this.canvas.repaint();
                this.canvas.serviceRepaints();
                break;
            }
            case 3: {
                MainCanvas.scrMenu = new ScreenMenu(this.canvas);
                MainCanvas.activeScreen = MainCanvas.scrMenu;
                MainCanvas.scrSplash = null;
                this.canvas.repaint();
                this.canvas.serviceRepaints();
            }
        }
    }

    public void keyPressed(int keyCode) {
        this.canvas.repaint();
        this.canvas.serviceRepaints();
        switch (this.mode) {
            case 0: {
                if (Keys.key_fn1) {
                    Settings.bMusic = true;
                    Settings.saveSettings();
                    X.soundManager.SetSoundOn(true);
                    this.nextMode();
                    break;
                }
                if (!Keys.key_fn2) break;
                Settings.bMusic = false;
                Settings.saveSettings();
                X.soundManager.SetSoundOn(false);
                this.nextMode();
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (!Keys.key_fire) break;
                this.nextMode();
            }
        }
    }

    public void keyReleased(int keyCode) {
    }

    public void paint(Graphics g) {
        switch (this.mode) {
            case 0: {
                g.setColor(0);
                g.fillRect(0, 0, Defines.WIDTH, Defines.HEIGHT);
                g.setColor(0xFFFF00);
                Fonts.drawCenterString(X.texts.getHashedString("ENABLE_MUSIC").toUpperCase(), Defines.HEIGHT / 2, g, this.canvas);
                Fonts.drawLeftString(X.texts.getHashedString("YES").toUpperCase(), Defines.HEIGHT - Fonts.iFontHeight, g, this.canvas);
                Fonts.drawRightString(X.texts.getHashedString("NO").toUpperCase(), Defines.HEIGHT - Fonts.iFontHeight, g, this.canvas);
                break;
            }
            case 2: {
                g.setColor(0);
                g.fillRect(0, 0, Defines.WIDTH, Defines.HEIGHT);
                Resources.paintBackground(g);
                break;
            }
            case 1: 
            case 3: {
                g.setColor(0);
                g.fillRect(0, 0, Defines.WIDTH, Defines.HEIGHT);
                Resources.paintBackground(g);
            }
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        switch (this.mode) {
            case 0: {
                if (x < Defines.WIDTH / 2) {
                    Keys.key_fn1 = true;
                    this.keyPressed(Keys.iLeftKey);
                    Keys.key_fn1 = false;
                    break;
                }
                Keys.key_fn2 = true;
                this.keyPressed(Keys.iRightKey);
                Keys.key_fn2 = false;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                Keys.key_fire = true;
                this.keyPressed(8);
                Keys.key_fire = false;
            }
        }
    }
}

