/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

class ScoreLabels {
    public static ScoreLabels sInstance = null;
    static final int MAX_SCORE_LABELS = 5;
    static final int TIME_SCORE_LABEL = 20;
    static final int DSPY_SPEED = 6;
    static final String NUMBERS = "/:x1234567890";
    private int[] scoreLabelX = null;
    private int[] scoreLabelY = null;
    private int[] scoreLabelTim = null;
    private String[] scoreLabelStr = null;
    public int iActiveScoreLabels;
    private StringBuffer stringBuffer;
    private static Sprite sprCombo;

    public static ScoreLabels CreateInstance() {
        if (sInstance != null) {
            return sInstance;
        }
        sInstance = new ScoreLabels();
        return sInstance;
    }

    public static void ReleaseInstance() {
        if (sInstance == null) {
            return;
        }
        sInstance.release();
        sInstance = null;
        System.gc();
    }

    ScoreLabels() {
        Debug.traceIn("> ScoreLabels.ScoreLabels()");
        this.scoreLabelX = new int[5];
        this.scoreLabelY = new int[5];
        this.scoreLabelTim = new int[5];
        this.scoreLabelStr = new String[5];
        this.stringBuffer = new StringBuffer();
        sprCombo = Common.createSprite(MainCanvas.strPrefix + "cmb.png", 1, 1);
        this.resetScoreLabels();
        Debug.traceOut("< ScoreLabels.ScoreLabels()");
    }

    void release() {
        this.scoreLabelX = null;
        this.scoreLabelY = null;
        this.scoreLabelTim = null;
        this.scoreLabelStr = null;
        this.stringBuffer = null;
        sprCombo = null;
        System.gc();
    }

    public void resetScoreLabels() {
        Debug.traceIn("> ScoreLabels.resetScoreLabels()");
        Arrays.resetIntsArray(this.scoreLabelX);
        this.iActiveScoreLabels = 0;
        Debug.traceOut("< ScoreLabels.resetScoreLabels()");
    }

    public void createScoreLabel(int xpos, int ypos, int mul, int scorebase) {
        for (int i = this.scoreLabelX.length - 1; i >= 0; --i) {
            if (this.scoreLabelX[i] != -1979) continue;
            this.scoreLabelX[i] = xpos;
            this.scoreLabelY[i] = ypos << 2;
            this.scoreLabelTim[i] = 20;
            this.stringBuffer.setLength(0);
            this.stringBuffer.append(mul);
            this.stringBuffer.append("x");
            this.stringBuffer.append(scorebase);
            this.scoreLabelStr[i] = this.stringBuffer.toString();
            this.correctScoreLabelPos(i);
            ++this.iActiveScoreLabels;
            return;
        }
    }

    public void createScoreLabel(int xpos, int ypos, int score) {
        Debug.traceIn("> ScoreLabels.createScoreLabel(int xpos, int ypos, int score)");
        for (int i = this.scoreLabelX.length - 1; i >= 0; --i) {
            if (this.scoreLabelX[i] != -1979) continue;
            this.scoreLabelX[i] = xpos;
            this.scoreLabelY[i] = ypos << 2;
            this.scoreLabelTim[i] = 20;
            this.stringBuffer.setLength(0);
            this.stringBuffer.append(score);
            this.scoreLabelStr[i] = this.stringBuffer.toString();
            this.correctScoreLabelPos(i);
            ++this.iActiveScoreLabels;
            Debug.traceOut("< ScoreLabels.createScoreLabel() - from loop");
            return;
        }
        Debug.traceOut("< ScoreLabels.createScoreLabel()");
    }

    public void createScoreLabelCombo(int mul) {
        int i;
        for (i = this.scoreLabelX.length - 1; i >= 0; --i) {
            if (this.scoreLabelX[i] == -1979 || this.scoreLabelStr[i].charAt(0) != 'c') continue;
            --this.iActiveScoreLabels;
            this.scoreLabelX[i] = -1979;
        }
        for (i = this.scoreLabelX.length - 1; i >= 0; --i) {
            if (this.scoreLabelX[i] != -1979) continue;
            this.scoreLabelY[i] = (Defines.HEIGHT - sprCombo.getHeight()) / 2 << 2;
            this.scoreLabelTim[i] = 40;
            this.stringBuffer.setLength(0);
            this.stringBuffer.append("c");
            this.stringBuffer.append("x");
            this.stringBuffer.append(mul);
            this.scoreLabelStr[i] = this.stringBuffer.toString();
            int iWidth = (this.stringBuffer.length() - 1) * Resources.sprNumbersSmall.getWidth() + sprCombo.getWidth();
            this.scoreLabelX[i] = (Defines.WIDTH - iWidth) / 2;
            ++this.iActiveScoreLabels;
            return;
        }
    }

    public void correctScoreLabelPos(int idx) {
        int iLetterW = Resources.sprNumbersSmall.getWidth();
        int iWidth = this.stringBuffer.length() * iLetterW;
        int iLeft = Defines.WIDTH - 3;
        if (this.stringBuffer.charAt(0) == 'c') {
            iWidth += sprCombo.getWidth() - iLetterW;
        }
        if (iWidth + this.scoreLabelX[idx] > iLeft) {
            this.scoreLabelX[idx] = iLeft - iWidth;
        }
    }

    public static void drawNumbers(Graphics g, Sprite sprFont, String string, int x, int y) {
        int fntWidth = sprFont.getWidth();
        for (int loop = 0; loop < string.length(); ++loop) {
            char c = string.charAt(loop);
            if (c == 'c') {
                sprCombo.setPosition(x, y);
                sprCombo.paint(g);
                x += sprCombo.getWidth() + 1;
                sprFont = Resources.sprNumbersSmall;
                continue;
            }
            int index = NUMBERS.indexOf(c);
            sprFont.setFrame(index);
            sprFont.setPosition(x, y);
            sprFont.paint(g);
            x += fntWidth + 1;
        }
    }

    public void paint(Graphics g) {
        for (int i = this.scoreLabelX.length - 1; i >= 0; --i) {
            if (this.scoreLabelX[i] == -1979) continue;
            int xpos = this.scoreLabelX[i];
            int ypos = this.scoreLabelY[i];
            if (this.scoreLabelY[i] > 0) {
                ScoreLabels.drawNumbers(g, Resources.sprNumbersSmall, this.scoreLabelStr[i], xpos, ypos >> 2);
            }
            if (this.scoreLabelStr[i].charAt(0) != 'c') {
                int n = i;
                this.scoreLabelY[n] = this.scoreLabelY[n] - 6;
            }
            int n = i;
            this.scoreLabelTim[n] = this.scoreLabelTim[n] - 1;
            if (this.scoreLabelTim[i] > 0) continue;
            this.scoreLabelX[i] = -1979;
            --this.iActiveScoreLabels;
        }
    }
}

