/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class Level {
    public static Level sInstance = null;
    public GameStateCommon gssCommon;
    public GameStateCareer gssCareer;
    public static final int GAME_TYPE_QUICK = 0;
    public static final int GAME_TYPE_CAREER = 1;
    public int iGameType;
    public static final int QUICK_GAME_LEVELS_ON_MAP = 5;
    public static final int CAREER_GAME_LEVELS_ON_MAP = 20;
    private Robot robot;
    private Blocks blocks;
    private Bonuses bonuses;
    private ScoreLabels scoreLabels;
    public static final String RS_QUICK = "quick";
    public static final String RS_CAREER = "career";
    private int powerFrameIdx;
    private int iDeletingPosY = 0;
    private int[][] iCloudCoord = new int[3][3];
    private int iCloudPos = 0;
    int[] quickGameOverMapArray = new int[8];

    public static Level CreateInstance(int iGameType) {
        if (sInstance != null) {
            return sInstance;
        }
        sInstance = new Level(iGameType);
        return sInstance;
    }

    public static void ReleaseInstance() {
        if (sInstance == null) {
            return;
        }
        sInstance.release();
        sInstance = null;
        System.gc();
    }

    Level(int iGameType) {
        Debug.traceIn("> Level.Level()");
        this.gssCommon = GameStateCommon.CreateInstance();
        this.gssCareer = GameStateCareer.CreateInstance();
        this.robot = Robot.CreateInstance();
        this.blocks = Blocks.CreateInstance();
        this.bonuses = Bonuses.CreateInstance();
        this.scoreLabels = ScoreLabels.CreateInstance();
        this.iGameType = iGameType;
        this.powerFrameIdx = 0;
        Debug.traceOut("< Level.Level()");
    }

    public void release() {
        Debug.traceIn("> Level.release()");
        GameStateCommon.ReleaseInstance();
        GameStateCareer.ReleaseInstance();
        Robot.ReleaseInstance();
        Blocks.ReleaseInstance();
        Bonuses.ReleaseInstance();
        ScoreLabels.ReleaseInstance();
        System.gc();
        Debug.traceOut("< Level.release()");
    }

    public void newGame() {
        Debug.traceIn("> Level.newGame()");
        if (this.iGameType == 0) {
            this.createQuickGame();
        } else {
            this.createCareerGame();
        }
        Debug.traceOut("< Level.newGame()");
    }

    private void createQuickGame() {
        Debug.traceIn("> Level.createQuickGame()");
        this.gssCommon.initData();
        this.gssCommon.iBlocksToNextLev = this.blocks_getBlocksToNextLevel();
        this.blocks.initBlocks();
        Debug.traceOut("< Level.createQuickGame()");
    }

    private void createCareerGame() {
        Debug.traceIn("> Level.createCareerGame()");
        this.gssCommon.initData();
        this.gssCommon.iBlocksToNextLev = this.blocks_getBlocksToNextLevel();
        this.blocks.initBlocks();
        this.generateCloud();
        Debug.traceOut("< Level.createCareerGame()");
    }

    public boolean nextLevelQuickGame() {
        Debug.traceIn("> Level.nextLevel()");
        boolean bRetVal = false;
        ++this.gssCommon.iLevel;
        Debug.trace("iLevel = " + this.gssCommon.iLevel);
        if (this.iGameType == 0) {
            int iStage = this.gssCommon.iLevel / 5;
            if (iStage >= 3) {
                iStage = 2;
            }
            if (iStage != this.gssCommon.iStage) {
                this.gssCommon.iStage = iStage;
                bRetVal = true;
                this.gssCommon.upgradeRobotQuick();
            }
        }
        this.gssCommon.iBlocksToNextLev = this.blocks_getBlocksToNextLevel();
        this.gssCommon.resetOnLevelStart();
        this.blocks.initBlocks();
        Debug.traceOut("< Level.nextLevel()");
        return bRetVal;
    }

    public boolean nextLevelCareerGame(int stageIdx) {
        Debug.traceIn("> Level.nextLevel()");
        int iOldStage = this.gssCommon.iStage;
        switch (stageIdx) {
            case 0: {
                this.gssCommon.iStage = 0;
                this.gssCareer.iMapLevel[0] = this.gssCareer.iMapLevel[0] + 1;
                break;
            }
            case 1: {
                this.gssCommon.iStage = 1;
                this.gssCareer.iMapLevel[1] = this.gssCareer.iMapLevel[1] + 1;
                break;
            }
            case 2: {
                this.gssCommon.iStage = 2;
                this.gssCareer.iMapLevel[2] = this.gssCareer.iMapLevel[2] + 1;
            }
        }
        this.gssCommon.iBlocksToNextLev = this.blocks_getBlocksToNextLevel();
        this.gssCommon.resetOnLevelStart();
        this.blocks.initBlocks();
        Debug.traceOut("< Level.nextLevel()");
        return iOldStage != this.gssCommon.iStage;
    }

    private void saveData(String sRSName) {
        Debug.traceIn("> Level.saveData(" + sRSName + ")");
        Common.deleteRecordStore(sRSName);
        try {
            RecordStore rsobj_settings = RecordStore.openRecordStore((String)sRSName, (boolean)true);
            ByteArrayOutputStream array = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(array);
            this.gssCommon.saveData(data);
            if (sRSName.equals(RS_CAREER)) {
                this.gssCareer.saveData(data);
            }
            this.blocks.saveData(data);
            rsobj_settings.addRecord(array.toByteArray(), 0, array.toByteArray().length);
            rsobj_settings.closeRecordStore();
            array = null;
            Object var3_5 = null;
        }
        catch (Exception e) {
            Debug.trace("Error message : " + e.getMessage());
            e.printStackTrace();
        }
        Debug.traceOut("< Level.saveData()");
    }

    public void saveGame() {
        Debug.traceIn("> Level.saveGame()");
        String sRSName = RS_QUICK;
        if (this.iGameType == 1) {
            sRSName = RS_CAREER;
        }
        this.saveData(sRSName);
        Debug.traceOut("< Level.saveGame()");
    }

    public static void deleteQuick() {
        Common.deleteRecordStore(RS_QUICK);
    }

    public static void deleteCareer() {
        Common.deleteRecordStore(RS_CAREER);
    }

    private void loadData(String sRSName) {
        Debug.traceIn("> Level.loadData()");
        try {
            RecordStore rsobj_settings = RecordStore.openRecordStore((String)sRSName, (boolean)false);
            RecordEnumeration enumeration = rsobj_settings.enumerateRecords(null, null, false);
            int i = enumeration.nextRecordId();
            byte[] record = rsobj_settings.getRecord(i);
            DataInputStream data = new DataInputStream(new ByteArrayInputStream(record));
            this.gssCommon.loadData(data);
            if (sRSName.equals(RS_CAREER)) {
                this.gssCareer.loadData(data);
            }
            this.blocks.loadData(data);
            rsobj_settings.closeRecordStore();
        }
        catch (Exception e) {
            Debug.trace("Error message : " + e.getMessage());
            e.printStackTrace();
        }
        Debug.traceOut("< Level.loadData()");
    }

    public void loadGame() {
        Debug.traceIn("> Level.loadGame()");
        String sRSName = RS_QUICK;
        if (this.iGameType == 1) {
            sRSName = RS_CAREER;
        }
        this.loadData(sRSName);
        Debug.traceOut("< Level.loadGame()");
    }

    public void update() {
        this.robot.update();
        this.blocks.update();
        this.bonuses.update();
        this.gssCommon.updateMultiplier();
        this.gssCommon.updateBonusesTime();
        this.updateCloud();
    }

    private void paintStatus(Graphics g) {
        int iRoofPosX = Defines.WIDTH - Resources.iRoofW >> 1;
        int iRoofPosY = 0;
        if (!this.blocks.isAddingRow()) {
            iRoofPosY = Defines.HEIGHT - Resources.iRoofH + 2;
        }
        if (this.blocks.isAddingRow()) {
            iRoofPosY = Defines.HEIGHT - Resources.iRoofH + 2 - Common.getRandomUInt(2);
        }
        Resources.sprRoof.setFrame(this.gssCommon.iStage);
        Resources.sprRoof.setPosition(iRoofPosX, iRoofPosY);
        Resources.sprRoof.paint(g);
        Resources.sprLvlAnimal.setFrame(this.gssCommon.iStage);
        Resources.sprLvlAnimal.setPosition(0, Defines.HEIGHT - Resources.iAnimalH);
        Resources.sprLvlAnimal.paint(g);
        Resources.paintStatusBarNumbers(g, this);
    }

    public void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Defines.WIDTH, Defines.HEIGHT);
        Resources.paintGameBackground(g);
        this.paintCloud(g);
        Resources.paintGameGround(g, this.blocks.getTrasholdY());
        this.blocks.paintDeletingAnimals(g);
        this.robot.paint(g);
        this.blocks.paint(g);
        this.bonuses.paint(g);
        this.scoreLabels.paint(g);
        this.paintStatus(g);
        this.paintMultiplier(g);
    }

    public void paintMultiplier(Graphics g) {
        if (GameStateCommon.sInstance.iScoreMul > 0) {
            g.setClip(0, 0, Common.barValue(GameStateCommon.sInstance.iScoreMulTime, GameStateCommon.sInstance.getMultiplierTime(), Defines.WIDTH - 2), Resources.imgStatDecor.getHeight());
            g.drawImage(Resources.imgStatDecor, 0, 0, 0);
            g.setClip(0, 0, Defines.WIDTH, Defines.HEIGHT);
        }
    }

    public void updateCloud() {
        for (int i = 0; i < 3; ++i) {
            int[] nArray = this.iCloudCoord[i];
            nArray[0] = nArray[0] + 1;
            if (this.iCloudCoord[i][0] < Defines.WIDTH) continue;
            this.iCloudCoord[i][2] = Common.getRandomUInt(3);
            if (i == 0) {
                this.iCloudCoord[i][1] = 0;
            }
            if (i == 1) {
                this.iCloudCoord[i][1] = Resources.iCloud1H + Common.getRandomUInt(this.blocks.getTrasholdY() - Resources.iCloud1H);
            }
            if (i == 2) {
                this.iCloudCoord[i][1] = (Resources.iCloud1H << 1) + Common.getRandomUInt(this.blocks.getTrasholdY() - Resources.iCloud1H);
            }
            if (this.iCloudCoord[i][2] == 0) {
                this.iCloudCoord[i][0] = 0 - Resources.iCloud1W - Common.getRandomUInt(20) * 30;
            }
            if (this.iCloudCoord[i][2] == 1) {
                this.iCloudCoord[i][0] = 0 - Resources.iCloud2W - Common.getRandomUInt(20) * 30;
            }
            if (this.iCloudCoord[i][2] != 2) continue;
            this.iCloudCoord[i][0] = 0 - Resources.iCloud3W - Common.getRandomUInt(20) * 30;
        }
    }

    public void generateCloud() {
        for (int i = 0; i < 3; ++i) {
            this.iCloudCoord[i][0] = Common.getRandomUInt(Defines.WIDTH);
            if (i == 0) {
                this.iCloudCoord[i][1] = 0;
            }
            if (i == 1) {
                this.iCloudCoord[i][1] = Resources.iCloud1H + Common.getRandomUInt(this.blocks.getTrasholdY() - Resources.iCloud1H);
            }
            if (i == 2) {
                this.iCloudCoord[i][1] = (Resources.iCloud1H << 1) + Common.getRandomUInt(this.blocks.getTrasholdY() - Resources.iCloud1H);
            }
            this.iCloudCoord[i][2] = Common.getRandomUInt(3);
        }
    }

    public void paintCloud(Graphics g) {
        for (int i = 0; i < 3; ++i) {
            if (this.iCloudCoord[i][2] == 0) {
                g.drawImage(Resources.imgCloud1, this.iCloudCoord[i][0], this.iCloudCoord[i][1], 0);
            }
            if (this.iCloudCoord[i][2] == 1) {
                g.drawImage(Resources.imgCloud2, this.iCloudCoord[i][0], this.iCloudCoord[i][1], 0);
            }
            if (this.iCloudCoord[i][2] != 2) continue;
            g.drawImage(Resources.imgCloud3, this.iCloudCoord[i][0], this.iCloudCoord[i][1], 0);
        }
    }

    public void incScore(int iInc) {
        this.gssCommon.iScore += iInc;
    }

    public boolean completed() {
        return this.gssCommon.iBlocksToNextLev <= 0 && !this.blocks.bShakeNeeded && this.blocks.iStackedBlocksCnt < 4;
    }

    public boolean failed() {
        return this.blocks.isAnyLastRowOverMax();
    }

    public int blocks_getInitialRowsCount() {
        int rowsNum = 4;
        if (this.iGameType == 0) {
            rowsNum = 4 + this.gssCommon.iLevel / 5;
            if (rowsNum > 7) {
                rowsNum = 7;
            }
        } else if (this.iGameType == 1) {
            rowsNum = this.gssCareer.iMapLevel[this.gssCareer.iMapSelIdx] < 4 ? 4 : (this.gssCareer.iMapLevel[this.gssCareer.iMapSelIdx] < 8 ? 5 : (this.gssCareer.iMapLevel[this.gssCareer.iMapSelIdx] < 16 ? 6 : 7));
        }
        return rowsNum;
    }

    public int blocks_getBlocksToNextLevel() {
        int iLevel = this.iGameType == 0 ? this.gssCommon.iLevel : this.gssCareer.iMapLevel[this.gssCareer.iMapSelIdx] * (this.gssCareer.iMapSelIdx + 1);
        return 100 + iLevel * 20;
    }

    public int blocks_getLevelColors() {
        int addColorsNum = 0;
        if (this.iGameType == 0) {
            addColorsNum = this.gssCommon.iLevel / 3;
            if (addColorsNum > 5) {
                addColorsNum = 5;
            }
        } else {
            addColorsNum = this.gssCareer.iMapLevel[this.gssCareer.iMapSelIdx] / 3;
            if (addColorsNum > 5) {
                addColorsNum = 5;
            }
        }
        return 3 + addColorsNum;
    }

    public int blocks_getBonusBlock() {
        Debug.trace("> Level.blocks_initBonus()");
        int iLevel = this.iGameType == 0 ? this.gssCommon.iLevel : this.gssCareer.iMapLevel[this.gssCareer.iMapSelIdx];
        this.blocks.getClass();
        int iRetVal = 130;
        if (Common.getRandomUInt(2) == 1 && iLevel / 3 > 0) {
            switch (Common.getRandomUInt(iLevel / 3)) {
                case 1: {
                    this.blocks.getClass();
                    iRetVal = 110;
                    break;
                }
                case 2: {
                    this.blocks.getClass();
                    iRetVal = 120;
                    break;
                }
                default: {
                    this.blocks.getClass();
                    iRetVal = 130;
                    break;
                }
            }
        } else {
            this.blocks.getClass();
            iRetVal = 200 + Common.getRandomUInt(this.blocks_getLevelColors());
        }
        Debug.traceOut("< Level.blocks_initBonus()");
        this.blocks.getClass();
        iRetVal = 110;
        return iRetVal;
    }

    public int blocks_getBlocksToBonus() {
        this.blocks.getClass();
        this.blocks.getClass();
        return 3 * 7 + Common.getRandomUInt(2 * 7);
    }

    private void blocks_newBlockIntoColumn(int iCol, int iTime) {
        --this.gssCommon.iBlocksToBonus;
        if (this.gssCommon.iBlocksToBonus <= 0) {
            this.blocks.iaNewBlocks[iCol] = this.blocks_getBonusBlock();
            this.gssCommon.iBlocksToBonus = this.blocks_getBlocksToBonus();
        } else {
            this.blocks.iaNewBlocks[iCol] = Common.getRandomUInt(this.blocks_getLevelColors());
        }
        this.blocks.iaNewBlocksShift[iCol] = 0;
        this.blocks.iaNewBlocksTime[iCol] = iTime;
    }

    public void blocks_initNewBlocks() {
        Debug.traceIn("> Level.initNewBlocks()");
        int iLevelMap = this.iGameType == 0 ? this.gssCommon.iLevel / 5 : this.gssCareer.iMapSelIdx;
        int iLevelSpeedMul = this.iGameType == 0 ? this.gssCommon.iLevel % 5 : this.gssCareer.iMapLevel[this.gssCareer.iMapSelIdx];
        int iLevelSpeedDiv = this.iGameType == 0 ? 1 : 4;
        int iMod = 0;
        block0 : switch (iLevelMap) {
            case 0: {
                int i = 0;
                while (true) {
                    this.blocks.getClass();
                    if (i >= 7) break block0;
                    this.blocks_newBlockIntoColumn(i, 6000 - iLevelSpeedMul * 600 / iLevelSpeedDiv);
                    ++i;
                }
            }
            case 1: {
                iMod = this.gssCommon.iNewRows % 2;
                int i = 0;
                while (true) {
                    this.blocks.getClass();
                    if (i >= 7) break;
                    if (i % 2 == iMod) {
                        this.blocks_newBlockIntoColumn(i, 2500 - iLevelSpeedMul * 600 / iLevelSpeedDiv);
                    }
                    ++i;
                }
                ++this.gssCommon.iNewRows;
                break;
            }
            case 2: {
                iMod = this.gssCommon.iNewRows % 4;
                if (iMod == 0) {
                    this.blocks_newBlockIntoColumn(0, 1500 - iLevelSpeedMul * 600 / iLevelSpeedDiv);
                    this.blocks_newBlockIntoColumn(6, 1500 - iLevelSpeedMul * 600 / iLevelSpeedDiv);
                }
                if (iMod == 1) {
                    this.blocks_newBlockIntoColumn(1, 1000 - iLevelSpeedMul * 100 / iLevelSpeedDiv);
                    this.blocks_newBlockIntoColumn(5, 1000 - iLevelSpeedMul * 100 / iLevelSpeedDiv);
                }
                if (iMod == 2) {
                    this.blocks_newBlockIntoColumn(2, 1000 - iLevelSpeedMul * 100 / iLevelSpeedDiv);
                    this.blocks_newBlockIntoColumn(4, 1000 - iLevelSpeedMul * 100 / iLevelSpeedDiv);
                }
                if (iMod == 3) {
                    this.blocks_newBlockIntoColumn(3, 1000 - iLevelSpeedMul * 100 / iLevelSpeedDiv);
                }
                ++this.gssCommon.iNewRows;
                break;
            }
            default: {
                int columnsCount = (this.gssCommon.iLevel - 15) / 3 + 1;
                Blocks.sInstance.getClass();
                if (columnsCount > 7) {
                    Blocks.sInstance.getClass();
                    columnsCount = 7;
                }
                int speed = 1000 - (this.gssCommon.iLevel - 15) % 3 * 500;
                Arrays.resetIntsArray(this.quickGameOverMapArray);
                int column = 0;
                for (int i = 0; i < columnsCount; ++i) {
                    do {
                        Blocks.sInstance.getClass();
                        column = Common.getRandomUInt(7);
                    } while (Arrays.arrayContainsInt(this.quickGameOverMapArray, column));
                    Arrays.addIntToArray(this.quickGameOverMapArray, column);
                    this.blocks_newBlockIntoColumn(column, speed);
                }
            }
        }
        Debug.traceOut("< Level.initNewBlocks()");
    }
}

