/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class SoundManager {
    public static final byte KSTMIDI = 0;
    public static final byte KSTWAV = 1;
    private static final String[] KMIMETypes = new String[]{"audio/midi", "audio/x-wav"};
    public static final byte KSfxFlgPlayIn2ndChannel = 1;
    public static final byte KSfxFlgPlayIn3rdChannel = 2;
    public static final byte KSfxFlgResumeAfterInterrupt = 4;
    private int iChannelCnt;
    private byte[] iSfxFlagList;
    private Player[] iPlayerList;
    private boolean iIsSoundOn = true;
    private boolean iIsInitialized;
    public static final int KDefVolume = 100;
    private int[] iVolume;
    private Player[] iPlayer;
    private int[] iLastPlayed;

    public SoundManager(int aChannelCnt) {
        this.iChannelCnt = aChannelCnt;
        int i = aChannelCnt;
        this.iVolume = new int[i];
        this.iPlayer = new Player[aChannelCnt];
        this.iLastPlayed = new int[aChannelCnt];
        i = aChannelCnt;
        while (i-- != 0) {
            this.iVolume[i] = 100;
            this.iLastPlayed[i] = -1;
        }
    }

    private Player InitializePlayer(Player aPlayer, String aFileName, int aType) {
        try {
            aPlayer = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(aFileName), (String)KMIMETypes[aType]);
            aPlayer.realize();
        }
        catch (Throwable t) {
            if (aPlayer != null) {
                aPlayer.close();
            }
            return null;
        }
        return aPlayer;
    }

    private boolean InitializeSfx(int aSfxId, String aFileName, int aType) {
        this.iPlayerList[aSfxId] = this.InitializePlayer(this.iPlayerList[aSfxId], aFileName, aType);
        return this.iPlayerList[aSfxId] != null;
    }

    private void ReleaseSfx(int aSfxId) {
        int channel;
        int n = channel = (this.iSfxFlagList[aSfxId] & 1) == 0 ? 0 : 1;
        if (this.iLastPlayed[channel] == aSfxId) {
            this.iLastPlayed[channel] = -1;
            this.Stop(channel);
        } else {
            this.iPlayerList[aSfxId].close();
        }
        this.iPlayerList[aSfxId] = null;
    }

    public void Release() {
        if (!this.iIsInitialized) {
            return;
        }
        for (int i = 0; i < this.iSfxFlagList.length; ++i) {
            this.ReleaseSfx(i);
        }
        this.iSfxFlagList = null;
        this.iIsInitialized = false;
    }

    public boolean LoadPlayList(String[] aFileNames, byte[] aTypes, byte[] aFlags) {
        this.Release();
        this.iSfxFlagList = aFlags;
        this.iPlayerList = new Player[aFileNames.length];
        for (int i = 0; i < aFileNames.length; ++i) {
            this.InitializeSfx(i, aFileNames[i], aTypes[i]);
        }
        this.iIsInitialized = true;
        return true;
    }

    public boolean ChangeSfxInPlayList(int aSfxId, String aFileName, byte aType, byte aFlags) {
        if (!this.iIsInitialized) {
            return false;
        }
        this.ReleaseSfx(aSfxId);
        this.iSfxFlagList[aSfxId] = aFlags;
        return this.InitializeSfx(aSfxId, aFileName, aType);
    }

    public boolean Play(int aSfxId, int aRepeat) {
        int channel;
        if (!this.iIsSoundOn || !this.iIsInitialized) {
            return true;
        }
        int n = channel = (this.iSfxFlagList[aSfxId] & 1) == 0 ? 0 : 1;
        if (this.iVolume[channel] == 0) {
            return true;
        }
        if (this.iLastPlayed[channel] != aSfxId) {
            this.Stop(channel);
            this.iPlayer[channel] = this.iPlayerList[aSfxId];
        } else {
            try {
                this.iPlayer[channel].stop();
                this.iPlayer[channel].setMediaTime(-1L);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.iPlayer[channel] == null) {
            return false;
        }
        this.iPlayer[channel].setLoopCount(aRepeat);
        try {
            this.iPlayer[channel].prefetch();
            VolumeControl volCtrl = (VolumeControl)this.iPlayer[channel].getControl("VolumeControl");
            if (volCtrl != null) {
                volCtrl.setLevel(this.iVolume[channel]);
            }
            this.iPlayer[channel].start();
        }
        catch (Throwable t) {
            this.iLastPlayed[channel] = -1;
            return false;
        }
        this.iLastPlayed[channel] = aSfxId;
        return true;
    }

    public void Stop() {
        for (int i = 0; i < this.iChannelCnt; ++i) {
            this.Stop(i);
        }
    }

    public void Stop(int aChannelId) {
        if (this.iPlayer[aChannelId] == null) {
            return;
        }
        try {
            int state = this.iPlayer[aChannelId].getState();
            if (state == 300 || state == 400) {
                this.iPlayer[aChannelId].stop();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.iPlayer[aChannelId] = null;
        this.iLastPlayed[aChannelId] = -1;
    }

    public void SetSoundOn(boolean aOn) {
        this.iIsSoundOn = aOn;
        if (!aOn) {
            this.Stop();
        }
    }

    public boolean IsSoundOn() {
        return this.iIsSoundOn;
    }

    public void SetVolume(int aChannelId, int aLevel) {
        if (aLevel < 0) {
            aLevel = 0;
        } else if (aLevel > 100) {
            aLevel = 100;
        }
        this.iVolume[aChannelId] = aLevel;
        Player player = this.iPlayer[aChannelId];
        if (player != null && player.getState() == 400) {
            if (aLevel != 0) {
                VolumeControl volCtrl = (VolumeControl)player.getControl("VolumeControl");
                if (volCtrl != null) {
                    volCtrl.setLevel(this.iVolume[aChannelId]);
                }
            } else {
                this.Stop(aChannelId);
            }
        }
    }

    public int GetVolume(int aChannel) {
        return this.iVolume[aChannel];
    }
}

