/*
 * Decompiled with CFR 0.152.
 */
package sims_pets;

import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import sims_pets.GameObject;

public final class TileMap
extends GameObject {
    public static final boolean DEBUG = false;
    public static final int kTileWidth = 16;
    public static final int kTileHeight = 16;
    private static final int kTileShift = 4;
    private short sFlags;
    public int iMapWidth;
    public int iMapHeight;
    public byte[] pTileData;
    public byte[] pBoundsData;
    public byte[] pCodeData;
    Image[] pTileImage;
    private int m_iTileSetID;
    private int m_iTileMapID;

    public TileMap(int n, int n2) {
        this.m_iTileSetID = n2;
        this.m_iTileMapID = n;
    }

    public int getIndex(int n, int n2) {
        int n3 = -1;
        if (n >= 0 && n < this.iMapWidth << 4 && n2 >= 0 && n2 < this.iMapHeight << 4) {
            int n4 = n >> 4;
            int n5 = n2 >> 4;
            if (n5 < this.iMapHeight && n4 < this.iMapWidth) {
                n3 = this.iMapWidth * n5 + n4;
            }
        }
        return n3;
    }

    public int[] getPointFromIndex(int n) {
        int[] nArray = new int[2];
        nArray[1] = n / this.iMapWidth << 4;
        nArray[0] = n % this.iMapWidth << 4;
        nArray[1] = nArray[1] + 8;
        nArray[0] = nArray[0] + 8;
        return nArray;
    }

    public int getIndexBelow(int n) {
        int n2 = -1;
        if (n >= 0) {
            int n3 = n / this.iMapWidth;
            int n4 = n - n3 * this.iMapWidth;
            if (n3 < this.iMapHeight - 1) {
                n2 = n + this.iMapWidth;
            }
        }
        return n2;
    }

    public int getIndexAbove(int n) {
        int n2 = -1;
        if (n >= 0) {
            int n3 = n / this.iMapWidth;
            int n4 = n - n3 * this.iMapWidth;
            if (n3 > 0) {
                n2 = n - this.iMapWidth;
            }
        }
        return n2;
    }

    public boolean onLoadResource(int n) {
        int n2 = this.m_iTileMapID;
        int n3 = this.m_iTileSetID;
        InputStream inputStream = this.getClass().getResourceAsStream("/" + (n2 & 0xFFF));
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        boolean bl = false;
        int n4 = 0;
        try {
            dataInputStream.skip(4L);
            int n5 = (dataInputStream.read() & 0xFF) + ((dataInputStream.read() & 0xFF) << 8);
            n5 = (dataInputStream.read() & 0xFF) + ((dataInputStream.read() & 0xFF) << 8);
            n5 = dataInputStream.read();
            n5 = dataInputStream.read();
            dataInputStream.skip(2L);
            n5 = (dataInputStream.read() & 0xFF) + ((dataInputStream.read() & 0xFF) << 8);
            n5 = (dataInputStream.read() & 0xFF) + ((dataInputStream.read() & 0xFF) << 8);
            dataInputStream.skip(8L);
            n4 = 0;
            do {
                ++n4;
            } while (dataInputStream.read() != 0);
            n4 = (n4 + 3 & 0xFFFFFFFC) - n4;
            dataInputStream.skip(n4);
            dataInputStream.skip(2L);
            this.sFlags = (short)((dataInputStream.read() & 0xFF) + ((dataInputStream.read() & 0xFF) << 8));
            this.iMapWidth = (dataInputStream.read() & 0xFF) + ((dataInputStream.read() & 0xFF) << 8);
            this.iMapHeight = (dataInputStream.read() & 0xFF) + ((dataInputStream.read() & 0xFF) << 8);
            dataInputStream.skip(12L);
            n4 = this.iMapWidth * this.iMapHeight;
            n5 = (n4 + 3 & 0xFFFFFFFC) - n4;
            this.pTileData = new byte[n4];
            dataInputStream.readFully(this.pTileData);
            dataInputStream.skip(n5);
            this.pBoundsData = new byte[n4];
            dataInputStream.readFully(this.pBoundsData);
            dataInputStream.skip(n5);
            this.pCodeData = new byte[n4];
            dataInputStream.readFully(this.pCodeData);
            dataInputStream.skip(n5);
            dataInputStream.close();
            Image image = Image.createImage((String)("/" + (n3 & 0xFFF)));
            if (image != null) {
                this.setWidth(this.iMapWidth << 4 << 12);
                this.setHeight(this.iMapHeight << 4 << 12);
                this.onUpdateRect();
                n5 = image.getWidth() >> 4;
                this.pTileImage = new Image[n5];
                while (--n5 >= 0) {
                    this.pTileImage[n5] = Image.createImage((Image)image, (int)(n5 * 16), (int)0, (int)16, (int)16, (int)0);
                }
                image = null;
            }
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public void onPaint(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n2 + n4;
        int n8 = n + n3;
        int n9 = n5 & 0xF;
        int n10 = n6 & 0xF;
        int n11 = (n6 - n10 >> 4) * this.iMapWidth;
        int n12 = graphics.getClipX();
        int n13 = graphics.getClipY();
        int n14 = graphics.getClipWidth();
        int n15 = graphics.getClipHeight();
        int n16 = -1;
        Image image = null;
        graphics.setClip(n, n2, n3, n4);
        for (int i = n2 - n10; i < n7; i += 16) {
            int n17 = n5 - n9 >> 4;
            for (int j = n - n9; j < n8; j += 16) {
                int n18 = this.pTileData[n11 + n17] - 1 & 0xFF;
                if (n18 != n16) {
                    image = this.pTileImage[n18];
                    n16 = n18;
                }
                graphics.drawImage(image, j, i, 20);
                ++n17;
            }
            n11 += this.iMapWidth;
        }
        graphics.setClip(n12, n13, n14, n15);
    }

    public void onReleaseResource() {
    }

    public final int getTilesPerRow() {
        return this.iMapWidth;
    }

    public final int getTilesPerColumn() {
        return this.iMapHeight;
    }

    public final int getMapCodeByPosition(int n, int n2) {
        if (this.pCodeData != null) {
            return this.pCodeData[n2 * this.iMapWidth + n] & 0xFF;
        }
        return 0;
    }

    public final int getXPixelPosition(int n, int n2) {
        int n3 = n2 * this.iMapWidth + n;
        int n4 = n3 % this.iMapWidth;
        return (n4 << 4) + 8;
    }

    public final int getYPixelPosition(int n, int n2) {
        int n3 = n2 * this.iMapWidth + n;
        int n4 = n3 / this.iMapWidth;
        return (n4 << 4) + 8;
    }
}

