/*
 * Decompiled with CFR 0.152.
 */
package sims_pets;

import javax.microedition.lcdui.Graphics;
import sims_pets.Font;
import sims_pets.GameApp;
import sims_pets.GameObject;

public class TextObject
extends GameObject {
    public static final int kHorzJustLeft = 0;
    public static final int kHorzJustCenter = 1;
    public static final int kHorzJustRight = 2;
    public static final int kVertJustTop = 0;
    public static final int kVertJustCenter = 1;
    public static final int kVertJustBottom = 2;
    public static final int kSameKeyTime = 2000;
    public boolean m_bPaintBackground;
    public boolean m_bPaintBorder;
    public boolean m_bPaintBorderOutline;
    public boolean m_bEditable;
    public boolean m_bRoundedEnds;
    public Font m_pFont;
    public byte[] m_pText;
    public int m_iStringID;
    public int m_iBufferLength;
    public int m_iBackgroundColor;
    public int m_iBorderColor;
    public int m_iBorderOutlineColor;
    public int m_iHorzJustification;
    public int m_iVertJustification;
    public int m_iCharTimer;
    public int m_iCaretColor;
    public int m_iCaretPos;
    public int m_iMaxEditLength;
    public int m_iKeyMask;
    public int m_iCharIndex;

    public TextObject() {
        this.m_pFont = GameApp.m_instance.getFont();
        this.m_iStringID = -1;
    }

    public TextObject(Font font) {
        this.m_pFont = font;
        this.m_iStringID = -1;
    }

    public void setPaintBackground(boolean bl) {
        this.m_bPaintBackground = bl;
    }

    public boolean isPaintBackground() {
        return this.m_bPaintBackground;
    }

    public void setPaintBorder(boolean bl) {
        this.m_bPaintBorder = bl;
    }

    public boolean isPaintBorder() {
        return this.m_bPaintBorder;
    }

    public void setPaintBorderOutline(boolean bl) {
        this.m_bPaintBorderOutline = bl;
    }

    public boolean isPaintBorderOutline() {
        return this.m_bPaintBorderOutline;
    }

    public void setEditable(boolean bl) {
        this.m_bEditable = bl;
    }

    public boolean isEditable() {
        return this.m_bEditable;
    }

    public void setRoundedEnds(boolean bl) {
        this.m_bRoundedEnds = bl;
    }

    public boolean isRoundedEnds() {
        return this.m_bRoundedEnds;
    }

    private void releaseText() {
        if (this.m_pText != null) {
            GameApp.releaseStringBuffer(this.m_pText);
            this.m_pText = null;
        }
        this.m_iStringID = -1;
        this.m_iBufferLength = 0;
    }

    private final void fillCircle(Graphics graphics, int n, int n2, int n3) {
        int n4 = n3 - 1 << 11;
        int n5 = GameApp.mul(n4, n4);
        int n6 = (n << 12) + 2048;
        int n7 = (n2 << 12) + 2048;
        int n8 = n7 + n4;
        int n9 = n7 + (n3 - 1 << 12);
        for (int i = n7; i <= n9; i += 4096) {
            int n10 = n8 - i;
            int n11 = GameApp.mul(n10, n10);
            int n12 = GameApp.sqrt(n5 - n11);
            int n13 = i >> 12;
            graphics.drawLine(n6 - n12 >> 12, n13, n6 + n12 >> 12, n13);
        }
    }

    public void sizeToText() {
        this.m_iWidth = 0;
        this.m_iHeight = 0;
        if (this.m_pText != null && this.m_pFont != null) {
            switch (this.m_iHorzJustification) {
                case 1: {
                    int n = 4;
                    break;
                }
                case 2: {
                    int n = 2;
                    break;
                }
                default: {
                    int n = 1;
                }
            }
            switch (this.m_iVertJustification) {
                case 1: {
                    n |= 0x10;
                    break;
                }
            }
            this.m_pFont.textRender(GameApp.m_instance.getGraphics(), 0, 0, GameApp.m_instance.m_iScreenWidth, GameApp.m_instance.m_iScreenHeight, n |= 0x100, this.m_pText, 0, 0, -1, true, null);
            this.m_iWidth = this.m_pFont.getMeasuredWidth() << 12;
            this.m_iHeight = this.m_pFont.getMeasuredHeight() << 12;
        }
    }

    public int StrLen(byte[] byArray) {
        int n = 0;
        if (byArray != null && byArray.length != 0) {
            for (n = 0; n < byArray.length && byArray[n] != 0; ++n) {
            }
        }
        return n;
    }

    public int getLength() {
        if (this.m_pText != null) {
            return this.StrLen(this.m_pText);
        }
        return 0;
    }

    public void setText(int n) {
        this.releaseText();
        if (n > -1) {
            this.m_pText = GameApp.loadStringResource(n);
        }
        this.m_iStringID = n;
        if (this.m_pText != null) {
            this.m_iBufferLength = this.StrLen(this.m_pText) + 1;
        }
    }

    public void setText(byte[] byArray, boolean bl) {
        this.releaseText();
        this.m_pText = bl || byArray == null ? byArray : GameApp.dupeStringBuffer(byArray);
        this.m_iBufferLength = this.m_pText != null ? this.StrLen(this.m_pText) + 1 : 0;
    }

    public void setNumber(int n) {
        this.setNumber(n, false);
    }

    public void setNumber(int n, boolean bl) {
        this.setText(GameApp.getStringBufferForNumber(n), true);
        if (bl) {
            int n2 = n < 0 ? 1 : 0;
            int n3 = this.m_iBufferLength - 1;
            while ((n3 -= 3) > n2) {
                this.insertCharAt(n3, (byte)44);
            }
        }
    }

    public void setFixedNumber(int n, int n2) {
    }

    public Font getFont() {
        return this.m_pFont;
    }

    public void setFont(Font font) {
        this.m_pFont = font;
    }

    public byte[] getText() {
        return this.m_pText;
    }

    public int getBackgroundColor() {
        return this.m_iBackgroundColor;
    }

    public void setBackgroundColor(int n) {
        this.m_iBackgroundColor = n;
    }

    public int getBorderColor() {
        return this.m_iBorderColor;
    }

    public void setBorderColor(int n) {
        this.m_iBorderColor = n;
    }

    public int getBorderOutlineColor() {
        return this.m_iBorderOutlineColor;
    }

    public void setBorderOutlineColor(int n) {
        this.m_iBorderOutlineColor = n;
    }

    public int getHorzJustification() {
        return this.m_iHorzJustification;
    }

    public void setHorzJustification(int n) {
        this.m_iHorzJustification = n;
    }

    public int getVertJustification() {
        return this.m_iVertJustification;
    }

    public void setVertJustification(int n) {
        this.m_iVertJustification = n;
    }

    public int getCaretColor() {
        return this.m_iCaretColor;
    }

    public void setCaretColor(int n) {
        this.m_iCaretColor = n;
    }

    public int getCaretPosition() {
        return this.m_iCaretPos;
    }

    void setCaretPosition(int n) {
        int n2 = 0;
        this.m_iCaretPos = n;
        if (this.m_iCaretPos < 0) {
            this.m_iCaretPos = 0;
        } else {
            if (this.m_pText != null) {
                n2 = this.StrLen(this.m_pText);
            }
            if (this.m_iCaretPos > n2) {
                this.m_iCaretPos = n2;
            }
        }
    }

    public int getMaxEditLength() {
        return this.m_iMaxEditLength;
    }

    public void setMaxEditLength(int n) {
        this.m_iMaxEditLength = n;
    }

    public int getKeyMask() {
        return this.m_iKeyMask;
    }

    public int getCharIndex() {
        return this.m_iCharIndex;
    }

    void insertCharAt(int n, byte by) {
        this.m_iStringID = -1;
        if (this.m_pText != null) {
            int n2 = this.StrLen(this.m_pText);
            if (n < 0) {
                n = 0;
            }
            if (n > n2) {
                n = n2;
            }
            if (n2 + 2 > this.m_iBufferLength) {
                byte[] byArray = GameApp.getStringBuffer(n2 + 2);
                if (n > 0) {
                    System.arraycopy(this.m_pText, 0, byArray, 0, n);
                }
                byArray[n] = by;
                byArray[n + 1] = 0;
                if (n < n2) {
                    System.arraycopy(this.m_pText, n, byArray, n + 1, n2 - n);
                }
                GameApp.releaseStringBuffer(this.m_pText);
                this.m_pText = byArray;
                this.m_iBufferLength = n2 + 2;
            } else {
                for (int i = n2; i >= n; --i) {
                    this.m_pText[i + 1] = this.m_pText[i];
                }
                this.m_pText[n] = by;
            }
        } else {
            this.m_pText = GameApp.getStringBuffer(2);
            this.m_pText[0] = by;
            this.m_pText[1] = 0;
            this.m_iBufferLength = 2;
        }
    }

    void replaceCharAt(int n, byte by) {
        this.m_iStringID = -1;
        if (this.m_pText != null) {
            int n2 = this.StrLen(this.m_pText);
            if (n < 0) {
                n = 0;
            }
            if (n >= n2) {
                n = n2 - 1;
            }
            if (n >= 0) {
                this.m_pText[n] = by;
            }
        }
    }

    void removeCharAt(int n) {
        this.m_iStringID = -1;
        if (this.m_pText != null) {
            int n2 = this.StrLen(this.m_pText);
            if (n2 <= 1) {
                this.m_pText[0] = 0;
            } else {
                if (n < 0) {
                    n = 0;
                }
                if (n >= n2) {
                    n = n2 - 1;
                }
                for (int i = n + 1; i < n2; ++i) {
                    this.m_pText[i - 1] = this.m_pText[i];
                }
                this.m_pText[i - 1] = 0;
            }
        }
    }

    void handleKeyPressed(int n) {
        if (this.isEditable()) {
            GameApp gameApp = GameApp.m_instance;
            byte[] byArray = null;
            int n2 = 0;
            int n3 = 0;
            if ((n & 1) != 0) {
                byArray = gameApp.m_pCharKeyMap[0];
                n = 1;
            } else if ((n & 2) != 0) {
                byArray = gameApp.m_pCharKeyMap[1];
                n = 2;
            } else if ((n & 4) != 0) {
                byArray = gameApp.m_pCharKeyMap[2];
                n = 4;
            } else if ((n & 8) != 0) {
                byArray = gameApp.m_pCharKeyMap[3];
                n = 8;
            } else if ((n & 0x10) != 0) {
                byArray = gameApp.m_pCharKeyMap[4];
                n = 16;
            } else if ((n & 0x20) != 0) {
                byArray = gameApp.m_pCharKeyMap[5];
                n = 32;
            } else if ((n & 0x40) != 0) {
                byArray = gameApp.m_pCharKeyMap[6];
                n = 64;
            } else if ((n & 0x80) != 0) {
                byArray = gameApp.m_pCharKeyMap[7];
                n = 128;
            } else if ((n & 0x100) != 0) {
                byArray = gameApp.m_pCharKeyMap[8];
                n = 256;
            } else if ((n & 0x200) != 0) {
                byArray = gameApp.m_pCharKeyMap[9];
                n = 512;
            } else if ((n & 0x800) != 0) {
                byArray = gameApp.m_pCharKeyMap[10];
                n = 2048;
            } else if ((n & 0x20000) != 0) {
                if (this.m_iCharTimer > 0) {
                    this.setCaretPosition(this.getCaretPosition() + 1);
                    this.m_iKeyMask = 0;
                    this.m_iCharIndex = 0;
                    this.m_iCharTimer = 0;
                }
                if (this.getCaretPosition() > 0) {
                    this.setCaretPosition(this.getCaretPosition() - 1);
                    this.removeCharAt(this.getCaretPosition());
                }
                n = 131072;
            } else if ((n & 0x1000) != 0) {
                n = 4096;
            } else if ((n & 0x2000) != 0) {
                n = 8192;
            } else if ((n & 0x4000) != 0) {
                this.setCaretPosition(this.getCaretPosition() - 1);
                this.m_iKeyMask = 0;
                this.m_iCharIndex = 0;
                this.m_iCharTimer = 0;
                n = 16384;
            } else if ((n & 0x8000) != 0) {
                this.setCaretPosition(this.getCaretPosition() + 1);
                this.m_iKeyMask = 0;
                this.m_iCharIndex = 0;
                this.m_iCharTimer = 0;
                n = 32768;
            }
            if (byArray != null) {
                n2 = this.StrLen(byArray);
            }
            if (this.m_pText != null) {
                n3 = this.StrLen(this.m_pText);
            }
            if (n2 > 0) {
                if (this.m_iKeyMask != n) {
                    if (this.m_iMaxEditLength <= 0 || n3 < this.m_iMaxEditLength) {
                        if (this.m_iKeyMask != 0) {
                            this.setCaretPosition(this.getCaretPosition() + 1);
                        }
                        this.m_iKeyMask = n;
                        this.m_iCharIndex = 0;
                        this.insertCharAt(this.getCaretPosition(), byArray[this.m_iCharIndex]);
                        this.setCaretPosition(this.getCaretPosition());
                    }
                } else {
                    ++this.m_iCharIndex;
                    if (this.m_iCharIndex >= n2) {
                        this.m_iCharIndex = 0;
                    }
                    this.replaceCharAt(this.getCaretPosition(), byArray[this.m_iCharIndex]);
                }
                this.m_iCharTimer = 2000;
            } else {
                if (this.m_iKeyMask != 0) {
                    this.setCaretPosition(this.getCaretPosition() + 1);
                }
                this.m_iKeyMask = 0;
                this.m_iCharIndex = 0;
                this.m_iCharTimer = 0;
            }
        }
    }

    public void onReleaseResource() {
        this.releaseText();
        super.onReleaseResource();
    }

    public void onReloadText() {
        if (this.m_iStringID > 0) {
            this.setText(this.m_iStringID);
        }
    }

    public void onIdle(int n) {
        if (this.m_iCharTimer > 0) {
            this.m_iCharTimer -= n;
            if (this.m_iCharTimer <= 0) {
                this.setCaretPosition(this.getCaretPosition() + 1);
                this.m_iKeyMask = 0;
                this.m_iCharIndex = 0;
                this.m_iCharTimer = 0;
            }
        }
        super.onIdle(n);
    }

    public void onPaint(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.m_iLeft >> 12;
        int n8 = this.m_iTop >> 12;
        int n9 = this.m_iWidth >> 12;
        int n10 = this.m_iHeight >> 12;
        if (this.m_pParent != null) {
            n7 -= this.m_pParent.m_iX >> 12;
            n8 -= this.m_pParent.m_iY >> 12;
        }
        if (this.m_bPaintBackground) {
            graphics.setColor(this.m_iBackgroundColor);
            if (this.m_bRoundedEnds) {
                this.fillCircle(graphics, n7 + 1, n8, n10);
                this.fillCircle(graphics, n7 + n9 - 1, n8, n10);
            }
            graphics.fillRect(n7, n8, n9, n10);
        }
        if (this.m_bPaintBorder && !this.m_bRoundedEnds) {
            graphics.setColor(this.m_iBorderColor);
            graphics.drawRect(n7, n8, n9 - 1, n10 - 1);
            if (this.m_bPaintBorderOutline) {
                graphics.setColor(this.m_iBorderOutlineColor);
                graphics.drawRect(n7 + 1, n8 + 1, n9 - 3, n10 - 3);
                graphics.drawRect(n7 - 1, n8 - 1, n9 + 1, n10 + 1);
            }
        }
        if (this.m_pFont != null) {
            switch (this.m_iHorzJustification) {
                case 1: {
                    int n11 = 4;
                    break;
                }
                case 2: {
                    int n11 = GameApp.m_instance.m_bDrawingSKSwap ? 1 : 2;
                    break;
                }
                default: {
                    int n11 = GameApp.m_instance.m_bDrawingSKSwap ? 2 : 1;
                }
            }
            switch (this.m_iVertJustification) {
                case 1: {
                    n11 |= 0x10;
                    break;
                }
            }
            this.m_pFont.setCaretPosition(this.m_iCaretPos);
            this.m_pFont.textRender(graphics, n7, n8, n9, n10, n11 |= 0x100, this.m_pText, 0, 0, -1, false, null);
            if (this.m_bEditable && this.m_pParent != null) {
                graphics.setColor(this.m_iCaretColor);
                n7 = this.m_pFont.getCaretX() - 1;
                n8 = this.m_pFont.getCaretY();
                graphics.drawLine(n7, n8 - 1, n7, n8 + this.m_pFont.m_iHeight);
            }
        }
        super.onPaint(graphics, n, n2, n3, n4, n5, n6);
    }
}

