/*
 * Decompiled with CFR 0.152.
 */
package sims_pets;

import sims_pets.AnimObject;
import sims_pets.Box;
import sims_pets.DeviceInfo;
import sims_pets.GameApp;
import sims_pets.GameObject;
import sims_pets.MenuScene;
import sims_pets.PetsApp;
import sims_pets.TextObject;

public class StoreScene
extends MenuScene {
    public static final int kStoreItemIconBaseID = 1000;
    public static final int kStoreItemFrameBaseID = 1100;
    public static final int kStoreItemDescBaseID = 1500;
    public static final int kStoreItemCostBaseID = 2000;
    public static final int kStoreListArrowPrevID = 2102;
    public static final int kStoreListArrowNextID = 2103;
    public static final int kStoreSelectedAreaID = 2500;
    public static final int kStoreSelectedTextID = 2501;
    public static final int kStoreBankID = 3000;
    public static final int kStoreBubbleID = 4000;
    public static final int kStoreMessageLineID = 4001;
    public static final int kStoreMessageCloseID = 4002;
    public static final int kStoreQtyTitleID = 4101;
    public static final int kStoreQtyArrowMoreID = 4102;
    public static final int kStoreQtyArrowLessID = 4103;
    public static final int kStoreQtyMultSignID = 4104;
    public static final int kStoreQtyMultAmountID = 4105;
    public static final int kStoreQtyMultBgID = 4106;
    public static final int kStoreQtyCurrentCashID = 4107;
    public static final int kStoreQtyMinusCashID = 4108;
    public static final int kStoreQtyResultCashID = 4109;
    public static final int kStoreQtyMinusSignID = 4110;
    public static final int kStoreQtyResultLineID = 4111;
    public static final int kStoreBuyConfirmTitleID = 4201;
    public static final int kStoreBuyConfirmYesID = 4202;
    public static final int kStoreBuyConfirmNoID = 4203;
    public static final int kStoreBGBoxHeaderID = 5000;
    public static final int kStoreBGBoxBodyID = 5001;
    public static final int kStoreBGBoxSoftkeysID = 5002;
    public static final int kMaxStoreItemsPerPage = 6;
    public static final int kMaxNumItems = 23;
    public static final int kItemInfoStringID = 0;
    public static final int kItemInfoState = 1;
    public static final int kItemInfoInstID = 2;
    public static final int kNumItemInfo = 3;
    public static final int kMaxNumStoreLevels = 2;
    public static final int kDialogPhaseNone = 0;
    public static final int kDialogPhaseMessage = 1;
    public static final int kDialogPhaseQuantity = 2;
    public static final int kDialogPhaseBuyConfirm = 3;
    private AnimObject[] m_pIcons = new AnimObject[6];
    private Box[] m_pFrames = new Box[6];
    private TextObject[] m_pDescs = new TextObject[6];
    private TextObject[] m_pCosts = new TextObject[6];
    private GameObject m_pListArrowPrev;
    private GameObject m_pListArrowNext;
    private GameObject m_pSelectedArea;
    private TextObject m_pItemSelected;
    private TextObject m_pBank;
    private GameObject m_pBubbleArea;
    private TextObject m_pMsgLine;
    private TextObject m_pMsgClose;
    private GameObject m_pQtyTitle;
    private GameObject m_pQtyArrowMore;
    private GameObject m_pQtyArrowLess;
    private GameObject m_pQtyMultSign;
    private TextObject m_pQtyMultAmount;
    private Box m_pQtyMultBG;
    private TextObject m_pQtyCurrentCash;
    private TextObject m_pQtyMinusCash;
    private TextObject m_pQtyResultCash;
    private GameObject m_pQtyMinusSign;
    private GameObject m_pQtyResultLine;
    private GameObject m_pBuyConfirmTitle;
    private TextObject m_pBuyConfirmYes;
    private TextObject m_pBuyConfirmNo;
    private int m_iNumItemsPerPage;
    private int[][] m_iItems = new int[23][3];
    private int m_iNumItems;
    private int[] m_iCurItem = new int[2];
    private int[] m_iItemOffset = new int[2];
    private int[] m_iLevelInstanceID = new int[2];
    private int m_iCurLevel;
    private int m_iPhase;
    private int m_iCurInvItem;
    private int m_iCurInvCost;
    private int m_iQtyMaxAmount;
    private int m_iQtyAmount;
    private int m_iQtyCurrentCash;
    private int m_iQtyMinusCash;
    private int m_iQtyResultCash;
    private boolean m_bBuyConfirm;
    private boolean m_bWasAMetaGoalCompleted;

    public StoreScene(int n) {
        super(n);
    }

    private final void addItem(int n, int n2, int n3) {
        if (this.m_iNumItems >= 23) {
            return;
        }
        this.m_iItems[this.m_iNumItems][0] = n2;
        this.m_iItems[this.m_iNumItems][1] = n;
        this.m_iItems[this.m_iNumItems][2] = n3;
        ++this.m_iNumItems;
    }

    private final void rebuildList() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        this.m_iNumItems = 0;
        if (this.m_iCurLevel == 0) {
            for (int i = 0; i < 4 && DeviceInfo.k_iCategories[i][0] >= 0; ++i) {
                this.addItem(DeviceInfo.k_iCategories[i][0], DeviceInfo.k_iCategories[i][1], DeviceInfo.k_iCategories[i][1]);
            }
            if (this.m_pSelectedArea != null) {
                this.m_pSelectedArea.m_bVisible = false;
            }
            if (this.m_pItemSelected != null) {
                this.m_pItemSelected.m_bVisible = false;
            }
            if (this.m_pBank != null) {
                this.m_pBank.m_bVisible = false;
            }
        } else {
            for (int i = 0; i < 23; ++i) {
                int n;
                if (DeviceInfo.k_iInventoryItems[i][1] != this.m_iLevelInstanceID[this.m_iCurLevel] || DeviceInfo.k_iInventoryItems[i][2] == 0) continue;
                int n2 = -1;
                if (DeviceInfo.k_iInventoryItems[i][4] != 0) {
                    if (petsApp.checkInventory(DeviceInfo.k_iInventoryItems[i][4]) || (n = DeviceInfo.k_iInventoryItems[i][7]) != 0 && (this.m_bWasAMetaGoalCompleted || !petsApp.isCurrentMetaGoal(n))) {
                        continue;
                    }
                } else {
                    n = petsApp.getConsumable(DeviceInfo.k_iInventoryItems[i][5]);
                    if (n > 0) {
                        n2 = 8;
                    }
                }
                this.addItem(n2, DeviceInfo.k_iInventoryItems[i][0], i);
            }
            if (this.m_pSelectedArea != null) {
                this.m_pSelectedArea.m_bVisible = true;
            }
            if (this.m_pItemSelected != null) {
                this.m_pItemSelected.m_bVisible = true;
            }
            if (this.m_pBank != null) {
                this.m_pBank.m_bVisible = true;
            }
        }
        this.refreshList();
        this.m_pCurrentObject = null;
        if (this.m_plstTabStops != null && this.m_iCurItem[this.m_iCurLevel] >= 0) {
            this.m_pCurrentObject = (GameObject)this.m_plstTabStops.elementData[this.m_iCurItem[this.m_iCurLevel]];
        }
        this.updateSelectorPosition();
        if (this.m_pListArrowPrev != null) {
            boolean bl = this.m_pListArrowPrev.m_bVisible = this.m_iNumItems > 1;
        }
        if (this.m_pListArrowNext != null) {
            this.m_pListArrowNext.m_bVisible = this.m_iNumItems > 1;
        }
    }

    private final void refreshList() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n = petsApp.getCurrentSimoleons();
        for (int i = 0; i < this.m_iNumItemsPerPage; ++i) {
            if (this.m_pIcons[i] != null) {
                if (this.m_iItemOffset[this.m_iCurLevel] + i < this.m_iNumItems && this.m_iItems[this.m_iItemOffset[this.m_iCurLevel] + i][1] >= 0) {
                    this.m_pIcons[i].setState(this.m_iItems[this.m_iItemOffset[this.m_iCurLevel] + i][1], 0, false);
                    this.m_pIcons[i].setVisible(true);
                } else {
                    this.m_pIcons[i].setVisible(false);
                }
            }
            if (this.m_pDescs[i] != null) {
                if (this.m_iItemOffset[this.m_iCurLevel] + i < this.m_iNumItems) {
                    this.m_pDescs[i].setText(this.m_iItems[this.m_iItemOffset[this.m_iCurLevel] + i][0]);
                    this.m_pDescs[i].setVisible(true);
                } else {
                    this.m_pDescs[i].setVisible(false);
                }
            }
            if (this.m_pFrames[i] != null) {
                if (this.m_iItemOffset[this.m_iCurLevel] + i < this.m_iNumItems) {
                    this.m_pFrames[i].setVisible(true);
                } else {
                    this.m_pFrames[i].setVisible(false);
                }
            }
            if (this.m_pCosts[i] == null) continue;
            if (this.m_iCurLevel == 1 && this.m_iItemOffset[this.m_iCurLevel] + i < this.m_iNumItems) {
                int n2 = this.m_iItems[this.m_iItemOffset[this.m_iCurLevel] + i][2];
                this.m_pCosts[i].setNumber(GameApp.abs(DeviceInfo.k_iInventoryItems[n2][2]), true);
                this.m_pCosts[i].insertCharAt(0, (byte)32);
                this.m_pCosts[i].insertCharAt(0, (byte)126);
                this.m_pCosts[i].setVisible(true);
                continue;
            }
            this.m_pCosts[i].setVisible(false);
        }
        if (this.m_pBank != null) {
            this.m_pBank.setNumber(n, true);
            this.m_pBank.insertCharAt(0, (byte)32);
            this.m_pBank.insertCharAt(0, (byte)126);
        }
    }

    private final void handleSelect() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n = this.m_iCurItem[this.m_iCurLevel] + this.m_iItemOffset[this.m_iCurLevel];
        if (this.m_iCurLevel == 0) {
            ++this.m_iCurLevel;
            this.m_iCurItem[this.m_iCurLevel] = 0;
            this.m_iItemOffset[this.m_iCurLevel] = 0;
            this.m_iLevelInstanceID[this.m_iCurLevel] = this.m_iItems[n][2];
            this.rebuildList();
        } else if (this.m_plstTabStops != null) {
            this.m_iCurInvItem = this.m_iItems[n][2];
            if (DeviceInfo.k_iInventoryItems[this.m_iCurInvItem][4] != 0 && petsApp.checkInventory(DeviceInfo.k_iInventoryItems[this.m_iCurInvItem][4])) {
                this.openMessage(93);
            } else {
                this.m_iCurInvCost = DeviceInfo.k_iInventoryItems[this.m_iCurInvItem][2];
                if (this.m_iCurInvCost <= 0) {
                    this.openMessage(186);
                } else if (petsApp.getCurrentSimoleons() < this.m_iCurInvCost) {
                    this.openMessage(94);
                } else {
                    this.m_iQtyMaxAmount = 1;
                    if (DeviceInfo.k_iInventoryItems[this.m_iCurInvItem][4] == 0) {
                        this.m_iQtyMaxAmount = petsApp.getCurrentSimoleons() / this.m_iCurInvCost;
                    }
                    this.m_iQtyAmount = 1;
                    if (DeviceInfo.k_iInventoryItems[this.m_iCurInvItem][4] != 0) {
                        this.openBuyConfirm();
                    } else {
                        this.openQuantity();
                    }
                }
            }
        }
    }

    private final void showMessage(boolean bl) {
        this.m_iPhase = bl ? 1 : 0;
        if (this.m_pMsgLine != null) {
            this.m_pMsgLine.m_bVisible = bl;
        }
        if (this.m_pMsgClose != null) {
            this.m_pMsgClose.m_bVisible = bl;
        }
        if (this.m_pBubbleArea != null) {
            this.m_pBubbleArea.m_bVisible = bl;
        }
    }

    private final void openMessage(byte[] byArray) {
        if (byArray != null) {
            this.showMessage(true);
            if (this.m_pMsgLine != null) {
                this.m_pMsgLine.setText(byArray, true);
            } else {
                GameApp.releaseStringBuffer(byArray);
            }
        }
    }

    private final void openMessage(int n) {
        this.openMessage(GameApp.loadStringResource(n));
    }

    private final void showQuantity(boolean bl) {
        this.m_iPhase = bl ? 2 : 0;
        if (this.m_pQtyTitle != null) {
            this.m_pQtyTitle.m_bVisible = bl;
        }
        if (this.m_pQtyArrowMore != null) {
            this.m_pQtyArrowMore.m_bVisible = bl;
        }
        if (this.m_pQtyArrowLess != null) {
            this.m_pQtyArrowLess.m_bVisible = bl;
        }
        if (this.m_pBubbleArea != null) {
            this.m_pBubbleArea.m_bVisible = bl;
        }
        if (this.m_pQtyMultSign != null) {
            this.m_pQtyMultSign.m_bVisible = bl;
        }
        if (this.m_pQtyMultAmount != null) {
            this.m_pQtyMultAmount.m_bVisible = bl;
        }
        if (this.m_pQtyMultBG != null) {
            this.m_pQtyMultBG.m_bVisible = bl;
        }
        if (this.m_pQtyCurrentCash != null) {
            this.m_pQtyCurrentCash.m_bVisible = bl;
        }
        if (this.m_pQtyMinusCash != null) {
            this.m_pQtyMinusCash.m_bVisible = bl;
        }
        if (this.m_pQtyResultCash != null) {
            this.m_pQtyResultCash.m_bVisible = bl;
        }
        if (this.m_pQtyMinusSign != null) {
            this.m_pQtyMinusSign.m_bVisible = bl;
        }
        if (this.m_pQtyResultLine != null) {
            this.m_pQtyResultLine.m_bVisible = bl;
        }
    }

    private final void openQuantity() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        this.m_iQtyCurrentCash = petsApp.getCurrentSimoleons();
        this.showQuantity(true);
        if (this.m_pQtyCurrentCash != null) {
            this.m_pQtyCurrentCash.setNumber(this.m_iQtyCurrentCash, true);
        }
        this.updateQuantity();
    }

    private final void updateQuantity() {
        if (this.m_pQtyMultAmount != null) {
            this.m_pQtyMultAmount.setNumber(this.m_iQtyAmount, false);
        }
        this.m_iQtyMinusCash = this.m_iQtyAmount * this.m_iCurInvCost;
        this.m_iQtyResultCash = this.m_iQtyCurrentCash - this.m_iQtyMinusCash;
        if (this.m_pQtyMinusCash != null) {
            this.m_pQtyMinusCash.setNumber(this.m_iQtyMinusCash, true);
        }
        if (this.m_pQtyResultCash != null) {
            this.m_pQtyResultCash.setNumber(this.m_iQtyResultCash, true);
        }
        if (this.m_pQtyArrowMore != null) {
            boolean bl = this.m_pQtyArrowMore.m_bVisible = this.m_iQtyAmount < this.m_iQtyMaxAmount;
        }
        if (this.m_pQtyArrowLess != null) {
            this.m_pQtyArrowLess.m_bVisible = this.m_iQtyAmount > 1;
        }
    }

    private final void showBuyConfirm(boolean bl) {
        this.m_iPhase = bl ? 3 : 0;
        if (this.m_pBuyConfirmTitle != null) {
            this.m_pBuyConfirmTitle.m_bVisible = bl;
        }
        if (this.m_pBuyConfirmYes != null) {
            this.m_pBuyConfirmYes.m_bVisible = bl;
        }
        if (this.m_pBuyConfirmNo != null) {
            this.m_pBuyConfirmNo.m_bVisible = bl;
        }
        if (this.m_pBubbleArea != null) {
            this.m_pBubbleArea.m_bVisible = bl;
        }
    }

    private final void openBuyConfirm() {
        this.showBuyConfirm(true);
        this.m_bBuyConfirm = true;
        this.updateBuyConfirm();
    }

    private final void updateBuyConfirm() {
        if (this.m_pBuyConfirmYes != null) {
            this.m_pBuyConfirmYes.m_bPaintBackground = this.m_bBuyConfirm;
        }
        if (this.m_pBuyConfirmNo != null) {
            this.m_pBuyConfirmNo.m_bPaintBackground = !this.m_bBuyConfirm;
        }
    }

    public GameObject nextObject() {
        this.m_pCurrentObject = null;
        if (this.m_iNumItemsPerPage <= 0) {
            return this.m_pCurrentObject;
        }
        if (this.m_iNumItems <= 0) {
            return this.m_pCurrentObject;
        }
        int n = this.m_iCurItem[this.m_iCurLevel] + 1;
        if (n >= this.m_iNumItemsPerPage) {
            if (this.m_iItemOffset[this.m_iCurLevel] < this.m_iNumItems - this.m_iNumItemsPerPage) {
                int n2 = this.m_iCurLevel;
                this.m_iItemOffset[n2] = this.m_iItemOffset[n2] + 1;
                n = this.m_iCurItem[this.m_iCurLevel];
            } else {
                this.m_iItemOffset[this.m_iCurLevel] = 0;
                n = 0;
            }
            this.refreshList();
        } else if (n >= this.m_iNumItems) {
            n = 0;
        }
        this.m_iCurItem[this.m_iCurLevel] = n;
        if (this.m_plstTabStops != null && this.m_iCurItem[this.m_iCurLevel] >= 0) {
            this.m_pCurrentObject = (GameObject)this.m_plstTabStops.elementData[this.m_iCurItem[this.m_iCurLevel]];
        }
        return this.m_pCurrentObject;
    }

    public GameObject prevObject() {
        this.m_pCurrentObject = null;
        if (this.m_iNumItemsPerPage <= 0) {
            return this.m_pCurrentObject;
        }
        if (this.m_iNumItems <= 0) {
            return this.m_pCurrentObject;
        }
        int n = this.m_iCurItem[this.m_iCurLevel] - 1;
        if (n < 0) {
            if (this.m_iItemOffset[this.m_iCurLevel] > 0) {
                int n2 = this.m_iCurLevel;
                this.m_iItemOffset[n2] = this.m_iItemOffset[n2] - 1;
                n = this.m_iCurItem[this.m_iCurLevel];
                this.refreshList();
            } else if (this.m_iNumItems > this.m_iNumItemsPerPage) {
                this.m_iItemOffset[this.m_iCurLevel] = this.m_iNumItems - this.m_iNumItemsPerPage;
                n = this.m_iNumItemsPerPage - 1;
                this.refreshList();
            } else {
                n = this.m_iNumItems - 1;
            }
        }
        this.m_iCurItem[this.m_iCurLevel] = n;
        if (this.m_plstTabStops != null && this.m_iCurItem[this.m_iCurLevel] >= 0) {
            this.m_pCurrentObject = (GameObject)this.m_plstTabStops.elementData[this.m_iCurItem[this.m_iCurLevel]];
        }
        return this.m_pCurrentObject;
    }

    public void updateSelectorPosition() {
        super.updateSelectorPosition();
        if (this.m_iNumItems > 0) {
            if (this.m_pItemSelected != null && this.m_iCurLevel == 1) {
                PetsApp petsApp = (PetsApp)GameApp.m_instance;
                int n = this.m_iCurItem[this.m_iCurLevel] + this.m_iItemOffset[this.m_iCurLevel];
                byte[] byArray = GameApp.loadStringResource(113);
                byte[][] byArrayArray = new byte[][]{GameApp.getStringBufferForNumber(petsApp.getInventoryItemQuantity(this.m_iItems[n][2])), GameApp.loadStringResource(this.m_iItems[n][0])};
                byte[] byArray2 = GameApp.formatStringBuffer(byArray, byArrayArray, 2);
                GameApp.releaseStringBuffer(byArray);
                GameApp.releaseStringBuffer(byArrayArray[0]);
                GameApp.releaseStringBuffer(byArrayArray[1]);
                this.m_pItemSelected.setText(byArray2, true);
            }
        } else if (this.m_pItemSelected != null) {
            this.m_pItemSelected.setText(167);
        }
    }

    public void onResume() {
        this.refreshList();
        super.onResume();
    }

    public int onOpen() {
        this.rebuildList();
        return super.onOpen();
    }

    public boolean onAddObject(GameObject gameObject) {
        int n = gameObject.m_iInstanceID;
        if (n == 3000) {
            this.m_pBank = (TextObject)gameObject;
        } else if (n == 2102) {
            this.m_pListArrowPrev = gameObject;
        } else if (n == 2103) {
            this.m_pListArrowNext = gameObject;
        } else if (n == 2500) {
            this.m_pSelectedArea = gameObject;
        } else if (n == 2501) {
            this.m_pItemSelected = (TextObject)gameObject;
        } else if (n == 4000) {
            this.m_pBubbleArea = gameObject;
        } else if (n == 4001) {
            this.m_pMsgLine = (TextObject)gameObject;
        } else if (n == 4002) {
            this.m_pMsgClose = (TextObject)gameObject;
            this.m_pMsgClose.m_bRoundedEnds = true;
            this.m_pMsgClose.m_bPaintBackground = true;
        } else if (n == 4101) {
            this.m_pQtyTitle = gameObject;
        } else if (n == 4102) {
            this.m_pQtyArrowMore = gameObject;
        } else if (n == 4103) {
            this.m_pQtyArrowLess = gameObject;
        } else if (n == 4104) {
            this.m_pQtyMultSign = gameObject;
        } else if (n == 4105) {
            this.m_pQtyMultAmount = (TextObject)gameObject;
        } else if (n == 4106) {
            this.m_pQtyMultBG = (Box)gameObject;
            this.m_pQtyMultBG.m_iValue = 3264000;
        } else if (n == 4107) {
            this.m_pQtyCurrentCash = (TextObject)gameObject;
        } else if (n == 4108) {
            this.m_pQtyMinusCash = (TextObject)gameObject;
        } else if (n == 4109) {
            this.m_pQtyResultCash = (TextObject)gameObject;
        } else if (n == 4110) {
            this.m_pQtyMinusSign = gameObject;
        } else if (n == 4111) {
            this.m_pQtyResultLine = gameObject;
        } else if (n == 4201) {
            this.m_pBuyConfirmTitle = gameObject;
        } else if (n == 4202) {
            this.m_pBuyConfirmYes = (TextObject)gameObject;
            this.m_pBuyConfirmYes.m_bRoundedEnds = true;
        } else if (n == 4203) {
            this.m_pBuyConfirmNo = (TextObject)gameObject;
            this.m_pBuyConfirmNo.m_bRoundedEnds = true;
        } else if (1000 <= n && n < 1006) {
            this.m_pIcons[n -= 1000] = (AnimObject)gameObject;
            if (++n > this.m_iNumItemsPerPage) {
                this.m_iNumItemsPerPage = n;
            }
        } else if (1100 <= n && n < 1106) {
            Box box = (Box)gameObject;
            box.m_iStyle = 6;
            box.m_iValue = 5463451;
            this.m_pFrames[n -= 1100] = box;
            if (++n > this.m_iNumItemsPerPage) {
                this.m_iNumItemsPerPage = n;
            }
        } else if (1500 <= n && n < 1506) {
            this.m_pDescs[n -= 1500] = (TextObject)gameObject;
            if (++n > this.m_iNumItemsPerPage) {
                this.m_iNumItemsPerPage = n;
            }
        } else if (2000 <= n && n < 2006) {
            this.m_pCosts[n -= 2000] = (TextObject)gameObject;
            if (++n > this.m_iNumItemsPerPage) {
                this.m_iNumItemsPerPage = n;
            }
        } else if (n == 5000 || n == 5001 || n == 5002) {
            Box box = (Box)gameObject;
            box.m_iStyle = 5;
        }
        return super.onAddObject(gameObject);
    }

    public void onCheckKeysChanged() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n = petsApp.m_iKeysChanged;
        switch (this.m_iPhase) {
            case 1: {
                if ((n & 0xF0020) != 0) {
                    this.showMessage(false);
                }
                return;
            }
            case 2: {
                if ((n & 0x1004) != 0) {
                    if (this.m_iQtyAmount < this.m_iQtyMaxAmount) {
                        ++this.m_iQtyAmount;
                        this.updateQuantity();
                    }
                } else if ((n & 0x2100) != 0) {
                    if (this.m_iQtyAmount > 1) {
                        --this.m_iQtyAmount;
                        this.updateQuantity();
                    }
                } else if ((n & 0x90020) != 0) {
                    this.showQuantity(false);
                    this.openBuyConfirm();
                } else if ((n & 0x60000) != 0) {
                    this.showQuantity(false);
                }
                return;
            }
            case 3: {
                if ((n & 0xC050) != 0) {
                    this.m_bBuyConfirm = !this.m_bBuyConfirm;
                    this.updateBuyConfirm();
                } else if ((n & 0x90020) != 0) {
                    if (this.m_bBuyConfirm) {
                        int n2;
                        while (this.m_iQtyAmount > 0) {
                            petsApp.buyInventoryItem(this.m_iCurInvItem);
                            --this.m_iQtyAmount;
                        }
                        if (!this.m_bWasAMetaGoalCompleted && (n2 = DeviceInfo.k_iInventoryItems[this.m_iCurInvItem][7]) != 0) {
                            this.m_bWasAMetaGoalCompleted = petsApp.completeMetaGoal(n2);
                        }
                        this.rebuildList();
                    }
                    this.showBuyConfirm(false);
                } else if ((n & 0x60000) != 0) {
                    this.showBuyConfirm(false);
                }
                return;
            }
            default: {
                this.m_iPhase = 0;
            }
            case 0: 
        }
        if ((n & 0x90020) != 0) {
            this.handleSelect();
            return;
        }
        if ((n & 0x60000) != 0 && this.m_iCurLevel > 0) {
            --this.m_iCurLevel;
            this.rebuildList();
            return;
        }
        super.onCheckKeysChanged();
    }
}

