/*
 * Decompiled with CFR 0.152.
 */
package sims_pets;

import sims_pets.AnimObject;
import sims_pets.DeviceInfo;
import sims_pets.GameApp;
import sims_pets.GameObject;
import sims_pets.Interactive;
import sims_pets.PetsApp;
import sims_pets.PetsGame;
import sims_pets.Toy;

public class Dog
extends Interactive {
    public static final int kPointSetHeadOffset = 2;
    public static final int kPointSetHeadZOffset = 3;
    public static final int kPointSetTailOffset = 4;
    public static final int kPointSetTailZOffset = 5;
    public static final int kPointSetHighest = 5;
    public static final int kPointSetAttachOffset = 4;
    public static final int kAIIdle = 0;
    public static final int kAIInteract = 1;
    public static final int kAIInterrupt = 2;
    public static final int kAIMove = 3;
    public static final int kAIStay = 4;
    public static final int kAICount = 5;
    public static final int kNeedBladder = 0;
    public static final int kNeedEnergy = 1;
    public static final int kNeedFun = 2;
    public static final int kNeedHunger = 3;
    public static final int kNeedHygiene = 4;
    public static final int kNeedCount = 5;
    public static final int kTLCModeNone = 0;
    public static final int kTLCModePetting = 1;
    public static final int kTLCModeBrushing = 2;
    public static final int kTLCModeWashing = 3;
    public static final int kTrainingConfusion = 5;
    public static final int kTrainingRefusal = 6;
    public static final int kActionAmbient = 0;
    public static final int kActionBark = 1;
    public static final int kActionCarry = 2;
    public static final int kActionDrop = 3;
    public static final int kActionEat = 4;
    public static final int kActionLay = 5;
    public static final int kActionMove = 6;
    public static final int kActionSit = 7;
    public static final int kActionSleep = 8;
    public static final int kActionStand = 9;
    public static final int kActionPotty = 10;
    public static final int kActionRespond = 11;
    public static final int kActionTrick = 12;
    public static final int kActionJump = 13;
    public static final int kActionHindLegs = 14;
    public static final int kActionConfused = 15;
    public static final int kActionCount = 16;
    public static final int kEnergyAfterSleep = 409600;
    public static final int kBladderAfterSleep = 102400;
    public static final int kHungerAfterSleep = -307200;
    public static final int kInterruptGainInterest = 0;
    public static final int kInterruptLoseInterest = 1;
    public static final int kInterruptDiscThrow = 2;
    public static final int kInterruptStay = 3;
    public static final int kFeedbackMinus = 0;
    public static final int kFeedbackMinusMinus = 1;
    public static final int kFeedbackPlus = 2;
    public static final int kFeedbackPlusPlus = 3;
    public static final int kxStatFailure = 4096;
    public static final int kxStatFailureRestore = 20480;
    public static final int kxStatWarningVeryHigh = 368640;
    public static final int kxStatWarningHigh = 307200;
    public static final int kxStatWarningLow = 102400;
    public static final int kxStatWarningVeryLow = 40960;
    public static final int kxFun_HealthNeedDrop = 40960;
    public static final int kxHunger_HealthNeedDrop = 81920;
    public static final int kxFunPlayChewBone = 81920;
    public static final int kxHygiene_NeedDrop = 122880;
    public static final int kxMoodVerySad = -204800;
    public static final int kxMoodSad = 0;
    public static final int kxMoodNeutral = 0;
    public static final int kxMoodHappy = 307200;
    public static final int kxSatisfiedHunger = 327680;
    public static final int kxStatRateEnergy = -153;
    public static final int kxStatRateFun = -352;
    public static final int kxStatRateHunger = -153;
    public static final int kxStatRateHealth = 0;
    public static final int kxStatRateHygiene = -409;
    public static final int kxStatRateBladder = -54;
    public static final int kxStatRateEnergyAtNight = -26214;
    public static final int kxStatRateEnergy_Nap = 40960;
    public static final int kxStatRateEnergy_Sleep = 40960;
    public static final int kxStatRateFun_Pet = 12288;
    public static final int kxStatRateHygiene_Brush = 12288;
    public static final int kxStatRateHygiene_Wash = 24576;
    public static final int kxStatRateBladder_Food = -12288;
    public static final int kxStatRateHunger_Food = 40960;
    public static final int kxStatIncFun_Play = 24576;
    public static final int kxStatDecEnergy_Play = 12288;
    public static final int kxStatDecHunger_Play = 12288;
    public static final int kxTLCBonusPetting = 307200;
    public static final int kxTLCBonusBrushing = 81920;
    public static final int kxTLCBonusBathing = 327680;
    public static final int kDogEventBase = 400;
    public static final int kDogEventReact = 401;
    public static final int kDogEventCarry = 402;
    public static final int kDogEventDrop = 403;
    public static final int kDogEventPotty = 404;
    public static final int kDogEventThrow = 405;
    public static final int kDogEventAttachItem = 407;
    public static final int kDogCatchLevelThrowNum = 5;
    public static final int kDogMaxCatchLevel = 5;
    public static final int kDogCatchUnitChance = 81920;
    public static final int kxDefaultWalkSpeed = 12288;
    public static final int kxDefaultRunSpeed = 28672;
    public static final int kxDefaultMoveSpeed = 24576;
    public static final int kxCurrentInterestDropRate = 12288;
    public static final int kxCurrentOwnerDropRate = -8192;
    public static final int kxCurrentAbilityDropRate = -8192;
    public static final int kxMood_DestroyPlantFirst = 163840;
    public static final int kxMood_DestroyPlantSecond = -163840;
    public static final int kxMood_DestroyNewpaper = -40960;
    public static final int kxMood_DestroySlipper = -102400;
    public static final int kxCurrentInterest = 0;
    public static final int kPlayDeadDelay = 2000;
    public static final int kiChewBonePlayingTime = 5000;
    public static final int kiFirstAttackCountDownTime = 30000;
    public static final int kiSecondAttackCountDownTime = 60000;
    public static final int kiDropToyTime = 30000;
    public static final int kiMaxSqueakyToySoundTime = 6000;
    protected int m_iThrowedNum;
    protected boolean m_bThrowSucceed;
    protected int m_iTLCMode;
    protected boolean m_bFeedBackBladderShow;
    protected boolean m_bCalledByOwner;
    protected int m_iAbilityLevel;
    protected int m_iSequenceAbility;
    protected int m_iCommandResponseTime;
    protected boolean m_bCommandResponseTimeOn;
    protected int m_iSequenceResponseTime;
    protected boolean m_bSequenceResponseTimeOn;
    protected boolean m_bTrickResponseTimeOn;
    protected boolean m_bTrickSequenceTimeOn;
    protected int m_iNeedTrainingTimer;
    protected int m_iSuccessAnimState;
    protected int m_iAction;
    protected int m_iCatchLevel;
    protected int m_iThought;
    protected int m_iWantToShowThought;
    protected int m_xPreviousAbilityLevel;
    protected boolean m_bPottyAtWanderInterest;
    protected int m_iDisplayFeedBackNeed;
    protected int m_iDisplayPlusMinus;
    protected int m_xTargetY;
    protected boolean m_bFoundObject;
    protected int m_iFoundObjectType;
    protected boolean m_bPlayDead;
    protected int m_iAmbientIdleCounter;
    protected boolean m_bExcited_Bark_Bark;
    protected boolean m_bExcited_Bark_Jump;
    protected boolean m_bExcited_Jump_Bark;
    protected int m_iChewBonePlayingTime;
    protected int m_iSqueakyToySoundTime;
    protected int m_iDidSuccessfulAbility;
    protected int[] m_piActiveCommands;
    protected int[] m_pxNeeds = new int[5];
    protected int[] m_pxTargetNeeds = new int[5];
    protected int[] m_pxNeedRates = new int[5];
    protected int[] m_pxAbilities = new int[27];
    protected int m_xMood;
    protected int m_iInterruptDelay;
    protected int m_xLastSuccessfulCommand;
    protected int m_iLearningTimer;
    protected int m_xLearningProgress;
    protected int m_xLearningTarget;
    protected int m_iPetLastInteractionTime;
    protected int m_iPetReqAttentionCount;
    protected int m_iBubbleTime;
    protected int m_iBubbleCycleTime;
    protected boolean m_bSleeping;
    protected Toy m_pCarry;
    protected boolean m_bCommandDisobey;
    protected PetsGame m_pGame;
    protected boolean m_bDestroyed;
    protected Toy m_pInterest;
    public boolean m_bNeedBladder;
    public int m_iPottyTime;
    public int m_msCountdownTimer1;
    public int m_msCountdownTimer2;
    private boolean m_bPraised;
    private boolean m_bScolded;
    private AnimObject m_pAttached;
    private Interactive m_pHeadPart;
    private Interactive m_pTailPart;
    protected boolean m_bIsoXCollision;
    protected boolean m_bIsoYCollision;
    protected int m_iLogicalState;
    protected int m_iTargetState;

    public Dog(PetsGame petsGame) {
        super(99311);
        this.m_iCollisionGroup = 1;
        this.m_iCollisionMask = 2;
        this.m_pGame = petsGame;
        this.m_iCurrentAI = 0;
        this.m_pInterest = null;
        this.m_iPetReqAttentionCount = 0;
        this.m_iPottyTime = 0;
        this.m_iBubbleTime = 0;
        this.m_iBubbleCycleTime = 0;
        this.m_bSleeping = false;
        this.m_iThought = -1;
        this.m_iDisplayFeedBackNeed = -1;
        this.m_iDisplayPlusMinus = -1;
        this.m_iWantToShowThought = -1;
        this.m_bPottyAtWanderInterest = false;
        this.m_xPreviousAbilityLevel = 0;
        this.m_xLearningProgress = -1;
        this.m_xLastSuccessfulCommand = -1;
        this.m_iSuccessAnimState = -1;
        this.m_iAction = 9;
        this.m_iThrowedNum = 0;
        this.m_iDidSuccessfulAbility = -1;
        this.m_iTargetState = -1;
        this.m_iCommandResponseTime = 0;
        this.m_iSequenceResponseTime = 0;
        this.m_iSequenceAbility = -1;
        this.m_iChewBonePlayingTime = 0;
        this.m_iSqueakyToySoundTime = 0;
        this.m_iAmbientIdleCounter = 1;
    }

    private final void moveToInterest() {
        boolean bl = false;
        if (this.m_pxNeeds[0] < 40960 || this.m_pxNeeds[1] >= 40960) {
            bl = true;
        }
        if (this.m_pInterest != null) {
            int n = 0;
            int n2 = 0;
            if (this.m_pInterest.m_xWorldLeft > this.m_xWorldRight && !this.m_bIsoXCollision) {
                n = this.m_pInterest.m_xWorldLeft - this.m_xWorldRight;
                if (bl) {
                    this.setVelocity(n, 0, 0, 28672);
                    this.setLogicalState(7);
                } else {
                    this.setVelocity(n, 0, 0, 12288);
                    this.setLogicalState(4);
                }
            } else if (this.m_xWorldLeft > this.m_pInterest.m_xWorldRight && !this.m_bIsoXCollision) {
                n = this.m_pInterest.m_xWorldRight - this.m_xWorldLeft;
                if (bl) {
                    this.setVelocity(n, 0, 0, 28672);
                    this.setLogicalState(28);
                } else {
                    this.setVelocity(n, 0, 0, 12288);
                    this.setLogicalState(26);
                }
            } else if (this.m_xWorldBottom < this.m_pInterest.m_xWorldTop && !this.m_bIsoYCollision) {
                n2 = this.m_pInterest.m_xWorldTop - this.m_xWorldBottom;
                if (bl) {
                    this.setVelocity(0, n2, 0, 28672);
                    this.setLogicalState(6);
                } else {
                    this.setVelocity(0, n2, 0, 12288);
                    this.setLogicalState(3);
                }
            } else if (this.m_xWorldTop > this.m_pInterest.m_xWorldBottom && !this.m_bIsoYCollision) {
                n2 = this.m_pInterest.m_xWorldBottom - this.m_xWorldTop;
                if (bl) {
                    this.setVelocity(0, n2, 0, 28672);
                    this.setLogicalState(29);
                } else {
                    this.setVelocity(0, n2, 0, 12288);
                    this.setLogicalState(27);
                }
            } else if (this.m_xWorldBottom >= this.m_pInterest.m_xWorldTop || this.m_xWorldTop <= this.m_pInterest.m_xWorldBottom) {
                this.m_bIsoXCollision = false;
                this.m_bIsoYCollision = false;
            }
        }
    }

    private final void updateCarriedObject() {
        if (this.m_pCarry != null && this.getNumPointSets() >= 4) {
            this.getPointSet(3, this.m_piPoints);
            int n = this.m_piPoints[1];
            this.getPointSet(2, this.m_piPoints);
            n = this.m_piPoints[1] - n;
            int[] nArray = this.m_pGame.toWorldCoord(this.m_piPoints[0] - this.getAnchorX() << 12, this.m_piPoints[1] - this.getAnchorY() << 12);
            this.m_pCarry.setWorldLocation(this.m_xWorldX + nArray[0], this.m_xWorldY + nArray[1], this.m_xWorldZ + (n <<= 12));
        }
    }

    public final void expireNeedTrainingTimer() {
        if (this.m_iNeedTrainingTimer > 0) {
            this.m_iNeedTrainingTimer = 1;
        }
    }

    public final void setDisplayFeedback(int n, int n2) {
        this.m_iDisplayFeedBackNeed = n;
        this.m_iDisplayPlusMinus = n2;
    }

    public final int getCatchLevel() {
        return this.m_iCatchLevel;
    }

    public final void setNeed(int n, int n2) {
        this.m_pxNeeds[n] = n2;
    }

    public final void setNeedRate(int n, int n2) {
        this.m_pxNeedRates[n] = n2;
    }

    public final void setDogAbility(int n, int n2) {
        this.m_pxAbilities[n] = n2;
    }

    public final void setTargetNeed(int n, int n2) {
        if (n2 > 409600) {
            n2 = 409600;
        } else if (n2 < 0) {
            n2 = 0;
        }
        this.m_pxTargetNeeds[n] = n2;
    }

    public final void wakeUp() {
        this.m_pxNeeds[1] = this.m_pxNeeds[1] + 409600;
        this.m_pxNeeds[0] = this.m_pxNeeds[0] + 102400;
        this.m_pxNeeds[3] = this.m_pxNeeds[3] + -307200;
        for (int i = 0; i < 5; ++i) {
            if (this.m_pxNeeds[i] > 409600) {
                this.m_pxNeeds[i] = 409600;
                continue;
            }
            if (this.m_pxNeeds[i] >= 0) continue;
            this.m_pxNeeds[i] = 0;
        }
        this.m_bSleeping = false;
        this.setAction(9);
        if (this.m_pGame != null) {
            this.m_pGame.getItem(4).onDeactivate();
        }
    }

    public final void adjustNeed(int n, int n2) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        Toy toy = null;
        if (n >= 0 && n < 5) {
            int n3 = this.m_pxNeeds[n];
            int n4 = n;
            this.m_pxNeeds[n4] = this.m_pxNeeds[n4] + n2;
            if (this.m_pxNeeds[n] <= 0) {
                this.m_pxNeeds[n] = 0;
            }
            if (this.m_pxNeeds[n] >= 409600) {
                this.m_pxNeeds[n] = 409600;
            }
            if (this.m_pxNeeds[n] > 102400 && this.m_iWantToShowThought == n) {
                this.m_iWantToShowThought = -1;
            }
            if (this.m_pxNeeds[n] <= 204800 && n3 > 204800) {
                petsApp.triggerHint(262144);
                petsApp.triggerHint(-2139095040);
            }
            if (n == 0 && petsApp.getCurrentLocation() == 1 && this.m_pxNeeds[n] <= 204800) {
                this.m_bNeedBladder = true;
                this.m_bPottyAtWanderInterest = true;
                toy = this.m_pGame.getItem(1);
                toy.m_xInterestLevel = 409600;
            }
            if (this.m_pxNeeds[n] <= 102400 && n3 > 102400 || this.m_pxNeeds[n] <= 40960 && n3 > 40960) {
                switch (n) {
                    case 0: {
                        int n5 = this.m_pxAbilities[22];
                        this.resetNeedRate(0);
                        this.m_bNeedBladder = true;
                        if (petsApp.getCurrentLocation() != 1) {
                            petsApp.triggerHint(0x4000000);
                        }
                        if (n5 >= 409600 && petsApp.getCurrentLocation() != 1) {
                            toy = this.m_pGame.getItem(2);
                            toy.m_xInterestLevel = 409600;
                            this.m_iWantToShowThought = n;
                            break;
                        }
                        if (n5 == 0 || petsApp.getCurrentLocation() == 1) {
                            this.m_bPottyAtWanderInterest = true;
                            toy = this.m_pGame.getItem(1);
                            toy.m_xInterestLevel = 409600;
                            break;
                        }
                        if (n5 <= 0 || petsApp.getCurrentLocation() == 1) break;
                        boolean bl = false;
                        int n6 = (GameApp.nextInt() & Integer.MAX_VALUE) % 100 << 12;
                        if (this.m_pxNeeds[n] <= 40960 && n6 <= n5 >> 1) {
                            bl = true;
                        } else if (this.m_pxNeeds[n] <= 102400 && n6 <= n5) {
                            bl = true;
                        }
                        if (bl) {
                            this.m_iWantToShowThought = n;
                            toy = this.m_pGame.getItem(2);
                            toy.m_xInterestLevel = 409600;
                            break;
                        }
                        this.m_bPottyAtWanderInterest = true;
                        toy = this.m_pGame.getItem(1);
                        toy.m_xInterestLevel = 409600;
                        break;
                    }
                    case 1: {
                        petsApp.triggerHint(0x1000000);
                        toy = this.m_pGame.getItem(4);
                        if (null != toy && !toy.m_bVisible) {
                            toy = this.m_pGame.getItem(2);
                            toy.m_xInterestLevel = 409600;
                        }
                        this.m_iWantToShowThought = n;
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (n == 2) {
                            petsApp.triggerHint(0x400000);
                        } else if (n == 3) {
                            petsApp.triggerHint(0x100000);
                        }
                        toy = this.m_pGame.getItem(2);
                        toy.m_xInterestLevel = 409600;
                        this.m_iWantToShowThought = n;
                        break;
                    }
                    case 4: {
                        petsApp.triggerHint(0x8000000);
                    }
                }
            }
            if (this.m_pxNeeds[n] <= 0 && n3 > 0) {
                switch (n) {
                    case 0: {
                        this.m_bNeedBladder = true;
                        this.m_bPottyAtWanderInterest = true;
                        toy = this.m_pGame.getItem(1);
                        toy.m_xInterestLevel = 409600;
                        break;
                    }
                    case 1: {
                        petsApp.triggerHint(0x2000000);
                        break;
                    }
                    case 2: {
                        toy = this.m_pGame.getItem(2);
                        toy.m_xInterestLevel = 409600;
                        break;
                    }
                    case 3: {
                        petsApp.triggerHint(0x200000);
                        toy = this.m_pGame.getItem(2);
                        toy.m_xInterestLevel = 409600;
                        break;
                    }
                    case 4: {
                        petsApp.triggerHint(0x10000000);
                    }
                }
            }
        }
        this.updateMood();
    }

    public final void updateMood() {
        if (this.m_pGame == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 12288;
        for (int i = 0; i < 5; ++i) {
            n += 409600;
            n2 += this.m_pxNeeds[i];
        }
        this.m_xMood = (n2 - (n >> 1)) / n3 << 12;
        if (this.m_xMood < 0 && this.m_iPetLastInteractionTime == 0 && this.m_iPetReqAttentionCount < 3) {
            this.m_iPetLastInteractionTime = 15000;
        }
    }

    public final void resetNeedRate(int n) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        if (n >= 0 && n < 5) {
            if (n == 1) {
                this.m_pxNeedRates[n] = -153;
            } else if (n == 3) {
                this.m_pxNeedRates[n] = -153;
            } else if (n == 2) {
                this.m_pxNeedRates[n] = -352;
            } else if (n == 0) {
                this.m_pxNeedRates[n] = -54;
            } else if (n == 4) {
                this.m_pxNeedRates[n] = petsApp.getCurrentLocation() == 1 ? -409 : 0;
            }
        }
    }

    public final void resetAllNeedRates() {
        for (int i = 0; i < 5; ++i) {
            this.resetNeedRate(i);
        }
    }

    public final boolean checkAbilityState(int n) {
        if (n != 5) {
            int n2 = 0;
            while (DeviceInfo.k_iPetMenuAbilities[n2][0] > -1) {
                if (DeviceInfo.k_iPetMenuAbilities[n2][0] == n) {
                    return this.m_pxAbilities[DeviceInfo.k_iPetMenuAbilities[n2 - 1][0]] >= 409600;
                }
                ++n2;
            }
        }
        return true;
    }

    public final void setThought(int n) {
        if ((this.m_iThought == -1 || n == -1 || this.m_iThought > -1 && DeviceInfo.k_iNeedWarningPriority[n] < DeviceInfo.k_iNeedWarningPriority[this.m_iThought]) && n != this.m_iThought) {
            this.m_iThought = n;
            if (this.m_iThought == 0 && this.m_pInterest != null && this.m_pInterest.m_iType == 5) {
                this.interrupt(1, 0, null);
            }
        }
    }

    public final void finishDisobedienceDisplay() {
        this.m_iNumAvailableInteractions = this.m_iInteractionCount;
        this.m_iNeedTrainingTimer = 30000;
        this.setThought(-1);
    }

    public final boolean onInteract(Toy toy) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        Toy toy2 = null;
        boolean bl = true;
        int n = toy.m_iType;
        if (toy.m_iInteractDelay > 0) {
            return bl;
        }
        this.m_bIsoXCollision = false;
        this.m_bIsoYCollision = false;
        switch (n) {
            case 5: {
                if (this.m_pxTargetNeeds[3] > 0) {
                    if (this.m_pxNeeds[3] < this.m_pxTargetNeeds[3]) break;
                    bl = false;
                    this.makeExcited();
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                Toy toy3 = this.m_pGame.getItem(0);
                int n2 = -8192;
                if (toy3 != null && toy3.m_bVisible) {
                    n2 = -1474560;
                }
                toy2 = this.m_pGame.getItem(2);
                if (toy2.m_xInterestRate != n2 || toy2.m_xInterestRate != -8192) {
                    toy2.m_bPauseInterestGen = false;
                    toy2.m_xInterestRate = n2;
                }
                if (this.m_pCarry != null) {
                    this.m_pCarry.setCurrentAI(0);
                    this.onDogEvent(null, 403, null, 0);
                    break;
                }
                if (this.m_iTLCMode == 0 || this.m_iAction == 7) break;
                this.setAction(7);
                break;
            }
            case 0: 
            case 3: 
            case 10: 
            case 11: {
                if (this.m_pCarry == null || this.m_pCarry != toy) {
                    if (toy.m_iType == 0 && !this.m_pGame.isInInteractionArea(toy) && toy.m_bVisible || toy.m_iType == 3 && toy.m_bVisible || toy.m_iType == 10 && toy.m_bVisible || toy.m_iType == 11 && toy.m_bVisible) {
                        this.onDogEvent(toy, 402, null, 0);
                        toy.setCurrentAI(2);
                        if (n != 10 || this.m_iChewBonePlayingTime > 0) break;
                        this.m_iChewBonePlayingTime = 5000;
                        break;
                    }
                    toy2 = this.m_pGame.getItem(1);
                    if (toy2 != null) {
                        int n3 = toy2.m_xInterestLevel;
                        toy.m_xInterestLevel = n3 -= 4096;
                        toy.m_bPauseInterestGen = false;
                    }
                    bl = false;
                    break;
                }
                toy2 = this.m_pGame.getItem(1);
                if (toy2 != null) {
                    int n4 = toy2.m_xInterestLevel;
                    toy.m_xInterestLevel = n4 -= 4096;
                    toy.m_bPauseInterestGen = false;
                }
                bl = false;
                break;
            }
            case 4: {
                if (this.m_pxNeeds[1] < this.m_pxTargetNeeds[1]) break;
                int n5 = petsApp.getSleepCount();
                if (++n5 >= 2) {
                    int n6 = petsApp.getAvatarRank();
                    n5 = DeviceInfo.k_iSimGoalInfo[n6][1];
                    petsApp.createGameMessage(224);
                    petsApp.addNumberToPopup(n5);
                    petsApp.addPopup();
                    petsApp.earnSimoleons(n5);
                    petsApp.tallySimoleons();
                    n5 = 0;
                }
                petsApp.setSleepCount(n5);
                this.resetNeedRate(0);
                this.setAction(9);
                bl = false;
                break;
            }
            case 1: {
                toy2 = this.m_pGame.getItem(0);
                if (this.m_pGame.isInCatchDiscArea(toy) && toy2 != null && toy2.m_bVisible && !toy2.isMoving() && this.m_pGame.isInInteractionArea(toy2) && this.m_pCarry != null && this.m_pCarry == toy2) {
                    Toy toy4 = this.m_pGame.getItem(2);
                    toy4.m_xInterestLevel = 405504;
                    this.interrupt(2, 0, null);
                    break;
                }
                if (this.m_msCountdownTimer1 != 0) break;
                this.m_pGame.randomWander(toy);
                bl = false;
                break;
            }
            case 8: {
                if (this.m_msCountdownTimer1 != 0) break;
                bl = false;
                break;
            }
            case 9: {
                Toy toy5 = toy;
                toy5.setState(toy5.m_iState + 1, 0, false);
                toy.m_xInterestLevel = 0;
                this.adjustNeed(2, 81920);
                this.m_xLastSuccessfulCommand = 13;
                this.m_iNeedTrainingTimer = 30000;
                toy2 = this.m_pGame.getItem(1);
                toy2.m_xInterestLevel = 409600;
                petsApp.playVib();
                bl = false;
                break;
            }
            case 12: {
                Toy toy6 = this.m_pGame.getItem(12);
                toy6.m_bVisible = false;
                this.adjustNeed(2, 81920);
                this.m_xLastSuccessfulCommand = 13;
                this.m_iNeedTrainingTimer = 30000;
                toy2 = this.m_pGame.getItem(1);
                toy2.m_xInterestLevel = 409600;
                petsApp.playVib();
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public final void setAction(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                int n3 = GameApp.nextInt() & Integer.MAX_VALUE;
                int n4 = 0;
                int n5 = 0;
                boolean bl = false;
                int n6 = 0;
                while (DeviceInfo.k_iPetMenuAbilities[n6][0] > -1) {
                    if (this.m_pxAbilities[DeviceInfo.k_iPetMenuAbilities[n6][0]] >= 409600) {
                        ++n4;
                    }
                    ++n6;
                }
                if (this.m_iAmbientIdleCounter > 0) {
                    --this.m_iAmbientIdleCounter;
                } else if (this.m_pCarry == null) {
                    n5 = n3 & 7;
                }
                if (n4 == 0 && n5 == 4) {
                    n5 = 0;
                }
                switch (n5) {
                    case 7: {
                        if (this.m_xMood >= 307200) {
                            this.makeExcited();
                            return;
                        }
                    }
                    case 0: 
                    case 5: 
                    case 6: {
                        n2 = DeviceInfo.k_iDogStateMap[this.m_iLogicalState][4];
                        bl = true;
                        break;
                    }
                    case 1: {
                        n2 = 12;
                        break;
                    }
                    case 2: {
                        n2 = 19;
                        break;
                    }
                    case 3: {
                        n2 = 14;
                        break;
                    }
                    case 4: {
                        n6 = n3 % n4;
                        n6 = DeviceInfo.k_iPetMenuAbilities[n6][0];
                        n2 = DeviceInfo.k_iPetAbilities[n6][2];
                        if (n6 != 20) break;
                        this.m_bPlayDead = true;
                    }
                }
                this.setNextAI(this.m_iCurrentAI);
                this.setCurrentAI(2);
                if (this.m_iAmbientIdleCounter <= 0 && !bl) {
                    this.m_iAmbientIdleCounter = 2 + ((n3 >>= 16) & 3);
                }
                this.m_iInterruptDelay = 3000 + GameApp.nextInt() % 2000;
                break;
            }
            case 1: {
                n2 = 8;
                break;
            }
            case 2: 
            case 3: {
                return;
            }
            case 4: {
                n2 = 5;
                break;
            }
            case 5: {
                n2 = 16;
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                n2 = 9;
                break;
            }
            case 8: {
                n2 = 10;
                break;
            }
            case 13: {
                n2 = 15;
                break;
            }
            case 14: {
                n2 = 21;
                break;
            }
            case 11: {
                break;
            }
            case 9: {
                if (this.m_pInterest != null && this.m_pInterest.m_iType == 2 && this.m_pInterest.m_bActive) {
                    n2 = 0;
                    break;
                }
                n2 = DeviceInfo.k_iDogStateMap[this.m_iLogicalState][4];
                break;
            }
            case 10: {
                n2 = 17;
                break;
            }
            case 15: {
                n2 = 11;
                break;
            }
            case 12: {
                n2 = this.m_iSuccessAnimState;
            }
        }
        if (n2 > -1 && this.m_iLogicalState != n2) {
            if (n2 == 8) {
                PetsApp petsApp = (PetsApp)GameApp.m_instance;
                petsApp.playSound(0);
            }
            this.setLogicalState(n2);
        }
        this.m_iAction = n;
    }

    public final void makeExcited() {
        int n = (GameApp.nextInt() & Integer.MAX_VALUE) % 100;
        if (n < 30) {
            this.setAction(1);
        } else if (n >= 30 && n < 60) {
            this.setAction(1);
            this.m_bExcited_Bark_Bark = true;
        } else if (n >= 60 && n < 80) {
            this.setAction(13);
        } else if (n >= 80 && n < 90) {
            this.setAction(1);
            this.m_bExcited_Bark_Jump = true;
        } else if (n >= 90) {
            this.setAction(13);
            this.m_bExcited_Jump_Bark = true;
        }
    }

    private final void updateAction() {
        int n = -1;
        switch (this.m_iAction) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                PetsApp petsApp;
                if (DeviceInfo.k_iDogStateMap[this.m_iLogicalState][3] == 0 || (petsApp = (PetsApp)GameApp.m_instance).isPlayingSound(1)) break;
                petsApp.playSound(1);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
        }
    }

    private final boolean caughtDisc() {
        int n;
        int n2 = (GameApp.nextInt() & Integer.MAX_VALUE) % 100 << 12;
        int n3 = this.m_iCatchLevel;
        if (!this.m_bThrowSucceed) {
            --n3;
        }
        if (n3 == 1) {
            n = 81920;
        } else if (n3 >= 2) {
            n = 81920 * this.m_iCatchLevel;
        } else {
            return false;
        }
        return n2 <= n;
    }

    private final void updateAttached() {
        if (this.getNumPointSets() >= 5) {
            int n = DeviceInfo.k_iDogStateMap[this.m_iLogicalState][4];
            int n2 = 0;
            boolean bl = false;
            boolean bl2 = true;
            this.getPointSet(4, this.m_piPoints);
            int n3 = this.m_iX - (this.getAnchorX() << 12);
            int n4 = this.m_iY - (this.getAnchorY() << 12);
            this.m_pAttached.setLocation(n3 + (this.m_piPoints[0] << 12), n4 + (this.m_piPoints[1] << 12));
            int[] nArray = this.m_pGame.toIsoCoord(this.m_xWorldRight, this.m_xWorldTop);
            this.m_pAttached.setZ(nArray[1] + 4096);
            switch (n) {
                case 0: {
                    n2 = 0;
                    break;
                }
                case 24: {
                    bl = true;
                    break;
                }
                case 1: {
                    n2 = 1;
                    break;
                }
                case 25: {
                    bl = true;
                }
                case 2: {
                    if (this.m_pAttached.m_iResourceID == 62) {
                        bl2 = false;
                        break;
                    }
                    n2 = 2;
                }
            }
            this.m_pAttached.setState(n2, 0, bl);
            this.m_pAttached.m_bVisible = bl2;
        }
    }

    protected final void adjustAbilityLevel(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        boolean bl = true;
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        Toy toy = null;
        this.m_xPreviousAbilityLevel = n5 = this.m_pxAbilities[n];
        n6 = DeviceInfo.k_iBaseTrainingValues[n3][n2];
        n8 = DeviceInfo.k_iPetAbilities[n][4];
        if (n8 > -1) {
            if (n8 == 0 && n4 == 1 || n8 == 1 && n4 == 3) {
                if (n != 22 || petsApp.getCurrentLocation() != 1) {
                    bl = false;
                }
            } else if (n == 22 && petsApp.getCurrentLocation() == 1) {
                bl = false;
            }
        } else if (n4 == 3) {
            bl = false;
        }
        n7 = n6;
        n7 = bl ? n5 + n7 : n5 - n7;
        if (n7 >= 409600) {
            n7 = 409600;
            if (n7 > n5) {
                if (n == 22) {
                    petsApp.triggerHint(-2147483584);
                    petsApp.completeMetaGoal(131073);
                } else if (n == 13) {
                    petsApp.triggerHint(-2147483632);
                    petsApp.completeMetaGoal(131080);
                } else {
                    petsApp.pushTrainerPromptLearnedAbility(n);
                    int n9 = 0;
                    while (DeviceInfo.k_iPetMenuAbilities[n9][0] > -1) {
                        if (DeviceInfo.k_iPetMenuAbilities[n9][0] == n) {
                            petsApp.completeMetaGoal(0 | 1 << n9);
                            break;
                        }
                        ++n9;
                    }
                }
            }
        } else if (n7 < 0) {
            n7 = 0;
        }
        if (n7 != n5) {
            this.m_iLearningTimer = -2500;
            this.m_xLearningProgress = n5;
            this.m_xLearningTarget = n7;
        }
        if (this.m_pInterest != (toy = this.m_pGame.getItem(2))) {
            toy.m_xInterestLevel = 409600;
        }
        this.setDogAbility(n, n7);
        petsApp.saveData();
    }

    public final void updateCompositeParts(int n) {
        if (this.m_pHeadPart != null) {
            this.getPointSet(2, this.m_piPoints);
            if (this.m_bMirrored) {
                this.m_pHeadPart.setWorldLocation(this.m_xWorldX + (this.m_piPoints[0] - (this.getFrameWidth() - this.getAnchorX()) << 12), this.m_xWorldY + (this.m_piPoints[1] - this.getAnchorY() << 12), this.m_pHeadPart.m_xWorldZ);
            } else {
                this.m_pHeadPart.setWorldLocation(this.m_xWorldX + (this.m_piPoints[0] - this.getAnchorX() << 12), this.m_xWorldY + (this.m_piPoints[1] - this.getAnchorY() << 12), this.m_pHeadPart.m_xWorldZ);
            }
        }
        if (this.m_pTailPart != null) {
            this.getPointSet(4, this.m_piPoints);
            if (this.m_bMirrored) {
                this.m_pTailPart.setWorldLocation(this.m_xWorldX + (this.m_piPoints[0] - (this.getFrameWidth() - this.getAnchorX()) << 12), this.m_xWorldY + (this.m_piPoints[1] - this.getAnchorY() << 12), this.m_pTailPart.m_xWorldZ);
            } else {
                this.m_pTailPart.setWorldLocation(this.m_xWorldX + (this.m_piPoints[0] - this.getAnchorX() << 12), this.m_xWorldY + (this.m_piPoints[1] - this.getAnchorY() << 12), this.m_pTailPart.m_xWorldZ);
            }
        }
    }

    public final void setHeadPart(Interactive interactive) {
        this.m_pHeadPart = interactive;
    }

    public final void setTailPart(Interactive interactive) {
        this.m_pTailPart = interactive;
    }

    public final void addInteractionAbility() {
        int n = 0;
        while (DeviceInfo.k_iPetMenuInteractions[n][0] >= 0) {
            this.addInteraction(DeviceInfo.k_iPetMenuInteractions[n][0], DeviceInfo.k_iPetMenuInteractions[n][1]);
            ++n;
        }
        n = 0;
        while (DeviceInfo.k_iPetMenuAbilities[n][0] >= 0) {
            this.addAbility(DeviceInfo.k_iPetMenuAbilities[n][0], DeviceInfo.k_iPetMenuAbilities[n][1]);
            ++n;
        }
        this.addInteraction(2600, 0);
        this.m_bVisible = true;
    }

    public final void onDogEvent(GameObject gameObject, int n, Object object, int n2) {
        Toy toy = null;
        switch (n) {
            case 401: {
                this.advanceAI();
                switch (this.m_iCurrentAI) {
                    case 3: {
                        Toy toy2;
                        if (this.m_pInterest == null && (toy2 = (Toy)this.m_pGame.findMostInteresting()) != null) {
                            this.interrupt(0, 0, toy2);
                        }
                        if (this.m_pInterest != null) {
                            this.m_pInterest.m_bPauseInterestGen = false;
                            this.setVelocity(this.m_pInterest.m_xWorldX - this.m_xWorldX, this.m_pInterest.m_xWorldY - this.m_xWorldY, 0, 24576);
                        }
                        this.setNextAI(1);
                        break;
                    }
                    case 0: {
                        if (this.m_iAction != 12 && this.m_iAction != 0) break;
                        this.setAction(9);
                    }
                }
                break;
            }
            case 402: {
                if (!this.m_bFoundObject) {
                    if (this.m_pCarry != null && this.m_pCarry != gameObject) {
                        this.onDogEvent(null, 403, null, 0);
                        Toy toy3 = this.m_pGame.getItem(2);
                        this.interrupt(0, 0, toy3);
                        toy3.m_xInterestLevel = 409600;
                    }
                    if (this.m_pGame != null) {
                        this.m_pGame.selectInteractive(this);
                    }
                    this.setNextAI(this.m_iCurrentAI);
                    this.setCurrentAI(2);
                }
                this.m_pCarry = (Toy)gameObject;
                this.setAction(2);
                break;
            }
            case 403: {
                if (this.m_pCarry == null) break;
                this.m_pCarry.m_bNoContainment = false;
                this.m_pCarry.onDeactivate();
                this.setAction(3);
                toy = this.m_pGame.getItem(1);
                if (this.m_pCarry.m_iType != 0) {
                    int n3 = toy.m_xInterestLevel;
                    this.m_pCarry.m_xInterestLevel = n3 += 4096;
                    this.m_pCarry.m_bPauseInterestGen = false;
                    toy = this.m_pGame.getItem(2);
                    toy.m_bPauseInterestGen = false;
                    toy.m_xInterestLevel = 409600;
                } else {
                    this.interrupt(0, 0, toy);
                    toy.m_xInterestLevel = 409600;
                    this.m_pCarry.m_xInterestLevel = 0;
                }
                this.m_pCarry.setWorldLocation(this.m_pCarry.m_xWorldX, this.m_pCarry.m_xWorldY, 0);
                this.m_pCarry = null;
                this.m_msCountdownTimer1 = 0;
                this.m_msCountdownTimer2 = 0;
                toy = this.m_pGame.getItem(0);
                if (toy != null && toy.m_bVisible) {
                    this.m_pGame.selectInteractive(toy);
                    break;
                }
                this.setNextAI(0);
                break;
            }
            case 405: {
                if (this.m_pCarry != null) {
                    this.m_pCarry.m_bNoContainment = false;
                    this.m_pCarry.onDeactivate();
                    int n4 = GameApp.nextInt() % 4096;
                    int n5 = GameApp.nextInt() % 4096;
                    this.m_pGame.startThrow(this.m_pCarry, n4, n5, 0, 1024);
                    this.m_pCarry.m_xInterestLevel = 409600;
                    this.m_pCarry = null;
                }
                if (this.m_iCurrentAI != 2) break;
                this.advanceAI();
                break;
            }
            case 404: {
                this.setAction(10);
                this.setNextAI(this.m_iCurrentAI);
                this.setCurrentAI(2);
                break;
            }
            case 407: {
                if (this.m_pAttached != null) {
                    this.m_pAttached.m_bVisible = false;
                    this.m_pAttached = null;
                }
                if (gameObject == null) break;
                this.m_pAttached = (AnimObject)gameObject;
            }
        }
    }

    public final boolean interrupt(int n, int n2, Interactive interactive) {
        boolean bl = false;
        switch (n) {
            case 0: {
                this.m_iInterruptDelay = 0;
                if (this.m_pInterest != null) {
                    this.interrupt(1, n2, null);
                }
                this.m_pInterest = (Toy)interactive;
                if (this.m_pInterest != null) {
                    this.m_pInterest.onToyEvent(this, 401, null, 0);
                    this.m_iInterruptDelay = this.m_pInterest.m_iReactionTime;
                }
                if (this.m_iAction == 0) {
                    this.setAction(9);
                }
                this.setCurrentAI(2);
                this.setNextAI(3);
                bl = true;
                break;
            }
            case 1: {
                this.setCurrentAI(2);
                this.m_iInterruptDelay = 0;
                if (this.m_pInterest != null) {
                    if (this.m_pInterest.m_bActive) {
                        this.m_pInterest.onDeactivate();
                        if (this.m_pInterest == this.m_pGame.getItem(2)) {
                            this.m_iNumAvailableInteractions = 0;
                            this.m_pInterest.m_bPauseInterestGen = false;
                            this.setThought(-1);
                        }
                    } else {
                        this.m_pInterest.onToyEvent(this, 402, null, 0);
                    }
                }
                this.m_pInterest = null;
                this.setNextAI(0);
                bl = true;
                break;
            }
            case 2: {
                this.interrupt(3, 0, null);
                this.setLogicalState(0);
                bl = true;
                break;
            }
            case 3: {
                this.stopMovement();
                this.setNextAI(this.m_iCurrentAI);
                this.setCurrentAI(4);
                this.setAction(9);
            }
        }
        return bl;
    }

    public final void doPotty() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        Toy toy = null;
        this.resetAllNeedRates();
        this.m_bNeedBladder = false;
        this.setTargetNeed(0, 0);
        if (this.m_pGame != null && (toy = this.m_pGame.getItem(7)) != null) {
            if (toy.m_bVisible) {
                toy.m_bVisible = false;
            }
            this.m_pGame.useItem(23);
            this.adjustNeed(0, 409600);
            this.m_bFeedBackBladderShow = false;
        }
        if (this.m_pxAbilities[22] < 409600) {
            this.m_xLastSuccessfulCommand = 22;
            this.m_iNeedTrainingTimer = 30000;
        }
        this.setAction(10);
        this.m_bPottyAtWanderInterest = false;
        this.m_pxNeeds[4] = this.m_pxNeeds[4] - 122880;
        this.setDisplayFeedback(4, 1);
        petsApp.playVib();
    }

    public final boolean readyToMove() {
        return DeviceInfo.k_iDogStateMap[this.m_iLogicalState][2] != 0;
    }

    public final void onUpdateAction(int n) {
        switch (this.m_iCurrentAI) {
            case 0: {
                Toy toy;
                if (this.m_pInterest != null || (toy = (Toy)this.m_pGame.findMostInteresting()) == null) break;
                this.interrupt(0, 0, toy);
                break;
            }
            case 2: {
                if (this.m_bStationary) break;
                this.m_bStationary = true;
                break;
            }
            case 3: {
                Toy toy;
                if (this.m_iAction != 6) {
                    this.setAction(6);
                    break;
                }
                if (!this.readyToMove()) break;
                if (this.m_pGame != null && (toy = (Toy)this.m_pGame.findMostInteresting()) != null && toy != this.m_pInterest && this.m_pInterest != null && (this.m_pInterest.getActualInterest(this) <= 0 || this.m_pInterest.getActualInterest(this) < toy.getActualInterest(this))) {
                    this.interrupt(1, 0, null);
                    break;
                }
                this.setNextAI(1);
                this.m_bStationary = false;
                this.moveToInterest();
                break;
            }
            case 1: {
                int n2 = 0;
                Toy toy = (Toy)this.m_pGame.findMostInteresting();
                if (toy != null && toy != this.m_pInterest) {
                    n2 = toy.getActualInterest(this);
                }
                boolean bl = false;
                if (this.m_pInterest != null) {
                    bl = !this.onInteract(this.m_pInterest);
                    bl |= this.m_pInterest.getActualInterest(this) == 0 || this.m_pInterest.getActualInterest(this) < n2;
                } else {
                    bl = true;
                }
                if (!bl) break;
                this.interrupt(1, 0, null);
                break;
            }
        }
    }

    public final boolean willRefuse() {
        for (int i = 0; i < 4; ++i) {
            if (this.m_pxNeeds[i] >= DeviceInfo.k_iRefusalMotivesLevel[i]) continue;
            this.m_iThought = i;
            return true;
        }
        return false;
    }

    public final void confuse() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        petsApp.decrAvatarMood(20480);
        this.setThought(5);
        this.m_iTargetState = -1;
        if (this.m_bTrickSequenceTimeOn) {
            this.m_bTrickSequenceTimeOn = false;
            this.m_iCommandResponseTime = 0;
            this.m_iSequenceAbility = -1;
        }
        this.setAction(15);
    }

    public final void dismiss() {
        this.setCurrentAI(0);
        this.setNextAI(0);
        Toy toy = this.m_pGame.getItem(2);
        toy.m_xInterestLevel = 0;
        if (this.m_pInterest != null) {
            this.interrupt(1, 0, null);
        }
        if (this.m_pCarry != null && !this.m_pCarry.m_bVisible) {
            this.m_pCarry = null;
        }
        this.setAction(9);
    }

    public void handleInteractionAbility(int n) {
        Toy toy = null;
        toy = this.m_pGame.getItem(2);
        toy.m_xInterestLevel = 409600;
        toy.m_bPauseInterestGen = false;
        toy.m_xInterestRate = -8192;
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        this.m_bCommandDisobey = false;
        this.m_iPetReqAttentionCount = 0;
        if (n == -1) {
            if (this.m_iNeedTrainingTimer <= 0) {
                this.m_iNumAvailableInteractions = 0;
                if (this.m_pInterest == this.m_pGame.getItem(2)) {
                    this.m_pInterest.m_bPauseInterestGen = false;
                }
            }
            return;
        }
        if (this.m_iThought == 5 || this.m_iThought == 6) {
            this.setThought(-1);
        }
        switch (n) {
            case 0: 
            case 2: 
            case 4: {
                super.handleInteractionAbility(n);
                return;
            }
            case 1: {
                this.adjustNeed(2, 81920);
                this.adjustAbilityLevel(this.m_xLastSuccessfulCommand, 1, 0, 1);
                this.m_iNeedTrainingTimer = 0;
                this.m_bPraised = true;
                this.setAction(11);
                this.m_iDidSuccessfulAbility = this.m_xLastSuccessfulCommand;
                this.m_xLastSuccessfulCommand = -1;
                super.handleInteractionAbility(n);
                return;
            }
            case 3: {
                this.adjustNeed(2, -81920);
                this.m_bScolded = true;
                this.setAction(11);
                this.adjustAbilityLevel(this.m_xLastSuccessfulCommand, 0, 0, 3);
                this.m_iNeedTrainingTimer = 0;
                this.m_iDidSuccessfulAbility = this.m_xLastSuccessfulCommand;
                this.m_xLastSuccessfulCommand = -1;
                super.handleInteractionAbility(n);
                return;
            }
        }
        for (int i = 0; i < 4; ++i) {
            if (this.m_pxNeeds[i] >= DeviceInfo.k_iRefusalMotivesLevel[i]) continue;
            this.m_bCommandDisobey = true;
        }
        this.m_bCommandDisobey &= this.m_xMood < 0;
        if (!this.m_bCommandDisobey) {
            this.adjustNeed(2, 40960);
            int n2 = this.m_pxAbilities[n];
            if (n2 < 409600) {
                this.m_xLastSuccessfulCommand = n;
            }
            this.m_iSuccessAnimState = DeviceInfo.k_iPetAbilities[n][2];
            if (this.m_iSuccessAnimState != -1) {
                this.m_bPlayDead = n == 20;
                this.m_bTrickResponseTimeOn = true;
            } else {
                petsApp.incrAvatarMood(40960);
                this.m_iNeedTrainingTimer = 30000;
            }
            this.m_iAbilityLevel = n2;
        } else {
            this.setThought(6);
            petsApp.playSound(2);
            this.m_msCountdownTimer1 = 2000;
            this.m_xLastSuccessfulCommand = n;
            petsApp.decrAvatarMood(40960);
        }
        if (this.m_iAction != 12) {
            this.setAction(11);
        }
    }

    public boolean onStateDone() {
        Toy toy;
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        boolean bl = super.onStateDone();
        boolean bl2 = this.m_bPlayForward;
        if (this.m_iAction == 12 && this.m_iSuccessAnimState != -1 && (this.m_iLogicalState != 18 || this.m_iLogicalState == 18 && !this.m_bPlayForward)) {
            petsApp.incrAvatarMood(40960);
            if (this.m_xLastSuccessfulCommand != -1) {
                this.m_bCommandResponseTimeOn = true;
                petsApp.triggerHint(2048);
            }
            if (this.m_iLogicalState == 18) {
                this.m_iTargetState = 0;
            }
            this.m_iSuccessAnimState = -1;
        }
        if (this.m_iState == 5) {
            this.m_pCarry = null;
            toy = this.m_pGame.getItem(10);
            if (toy != null && toy.m_bVisible) {
                this.m_pGame.removeRemovableObject();
                this.setAction(9);
                this.adjustNeed(2, 81920);
                this.setDisplayFeedback(2, 2);
            }
        }
        if (this.m_iState == 17) {
            this.setAction(9);
        }
        if (this.m_iState == 15) {
            this.setAction(9);
            if (this.m_pCarry != null && (toy = this.m_pGame.getItem(0)) != null && this.m_pCarry == toy) {
                toy = this.m_pGame.getItem(2);
                this.interrupt(0, 0, toy);
                toy.m_xInterestLevel = 409600;
                if (this.m_pCarry == null) {
                    this.m_pCarry = this.m_pGame.getItem(0);
                }
            }
            if (this.m_bExcited_Jump_Bark) {
                this.m_bExcited_Jump_Bark = false;
                this.setAction(1);
            }
        }
        if (this.m_iState == 18) {
            if (this.m_bPlayForward) {
                if (this.m_bPlayDead) {
                    if (this.m_msCountdownTimer2 <= 0) {
                        this.m_msCountdownTimer2 = 2000;
                    }
                    return false;
                }
                this.m_bPlayForward = false;
            } else {
                this.m_bPlayDead = false;
                bl = false;
                this.m_iTargetState = 0;
                this.m_iInterruptDelay = 1;
            }
        }
        if (this.m_iTargetState != -1) {
            this.setLogicalState(this.m_iTargetState);
        } else {
            if (this.m_iLogicalState == 9) {
                bl = false;
            } else if (this.m_iLogicalState == 8 || this.m_iLogicalState == 11 || this.m_iLogicalState == 14) {
                this.setLogicalState(0);
            }
            if (this.m_iAction == 1 || this.m_iAction == 15) {
                if (this.m_bExcited_Bark_Bark) {
                    this.m_bExcited_Bark_Bark = false;
                    this.setAction(1);
                } else if (this.m_bExcited_Bark_Jump) {
                    this.m_bExcited_Bark_Jump = false;
                    this.setAction(13);
                } else {
                    this.setAction(9);
                }
            }
        }
        if (this.m_iCurrentAI == 2 && this.m_iInterruptDelay <= 0) {
            if (this.m_pInterest != null) {
                this.m_xInterestLevel = this.m_pInterest.m_xInterestLevel;
                this.advanceAI();
                if (this.m_iCurrentAI == 3) {
                    this.setNextAI(1);
                }
            } else {
                this.setCurrentAI(0);
                this.setNextAI(0);
            }
        }
        if (bl2 != this.m_bPlayForward) {
            return false;
        }
        return bl;
    }

    public void onUserSelected() {
        Toy toy = null;
        super.onUserSelected();
        toy = this.m_pGame.getItem(2);
        if (this.m_pInterest != toy) {
            toy.m_xInterestLevel = 405504;
            this.m_bCalledByOwner = true;
            this.m_iBubbleTime = 0;
        } else {
            this.m_iNumAvailableInteractions = this.m_iInteractionCount;
            this.m_iBubbleTime = 0;
        }
        if (this.m_iAction == 0 && (this.m_iLogicalState == 0 || this.m_iLogicalState == 1 || this.m_iLogicalState == 24 || this.m_iLogicalState == 2 || this.m_iLogicalState == 25)) {
            this.setAction(9);
        }
    }

    public boolean onCheckContainment(int[] nArray) {
        if (!this.m_bNoContainment) {
            if (this.m_xWorldLeft <= nArray[0] && this.m_xWorldRight < nArray[2] || this.m_xWorldLeft > nArray[0] && this.m_xWorldRight >= nArray[2]) {
                return true;
            }
            if (this.m_xWorldTop <= nArray[1] && this.m_xWorldBottom < nArray[3] || this.m_xWorldTop > nArray[1] && this.m_xWorldBottom >= nArray[3]) {
                return true;
            }
        }
        return false;
    }

    public void onHandleContainment(int[] nArray) {
        int[] nArray2 = new int[4];
        int n = 0;
        int n2 = 0;
        nArray2[0] = this.m_xWorldLeft;
        nArray2[1] = this.m_xWorldTop;
        nArray2[2] = this.m_xWorldRight;
        nArray2[3] = this.m_xWorldBottom;
        if (nArray2[0] <= nArray[0] && nArray2[2] < nArray[2] || nArray2[0] > nArray[0] && nArray2[2] >= nArray[2]) {
            if (nArray2[0] <= nArray[0]) {
                n = nArray[0] - nArray2[0];
                n += 4096;
            } else {
                n = nArray[2] - nArray2[2];
                n -= 4096;
            }
        }
        if (nArray2[1] <= nArray[1] && nArray2[3] < nArray[3] || nArray2[1] > nArray[1] && nArray2[3] >= nArray[3]) {
            if (nArray2[1] <= nArray[1]) {
                n2 = nArray[1] - nArray2[1];
                n2 += 4096;
            } else {
                n2 = nArray[3] - nArray2[3];
                n2 -= 4096;
            }
        }
        this.setWorldLocation(this.m_xWorldX + n, this.m_xWorldY + n2, this.m_xWorldZ);
    }

    public void onHandleCollision(Interactive interactive) {
        Interactive interactive2 = interactive;
        if (!this.m_pGame.isInInteractionArea(interactive) && interactive == this.m_pGame.getItem(0) && this.m_iCurrentAI == 4) {
            PetsApp petsApp = (PetsApp)GameApp.m_instance;
            if (this.m_iState != 15 && this.m_pCarry == null) {
                ++this.m_iThrowedNum;
                if (this.m_iThrowedNum >= 5) {
                    this.m_iThrowedNum = 0;
                    if (this.m_iCatchLevel < 5) {
                        ++this.m_iCatchLevel;
                        if (this.m_iCatchLevel == 5) {
                            if (petsApp.isCurrentMetaGoal(196609)) {
                                petsApp.completeMetaGoal(196609);
                            } else {
                                --this.m_iCatchLevel;
                            }
                        }
                    }
                }
                this.setAction(13);
                if (this.caughtDisc()) {
                    petsApp.triggerHint(-2147483616);
                    this.onDogEvent(interactive, 402, null, 0);
                    interactive.setCurrentAI(2);
                }
            }
        }
        if (this.m_iCurrentAI == 3 && this.m_pInterest != null && interactive2 == this.m_pInterest) {
            this.advanceAI();
            this.m_pInterest.onActivate();
            if (this.m_pInterest.m_iType == 2) {
                if (this.m_bCalledByOwner) {
                    this.m_iNumAvailableInteractions = this.m_iInteractionCount;
                    this.m_pInterest.m_bPauseInterestGen = true;
                } else if (this.m_iWantToShowThought >= 0) {
                    this.setThought(this.m_iWantToShowThought);
                    this.m_iWantToShowThought = -1;
                }
                this.m_bCalledByOwner = false;
                int n = GameApp.nextInt() & Integer.MAX_VALUE;
                if (this.m_msCountdownTimer1 == 0) {
                    if (this.m_bCommandDisobey) {
                        this.finishDisobedienceDisplay();
                        this.m_xInterestLevel = 409600;
                    } else if ((n & 0x1F) == 0 && this.m_iNextAI != 3 && this.m_iAction != 9) {
                        this.setAction(9);
                    }
                }
            }
            if (this.m_iAction == 6) {
                this.setAction(9);
            }
            this.stopMovement();
        }
    }

    public boolean canAddInteraction(int n) {
        switch (n) {
            case 0: {
                return true;
            }
            case 4: {
                return false;
            }
            case 1: {
                if (this.m_iNeedTrainingTimer > 0) {
                    if (0 <= this.m_xLastSuccessfulCommand && this.m_xLastSuccessfulCommand < 27 && DeviceInfo.k_iPetAbilities[this.m_xLastSuccessfulCommand][4] < 0) {
                        return true;
                    }
                    switch (this.m_xLastSuccessfulCommand) {
                        case 22: {
                            PetsApp petsApp = (PetsApp)GameApp.m_instance;
                            if (petsApp.getCurrentLocation() != 1) break;
                            return true;
                        }
                    }
                }
                return false;
            }
            case 3: {
                if (this.m_iNeedTrainingTimer > 0 && 0 <= this.m_xLastSuccessfulCommand && this.m_xLastSuccessfulCommand < 27 && DeviceInfo.k_iPetAbilities[this.m_xLastSuccessfulCommand][4] >= 0) {
                    switch (this.m_xLastSuccessfulCommand) {
                        case 22: {
                            PetsApp petsApp = (PetsApp)GameApp.m_instance;
                            if (petsApp.getCurrentLocation() == 1) break;
                            return true;
                        }
                        case 13: {
                            return true;
                        }
                    }
                }
                return false;
            }
            case 2600: {
                return this.m_bFoundObject;
            }
        }
        return this.m_pInterest == this.m_pGame.getItem(2);
    }

    public boolean canAddAbility(int n) {
        if (!this.checkAbilityState(n)) {
            return false;
        }
        if (this.m_iNeedTrainingTimer > 0) {
            return false;
        }
        if (n == 2) {
            return this.m_pInterest == this.m_pGame.getItem(2);
        }
        return super.canAddAbility(n);
    }

    public void setCurrentAI(int n) {
        if (n >= 0 && n < 5) {
            this.m_iCurrentAI = n;
        }
    }

    public void setNextAI(int n) {
        if (n >= 0 && n < 5) {
            this.m_iNextAI = n;
        }
    }

    public void advanceAI() {
        this.setCurrentAI(this.m_iNextAI);
        this.setNextAI(0);
    }

    public void onIdle(int n) {
        int n2;
        AnimObject animObject;
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        if (this.m_pGame == null) {
            super.onIdle(n);
            return;
        }
        Toy toy = null;
        if (this.m_pxNeeds[3] < 327680 && this.m_iAction != 8) {
            toy = this.m_pGame.getItem(5);
            animObject = this.m_pGame.m_pFood;
            if (toy != null && animObject != null && animObject.m_bVisible && this.m_pInterest != toy) {
                this.interrupt(0, 0, toy);
                toy.m_xInterestLevel = 409600;
            }
        }
        if (this.m_bTrickResponseTimeOn || this.m_bTrickSequenceTimeOn) {
            this.m_iCommandResponseTime += n;
            if (this.m_iCommandResponseTime > 350) {
                this.m_iCommandResponseTime = 0;
                if (this.m_bTrickResponseTimeOn) {
                    this.setAction(12);
                    if (this.m_iAbilityLevel >= 409600) {
                        this.m_iSuccessAnimState = -1;
                        this.m_iNeedTrainingTimer = 0;
                        this.interrupt(1, 0, null);
                        this.m_iInterruptDelay = 2000;
                    }
                    this.m_bTrickResponseTimeOn = false;
                } else if (this.m_bTrickSequenceTimeOn) {
                    this.setAction(this.m_iSequenceAbility);
                    this.m_bTrickSequenceTimeOn = false;
                }
            }
        }
        if (this.m_bCommandResponseTimeOn) {
            this.m_iCommandResponseTime += n;
            if (this.m_iCommandResponseTime > 2000) {
                this.m_iCommandResponseTime = 0;
                this.m_bCommandResponseTimeOn = false;
                this.m_iNeedTrainingTimer = 30000;
                if (this.m_pInterest != null) {
                    this.m_pInterest.m_bPauseInterestGen = true;
                }
                this.setNextAI(this.m_iCurrentAI);
                this.setCurrentAI(2);
            }
        }
        if (this.m_xMood < 0 && this.m_iPetLastInteractionTime > 0 && this.m_iPetReqAttentionCount < 3) {
            this.m_iPetLastInteractionTime -= n;
            if (this.m_iPetLastInteractionTime <= 0) {
                this.m_iPetLastInteractionTime = 0;
                this.setAction(1);
                if (this.m_xMood < -204800) {
                    petsApp.playSound(5);
                } else {
                    petsApp.playSound(13);
                }
                ++this.m_iPetReqAttentionCount;
            }
        }
        if (this.m_iChewBonePlayingTime > 0) {
            this.m_iChewBonePlayingTime -= n;
            toy = this.m_pGame.getItem(10);
            if (this.m_iChewBonePlayingTime <= 0) {
                this.m_iChewBonePlayingTime = 0;
                this.setAction(4);
                this.interrupt(0, 0, toy);
                if (toy != null) {
                    toy.setWorldLocation(this.m_xWorldX, this.m_xWorldY, this.m_xWorldZ);
                }
            } else if (toy != null && !toy.m_bVisible) {
                this.m_iChewBonePlayingTime = 0;
            }
        }
        if ((toy = this.m_pGame.getItem(4)) != null && toy.m_bVisible && this.m_pxNeeds[1] >= 0 && this.m_pxNeeds[1] < 102400 && toy.m_bVisible && this.m_pInterest != (animObject = this.m_pGame.getItem(2))) {
            toy.m_xInterestLevel = 409600;
        }
        if (this.m_bSleeping) {
            this.setNeedRate(1, 40960);
            this.setTargetNeed(1, 409600);
        }
        if (this.m_iPottyTime > 0) {
            this.m_iPottyTime -= n;
            if (this.m_iPottyTime <= 0) {
                this.m_iPottyTime = 0;
                this.m_bPottyAtWanderInterest = true;
                toy = this.m_pGame.getItem(1);
                toy.m_xInterestLevel = 409600;
            }
        }
        if (this.m_iNeedTrainingTimer > 0) {
            this.m_iNeedTrainingTimer -= n;
            if (this.m_iNeedTrainingTimer <= 0) {
                this.m_iNeedTrainingTimer = 0;
                this.m_iNumAvailableInteractions = 0;
            } else if (this.m_xLastSuccessfulCommand != 22) {
                toy = this.m_pGame.getItem(2);
                toy.m_xInterestLevel = 409600;
                toy.m_bPauseInterestGen = false;
            }
        }
        if (this.m_iTLCMode != 0) {
            toy = this.m_pGame.getItem(2);
            toy.m_xInterestLevel = 409600;
            toy.m_bPauseInterestGen = false;
        }
        if (this.m_iLearningTimer != 0) {
            if (this.m_iLearningTimer < 0) {
                this.m_iLearningTimer = -this.m_iLearningTimer;
            } else if (this.m_iLearningTimer <= n) {
                this.m_xLearningProgress = this.m_xLearningTarget;
                this.m_iLearningTimer = 0;
            } else {
                int n3 = this.m_xLearningTarget - this.m_xLearningProgress;
                n3 *= n;
                this.m_xLearningProgress += (n3 /= this.m_iLearningTimer);
                this.m_iLearningTimer -= n;
            }
        } else if (this.m_xLearningProgress != -1) {
            this.m_xLearningProgress = -1;
        }
        if (this.m_iWantToShowThought > -1 && (this.m_pInterest == null || this.m_pInterest != null && this.m_pInterest.m_iType != 2)) {
            boolean bl = true;
            toy = this.m_pGame.getItem(3);
            if (toy != null && toy.m_bVisible) {
                bl = false;
            }
            if ((toy = this.m_pGame.getItem(0)) != null && toy.m_bVisible) {
                bl = false;
            }
            if (bl) {
                toy = this.m_pGame.getItem(2);
                toy.m_xInterestLevel = 409600;
            }
        }
        this.onUpdateAction(n);
        this.updateAction();
        this.updateCompositeParts(n);
        if (this.m_iThought >= 0) {
            this.m_iBubbleTime += n;
            if (this.m_iBubbleTime >= 5000) {
                this.setThought(-1);
                if (this.m_pInterest == this.m_pGame.getItem(2)) {
                    this.m_pInterest.m_bPauseInterestGen = false;
                    this.dismiss();
                }
                this.m_iBubbleTime = 0;
            }
        }
        for (n2 = 0; n2 < 5; ++n2) {
            if (n2 == 0 && this.m_pxNeeds[n2] <= 102400) {
                this.setNeedRate(0, -6144);
                if (!this.m_bFeedBackBladderShow) {
                    this.m_bFeedBackBladderShow = true;
                    this.setDisplayFeedback(0, 0);
                }
            }
            this.adjustNeed(n2, this.m_pxNeedRates[n2] * n >> 10);
        }
        if (this.m_pxNeeds[0] <= this.m_pxTargetNeeds[0]) {
            this.resetNeedRate(0);
            this.setTargetNeed(0, 0);
        }
        if (this.m_pInterest != null) {
            this.m_xInterestLevel = this.m_pInterest.m_xInterestLevel;
        }
        if (this.m_iInterruptDelay >= 0 && this.m_iCurrentAI == 2) {
            this.m_iInterruptDelay -= n;
            if (this.m_iInterruptDelay <= 0) {
                this.onDogEvent(null, 401, null, 0);
                this.m_iInterruptDelay = 0;
            }
        }
        if (this.m_msCountdownTimer1 > 0) {
            this.m_msCountdownTimer1 -= n;
            if (this.m_msCountdownTimer1 < 0) {
                this.m_msCountdownTimer1 = 0;
            }
        }
        if (this.m_msCountdownTimer2 > 0) {
            this.m_msCountdownTimer2 -= n;
            if (this.m_msCountdownTimer2 <= 0) {
                this.m_msCountdownTimer2 = 0;
                if (this.m_bPlayDead) {
                    this.m_bPlayForward = false;
                    this.setState(this.m_iState, -1, this.m_bMirrored);
                }
            }
        }
        if (this.m_pCarry != null && this.m_pCarry.m_iType == 11) {
            if (this.m_iSqueakyToySoundTime == 0) {
                int n4 = (GameApp.nextInt() & Integer.MAX_VALUE) % 4;
                this.m_iSqueakyToySoundTime = 6000 - 1000 * n4;
            } else if (this.m_iSqueakyToySoundTime > 0) {
                this.m_iSqueakyToySoundTime -= n;
                if (this.m_iSqueakyToySoundTime < 0) {
                    this.m_iSqueakyToySoundTime = 0;
                    petsApp.playSound(15);
                }
            }
        }
        n2 = this.m_xWorldY;
        super.onIdle(n);
        if (this.m_pCarry != null) {
            this.updateCarriedObject();
        }
        if (this.m_pAttached != null) {
            this.updateAttached();
        }
    }

    public boolean onLoadResource(int n) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        boolean bl = super.onLoadResource(n);
        if (bl) {
            int n2;
            this.m_iCurrentAI = 0;
            this.m_pInterest = null;
            this.m_iCatchLevel = petsApp.getCatchLevel();
            for (n2 = 0; n2 < 5; ++n2) {
                this.m_pxNeeds[n2] = petsApp.getMotive(n2);
            }
            for (n2 = 1; n2 < 5; ++n2) {
                this.resetNeedRate(n2);
            }
            this.m_pxTargetNeeds[0] = petsApp.getTargetBladder();
            if (this.m_pxTargetNeeds[0] != 0 && this.m_pxTargetNeeds[0] < this.m_pxNeeds[0]) {
                this.setNeedRate(0, -12288);
            }
            this.m_xInterestLevel = 0;
            this.m_xInterestRate = 12288;
        }
        return bl;
    }

    public boolean onCheckIsoContainment(int[] nArray) {
        int[] nArray2 = new int[4];
        int[] nArray3 = this.m_pGame.toIsoCoord(this.m_xWorldLeft, this.m_xWorldTop);
        nArray2[0] = nArray3[0];
        nArray3 = this.m_pGame.toIsoCoord(this.m_xWorldRight, this.m_xWorldBottom);
        nArray2[2] = nArray3[0];
        return !this.m_bNoContainment && (nArray2[0] <= nArray[0] && nArray2[2] < nArray[2] || nArray2[0] > nArray[0] && nArray2[2] >= nArray[2]);
    }

    public void onHandleIsoContainment(int[] nArray) {
        int[] nArray2 = new int[4];
        int n = 0;
        boolean bl = false;
        int[] nArray3 = this.m_pGame.toIsoCoord(this.m_xWorldLeft, this.m_xWorldTop);
        nArray2[0] = nArray3[0];
        nArray3 = this.m_pGame.toIsoCoord(this.m_xWorldRight, this.m_xWorldBottom);
        nArray2[2] = nArray3[0];
        if (nArray2[0] <= nArray[0] && nArray2[2] < nArray[2] || nArray2[0] > nArray[0] && nArray2[2] >= nArray[2]) {
            if (nArray2[0] <= nArray[0]) {
                n = nArray[0] - nArray2[0];
                n += 4096;
            } else {
                n = nArray[2] - nArray2[2];
                n -= 4096;
            }
            nArray3 = this.m_pGame.toWorldCoord(n, 0);
            n = nArray3[0];
        }
        this.setWorldLocation(this.m_xWorldX + n, this.m_xWorldY, this.m_xWorldZ);
        if (this.m_iLogicalState == 28 || this.m_iLogicalState == 7 || this.m_iLogicalState == 26 || this.m_iLogicalState == 4) {
            this.m_bIsoXCollision = true;
            this.m_bIsoYCollision = false;
        } else {
            this.m_bIsoYCollision = true;
            this.m_bIsoXCollision = false;
        }
    }

    protected final void setLogicalState(int n) {
        int n2 = DeviceInfo.k_iDogStateMap[n][0];
        boolean bl = DeviceInfo.k_iDogStateMap[n][1] != 0;
        int n3 = DeviceInfo.k_iDogStateMap[this.m_iState][5];
        int n4 = DeviceInfo.k_iDogStateMap[n][5];
        int n5 = n;
        if (n3 != n4) {
            n5 = DeviceInfo.k_iLogicalBaseStateMap[n4][n3];
            if (n5 == -1 || n5 == n || n5 == this.m_iState) {
                n2 = DeviceInfo.k_iDogStateMap[n][0];
                n5 = n;
                this.m_iTargetState = -1;
            } else {
                n2 = DeviceInfo.k_iDogStateMap[n5][0];
                this.m_iTargetState = n;
            }
        } else {
            this.m_iTargetState = -1;
        }
        if (this.m_iState != n2 || this.m_bMirrored != bl) {
            this.m_bPlayForward = !(n5 == 30 && n2 == 22 || n5 == 31 && n2 == 23);
            this.setState(n2, -1, bl);
            if (this.m_iTargetState == -1 && this.m_iAction == 12 && this.m_iAbilityLevel >= 409600) {
                this.m_iInterruptDelay = this.getStateDuration();
                if (n2 == 18) {
                    this.m_iInterruptDelay <<= 1;
                    if (this.m_bPlayDead) {
                        this.m_iInterruptDelay += 2000;
                    }
                }
                if (this.m_iInterruptDelay < 1000) {
                    this.m_iInterruptDelay *= 1000 / this.m_iInterruptDelay + 1;
                }
            }
        }
        this.m_iLogicalState = n5;
    }
}

