/*
 * Decompiled with CFR 0.152.
 */
package sims_pets;

public class ArrayList {
    public Object[] elementData;
    public int elementCount;
    protected int capacityIncrement;
    public static final int kDefaultInitialCapacity = 10;

    public ArrayList(int n, int n2) {
        if (n >= 0) {
            this.elementData = new Object[n];
            this.capacityIncrement = n2;
            return;
        }
    }

    public ArrayList(int n) {
        this(n, 0);
    }

    public ArrayList() {
        this(10, 0);
    }

    public void copyInto(Object[] objectArray) {
        int n = this.elementCount;
        while (n-- > 0) {
            objectArray[n] = this.elementData[n];
        }
    }

    public void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            Object[] objectArray = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public void ensureCapacity(int n) {
        if (n > this.elementData.length) {
            this.ensureCapacityHelper(n);
        }
    }

    private void ensureCapacityHelper(int n) {
        int n2;
        int n3 = this.elementData.length;
        Object[] objectArray = this.elementData;
        int n4 = n2 = this.capacityIncrement <= 0 ? n3 * 2 : n3 + this.capacityIncrement;
        if (n2 < n) {
            n2 = n;
        }
        this.elementData = new Object[n2];
        System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
    }

    public void setSize(int n) {
        if (n > this.elementCount && n > this.elementData.length) {
            this.ensureCapacityHelper(n);
        } else {
            for (int i = n; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
        }
        this.elementCount = n;
    }

    public boolean contains(Object object) {
        return this.indexOf(object, 0) >= 0;
    }

    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public int indexOf(Object object, int n) {
        if (object == null) {
            for (int i = n; i < this.elementCount; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i < this.elementCount; ++i) {
                if (!object.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    public int lastIndexOf(Object object, int n) {
        if (n >= this.elementCount) {
            throw new IndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (object == null) {
            for (int i = n; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i >= 0; --i) {
                if (!object.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object lastElement() {
        if (this.elementCount == 0) {
            return null;
        }
        return this.elementData[this.elementCount - 1];
    }

    public void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public void insertElementAt(Object object, int n) {
        int n2 = this.elementCount + 1;
        if (n >= n2) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        if (n2 > this.elementData.length) {
            this.ensureCapacityHelper(n2);
        }
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        this.elementData[n] = object;
        ++this.elementCount;
    }

    public void addElement(Object object) {
        int n = this.elementCount + 1;
        if (n > this.elementData.length) {
            this.ensureCapacityHelper(n);
        }
        this.elementData[this.elementCount++] = object;
    }

    public boolean removeElement(Object object) {
        int n = this.indexOf(object, 0);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }
}

