/*
 * Decompiled with CFR 0.152.
 */
package sims_pets;

import javax.microedition.lcdui.Graphics;
import sims_pets.AnimObject;
import sims_pets.ArrayList;
import sims_pets.DeviceInfo;
import sims_pets.Dog;
import sims_pets.GameApp;
import sims_pets.Interactive;
import sims_pets.PetsApp;
import sims_pets.Scene;
import sims_pets.TileMap;
import sims_pets.Toy;

public class PetsGame
extends Scene {
    public static final int kMapCodeTopLeft = 1;
    public static final int kMapCodeBottomRight = 2;
    public static final int kMapCodeBed = 3;
    public static final int kMapCodeFoodBowl = 4;
    public static final int kMapCodeWaterBowl = 5;
    public static final int kMapCodeSofa = 6;
    public static final int kMapCodePetStartPos = 7;
    public static final int kMapCodeBall = 8;
    public static final int kMapCodeDisc = 9;
    public static final int kMapCodeTree_1 = 10;
    public static final int kMapCodeTree_2 = 11;
    public static final int kMapCodeFlower_1 = 12;
    public static final int kMapCodeFlower_2 = 13;
    public static final int kMapCodeFlower_3 = 14;
    public static final int kMapCodeBush_1 = 15;
    public static final int kMapCodeBush_2 = 16;
    public static final int kMapCodeBush_3 = 17;
    public static final int kMapCodeBush_4 = 18;
    public static final int kMapCodeClump_1 = 19;
    public static final int kMapCodeClump_2 = 20;
    public static final int kMapCodeRug = 22;
    public static final int kMapCodeMirror = 23;
    public static final int kMapCodePlant = 24;
    public static final int kMapCodeWindow = 25;
    public static final int kMapCodeFood = 26;
    public static final int kMapCodeNewsPaper = 27;
    public static final int kMapCodeWanderTopLeft = 101;
    public static final int kMapCodeWanderBottomRight = 102;
    public static final int kMapCodeThrowDirection = 110;
    public static final int kMapCodeInteractTopLeft = 201;
    public static final int kMapCodeInteractBottomRight = 202;
    public static final int kParkObjectFootball = 0;
    public static final int kParkObjectTennisBall = 1;
    public static final int kParkObjectBow = 2;
    public static final int kParkObjectSunglasses = 3;
    public static final int kNumParkObjects = 4;
    public static final int kCollisionPets = 1;
    public static final int kCollisionToys = 2;
    public static final int kiSleepTime = 5000;
    public static final int kxWanderInterestIncRate = 4096;
    public static final int kxWanderInterestDecRate = 12288;
    public static final int kxOwnerActiveInterestRate = -6144;
    public static final int kxOwnerInactiveInterestRate = 0;
    public static final int kxWanderInterestMax = 307200;
    public static final int kxWanderInterestMin = 2048;
    public static final int kInteractRemove = 1000;
    public static final int kInteractBallThrow = 1100;
    public static final int kInteractBedSleep = 1200;
    public static final int kInteractBowlFill_Kibble = 1300;
    public static final int kInteractBowlFill_Chow = 1400;
    public static final int kInteractBowlFill_CannedFood = 1500;
    public static final int kInteractBowlFill_FancyFood = 1600;
    public static final int kInteractBowlFill_ChickenTreat = 1700;
    public static final int kInteractBowlFill_LiverTreat = 1800;
    public static final int kInteractPottySolid = 1900;
    public static final int kInteractPottyLiquid = 2000;
    public static final int kInteractDiscThrow = 2100;
    public static final int kInteractBrushPet = 2200;
    public static final int kInteractWashPet = 2300;
    public static final int kInteractChewBone = 2400;
    public static final int kInteractSqueakyToy = 2500;
    public static final int kInteractFoundObject = 2600;
    public static final int kFunAdjustPraise = 81920;
    public static final int kFunAdjustPetScold = -81920;
    public static final int kHungerAdjustPetTreat = 40960;
    public static final int kPetInstanceID = 99311;
    protected int m_xThrowDirection_X;
    protected int m_xThrowDirection_Y;
    protected int[] m_xboxIsoSceneBounds = new int[6];
    protected int[] m_xboxWanderBounds = new int[6];
    protected int[] m_xboxInteractBounds = new int[6];
    protected TileMap m_pTileMap;
    protected int m_iTilesPerColumn;
    protected int m_iTilesPerRow;
    protected int m_iTileMapRowCounter;
    protected int[][] m_xIsoViewMatrix = new int[4][4];
    protected int[][] m_xInvIsoViewMatrix = new int[4][4];
    protected int[] m_xptTrans = new int[4];
    protected int[] m_xboxSceneBounds = new int[6];
    protected boolean m_bKeepCameraNear;
    protected boolean m_bNewCurrentObject;
    protected Interactive m_pCurrentObject;
    protected Dog m_pDog;
    protected int m_xDefaultDiscX;
    protected int m_xDefaultDiscY;
    protected int m_xDefaultDiscZ;
    protected int m_xDefaultBallX;
    protected int m_xDefaultBallY;
    protected int m_xDefaultBallZ;
    protected boolean m_bSnapCamera = true;
    protected int m_iFoodType = -1;
    protected ArrayList m_pListInteractive;
    protected ArrayList m_pListCollision;
    protected ArrayList m_pListToy;
    protected AnimObject m_pWashtubFront;
    protected AnimObject m_pWashtubBack;
    protected AnimObject m_pFood;
    protected ArrayList m_pListSoapBubblePool;
    protected ArrayList m_pListSoapBubblesInUse;

    public final int getThrowDirection_X() {
        return this.m_xThrowDirection_X;
    }

    public final int getThrowDirection_Y() {
        return this.m_xThrowDirection_Y;
    }

    public final int[] getWanderBounds() {
        return this.m_xboxWanderBounds;
    }

    protected final void setupIsometric() {
        int n;
        int n2;
        int n3;
        int n4 = 2896;
        int n5 = -2896;
        int[][] nArrayArray = new int[][]{{n4, n5, 0, 0}, {-n5, n4, 0, 0}, {0, 0, 4096, 0}, {0, 0, 0, 4096}};
        int[][] nArrayArray2 = new int[][]{{4096, 0, 0, 0}, {0, 1024, 0, 0}, {0, 0, 4096, 0}, {0, 0, 0, 4096}};
        for (n3 = 0; n3 < 4; ++n3) {
            for (n2 = 0; n2 < 4; ++n2) {
                this.m_xIsoViewMatrix[n2][n3] = 0;
                for (n = 0; n < 4; ++n) {
                    int[] nArray = this.m_xIsoViewMatrix[n2];
                    int n6 = n3;
                    nArray[n6] = nArray[n6] + GameApp.mul(nArrayArray2[n][n3], nArrayArray[n2][n]);
                }
            }
        }
        int[] nArray = new int[12];
        int[] nArray2 = new int[16];
        int[] nArray3 = new int[16];
        for (n2 = 0; n2 < 4; ++n2) {
            for (n3 = 0; n3 < 4; ++n3) {
                nArray2[n2 * 4 + n3] = this.m_xIsoViewMatrix[n2][n3];
            }
        }
        nArray[0] = GameApp.mul(nArray2[10], nArray2[15]);
        nArray[1] = GameApp.mul(nArray2[11], nArray2[14]);
        nArray[2] = GameApp.mul(nArray2[9], nArray2[15]);
        nArray[3] = GameApp.mul(nArray2[11], nArray2[13]);
        nArray[4] = GameApp.mul(nArray2[9], nArray2[14]);
        nArray[5] = GameApp.mul(nArray2[10], nArray2[13]);
        nArray[6] = GameApp.mul(nArray2[8], nArray2[15]);
        nArray[7] = GameApp.mul(nArray2[11], nArray2[12]);
        nArray[8] = GameApp.mul(nArray2[8], nArray2[14]);
        nArray[9] = GameApp.mul(nArray2[10], nArray2[12]);
        nArray[10] = GameApp.mul(nArray2[8], nArray2[13]);
        nArray[11] = GameApp.mul(nArray2[9], nArray2[12]);
        nArray3[0] = GameApp.mul(nArray[0], nArray2[5]) + GameApp.mul(nArray[3], nArray2[6]) + GameApp.mul(nArray[4], nArray2[7]);
        nArray3[0] = nArray3[0] - (GameApp.mul(nArray[1], nArray2[5]) + GameApp.mul(nArray[2], nArray2[6]) + GameApp.mul(nArray[5], nArray2[7]));
        nArray3[1] = GameApp.mul(nArray[1], nArray2[4]) + GameApp.mul(nArray[6], nArray2[6]) + GameApp.mul(nArray[9], nArray2[7]);
        nArray3[1] = nArray3[1] - (GameApp.mul(nArray[0], nArray2[4]) + GameApp.mul(nArray[7], nArray2[6]) + GameApp.mul(nArray[8], nArray2[7]));
        nArray3[2] = GameApp.mul(nArray[2], nArray2[4]) + GameApp.mul(nArray[7], nArray2[5]) + GameApp.mul(nArray[10], nArray2[7]);
        nArray3[2] = nArray3[2] - (GameApp.mul(nArray[3], nArray2[4]) + GameApp.mul(nArray[6], nArray2[5]) + GameApp.mul(nArray[11], nArray2[7]));
        nArray3[3] = GameApp.mul(nArray[5], nArray2[4]) + GameApp.mul(nArray[8], nArray2[5]) + GameApp.mul(nArray[11], nArray2[6]);
        nArray3[3] = nArray3[3] - (GameApp.mul(nArray[4], nArray2[4]) + GameApp.mul(nArray[9], nArray2[5]) + GameApp.mul(nArray[10], nArray2[6]));
        nArray3[4] = GameApp.mul(nArray[1], nArray2[1]) + GameApp.mul(nArray[2], nArray2[2]) + GameApp.mul(nArray[5], nArray2[3]);
        nArray3[4] = nArray3[4] - (GameApp.mul(nArray[0], nArray2[1]) + GameApp.mul(nArray[3], nArray2[2]) + GameApp.mul(nArray[4], nArray2[3]));
        nArray3[5] = GameApp.mul(nArray[0], nArray2[0]) + GameApp.mul(nArray[7], nArray2[2]) + GameApp.mul(nArray[8], nArray2[3]);
        nArray3[5] = nArray3[5] - (GameApp.mul(nArray[1], nArray2[0]) + GameApp.mul(nArray[6], nArray2[2]) + GameApp.mul(nArray[9], nArray2[3]));
        nArray3[6] = GameApp.mul(nArray[3], nArray2[0]) + GameApp.mul(nArray[6], nArray2[1]) + GameApp.mul(nArray[11], nArray2[3]);
        nArray3[6] = nArray3[6] - (GameApp.mul(nArray[2], nArray2[0]) + GameApp.mul(nArray[7], nArray2[1]) + GameApp.mul(nArray[10], nArray2[3]));
        nArray3[7] = GameApp.mul(nArray[4], nArray2[0]) + GameApp.mul(nArray[9], nArray2[1]) + GameApp.mul(nArray[10], nArray2[2]);
        nArray3[7] = nArray3[7] - (GameApp.mul(nArray[5], nArray2[0]) + GameApp.mul(nArray[8], nArray2[1]) + GameApp.mul(nArray[11], nArray2[2]));
        nArray[0] = GameApp.mul(nArray2[2], nArray2[7]);
        nArray[1] = GameApp.mul(nArray2[3], nArray2[6]);
        nArray[2] = GameApp.mul(nArray2[1], nArray2[7]);
        nArray[3] = GameApp.mul(nArray2[3], nArray2[5]);
        nArray[4] = GameApp.mul(nArray2[1], nArray2[6]);
        nArray[5] = GameApp.mul(nArray2[2], nArray2[5]);
        nArray[6] = GameApp.mul(nArray2[0], nArray2[7]);
        nArray[7] = GameApp.mul(nArray2[3], nArray2[4]);
        nArray[8] = GameApp.mul(nArray2[0], nArray2[6]);
        nArray[9] = GameApp.mul(nArray2[2], nArray2[4]);
        nArray[10] = GameApp.mul(nArray2[0], nArray2[5]);
        nArray[11] = GameApp.mul(nArray2[1], nArray2[4]);
        nArray3[8] = GameApp.mul(nArray[0], nArray2[13]) + GameApp.mul(nArray[3], nArray2[14]) + GameApp.mul(nArray[4], nArray2[15]);
        nArray3[8] = nArray3[8] - (GameApp.mul(nArray[1], nArray2[13]) + GameApp.mul(nArray[2], nArray2[14]) + GameApp.mul(nArray[5], nArray2[15]));
        nArray3[9] = GameApp.mul(nArray[1], nArray2[12]) + GameApp.mul(nArray[6], nArray2[14]) + GameApp.mul(nArray[9], nArray2[15]);
        nArray3[9] = nArray3[9] - (GameApp.mul(nArray[0], nArray2[12]) + GameApp.mul(nArray[7], nArray2[14]) + GameApp.mul(nArray[8], nArray2[15]));
        nArray3[10] = GameApp.mul(nArray[2], nArray2[12]) + GameApp.mul(nArray[7], nArray2[13]) + GameApp.mul(nArray[10], nArray2[15]);
        nArray3[10] = nArray3[10] - (GameApp.mul(nArray[3], nArray2[12]) + GameApp.mul(nArray[6], nArray2[13]) + GameApp.mul(nArray[11], nArray2[15]));
        nArray3[11] = GameApp.mul(nArray[5], nArray2[12]) + GameApp.mul(nArray[8], nArray2[13]) + GameApp.mul(nArray[11], nArray2[14]);
        nArray3[11] = nArray3[11] - (GameApp.mul(nArray[4], nArray2[12]) + GameApp.mul(nArray[9], nArray2[13]) + GameApp.mul(nArray[10], nArray2[14]));
        nArray3[12] = GameApp.mul(nArray[2], nArray2[10]) + GameApp.mul(nArray[5], nArray2[11]) + GameApp.mul(nArray[1], nArray2[9]);
        nArray3[12] = nArray3[12] - (GameApp.mul(nArray[4], nArray2[11]) + GameApp.mul(nArray[0], nArray2[9]) + GameApp.mul(nArray[3], nArray2[10]));
        nArray3[13] = GameApp.mul(nArray[8], nArray2[11]) + GameApp.mul(nArray[0], nArray2[8]) + GameApp.mul(nArray[7], nArray2[10]);
        nArray3[13] = nArray3[13] - (GameApp.mul(nArray[6], nArray2[10]) + GameApp.mul(nArray[9], nArray2[11]) + GameApp.mul(nArray[1], nArray2[8]));
        nArray3[14] = GameApp.mul(nArray[6], nArray2[9]) + GameApp.mul(nArray[11], nArray2[11]) + GameApp.mul(nArray[3], nArray2[8]);
        nArray3[14] = nArray3[14] - (GameApp.mul(nArray[10], nArray2[11]) + GameApp.mul(nArray[2], nArray2[8]) + GameApp.mul(nArray[7], nArray2[9]));
        nArray3[15] = GameApp.mul(nArray[10], nArray2[10]) + GameApp.mul(nArray[4], nArray2[8]) + GameApp.mul(nArray[9], nArray2[9]);
        nArray3[15] = nArray3[15] - (GameApp.mul(nArray[8], nArray2[9]) + GameApp.mul(nArray[11], nArray2[10]) + GameApp.mul(nArray[5], nArray2[8]));
        int n7 = GameApp.mul(nArray2[0], nArray3[0]) + GameApp.mul(nArray2[1], nArray3[1]) + GameApp.mul(nArray2[2], nArray3[2]) + GameApp.mul(nArray2[3], nArray3[3]);
        if (n7 != 0) {
            n7 = GameApp.div(4096, n7);
            for (n = 0; n < 16; ++n) {
                nArray3[n] = GameApp.mul(nArray3[n], n7);
            }
            for (n2 = 0; n2 < 4; ++n2) {
                for (n3 = 0; n3 < 4; ++n3) {
                    this.m_xInvIsoViewMatrix[n2][n3] = nArray3[n2 + n3 * 4];
                }
            }
        }
    }

    public final int[] toIsoCoord(int n, int n2) {
        this.m_xptTrans[0] = (int)((long)this.m_xIsoViewMatrix[0][0] * (long)n + (long)this.m_xIsoViewMatrix[1][0] * (long)n2 >> 12);
        this.m_xptTrans[1] = (int)((long)this.m_xIsoViewMatrix[0][1] * (long)n + (long)this.m_xIsoViewMatrix[1][1] * (long)n2 >> 12);
        return this.m_xptTrans;
    }

    public final int[] toWorldCoord(int n, int n2) {
        this.m_xptTrans[0] = (int)((long)this.m_xInvIsoViewMatrix[0][0] * (long)n + (long)this.m_xInvIsoViewMatrix[1][0] * (long)n2 >> 12);
        this.m_xptTrans[1] = (int)((long)this.m_xInvIsoViewMatrix[0][1] * (long)n + (long)this.m_xInvIsoViewMatrix[1][1] * (long)n2 >> 12);
        return this.m_xptTrans;
    }

    public final void setWorldBGVisible(boolean bl) {
        if (this.m_pTileMap != null) {
            this.m_pTileMap.m_bVisible = bl;
        }
    }

    public final void snapCamera() {
        this.m_bSnapCamera = true;
        this.updateCamera(0);
    }

    public void randomWander(Interactive interactive) {
        int n = GameApp.nextInt();
        int n2 = 409600;
        int n3 = 102400;
        int n4 = n2 + (n % (n3 >> 12) << 12);
        if (((n >>= 12) & 1) != 0) {
            n4 = -n4;
        }
        int n5 = n2 + ((n >>= 1) % (n3 >> 12) << 12);
        if (((n >>= 12) & 1) != 0) {
            n5 = -n5;
        }
        n5 += interactive.m_xWorldY;
        if ((n4 += interactive.m_xWorldX) < this.m_xboxWanderBounds[0]) {
            n4 = this.m_xboxWanderBounds[0];
        }
        if (n4 > this.m_xboxWanderBounds[2]) {
            n4 = this.m_xboxWanderBounds[2];
        }
        if (n5 > this.m_xboxWanderBounds[3]) {
            n5 = this.m_xboxWanderBounds[3];
        }
        if (n5 < this.m_xboxWanderBounds[1]) {
            n5 = this.m_xboxWanderBounds[1];
        }
        interactive.setWorldLocation(n4, n5, interactive.m_xWorldZ);
    }

    public boolean isInInteractionArea(Interactive interactive) {
        if (interactive == null) {
            return false;
        }
        return this.m_xboxInteractBounds[0] < interactive.m_xWorldRight && this.m_xboxInteractBounds[2] > interactive.m_xWorldLeft && this.m_xboxInteractBounds[1] < interactive.m_xWorldBottom && this.m_xboxInteractBounds[3] > interactive.m_xWorldTop;
    }

    public boolean isInCatchDiscArea(Interactive interactive) {
        if (interactive == null) {
            return false;
        }
        return this.m_xboxWanderBounds[0] < interactive.m_xWorldX && this.m_xboxWanderBounds[2] > interactive.m_xWorldX && this.m_xboxWanderBounds[1] < interactive.m_xWorldY && this.m_xboxWanderBounds[3] > interactive.m_xWorldY;
    }

    private final void createSoapBubble() {
        AnimObject animObject = new AnimObject();
        if (animObject != null) {
            animObject.onLoadResource(60);
            this.addObject(animObject);
            animObject.m_bVisible = false;
            this.m_pListSoapBubblePool.addElement(animObject);
        }
    }

    protected final void updateSoapBubbles(int n) {
        if (this.m_pListSoapBubblePool != null && this.m_pListSoapBubblesInUse != null) {
            int n2 = this.m_pListSoapBubblePool.elementCount;
            int n3 = this.m_pListSoapBubblesInUse.elementCount;
            if (n2 + n3 < 16 && n2 + n3 < 20) {
                this.createSoapBubble();
            }
            if (n3 > 0) {
                int n4 = 61440 * n >> 10;
                int n5 = n3;
                while (--n5 >= 0) {
                    AnimObject animObject = (AnimObject)this.m_pListSoapBubblesInUse.elementData[n5];
                    if (animObject != null) {
                        int n6 = animObject.m_iUserData;
                        if ((n6 -= n) > 0) {
                            animObject.m_iUserData = n6;
                            animObject.setLocation(animObject.m_iX, animObject.m_iY - n4);
                            animObject.setZ(animObject.m_iZ + n4);
                            continue;
                        }
                        this.m_pListSoapBubblesInUse.removeElementAt(n5);
                        animObject.m_bVisible = false;
                        this.m_pListSoapBubblePool.addElement(animObject);
                        continue;
                    }
                    this.m_pListSoapBubblesInUse.removeElementAt(n5);
                }
            }
        }
    }

    public final void startSoapBubble(int n, int n2) {
        if (this.m_pListSoapBubblePool != null && this.m_pListSoapBubblesInUse != null) {
            int n3 = this.m_pListSoapBubblePool.elementCount;
            int n4 = this.m_pListSoapBubblesInUse.elementCount;
            if (n3 < 1 && n3 + n4 < 20) {
                this.createSoapBubble();
            }
            if ((n3 = this.m_pListSoapBubblePool.elementCount) > 0) {
                AnimObject animObject = (AnimObject)this.m_pListSoapBubblePool.elementData[--n3];
                this.m_pListSoapBubblePool.removeElementAt(n3);
                animObject.m_iUserData = 3000;
                animObject.setLocation(n, n2);
                animObject.setZ(0x7D0000 - n2);
                animObject.m_bVisible = true;
                this.m_pListSoapBubblesInUse.addElement(animObject);
            }
        }
    }

    public final void stopTLC(int n) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        switch (this.m_pDog.m_iTLCMode) {
            case 1: {
                n2 = 307200;
                n3 = 2;
                break;
            }
            case 2: {
                n2 = 81920;
                n3 = 4;
                n4 = 131074;
                break;
            }
            case 3: {
                n2 = 327680;
                n3 = 4;
                n4 = 131076;
                if (this.m_pWashtubFront != null) {
                    this.m_pWashtubFront.m_bVisible = false;
                }
                if (this.m_pWashtubBack == null) break;
                this.m_pWashtubBack.m_bVisible = false;
                break;
            }
        }
        if (n > 0) {
            if (n3 > -1) {
                n2 = GameApp.mul(n2, n * 1024);
                this.m_pDog.adjustNeed(n3, n2);
            }
            if (n <= 2) {
                this.m_pDog.setDisplayFeedback(n3, 2);
            } else if (n3 == 4 && n2 <= 81920) {
                this.m_pDog.setDisplayFeedback(n3, 2);
            } else {
                this.m_pDog.setDisplayFeedback(n3, 3);
            }
            if (n == 4 && n4 > -1) {
                petsApp.completeMetaGoal(n4);
            }
        }
        this.m_pDog.m_iTLCMode = 0;
        if (this.m_pDog.m_iAction != 9) {
            this.m_pDog.setAction(9);
        }
        this.m_pDog.dismiss();
    }

    public final void startThrow(Toy toy, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        int n7 = -40140;
        if (toy != null) {
            if (toy.m_iType == 0) {
                toy.setVelocity(n, n2, n3 >> 2, GameApp.abs(GameApp.mul(32768, n4)));
                n7 >>= 3;
            } else {
                toy.setVelocity(n, n2, n3, GameApp.abs(GameApp.mul(86016, n4)));
                if (toy.m_xVelocity[0] < 0) {
                    n5 = 2048;
                } else if (toy.m_xVelocity[0] > 0) {
                    n5 = -2048;
                }
                if (toy.m_xVelocity[1] < 0) {
                    n6 = 2048;
                } else if (toy.m_xVelocity[1] > 0) {
                    n6 = -2048;
                }
            }
            toy.setCurrentAI(1);
            toy.setAccel(n5, n6, n7);
        }
    }

    public final void reset() {
        if (this.m_pCurrentObject == this.getItem(3)) {
            this.m_pCurrentObject.setCurrentAI(0);
            this.m_pCurrentObject.setWorldZ(0);
        }
        this.m_pCurrentObject.stopMovement();
    }

    private final void updateSelected() {
        if (!this.m_bNewCurrentObject) {
            this.m_bNewCurrentObject = true;
        }
    }

    public final void addCollisionObject(Interactive interactive) {
        if (interactive != null && this.m_pListCollision.indexOf(interactive) == -1) {
            this.m_pListCollision.addElement(interactive);
        }
    }

    public final void addInteractive(Interactive interactive) {
        if (this.m_pListInteractive != null && interactive != null && this.m_pListInteractive.indexOf(interactive) < 0) {
            this.m_pListInteractive.addElement(interactive);
        }
    }

    public final void addItem(Toy toy) {
        if (this.m_pListToy != null && toy != null && this.m_pListToy.indexOf(toy) < 0) {
            this.m_pListToy.addElement(toy);
        }
    }

    public final void removeRemovableObject() {
        Interactive interactive = null;
        if (this.m_pListInteractive != null && this.m_pListCollision != null) {
            for (int i = 0; i < this.m_pListInteractive.elementCount; ++i) {
                interactive = (Interactive)this.m_pListInteractive.elementData[i];
                if (interactive == null || !interactive.m_bVisible || !interactive.m_bRemovable) continue;
                if (this.m_pDog != null) {
                    if (interactive == this.m_pDog.m_pInterest) {
                        this.m_pDog.interrupt(1, 0, null);
                    }
                    if (interactive == this.m_pDog.m_pCarry) {
                        this.m_pDog.m_pCarry.m_bVisible = false;
                        this.m_pDog.dismiss();
                    }
                }
                interactive.m_bVisible = false;
                this.m_pListInteractive.removeElementAt(i);
                this.m_pListCollision.removeElement(interactive);
                --i;
            }
            if (this.m_pFood != null) {
                this.m_pFood.m_bVisible = false;
            }
            this.m_pCurrentObject = null;
            this.nextInteractive();
        }
        this.m_pDog.setAction(9);
    }

    public final void removeSelectedObject() {
        Interactive interactive = null;
        if (this.m_pListInteractive != null && this.m_pListCollision != null) {
            for (int i = 0; i < this.m_pListInteractive.elementCount; ++i) {
                interactive = (Interactive)this.m_pListInteractive.elementData[i];
                if (interactive == null || !interactive.m_bVisible || interactive != this.m_pCurrentObject) continue;
                interactive.m_bVisible = false;
                this.m_pListInteractive.removeElementAt(i);
                this.m_pListCollision.removeElement(interactive);
                --i;
            }
            this.m_pCurrentObject = null;
            this.nextInteractive();
        }
    }

    public final Interactive getInteractive(int n) {
        if (this.m_pListInteractive != null && n < this.m_pListInteractive.elementCount) {
            return (Interactive)this.m_pListInteractive.elementData[n];
        }
        return null;
    }

    public final boolean prevInteractive() {
        if (this.m_pListInteractive != null && this.m_pListInteractive.elementCount > 0) {
            Interactive interactive = null;
            int n = -1;
            if (this.m_pCurrentObject != null) {
                n = this.m_pListInteractive.indexOf(this.m_pCurrentObject);
            }
            do {
                if (--n >= 0) continue;
                n = this.m_pListInteractive.elementCount - 1;
            } while ((interactive = (Interactive)this.m_pListInteractive.elementData[n]) != null && (!interactive.m_bVisible || interactive.m_iInteractionCount <= 0 || interactive == this.m_pDog.m_pCarry));
            this.m_pCurrentObject = interactive;
            this.updateSelected();
            return true;
        }
        return false;
    }

    public final boolean nextInteractive() {
        if (this.m_pListInteractive != null && this.m_pListInteractive.elementCount > 0) {
            Interactive interactive = null;
            int n = -1;
            if (this.m_pCurrentObject != null) {
                n = this.m_pListInteractive.indexOf(this.m_pCurrentObject);
            }
            do {
                if (++n < this.m_pListInteractive.elementCount) continue;
                n = 0;
            } while ((interactive = (Interactive)this.m_pListInteractive.elementData[n]) != null && (!interactive.m_bVisible || interactive.m_iInteractionCount <= 0 || interactive == this.m_pDog.m_pCarry));
            this.m_pCurrentObject = interactive;
            this.updateSelected();
            return true;
        }
        return false;
    }

    public final boolean selectInteractive(Interactive interactive) {
        if (interactive != null && this.m_pListInteractive.indexOf(interactive) > -1 && interactive.m_bVisible && interactive.m_iInteractionCount > 0 && interactive != this.m_pDog.m_pCarry) {
            this.m_pCurrentObject = interactive;
            this.updateSelected();
            return true;
        }
        return false;
    }

    public final void throwObject(Interactive interactive, int n, int n2, int n3) {
        Toy toy = (Toy)interactive;
        Toy toy2 = this.getItem(2);
        if (toy2 != null) {
            if (this.m_pDog.m_pCarry == toy) {
                this.m_pDog.onDogEvent(null, 403, null, 0);
            } else {
                this.selectInteractive(interactive);
            }
            toy.setWorldLocation(toy2.m_xWorldX, toy2.m_xWorldY, toy2.m_xWorldZ + 131072);
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            n4 = n;
            n5 = n2;
            n6 = GameApp.mul(n4 -= toy2.m_xWorldX, n4) + GameApp.mul(n5 -= toy2.m_xWorldY, n5);
            if (n6 != 0) {
                n6 = GameApp.sqrt(n6);
            }
            n3 -= n3 >> 3;
            this.startThrow(toy, n4, n5, n6, n3);
            this.m_pDog.expireNeedTrainingTimer();
        }
    }

    public final Toy getItem(int n) {
        Toy toy = null;
        if (this.m_pListToy != null) {
            int n2 = this.m_pListToy.elementCount;
            while (--n2 >= 0) {
                toy = (Toy)this.m_pListToy.elementData[n2];
                if (toy == null || toy.m_iType != n) continue;
                return toy;
            }
        }
        return null;
    }

    protected final void updateCamera(int n) {
        if (this.m_pCurrentObject != null) {
            PetsApp petsApp = (PetsApp)GameApp.m_instance;
            int n2 = 36864;
            int n3 = this.m_pCurrentObject.m_iX;
            int n4 = this.m_pCurrentObject.m_iY;
            if (this.m_pCurrentObject == this.m_pDog && this.isInInteractionArea(this.m_pDog)) {
                n4 -= this.m_pCurrentObject.getFrameHeight() << 10;
            }
            n3 -= petsApp.m_iScreenWidth << 12 >> 1;
            n4 -= petsApp.m_iScreenHeight << 12 >> 1;
            if (this.m_bSnapCamera) {
                this.m_bSnapCamera = false;
            } else {
                int n5 = GameApp.abs(n3 - this.m_iX);
                int n6 = GameApp.abs(n4 - this.m_iY);
                if (n5 > n2) {
                    n3 = this.m_iX + (n3 - this.m_iX > 0 ? n2 : -n2);
                }
                if (n6 > n2) {
                    n4 = this.m_iY + (n4 - this.m_iY > 0 ? n2 : -n2);
                }
            }
            this.setLocation(n3, n4);
        }
    }

    protected final void checkCollision() {
        int n;
        Interactive interactive = null;
        Interactive interactive2 = null;
        int n2 = this.m_pListCollision.elementCount;
        for (n = 0; n < n2; ++n) {
            interactive = (Interactive)this.m_pListCollision.elementData[n];
            if (interactive == null) continue;
            if (interactive.onCheckContainment(this.m_xboxSceneBounds)) {
                interactive.onHandleContainment(this.m_xboxSceneBounds);
            }
            if (!interactive.onCheckIsoContainment(this.m_xboxIsoSceneBounds)) continue;
            interactive.onHandleIsoContainment(this.m_xboxIsoSceneBounds);
        }
        for (n = 0; n < n2; ++n) {
            interactive = (Interactive)this.m_pListCollision.elementData[n];
            if (interactive == null) continue;
            for (int i = n + 1; i < n2; ++i) {
                interactive2 = (Interactive)this.m_pListCollision.elementData[i];
                if ((interactive.m_iCollisionGroup & interactive2.m_iCollisionMask) != 0) {
                    if (!interactive2.onCheckCollision(interactive)) continue;
                    interactive2.onHandleCollision(interactive);
                    continue;
                }
                if ((interactive.m_iCollisionMask & interactive2.m_iCollisionGroup) == 0 || !interactive.onCheckCollision(interactive2)) continue;
                interactive.onHandleCollision(interactive2);
            }
        }
    }

    public final Interactive findMostInteresting() {
        Interactive interactive = null;
        Interactive interactive2 = null;
        int n = 0;
        if (this.m_pListInteractive != null && this.m_pListInteractive.elementCount > 0) {
            for (int i = 0; i < this.m_pListInteractive.elementCount; ++i) {
                int n2;
                interactive = (Interactive)this.m_pListInteractive.elementData[i];
                if (interactive == this.m_pDog || (n2 = ((Toy)interactive).getActualInterest(this.m_pDog)) <= n || n2 <= 0) continue;
                n = n2;
                interactive2 = interactive;
            }
        }
        return interactive2;
    }

    public final void checkBush() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        Toy toy = null;
        AnimObject animObject = null;
        int n = GameApp.nextInt() & Integer.MAX_VALUE;
        Toy toy2 = this.getItem(3);
        Toy toy3 = this.getItem(0);
        if (toy2 != null && toy2.m_bVisible || toy3 != null && toy3.m_bVisible) {
            return;
        }
        if ((n & 3) == 1) {
            int n2 = -1;
            n >>= 2;
            if (petsApp.isCurrentMetaGoal(196610)) {
                n2 = 0;
            } else if (petsApp.isCurrentMetaGoal(196612)) {
                n2 = 2;
            } else if (petsApp.isCurrentMetaGoal(196616)) {
                n2 = 3;
            } else {
                n2 = n % 4;
                if (!petsApp.isMetaGoalMet(196610) && n2 == 0 || !petsApp.isMetaGoalMet(196612) && n2 == 2 || !petsApp.isMetaGoalMet(196616) && n2 == 3) {
                    n2 = 1;
                }
            }
            switch (n2) {
                case 0: {
                    toy = new Toy(13, 0);
                    toy.onLoadResource(55);
                    break;
                }
                case 1: {
                    toy = new Toy(13, 0);
                    toy.onLoadResource(54);
                    break;
                }
                case 2: {
                    animObject = new AnimObject();
                    animObject.onLoadResource(61);
                    break;
                }
                case 3: {
                    animObject = new AnimObject();
                    animObject.onLoadResource(62);
                }
            }
            if (toy != null) {
                this.addObject(toy);
                this.addItem(toy);
                this.m_pDog.onDogEvent(toy, 402, null, 0);
            }
            if (animObject != null) {
                this.addObject(animObject);
                this.m_pDog.onDogEvent(animObject, 407, null, 0);
            }
            this.sortObjects();
            Toy toy4 = this.getItem(2);
            toy4.m_xInterestLevel = 409600;
            this.m_pDog.m_bFoundObject = true;
            this.m_pDog.m_iFoundObjectType = n2;
            this.m_pDog.onUserSelected();
        }
    }

    public void updateViewport(int n, int n2, int n3, int n4) {
        this.setViewPort(n, n2, n3, n4);
    }

    public final void useItem(int n) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        Toy toy = null;
        int n2 = 0;
        int n3 = 0;
        toy = this.getItem(2);
        if (toy != null) {
            n2 = toy.m_xWorldX;
            n3 = toy.m_xWorldY;
        }
        switch (n) {
            case 23: {
                toy = this.getItem(7);
                if (toy != null) {
                    if (toy.m_bVisible) {
                        toy = null;
                    } else {
                        n2 = this.m_pDog.m_xWorldX;
                        n3 = this.m_pDog.m_xWorldY;
                    }
                }
                if (petsApp.getCurrentLocation() == 1) break;
                petsApp.triggerHint(0x20000000);
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                toy = this.getItem(5);
                if (toy == null || !toy.m_bVisible) break;
                toy = null;
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                toy = this.getItem(3);
                if (toy == null) break;
                if (toy.m_bVisible) {
                    toy = null;
                    break;
                }
                petsApp.triggerHint(-2147483520);
                break;
            }
            case 16: {
                toy = this.getItem(0);
                if (toy == null) break;
                if (toy.m_bVisible) {
                    toy = null;
                    break;
                }
                petsApp.triggerHint(-2147483392);
                break;
            }
            case 17: {
                toy = this.getItem(10);
                if (toy == null || !toy.m_bVisible) break;
                toy = null;
                break;
            }
            case 10: {
                toy = this.getItem(11);
                if (toy == null || !toy.m_bVisible) break;
                toy = null;
                break;
            }
        }
        if (n != 8 && n != 9 && this.m_pFood != null) {
            this.m_pFood.m_bVisible = false;
        }
        if (toy != null) {
            this.removeRemovableObject();
            this.prevInteractive();
            toy.m_bVisible = true;
            this.reset();
            this.addInteractive(toy);
            this.addCollisionObject(toy);
            toy.setWorldLocation(n2, n3, toy.m_xWorldZ);
            if (n == 16) {
                this.selectInteractive(toy);
                if (this.isInInteractionArea(this.m_pDog) && (toy = this.getItem(1)) != null) {
                    this.m_pDog.interrupt(0, 0, toy);
                    toy.m_xInterestLevel = 409600;
                }
            } else if (n == 15) {
                this.selectInteractive(toy);
            }
        }
    }

    public final void interaction(int n) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        switch (n) {
            case 1300: {
                this.m_iFoodType = 0;
                break;
            }
            case 1400: {
                this.m_iFoodType = 1;
                break;
            }
            case 1500: {
                this.m_iFoodType = 2;
                break;
            }
            case 1600: {
                this.m_iFoodType = 3;
                break;
            }
            case 1700: {
                this.m_iFoodType = 4;
                break;
            }
            case 1800: {
                this.m_iFoodType = 5;
            }
        }
        switch (n) {
            case 1300: 
            case 1400: 
            case 1500: 
            case 1600: 
            case 1700: 
            case 1800: {
                Toy toy = this.getItem(5);
                if (toy == null) break;
                if (!toy.m_bVisible) {
                    this.useItem(8);
                }
                if (this.m_iFoodType == -1 || petsApp.getConsumable(this.m_iFoodType) <= 0) break;
                if (petsApp.checkInventory(DeviceInfo.k_iInventoryItems[9][4])) {
                    toy.setState(1, 0, true);
                } else {
                    toy.setState(0, 0, true);
                }
                petsApp.setConsumable(this.m_iFoodType, petsApp.getConsumable(this.m_iFoodType) - 1);
                this.m_pFood.m_bVisible = true;
                this.m_pFood.setLocation(toy.m_iX, toy.m_iTop);
                this.m_pFood.setZ(toy.m_iZ + 4096);
                if (this.m_pDog.m_iAction != 8) {
                    toy.m_xInterestLevel = 409600;
                    this.m_pDog.interrupt(0, 0, toy);
                }
                this.m_pDog.expireNeedTrainingTimer();
                break;
            }
            case 1200: {
                Toy toy = (Toy)this.m_pCurrentObject;
                if (toy != null) {
                    toy.m_xInterestLevel = 409600;
                }
                this.m_pDog.interrupt(0, 0, toy);
                this.m_pDog.expireNeedTrainingTimer();
                break;
            }
            case 1100: {
                Toy toy = this.getItem(3);
                break;
            }
            case 2100: {
                Toy toy = this.getItem(0);
                break;
            }
            case 2400: {
                Toy toy = this.getItem(10);
                if (toy == null) break;
                if (!toy.m_bVisible) {
                    this.useItem(17);
                }
                if (petsApp.getConsumable(6) <= 0) break;
                petsApp.setConsumable(6, petsApp.getConsumable(6) - 1);
                toy.m_xInterestLevel = 409600;
                this.m_pDog.expireNeedTrainingTimer();
                break;
            }
            case 2500: {
                Toy toy = this.getItem(11);
                if (toy == null) break;
                if (!toy.m_bVisible) {
                    this.useItem(10);
                }
                toy.m_xInterestLevel = 409600;
                this.m_pDog.expireNeedTrainingTimer();
                break;
            }
            case 1900: {
                if (this.getItem(7) == null) break;
                this.removeSelectedObject();
                break;
            }
            case 2000: {
                if (this.getItem(7) == null) break;
                this.removeSelectedObject();
                break;
            }
            case 2200: {
                Toy toy = this.getItem(2);
                toy.m_xInterestLevel = 409600;
                this.m_pDog.m_iTLCMode = 2;
                petsApp.triggerHint(-2147482624);
                petsApp.triggerHint(-2147481600);
                break;
            }
            case 2300: {
                if (petsApp.getConsumable(7) > 0) {
                    petsApp.setConsumable(7, petsApp.getConsumable(7) - 1);
                }
                Toy toy = this.getItem(2);
                toy.m_xInterestLevel = 409600;
                this.m_pDog.m_iTLCMode = 3;
                petsApp.triggerHint(-2147479552);
                petsApp.triggerHint(-2147475456);
                this.m_pDog.setAction(7);
                int n2 = this.m_pDog.m_iX;
                int n3 = this.m_pDog.m_iY;
                int n4 = this.m_pDog.m_iZ;
                if (this.m_pWashtubFront != null) {
                    this.m_pWashtubFront.setLocation(n2, n3);
                    this.m_pWashtubFront.setZ(n4 + 409600);
                    this.m_pWashtubFront.m_bVisible = true;
                }
                if (this.m_pWashtubBack == null) break;
                this.m_pWashtubBack.setLocation(n2, n3);
                this.m_pWashtubBack.setZ(n4 - 409600);
                this.m_pWashtubBack.m_bVisible = true;
                break;
            }
            case 0: {
                Toy toy = this.getItem(2);
                toy.m_xInterestLevel = 409600;
                this.m_pDog.m_iTLCMode = 1;
                petsApp.triggerHint(32);
                petsApp.triggerHint(128);
                if (this.m_pDog.m_iThought < 5) break;
                this.m_pDog.setThought(-1);
                break;
            }
            default: {
                this.m_pDog.handleInteractionAbility(n);
            }
        }
    }

    public final void setupRoom() {
        this.m_xptTrans[0] = this.m_xboxIsoSceneBounds[0] + this.m_xboxIsoSceneBounds[2] >> 1;
        this.m_xptTrans[1] = this.m_xboxIsoSceneBounds[3];
        this.toWorldCoord(this.m_xptTrans[0], this.m_xptTrans[1]);
        this.m_xboxSceneBounds[0] = this.m_xptTrans[0];
        this.m_xboxSceneBounds[3] = this.m_xptTrans[1];
        this.m_xptTrans[0] = this.m_xboxIsoSceneBounds[0] + this.m_xboxIsoSceneBounds[2] >> 1;
        this.m_xptTrans[1] = this.m_xboxIsoSceneBounds[1];
        this.toWorldCoord(this.m_xptTrans[0], this.m_xptTrans[1]);
        this.m_xboxSceneBounds[2] = this.m_xptTrans[0];
        this.m_xboxSceneBounds[1] = this.m_xptTrans[1];
        this.toWorldCoord(this.m_xboxWanderBounds[0], this.m_xboxWanderBounds[1]);
        this.m_xboxWanderBounds[0] = this.m_xptTrans[0];
        this.m_xboxWanderBounds[1] = this.m_xptTrans[1];
        this.toWorldCoord(this.m_xboxWanderBounds[2], this.m_xboxWanderBounds[3]);
        this.m_xboxWanderBounds[2] = this.m_xptTrans[0];
        this.m_xboxWanderBounds[3] = this.m_xptTrans[1];
        this.toWorldCoord(this.m_xboxInteractBounds[0], this.m_xboxInteractBounds[1]);
        this.m_xboxInteractBounds[0] = this.m_xptTrans[0];
        this.m_xboxInteractBounds[1] = this.m_xptTrans[1];
        this.toWorldCoord(this.m_xboxInteractBounds[2], this.m_xboxInteractBounds[3]);
        this.m_xboxInteractBounds[2] = this.m_xptTrans[0];
        this.m_xboxInteractBounds[3] = this.m_xptTrans[1];
        this.toWorldCoord(this.m_xThrowDirection_X, this.m_xThrowDirection_Y);
        this.m_xThrowDirection_X = this.m_xptTrans[0];
        this.m_xThrowDirection_Y = this.m_xptTrans[1];
        Toy toy = this.getItem(2);
        if (toy != null) {
            toy.setWorldLocation(this.m_xboxInteractBounds[0] + this.m_xboxInteractBounds[2] >> 1, this.m_xboxInteractBounds[3] + this.m_xboxInteractBounds[1] >> 1, 0);
        }
    }

    public final void loadMapCode(int n, int n2, int n3) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        Toy toy = null;
        AnimObject animObject = null;
        this.toWorldCoord(n2, n3);
        int n4 = this.m_xptTrans[0];
        int n5 = this.m_xptTrans[1];
        switch (n) {
            case 1: {
                this.m_xboxIsoSceneBounds[0] = n2 - 32768;
                this.m_xboxIsoSceneBounds[1] = n3 - 32768;
                break;
            }
            case 2: {
                this.m_xboxIsoSceneBounds[2] = n2 + 32768;
                this.m_xboxIsoSceneBounds[3] = n3 + 32768;
                break;
            }
            case 101: {
                this.m_xboxWanderBounds[0] = n2 - 32768;
                this.m_xboxWanderBounds[1] = n3 - 32768;
                break;
            }
            case 102: {
                this.m_xboxWanderBounds[2] = n2 + 32768;
                this.m_xboxWanderBounds[3] = n3 + 32768;
                break;
            }
            case 201: {
                this.m_xboxInteractBounds[0] = n2 - 32768;
                this.m_xboxInteractBounds[1] = n3 - 32768;
                break;
            }
            case 202: {
                this.m_xboxInteractBounds[2] = n2 + 32768;
                this.m_xboxInteractBounds[3] = n3 + 32768;
                break;
            }
            case 110: {
                this.m_xThrowDirection_X = n2 + 32768;
                this.m_xThrowDirection_Y = n3 + 32768;
                break;
            }
            case 3: {
                toy = new Toy(4, 0);
                if (toy == null) break;
                toy.onLoadResource(48);
                this.addObject(toy);
                this.addItem(toy);
                toy.setWorldLocation(n4, n5, 0);
                if (petsApp.getCurrentLocation() == 0) {
                    if (petsApp.checkInventory(DeviceInfo.k_iInventoryItems[7][4])) {
                        toy.setState(1, 0, false);
                    } else {
                        toy.setState(0, 0, false);
                    }
                    toy.m_bVisible = true;
                }
                toy.setName(44);
                toy.setSatisfierMinNeed(1, 40960);
                toy.setSatisfierInterestAdjust(1, 409600);
                toy.m_xDeactivateInterest = 0;
                toy.m_xActivateInterest = 409600;
                this.addInteractive(toy);
                this.addCollisionObject(toy);
                break;
            }
            case 4: {
                toy = new Toy(5, 0);
                if (toy == null) break;
                toy.onLoadResource(49);
                this.addObject(toy);
                this.addItem(toy);
                toy.setWorldLocation(n4, n5, 0);
                toy.m_bVisible = false;
                toy.setName(29);
                toy.m_xDeactivateInterest = 0;
                toy.m_xActivateInterest = 409600;
                toy.m_bRemovable = true;
                toy.addInteraction(1000, 220);
                break;
            }
            case 8: {
                toy = new Toy(3, 0);
                if (toy == null) break;
                toy.onLoadResource(50);
                this.addObject(toy);
                this.addItem(toy);
                toy.setWorldLocation(n4, n5, 0);
                toy.m_bVisible = false;
                toy.setName(56);
                toy.m_xDeactivateInterest = 0;
                toy.m_bRemovable = true;
                toy.addInteraction(1100, 24);
                toy.addInteraction(1000, 220);
                this.m_xDefaultBallX = toy.m_xWorldX;
                this.m_xDefaultBallY = toy.m_xWorldY;
                this.m_xDefaultBallZ = toy.m_xWorldZ;
                break;
            }
            case 9: {
                toy = new Toy(0, 0);
                if (toy == null) break;
                toy.onLoadResource(51);
                this.addObject(toy);
                this.addItem(toy);
                toy.setWorldLocation(n4, n5, 0);
                toy.m_bVisible = false;
                toy.setName(57);
                toy.m_xDeactivateInterest = 0;
                toy.m_bRemovable = true;
                toy.addInteraction(2100, 119);
                toy.addInteraction(1000, 220);
                this.m_xDefaultDiscX = toy.m_xWorldX;
                this.m_xDefaultDiscY = toy.m_xWorldY;
                this.m_xDefaultDiscZ = toy.m_xWorldZ;
                break;
            }
            case 10: 
            case 11: {
                animObject = new AnimObject();
                if (animObject == null) break;
                animObject.onLoadResource(15);
                this.addObject(animObject);
                animObject.setState(n - 10, 0, false);
                animObject.setLocation(n2, n3);
                animObject.setZ(Integer.MIN_VALUE + animObject.m_iBottom);
                animObject = null;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                animObject = new AnimObject();
                if (animObject == null) break;
                animObject.onLoadResource(14);
                this.addObject(animObject);
                animObject.setState(n - 12, 0, false);
                animObject.setLocation(n2, n3);
                animObject.setZ(Integer.MIN_VALUE + animObject.m_iBottom);
                animObject = null;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                toy = new Toy(8, 0);
                if (toy == null) break;
                toy.onLoadResource(16);
                toy.setState(n - 15, 0, false);
                this.addObject(toy);
                this.addItem(toy);
                this.addCollisionObject(toy);
                toy.setWorldLocation(n4, n5, 0);
                toy.m_xDeactivateInterest = 0;
                break;
            }
            case 19: 
            case 20: {
                animObject = new AnimObject();
                if (animObject == null) break;
                animObject.onLoadResource(17);
                this.addObject(animObject);
                animObject.setState(n - 19, 0, false);
                animObject.setLocation(n2, n3);
                animObject.setZ(Integer.MIN_VALUE + animObject.m_iBottom);
                animObject = null;
                break;
            }
            case 24: {
                toy = new Toy(9, 0);
                if (toy == null) break;
                toy.onLoadResource(20);
                this.addObject(toy);
                this.addCollisionObject(toy);
                this.addInteractive(toy);
                this.addItem(toy);
                toy.setWorldLocation(n4, n5, 0);
                toy = null;
                break;
            }
            case 26: {
                this.m_pFood = new AnimObject();
                if (this.m_pFood == null) break;
                this.m_pFood.onLoadResource(57);
                this.addObject(this.m_pFood);
                this.m_pFood.m_bVisible = false;
                break;
            }
            case 27: {
                toy = new Toy(12, 0);
                if (toy == null) break;
                toy.onLoadResource(59);
                this.addObject(toy);
                this.addCollisionObject(toy);
                this.addInteractive(toy);
                this.addItem(toy);
                toy.setWorldLocation(n4, n5, 0);
                toy = null;
                break;
            }
            case 22: {
                animObject = new AnimObject();
                if (animObject == null) break;
                animObject.onLoadResource(18);
                this.addObject(animObject);
                animObject.setLocation(n2, n3);
                animObject.setZ(Integer.MIN_VALUE + animObject.m_iBottom);
                animObject = null;
                break;
            }
            case 25: {
                animObject = new AnimObject();
                if (animObject == null) break;
                animObject.onLoadResource(19);
                this.addObject(animObject);
                animObject.setLocation(n2, n3);
                animObject.setZ(Integer.MIN_VALUE + animObject.m_iBottom);
                animObject = null;
                break;
            }
            case 7: {
                if (this.m_pDog != null) {
                    this.m_pDog.setWorldLocation(n4, n5, 0);
                }
                if ((toy = this.getItem(1)) == null) break;
                toy.setWorldLocation(n4, n5, 0);
            }
        }
    }

    public int onLoad(int n) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        Toy toy = null;
        Object var4_4 = null;
        Object var5_5 = null;
        switch (n) {
            case 0: {
                n = super.onLoad(n);
                this.m_pListCollision = new ArrayList();
                this.m_pListInteractive = new ArrayList();
                this.m_pListToy = new ArrayList();
                n = 5;
                break;
            }
            case 5: {
                this.m_pListSoapBubblePool = new ArrayList();
                this.m_pListSoapBubblesInUse = new ArrayList();
                n = 10;
                break;
            }
            case 10: {
                this.m_pTileMap = new TileMap(DeviceInfo.k_iScenes[petsApp.getCurrentLocation()][2], DeviceInfo.k_iScenes[petsApp.getCurrentLocation()][3]);
                if (this.m_pTileMap != null) {
                    this.m_pTileMap.onLoadResource(0);
                    this.m_pTileMap.setZ(Integer.MIN_VALUE);
                    this.addObject(this.m_pTileMap);
                    this.m_iWidth = this.m_pTileMap.getWidth();
                    this.m_iHeight = this.m_pTileMap.getHeight();
                }
                this.m_iTilesPerColumn = this.m_pTileMap.getTilesPerColumn();
                this.m_iTilesPerRow = this.m_pTileMap.getTilesPerRow();
                this.setupIsometric();
                n = 15;
                break;
            }
            case 15: {
                toy = new Toy(1, 0);
                if (toy != null) {
                    this.addObject(toy);
                    this.addItem(toy);
                    toy.setWorldWidth(40960);
                    toy.setWorldHeight(40960);
                    toy.m_iWidth = 4096;
                    toy.m_iHeight = 4096;
                    toy.m_xActiveInterestRate = -12288;
                    toy.m_xInactiveInterestRate = 4096;
                    toy.m_xActivateInterest = -1;
                    toy.m_xDeactivateInterest = -1;
                    toy.setMaxInterest(307200);
                    toy.setMinInterest(2048);
                    toy.m_iReactionTime = 250;
                    toy.m_iInteractDelay = 2000;
                    toy.onDeactivate();
                    this.addInteractive(toy);
                    this.addCollisionObject(toy);
                }
                n = 20;
                break;
            }
            case 20: {
                this.m_pDog = new Dog(this);
                if (this.m_pDog != null) {
                    int n2 = petsApp.getPetPartOption(0);
                    int n3 = petsApp.getPetPartOption(1);
                    this.m_pDog.setPaletteResID(DeviceInfo.k_iDogBreedParts[n2][2 + n3][0]);
                    this.m_pDog.onLoadResource(DeviceInfo.k_iDogBreedParts[n2][0][0]);
                    for (int i = 0; i < 27; ++i) {
                        this.m_pDog.setDogAbility(i, petsApp.getAbility(i));
                    }
                    this.m_pDog.m_bNoContainment = false;
                    this.addObject(this.m_pDog);
                    this.addInteractive(this.m_pDog);
                    this.addCollisionObject(this.m_pDog);
                    toy = new Toy(7, 0);
                    if (toy != null) {
                        toy.onLoadResource(52);
                        toy.m_bVisible = false;
                        toy.m_bRemovable = true;
                        this.addObject(toy);
                        this.addItem(toy);
                        this.addInteractive(toy);
                        toy.addInteraction(1900, 117);
                    }
                    if (petsApp.getPetName() != null) {
                        this.m_pDog.setName(petsApp.getPetName());
                    }
                    this.m_pDog.addInteractionAbility();
                }
                n = 25;
                break;
            }
            case 25: {
                toy = new Toy(2, 0);
                if (toy != null) {
                    this.addObject(toy);
                    this.addItem(toy);
                    toy.setWorldWidth(40960);
                    toy.setWorldHeight(40960);
                    toy.m_iWidth = 4096;
                    toy.m_iHeight = 4096;
                    this.addInteractive(toy);
                    toy.m_xDeactivateInterest = 0;
                    this.addCollisionObject(toy);
                }
                n = 30;
                break;
            }
            case 90: {
                this.setupRoom();
                n = 92;
                break;
            }
            case 92: {
                if (petsApp.getCurrentLocation() == 0) {
                    toy = new Toy(10, 0);
                    if (toy != null) {
                        toy.onLoadResource(56);
                        this.addObject(toy);
                        this.addCollisionObject(toy);
                        this.addInteractive(toy);
                        this.addItem(toy);
                        toy.m_xDeactivateInterest = 0;
                        toy.m_bVisible = false;
                        toy.m_bRemovable = true;
                        toy = null;
                    }
                    if ((toy = new Toy(11, 0)) != null) {
                        toy.onLoadResource(58);
                        this.addObject(toy);
                        this.addCollisionObject(toy);
                        this.addInteractive(toy);
                        this.addItem(toy);
                        toy.m_xDeactivateInterest = 0;
                        toy.m_bVisible = false;
                        toy.m_bRemovable = true;
                        toy = null;
                    }
                }
                n = 95;
                break;
            }
            case 95: {
                this.nextInteractive();
                this.m_pWashtubFront = new AnimObject();
                if (this.m_pWashtubFront != null) {
                    this.m_pWashtubFront.onLoadResource(53);
                    this.addObject(this.m_pWashtubFront);
                    this.m_pWashtubFront.setState(0, 0, false);
                    this.m_pWashtubFront.m_bVisible = false;
                }
                this.m_pWashtubBack = new AnimObject();
                if (this.m_pWashtubBack != null) {
                    this.m_pWashtubBack.onLoadResource(53);
                    this.addObject(this.m_pWashtubBack);
                    this.m_pWashtubBack.setState(1, 0, false);
                    this.m_pWashtubBack.m_bVisible = false;
                }
                n = 96;
                break;
            }
            default: {
                if (30 <= n && n < 90) {
                    if (this.m_iTileMapRowCounter >= this.m_iTilesPerColumn) {
                        n = 90;
                        break;
                    }
                    if (30 > n || n >= 90) break;
                    int n4 = 0;
                    for (int i = 0; i < this.m_iTilesPerRow; ++i) {
                        n4 = this.m_pTileMap.getMapCodeByPosition(i, this.m_iTileMapRowCounter);
                        if (n4 <= 0) continue;
                        this.loadMapCode(n4, this.m_pTileMap.getXPixelPosition(i, this.m_iTileMapRowCounter) << 12, this.m_pTileMap.getYPixelPosition(i, this.m_iTileMapRowCounter) << 12);
                    }
                    ++this.m_iTileMapRowCounter;
                    if (this.m_iTileMapRowCounter >= this.m_iTilesPerColumn) break;
                    n = 30 + this.m_iTileMapRowCounter * 60 / this.m_iTilesPerColumn;
                    break;
                }
                if (n < 96) break;
                ++n;
            }
        }
        return n;
    }

    public void onIdle(int n) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        this.updateSoapBubbles(n);
        super.onIdle(n);
        this.updateCamera(n);
        this.sortObjects();
        this.checkCollision();
        if (this.m_pDog.m_pCarry == this.getItem(3) && this.m_pDog.m_pCarry != null && this.m_pCurrentObject != this.m_pDog) {
            this.m_pCurrentObject = this.m_pDog;
        }
    }

    public int onClose() {
        int n;
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        petsApp.setTargetBladder(this.m_pDog.m_pxTargetNeeds[0]);
        petsApp.setCatchLevel(this.m_pDog.getCatchLevel());
        for (n = 0; n < 5; ++n) {
            petsApp.setMotive(n, this.m_pDog.m_pxNeeds[n]);
        }
        for (n = 0; n < 27; ++n) {
            petsApp.setAbility(n, this.m_pDog.m_pxAbilities[n]);
        }
        return super.onClose();
    }

    public int onOpen() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int[] nArray = this.getViewPortRect();
        this.setViewPort(nArray[0], nArray[1], nArray[2], nArray[3]);
        petsApp.triggerHint(-2147467264);
        petsApp.triggerHint(-2147450880);
        petsApp.triggerHint(-2147418112);
        petsApp.triggerHint(-2147352576);
        petsApp.triggerHint(-2147221504);
        petsApp.triggerHint(-2146959360);
        petsApp.triggerHint(-2146435072);
        petsApp.triggerHint(-2145386496);
        petsApp.triggerHint(1);
        petsApp.triggerHint(65536);
        return super.onOpen();
    }

    public void onPaint(Graphics graphics) {
        graphics.setClip(this.m_rctViewPort[0] >> 12, this.m_rctViewPort[1] >> 12, this.m_iViewPortWidth >> 12, this.m_iViewPortHeight >> 12);
        graphics.setColor(0);
        graphics.fillRect(this.m_rctViewPort[0] >> 12, this.m_rctViewPort[1] >> 12, this.m_iViewPortWidth >> 12, this.m_iViewPortHeight >> 12);
        super.onPaint(graphics);
    }
}

