/*
 * Decompiled with CFR 0.152.
 */
package sims_pets;

import sims_pets.AnimObject;
import sims_pets.ArrayList;
import sims_pets.GameApp;
import sims_pets.GameObject;
import sims_pets.GameScene;
import sims_pets.InfoPageScene;
import sims_pets.OptionScene;
import sims_pets.PetsApp;
import sims_pets.Scene;
import sims_pets.TextObject;

public class MenuScene
extends GameScene {
    public static final int kOptionSoundID = 2001;
    public static final int kOptionVibeID = 2002;
    public static final int kOptionSound = 0;
    public static final int kOptionVibe = 1;
    public static final int kOptionHelp = 2;
    public static final int kOptionLanguage = 3;
    public static final int kOptionBack = 4;
    public static final int kMainMenu_NewGame = 1;
    public static final int kMainMenu_LoadGame = 2;
    public static final int kMainMenu_Options = 3;
    public static final int kMainMenu_Help = 4;
    public static final int kMainMenu_About = 5;
    public static final int kMainMenu_MoreGames = 6;
    public static final int kHelpMenu_HowToPlay = 1;
    public static final int kHelpMenu_Controls = 2;
    public static final int kHelpMenu_Icons = 3;
    public static final int kOptions_Sfx = 1;
    public static final int kOptions_vibrate = 2;
    public static final int kOptions_help = 3;
    public static final int kOptions_language = 4;
    public static final int kOptions_back = 5;
    public static final int kLanguagePromptID = 200;
    public static final int kLanguageLanguageID = 201;
    public static final int kLanguage_English = 1;
    public static final int kLanguage_French = 2;
    public static final int kLanguage_Italian = 3;
    public static final int kLanguage_German = 4;
    public static final int kLanguage_Spanish = 5;
    protected AnimObject m_pMenuSelector;
    protected ArrayList m_plstTabStops;
    protected GameObject m_pCurrentObject;
    protected int m_iNumItems;
    private TextObject m_pLangMenuPrompt;
    private TextObject m_pLangMenuLanguage;

    public MenuScene(int n) {
        super(n);
    }

    public boolean onAddObject(GameObject gameObject) {
        boolean bl = super.onAddObject(gameObject);
        if (gameObject.m_iUserData > 0) {
            this.addTabStopObject(gameObject);
        }
        if (gameObject.m_iInstanceID == 100) {
            this.m_pMenuSelector = (AnimObject)gameObject;
        }
        this.m_pCurrentObject = this.m_plstTabStops != null && this.m_plstTabStops.elementCount > 0 ? (GameObject)this.m_plstTabStops.elementData[0] : null;
        if (this.m_iSceneID == 79) {
            if (gameObject.m_iInstanceID == 200) {
                this.m_pLangMenuPrompt = (TextObject)gameObject;
            } else if (gameObject.m_iInstanceID == 201) {
                this.m_pLangMenuLanguage = (TextObject)gameObject;
            }
        }
        return bl;
    }

    public void onCheckKeysChanged() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n = petsApp.m_iKeysChanged;
        if ((n & 0x1004) != 0) {
            this.prevObject();
            this.updateSelectorPosition();
        } else if ((n & 0x2100) != 0) {
            this.nextObject();
            this.updateSelectorPosition();
        } else {
            if ((n & 0x90020) != 0) {
                if (this.m_pCurrentObject != null) {
                    this.handleSelect(this.m_pCurrentObject.m_iUserData);
                } else if (this.m_iSceneID != 72) {
                    this.handleSelect(-1);
                }
                return;
            }
            if ((n & 0x60000) != 0) {
                if (this.m_iSceneID == 70) {
                    petsApp.openConfirmDialog(37);
                } else {
                    petsApp.closeScene(this);
                }
                return;
            }
        }
        super.onCheckKeysChanged();
    }

    public int onOpen() {
        GameObject gameObject;
        int n;
        int n2;
        GameObject gameObject2;
        int n3;
        int n4;
        block16: {
            PetsApp petsApp;
            block17: {
                block15: {
                    petsApp = (PetsApp)GameApp.m_instance;
                    n4 = -1;
                    n3 = -1;
                    if (this.m_iSceneID != 70) break block15;
                    if (!petsApp.getUserExists()) {
                        n4 = 2;
                    }
                    petsApp.playMusic();
                    break block16;
                }
                if (this.m_iSceneID != 76) break block17;
                if (petsApp.m_bAblePlayVib) break block16;
                n4 = 2;
                n3 = 5;
                break block16;
            }
            if (this.m_iSceneID == 79) {
                if (petsApp.getSavedLanguage() == 0 && this.m_pCancelSoftKey != null) {
                    gameObject2 = (TextObject)this.m_pCancelSoftKey;
                    gameObject2.setText(5);
                }
                n2 = this.m_plstTabStops != null ? this.m_plstTabStops.elementCount : 0;
                for (n = 0; n < n2; ++n) {
                    gameObject = (GameObject)this.m_plstTabStops.elementData[n];
                    if (gameObject == null || gameObject.m_iUserData != petsApp.getLanguage()) continue;
                    this.m_pCurrentObject = gameObject;
                    break;
                }
            }
        }
        if (n4 > -1) {
            gameObject2 = null;
            int n5 = -1;
            int n6 = 0;
            n2 = this.m_plstTabStops != null ? this.m_plstTabStops.elementCount : 0;
            for (n = 0; n < n2 && gameObject2 == null; ++n) {
                gameObject = (GameObject)this.m_plstTabStops.elementData[n];
                if (gameObject == null || gameObject.m_iUserData != n4) continue;
                gameObject2 = gameObject;
                n5 = n;
            }
            if (gameObject2 != null) {
                gameObject2.m_bVisible = false;
                this.m_plstTabStops.removeElementAt(n5);
                gameObject = (GameObject)this.m_plstTabStops.elementData[n5 - 1];
                if (gameObject != null) {
                    n6 = gameObject2.m_iY - gameObject.m_iY;
                }
                for (n = n5; n < this.m_plstTabStops.elementCount; ++n) {
                    gameObject = (GameObject)this.m_plstTabStops.elementData[n];
                    if (gameObject == null) continue;
                    gameObject.setLocation(gameObject.m_iX, gameObject.m_iY - n6);
                }
                if (n3 > -1) {
                    for (n = 0; n < this.m_listObjects.elementCount; ++n) {
                        gameObject = (GameObject)this.m_listObjects.elementData[n];
                        if (gameObject == null) continue;
                        if (gameObject.m_iInstanceID == n4 && gameObject.m_iUserData == 0) {
                            gameObject.m_bVisible = false;
                            continue;
                        }
                        if (gameObject.m_iInstanceID <= n4 || gameObject.m_iInstanceID > n3 || gameObject.m_iUserData != 0) continue;
                        gameObject.setLocation(gameObject.m_iX, gameObject.m_iY - n6);
                    }
                }
            }
        }
        if (PetsApp.iUseStatic == 0) {
            n2 = this.m_plstTabStops != null ? this.m_plstTabStops.elementCount : 0;
            for (n = 0; n < n2; ++n) {
                gameObject = (GameObject)this.m_plstTabStops.elementData[n];
                if (gameObject == null || gameObject.m_iUserData != 6) continue;
                gameObject.m_bVisible = false;
                this.m_plstTabStops.removeElementAt(n);
                break;
            }
            for (n = 0; n < this.m_listObjects.elementCount; ++n) {
                gameObject = (GameObject)this.m_listObjects.elementData[n];
                if (gameObject == null || gameObject.m_iInstanceID != n4 || gameObject.m_iUserData != 0) continue;
                gameObject.m_bVisible = false;
            }
        }
        this.updateSelectorPosition();
        return super.onOpen();
    }

    public void onSuspend() {
        super.onSuspend();
        if (this.m_pMenuSelector != null) {
            this.m_pMenuSelector.m_bVisible = false;
        }
    }

    public void onIdle(int n) {
        if (this.m_pMenuSelector != null) {
            this.m_pMenuSelector.m_bVisible = true;
        }
        super.onIdle(n);
    }

    public void updateSelectorPosition() {
        int n;
        int n2;
        GameObject gameObject = this.m_pCurrentObject;
        if (gameObject != null) {
            n2 = gameObject.m_iX;
            n = gameObject.m_iY;
            if (this.m_pMenuSelector != null) {
                this.m_pMenuSelector.setLocation(n2, n);
            }
        }
        if (this.m_iSceneID == 79) {
            n2 = -1;
            n = -1;
            switch (gameObject.m_iUserData) {
                case 1: {
                    n2 = 348;
                    n = 343;
                    break;
                }
                case 2: {
                    n2 = 349;
                    n = 344;
                    break;
                }
                case 3: {
                    n2 = 350;
                    n = 345;
                    break;
                }
                case 4: {
                    n2 = 351;
                    n = 346;
                    break;
                }
                case 5: {
                    n2 = 352;
                    n = 347;
                }
            }
            if (this.m_pLangMenuPrompt != null) {
                this.m_pLangMenuPrompt.setText(n2);
            }
            if (this.m_pLangMenuLanguage != null) {
                this.m_pLangMenuLanguage.setText(n);
            }
        }
    }

    public final void addTabStopObject(GameObject gameObject) {
        if (this.m_plstTabStops == null) {
            this.m_plstTabStops = new ArrayList();
        }
        int n = this.m_plstTabStops.elementCount;
        for (int i = 0; i < n; ++i) {
            GameObject gameObject2 = (GameObject)this.m_plstTabStops.elementData[i];
            if (gameObject2.m_iInstanceID <= gameObject.m_iInstanceID) continue;
            this.m_plstTabStops.addElement(gameObject);
            return;
        }
        this.m_plstTabStops.addElement(gameObject);
    }

    public GameObject nextObject() {
        if (this.m_plstTabStops != null) {
            if (this.m_plstTabStops.elementCount <= 0) {
                return null;
            }
            int n = this.m_plstTabStops.indexOf(this.m_pCurrentObject) + 1;
            if (n == this.m_plstTabStops.elementCount) {
                n = 0;
            }
            this.m_pCurrentObject = (GameObject)this.m_plstTabStops.elementData[n];
        }
        return this.m_pCurrentObject;
    }

    public GameObject prevObject() {
        if (this.m_plstTabStops != null) {
            if (this.m_plstTabStops.elementCount <= 0) {
                return null;
            }
            int n = this.m_plstTabStops.indexOf(this.m_pCurrentObject) - 1;
            if (n <= -1) {
                n = this.m_plstTabStops.elementCount - 1;
            }
            this.m_pCurrentObject = (GameObject)this.m_plstTabStops.elementData[n];
        }
        return this.m_pCurrentObject;
    }

    public void handleSelect(int n) {
        GameApp gameApp = GameApp.m_instance;
        Scene scene = null;
        switch (this.m_iSceneID) {
            case 70: {
                scene = this.handleMainMenuSelect(n);
                break;
            }
            case 73: {
                scene = this.handleHelpMenuSelect(n);
                break;
            }
            case 79: {
                scene = this.handleLanguageMenuSelect(n);
            }
        }
        if (n == -1) {
            gameApp.closeScene(this);
        }
        if (scene != null) {
            gameApp.openScene(scene);
        }
    }

    public final Scene handleMainMenuSelect(int n) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        GameScene gameScene = null;
        switch (n) {
            case 1: {
                if (petsApp.getUserExists()) {
                    petsApp.openConfirmDialog(362);
                    break;
                }
                petsApp.onDialogEvent(38, 362);
                break;
            }
            case 2: {
                petsApp.onDialogEvent(0, 61);
                break;
            }
            case 3: {
                gameScene = new OptionScene(76);
                break;
            }
            case 4: {
                gameScene = new MenuScene(73);
                break;
            }
            case 5: {
                gameScene = new InfoPageScene(264, 11);
                break;
            }
            case 6: {
                if (PetsApp.iUseStatic == 2) {
                    petsApp.saveData();
                    petsApp.openConfirmDialog(373);
                    break;
                }
                petsApp.moreGames();
            }
        }
        return gameScene;
    }

    public final Scene handleHelpMenuSelect(int n) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        GameScene gameScene = null;
        switch (n) {
            case 1: {
                gameScene = new InfoPageScene(262, 123);
                break;
            }
            case 2: {
                gameScene = new InfoPageScene(263, 10);
                break;
            }
            case 3: {
                gameScene = new MenuScene(72);
            }
        }
        return gameScene;
    }

    public final Scene handleLanguageMenuSelect(int n) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        Scene scene = null;
        int n2 = petsApp.getSavedLanguage();
        petsApp.setLanguage(n);
        if (n2 == 0) {
            petsApp.onStartFirstScene();
        }
        petsApp.closeScene(this);
        return scene;
    }
}

