/*
 * Decompiled with CFR 0.152.
 */
package sims_pets;

import javax.microedition.lcdui.Graphics;
import sims_pets.GameApp;
import sims_pets.GameObject;
import sims_pets.MenuScene;
import sims_pets.PetsApp;
import sims_pets.TextObject;

public class DialogScene
extends MenuScene {
    public static final int kMaxItemCount = 16;
    public static final int kTitleTextBoxInstanceID = 50;
    public static final int kSelectorInstanceID = 100;
    public static final int kDialogEventBase = 1400;
    public static final int kDialogEventSelectItem = 1401;
    public static final int kDialogEventClosed = 1402;
    protected TextObject m_pTitleText;
    protected TextObject[] m_ptxtItem = new TextObject[16];
    protected int m_iCurrentItemCount;
    protected int[] m_iItemString = new int[16];
    protected int[] m_iItemInstanceID = new int[16];
    protected boolean[] m_bDisabledItem = new boolean[16];
    protected int m_iTitleStringResID;
    protected byte[] m_strTitleString;
    protected int m_xLineHeight;
    protected int m_xMaxWidth;
    protected int m_xWidestItem;
    protected int m_iDefaultSelection;
    protected int m_iAcceptSoftKeyTextID;
    protected int m_iCancelSoftKeyTextID;
    protected int m_iDialogID;
    protected boolean m_bGameMessage;

    public DialogScene(int n, int n2, byte[] byArray) {
        super(77);
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        this.m_iDialogID = n;
        this.m_strTitleString = byArray;
        this.m_iTitleStringResID = n2;
        this.m_xMaxWidth = petsApp.m_iScreenWidth * 3072;
        this.m_xLineHeight = petsApp.getFont().getHeight() + 2 << 12;
        this.m_iAcceptSoftKeyTextID = -1;
        this.m_iCancelSoftKeyTextID = 0;
        this.m_bPaintBackground = false;
    }

    public final void addString(int n, int n2) {
        this.m_iItemString[this.m_iCurrentItemCount] = n;
        this.m_iItemInstanceID[this.m_iCurrentItemCount] = n2;
        ++this.m_iCurrentItemCount;
        this.m_iAcceptSoftKeyTextID = 0;
    }

    public final void setSelectedItem(int n) {
        this.m_iDefaultSelection = n;
    }

    public void onPaint(Graphics graphics) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        petsApp.drawCommonBackground(graphics, (this.m_rctViewPort[0] >> 12) - 3, (this.m_rctViewPort[1] >> 12) - 3, (this.m_iViewPortWidth >> 12) + 6, (this.m_iViewPortHeight >> 12) + 6);
        super.onPaint(graphics);
    }

    public void handleSelect(int n) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        if (n != -1) {
            petsApp.onDialogEvent(n, this.m_iDialogID);
        } else {
            super.handleSelect(n);
        }
    }

    public boolean onAddObject(GameObject gameObject) {
        boolean bl = true;
        if (gameObject != null) {
            bl = super.onAddObject(gameObject);
            if (gameObject.m_iInstanceID != 100) {
                TextObject textObject = (TextObject)gameObject;
                int n = textObject.m_iInstanceID;
                boolean bl2 = false;
                if (n == 50) {
                    this.m_pTitleText = textObject;
                    bl2 = true;
                    if (this.m_strTitleString != null) {
                        textObject.setText(this.m_strTitleString, false);
                    } else {
                        textObject.setText(this.m_iTitleStringResID);
                    }
                } else if (n > 0 && n <= 16) {
                    if (this.m_iItemString[--n] > 0) {
                        this.m_ptxtItem[n] = textObject;
                        bl2 = true;
                        textObject.m_iUserData = this.m_iItemInstanceID[n];
                        textObject.setText(this.m_iItemString[n]);
                    } else {
                        bl = false;
                    }
                }
                if (bl2 && textObject.getWidth() > this.m_xWidestItem) {
                    this.m_xWidestItem = textObject.getWidth();
                }
            }
        }
        return bl;
    }

    public void onReloadText() {
        if (this.m_iDialogID == 2000 && this.m_pTitleText != null && this.m_strTitleString != null) {
            GameApp.releaseStringBuffer(this.m_strTitleString);
            PetsApp petsApp = (PetsApp)GameApp.m_instance;
            this.m_strTitleString = petsApp.getLastPopup();
            if (this.m_strTitleString != null) {
                this.m_pTitleText.setText(this.m_strTitleString, false);
            }
        }
        super.onReloadText();
    }

    public void onCheckKeysChanged() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n = petsApp.m_iKeysChanged;
        if (this.m_bGameMessage) {
            if ((n & 0x60000) != 0) {
                petsApp.openPauseDialog();
                petsApp.closeScene(this);
            } else if ((n & 0x90020) != 0) {
                petsApp.closeScene(this);
            }
            return;
        }
        super.onCheckKeysChanged();
    }

    public int onOpen() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n = 0;
        this.m_xWidestItem += 16384;
        if (this.m_pTitleText != null) {
            this.m_pTitleText.setLocation(0, 0);
            this.m_pTitleText.m_iWidth = this.m_xWidestItem;
            this.m_pTitleText.m_iHeight = this.m_bGameMessage ? 319488 : 3 * this.m_xLineHeight;
            n += this.m_pTitleText.getHeight();
        }
        if (this.m_bGameMessage) {
            this.m_iAcceptSoftKeyTextID = 13;
            this.m_iCancelSoftKeyTextID = 35;
        }
        for (int i = 0; i < this.m_iCurrentItemCount; ++i) {
            if (this.m_ptxtItem[i] == null) continue;
            this.m_ptxtItem[i].setLocation(0, n);
            this.m_ptxtItem[i].setWidth(this.m_xWidestItem);
            n += this.m_ptxtItem[i].getHeight();
        }
        this.setLocation(-((petsApp.m_iScreenWidth << 12) - this.m_xWidestItem >> 1), -((petsApp.m_iScreenHeight << 12) - (n += 16384) >> 1));
        this.setViewPort(-this.m_iX, -this.m_iY, -this.m_iX + this.m_xWidestItem, -this.m_iY + n);
        if (this.m_plstTabStops != null && this.m_plstTabStops.elementCount > 0) {
            this.m_pCurrentObject = (GameObject)this.m_plstTabStops.elementData[this.m_iDefaultSelection];
            if (this.m_pCurrentObject == null) {
                this.m_pCurrentObject = (GameObject)this.m_plstTabStops.elementData[0];
            }
            this.updateSelectorPosition();
        }
        if (this.m_pAcceptSoftKey != null) {
            if (this.m_iAcceptSoftKeyTextID < 0) {
                this.m_pAcceptSoftKey = null;
            } else if (this.m_iAcceptSoftKeyTextID > 0) {
                ((TextObject)this.m_pAcceptSoftKey).setText(this.m_iAcceptSoftKeyTextID);
            }
        }
        if (this.m_pCancelSoftKey != null) {
            if (this.m_iCancelSoftKeyTextID < 0) {
                this.m_pCancelSoftKey = null;
            } else if (this.m_iCancelSoftKeyTextID > 0) {
                ((TextObject)this.m_pCancelSoftKey).setText(this.m_iCancelSoftKeyTextID);
            }
        }
        return 0;
    }

    public int onClose() {
        if (this.m_strTitleString != null) {
            GameApp.releaseStringBuffer(this.m_strTitleString);
            this.m_strTitleString = null;
        }
        this.m_iCurrentItemCount = 0;
        return super.onClose();
    }

    public GameObject nextObject() {
        int n;
        int n2 = this.m_plstTabStops.indexOf(this.m_pCurrentObject);
        do {
            if (this.m_plstTabStops.indexOf(this.m_pCurrentObject) >= this.m_iCurrentItemCount - 1) {
                this.m_pCurrentObject = (GameObject)this.m_plstTabStops.elementData[0];
                continue;
            }
            super.nextObject();
        } while ((n = this.m_plstTabStops.indexOf(this.m_pCurrentObject)) != n2 && this.m_bDisabledItem[n]);
        return this.m_pCurrentObject;
    }

    public GameObject prevObject() {
        int n;
        int n2 = this.m_plstTabStops.indexOf(this.m_pCurrentObject);
        do {
            if (this.m_plstTabStops.indexOf(this.m_pCurrentObject) == 0 && this.m_plstTabStops.elementCount > this.m_iCurrentItemCount) {
                this.m_pCurrentObject = (GameObject)this.m_plstTabStops.elementData[this.m_iCurrentItemCount - 1];
                continue;
            }
            super.prevObject();
        } while ((n = this.m_plstTabStops.indexOf(this.m_pCurrentObject)) != n2 && this.m_bDisabledItem[n]);
        return this.m_pCurrentObject;
    }
}

