/*
 * Decompiled with CFR 0.152.
 */
package sims_pets;

import javax.microedition.lcdui.Graphics;
import sims_pets.AnimObject;
import sims_pets.Box;
import sims_pets.DeviceInfo;
import sims_pets.DialogScene;
import sims_pets.GameApp;
import sims_pets.GameObject;
import sims_pets.GameScene;
import sims_pets.PetsApp;
import sims_pets.TextObject;

public class ChoosePetScene
extends GameScene {
    public static final int kBoxPreview = 100;
    public static final int kBoxStepBounds = 101;
    public static final int kBoxTitle = 102;
    public static final int kBoxOption = 103;
    public static final int kTxtTitle = 200;
    public static final int kTxtOptionTitle = 201;
    public static final int kTxtOptionDesc = 202;
    public static final int kAnmArrowLeft = 300;
    public static final int kAnmArrowUp = 301;
    public static final int kAnmArrowRight = 302;
    public static final int kAnmArrowDown = 303;
    public static final int kAnmCursor = 304;
    public static final int kAnmBGBase = 310;
    public static final int kAnmNumberBase = 320;
    public static final int kLoadDone = 0;
    public static final int kLoadBreed = 1;
    public static final int kStepBreed = 0;
    public static final int kStepCoat = 1;
    public static final int kStepName = 2;
    public static final int kStepCount = 3;
    public static final int kCharMapTextID = 3001;
    public static final int kCharMapBoxID = 3002;
    public static final int kTotalOptions = 8;
    private AnimObject[] m_ppanmArrows = new AnimObject[4];
    private AnimObject[][] m_ppanmDogs = new AnimObject[2][4];
    private AnimObject m_panmCursor;
    private AnimObject[] m_ppanmStepBGs = new AnimObject[3];
    private TextObject m_ptxtOptionTitle;
    private TextObject m_ptxtOptionDesc;
    private int m_xPreviewX;
    private int m_xPreviewY;
    private int[] m_xrctStepBounds = new int[4];
    private int m_iFirstStep;
    private int m_iStep;
    private int m_iLoadStep;
    private int[] m_piCurrentOptions = new int[3];
    private byte[] m_pSavedName;
    private TextObject m_ptxtCharMap;
    private Box m_pboxCharMap;
    private int m_iSuperProgress;

    public ChoosePetScene() {
        super(69);
        if (this.m_pyLoadingLocationString != null) {
            GameApp.releaseStringBuffer(this.m_pyLoadingLocationString);
        }
        this.m_pyLoadingLocationString = GameApp.loadStringResource(19);
        this.m_iStep = this.m_iFirstStep;
    }

    private final void nextOption() {
        int n = this.m_piCurrentOptions[0];
        int n2 = this.m_piCurrentOptions[this.m_iStep];
        int n3 = 0;
        switch (this.m_iStep) {
            case 0: {
                if (++n2 >= 2) {
                    n2 = 0;
                }
                if (DeviceInfo.k_iDogBreedParts[n2][2 + this.m_piCurrentOptions[1]][0] != -1) break;
                this.m_piCurrentOptions[1] = 0;
                break;
            }
            case 1: {
                do {
                    ++n3;
                    if (++n2 < 4) continue;
                    n2 = 0;
                } while (DeviceInfo.k_iDogBreedParts[n][2 + n2][0] == -1 && n3 < 4);
            }
        }
        this.m_piCurrentOptions[this.m_iStep] = n2;
        this.update();
    }

    private final void prevOption() {
        int n = this.m_piCurrentOptions[0];
        int n2 = this.m_piCurrentOptions[this.m_iStep];
        int n3 = 0;
        switch (this.m_iStep) {
            case 0: {
                if (--n2 < 0) {
                    n2 = 1;
                }
                if (DeviceInfo.k_iDogBreedParts[n2][2 + this.m_piCurrentOptions[1]][0] != -1) break;
                this.m_piCurrentOptions[1] = 0;
                break;
            }
            case 1: {
                do {
                    ++n3;
                    if (--n2 >= 0) continue;
                    n2 = 3;
                } while (DeviceInfo.k_iDogBreedParts[n][2 + n2][0] == -1 && n3 < 4);
            }
        }
        this.m_piCurrentOptions[this.m_iStep] = n2;
        this.update();
    }

    private final void nextStep() {
        if (this.m_iStep < 2) {
            ++this.m_iStep;
            this.update();
        }
    }

    private final void prevStep() {
        if (this.m_iStep > this.m_iFirstStep) {
            if (this.m_iStep == 2 && this.m_ptxtOptionDesc.m_pText != null) {
                this.m_pSavedName = GameApp.dupeStringBuffer(this.m_ptxtOptionDesc.m_pText);
            }
            --this.m_iStep;
            this.update();
        }
    }

    private final void update() {
        int n;
        int n2 = -1;
        if (this.m_ptxtOptionTitle != null && this.m_ptxtOptionTitle.m_iUserData != DeviceInfo.k_iDogOptionDscriptionIDs[this.m_iStep]) {
            this.m_ptxtOptionTitle.setText(DeviceInfo.k_iDogOptionDscriptionIDs[this.m_iStep]);
            this.m_ptxtOptionTitle.m_iUserData = DeviceInfo.k_iDogOptionDscriptionIDs[this.m_iStep];
        }
        switch (this.m_iStep) {
            case 0: {
                n2 = DeviceInfo.k_iDogBreedParts[this.m_piCurrentOptions[0]][0][1];
                break;
            }
            case 1: {
                n2 = DeviceInfo.k_iDogBreedParts[this.m_piCurrentOptions[0]][2 + this.m_piCurrentOptions[1]][1];
            }
        }
        if (n2 != -1 && this.m_ptxtOptionDesc != null) {
            this.m_ptxtOptionDesc.setText(n2);
        }
        if (this.m_panmCursor != null) {
            n = this.m_iStep - this.m_iFirstStep;
            if (this.m_ppanmStepBGs[n] != null) {
                this.m_panmCursor.setLocation(this.m_ppanmStepBGs[n].getX(), this.m_ppanmStepBGs[n].getY());
                this.m_panmCursor.m_bVisible = true;
            } else {
                this.m_panmCursor.m_bVisible = false;
            }
        }
        for (n = 0; n < 2; ++n) {
            for (int i = 0; i < 4; ++i) {
                if (this.m_ppanmDogs[n][i] == null) continue;
                this.m_ppanmDogs[n][i].setVisible(n == this.m_piCurrentOptions[0] && i == this.m_piCurrentOptions[1]);
            }
        }
        if (this.m_ppanmArrows[0] != null) {
            this.m_ppanmArrows[0].setVisible(this.m_iStep != 2);
        }
        if (this.m_ppanmArrows[2] != null) {
            this.m_ppanmArrows[2].setVisible(this.m_iStep != 2);
        }
        if (this.m_ppanmArrows[1] != null) {
            this.m_ppanmArrows[1].setVisible(this.m_iStep > this.m_iFirstStep);
        }
        if (this.m_ppanmArrows[3] != null) {
            this.m_ppanmArrows[3].setVisible(this.m_iStep < 2);
        }
        if (this.m_iStep == 2) {
            this.setNameEntryMode(true);
        } else {
            this.setNameEntryMode(false);
        }
        this.m_iLoadStep = 1;
    }

    private final void loadDog(int n, int n2) {
        AnimObject animObject = null;
        if (this.m_ppanmDogs[n][n2] == null) {
            int n3 = DeviceInfo.k_iDogBreedParts[n][2 + n2][0];
            int n4 = DeviceInfo.k_iDogBreedParts[n][1][0];
            if (n3 < 0 || n4 < 0) {
                return;
            }
            animObject = new AnimObject();
            if (animObject != null) {
                animObject.m_sLoadMaskOption = 0;
                animObject.setPaletteResID(n3);
                animObject.onLoadResource(n4);
                this.addObject(animObject);
                animObject.setLocation(this.m_xPreviewX, this.m_xPreviewY + (animObject.getHeight() >> 1));
                this.m_ppanmDogs[n][n2] = animObject;
            }
        }
    }

    private final void setNameEntryMode(boolean bl) {
        if (bl) {
            if (this.m_ptxtOptionDesc != null) {
                this.m_ptxtOptionDesc.m_bEditable = true;
                this.m_ptxtOptionDesc.m_iCaretColor = 0xFFFFFF;
                this.m_ptxtOptionDesc.m_bPaintBackground = true;
                this.m_ptxtOptionDesc.m_bPaintBorder = true;
                this.m_ptxtOptionDesc.m_bPaintBorderOutline = true;
                this.m_ptxtOptionDesc.m_iBackgroundColor = 0;
                this.m_ptxtOptionDesc.m_iBorderColor = 19852;
                this.m_ptxtOptionDesc.m_iBorderOutlineColor = 19852;
                this.m_ptxtOptionDesc.m_iMaxEditLength = 10;
                this.m_ptxtOptionDesc.setText(this.m_pSavedName, true);
                if (this.m_ptxtOptionDesc.getLength() > 0) {
                    this.m_ptxtOptionDesc.setCaretPosition(this.m_ptxtOptionDesc.getLength());
                }
            }
        } else {
            if (this.m_ptxtOptionDesc != null) {
                this.m_ptxtOptionDesc.m_bEditable = false;
                this.m_ptxtOptionDesc.m_bPaintBackground = false;
                this.m_ptxtOptionDesc.m_bPaintBorder = false;
                this.m_ptxtOptionDesc.m_bPaintBorderOutline = false;
            }
            if (this.m_ptxtCharMap != null) {
                this.m_ptxtCharMap.m_bVisible = false;
            }
            if (this.m_pboxCharMap != null) {
                this.m_pboxCharMap.m_bVisible = false;
            }
        }
    }

    public boolean onAddObject(GameObject gameObject) {
        if (gameObject != null) {
            int n = gameObject.m_iInstanceID;
            switch (n) {
                case 3001: {
                    this.m_ptxtCharMap = (TextObject)gameObject;
                    this.m_ptxtCharMap.m_bVisible = false;
                    break;
                }
                case 3002: {
                    this.m_pboxCharMap = (Box)gameObject;
                    this.m_pboxCharMap.m_iStyle = 2;
                    this.m_pboxCharMap.m_bVisible = false;
                    break;
                }
                case 100: {
                    this.m_xPreviewX = gameObject.m_iLeft + gameObject.m_iRight >> 1;
                    this.m_xPreviewY = gameObject.m_iTop + gameObject.m_iBottom >> 1;
                    Box box = (Box)gameObject;
                    box.m_iStyle = 5;
                    box.setZ(box.m_iZ - 1);
                    break;
                }
                case 102: {
                    Box box = (Box)gameObject;
                    box.m_iStyle = 5;
                    break;
                }
                case 103: {
                    Box box = (Box)gameObject;
                    box.m_iStyle = 5;
                    break;
                }
                case 101: {
                    this.m_xrctStepBounds[0] = gameObject.m_iLeft;
                    this.m_xrctStepBounds[1] = gameObject.m_iTop;
                    this.m_xrctStepBounds[2] = gameObject.m_iRight;
                    this.m_xrctStepBounds[3] = gameObject.m_iBottom;
                    Box box = (Box)gameObject;
                    box.m_iStyle = 5;
                    break;
                }
                case 304: {
                    this.m_panmCursor = (AnimObject)gameObject;
                    break;
                }
                default: {
                    if (310 <= n && n < 320) {
                        if ((n -= 310) >= 3 - this.m_iFirstStep) {
                            gameObject.m_bVisible = false;
                            gameObject.m_bRemove = true;
                            break;
                        }
                        this.m_ppanmStepBGs[n] = (AnimObject)gameObject;
                        break;
                    }
                    if (320 > n || n >= 330 || (n -= 320) < 3 - this.m_iFirstStep) break;
                    gameObject.m_bVisible = false;
                    gameObject.m_bRemove = true;
                    break;
                }
                case 200: {
                    TextObject textObject = (TextObject)gameObject;
                    textObject.setText(19);
                    break;
                }
                case 201: {
                    this.m_ptxtOptionTitle = (TextObject)gameObject;
                    break;
                }
                case 202: {
                    this.m_ptxtOptionDesc = (TextObject)gameObject;
                    break;
                }
                case 300: 
                case 301: 
                case 302: 
                case 303: {
                    int n2 = n - 300;
                    this.m_ppanmArrows[n2] = (AnimObject)gameObject;
                }
            }
        }
        return super.onAddObject(gameObject);
    }

    public void onIdle(int n) {
        if (this.m_iLoadStep != 0 && this.m_iLoadStep == 1) {
            this.loadDog(this.m_piCurrentOptions[0], this.m_piCurrentOptions[1]);
            this.m_iLoadStep = 0;
        }
        super.onIdle(n);
    }

    public void onCheckKeysChanged() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n = petsApp.m_iKeysChanged;
        boolean bl = true;
        if (this.m_iLoadStep != 0) {
            return;
        }
        if (this.m_iStep == 2 && this.m_ptxtOptionDesc != null) {
            if ((n & 0x60000) != 0 && this.m_ptxtOptionDesc.getLength() > 0) {
                bl = false;
            }
            if ((n & 0x40000) != 0) {
                this.m_ptxtOptionDesc.handleKeyPressed(131072);
            } else {
                this.m_ptxtOptionDesc.handleKeyPressed(n);
            }
            if (this.m_ptxtCharMap != null) {
                petsApp.updateCharacterMap(this.m_ptxtOptionDesc, this.m_ptxtCharMap);
            }
            n &= 0xFFFFFC00;
        }
        if (bl && (n & 0x60000) != 0) {
            if (this.m_iStep <= this.m_iFirstStep) {
                petsApp.closeAllScenes();
                petsApp.m_iDeferredScene = 1;
                return;
            }
            this.prevStep();
        }
        if ((n & 0x90020) != 0) {
            if (this.m_iStep == 2) {
                byte[] byArray = null;
                byArray = this.m_iStep == 2 ? this.m_ptxtOptionDesc.m_pText : this.m_pSavedName;
                if (byArray != null && GameApp.getStringBufferLength(byArray) > 0) {
                    for (int i = 0; i < 2; ++i) {
                        petsApp.m_iNewPetParts[i] = this.m_piCurrentOptions[i];
                    }
                    petsApp.m_pNewPetName = GameApp.dupeStringBuffer(byArray);
                    petsApp.saveNewUserAndPet();
                    petsApp.onDialogEvent(0, 61);
                } else {
                    DialogScene dialogScene = new DialogScene(161, 161, null);
                    if (dialogScene != null) {
                        dialogScene.addString(13, -1);
                        dialogScene.m_iAcceptSoftKeyTextID = 13;
                        dialogScene.m_iCancelSoftKeyTextID = -1;
                        petsApp.openScene(dialogScene);
                    }
                }
                return;
            }
            this.nextStep();
        } else if ((n & 0x1004) != 0) {
            this.prevStep();
        } else if ((n & 0x2100) != 0) {
            this.nextStep();
        } else if (this.m_iStep != 2) {
            if ((n & 0x4010) != 0) {
                this.prevOption();
            } else if ((n & 0x8040) != 0) {
                this.nextOption();
            }
        }
        super.onCheckKeysChanged();
    }

    public int onOpen() {
        this.update();
        return super.onOpen();
    }

    public int onLoad(int n) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n2 = n;
        switch (n) {
            case 0: {
                this.m_iSuperProgress = super.onLoad(this.m_iSuperProgress);
                if (this.m_iSuperProgress < 100) break;
                n2 = 9;
                break;
            }
            default: {
                if ((n2 += 10) > 100) {
                    n2 = 100;
                }
                int n3 = (n - 9) * 7 / 90;
                int n4 = (n2 - 9) * 7 / 90;
                if (n3 + 1 >= 8) {
                    n4 = 8;
                }
                for (n = n3; n < n4; ++n) {
                    int n5 = n / 4;
                    int n6 = n % 4;
                    this.loadDog(n5, n6);
                }
            }
        }
        return n2;
    }

    public void onPaintLoading(Graphics graphics, int n) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        petsApp.drawLoadingBar(graphics, n, Short.MAX_VALUE);
        super.onPaintLoading(graphics, n);
    }

    public void onPaint(Graphics graphics) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        if (this.m_ptxtCharMap != null) {
            if (this.m_ptxtOptionDesc == null || this.m_ptxtOptionDesc.m_iKeyMask == 0) {
                this.m_ptxtCharMap.m_bVisible = false;
            }
            if (this.m_pboxCharMap != null) {
                this.m_pboxCharMap.m_bVisible = this.m_ptxtCharMap.isVisible();
            }
        }
        super.onPaint(graphics);
    }
}

