/*
 * Decompiled with CFR 0.152.
 */
package sims_pets;

import sims_pets.AnimObject;
import sims_pets.DeviceInfo;
import sims_pets.Dog;
import sims_pets.GameApp;
import sims_pets.GameObject;
import sims_pets.Interactive;
import sims_pets.PetsApp;
import sims_pets.PetsGame;

public class Toy
extends Interactive {
    public static final int kToyDisc = 0;
    public static final int kToyWandering = 1;
    public static final int kToyOwner = 2;
    public static final int kToyBall = 3;
    public static final int kToyBed = 4;
    public static final int kToyFood = 5;
    public static final int kToyWater = 6;
    public static final int kToyPotty = 7;
    public static final int kToyBush = 8;
    public static final int kToyPlant = 9;
    public static final int kToyChewBone = 10;
    public static final int kToySqueakyToy = 11;
    public static final int kToyNewsPaper = 12;
    public static final int kToyFoundInBush = 13;
    public static final int kNeedBladder = 0;
    public static final int kNeedEnergy = 1;
    public static final int kNeedFun = 2;
    public static final int kNeedHunger = 3;
    public static final int kNeedHygiene = 4;
    public static final int kNeedCount = 5;
    public static final int kAIIdle = 0;
    public static final int kAIWait = 1;
    public static final int kAIActive = 2;
    public static final int kAICount = 3;
    public static final int kDefaultGiveUpTime = 4000;
    public static final int kDefaultReactionTime = 250;
    public static final int kToyEventBase = 400;
    public static final int kToyEventGainFocus = 401;
    public static final int kToyEventLoseFocus = 402;
    protected int m_iType;
    protected int m_xActivateInterest;
    protected int m_xActiveInterestRate;
    protected int m_xMinActiveInterest;
    protected int m_xMaxActiveInterest;
    protected int m_xDeactivateInterest;
    protected int m_xInactiveInterestRate;
    protected int[] m_pxNeedAdjustRate = new int[5];
    protected int[] m_pxSatisfierMinNeed = new int[5];
    protected int[] m_pxSatisfierMaxNeed = new int[5];
    protected int[] m_pxSatisfierInterestAdjust = new int[5];
    protected int m_xSatisfierEffectRadius;
    protected int m_iGiveUpTimer;
    protected int m_iInteractDelay;
    protected int m_iReactionTime;
    protected int m_iAttackPlantTimer;
    protected boolean m_bAttackPlant;

    public Toy(int n, int n2) {
        super(n2);
        this.m_iCollisionGroup = 2;
        this.m_iType = n;
        this.m_xActivateInterest = -1;
        this.m_xDeactivateInterest = -1;
        this.m_xMinInterestLevel = 0;
        this.m_xMaxInterestLevel = 409600;
        this.m_xMinActiveInterest = -1;
        this.m_xMaxActiveInterest = -1;
        this.m_iReactionTime = 250;
        for (int i = 0; i < 5; ++i) {
            this.m_pxSatisfierMinNeed[i] = -1;
            this.m_pxSatisfierMaxNeed[i] = -1;
        }
        this.m_iAttackPlantTimer = 0;
    }

    public final void setNeedAdjustRate(int n, int n2) {
        this.m_pxNeedAdjustRate[n] = n2;
    }

    public final void setSatisfierMinNeed(int n, int n2) {
        this.m_pxSatisfierMinNeed[n] = n2;
    }

    public final void setSatisfierMaxNeed(int n, int n2) {
        this.m_pxSatisfierMaxNeed[n] = n2;
    }

    public final void setSatisfierInterestAdjust(int n, int n2) {
        this.m_pxSatisfierInterestAdjust[n] = n2;
    }

    public final int getActualInterest(Dog dog) {
        int n = this.m_xInterestLevel;
        if (dog != null) {
            for (int i = 0; i < 5; ++i) {
                if (this.m_pxSatisfierMinNeed[i] <= -1 || dog.m_pxNeeds[i] >= this.m_pxSatisfierMinNeed[i]) continue;
                n += this.m_pxSatisfierInterestAdjust[i];
            }
            PetsApp petsApp = (PetsApp)GameApp.m_instance;
            if (petsApp.isCurrentMetaGoal(131080) && this.m_iType == 9 && dog.m_pxAbilities[13] < 409600) {
                if (!this.m_bAttackPlant) {
                    if (this.m_iState == 0) {
                        this.m_iAttackPlantTimer = 30000;
                        this.m_bAttackPlant = true;
                    } else if (this.m_iState == 1) {
                        this.m_iAttackPlantTimer = 60000;
                        this.m_bAttackPlant = true;
                    }
                } else if (this.m_bAttackPlant && this.m_iAttackPlantTimer <= 0) {
                    n += 307200;
                    dog.m_bDestroyed = true;
                }
            }
            if (this.m_iType == 12 && dog.m_pxAbilities[13] < 409600) {
                int n2 = dog.m_xMood;
                if (this.m_bVisible && n2 < -40960) {
                    n += 409600;
                    dog.m_bDestroyed = true;
                }
            }
        }
        if (n < this.m_xMinInterestLevel) {
            n = this.m_xMinInterestLevel;
        }
        if (n > this.m_xMaxInterestLevel) {
            n = this.m_xMaxInterestLevel;
        }
        return n;
    }

    public final void onToyEvent(GameObject gameObject, int n, Object object, int n2) {
        switch (n) {
            case 401: {
                this.m_iGiveUpTimer = 4000 + this.m_iReactionTime;
                break;
            }
            case 402: {
                this.onDeactivate();
            }
        }
    }

    public boolean onCheckContainment(int[] nArray) {
        if (!this.m_bNoContainment) {
            switch (this.m_iType) {
                case 0: 
                case 3: 
                case 10: 
                case 11: {
                    if (this.m_xWorldLeft <= nArray[0] && this.m_xWorldRight < nArray[2] || this.m_xWorldLeft > nArray[0] && this.m_xWorldRight >= nArray[2] || this.m_xWorldTop <= nArray[1] && this.m_xWorldBottom < nArray[3] || this.m_xWorldTop > nArray[1] && this.m_xWorldBottom >= nArray[3]) {
                        return true;
                    }
                    if (this.m_xWorldZ >= 0) break;
                    return true;
                }
                default: {
                    if (this.m_xWorldLeft <= nArray[0] && this.m_xWorldRight < nArray[2] || this.m_xWorldLeft > nArray[0] && this.m_xWorldRight >= nArray[2] || this.m_xWorldTop <= nArray[1] && this.m_xWorldBottom < nArray[3] || this.m_xWorldTop > nArray[1] && this.m_xWorldBottom >= nArray[3]) {
                        return true;
                    }
                    if (this.m_xWorldBottom >= nArray[1] && (this.m_xWorldBottom <= nArray[3] || this.m_xWorldTop < nArray[1])) break;
                    return true;
                }
            }
        }
        return false;
    }

    public void onHandleContainment(int[] nArray) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        PetsGame petsGame = (PetsGame)this.m_pParent;
        Dog dog = petsGame.m_pDog;
        int n = 0;
        int n2 = 0;
        int n3 = -this.m_xVelocity[2];
        if (this.m_xWorldLeft <= nArray[0] && this.m_xWorldRight < nArray[2] || this.m_xWorldLeft > nArray[0] && this.m_xWorldRight >= nArray[2]) {
            this.m_xVelocity[0] = -this.m_xVelocity[0];
            this.m_xAccel[0] = -this.m_xAccel[0];
            if (this.m_xWorldLeft <= nArray[0]) {
                n = nArray[0] - this.m_xWorldLeft;
                ++n;
            } else {
                n = nArray[2] - this.m_xWorldRight;
                --n;
            }
            if (n3 >= 12288) {
                petsApp.playSound(12);
            }
        }
        if (this.m_xWorldTop <= nArray[1] && this.m_xWorldBottom < nArray[3] || this.m_xWorldTop > nArray[1] && this.m_xWorldBottom >= nArray[3]) {
            this.m_xVelocity[1] = -this.m_xVelocity[1];
            this.m_xAccel[1] = -this.m_xAccel[1];
            if (this.m_xWorldTop <= nArray[1]) {
                n2 = nArray[1] - this.m_xWorldTop;
                ++n2;
            } else {
                n2 = nArray[3] - this.m_xWorldBottom;
                --n2;
            }
            if (n3 >= 12288) {
                petsApp.playSound(12);
            }
        }
        if (this.m_iType != 0) {
            this.m_xVelocity[0] = this.m_xVelocity[0] - (this.m_xVelocity[0] >> 2);
            this.m_xVelocity[1] = this.m_xVelocity[1] - (this.m_xVelocity[1] >> 2);
        } else {
            this.m_xVelocity[0] = this.m_xVelocity[0] - (this.m_xVelocity[0] >> 3);
            this.m_xVelocity[1] = this.m_xVelocity[1] - (this.m_xVelocity[1] >> 3);
        }
        this.setWorldLocation(this.m_xWorldX + n, this.m_xWorldY + n2, this.m_xWorldZ);
        if (dog != null && this.m_xWorldZ < 0 && dog.m_pCarry == null) {
            n3 -= (n3 >> 1) + (n3 >> 3);
            if (this.m_xInterestLevel < 409600 && this.m_iType == 3) {
                Toy toy;
                this.m_xInterestLevel = 409600;
                if (dog.m_iAction != 8) {
                    dog.interrupt(0, 0, this);
                }
                if ((toy = petsGame.getItem(2)) != null) {
                    toy.m_xInterestLevel = 409600;
                }
            }
            if (n3 <= 4096 || this.m_iType == 0 || this.m_iType == 10 || this.m_iType == 11) {
                this.m_xVelocity[2] = 0;
                this.m_xAccel[2] = 0;
                this.stopMovement();
                if (dog.m_pCarry == null && this.m_iType != 10 && this.m_iType != 11) {
                    if (dog.m_iAction != 8) {
                        dog.interrupt(0, 0, this);
                    }
                    this.m_xInterestLevel = 409600;
                }
            } else {
                this.m_xVelocity[2] = n3;
                if (n3 >= 12288) {
                    petsApp.playSound(12);
                }
            }
            this.setWorldZ(0);
        }
    }

    public void onHandleCollision(Interactive interactive) {
        if (interactive.m_iCollisionGroup == 1) {
            interactive.onHandleCollision(this);
        }
    }

    public void setCurrentAI(int n) {
        this.m_iCurrentAI = n;
    }

    public void setNextAI(int n) {
        this.m_iNextAI = n;
    }

    public void advanceAI() {
        this.setCurrentAI(this.m_iNextAI);
        this.setNextAI(0);
    }

    public void onUserSelected() {
        super.onUserSelected();
        if (this.m_iCurrentAI == 0) {
            this.m_iNumAvailableInteractions = this.m_iInteractionCount;
        }
    }

    public void onActivate() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        PetsGame petsGame = (PetsGame)this.m_pParent;
        Dog dog = petsGame.m_pDog;
        if (dog != null) {
            for (int i = 0; i < 5; ++i) {
                if (i == 0) continue;
                dog.setTargetNeed(i, 0);
            }
        }
        if (this.m_iType == 3 || this.m_iType == 11) {
            dog.m_msCountdownTimer2 = 30000;
        }
        if (petsGame != null) {
            switch (this.m_iType) {
                case 1: {
                    if (dog.m_bPottyAtWanderInterest) {
                        dog.doPotty();
                        break;
                    }
                    if (dog.m_iAction == 0) break;
                    dog.setAction(0);
                    break;
                }
                case 0: 
                case 3: {
                    this.stopMovement();
                    dog.setNeed(1, dog.m_pxNeeds[1] - 12288);
                    dog.setNeed(3, dog.m_pxNeeds[3] - 12288);
                    dog.setNeed(2, dog.m_pxNeeds[2] + 24576);
                    break;
                }
                case 2: {
                    if (dog.m_pCarry != null && (dog.m_pCarry.m_iType == 3 || dog.m_pCarry.m_iType == 0)) {
                        dog.resetNeedRate(1);
                    }
                    dog.m_msCountdownTimer1 = 10000;
                    break;
                }
                case 5: {
                    if (dog.m_pxNeeds[3] >= 327680) break;
                    int n = petsGame.m_iFoodType;
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    dog.setAction(4);
                    dog.setWorldLocation(this.m_xWorldX, this.m_xWorldY, 0);
                    dog.setNeedRate(3, 40960);
                    switch (n) {
                        case 4: 
                        case 5: {
                            dog.setNeedRate(3, 6144);
                            break;
                        }
                        case 2: 
                        case 3: {
                            dog.setNeedRate(2, 6144);
                        }
                    }
                    dog.setTargetNeed(3, dog.m_pxNeeds[3] + DeviceInfo.k_iNeedIncrement_Consumable[n][0]);
                    dog.setTargetNeed(2, dog.m_pxNeeds[2] + DeviceInfo.k_iNeedIncrement_Consumable[n][2]);
                    dog.setTargetNeed(0, dog.m_pxNeeds[0] + DeviceInfo.k_iNeedIncrement_Consumable[n][1]);
                    break;
                }
                case 4: {
                    dog.setAction(8);
                    dog.setWorldLocation(this.m_xWorldX, this.m_xWorldY, dog.m_xWorldZ);
                    dog.m_bSleeping = true;
                    break;
                }
                case 8: {
                    dog.m_msCountdownTimer1 = 2000;
                    petsGame.checkBush();
                    break;
                }
                case 11: {
                    petsApp.playSound(15);
                    dog.setNeed(2, dog.m_pxNeeds[2] + 24576);
                }
            }
        }
        if (this.m_xActivateInterest > -1) {
            this.m_xInterestLevel = this.m_xActivateInterest;
        }
        this.m_xInterestRate = this.m_xActiveInterestRate;
        if (this.m_xMinActiveInterest > -1) {
            this.m_xMinInterestLevel = this.m_xMinActiveInterest;
        }
        if (this.m_xMaxActiveInterest > -1) {
            this.m_xMaxInterestLevel = this.m_xMaxActiveInterest;
        }
        this.m_iGiveUpTimer = 0;
        super.onActivate();
    }

    public void onDeactivate() {
        PetsGame petsGame = (PetsGame)this.m_pParent;
        Dog dog = petsGame.m_pDog;
        Toy toy = null;
        Toy toy2 = null;
        if (this.m_xDeactivateInterest > -1) {
            this.m_xInterestLevel = this.m_xDeactivateInterest;
        }
        this.m_xInterestRate = this.m_xInactiveInterestRate;
        this.m_iGiveUpTimer = 0;
        if (petsGame != null && dog != null) {
            switch (this.m_iType) {
                case 0: {
                    dog.resetAllNeedRates();
                    dog.setDisplayFeedback(2, 2);
                    break;
                }
                case 3: {
                    if (dog.m_pCarry == petsGame.getItem(3)) break;
                    dog.resetAllNeedRates();
                    this.m_xInterestLevel = 0;
                    dog.setDisplayFeedback(2, 2);
                    break;
                }
                case 2: {
                    toy = petsGame.getItem(3);
                    toy2 = petsGame.getItem(0);
                    if (toy == null || toy != null && !toy.isMoving() || toy2 == null || toy2 != null && !toy2.isMoving()) {
                        for (int i = 1; i < 5; ++i) {
                            dog.resetNeedRate(i);
                        }
                    }
                    toy = petsGame.getItem(11);
                    toy2 = petsGame.getItem(10);
                    if (toy != null && toy.m_bVisible) {
                        toy.m_xInterestLevel = 409600;
                        break;
                    }
                    if (toy2 == null || !toy2.m_bVisible) break;
                    toy2.m_xInterestLevel = 409600;
                    break;
                }
                case 5: {
                    AnimObject animObject = petsGame.m_pFood;
                    if (dog.m_pxTargetNeeds[3] <= 0) break;
                    if (animObject != null) {
                        animObject.m_bVisible = false;
                    }
                    dog.resetAllNeedRates();
                    dog.setNeedRate(0, -12288);
                    dog.setDisplayFeedback(3, 3);
                    break;
                }
                case 4: {
                    if (dog.m_bSleeping) {
                        dog.m_bSleeping = false;
                    }
                    dog.resetNeedRate(1);
                    dog.setDisplayFeedback(1, 2);
                    break;
                }
                case 9: {
                    this.m_bAttackPlant = false;
                }
            }
        }
        super.onDeactivate();
    }

    public void onIdle(int n) {
        if (this.m_iGiveUpTimer > 0) {
            this.m_iGiveUpTimer -= n;
            if (this.m_iGiveUpTimer <= 0) {
                this.m_iGiveUpTimer = 0;
            }
        }
        if (this.m_iInteractDelay > 0) {
            this.m_iInteractDelay -= n;
            if (this.m_iInteractDelay < 0) {
                this.m_iInteractDelay = 0;
            }
        }
        if (this.m_iAttackPlantTimer > 0) {
            this.m_iAttackPlantTimer -= n;
            if (this.m_iAttackPlantTimer < 0) {
                this.m_iAttackPlantTimer = 0;
            }
        }
        super.onIdle(n);
    }

    public void onHandleIsoContainment(int[] nArray) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        PetsGame petsGame = (PetsGame)this.m_pParent;
        Dog dog = petsGame.m_pDog;
        int n = 0;
        boolean bl = false;
        int n2 = -this.m_xVelocity[2];
        int[] nArray2 = new int[4];
        int[] nArray3 = petsGame.toIsoCoord(this.m_xWorldLeft, this.m_xWorldTop);
        nArray2[0] = nArray3[0];
        nArray3 = petsGame.toIsoCoord(this.m_xWorldRight, this.m_xWorldBottom);
        nArray2[2] = nArray3[0];
        if (nArray2[0] <= nArray[0] && nArray2[2] < nArray[2] || nArray2[0] > nArray[0] && nArray2[2] >= nArray[2]) {
            this.m_xVelocity[0] = -this.m_xVelocity[0];
            this.m_xAccel[0] = -this.m_xAccel[0];
            if (nArray2[0] <= nArray[0]) {
                n = nArray[0] - nArray2[0];
                ++n;
            } else {
                n = nArray[2] - nArray2[2];
                --n;
            }
            if (n2 >= 12288) {
                petsApp.playSound(12);
            }
        }
        this.m_xVelocity[0] = this.m_xVelocity[0] - (this.m_xVelocity[0] >> 2);
        this.m_xVelocity[1] = this.m_xVelocity[1] - (this.m_xVelocity[1] >> 2);
        nArray3 = petsGame.toWorldCoord(n, 0);
        n = nArray3[0];
        this.setWorldLocation(this.m_xWorldX + n, this.m_xWorldY, this.m_xWorldZ);
        if (dog != null && this.m_xWorldZ < 0 && dog.m_pCarry == null) {
            n2 -= n2 >> 1;
            if (this.m_iType != 3) {
                this.stopMovement();
            }
            Toy toy = null;
            if (this.m_xInterestLevel < 409600) {
                this.m_xInterestLevel = 409600;
                if (dog.m_iAction != 8) {
                    dog.interrupt(0, 0, this);
                }
                if ((toy = petsGame.getItem(2)) != null) {
                    toy.m_xInterestLevel = 409600;
                }
            }
            if (n2 <= 4096 || this.m_iType == 0) {
                this.m_xVelocity[2] = 0;
                this.m_xAccel[2] = 0;
                this.stopMovement();
            } else {
                this.m_xVelocity[2] = n2;
                if (n2 >= 12288) {
                    petsApp.playSound(12);
                }
            }
            this.setWorldZ(0);
        }
    }

    public boolean onCheckIsoContainment(int[] nArray) {
        PetsGame petsGame = (PetsGame)this.m_pParent;
        int[] nArray2 = new int[4];
        int[] nArray3 = petsGame.toIsoCoord(this.m_xWorldLeft, this.m_xWorldTop);
        nArray2[0] = nArray3[0];
        nArray3 = petsGame.toIsoCoord(this.m_xWorldRight, this.m_xWorldBottom);
        nArray2[2] = nArray3[0];
        if (!this.m_bNoContainment) {
            switch (this.m_iType) {
                case 0: 
                case 3: {
                    if (nArray2[0] <= nArray[0] && nArray2[2] < nArray[2] || nArray2[0] > nArray[0] && nArray2[2] >= nArray[2]) {
                        return true;
                    }
                    if (this.m_xWorldZ >= 0) break;
                    return true;
                }
                default: {
                    if ((nArray2[0] > nArray[0] || nArray2[2] >= nArray[2]) && (nArray2[0] <= nArray[0] || nArray2[2] < nArray[2])) break;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean onLoadResource(int n) {
        boolean bl = super.onLoadResource(n);
        if (bl) {
            this.setState(0, 0, false);
        }
        return bl;
    }
}

