/*
 * Decompiled with CFR 0.152.
 */
package sims_pets;

import sims_pets.AnimObject;
import sims_pets.Box;
import sims_pets.DeviceInfo;
import sims_pets.GameApp;
import sims_pets.GameObject;
import sims_pets.GameScene;
import sims_pets.PetsApp;
import sims_pets.TextObject;

public class MetaGameScene
extends GameScene {
    public static final int kTxtGoals = 600;
    public static final int kBoxPreview = 602;
    public static final int kTxtName = 603;
    public static final int kAnimArrowUp = 605;
    public static final int kAnimArrowDown = 606;
    public static final int kBoxBackground = 607;
    private Box m_pboxPreview;
    private TextObject m_ptxtName;
    private TextObject m_ptxtGoals;
    private AnimObject m_pAnmArrowUp;
    private AnimObject m_pAnmArrowDown;
    private AnimObject m_pDog;
    private AnimObject[] m_ppanmParts = new AnimObject[4];
    private int m_iSuperProgress;

    public MetaGameScene() {
        super(71);
    }

    protected final void loadAvatarFace() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n = petsApp.getSimPartOption(0);
        int n2 = petsApp.getSimPartOption(1);
        int n3 = petsApp.getSimPartOption(2);
        int n4 = petsApp.getSimPartOption(3);
        int n5 = this.m_pboxPreview.m_iLeft + (this.m_pboxPreview.getWidth() >> 1);
        int n6 = this.m_pboxPreview.m_iTop + (this.m_pboxPreview.getHeight() >> 1);
        int n7 = this.m_pboxPreview.m_iZ;
        AnimObject animObject = new AnimObject();
        if (animObject != null) {
            animObject.setPaletteResID(DeviceInfo.k_iSimPartOptions[1][n2][0]);
            animObject.onLoadResource(DeviceInfo.k_iSimPartOptions[0][n][0]);
            animObject.setZ(n7);
            animObject.setState(petsApp.getAvatarMoodState(petsApp.getAvatarMoodLevel()), 0, false);
            this.m_ppanmParts[0] = animObject;
            animObject = null;
        }
        if ((animObject = new AnimObject()) != null) {
            animObject.setPaletteResID(DeviceInfo.k_iSimPartOptions[3][n4][0]);
            animObject.onLoadResource(DeviceInfo.k_iSimPartOptions[2][n][0]);
            animObject.setZ(n7 + 4096);
            animObject.setState(n3, 0, false);
            this.m_ppanmParts[1] = animObject;
            animObject = null;
        }
        for (int i = 0; i < 2; ++i) {
            if (this.m_ppanmParts[i] == null) continue;
            this.m_ppanmParts[i].setLocation(n5, n6);
            this.addObject(this.m_ppanmParts[i]);
            this.m_ppanmParts[i].setVisible(false);
        }
    }

    protected final void loadDogGoals() {
        byte[] byArray;
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        if (this.m_pAnmArrowDown != null && this.m_pAnmArrowUp != null) {
            this.m_pAnmArrowDown.m_bVisible = true;
            this.m_pAnmArrowUp.m_bVisible = false;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.m_ppanmParts[i] == null) continue;
            this.m_ppanmParts[i].setVisible(false);
        }
        if (this.m_pDog != null) {
            this.m_pDog.m_bVisible = true;
        }
        if (this.m_ptxtName != null) {
            this.m_ptxtName.setText(petsApp.getPetName(), false);
        }
        if (this.m_ptxtGoals != null && (byArray = this.getDogGoalBuffer()) != null) {
            this.m_ptxtGoals.setText(byArray, true);
        }
    }

    protected final void loadSimGoals() {
        byte[] byArray;
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        if (this.m_pAnmArrowDown != null && this.m_pAnmArrowUp != null) {
            this.m_pAnmArrowDown.m_bVisible = false;
            this.m_pAnmArrowUp.m_bVisible = true;
        }
        if (this.m_pDog != null) {
            this.m_pDog.m_bVisible = false;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.m_ppanmParts[i] == null) continue;
            this.m_ppanmParts[i].setVisible(true);
        }
        if (this.m_ptxtName != null) {
            this.m_ptxtName.setText(petsApp.getUserName(), false);
        }
        if (this.m_ptxtGoals != null && (byArray = this.getSimGoalBuffer()) != null) {
            this.m_ptxtGoals.setText(byArray, false);
        }
    }

    protected final byte[] getDogGoalBuffer() {
        byte[] byArray;
        int n;
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        byte[] byArray2 = null;
        byte[][] byArrayArray = new byte[6][];
        int n2 = petsApp.getLastLearnedTrickMask();
        for (n = 1; n < 6; ++n) {
            byArrayArray[n] = null;
        }
        byArrayArray[0] = petsApp.getPetName();
        if (n2 > 0) {
            byArray = GameApp.loadStringResource(272);
            byArrayArray[1] = GameApp.loadStringResource(n2);
        } else {
            byArray = GameApp.loadStringResource(274);
        }
        byte[] byArray3 = null;
        byte[][] byArrayArray2 = new byte[1][];
        block6: for (n = 0; n < 4; ++n) {
            int n3 = petsApp.getCurrentMetaGoal(n);
            int n4 = (n3 & 0xFFFF0000) >> 16;
            int n5 = -1;
            for (int i = n3 & 0xFFFF; i != 0; i >>= 1) {
                ++n5;
            }
            if (n5 < 0) continue;
            switch (n4) {
                case 0: {
                    byArray3 = GameApp.loadStringResource(275);
                    byArrayArray2[0] = GameApp.loadStringResource(DeviceInfo.k_iMetaGoalList[n5][n4]);
                    byArrayArray[n + 2] = GameApp.formatStringBuffer(byArray3, byArrayArray2, 1);
                    GameApp.releaseStringBuffer(byArray3);
                    GameApp.releaseStringBuffer(byArrayArray2[0]);
                    continue block6;
                }
                case 1: {
                    byArray3 = GameApp.loadStringResource(276);
                    byArrayArray2[0] = GameApp.loadStringResource(DeviceInfo.k_iMetaGoalList[n5][n4]);
                    byArrayArray[n + 2] = GameApp.formatStringBuffer(byArray3, byArrayArray2, 1);
                    GameApp.releaseStringBuffer(byArray3);
                    GameApp.releaseStringBuffer(byArrayArray2[0]);
                    continue block6;
                }
                case 2: 
                case 3: {
                    byArrayArray[n + 2] = GameApp.loadStringResource(DeviceInfo.k_iMetaGoalList[n5][n4]);
                }
            }
        }
        byArray2 = GameApp.formatStringBuffer(byArray, byArrayArray, 6);
        GameApp.releaseStringBuffer(byArray);
        for (n = 1; n < 6; ++n) {
            if (byArrayArray[n] == null) continue;
            GameApp.releaseStringBuffer(byArrayArray[n]);
        }
        return byArray2;
    }

    protected final byte[] getSimGoalBuffer() {
        byte[] byArray;
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        byte[][] byArrayArray = new byte[3][];
        int n = petsApp.getAvatarRank();
        byArrayArray[0] = null;
        byArrayArray[1] = null;
        int n2 = DeviceInfo.k_iSimGoalInfo[n][0];
        if (n2 > 0) {
            byArrayArray[0] = GameApp.loadStringResource(n2);
        }
        if ((n2 = DeviceInfo.k_iSimGoalInfo[++n][0]) > 0) {
            byArray = GameApp.loadStringResource(273);
            byArrayArray[1] = GameApp.loadStringResource(n2);
        } else {
            byArray = GameApp.loadStringResource(202);
        }
        byArrayArray[2] = GameApp.getStringBufferForNumber(petsApp.getCurrentSimoleons());
        byte[] byArray2 = GameApp.formatStringBuffer(byArray, byArrayArray, 3);
        for (n2 = 0; n2 < 3; ++n2) {
            if (byArrayArray[n2] == null) continue;
            GameApp.releaseStringBuffer(byArrayArray[n2]);
        }
        return byArray2;
    }

    public int onOpen() {
        return super.onOpen();
    }

    public int onClose() {
        return super.onClose();
    }

    public int onLoad(int n) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n2 = n;
        switch (n) {
            case 0: {
                this.m_iSuperProgress = super.onLoad(this.m_iSuperProgress);
                if (this.m_iSuperProgress < 100) break;
                if (petsApp.getUserExists()) {
                    n2 = 50;
                    break;
                }
                n2 = 96;
                break;
            }
            case 60: {
                this.loadAvatarFace();
                n2 = 80;
                break;
            }
            case 80: {
                this.m_pDog = new AnimObject();
                if (this.m_pDog != null) {
                    int n3 = petsApp.getPetPartOption(0);
                    int n4 = petsApp.getPetPartOption(1);
                    this.m_pDog.m_sLoadMaskOption = 0;
                    this.m_pDog.setPaletteResID(DeviceInfo.k_iDogBreedParts[n3][2 + n4][0]);
                    this.m_pDog.onLoadResource(DeviceInfo.k_iDogBreedParts[n3][1][0]);
                    this.addObject(this.m_pDog);
                    this.m_pDog.setLocation(this.m_pboxPreview.m_iLeft + (this.m_pboxPreview.getWidth() >> 1), this.m_pboxPreview.m_iTop + (this.m_pboxPreview.getHeight() >> 1) + (this.m_pDog.getHeight() >> 1));
                }
                n2 = 96;
                break;
            }
            default: {
                if ((n2 += 2) <= 100) break;
                n2 = 100;
            }
        }
        return n2;
    }

    public boolean onAddObject(GameObject gameObject) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        if (gameObject != null) {
            int n = gameObject.m_iInstanceID;
            switch (n) {
                case 600: {
                    this.m_ptxtGoals = (TextObject)gameObject;
                    break;
                }
                case 602: {
                    this.m_pboxPreview = (Box)gameObject;
                    break;
                }
                case 603: {
                    this.m_ptxtName = (TextObject)gameObject;
                    this.loadDogGoals();
                    break;
                }
                case 605: {
                    this.m_pAnmArrowUp = (AnimObject)gameObject;
                    break;
                }
                case 606: {
                    this.m_pAnmArrowDown = (AnimObject)gameObject;
                    this.m_pAnmArrowDown.m_bVisible = true;
                    break;
                }
                case 607: {
                    Box box = (Box)gameObject;
                    box.m_iStyle = 5;
                }
            }
        }
        return super.onAddObject(gameObject);
    }

    public void onCheckKeysChanged() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n = petsApp.m_iKeysChanged;
        if ((n & 0x60000) != 0) {
            petsApp.closeScene(this);
            return;
        }
        if ((n & 0x1004) != 0) {
            if (this.m_pAnmArrowUp.m_bVisible) {
                this.loadDogGoals();
            }
            return;
        }
        if ((n & 0x2100) != 0) {
            if (this.m_pAnmArrowDown.m_bVisible) {
                this.loadSimGoals();
            }
            return;
        }
        super.onCheckKeysChanged();
    }
}

