/*
 * Decompiled with CFR 0.152.
 */
package sims_pets;

import javax.microedition.lcdui.Graphics;
import sims_pets.AnimObject;
import sims_pets.Box;
import sims_pets.DeviceInfo;
import sims_pets.GameApp;
import sims_pets.GameObject;
import sims_pets.MenuScene;
import sims_pets.PetsApp;
import sims_pets.TextObject;

public class MainMenuScene
extends MenuScene {
    public static final int kBoxAvatarPreview = 200;
    public static final int kBoxDogPreview = 201;
    public static final int kBoxBackground = 202;
    public static final int kTxtDogName = 300;
    public static final int kTxtAnd = 301;
    public static final int kTxtSimName = 302;
    public static final int kAnmTitle = 400;
    private Box m_pboxAvatar;
    private Box m_pboxDog;
    private TextObject m_ptxtDogName;
    private TextObject m_ptxtAnd;
    private TextObject m_ptxtSimName;
    private int m_iSuperProgress;

    public MainMenuScene() {
        super(70);
    }

    private final void setupScene(boolean bl) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        if (bl) {
            if (this.m_ptxtDogName != null) {
                this.m_ptxtDogName.setText(petsApp.getPetName(), false);
            }
            if (this.m_ptxtSimName != null) {
                this.m_ptxtSimName.setText(petsApp.getUserName(), false);
            }
        }
        if (this.m_ptxtDogName != null) {
            this.m_ptxtDogName.m_bVisible = bl;
        }
        if (this.m_ptxtAnd != null) {
            this.m_ptxtAnd.m_bVisible = bl;
        }
    }

    private final void loadAvatarFace() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        AnimObject[] animObjectArray = new AnimObject[4];
        int n = petsApp.getSimPartOption(0);
        int n2 = petsApp.getSimPartOption(1);
        int n3 = petsApp.getSimPartOption(2);
        int n4 = petsApp.getSimPartOption(3);
        int n5 = this.m_pboxAvatar.m_iLeft + (this.m_pboxAvatar.getWidth() >> 1);
        int n6 = this.m_pboxAvatar.m_iTop + (this.m_pboxAvatar.getHeight() >> 1);
        int n7 = this.m_pboxAvatar.m_iZ;
        AnimObject animObject = new AnimObject();
        if (animObject != null) {
            animObject.setPaletteResID(DeviceInfo.k_iSimPartOptions[1][n2][0]);
            animObject.onLoadResource(DeviceInfo.k_iSimPartOptions[0][n][0]);
            animObject.setZ(n7);
            animObject.setState(2, 0, false);
            animObjectArray[0] = animObject;
            animObject = null;
        }
        if ((animObject = new AnimObject()) != null) {
            animObject.setPaletteResID(DeviceInfo.k_iSimPartOptions[3][n4][0]);
            animObject.onLoadResource(DeviceInfo.k_iSimPartOptions[2][n][0]);
            animObject.setZ(n7 + 4096);
            animObject.setState(n3, 0, false);
            animObjectArray[1] = animObject;
            animObject = null;
        }
        for (int i = 0; i < 2; ++i) {
            if (animObjectArray[i] == null) continue;
            animObjectArray[i].setLocation(n5, n6);
            this.addObject(animObjectArray[i]);
        }
    }

    public boolean onAddObject(GameObject gameObject) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n = gameObject.m_iInstanceID;
        switch (n) {
            case 400: {
                gameObject.m_bVisible = !petsApp.getUserExists();
                break;
            }
            case 200: {
                this.m_pboxAvatar = (Box)gameObject;
                break;
            }
            case 201: {
                this.m_pboxDog = (Box)gameObject;
                break;
            }
            case 202: {
                Box box = (Box)gameObject;
                box.m_iStyle = 8;
                box.m_bVisible = petsApp.getUserExists();
                break;
            }
            case 300: {
                this.m_ptxtDogName = (TextObject)gameObject;
                break;
            }
            case 301: {
                this.m_ptxtAnd = (TextObject)gameObject;
                break;
            }
            case 302: {
                this.m_ptxtSimName = (TextObject)gameObject;
            }
        }
        return super.onAddObject(gameObject);
    }

    public int onLoad(int n) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n2 = n;
        switch (n) {
            case 0: {
                this.m_iSuperProgress = super.onLoad(this.m_iSuperProgress);
                if (this.m_iSuperProgress < 100) break;
                n2 = 9;
                break;
            }
            case 29: {
                if (petsApp.getUserExists()) {
                    this.loadAvatarFace();
                }
                n2 = 39;
                break;
            }
            case 59: {
                AnimObject animObject;
                if (petsApp.getUserExists() && (animObject = new AnimObject()) != null) {
                    int n3 = petsApp.getPetPartOption(0);
                    int n4 = petsApp.getPetPartOption(1);
                    animObject.m_sLoadMaskOption = 0;
                    animObject.setPaletteResID(DeviceInfo.k_iDogBreedParts[n3][2 + n4][0]);
                    animObject.onLoadResource(DeviceInfo.k_iDogBreedParts[n3][1][0]);
                    this.addObject(animObject);
                    animObject.setState(1, 0, false);
                    animObject.setLocation(this.m_pboxDog.m_iX + (this.m_pboxDog.getWidth() >> 1), this.m_pboxDog.m_iY + this.m_pboxDog.getHeight());
                }
                n2 = 69;
                break;
            }
            default: {
                if ((n2 += 5) <= 100) break;
                n2 = 100;
            }
        }
        return n2;
    }

    public int onOpen() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        this.setupScene(petsApp.getUserExists());
        return super.onOpen();
    }

    public void onPaintLoading(Graphics graphics, int n) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        petsApp.drawLoadingBar(graphics, n, Short.MAX_VALUE);
        super.onPaintLoading(graphics, n);
    }
}

