/*
 * Decompiled with CFR 0.152.
 */
package sims_pets;

import javax.microedition.lcdui.Graphics;
import sims_pets.ArrayList;
import sims_pets.GameApp;
import sims_pets.GameObject;

public class Scene
extends GameObject {
    public static final int kSceneError = -1;
    public static final int kSceneOK = 0;
    protected ArrayList m_listObjects;
    protected ArrayList m_listRemoved;
    protected boolean m_bSortList;
    protected int[] m_rctViewPort = new int[4];
    protected int m_iViewPortWidth;
    protected int m_iViewPortHeight;
    protected GameObject m_pAcceptSoftKey;
    protected GameObject m_pCancelSoftKey;
    protected int[] m_rctWorking = new int[4];
    protected int[] m_rctWorldPort = new int[4];
    protected boolean m_bTransparent;

    public Scene() {
        this.m_listObjects = new ArrayList();
        this.m_listRemoved = new ArrayList();
        this.setViewPort(0, 0, GameApp.m_instance.m_iScreenWidth << 12, GameApp.m_instance.m_iScreenHeight << 12);
        this.m_rctWorldPort[0] = this.m_iX;
        this.m_rctWorldPort[1] = this.m_iY;
        this.m_rctWorldPort[2] = this.m_rctWorldPort[0] + this.m_iViewPortWidth;
        this.m_rctWorldPort[3] = this.m_rctWorldPort[1] + this.m_iViewPortHeight;
    }

    public void setSortObjects(boolean bl) {
        this.m_bSortList = bl;
    }

    public final void sortObjects() {
        if (this.m_listObjects.elementCount > 1 && this.m_bSortList) {
            this.sortObjects(0, this.m_listObjects.elementCount - 1, this.m_listObjects);
            this.m_bSortList = false;
        }
    }

    protected final void sortObjects(int n, int n2, ArrayList arrayList) {
        int n3 = n;
        int n4 = n2;
        if (n3 >= n4) {
            return;
        }
        if (n3 == n4 - 1) {
            if (((GameObject)arrayList.elementData[n3]).m_iZ > ((GameObject)arrayList.elementData[n4]).m_iZ) {
                Object object = arrayList.elementData[n3];
                arrayList.elementData[n3] = arrayList.elementData[n4];
                arrayList.elementData[n4] = object;
            }
            return;
        }
        Object object = arrayList.elementData[n3 + n4 >> 1];
        arrayList.elementData[n3 + n4 >> 1] = arrayList.elementData[n4];
        arrayList.elementData[n4] = object;
        while (n3 < n4) {
            while (((GameObject)arrayList.elementData[n3]).m_iZ <= ((GameObject)object).m_iZ && n3 < n4) {
                ++n3;
            }
            while (((GameObject)object).m_iZ <= ((GameObject)arrayList.elementData[n4]).m_iZ && n3 < n4) {
                --n4;
            }
            if (n3 >= n4) continue;
            Object object2 = arrayList.elementData[n3];
            arrayList.elementData[n3] = arrayList.elementData[n4];
            arrayList.elementData[n4] = object2;
        }
        arrayList.elementData[n2] = arrayList.elementData[n4];
        arrayList.elementData[n4] = object;
        this.sortObjects(n, n3 - 1, arrayList);
        this.sortObjects(n4 + 1, n2, arrayList);
    }

    public void addObject(GameObject gameObject) {
        this.m_listObjects.addElement(gameObject);
        gameObject.m_pParent = this;
        this.m_bSortList = true;
    }

    public void removeObject(GameObject gameObject) {
    }

    public void releaseObjects() {
        GameObject gameObject;
        int n;
        for (n = 0; n < this.m_listObjects.elementCount; ++n) {
            gameObject = (GameObject)this.m_listObjects.elementData[n];
            int n2 = this.m_listRemoved.indexOf(gameObject, 0);
            if (n2 != -1) {
                this.m_listRemoved.removeElementAt(n2);
            }
            gameObject.onReleaseResource();
        }
        this.m_listObjects.removeAllElements();
        for (n = 0; n < this.m_listRemoved.elementCount; ++n) {
            gameObject = (GameObject)this.m_listRemoved.elementData[n];
            gameObject.onReleaseResource();
        }
        this.m_listRemoved.removeAllElements();
    }

    public GameObject getAcceptSoftKey() {
        return this.m_pAcceptSoftKey;
    }

    public GameObject getCancelSoftKey() {
        return this.m_pCancelSoftKey;
    }

    public boolean isRectInViewPort(int[] nArray) {
        return Math.max(nArray[0], this.m_rctWorldPort[0]) < Math.min(nArray[2], this.m_rctWorldPort[2]) && Math.max(nArray[1], this.m_rctWorldPort[1]) < Math.min(nArray[3], this.m_rctWorldPort[3]);
    }

    public boolean isRectFullyInViewPort(int[] nArray) {
        return nArray[1] >= this.m_rctWorldPort[1] && nArray[3] <= this.m_rctWorldPort[3] && nArray[0] >= this.m_rctWorldPort[0] && nArray[2] <= this.m_rctWorldPort[2];
    }

    public void setViewPort(int n, int n2, int n3, int n4) {
        this.m_rctViewPort[0] = n;
        this.m_rctViewPort[1] = n2;
        this.m_rctViewPort[2] = n3;
        this.m_rctViewPort[3] = n4;
        this.m_iViewPortWidth = n3 - n;
        this.m_iViewPortHeight = n4 - n2;
        this.m_rctWorldPort[0] = this.m_iX;
        this.m_rctWorldPort[1] = this.m_iY;
        this.m_rctWorldPort[2] = this.m_rctWorldPort[0] + this.m_iViewPortWidth;
        this.m_rctWorldPort[3] = this.m_rctWorldPort[1] + this.m_iViewPortHeight;
    }

    public int getViewPortWidth() {
        return this.m_iViewPortWidth;
    }

    public int getViewPortHeight() {
        return this.m_iViewPortHeight;
    }

    int[] getWorkingRect() {
        return this.m_rctWorking;
    }

    int[] getViewPortRect() {
        return this.m_rctViewPort;
    }

    public void setTransparent(boolean bl) {
        this.m_bTransparent = bl;
    }

    public boolean getTransparent() {
        return this.m_bTransparent;
    }

    public int onOpen() {
        return 0;
    }

    public int onClose() {
        this.releaseObjects();
        return 0;
    }

    public int onLoad(int n) {
        return 100;
    }

    public void onSuspend() {
    }

    public void onResume() {
    }

    public void onPauseApp() {
    }

    public void onResumeApp() {
    }

    public boolean onKeyPressed(int n) {
        return false;
    }

    public boolean onKeyReleased(int n) {
        return false;
    }

    public void onCheckKeysChanged() {
    }

    public void onPaint(Graphics graphics) {
        for (int i = 0; i < this.m_listObjects.elementCount; ++i) {
            GameObject gameObject = (GameObject)this.m_listObjects.elementData[i];
            if (!gameObject.m_bVisible) continue;
            int n = (gameObject.m_iLeft >> 12) - (this.m_iX >> 12);
            int n2 = (gameObject.m_iTop >> 12) - (this.m_iY >> 12);
            int n3 = (gameObject.m_iRight >> 12) - (this.m_iX >> 12);
            int n4 = (gameObject.m_iBottom >> 12) - (this.m_iY >> 12);
            int n5 = n;
            int n6 = n2;
            if (n < this.m_rctViewPort[0] >> 12) {
                n = this.m_rctViewPort[0] >> 12;
            }
            if (n2 < this.m_rctViewPort[1] >> 12) {
                n2 = this.m_rctViewPort[1] >> 12;
            }
            if (n3 > this.m_rctViewPort[2] >> 12) {
                n3 = this.m_rctViewPort[2] >> 12;
            }
            if (n4 > this.m_rctViewPort[3] >> 12) {
                n4 = this.m_rctViewPort[3] >> 12;
            }
            if (n >= n3 || n2 >= n4) continue;
            gameObject.onPaint(graphics, n, n2, n3 - n, n4 - n2, n - n5, n2 - n6);
        }
    }

    public void onPaintLoading(Graphics graphics, int n) {
    }

    public void onReloadText() {
        for (int i = 0; i < this.m_listObjects.elementCount; ++i) {
            GameObject gameObject = (GameObject)this.m_listObjects.elementData[i];
            gameObject.onReloadText();
        }
    }

    public void onIdle(int n) {
        GameObject gameObject;
        int n2;
        this.m_rctWorldPort[0] = this.m_iX;
        this.m_rctWorldPort[1] = this.m_iY;
        this.m_rctWorldPort[2] = this.m_rctWorldPort[0] + this.m_iViewPortWidth;
        this.m_rctWorldPort[3] = this.m_rctWorldPort[1] + this.m_iViewPortHeight;
        for (n2 = 0; n2 < this.m_listObjects.elementCount; ++n2) {
            gameObject = (GameObject)this.m_listObjects.elementData[n2];
            gameObject.onIdle(n);
        }
        for (n2 = this.m_listObjects.elementCount - 1; n2 >= 0; --n2) {
            gameObject = (GameObject)this.m_listObjects.elementData[n2];
            if (!gameObject.m_bRemove) continue;
            gameObject.m_bRemove = false;
            this.m_listObjects.removeElementAt(n2);
            this.m_listRemoved.addElement(gameObject);
        }
    }

    public void onPaint(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }
}

