/*
 * Decompiled with CFR 0.152.
 */
package sims_pets;

import javax.microedition.lcdui.Graphics;
import sims_pets.AnimObject;
import sims_pets.ArrayList;
import sims_pets.Box;
import sims_pets.DeviceInfo;
import sims_pets.DialogScene;
import sims_pets.Dog;
import sims_pets.GameApp;
import sims_pets.GameObject;
import sims_pets.GameScene;
import sims_pets.Interactive;
import sims_pets.MetaGameScene;
import sims_pets.PetsApp;
import sims_pets.PetsGame;
import sims_pets.StoreScene;
import sims_pets.TextObject;
import sims_pets.Toy;

public class HudScene
extends GameScene {
    public static final int kBackgroundAreaID = 2000;
    public static final int kSoftKeyAreaID = 2001;
    public static final int kViewAreaID = 2002;
    public static final int kMotiveAreaBaseID = 2010;
    public static final int kTxtSimoleons = 2100;
    public static final int kTxtSelection = 2110;
    public static final int kTxtTrainer = 2120;
    public static final int kAnmTrainer = 2121;
    public static final int kBoxTrainerBG = 2122;
    public static final int kTxtAvatar = 2130;
    public static final int kAnmAvatar = 2131;
    public static final int kAnmAvatarMood = 2132;
    public static final int kAvatarBalloon = 2133;
    public static final int kBarAvatarMood = 2134;
    public static final int kBoxAvatarBG = 2135;
    public static final int kAnmAvatarSpeech = 2136;
    public static final int kBoxAvatarBalloon = 10;
    public static final int kInteractionItemBaseID = 2200;
    public static final int kCommandLearnedItemBaseID = 2210;
    public static final int kCommandLearningItemBaseID = 2220;
    public static final int kCommandSequenceBaseID = 2230;
    public static final int kCommandLearnedArrowUpID = 2701;
    public static final int kCommandLearnedArrowDownID = 2702;
    public static final int kCommandLearningArrowUpID = 2703;
    public static final int kCommandLearningArrowDownID = 2704;
    public static final int kInteractionFrameBaseID = 2300;
    public static final int kCommandLearnedFrameBaseID = 2310;
    public static final int kCommandLearningFrameBaseID = 2320;
    public static final int kInteractionHighlightID = 2400;
    public static final int kActionAreaID = 2500;
    public static final int kActionSelectedTextID = 2501;
    public static final int kActionArrowPrevItemID = 2502;
    public static final int kActionArrowNextItemID = 2503;
    public static final int kActionArrowPrevSubItemID = 2504;
    public static final int kActionArrowNextSubItemID = 2505;
    public static final int kActionIconHighlightID = 2506;
    public static final int kActionItemBaseID = 2510;
    public static final int kActionItemFrameBaseID = 2520;
    public static final int kActionItemStatusBaseID = 2530;
    public static final int kListAreaID = 2600;
    public static final int kListArrowPrevItemID = 2602;
    public static final int kListArrowNextItemID = 2603;
    public static final int kListIconHighlightID = 2606;
    public static final int kListItemBaseID = 2610;
    public static final int kListItemFrameBaseID = 2620;
    public static final int kListItemDescBaseID = 2630;
    public static final int kListItemStatusBaseID = 2640;
    public static final int kMotiveImageBaseID = 3000;
    public static final int kMotiveValueBaseID = 4001;
    public static final int kAnmCursor = 4200;
    public static final int kBarThrowing = 4202;
    public static final int kAnmThrowingArrow = 4203;
    public static final int kBarThrowingDisc = 4204;
    public static final int kAnmThrowDiscArrow = 4205;
    public static final int kAnmPetMood = 6002;
    public static final int kBoxInputTimer = 6007;
    public static final int kAnmBubble = 7001;
    public static final int kAnmMotive = 7002;
    public static final int kAnmFeedbackMotive = 8001;
    public static final int kAnmFeedbackChange = 8002;
    public static final int kTxtFeedbackMotive = 8003;
    public static final int kBoxFeedbackAreaHL = 8004;
    public static final int kCursorStateSelector = 0;
    public static final int kCursorStatePoint = 1;
    public static final int kCursorStatePet = 2;
    public static final int kCursorStateBrush = 3;
    public static final int kCursorStateSponge = 4;
    public static final int kMaxContextItemCount = 27;
    public static final int kContextMenuCancel = -1;
    public static final int kInteractionMenuPet = 0;
    public static final int kInteractionMenuCommand = 1;
    public static final int kInteractionMenuScold = 2;
    public static final int kInteractionMenuPraise = 3;
    public static final int kNumInteractions = 4;
    public static final int kPutAwaySuppliesInstanceID = 1000;
    public static final int kCommandGroupLearned = 0;
    public static final int kCommandGroupLearning = 1;
    public static final int kNumCommandGroups = 2;
    public static final int kCommandSequenceTimeLimit = 5000;
    public static final int kTLCSequenceTimeLimit = 5000;
    public static final int kMaxNumMenuItems = 32;
    public static final int kMenuItemInfoStringID = 0;
    public static final int kMenuItemInfoState = 1;
    public static final int kMenuItemInfoInstID = 2;
    public static final int kMenuItemInfoStatID = 3;
    public static final int kNumMenuItemInfo = 4;
    public static final int kMaxNumActionMenuLevels = 4;
    public static final int kAvatarTextTime = 3000;
    public static final int kCursorVisibleTime = 5000;
    public static final int kFeedbackIconVisibleTime = 3000;
    public static final int kAvatarMoodDegreeChangeSpeed = 102;
    public static final int kThrowDirectionDistance_X = 327680;
    public static final int kMoodSad = 0;
    public static final int kMoodNeutral = 1;
    public static final int kMoodHappy = 2;
    public static final int kPhaseDefault = 0;
    public static final int kPhaseActionMenu = 2;
    public static final int kPhaseSuppliesMenu = 3;
    public static final int kPhaseTrainingMenu = 4;
    public static final int kPhaseThrowDisc = 5;
    public static final int kPhaseThrowBall = 6;
    public static final int kPhaseTLC = 7;
    public static final int kPhaseTeaching = 8;
    public static final int kPhaseCalling = 9;
    public static final int kPhaseCommanding = 10;
    public static final int kPhaseLearning = 11;
    public static final int kPhaseInteractionMenu = 15;
    public static final int kPhaseCommandMenu = 16;
    public static final int kPhaseIncorrectTeaching = 17;
    public static final int kPhaseTrainerPopup = 18;
    public static final int kSimPartFace = 0;
    public static final int kSimPartHair = 1;
    public static final int kNumSimParts = 2;
    public static final int kSimTalkyFaceState = 4;
    protected AnimObject m_panmPetMood;
    protected Box m_pThrowingBar;
    protected Box m_pThrowingDiscBar;
    protected AnimObject m_pThrowingDiscArrow;
    protected Box m_pboxInputTimer;
    protected GameObject m_pAvatarBounds;
    protected GameObject m_pAvatarBalloon;
    protected AnimObject m_pAvatarSpeech;
    protected TextObject m_ptxtAvatar;
    protected TextObject m_ptxtSimoleons;
    protected AnimObject[] m_ppanmSimParts = new AnimObject[2];
    protected TextObject m_ptxtSelection;
    protected TextObject m_ptxtTrainer;
    protected ArrayList m_pListTrainer;
    protected AnimObject m_panmCursor;
    protected AnimObject m_panmBubble;
    protected AnimObject m_panmMotive;
    protected AnimObject m_panmFeedbackChange;
    protected AnimObject m_panmFeedbackMotive;
    protected TextObject m_ptxtFeedbackMotive;
    protected Box m_pboxFeedbackAreaHL;
    protected PetsGame m_pGame;
    protected Dog m_pDog;
    protected int m_xCursorSpeed = -1;
    protected int m_xCameraSpeed = -1;
    protected int[] m_xboxViewBounds = new int[4];
    protected int[] m_xboxCursorBounds = new int[4];
    protected int[] m_xrctCursor = new int[4];
    protected int m_iShowCursorTimer;
    protected int m_iSoapBubbleTimer;
    protected int m_iAvatarBalloonTimer;
    protected int m_xAvatarMoodLevel;
    protected int m_iStoredInteraction;
    protected int m_xThrowSuccess;
    protected int m_iReactAvatarTimer;
    protected int m_iReactState;
    protected int m_iPreTrainerPhase;
    protected int m_iBushSearchTimer;
    protected boolean m_bSearchTimerActive;
    protected boolean m_bFoundItem;
    protected boolean m_bMakeExcited;
    protected boolean m_bScolded;
    protected boolean m_bPraised;
    protected boolean m_bDoOpenPause;
    protected boolean m_bPauseMenuOpen;
    private boolean m_bGameLoaded;
    private int m_iHUDLayoutLoading;
    private int m_iPhase;
    private TextObject m_ptxtAcceptSoftKey;
    private TextObject m_ptxtCancelSoftKey;
    private Box[] m_pMotiveAreas = new Box[5];
    private Box[] m_pMeterBars = new Box[5];
    private Interactive m_pThrowingObject;
    private int m_iFeedbackDisplayTime;
    private int m_iKeyHeldMask;
    private int m_iKeyPressDuration;
    private TextObject[] m_ptxtContextItem = new TextObject[27];
    private int m_iContextItemCount;
    private int m_iCurContextItem;
    private AnimObject[] m_panmInteractionItem = new AnimObject[4];
    private AnimObject[] m_panmInteractionFrame = new AnimObject[4];
    private AnimObject[][] m_panmCommandItem = new AnimObject[2][10];
    private AnimObject[][] m_panmCommandFrame = new AnimObject[2][10];
    private GameObject[] m_pCommandArrowUp = new GameObject[2];
    private GameObject[] m_pCommandArrowDown = new GameObject[2];
    private AnimObject m_pInteractionItemHighlight;
    private int[] m_iNumCommandItemsPerPage = new int[2];
    private int[][] m_iCommandItems = new int[2][32];
    private int[] m_iNumCommandItems = new int[2];
    private int m_iCommandMenuCurItem;
    private int m_iCommandMenuCurGroup;
    private int[] m_iCommandMenuItemOffset = new int[2];
    private int m_iPraiseOrScold;
    private int m_iWantPraiseOrScold;
    private AnimObject[] m_panmCommandSequenceArrows = new AnimObject[5];
    private int m_xCommandSequenceBaseX;
    private int m_xCommandSequenceBaseY;
    private int[] m_iCommandSequenceKeys = new int[5];
    private int[] m_iCommandSequenceActions = new int[5];
    private int m_iCommandSequenceIndex;
    private int m_iCommandSequenceTimer;
    private boolean m_bCommandLearning;
    private int m_iTLCCommandKeyCounter;
    private Box m_pboxActionMenuBG;
    private TextObject m_ptxtActionItemSelected;
    private GameObject m_pActionItemIconHighlight;
    private GameObject m_pActionMenuArrowPrevItem;
    private GameObject m_pActionMenuArrowNextItem;
    private GameObject m_pActionMenuArrowPrevSubItem;
    private GameObject m_pActionMenuArrowNextSubItem;
    private AnimObject[] m_panmActionItem = new AnimObject[10];
    private Box[] m_pboxActionItemFrame = new Box[10];
    private TextObject[] m_ptxtActionItemStatus = new TextObject[10];
    private int m_iNumActionItemsPerPage;
    private int[][] m_iActionItems = new int[32][4];
    private int m_iNumActionItems;
    private int[] m_iActionMenuCurItem = new int[4];
    private int[] m_iActionMenuItemOffset = new int[4];
    private int[] m_iActionMenuStringID = new int[4];
    private int[] m_iActionMenuInstanceID = new int[4];
    private int m_iActionMenuCurLevel;
    private int[] m_iActionMenuCurSubItem = new int[32];
    private int[] m_iActionMenuTotSubItem = new int[32];
    private Box m_pboxListMenuBG;
    private GameObject m_pListItemIconHighlight;
    private GameObject m_pListMenuArrowPrevItem;
    private GameObject m_pListMenuArrowNextItem;
    private AnimObject[] m_panmListItem = new AnimObject[10];
    private Box[] m_pboxListItemFrame = new Box[10];
    private TextObject[] m_ptxtListItemDesc = new TextObject[10];
    private Box[] m_pboxListItemStatus = new Box[10];
    private int m_iNumListItemsPerPage;
    private int[][] m_iListItems = new int[32][4];
    private int m_iNumListItems;
    private int m_iListMenuCurItem;
    private int m_iListMenuItemOffset;
    private int m_iReopenMenu;

    public HudScene() {
        super(74);
        this.m_bPaintBackground = false;
        this.m_iStoredInteraction = -1;
        this.m_iReactAvatarTimer = 0;
        this.m_iReactState = -1;
    }

    private final void loadAvatarFace() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n = petsApp.getSimPartOption(0);
        int n2 = petsApp.getSimPartOption(1);
        int n3 = petsApp.getSimPartOption(2);
        int n4 = petsApp.getSimPartOption(3);
        int n5 = this.m_pAvatarBounds.m_iLeft + (this.m_pAvatarBounds.getWidth() >> 1);
        int n6 = this.m_pAvatarBounds.m_iTop + (this.m_pAvatarBounds.getHeight() >> 1);
        int n7 = this.m_pAvatarBounds.m_iZ;
        AnimObject animObject = new AnimObject();
        if (animObject != null) {
            animObject.setPaletteResID(DeviceInfo.k_iSimPartOptions[1][n2][0]);
            animObject.onLoadResource(DeviceInfo.k_iSimPartOptions[0][n][0]);
            animObject.setZ(n7);
            animObject.setState(2, 0, false);
            this.m_ppanmSimParts[0] = animObject;
            animObject = null;
        }
        if ((animObject = new AnimObject()) != null) {
            animObject.setPaletteResID(DeviceInfo.k_iSimPartOptions[3][n4][0]);
            animObject.onLoadResource(DeviceInfo.k_iSimPartOptions[2][n][0]);
            animObject.setZ(n7 + 4096);
            animObject.setState(n3, 0, false);
            this.m_ppanmSimParts[1] = animObject;
            animObject = null;
        }
        for (int i = 0; i < 2; ++i) {
            if (this.m_ppanmSimParts[i] == null) continue;
            this.m_ppanmSimParts[i].setLocation(n5, n6);
            this.addObject(this.m_ppanmSimParts[i]);
        }
    }

    private final void handleFoundItem() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        this.m_pDog.m_bFoundObject = false;
        if (this.m_pDog.m_pCarry != null) {
            this.m_pDog.m_pCarry.m_bVisible = false;
            this.m_pDog.onDogEvent(null, 403, null, 0);
        } else {
            this.m_pDog.onDogEvent(null, 407, null, 0);
        }
        this.m_pDog.dismiss();
        this.setPhase(0);
        int n = -1;
        int n2 = -1;
        switch (this.m_pDog.m_iFoundObjectType) {
            case 0: {
                n = 260;
                n2 = 196610;
                break;
            }
            case 1: {
                n = 261;
                break;
            }
            case 2: {
                n = 367;
                n2 = 196612;
                break;
            }
            case 3: {
                n = 59;
                n2 = 196616;
            }
        }
        if (n != -1) {
            petsApp.createGameMessage(31);
            petsApp.addStringToPopup(2001);
            petsApp.addStringToPopup(n);
            petsApp.addPopup();
        }
        if (n2 != -1) {
            petsApp.completeMetaGoal(n2);
        }
    }

    private final void resetSearchTimer() {
        if (this.m_bSearchTimerActive) {
            this.m_iBushSearchTimer = 0;
        }
    }

    private final void setSearchTimerEnabled(boolean bl) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        if (bl && !this.m_bFoundItem && petsApp.getCurrentLocation() == 1) {
            this.m_bSearchTimerActive = true;
            Toy toy = this.m_pGame.getItem(0);
            Toy toy2 = this.m_pGame.getItem(3);
            if (toy != null && toy.m_bVisible || toy2 != null && toy2.m_bVisible) {
                this.m_bSearchTimerActive = false;
            }
        } else {
            this.m_bSearchTimerActive = false;
        }
    }

    protected final void updateCursor(int n) {
        block45: {
            int n2;
            block43: {
                block44: {
                    if (this.m_ptxtSelection != null) {
                        this.m_ptxtSelection.m_bVisible = false;
                    }
                    if (this.m_panmCursor == null) {
                        return;
                    }
                    if (this.m_iShowCursorTimer > 0) {
                        this.m_iShowCursorTimer -= n;
                        if (this.m_iShowCursorTimer <= 0) {
                            this.m_iShowCursorTimer = 0;
                            this.m_panmCursor.m_bVisible = false;
                        }
                    }
                    PetsApp petsApp = (PetsApp)GameApp.m_instance;
                    int n3 = 0;
                    int n4 = 0;
                    n2 = 0;
                    int n5 = 0;
                    int n6 = petsApp.m_iKeysDown;
                    if (this.m_xCursorSpeed == -1 || this.m_xCameraSpeed == -1) {
                        this.m_xCursorSpeed = this.m_iWidth / 5000;
                        this.m_xCameraSpeed = this.m_pGame.getWidth() / 4500;
                    }
                    int n7 = this.m_xCursorSpeed * n;
                    int n8 = this.m_xCameraSpeed * n;
                    if ((this.m_iKeyHeldMask & n6) != 0) {
                        this.m_iKeyPressDuration += n >> 3;
                        n7 += GameApp.min(3 * n7, n7 * this.m_iKeyPressDuration);
                    } else {
                        this.m_iKeyHeldMask = 0;
                        this.m_iKeyPressDuration = 0;
                    }
                    this.m_iKeyHeldMask |= n6;
                    if ((n6 & 0x1004) != 0) {
                        n4 -= n7;
                        n5 -= n8;
                    } else if ((n6 & 0x2100) != 0) {
                        n4 += n7;
                        n5 += n8;
                    }
                    if ((n6 & 0x4010) != 0) {
                        n3 -= n7;
                        n2 -= n8;
                    } else if ((n6 & 0x8040) != 0) {
                        n3 += n7;
                        n2 += n8;
                    }
                    if (this.m_xrctCursor[0] + n3 < this.m_xboxCursorBounds[0]) {
                        n3 = this.m_xboxCursorBounds[0] - this.m_xrctCursor[0];
                    } else if (this.m_xrctCursor[2] + n3 >= this.m_xboxCursorBounds[2]) {
                        n3 = this.m_xboxCursorBounds[2] - this.m_xrctCursor[2];
                    }
                    if (this.m_xrctCursor[1] + n4 < this.m_xboxCursorBounds[1]) {
                        n4 = this.m_xboxCursorBounds[1] - this.m_xrctCursor[1];
                    } else if (this.m_xrctCursor[3] + n4 >= this.m_xboxCursorBounds[3]) {
                        n4 = this.m_xboxCursorBounds[3] - this.m_xrctCursor[3];
                    }
                    this.m_xrctCursor[0] = this.m_xrctCursor[0] + n3;
                    this.m_xrctCursor[2] = this.m_xrctCursor[2] + n3;
                    this.m_xrctCursor[1] = this.m_xrctCursor[1] + n4;
                    this.m_xrctCursor[3] = this.m_xrctCursor[3] + n4;
                    int n9 = -this.m_xboxCursorBounds[0];
                    int n10 = -this.m_xboxCursorBounds[1];
                    int n11 = this.m_pGame.getWidth() - this.m_xboxCursorBounds[2];
                    int n12 = this.m_pGame.getHeight() - this.m_xboxCursorBounds[3];
                    if (this.m_pGame.m_iX + n2 < n9) {
                        n2 = n9 - this.m_pGame.m_iX;
                    } else if (this.m_pGame.m_iX + n2 >= n11) {
                        n2 = n11 - this.m_pGame.m_iX;
                    }
                    if (this.m_pGame.m_iY + n5 < n10) {
                        n5 = n10 - this.m_pGame.m_iY;
                    } else if (this.m_pGame.m_iY + n5 >= n12) {
                        n5 = n12 - this.m_pGame.m_iY;
                    }
                    if (this.m_iPhase != 7) break block43;
                    if (this.m_pGame.m_pCurrentObject != this.m_pDog) break block44;
                    switch (this.m_pDog.m_iTLCMode) {
                        default: {
                            if (this.m_panmCursor.m_iState != 2) {
                                this.m_panmCursor.setState(2, 0, false);
                                break;
                            }
                            break block45;
                        }
                        case 2: {
                            if (this.m_panmCursor.m_iState != 3) {
                                this.m_panmCursor.setState(3, 0, false);
                                break;
                            }
                            break block45;
                        }
                        case 3: {
                            if (this.m_panmCursor.m_iState != 4) {
                                this.m_panmCursor.setState(4, 0, false);
                            }
                            if (this.m_iSoapBubbleTimer <= 0) {
                                this.m_iSoapBubbleTimer = 200;
                                break;
                            }
                            break block45;
                        }
                    }
                    break block45;
                }
                if (this.m_pGame.m_pCurrentObject != null) {
                    if (this.m_panmCursor.m_iState != 1) {
                        this.m_panmCursor.setState(1, 0, false);
                    }
                } else if (this.m_panmCursor.m_iState != 0) {
                    this.m_panmCursor.setState(0, 0, false);
                }
                if (this.m_pDog.m_pxNeedRates[2] != -352) {
                    this.m_pDog.resetNeedRate(2);
                }
                if (this.m_pDog.m_pxNeedRates[4] != -409) {
                    this.m_pDog.resetNeedRate(4);
                }
                break block45;
            }
            int[] nArray = new int[3];
            int[] nArray2 = this.m_xboxViewBounds;
            this.calcCursorLocation(nArray, nArray2);
            this.m_panmCursor.setLocation(nArray[0], nArray[1]);
            if (this.m_ptxtSelection != null && this.m_panmCursor.m_bVisible) {
                nArray[0] = nArray[0] - (this.m_ptxtSelection.getWidth() >> 1);
                if (nArray[0] < nArray2[0]) {
                    nArray[0] = nArray[0] + (nArray2[0] - nArray[0]);
                } else {
                    n2 = nArray2[2] - this.m_ptxtSelection.getWidth();
                    if (nArray[0] >= n2) {
                        nArray[0] = nArray[0] + (n2 - nArray[0]);
                    }
                }
                nArray[1] = nArray[1] - (this.m_panmCursor.getHeight() >> 1);
                nArray[1] = nArray[1] - 4096;
                nArray[1] = nArray[1] - this.m_ptxtSelection.getHeight();
                this.m_ptxtSelection.setLocation(nArray[0], nArray[1]);
                this.m_ptxtSelection.m_bVisible = true;
            }
        }
    }

    protected final void calcCursorLocation(int[] nArray, int[] nArray2) {
        if (this.m_panmCursor != null) {
            nArray[0] = this.m_xrctCursor[0];
            nArray[1] = this.m_xrctCursor[1];
            nArray[2] = 0;
            if (this.m_pGame.m_pCurrentObject != null) {
                int n = this.m_panmCursor.getWidth();
                int n2 = this.m_panmCursor.getHeight();
                int n3 = this.m_pGame.m_pCurrentObject.getScreenLeft() + this.m_pGame.m_pCurrentObject.getScreenRight() >> 1;
                int n4 = this.m_pGame.m_pCurrentObject.getScreenTop();
                nArray[0] = n3;
                nArray[1] = n4 -= n2 >> 1;
                n3 = 0;
                n4 = 0;
                int n5 = nArray2[1] + n2;
                if (this.m_ptxtSelection != null) {
                    n5 += 4096;
                    n5 += this.m_ptxtSelection.getHeight();
                }
                if (nArray[0] < nArray2[0]) {
                    n3 = nArray2[0] - nArray[0];
                } else if (nArray[0] + n >= nArray2[2]) {
                    n3 = nArray2[2] - (nArray[0] + n);
                }
                if (nArray[1] < n5) {
                    n4 = n5 - nArray[1];
                } else if (nArray[1] + n2 >= nArray2[3]) {
                    n4 = nArray2[3] - (nArray[1] + n2);
                }
                nArray[0] = nArray[0] + n3;
                nArray[1] = nArray[1] + n4;
            }
        }
    }

    protected final void setPhase(int n) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        boolean bl = false;
        boolean bl2 = false;
        this.m_iPhase = n;
        if (this.m_ptxtAcceptSoftKey != null && this.m_ptxtCancelSoftKey != null) {
            this.m_pAcceptSoftKey = this.m_ptxtAcceptSoftKey;
            this.m_pCancelSoftKey = this.m_ptxtCancelSoftKey;
            switch (this.m_iPhase) {
                default: {
                    if (this.m_pDog.m_iNeedTrainingTimer > 0 || this.m_iReopenMenu > 0 || this.m_pDog.m_bTrickResponseTimeOn || this.m_pDog.m_iSuccessAnimState != -1 || this.m_pDog.m_bCommandResponseTimeOn) {
                        this.m_pAcceptSoftKey = null;
                    }
                    this.m_ptxtAcceptSoftKey.setText(158);
                    this.m_ptxtCancelSoftKey.setText(35);
                    bl2 = true;
                    break;
                }
                case 15: 
                case 16: {
                    if (this.m_iPhase == 16) {
                        petsApp.triggerHint(8);
                        petsApp.triggerHint(16);
                    } else if (this.m_iPhase == 15) {
                        petsApp.triggerHint(4);
                        petsApp.triggerHint(2);
                    }
                    this.m_ptxtAcceptSoftKey.setText(166);
                    this.m_ptxtCancelSoftKey.setText(9);
                    break;
                }
                case 2: {
                    petsApp.triggerHint(131072);
                }
                case 3: {
                    this.m_ptxtAcceptSoftKey.setText(166);
                    this.m_ptxtCancelSoftKey.setText(14);
                    bl2 = true;
                    break;
                }
                case 4: {
                    this.m_pAcceptSoftKey = null;
                    this.m_ptxtCancelSoftKey.setText(14);
                    bl2 = true;
                    break;
                }
                case 5: {
                    petsApp.triggerHint(-2147483136);
                }
                case 6: {
                    this.m_pAcceptSoftKey = null;
                    this.m_ptxtCancelSoftKey.setText(9);
                    break;
                }
                case 7: 
                case 8: {
                    this.m_pAcceptSoftKey = null;
                    this.m_ptxtCancelSoftKey.setText(9);
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    this.m_pAcceptSoftKey = null;
                    this.m_ptxtCancelSoftKey.setText(35);
                    break;
                }
                case 18: {
                    this.m_ptxtAcceptSoftKey.setText(13);
                    this.m_ptxtCancelSoftKey.setText(35);
                }
            }
        }
        this.setSearchTimerEnabled(bl2);
        if (!bl2) {
            this.resetSearchTimer();
        }
        this.setShowCursor(bl);
    }

    protected final void setShowCursor(boolean bl) {
        if (this.m_panmCursor != null) {
            if (bl) {
                this.m_iShowCursorTimer = 0;
                switch (this.m_iPhase) {
                    case 0: {
                        this.m_iShowCursorTimer = 5000;
                    }
                    case 11: {
                        if (this.m_panmCursor.m_iState == 0) break;
                        this.m_panmCursor.setState(0, 0, false);
                    }
                }
                this.m_panmCursor.m_bVisible = true;
            } else {
                this.m_iShowCursorTimer = 0;
                this.m_panmCursor.m_bVisible = false;
            }
        }
    }

    protected final void setAvatarVisible(boolean bl) {
        for (int i = 0; i < 2; ++i) {
            if (this.m_ppanmSimParts[i] == null) continue;
            this.m_ppanmSimParts[i].setVisible(bl);
        }
    }

    protected final void updatePetMood() {
        if (this.m_panmPetMood != null) {
            PetsApp petsApp = (PetsApp)GameApp.m_instance;
            int n = this.m_pDog.m_xMood;
            if (n >= 307200) {
                this.m_panmPetMood.setState(2, 0, false);
            } else if (n >= 0) {
                this.m_panmPetMood.setState(1, 0, false);
            } else {
                this.m_panmPetMood.setState(0, 0, false);
            }
        }
    }

    protected final void updateAvatarMood() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n = petsApp.getAvatarMoodState(petsApp.getAvatarMoodLevel());
        if (this.m_iAvatarBalloonTimer > 0) {
            n = 4;
        }
        if (this.m_ppanmSimParts[0] != null && n != this.m_ppanmSimParts[0].getState()) {
            this.m_ppanmSimParts[0].setState(n, 0, false);
        }
    }

    protected final void updateReactState() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        if (this.m_pDog.m_iState == 17) {
            if (petsApp.getCurrentLocation() == 0) {
                this.m_iReactState = 0;
                this.m_iReactAvatarTimer = 4000;
            } else {
                this.m_iReactState = 4;
                this.m_iReactAvatarTimer = 4000;
            }
        }
        if (this.m_pDog.m_iAction == 12) {
            this.m_iReactState = 3;
            this.m_iReactAvatarTimer = 4000;
        }
        if (this.m_pDog.m_bFoundObject) {
            this.m_iReactState = 3;
            this.m_iReactAvatarTimer = 4000;
        }
        if (this.m_bScolded) {
            this.m_bScolded = false;
            this.m_iReactState = 0;
            this.m_iReactAvatarTimer = 4000;
        }
        if (this.m_bPraised) {
            this.m_bPraised = false;
            this.m_iReactState = 3;
            this.m_iReactAvatarTimer = 4000;
        }
        if (this.m_pDog.m_bDestroyed) {
            this.m_pDog.m_bDestroyed = false;
            this.m_iReactState = 0;
            this.m_iReactAvatarTimer = 4000;
        }
        if (this.m_iReactState != -1) {
            int n = 0;
            switch (this.m_iReactState) {
                case 0: 
                case 1: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 3: 
                case 4: {
                    n = 3;
                }
            }
            if (this.m_ppanmSimParts[0] != null && n != this.m_ppanmSimParts[0].getState()) {
                this.m_ppanmSimParts[0].setState(n, 0, false);
            }
        }
    }

    protected final void updateLearningIcon() {
        AnimObject animObject = this.m_panmCommandItem[this.m_iCommandMenuCurGroup][this.m_iCommandMenuCurItem];
        if (animObject != null && this.m_panmFeedbackChange != null) {
            int n = this.m_pDog.m_xLearningProgress;
            if (n >= 0) {
                if (this.m_bMakeExcited) {
                    this.m_bMakeExcited = false;
                    this.m_pDog.makeExcited();
                }
                if (this.m_pDog.m_iDidSuccessfulAbility == 13) {
                    animObject.setState(17, 0, false);
                } else if (this.m_pDog.m_iDidSuccessfulAbility == 22) {
                    animObject.setState(18, 0, false);
                    this.m_pDog.setDisplayFeedback(-1, -1);
                    this.m_iFeedbackDisplayTime = 0;
                    if (this.m_panmFeedbackMotive != null) {
                        this.m_panmFeedbackMotive.m_bVisible = false;
                    }
                }
                animObject.m_bVisible = true;
                animObject.setLocation(this.m_pDog.getScreenRight() + (animObject.getWidth() >> 1), this.m_pDog.getScreenTop() + this.m_pDog.getScreenBottom() - animObject.getHeight() >> 1);
                this.m_panmFeedbackChange.setState(3, 0, false);
                this.m_panmFeedbackChange.m_bVisible = true;
                this.m_panmFeedbackChange.setLocation(animObject.m_iRight + (this.m_panmFeedbackChange.getWidth() >> 2), this.m_pDog.getScreenTop() + this.m_pDog.getScreenBottom() - animObject.getHeight() >> 1);
                this.m_panmFeedbackChange.setZ(animObject.m_iZ + 4096);
            } else {
                animObject.m_bVisible = false;
                if (this.m_panmCommandFrame[this.m_iCommandMenuCurGroup][this.m_iCommandMenuCurItem] != null) {
                    animObject.setLocation(this.m_panmCommandFrame[this.m_iCommandMenuCurGroup][this.m_iCommandMenuCurItem].getX(), this.m_panmCommandFrame[this.m_iCommandMenuCurGroup][this.m_iCommandMenuCurItem].getY());
                }
                this.m_panmFeedbackChange.m_bVisible = false;
                this.m_panmFeedbackMotive.m_bVisible = false;
                this.setPhase(0);
                this.updateSelectionName();
                this.m_pDog.dismiss();
                this.setShowCursor(false);
            }
        }
    }

    protected final void updateBubble(int n) {
        if (this.m_panmBubble == null || this.m_panmMotive == null) {
            return;
        }
        if (n < 0) {
            this.m_panmBubble.m_bVisible = false;
            this.m_panmMotive.m_bVisible = false;
        } else {
            if (n != this.m_panmMotive.m_iState) {
                this.m_panmMotive.setState(n, 0, false);
            }
            this.m_panmBubble.m_bVisible = true;
            this.m_panmMotive.m_bVisible = true;
            int n2 = this.m_pDog.getScreenRight() + (this.m_panmBubble.getWidth() >> 1);
            int n3 = this.m_pDog.getScreenTop() - (this.m_panmBubble.getHeight() >> 1);
            this.m_panmBubble.setLocation(n2, n3);
            if (this.m_panmBubble.m_iTop < this.m_xboxViewBounds[1]) {
                n3 += this.m_xboxViewBounds[1] - this.m_panmBubble.m_iTop;
            } else if (this.m_panmBubble.m_iBottom > this.m_xboxViewBounds[3]) {
                n3 += this.m_xboxViewBounds[3] - this.m_panmBubble.m_iBottom;
            }
            if (this.m_panmBubble.m_iRight > this.m_xboxViewBounds[2]) {
                n2 += this.m_xboxViewBounds[2] - this.m_panmBubble.m_iRight;
            } else if (this.m_panmBubble.m_iLeft < this.m_xboxViewBounds[0]) {
                n2 += this.m_xboxViewBounds[0] - this.m_panmBubble.m_iLeft;
            }
            this.m_panmBubble.setLocation(n2, n3);
            this.m_panmMotive.setLocation(n2, n3);
        }
    }

    protected final void updateFeedback(int n, int n2) {
        if (this.m_panmFeedbackChange == null || this.m_panmFeedbackMotive == null) {
            return;
        }
        if (n2 < 0 || n < 0) {
            this.m_panmFeedbackChange.m_bVisible = false;
            this.m_panmFeedbackMotive.m_bVisible = false;
        } else {
            if (n2 != this.m_panmFeedbackChange.m_iState) {
                this.m_panmFeedbackChange.setState(n2, 0, false);
            }
            if (n != this.m_panmFeedbackMotive.m_iState) {
                this.m_panmFeedbackMotive.setState(n, 0, false);
            }
            this.m_panmFeedbackChange.m_bVisible = true;
            this.m_panmFeedbackMotive.m_bVisible = true;
            int n3 = this.m_pDog.getScreenRight() + this.m_pDog.getScreenLeft() >> 1;
            int n4 = this.m_pDog.getScreenTop() - (this.m_panmFeedbackMotive.getHeight() >> 1);
            this.m_panmFeedbackMotive.setLocation(n3, n4);
            this.m_panmFeedbackChange.setLocation(this.m_panmFeedbackMotive.m_iRight, n4);
            if (this.m_panmFeedbackMotive.m_iTop < this.m_xboxViewBounds[1]) {
                n4 += this.m_xboxViewBounds[1] - this.m_panmFeedbackMotive.m_iTop;
            }
            if (this.m_panmFeedbackChange.m_iRight > this.m_xboxViewBounds[2]) {
                n3 += this.m_xboxViewBounds[2] - this.m_panmFeedbackChange.m_iRight;
            } else if (this.m_panmFeedbackMotive.m_iLeft < this.m_xboxViewBounds[0]) {
                n3 += this.m_xboxViewBounds[0] - this.m_panmFeedbackMotive.m_iLeft;
            }
            this.m_panmFeedbackMotive.setLocation(n3, n4);
            this.m_panmFeedbackChange.setLocation(this.m_panmFeedbackMotive.m_iRight, n4);
        }
    }

    protected final void updateThrowDiscBar(int n) {
        int n2 = 0;
        this.m_xThrowSuccess += n * 4096 >> 11;
        if (this.m_xThrowSuccess > 4096) {
            this.m_xThrowSuccess -= this.m_xThrowSuccess - 4096;
            this.m_xThrowSuccess = -this.m_xThrowSuccess;
        }
        n2 = GameApp.abs(GameApp.mul(this.m_xThrowSuccess, this.m_pThrowingDiscBar.getWidth()));
        this.m_pThrowingDiscArrow.setLocation(this.m_pThrowingDiscBar.m_iLeft + n2, this.m_pThrowingDiscArrow.m_iY);
    }

    protected final void updateThrowMeter(int n) {
        int n2 = this.m_pThrowingBar.m_iValue;
        if ((n2 += n * 4096 >> 11) > 4096) {
            n2 -= n2 - 4096;
            n2 = -n2;
        }
        this.m_pThrowingBar.m_iValue = n2;
    }

    protected final void updateReinforcement() {
        int n = this.m_pDog.m_iNeedTrainingTimer;
        if (this.m_iPhase == 11) {
            n = -1;
        }
        if (n > 0) {
            this.hideMenuForInteraction();
            if (this.m_pboxInputTimer != null) {
                int n2;
                if (!this.m_pboxInputTimer.m_bVisible) {
                    AnimObject animObject;
                    this.m_pboxInputTimer.m_bVisible = true;
                    int n3 = -1;
                    this.m_iContextItemCount = 0;
                    this.m_iCurContextItem = 0;
                    this.m_pDog.setupInteractionMenu(this);
                    for (int i = 0; i < this.m_iContextItemCount; ++i) {
                        if (this.m_ptxtContextItem[i] == null) continue;
                        n3 = this.m_ptxtContextItem[i].getUserData();
                        if (n3 == 1 || n3 == 3) break;
                        n3 = -1;
                    }
                    this.m_iContextItemCount = 0;
                    this.m_iCurContextItem = 0;
                    AnimObject animObject2 = null;
                    if (n3 == 3) {
                        animObject = this.m_panmInteractionItem[2];
                        animObject2 = this.m_panmInteractionFrame[2];
                        this.m_iWantPraiseOrScold = 2;
                        this.m_iPraiseOrScold = 3;
                        n2 = 3;
                    } else {
                        animObject = this.m_panmInteractionItem[3];
                        animObject2 = this.m_panmInteractionFrame[3];
                        this.m_iWantPraiseOrScold = 3;
                        this.m_iPraiseOrScold = 2;
                        n2 = 2;
                    }
                    animObject.m_bVisible = true;
                    if (animObject2 != null) {
                        animObject2.m_bVisible = true;
                    }
                    animObject = this.m_panmInteractionItem[n2];
                    animObject2 = this.m_panmInteractionFrame[n2];
                    animObject.m_bVisible = true;
                    if (animObject2 != null) {
                        animObject2.m_bVisible = true;
                    }
                    if (this.m_pInteractionItemHighlight != null) {
                        this.m_pInteractionItemHighlight.setLocation(animObject.m_iX, animObject.m_iY);
                        this.m_pInteractionItemHighlight.m_bVisible = true;
                    }
                }
                n2 = n;
                n2 <<= 12;
                this.m_pboxInputTimer.m_iValue = n2 /= 30000;
            }
        } else if (this.m_pboxInputTimer != null && this.m_pboxInputTimer.m_bVisible) {
            this.m_pboxInputTimer.m_bVisible = false;
            switch (this.m_iPhase) {
                case 11: {
                    this.m_pDog.setAction(9);
                    break;
                }
                case 8: 
                case 18: {
                    break;
                }
                default: {
                    if (this.m_iWantPraiseOrScold != 3) break;
                    this.m_pDog.confuse();
                }
            }
            this.hideInteractions();
        }
    }

    protected final boolean sayCommand(int n) {
        if (this.m_ptxtAvatar == null) {
            return false;
        }
        int n2 = 0;
        while (DeviceInfo.k_iPetMenuAbilities[n2][0] >= 0) {
            if (n == DeviceInfo.k_iPetMenuAbilities[n2][0]) {
                this.showAvatarBubbleIcon(DeviceInfo.k_iPetAbilities[n][0]);
                break;
            }
            ++n2;
        }
        return true;
    }

    protected final void showAvatarBubbleIcon(int n) {
        if (this.m_pAvatarSpeech == null) {
            return;
        }
        this.m_pAvatarSpeech.setState(n, 0, false);
        this.m_pAvatarSpeech.m_bVisible = true;
        if (this.m_pAvatarBalloon != null) {
            this.m_pAvatarBalloon.m_bVisible = true;
        }
        if (this.m_ptxtAvatar != null) {
            this.m_ptxtAvatar.m_bVisible = false;
        }
        this.m_iAvatarBalloonTimer = 3000;
    }

    protected final void showAvatarBubbleText(int n) {
        this.showAvatarBubbleText(GameApp.loadStringResource(n));
    }

    protected final void showAvatarBubbleText(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        if (this.m_ptxtAvatar == null) {
            GameApp.releaseStringBuffer(byArray);
            return;
        }
        this.m_ptxtAvatar.setText(byArray, true);
        if (this.m_pAvatarBalloon != null) {
            this.m_pAvatarBalloon.m_bVisible = true;
        } else {
            this.m_ptxtAvatar.sizeToText();
            this.m_ptxtAvatar.m_iWidth = this.m_ptxtAvatar.getWidth() + 16384;
            this.m_ptxtAvatar.m_iHeight = this.m_ptxtAvatar.getHeight() + 16384;
        }
        this.m_ptxtAvatar.m_bVisible = true;
        if (this.m_pAvatarSpeech != null) {
            this.m_pAvatarSpeech.m_bVisible = false;
        }
        this.m_iAvatarBalloonTimer = 3000;
    }

    protected final void hideAvatarBubble() {
        this.m_iAvatarBalloonTimer = 0;
        if (this.m_ptxtAvatar != null) {
            this.m_ptxtAvatar.m_bVisible = false;
        }
        if (this.m_pAvatarBalloon != null) {
            this.m_pAvatarBalloon.m_bVisible = false;
        }
        if (this.m_pAvatarSpeech != null) {
            this.m_pAvatarSpeech.m_bVisible = false;
        }
    }

    protected final void updateSelectionName() {
        if (this.m_pGame.m_pCurrentObject != null) {
            this.setSelectionName(this.m_pGame.m_pCurrentObject.m_pyName);
        } else {
            this.setSelectionName(-1);
        }
    }

    protected final void setSelectionName(byte[] byArray) {
        if (this.m_ptxtSelection != null) {
            this.m_ptxtSelection.setText(byArray, false);
            this.m_ptxtSelection.sizeToText();
        }
    }

    protected final void setSelectionName(int n) {
        if (this.m_ptxtSelection != null) {
            this.m_ptxtSelection.setText(n);
            this.m_ptxtSelection.sizeToText();
        }
    }

    protected final void checkTrainer() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        byte[] byArray = petsApp.deqTrainerPrompt();
        if (byArray != null) {
            if (this.m_ptxtTrainer != null) {
                this.m_ptxtTrainer.setText(byArray, true);
                int n = this.m_pListTrainer.elementCount;
                while (--n >= 0) {
                    GameObject gameObject = (GameObject)this.m_pListTrainer.elementData[n];
                    gameObject.m_bVisible = true;
                }
                this.m_iPreTrainerPhase = this.m_iPhase;
                this.setPhase(18);
            } else {
                GameApp.releaseStringBuffer(byArray);
            }
        }
    }

    protected final void hideTrainer() {
        int n = this.m_pListTrainer.elementCount;
        while (--n >= 0) {
            GameObject gameObject = (GameObject)this.m_pListTrainer.elementData[n];
            gameObject.m_bVisible = false;
        }
    }

    protected final void setThrowing(Interactive interactive) {
        if (interactive != null) {
            if (this.m_pGame != null) {
                this.m_pGame.selectInteractive(interactive);
            }
            if (interactive == this.m_pGame.getItem(3)) {
                this.m_pThrowingBar.m_bVisible = true;
                this.m_pThrowingBar.m_iValue = 0;
                this.m_pThrowingObject = interactive;
                this.setPhase(6);
            } else if (interactive == this.m_pGame.getItem(0) && this.m_pGame.isInCatchDiscArea(this.m_pDog)) {
                int n;
                this.m_pThrowingDiscBar.m_bVisible = true;
                this.m_pThrowingDiscBar.m_iValue = n = this.m_pDog.getCatchLevel();
                this.m_pThrowingDiscArrow.m_bVisible = true;
                this.m_pThrowingObject = interactive;
                Toy toy = this.m_pGame.getItem(2);
                toy.m_xInterestLevel = 405504;
                this.m_pDog.interrupt(2, 0, null);
                this.setPhase(5);
            }
        } else {
            this.m_pThrowingBar.m_bVisible = false;
            this.m_pThrowingDiscBar.m_bVisible = false;
            this.m_pThrowingDiscArrow.m_bVisible = false;
            this.m_pThrowingObject = null;
            this.m_xThrowSuccess = 0;
            this.setPhase(0);
            this.setShowCursor(false);
        }
    }

    public final void addString(int n, int n2) {
        this.addString(null, n2);
    }

    public final void addString(byte[] byArray, int n) {
        if (byArray != null) {
            GameApp.releaseStringBuffer(byArray);
        }
        if (this.m_iContextItemCount > 27) {
            return;
        }
        if (this.m_ptxtContextItem[this.m_iContextItemCount] != null) {
            this.m_ptxtContextItem[this.m_iContextItemCount].setUserData(n);
        }
        ++this.m_iContextItemCount;
    }

    protected final void hideInteractions() {
        Toy toy;
        for (int i = 0; i < 4; ++i) {
            if (this.m_panmInteractionItem[i] != null) {
                this.m_panmInteractionItem[i].setVisible(false);
            }
            if (this.m_panmInteractionFrame[i] == null) continue;
            this.m_panmInteractionFrame[i].setVisible(false);
        }
        if (this.m_pInteractionItemHighlight != null) {
            this.m_pInteractionItemHighlight.m_bVisible = false;
        }
        if ((toy = this.m_pGame.getItem(3)) != null && toy.m_bVisible) {
            toy.m_xInterestLevel = 0;
        }
        this.m_iWantPraiseOrScold = -1;
    }

    protected final void hideInteractionMenu() {
        this.hideInteractions();
        this.setPhase(0);
    }

    protected final void hideCommandMenu() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < this.m_iNumCommandItemsPerPage[i]; ++j) {
                if (this.m_panmCommandItem[i][j] != null) {
                    this.m_panmCommandItem[i][j].setVisible(false);
                }
                if (this.m_panmCommandFrame[i][j] == null) continue;
                this.m_panmCommandFrame[i][j].setVisible(false);
            }
            if (this.m_pCommandArrowUp[i] != null) {
                this.m_pCommandArrowUp[i].setVisible(false);
            }
            if (this.m_pCommandArrowDown[i] == null) continue;
            this.m_pCommandArrowDown[i].setVisible(false);
        }
        if (this.m_pInteractionItemHighlight != null) {
            this.m_pInteractionItemHighlight.m_bVisible = false;
        }
        this.setPhase(0);
    }

    protected final void nextCommandItem() {
        if (this.m_iNumCommandItemsPerPage[this.m_iCommandMenuCurGroup] <= 0) {
            return;
        }
        if (this.m_iNumCommandItems[this.m_iCommandMenuCurGroup] <= 0) {
            return;
        }
        int n = this.m_iCommandMenuCurItem + 1;
        if (n >= this.m_iNumCommandItemsPerPage[this.m_iCommandMenuCurGroup]) {
            if (this.m_iCommandMenuItemOffset[this.m_iCommandMenuCurGroup] < this.m_iNumCommandItems[this.m_iCommandMenuCurGroup] - this.m_iNumCommandItemsPerPage[this.m_iCommandMenuCurGroup]) {
                int n2 = this.m_iCommandMenuCurGroup;
                this.m_iCommandMenuItemOffset[n2] = this.m_iCommandMenuItemOffset[n2] + 1;
                n = this.m_iCommandMenuCurItem;
            } else {
                this.m_iCommandMenuItemOffset[this.m_iCommandMenuCurGroup] = 0;
                n = 0;
            }
            this.refreshCommandMenu();
        } else if (n >= this.m_iNumCommandItems[this.m_iCommandMenuCurGroup]) {
            n = 0;
        }
        this.m_iCommandMenuCurItem = n;
        this.updateCommandMenuHighlight();
    }

    protected final void prevCommandItem() {
        if (this.m_iNumCommandItemsPerPage[this.m_iCommandMenuCurGroup] <= 0) {
            return;
        }
        if (this.m_iNumCommandItems[this.m_iCommandMenuCurGroup] <= 0) {
            return;
        }
        int n = this.m_iCommandMenuCurItem - 1;
        if (n < 0) {
            if (this.m_iCommandMenuItemOffset[this.m_iCommandMenuCurGroup] > 0) {
                int n2 = this.m_iCommandMenuCurGroup;
                this.m_iCommandMenuItemOffset[n2] = this.m_iCommandMenuItemOffset[n2] - 1;
                n = this.m_iCommandMenuCurItem;
                this.refreshCommandMenu();
            } else if (this.m_iNumCommandItems[this.m_iCommandMenuCurGroup] > this.m_iNumCommandItemsPerPage[this.m_iCommandMenuCurGroup]) {
                this.m_iCommandMenuItemOffset[this.m_iCommandMenuCurGroup] = this.m_iNumCommandItems[this.m_iCommandMenuCurGroup] - this.m_iNumCommandItemsPerPage[this.m_iCommandMenuCurGroup];
                n = this.m_iNumCommandItemsPerPage[this.m_iCommandMenuCurGroup] - 1;
                this.refreshCommandMenu();
            } else {
                n = this.m_iNumCommandItems[this.m_iCommandMenuCurGroup] - 1;
            }
        }
        this.m_iCommandMenuCurItem = n;
        this.updateCommandMenuHighlight();
    }

    protected final void showCommandMenu() {
        int n;
        int n2;
        if (this.m_iPhase == 16) {
            return;
        }
        this.m_iNumCommandItems[0] = 0;
        this.m_iNumCommandItems[1] = 0;
        this.m_iCommandMenuItemOffset[0] = 0;
        this.m_iCommandMenuItemOffset[1] = 0;
        this.m_iContextItemCount = 0;
        this.m_iCurContextItem = 0;
        this.m_pDog.setupInteractionMenu(this);
        for (int i = 0; i < this.m_iContextItemCount; ++i) {
            if (this.m_ptxtContextItem[i] == null) continue;
            n2 = this.m_ptxtContextItem[i].getUserData();
            n = 0;
            while (DeviceInfo.k_iPetMenuAbilities[n][0] >= 0) {
                if (n2 == DeviceInfo.k_iPetMenuAbilities[n][0]) {
                    if (this.m_pDog.m_pxAbilities[n2] < 409600) {
                        this.m_iCommandItems[1][this.m_iNumCommandItems[1]] = n2;
                        this.m_iNumCommandItems[1] = this.m_iNumCommandItems[1] + 1;
                    } else {
                        this.m_iCommandItems[0][this.m_iNumCommandItems[0]] = n2;
                        this.m_iNumCommandItems[0] = this.m_iNumCommandItems[0] + 1;
                    }
                }
                ++n;
            }
        }
        this.m_iContextItemCount = 0;
        this.m_iCurContextItem = 0;
        this.m_iCommandMenuCurGroup = this.m_iNumCommandItems[0] > 0 ? 0 : 1;
        this.m_iCommandMenuCurItem = 0;
        this.refreshCommandMenu();
        this.updateCommandMenuHighlight();
        for (n = 0; n < 2; ++n) {
            int n3 = n2 = this.m_iNumCommandItems[n] > this.m_iNumCommandItemsPerPage[n];
            if (this.m_pCommandArrowUp[n] != null) {
                this.m_pCommandArrowUp[n].setVisible(n2 != 0);
            }
            if (this.m_pCommandArrowDown[n] == null) continue;
            this.m_pCommandArrowDown[n].setVisible(n2 != 0);
        }
        this.setPhase(16);
    }

    protected final void refreshCommandMenu() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < this.m_iNumCommandItemsPerPage[i]; ++j) {
                if (this.m_panmCommandItem[i][j] == null) continue;
                if (this.m_iCommandMenuItemOffset[i] + j < this.m_iNumCommandItems[i]) {
                    int n = this.m_iCommandItems[i][this.m_iCommandMenuItemOffset[i] + j];
                    this.m_panmCommandItem[i][j].setState(DeviceInfo.k_iPetAbilities[n][0], 0, false);
                    this.m_panmCommandItem[i][j].setInstanceID(n);
                    this.m_panmCommandItem[i][j].setVisible(true);
                    if (this.m_panmCommandFrame[i][j] == null) continue;
                    this.m_panmCommandFrame[i][j].setVisible(true);
                    continue;
                }
                this.m_panmCommandItem[i][j].setVisible(false);
                if (this.m_panmCommandFrame[i][j] == null) continue;
                this.m_panmCommandFrame[i][j].setVisible(false);
            }
        }
    }

    protected final void updateCommandMenuHighlight() {
        AnimObject animObject = this.m_panmCommandItem[this.m_iCommandMenuCurGroup][this.m_iCommandMenuCurItem];
        if (animObject != null && this.m_pInteractionItemHighlight != null) {
            this.m_pInteractionItemHighlight.setLocation(animObject.m_iX, animObject.m_iY);
            this.m_pInteractionItemHighlight.m_bVisible = true;
        }
    }

    protected final void startCommandSequence(int n) {
        int n2 = -1;
        int n3 = this.m_xCommandSequenceBaseX;
        int n4 = this.m_xCommandSequenceBaseY;
        this.m_iCommandSequenceIndex = -1;
        this.m_iCommandSequenceKeys[0] = -1;
        int n5 = 0;
        while (DeviceInfo.k_iPetMenuAbilities[n5][0] >= 0) {
            if (n == DeviceInfo.k_iPetMenuAbilities[n5][0]) {
                do {
                    ++this.m_iCommandSequenceIndex;
                    this.m_iCommandSequenceKeys[this.m_iCommandSequenceIndex] = DeviceInfo.k_iPetMenuCommandSequences[n5][this.m_iCommandSequenceIndex];
                    this.m_iCommandSequenceActions[this.m_iCommandSequenceIndex] = DeviceInfo.k_iPetMenuCommandActions[n5][this.m_iCommandSequenceIndex];
                } while (this.m_iCommandSequenceKeys[this.m_iCommandSequenceIndex] >= 0);
                n2 = this.m_iCommandSequenceIndex;
                this.m_iCommandSequenceActions[n2 - 1] = n;
                break;
            }
            ++n5;
        }
        n3 -= (n2 - 1) * 102400 >> 1;
        for (n5 = 0; n5 < n2; ++n5) {
            if (this.m_panmCommandSequenceArrows[n5] != null) {
                this.m_panmCommandSequenceArrows[n5].setState(this.m_iCommandSequenceKeys[n5], 0, false);
                this.m_panmCommandSequenceArrows[n5].setLocation(n3, n4);
                this.m_panmCommandSequenceArrows[n5].setVisible(true);
            }
            n3 += 102400;
        }
        this.m_iCommandSequenceIndex = 0;
        this.m_iCommandSequenceTimer = 5000;
        this.setPhase(8);
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        petsApp.triggerHint(64);
        petsApp.triggerHint(-2143289344);
        petsApp.triggerHint(128);
    }

    protected final void handleCommandSequenceKey(int n) {
        if (n == this.m_iCommandSequenceKeys[this.m_iCommandSequenceIndex]) {
            if (this.m_iCommandSequenceKeys[this.m_iCommandSequenceIndex + 1] < 0) {
                this.hideCommandSequence();
                this.m_pGame.interaction(this.m_iCommandSequenceActions[this.m_iCommandSequenceIndex]);
                this.setPhase(0);
                this.m_pAcceptSoftKey = null;
            } else {
                this.m_pDog.m_bTrickSequenceTimeOn = true;
                this.m_pDog.m_iSequenceAbility = this.m_iCommandSequenceActions[this.m_iCommandSequenceIndex];
                if (this.m_panmCommandSequenceArrows[this.m_iCommandSequenceIndex] != null) {
                    this.m_panmCommandSequenceArrows[this.m_iCommandSequenceIndex].setVisible(false);
                }
                ++this.m_iCommandSequenceIndex;
            }
        } else {
            PetsApp petsApp;
            if (n == -1) {
                petsApp = (PetsApp)GameApp.m_instance;
                petsApp.triggerHint(256);
            } else {
                if (n == 4) {
                    this.hideCommandSequence();
                    this.m_pDog.dismiss();
                    this.setPhase(0);
                    return;
                }
                petsApp = (PetsApp)GameApp.m_instance;
                petsApp.triggerHint(4096);
            }
            if (this.m_panmCommandSequenceArrows[this.m_iCommandSequenceIndex] != null) {
                int n2 = this.m_panmCommandSequenceArrows[this.m_iCommandSequenceIndex].getState();
                this.m_panmCommandSequenceArrows[this.m_iCommandSequenceIndex].setState(n2 += 4, 0, false);
            }
            this.m_iCommandSequenceTimer = 750;
            this.m_iPhase = 17;
        }
    }

    protected final void hideCommandSequence() {
        for (int i = 0; i < 5; ++i) {
            if (this.m_panmCommandSequenceArrows[i] == null) continue;
            this.m_panmCommandSequenceArrows[i].setVisible(false);
        }
        if (this.m_pboxInputTimer != null) {
            this.m_pboxInputTimer.m_bVisible = false;
        }
    }

    protected final void startTLC() {
        int n;
        int n2 = 4;
        int n3 = this.m_xCommandSequenceBaseX;
        int n4 = this.m_xCommandSequenceBaseY;
        int n5 = GameApp.nextInt();
        int[] nArray = new int[8];
        for (n = 0; n < 8; ++n) {
            nArray[n] = 1;
        }
        this.m_iCommandSequenceIndex = -1;
        this.m_iTLCCommandKeyCounter = 0;
        this.m_iCommandSequenceKeys[0] = -1;
        block7: for (n = 0; n < n2; ++n) {
            int n6 = n5 & 7;
            n5 >>= 3;
            while (nArray[n6] == 0) {
                if (++n6 < 8) continue;
                n6 = 0;
            }
            int n7 = n6;
            nArray[n7] = nArray[n7] - 1;
            switch (n6) {
                case 0: 
                case 1: {
                    this.m_iCommandSequenceKeys[n] = 3;
                    continue block7;
                }
                case 2: 
                case 3: {
                    this.m_iCommandSequenceKeys[n] = 0;
                    continue block7;
                }
                case 4: 
                case 5: {
                    this.m_iCommandSequenceKeys[n] = 2;
                    continue block7;
                }
                case 6: 
                case 7: {
                    this.m_iCommandSequenceKeys[n] = 1;
                }
            }
        }
        this.m_iCommandSequenceKeys[4] = -1;
        n3 -= (n2 - 1) * 102400 >> 1;
        for (n = 0; n < n2; ++n) {
            if (this.m_panmCommandSequenceArrows[n] != null) {
                this.m_panmCommandSequenceArrows[n].setState(this.m_iCommandSequenceKeys[n], 0, false);
                this.m_panmCommandSequenceArrows[n].setLocation(n3, n4);
                this.m_panmCommandSequenceArrows[n].setVisible(true);
            }
            n3 += 102400;
        }
        this.m_iCommandSequenceIndex = 0;
        this.m_iCommandSequenceTimer = 5000;
        this.setPhase(7);
        if (this.m_panmCursor != null) {
            n3 = this.m_pDog.getScreenLeft() + (this.m_pDog.getWidth() >> 1);
            n4 = this.m_pDog.getScreenTop();
            this.m_panmCursor.setLocation(n3, n4);
        }
    }

    protected final void handleTLCSequenceKey(int n) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        if (n == this.m_iCommandSequenceKeys[this.m_iCommandSequenceIndex]) {
            if (this.m_iCommandSequenceKeys[this.m_iCommandSequenceIndex + 1] < 0) {
                petsApp.triggerHint(512);
                this.hideCommandSequence();
                this.m_pGame.stopTLC(4);
                this.setPhase(0);
            } else {
                if (this.m_panmCommandSequenceArrows[this.m_iCommandSequenceIndex] != null) {
                    this.m_panmCommandSequenceArrows[this.m_iCommandSequenceIndex].setVisible(false);
                }
                ++this.m_iCommandSequenceIndex;
                ++this.m_iTLCCommandKeyCounter;
                if (this.m_panmCursor != null) {
                    int n2 = this.m_panmCursor.m_iX;
                    int n3 = this.m_panmCursor.m_iY;
                    switch (n) {
                        case 0: {
                            n2 = this.m_pDog.getScreenLeft() + (this.m_pDog.getWidth() >> 1);
                            n3 = this.m_pDog.getScreenTop();
                            break;
                        }
                        case 2: {
                            n2 = this.m_pDog.getScreenLeft() + (this.m_pDog.getWidth() >> 1);
                            n3 = this.m_pDog.getScreenBottom();
                            break;
                        }
                        case 3: {
                            n2 = this.m_pDog.getScreenLeft();
                            n3 = this.m_pDog.getScreenTop() + (this.m_pDog.getHeight() >> 1);
                            break;
                        }
                        case 1: {
                            n2 = this.m_pDog.getScreenRight();
                            n3 = this.m_pDog.getScreenTop() + (this.m_pDog.getHeight() >> 1);
                        }
                    }
                    this.m_panmCursor.setLocation(n2, n3);
                    this.setShowCursor(true);
                }
            }
        } else {
            if (n == -1) {
                petsApp.triggerHint(256);
            } else if (n != 4) {
                petsApp.triggerHint(4096);
            }
            this.hideCommandSequence();
            this.m_pGame.stopTLC(this.m_iTLCCommandKeyCounter);
            this.setPhase(0);
        }
    }

    private final void rebuildActionMenu() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        this.m_iNumActionItems = 0;
        switch (this.m_iActionMenuInstanceID[this.m_iActionMenuCurLevel]) {
            case 158: {
                this.addActionItem(2, 91, 91, -1);
                for (int i = 0; i < 2; ++i) {
                    if (petsApp.getCurrentLocation() == i) continue;
                    this.addActionItem(DeviceInfo.k_iScenes[i][0], DeviceInfo.k_iScenes[i][1], DeviceInfo.k_iScenes[i][1], -1);
                }
                this.addActionItem(1, 112, 112, -1);
                this.addActionItem(6, 169, 169, -1);
                this.addActionItem(0, 99, 122, -1);
                break;
            }
            case 173: {
                for (int i = 0; i < 2; ++i) {
                    if (petsApp.getCurrentLocation() == i) continue;
                    this.addActionItem(DeviceInfo.k_iScenes[i][0], DeviceInfo.k_iScenes[i][1], DeviceInfo.k_iScenes[i][1], -1);
                }
                break;
            }
            case 122: {
                int n = 0;
                while (DeviceInfo.k_iPetMenuAbilities[n][0] >= 0) {
                    int n2 = this.m_pDog.m_pxAbilities[DeviceInfo.k_iPetMenuAbilities[n][0]];
                    this.addActionItem(0, DeviceInfo.k_iPetMenuAbilities[n][1], 0, n2 >> 12);
                    ++n;
                }
                break;
            }
            case 112: {
                for (int i = 0; i < 4; ++i) {
                    int n = 0;
                    boolean bl = false;
                    for (int j = 0; j < 23; ++j) {
                        if (DeviceInfo.k_iInventoryItems[j][1] != DeviceInfo.k_iCategories[i][1]) continue;
                        if (DeviceInfo.k_iInventoryItems[j][4] != 0) {
                            if (!petsApp.checkInventory(DeviceInfo.k_iInventoryItems[j][4])) continue;
                            if (n == this.m_iActionMenuCurSubItem[i]) {
                                this.addActionItem(this.getSuppliesCategoryIconState(DeviceInfo.k_iInventoryItems[j][1]), DeviceInfo.k_iInventoryItems[j][0], j, -1);
                                bl = true;
                                break;
                            }
                            ++n;
                            continue;
                        }
                        int n3 = petsApp.getConsumable(DeviceInfo.k_iInventoryItems[j][5]);
                        if (n3 <= 0) continue;
                        if (n == this.m_iActionMenuCurSubItem[i]) {
                            this.addActionItem(this.getSuppliesCategoryIconState(DeviceInfo.k_iInventoryItems[j][1]), DeviceInfo.k_iInventoryItems[j][0], j, n3);
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                    if (bl) continue;
                    this.addActionItem(DeviceInfo.k_iCategories[i][0], DeviceInfo.k_iCategories[i][1], DeviceInfo.k_iCategories[i][1], -1);
                }
                break;
            }
        }
        this.refreshActionMenu();
        if (this.m_iNumActionItems > 0) {
            this.updateActionMenuHighlight();
        } else {
            if (this.m_pActionItemIconHighlight != null) {
                this.m_pActionItemIconHighlight.m_bVisible = false;
            }
            if (this.m_ptxtActionItemSelected != null) {
                this.m_ptxtActionItemSelected.setText(167);
            }
        }
        this.updateActionMenuSubItemArrows();
    }

    private final void refreshActionMenu() {
        int n;
        for (n = 0; n < this.m_iNumActionItemsPerPage; ++n) {
            if (this.m_panmActionItem[n] == null) continue;
            if (this.m_iActionMenuItemOffset[this.m_iActionMenuCurLevel] + n < this.m_iNumActionItems) {
                this.m_panmActionItem[n].setState(this.m_iActionItems[this.m_iActionMenuItemOffset[this.m_iActionMenuCurLevel] + n][1], 0, false);
                this.m_panmActionItem[n].setInstanceID(this.m_iActionItems[this.m_iActionMenuItemOffset[this.m_iActionMenuCurLevel] + n][2]);
                this.m_panmActionItem[n].setVisible(true);
                if (this.m_ptxtActionItemStatus[n] != null) {
                    int n2 = this.m_iActionItems[this.m_iActionMenuItemOffset[this.m_iActionMenuCurLevel] + n][3];
                    if (n2 >= 0) {
                        this.m_ptxtActionItemStatus[n].setNumber(n2);
                        this.m_ptxtActionItemStatus[n].setVisible(true);
                    } else {
                        this.m_ptxtActionItemStatus[n].setVisible(false);
                    }
                }
                if (this.m_pboxActionItemFrame[n] == null) continue;
                this.m_pboxActionItemFrame[n].setVisible(true);
                continue;
            }
            this.m_panmActionItem[n].setVisible(false);
            if (this.m_ptxtActionItemStatus[n] != null) {
                this.m_ptxtActionItemStatus[n].setVisible(false);
            }
            if (this.m_pboxActionItemFrame[n] == null) continue;
            this.m_pboxActionItemFrame[n].setVisible(false);
        }
        if (this.m_iNumActionItems > 0) {
            if (this.m_pActionMenuArrowPrevItem != null) {
                this.m_pActionMenuArrowPrevItem.m_bVisible = true;
            }
            if (this.m_pActionMenuArrowNextItem != null) {
                n = this.m_iNumActionItemsPerPage;
                if (this.m_iNumActionItems < n) {
                    n = this.m_iNumActionItems;
                }
                --n;
                this.m_pActionMenuArrowNextItem.m_bVisible = true;
            }
        }
    }

    private final void updateActionMenuHighlight() {
        AnimObject animObject = this.m_panmActionItem[this.m_iActionMenuCurItem[this.m_iActionMenuCurLevel]];
        if (animObject != null) {
            if (this.m_pActionItemIconHighlight != null) {
                this.m_pActionItemIconHighlight.setLocation(animObject.m_iX, animObject.m_iY);
                this.m_pActionItemIconHighlight.m_bVisible = true;
            }
            if (this.m_ptxtActionItemSelected != null) {
                int n = this.m_iActionMenuCurItem[this.m_iActionMenuCurLevel] + this.m_iActionMenuItemOffset[this.m_iActionMenuCurLevel];
                this.m_ptxtActionItemSelected.setText(this.m_iActionItems[n][0]);
            }
        }
    }

    private final void updateActionMenuSubItemArrows() {
        Box box;
        int n;
        if (this.m_pActionMenuArrowPrevSubItem != null) {
            this.m_pActionMenuArrowPrevSubItem.m_bVisible = false;
        }
        if (this.m_pActionMenuArrowNextSubItem != null) {
            this.m_pActionMenuArrowNextSubItem.m_bVisible = false;
        }
        if (this.m_iActionMenuInstanceID[this.m_iActionMenuCurLevel] == 112 && this.m_iActionMenuTotSubItem[n = this.m_iActionMenuCurItem[this.m_iActionMenuCurLevel] + this.m_iActionMenuItemOffset[this.m_iActionMenuCurLevel]] > 1 && (box = this.m_pboxActionItemFrame[this.m_iActionMenuCurItem[this.m_iActionMenuCurLevel]]) != null) {
            int n2;
            int n3 = box.m_iTop + box.m_iBottom >> 1;
            if (this.m_pActionMenuArrowPrevSubItem != null) {
                n2 = box.m_iLeft;
                n2 -= 4096;
                this.m_pActionMenuArrowPrevSubItem.setLocation(n2 -= this.m_pActionMenuArrowPrevSubItem.getWidth() >> 1, n3);
                this.m_pActionMenuArrowPrevSubItem.m_bVisible = true;
            }
            if (this.m_pActionMenuArrowNextSubItem != null) {
                n2 = box.m_iRight;
                n2 += 4096;
                this.m_pActionMenuArrowNextSubItem.setLocation(n2 += this.m_pActionMenuArrowNextSubItem.getWidth() >> 1, n3);
                this.m_pActionMenuArrowNextSubItem.m_bVisible = true;
            }
        }
    }

    private final void nextActionMenuItem() {
        if (this.m_iNumActionItemsPerPage <= 0) {
            return;
        }
        if (this.m_iNumActionItems <= 0) {
            return;
        }
        int n = this.m_iActionMenuCurItem[this.m_iActionMenuCurLevel] + 1;
        if (n >= this.m_iNumActionItemsPerPage) {
            if (this.m_iActionMenuItemOffset[this.m_iActionMenuCurLevel] < this.m_iNumActionItems - this.m_iNumActionItemsPerPage) {
                int n2 = this.m_iActionMenuCurLevel;
                this.m_iActionMenuItemOffset[n2] = this.m_iActionMenuItemOffset[n2] + 1;
                n = this.m_iActionMenuCurItem[this.m_iActionMenuCurLevel];
            } else {
                this.m_iActionMenuItemOffset[this.m_iActionMenuCurLevel] = 0;
                n = 0;
            }
            this.refreshActionMenu();
        } else if (n >= this.m_iNumActionItems) {
            n = 0;
        }
        this.m_iActionMenuCurItem[this.m_iActionMenuCurLevel] = n;
        this.updateActionMenuHighlight();
        this.updateActionMenuSubItemArrows();
    }

    private final void prevActionMenuItem() {
        if (this.m_iNumActionItemsPerPage <= 0) {
            return;
        }
        if (this.m_iNumActionItems <= 0) {
            return;
        }
        int n = this.m_iActionMenuCurItem[this.m_iActionMenuCurLevel] - 1;
        if (n < 0) {
            if (this.m_iActionMenuItemOffset[this.m_iActionMenuCurLevel] > 0) {
                int n2 = this.m_iActionMenuCurLevel;
                this.m_iActionMenuItemOffset[n2] = this.m_iActionMenuItemOffset[n2] - 1;
                n = this.m_iActionMenuCurItem[this.m_iActionMenuCurLevel];
                this.refreshActionMenu();
            } else if (this.m_iNumActionItems > this.m_iNumActionItemsPerPage) {
                this.m_iActionMenuItemOffset[this.m_iActionMenuCurLevel] = this.m_iNumActionItems - this.m_iNumActionItemsPerPage;
                n = this.m_iNumActionItemsPerPage - 1;
                this.refreshActionMenu();
            } else {
                n = this.m_iNumActionItems - 1;
            }
        }
        this.m_iActionMenuCurItem[this.m_iActionMenuCurLevel] = n;
        this.updateActionMenuHighlight();
        this.updateActionMenuSubItemArrows();
    }

    private final void nextActionMenuSubItem() {
        int n;
        if (this.m_iActionMenuInstanceID[this.m_iActionMenuCurLevel] == 112 && this.m_iActionMenuTotSubItem[n = this.m_iActionMenuCurItem[this.m_iActionMenuCurLevel] + this.m_iActionMenuItemOffset[this.m_iActionMenuCurLevel]] > 1) {
            int n2 = n;
            this.m_iActionMenuCurSubItem[n2] = this.m_iActionMenuCurSubItem[n2] + 1;
            if (this.m_iActionMenuCurSubItem[n] >= this.m_iActionMenuTotSubItem[n]) {
                this.m_iActionMenuCurSubItem[n] = 0;
            }
            this.rebuildActionMenu();
        }
    }

    private final void prevActionMenuSubItem() {
        int n;
        if (this.m_iActionMenuInstanceID[this.m_iActionMenuCurLevel] == 112 && this.m_iActionMenuTotSubItem[n = this.m_iActionMenuCurItem[this.m_iActionMenuCurLevel] + this.m_iActionMenuItemOffset[this.m_iActionMenuCurLevel]] > 1) {
            int n2 = n;
            this.m_iActionMenuCurSubItem[n2] = this.m_iActionMenuCurSubItem[n2] - 1;
            if (this.m_iActionMenuCurSubItem[n] < 0) {
                this.m_iActionMenuCurSubItem[n] = this.m_iActionMenuTotSubItem[n] - 1;
            }
            this.rebuildActionMenu();
        }
    }

    private final void showActionMenu() {
        if (this.m_iPhase == 2) {
            return;
        }
        this.m_iActionMenuCurLevel = 0;
        this.m_iActionMenuCurItem[this.m_iActionMenuCurLevel] = 2;
        this.m_iActionMenuItemOffset[this.m_iActionMenuCurLevel] = 0;
        this.m_iActionMenuStringID[this.m_iActionMenuCurLevel] = 158;
        this.m_iActionMenuInstanceID[this.m_iActionMenuCurLevel] = 158;
        this.rebuildActionMenu();
        if (this.m_pboxActionMenuBG != null) {
            this.m_pboxActionMenuBG.m_bVisible = true;
        }
        if (this.m_ptxtActionItemSelected != null) {
            this.m_ptxtActionItemSelected.m_bVisible = true;
        }
        this.setPhase(2);
    }

    private final void hideActionMenu() {
        if (this.m_pActionMenuArrowPrevItem != null) {
            this.m_pActionMenuArrowPrevItem.m_bVisible = false;
        }
        if (this.m_pActionMenuArrowNextItem != null) {
            this.m_pActionMenuArrowNextItem.m_bVisible = false;
        }
        if (this.m_pActionMenuArrowPrevSubItem != null) {
            this.m_pActionMenuArrowPrevSubItem.m_bVisible = false;
        }
        if (this.m_pActionMenuArrowNextSubItem != null) {
            this.m_pActionMenuArrowNextSubItem.m_bVisible = false;
        }
        if (this.m_pboxActionMenuBG != null) {
            this.m_pboxActionMenuBG.m_bVisible = false;
        }
        if (this.m_ptxtActionItemSelected != null) {
            this.m_ptxtActionItemSelected.m_bVisible = false;
        }
        if (this.m_pActionItemIconHighlight != null) {
            this.m_pActionItemIconHighlight.m_bVisible = false;
        }
        for (int i = 0; i < this.m_iNumActionItemsPerPage; ++i) {
            if (this.m_panmActionItem[i] != null) {
                this.m_panmActionItem[i].setVisible(false);
            }
            if (this.m_ptxtActionItemStatus[i] != null) {
                this.m_ptxtActionItemStatus[i].setVisible(false);
            }
            if (this.m_pboxActionItemFrame[i] == null) continue;
            this.m_pboxActionItemFrame[i].setVisible(false);
        }
        this.setPhase(0);
    }

    private final void handleActionMenuSelect() {
        if (this.m_iNumActionItems <= 0) {
            return;
        }
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n = this.m_iActionMenuCurItem[this.m_iActionMenuCurLevel] + this.m_iActionMenuItemOffset[this.m_iActionMenuCurLevel];
        block0 : switch (this.m_iActionMenuInstanceID[this.m_iActionMenuCurLevel]) {
            case 158: {
                switch (this.m_iActionItems[n][2]) {
                    case 112: {
                        this.showSuppliesMenu();
                        break;
                    }
                    case 122: {
                        this.showTrainingMenu();
                        break;
                    }
                    case 173: {
                        ++this.m_iActionMenuCurLevel;
                        this.m_iActionMenuCurItem[this.m_iActionMenuCurLevel] = 0;
                        this.m_iActionMenuItemOffset[this.m_iActionMenuCurLevel] = 0;
                        this.m_iActionMenuStringID[this.m_iActionMenuCurLevel] = this.m_iActionItems[n][2];
                        this.m_iActionMenuInstanceID[this.m_iActionMenuCurLevel] = this.m_iActionItems[n][2];
                        this.rebuildActionMenu();
                        break;
                    }
                    case 175: 
                    case 176: {
                        petsApp.onDialogEvent(this.m_iActionItems[n][2], 35);
                        break;
                    }
                    case 91: {
                        StoreScene storeScene = new StoreScene(78);
                        if (storeScene == null) break;
                        petsApp.openScene(storeScene);
                        break;
                    }
                    case 169: {
                        MetaGameScene metaGameScene = new MetaGameScene();
                        if (metaGameScene == null) break;
                        petsApp.openScene(metaGameScene);
                        break;
                    }
                    case 193: {
                        this.hideActionMenu();
                    }
                }
                break;
            }
            case 173: {
                switch (this.m_iActionItems[n][2]) {
                    case 175: 
                    case 176: {
                        petsApp.onDialogEvent(this.m_iActionItems[n][2], 35);
                    }
                }
                break;
            }
            case 112: {
                n = this.m_iActionItems[n][2];
                switch (n) {
                    case 163: {
                        petsApp.pushTrainerPromptStringID(97);
                        break block0;
                    }
                    case 164: {
                        break block0;
                    }
                    case 165: {
                        break block0;
                    }
                }
                if (DeviceInfo.k_iInventoryItems[n][4] != 0 && petsApp.checkInventory(DeviceInfo.k_iInventoryItems[n][4])) {
                    this.m_pGame.useItem(n);
                    this.updateSelectionName();
                    this.hideActionMenu();
                    break;
                }
                if (DeviceInfo.k_iInventoryItems[n][4] != 0) break;
                this.updateSelectionName();
                this.hideActionMenu();
            }
        }
    }

    private final void addActionItem(int n, int n2, int n3, int n4) {
        if (this.m_iNumActionItems >= 32) {
            return;
        }
        this.m_iActionItems[this.m_iNumActionItems][0] = n2;
        this.m_iActionItems[this.m_iNumActionItems][1] = n;
        this.m_iActionItems[this.m_iNumActionItems][2] = n3;
        this.m_iActionItems[this.m_iNumActionItems][3] = n4;
        ++this.m_iNumActionItems;
    }

    private final void hideMenuForInteraction() {
        switch (this.m_iPhase) {
            case 2: 
            case 3: 
            case 4: {
                this.m_iReopenMenu = this.m_iPhase;
                this.hideListMenu();
                this.hideActionMenu();
            }
        }
    }

    private final void reopenMenu() {
        switch (this.m_iReopenMenu) {
            case 2: {
                this.showActionMenu();
                break;
            }
            case 3: {
                this.showActionMenu();
                this.showSuppliesMenu();
                break;
            }
            case 4: {
                this.showActionMenu();
                this.m_iActionMenuCurItem[this.m_iActionMenuCurLevel] = 4;
                this.updateActionMenuHighlight();
                this.showTrainingMenu();
            }
        }
        this.m_iReopenMenu = 0;
    }

    private final void addListItem(int n, int n2, int n3, int n4) {
        if (this.m_iNumListItems >= 32) {
            return;
        }
        this.m_iListItems[this.m_iNumListItems][0] = n2;
        this.m_iListItems[this.m_iNumListItems][1] = n;
        this.m_iListItems[this.m_iNumListItems][2] = n3;
        this.m_iListItems[this.m_iNumListItems][3] = n4;
        ++this.m_iNumListItems;
    }

    private final void hideListMenu() {
        if (this.m_pListMenuArrowPrevItem != null) {
            this.m_pListMenuArrowPrevItem.m_bVisible = false;
        }
        if (this.m_pListMenuArrowNextItem != null) {
            this.m_pListMenuArrowNextItem.m_bVisible = false;
        }
        if (this.m_pboxListMenuBG != null) {
            this.m_pboxListMenuBG.m_bVisible = false;
        }
        if (this.m_pListItemIconHighlight != null) {
            this.m_pListItemIconHighlight.m_bVisible = false;
        }
        for (int i = 0; i < this.m_iNumListItemsPerPage; ++i) {
            if (this.m_panmListItem[i] != null) {
                this.m_panmListItem[i].setVisible(false);
            }
            if (this.m_ptxtListItemDesc[i] != null) {
                this.m_ptxtListItemDesc[i].setVisible(false);
            }
            if (this.m_pboxListItemStatus[i] != null) {
                this.m_pboxListItemStatus[i].setVisible(false);
            }
            if (this.m_pboxListItemFrame[i] == null) continue;
            this.m_pboxListItemFrame[i].setVisible(false);
        }
        this.setPhase(2);
    }

    private final void updateListMenuHighlight() {
        AnimObject animObject = this.m_panmListItem[this.m_iListMenuCurItem];
        if (animObject != null && this.m_pListItemIconHighlight != null) {
            this.m_pListItemIconHighlight.setLocation(animObject.m_iX, animObject.m_iY);
            this.m_pListItemIconHighlight.m_bVisible = true;
        }
    }

    private final int getSuppliesCategoryIconState(int n) {
        for (int i = 0; i < 4 && DeviceInfo.k_iCategories[i][1] != -1; ++i) {
            if (DeviceInfo.k_iCategories[i][1] != n) continue;
            return DeviceInfo.k_iCategories[i][0];
        }
        return -1;
    }

    private final void addSuppliesCategory(int n) {
        int n2;
        if (this.m_iPhase == 3) {
            return;
        }
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n3 = this.getSuppliesCategoryIconState(n);
        if (n3 < 0) {
            return;
        }
        switch (petsApp.getCurrentLocation()) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        for (int i = 0; i < 23; ++i) {
            int n4;
            if (DeviceInfo.k_iInventoryItems[i][1] != n || DeviceInfo.k_iInventoryItems[i][3] == 0 || (n4 = DeviceInfo.k_iInventoryItems[i][6]) != -1 && (n2 & n4) == 0) continue;
            if (DeviceInfo.k_iInventoryItems[i][4] != 0) {
                if (!petsApp.checkInventory(DeviceInfo.k_iInventoryItems[i][4])) continue;
                this.addListItem(n3, DeviceInfo.k_iInventoryItems[i][0], i, -1);
                continue;
            }
            int n5 = petsApp.getConsumable(DeviceInfo.k_iInventoryItems[i][5]);
            if (n5 <= 0 && i != 0) continue;
            this.addListItem(n3, DeviceInfo.k_iInventoryItems[i][0], i, n5);
        }
    }

    private final void rebuildSuppliesMenu() {
        for (int i = 0; i < this.m_iNumListItemsPerPage; ++i) {
            if (this.m_ptxtListItemDesc[i] == null || this.m_pboxListItemStatus[i] == null) continue;
            int n = this.m_pboxListItemStatus[i].getRight() - this.m_ptxtListItemDesc[i].getLeft();
            this.m_ptxtListItemDesc[i].setWidth(n);
        }
        this.m_iNumListItems = 0;
        this.addSuppliesCategory(163);
        this.addSuppliesCategory(206);
        this.addSuppliesCategory(164);
        this.addSuppliesCategory(165);
        this.addListItem(9, 152, 1000, -1);
        this.refreshSuppliesMenu();
        if (this.m_iNumListItems > 0) {
            this.updateListMenuHighlight();
        } else if (this.m_pListItemIconHighlight != null) {
            this.m_pListItemIconHighlight.m_bVisible = false;
        }
    }

    private final void refreshSuppliesMenu() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        for (int i = 0; i < this.m_iNumListItemsPerPage; ++i) {
            if (this.m_panmListItem[i] == null) continue;
            if (this.m_iListMenuItemOffset + i < this.m_iNumListItems) {
                this.m_panmListItem[i].setState(this.m_iListItems[this.m_iListMenuItemOffset + i][1], 0, false);
                this.m_panmListItem[i].setInstanceID(this.m_iListItems[this.m_iListMenuItemOffset + i][2]);
                this.m_panmListItem[i].setVisible(true);
                if (this.m_ptxtListItemDesc[i] != null) {
                    int n = this.m_iListItems[this.m_iListMenuItemOffset + i][0];
                    int n2 = this.m_iListItems[this.m_iListMenuItemOffset + i][3];
                    if (n2 >= 0) {
                        this.m_ptxtListItemDesc[i].setText(petsApp.getInventoryBuffer(n, n2), true);
                    } else {
                        this.m_ptxtListItemDesc[i].setText(n);
                    }
                    this.m_ptxtListItemDesc[i].setVisible(true);
                }
                if (this.m_pboxListItemFrame[i] == null) continue;
                this.m_pboxListItemFrame[i].setVisible(true);
                continue;
            }
            this.m_panmListItem[i].setVisible(false);
            if (this.m_ptxtListItemDesc[i] != null) {
                this.m_ptxtListItemDesc[i].setVisible(false);
            }
            if (this.m_pboxListItemFrame[i] == null) continue;
            this.m_pboxListItemFrame[i].setVisible(false);
        }
        if (this.m_iNumListItems > 0) {
            if (this.m_pListMenuArrowPrevItem != null) {
                this.m_pListMenuArrowPrevItem.m_bVisible = true;
            }
            if (this.m_pListMenuArrowNextItem != null) {
                this.m_pListMenuArrowNextItem.m_bVisible = true;
            }
        }
    }

    private final void nextSuppliesMenuItem() {
        if (this.m_iNumListItemsPerPage <= 0) {
            return;
        }
        if (this.m_iNumListItems <= 0) {
            return;
        }
        int n = this.m_iListMenuCurItem + 1;
        if (n >= this.m_iNumListItemsPerPage) {
            if (this.m_iListMenuItemOffset < this.m_iNumListItems - this.m_iNumListItemsPerPage) {
                ++this.m_iListMenuItemOffset;
                n = this.m_iListMenuCurItem;
            } else {
                this.m_iListMenuItemOffset = 0;
                n = 0;
            }
            this.refreshSuppliesMenu();
        } else if (n >= this.m_iNumListItems) {
            n = 0;
        }
        this.m_iListMenuCurItem = n;
        this.updateListMenuHighlight();
    }

    private final void prevSuppliesMenuItem() {
        if (this.m_iNumListItemsPerPage <= 0) {
            return;
        }
        if (this.m_iNumListItems <= 0) {
            return;
        }
        int n = this.m_iListMenuCurItem - 1;
        if (n < 0) {
            if (this.m_iListMenuItemOffset > 0) {
                --this.m_iListMenuItemOffset;
                n = this.m_iListMenuCurItem;
                this.refreshSuppliesMenu();
            } else if (this.m_iNumListItems > this.m_iNumListItemsPerPage) {
                this.m_iListMenuItemOffset = this.m_iNumListItems - this.m_iNumListItemsPerPage;
                n = this.m_iNumListItemsPerPage - 1;
                this.refreshSuppliesMenu();
            } else {
                n = this.m_iNumListItems - 1;
            }
        }
        this.m_iListMenuCurItem = n;
        this.updateListMenuHighlight();
    }

    private final void showSuppliesMenu() {
        if (this.m_iPhase == 3) {
            return;
        }
        this.m_iListMenuCurItem = 0;
        this.m_iListMenuItemOffset = 0;
        this.rebuildSuppliesMenu();
        if (this.m_pboxListMenuBG != null) {
            this.m_pboxListMenuBG.m_bVisible = true;
        }
        this.setPhase(3);
    }

    private final void handleSuppliesMenuSelect() {
        if (this.m_iNumListItems <= 0) {
            return;
        }
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n = this.m_iListMenuCurItem + this.m_iListMenuItemOffset;
        if ((n = this.m_iListItems[n][2]) == 1000) {
            this.hideListMenu();
            this.hideActionMenu();
            if (this.m_pDog.m_pCarry != null) {
                this.m_pDog.m_pCarry.m_bVisible = false;
            }
            this.m_pDog.dismiss();
            this.m_pGame.removeRemovableObject();
            this.m_pGame.selectInteractive(this.m_pDog);
            Toy toy = this.m_pGame.getItem(9);
            if (toy != null) {
                toy.setState(0, 0, false);
            }
            this.setPhase(0);
            this.updateSelectionName();
            return;
        }
        if (DeviceInfo.k_iInventoryItems[n][4] != 0 && petsApp.checkInventory(DeviceInfo.k_iInventoryItems[n][4])) {
            this.hideListMenu();
            this.hideActionMenu();
            switch (n) {
                case 19: 
                case 20: {
                    Toy toy;
                    if (!this.m_pGame.isInInteractionArea(this.m_pDog) && (toy = this.m_pGame.getItem(2)) != null) {
                        int n2 = toy.m_xWorldX;
                        int n3 = toy.m_xWorldY;
                        this.m_pDog.setWorldLocation(n2, n3, this.m_pDog.m_xWorldZ);
                        this.m_pGame.snapCamera();
                    }
                    this.startTLC();
                    this.m_pGame.useItem(n);
                    if (n == 19) {
                        this.m_pGame.interaction(2200);
                        break;
                    }
                    this.m_pGame.interaction(2300);
                    break;
                }
                case 10: {
                    this.m_pGame.interaction(2500);
                    break;
                }
                default: {
                    this.m_pGame.useItem(n);
                    this.updateSelectionName();
                    break;
                }
            }
        } else if (DeviceInfo.k_iInventoryItems[n][4] == 0) {
            int n4 = petsApp.getConsumable(DeviceInfo.k_iInventoryItems[n][5]);
            if (n4 > 0) {
                this.hideListMenu();
                this.hideActionMenu();
                switch (DeviceInfo.k_iInventoryItems[n][5]) {
                    case 0: {
                        this.m_pGame.interaction(1300);
                        break;
                    }
                    case 1: {
                        this.m_pGame.interaction(1400);
                        break;
                    }
                    case 2: {
                        this.m_pGame.interaction(1500);
                        break;
                    }
                    case 3: {
                        this.m_pGame.interaction(1600);
                        break;
                    }
                    case 4: {
                        this.m_pGame.interaction(1700);
                        break;
                    }
                    case 5: {
                        this.m_pGame.interaction(1800);
                        break;
                    }
                    case 6: {
                        this.m_pGame.interaction(2400);
                        break;
                    }
                    case 7: {
                        Toy toy;
                        if (!this.m_pGame.isInInteractionArea(this.m_pDog) && (toy = this.m_pGame.getItem(2)) != null) {
                            int n5 = toy.m_xWorldX;
                            int n6 = toy.m_xWorldY;
                            this.m_pDog.setWorldLocation(n5, n6, this.m_pDog.m_xWorldZ);
                            this.m_pGame.snapCamera();
                        }
                        this.startTLC();
                        this.m_pGame.useItem(20);
                        this.m_pGame.interaction(2300);
                    }
                }
                this.updateSelectionName();
            } else {
                petsApp.pushTrainerPromptStringID(97);
            }
        }
    }

    private final void rebuildTrainingMenu() {
        int n;
        if (this.m_iPhase == 4) {
            return;
        }
        for (n = 0; n < this.m_iNumListItemsPerPage; ++n) {
            if (this.m_ptxtListItemDesc[n] == null || this.m_pboxListItemStatus[n] == null) continue;
            int n2 = this.m_pboxListItemStatus[n].getLeft() - this.m_ptxtListItemDesc[n].getLeft();
            this.m_ptxtListItemDesc[n].setWidth(n2 -= 16384);
        }
        this.m_iNumListItems = 0;
        n = 0;
        while (DeviceInfo.k_iPetMenuAbilities[n][0] >= 0) {
            int n3 = this.m_pDog.m_pxAbilities[DeviceInfo.k_iPetMenuAbilities[n][0]];
            this.addListItem(8, DeviceInfo.k_iPetMenuAbilities[n][1], DeviceInfo.k_iPetMenuAbilities[n][0], n3 >> 12);
            ++n;
        }
        this.refreshTrainingMenu();
    }

    private final void refreshTrainingMenu() {
        for (int i = 0; i < this.m_iNumListItemsPerPage; ++i) {
            Box box;
            AnimObject animObject = this.m_panmListItem[i];
            if (animObject == null) continue;
            if (this.m_iListMenuItemOffset + i < this.m_iNumListItems) {
                int n = this.m_iListItems[this.m_iListMenuItemOffset + i][3];
                animObject.m_iInstanceID = this.m_iListItems[this.m_iListMenuItemOffset + i][2];
                if (n >= 100) {
                    animObject.setState(this.m_iListItems[this.m_iListMenuItemOffset + i][1], 0, false);
                    animObject.m_bVisible = true;
                } else {
                    animObject.m_bVisible = false;
                }
                if (this.m_ptxtListItemDesc[i] != null) {
                    int n2 = this.m_iListItems[this.m_iListMenuItemOffset + i][0];
                    this.m_ptxtListItemDesc[i].setText(n2);
                    this.m_ptxtListItemDesc[i].setVisible(true);
                }
                if ((box = this.m_pboxListItemStatus[i]) != null) {
                    box.m_iValue = n;
                    box.m_bVisible = true;
                }
                box = this.m_pboxListItemFrame[i];
                if (this.m_pboxListItemFrame[i] == null) continue;
                box.m_bVisible = true;
                continue;
            }
            animObject.m_bVisible = false;
            if (this.m_ptxtListItemDesc[i] != null) {
                this.m_ptxtListItemDesc[i].setVisible(false);
            }
            if ((box = this.m_pboxListItemStatus[i]) != null) {
                box.m_bVisible = false;
            }
            if ((box = this.m_pboxListItemFrame[i]) == null) continue;
            box.m_bVisible = false;
        }
        if (this.m_iNumListItems > this.m_iNumListItemsPerPage) {
            if (this.m_pListMenuArrowPrevItem != null) {
                this.m_pListMenuArrowPrevItem.m_bVisible = this.m_iListMenuItemOffset > 0;
            }
            if (this.m_pListMenuArrowNextItem != null) {
                this.m_pListMenuArrowNextItem.m_bVisible = this.m_iListMenuItemOffset < this.m_iNumListItems - this.m_iNumListItemsPerPage;
            }
        } else {
            if (this.m_pListMenuArrowPrevItem != null) {
                this.m_pListMenuArrowPrevItem.m_bVisible = false;
            }
            if (this.m_pListMenuArrowNextItem != null) {
                this.m_pListMenuArrowNextItem.m_bVisible = false;
            }
        }
    }

    private final void nextTrainingMenuItem() {
        if (this.m_iListMenuItemOffset < this.m_iNumListItems - this.m_iNumListItemsPerPage) {
            this.m_iListMenuItemOffset += this.m_iNumListItemsPerPage;
            this.refreshTrainingMenu();
        }
    }

    private final void prevTrainingMenuItem() {
        if (this.m_iListMenuItemOffset > 0) {
            this.m_iListMenuItemOffset -= this.m_iNumListItemsPerPage;
            this.refreshTrainingMenu();
        }
    }

    private final void showTrainingMenu() {
        if (this.m_iPhase == 4) {
            return;
        }
        this.m_iListMenuCurItem = 0;
        this.m_iListMenuItemOffset = 0;
        this.rebuildTrainingMenu();
        if (this.m_pboxListMenuBG != null) {
            this.m_pboxListMenuBG.m_bVisible = true;
        }
        this.setPhase(4);
    }

    public void onResume() {
        if (!this.m_bPauseMenuOpen) {
            if (this.m_iPhase != 18) {
                Toy toy;
                PetsApp petsApp = (PetsApp)GameApp.m_instance;
                if (petsApp.checkInventory(DeviceInfo.k_iInventoryItems[7][4]) && (toy = this.m_pGame.getItem(4)) != null) {
                    toy.setState(1, 0, false);
                }
                if (this.m_iPhase != 0) {
                    switch (this.m_iPhase) {
                        case 3: {
                            this.hideListMenu();
                            this.hideActionMenu();
                            break;
                        }
                        case 4: {
                            this.hideListMenu();
                            this.hideActionMenu();
                            break;
                        }
                        case 7: {
                            this.handleTLCSequenceKey(-1);
                        }
                    }
                }
            }
        } else {
            this.m_bPauseMenuOpen = false;
        }
        super.onResume();
    }

    public void onPauseApp() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        super.onPauseApp();
        if (petsApp.getLoadingScene() == this) {
            this.m_bDoOpenPause = true;
        } else if (petsApp.getCurrentScene() == this) {
            this.m_bPauseMenuOpen = petsApp.openPauseDialog();
        }
    }

    public int onOpen() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        this.m_pDog = this.m_pGame.m_pDog;
        this.m_pGame.onOpen();
        this.m_pGame.sortObjects();
        int n = 0;
        this.m_ptxtAcceptSoftKey = (TextObject)this.m_pAcceptSoftKey;
        this.m_ptxtCancelSoftKey = (TextObject)this.m_pCancelSoftKey;
        this.m_xboxCursorBounds[0] = this.m_xboxViewBounds[0];
        this.m_xboxCursorBounds[2] = this.m_xboxViewBounds[2];
        this.m_xboxCursorBounds[1] = this.m_xboxViewBounds[1];
        this.m_xboxCursorBounds[3] = this.m_xboxViewBounds[3];
        if (this.m_ptxtAvatar != null && this.m_pAvatarBalloon == null) {
            this.m_ptxtAvatar.m_bPaintBackground = true;
            this.m_ptxtAvatar.m_bRoundedEnds = true;
        }
        this.updateSelectionName();
        if (this.m_panmCursor != null) {
            n = this.m_panmCursor.m_iZ + 4096;
        }
        for (int i = 0; i < 27; ++i) {
            this.m_ptxtContextItem[i] = new TextObject();
            if (this.m_ptxtContextItem[i] == null) continue;
            this.m_ptxtContextItem[i].setVisible(false);
            this.m_ptxtContextItem[i].setPaintBackground(true);
            this.m_ptxtContextItem[i].setRoundedEnds(true);
            this.m_ptxtContextItem[i].setBackgroundColor(5463451);
            this.m_ptxtContextItem[i].setHorzJustification(1);
            this.m_ptxtContextItem[i].setVertJustification(1);
            this.m_ptxtContextItem[i].setZ(n);
            this.addObject(this.m_ptxtContextItem[i]);
        }
        this.hideActionMenu();
        this.updateBubble(-1);
        this.updateFeedback(-1, -1);
        this.m_pGame.snapCamera();
        return super.onOpen();
    }

    public int onClose() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        this.m_pGame.onClose();
        if (this.m_pListTrainer != null) {
            this.m_pListTrainer = null;
        }
        petsApp.clearPopups();
        return super.onClose();
    }

    public boolean onAddObject(GameObject gameObject) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n = gameObject.m_iInstanceID;
        boolean bl = super.onAddObject(gameObject);
        if (n == 2000) {
            Box box = (Box)gameObject;
            box.m_iStyle = 5;
        } else if (2010 <= n && n < 2015) {
            Box box = (Box)gameObject;
            box.m_iStyle = 6;
            box.m_iValue = 5925821;
            this.m_pMotiveAreas[n -= 2010] = box;
        } else if (n == 2002) {
            this.m_xboxViewBounds[0] = gameObject.m_iLeft;
            this.m_xboxViewBounds[1] = gameObject.m_iTop;
            this.m_xboxViewBounds[2] = gameObject.m_iRight;
            this.m_xboxViewBounds[3] = gameObject.m_iBottom;
            this.m_pGame.updateViewport(this.m_xboxViewBounds[0], this.m_xboxViewBounds[1], this.m_xboxViewBounds[2], this.m_xboxViewBounds[3]);
        } else if (n == 6002) {
            this.m_panmPetMood = (AnimObject)gameObject;
        } else if (n == 2100) {
            this.m_ptxtSimoleons = (TextObject)gameObject;
            gameObject.m_iUserData = -1;
        } else if (n == 2110) {
            this.m_ptxtSelection = (TextObject)gameObject;
        } else if (n == 2120) {
            this.m_ptxtTrainer = (TextObject)gameObject;
            this.m_pListTrainer.addElement(gameObject);
        } else if (n == 2121) {
            this.m_pListTrainer.addElement(gameObject);
        } else if (n == 2122) {
            this.m_pListTrainer.addElement(gameObject);
            Box box = (Box)gameObject;
            box.m_iStyle = 12;
        } else if (n == 2130) {
            this.m_ptxtAvatar = (TextObject)gameObject;
        } else if (n == 2133) {
            this.m_pAvatarBalloon = gameObject;
            if (this.m_pAvatarBalloon.m_iUserData == 10) {
                Box box = (Box)this.m_pAvatarBalloon;
                box.m_iStyle = 13;
            }
        } else if (n == 2136) {
            this.m_pAvatarSpeech = (AnimObject)gameObject;
        } else if (n == 2135) {
            this.m_pAvatarBounds = gameObject;
            Box box = (Box)gameObject;
            box.m_iStyle = 12;
        } else if (4001 <= n && n < 4006) {
            Box box = (Box)gameObject;
            box.m_iStyle = 1;
            this.m_pMeterBars[n -= 4001] = box;
        } else if (n == 4200) {
            this.m_panmCursor = (AnimObject)gameObject;
            this.m_xrctCursor[0] = this.m_panmCursor.m_iLeft;
            this.m_xrctCursor[2] = this.m_panmCursor.m_iRight;
            this.m_xrctCursor[1] = this.m_panmCursor.m_iTop;
            this.m_xrctCursor[3] = this.m_panmCursor.m_iBottom;
        } else if (n == 4202) {
            this.m_pThrowingBar = (Box)gameObject;
            this.m_pThrowingBar.m_iStyle = 4;
        } else if (n == 4204) {
            this.m_pThrowingDiscBar = (Box)gameObject;
            this.m_pThrowingDiscBar.m_iStyle = 11;
        } else if (n == 4205) {
            this.m_pThrowingDiscArrow = (AnimObject)gameObject;
        } else if (n == 7001) {
            this.m_panmBubble = (AnimObject)gameObject;
        } else if (n == 7002) {
            this.m_panmMotive = (AnimObject)gameObject;
        } else if (n == 8002) {
            this.m_panmFeedbackChange = (AnimObject)gameObject;
        } else if (n == 8001) {
            this.m_panmFeedbackMotive = (AnimObject)gameObject;
        } else if (n == 8003) {
            this.m_ptxtFeedbackMotive = (TextObject)gameObject;
            this.m_ptxtFeedbackMotive.m_bPaintBackground = true;
            this.m_ptxtFeedbackMotive.m_bRoundedEnds = true;
        } else if (n == 8004) {
            this.m_pboxFeedbackAreaHL = (Box)gameObject;
            this.m_pboxFeedbackAreaHL.m_iStyle = 9;
        } else if (n == 6007) {
            this.m_pboxInputTimer = (Box)gameObject;
            this.m_pboxInputTimer.m_iStyle = 15;
        } else if (2200 <= n && n < 2204) {
            this.m_panmInteractionItem[n -= 2200] = (AnimObject)gameObject;
        } else if (2300 <= n && n < 2304) {
            this.m_panmInteractionFrame[n -= 2300] = (AnimObject)gameObject;
        } else if (2210 <= n && n < 2220) {
            this.m_panmCommandItem[0][n -= 2210] = (AnimObject)gameObject;
            if (++n > this.m_iNumCommandItemsPerPage[0]) {
                this.m_iNumCommandItemsPerPage[0] = n;
            }
        } else if (2310 <= n && n < 2320) {
            this.m_panmCommandFrame[0][n -= 2310] = (AnimObject)gameObject;
            if (++n > this.m_iNumCommandItemsPerPage[0]) {
                this.m_iNumCommandItemsPerPage[0] = n;
            }
        } else if (2220 <= n && n < 2230) {
            this.m_panmCommandItem[1][n -= 2220] = (AnimObject)gameObject;
            if (++n > this.m_iNumCommandItemsPerPage[1]) {
                this.m_iNumCommandItemsPerPage[1] = n;
            }
        } else if (2320 <= n && n < 2330) {
            this.m_panmCommandFrame[1][n -= 2320] = (AnimObject)gameObject;
            if (++n > this.m_iNumCommandItemsPerPage[1]) {
                this.m_iNumCommandItemsPerPage[1] = n;
            }
        } else if (n == 2701) {
            this.m_pCommandArrowUp[0] = gameObject;
        } else if (n == 2702) {
            this.m_pCommandArrowDown[0] = gameObject;
        } else if (n == 2703) {
            this.m_pCommandArrowUp[1] = gameObject;
        } else if (n == 2704) {
            this.m_pCommandArrowDown[1] = gameObject;
        } else if (n == 2400) {
            this.m_pInteractionItemHighlight = (AnimObject)gameObject;
        } else if (2230 <= n && n < 2235) {
            this.m_panmCommandSequenceArrows[n -= 2230] = (AnimObject)gameObject;
            this.m_xCommandSequenceBaseX = this.m_panmCommandSequenceArrows[n].getX();
            this.m_xCommandSequenceBaseY = this.m_panmCommandSequenceArrows[n].getY();
        } else if (n == 2500) {
            this.m_pboxActionMenuBG = (Box)gameObject;
            this.m_pboxActionMenuBG.m_iStyle = 5;
        } else if (n == 2501) {
            this.m_ptxtActionItemSelected = (TextObject)gameObject;
        } else if (n == 2502) {
            this.m_pActionMenuArrowPrevItem = gameObject;
        } else if (n == 2503) {
            this.m_pActionMenuArrowNextItem = gameObject;
        } else if (n == 2504) {
            this.m_pActionMenuArrowPrevSubItem = gameObject;
        } else if (n == 2505) {
            this.m_pActionMenuArrowNextSubItem = gameObject;
        } else if (n == 2506) {
            this.m_pActionItemIconHighlight = gameObject;
        } else if (2510 <= n && n < 2520) {
            this.m_panmActionItem[n -= 2510] = (AnimObject)gameObject;
            if (++n > this.m_iNumActionItemsPerPage) {
                this.m_iNumActionItemsPerPage = n;
            }
        } else if (2520 <= n && n < 2530) {
            Box box = (Box)gameObject;
            box.m_iStyle = 6;
            box.m_iValue = 5463451;
            this.m_pboxActionItemFrame[n -= 2520] = box;
            if (++n > this.m_iNumActionItemsPerPage) {
                this.m_iNumActionItemsPerPage = n;
            }
        } else if (2530 <= n && n < 2540) {
            this.m_ptxtActionItemStatus[n -= 2530] = (TextObject)gameObject;
            if (++n > this.m_iNumActionItemsPerPage) {
                this.m_iNumActionItemsPerPage = n;
            }
        } else if (n == 2600) {
            this.m_pboxListMenuBG = (Box)gameObject;
            this.m_pboxListMenuBG.m_iStyle = 5;
        } else if (n == 2602) {
            this.m_pListMenuArrowPrevItem = gameObject;
        } else if (n == 2603) {
            this.m_pListMenuArrowNextItem = gameObject;
        } else if (n == 2606) {
            this.m_pListItemIconHighlight = gameObject;
        } else if (2610 <= n && n < 2620) {
            this.m_panmListItem[n -= 2610] = (AnimObject)gameObject;
            if (++n > this.m_iNumListItemsPerPage) {
                this.m_iNumListItemsPerPage = n;
            }
        } else if (2620 <= n && n < 2630) {
            Box box = (Box)gameObject;
            box.m_iStyle = 6;
            box.m_iValue = 5463451;
            this.m_pboxListItemFrame[n -= 2620] = box;
            if (++n > this.m_iNumListItemsPerPage) {
                this.m_iNumListItemsPerPage = n;
            }
        } else if (2630 <= n && n < 2640) {
            this.m_ptxtListItemDesc[n -= 2630] = (TextObject)gameObject;
            if (++n > this.m_iNumListItemsPerPage) {
                this.m_iNumListItemsPerPage = n;
            }
        } else if (2640 <= n && n < 2650) {
            Box box = (Box)gameObject;
            box.m_iStyle = 7;
            this.m_pboxListItemStatus[n -= 2640] = box;
            if (++n > this.m_iNumListItemsPerPage) {
                this.m_iNumListItemsPerPage = n;
            }
        }
        return bl;
    }

    public void onPaintLoading(Graphics graphics, int n) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        if (!this.m_bGameLoaded) {
            n = GameApp.mul(n << 12, 3276) >> 12;
        } else if (n == 80 && (n += GameApp.mul(this.m_iHUDLayoutLoading << 12, 819) >> 12) > 98) {
            n = 98;
        }
        petsApp.drawLoadingBar(graphics, n, Short.MAX_VALUE);
        super.onPaintLoading(graphics, n);
    }

    public int onLoad(int n) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        if (n == 0) {
            this.m_pGame = new PetsGame();
            this.setSearchTimerEnabled(true);
            this.addObject(this.m_pGame);
            this.m_pGame.setZ(-1);
            this.m_pGame.m_bVisible = false;
        }
        if (!this.m_bGameLoaded) {
            if ((n = this.m_pGame.onLoad(n)) >= 100) {
                this.m_bGameLoaded = true;
                n = 79;
            }
        } else {
            if (n == 79) {
                this.m_pListTrainer = new ArrayList();
            } else {
                if (n == 80) {
                    this.m_iHUDLayoutLoading = super.onLoad(this.m_iHUDLayoutLoading);
                    if (this.m_iHUDLayoutLoading < 100) {
                        return n;
                    }
                    return 98;
                }
                if (n == 98) {
                    this.loadAvatarFace();
                }
            }
            ++n;
        }
        return n;
    }

    public void onIdle(int n) {
        Object object;
        int n2;
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n3 = this.m_pDog.m_iThought;
        int n4 = this.m_pDog.m_iDisplayPlusMinus;
        int n5 = this.m_pDog.m_iDisplayFeedBackNeed;
        if (this.m_bDoOpenPause) {
            this.m_bPauseMenuOpen = petsApp.openPauseDialog();
            if (this.m_bPauseMenuOpen) {
                this.m_bDoOpenPause = false;
                return;
            }
        }
        if ((n4 != -1 || n5 != -1) && this.m_iFeedbackDisplayTime == 0) {
            this.m_iFeedbackDisplayTime = 3000;
        }
        if (this.m_panmCursor != null) {
            this.m_panmCursor.onIdle(n);
            if (this.m_iSoapBubbleTimer > 0) {
                if (this.m_panmCursor.m_bVisible) {
                    this.m_iSoapBubbleTimer -= n;
                    if (this.m_iSoapBubbleTimer <= 0) {
                        int n6 = this.m_panmCursor.m_iLeft + this.m_pGame.m_iX;
                        n2 = this.m_panmCursor.m_iTop + this.m_pGame.m_iY;
                        this.m_pGame.startSoapBubble(n6, n2);
                        this.m_iSoapBubbleTimer = 200;
                    }
                } else {
                    this.m_iSoapBubbleTimer = 0;
                }
            }
        }
        if (this.m_iPhase != 18) {
            this.m_pGame.onIdle(n);
        }
        for (int i = 0; i < 5; ++i) {
            if (this.m_pMeterBars[i] == null) continue;
            n2 = this.m_pDog.m_pxNeeds[i];
            Box box = this.m_pMeterBars[i];
            box.m_iValue = n2;
        }
        if (this.m_ptxtSimoleons != null && this.m_ptxtSimoleons.m_iUserData != petsApp.getCurrentSimoleons()) {
            this.m_ptxtSimoleons.m_iUserData = petsApp.getCurrentSimoleons();
            this.m_ptxtSimoleons.setNumber(this.m_ptxtSimoleons.m_iUserData, true);
            this.m_ptxtSimoleons.insertCharAt(0, (byte)32);
            this.m_ptxtSimoleons.insertCharAt(0, (byte)126);
        }
        this.updatePetMood();
        if (this.m_iReactAvatarTimer > 0 && this.m_iReactState != -1) {
            this.m_iReactAvatarTimer -= n;
            if (this.m_iReactAvatarTimer <= 0) {
                this.m_iReactAvatarTimer = 0;
                this.m_iReactState = -1;
            }
        } else {
            this.updateAvatarMood();
        }
        this.updateReactState();
        if (this.m_bSearchTimerActive) {
            this.m_iBushSearchTimer += n;
            if (this.m_pDog.m_bFoundObject) {
                this.m_bFoundItem = true;
                this.setSearchTimerEnabled(false);
                this.hideMenuForInteraction();
            } else if (this.m_iBushSearchTimer > 30000) {
                object = this.m_pGame.getItem(8);
                if (this.m_pDog.m_pInterest == null || this.m_pDog.m_pInterest.m_iType != 2) {
                    this.m_pDog.interrupt(0, 0, (Interactive)object);
                }
                if (this.m_pDog.m_iAction == 0) {
                    this.m_pDog.setAction(9);
                }
                ((Interactive)object).m_xInterestLevel = 409600;
                this.m_iBushSearchTimer = 0;
            }
        }
        if (this.m_iPhase != 7) {
            this.updateReinforcement();
        }
        this.updateBubble(-1);
        this.updateCursor(n);
        if (this.m_iAvatarBalloonTimer > 0) {
            this.m_iAvatarBalloonTimer -= n;
            if (this.m_ppanmSimParts[0] != null) {
                this.m_ppanmSimParts[0].onIdle(n);
            }
            if (this.m_iAvatarBalloonTimer <= 0) {
                this.hideAvatarBubble();
                if (this.m_iStoredInteraction >= 0) {
                    if (this.m_bCommandLearning) {
                        this.startCommandSequence(this.m_iStoredInteraction);
                        this.m_bCommandLearning = false;
                    } else if (this.m_iStoredInteraction == 2) {
                        this.m_pDog.expireNeedTrainingTimer();
                        this.m_pDog.confuse();
                        this.setPhase(0);
                        this.updateSelectionName();
                        this.setShowCursor(false);
                    } else {
                        this.m_pGame.interaction(this.m_iStoredInteraction);
                    }
                    this.m_iStoredInteraction = -1;
                }
            }
            return;
        }
        switch (this.m_iPhase) {
            case 6: {
                this.updateThrowMeter(n);
                break;
            }
            case 5: {
                this.updateThrowDiscBar(n);
                break;
            }
            case 10: {
                if (this.m_pDog.m_iNeedTrainingTimer <= 0 && n3 < 0 && this.m_bCommandLearning) break;
                this.m_bCommandLearning = false;
                this.setPhase(0);
                break;
            }
            case 11: {
                this.updateLearningIcon();
                n3 = -1;
                break;
            }
            case 9: {
                n3 = -1;
                if (this.m_pDog.m_iNumAvailableInteractions <= 0) break;
                if (this.m_pDog.m_bFoundObject) {
                    this.handleFoundItem();
                    break;
                }
                this.m_panmInteractionItem[1].setVisible(true);
                if (this.m_panmInteractionFrame[1] != null) {
                    this.m_panmInteractionFrame[1].setVisible(true);
                }
                if (this.m_pInteractionItemHighlight != null) {
                    this.m_pInteractionItemHighlight.setLocation(this.m_panmInteractionItem[1].getX(), this.m_panmInteractionItem[1].getY());
                    this.m_pInteractionItemHighlight.m_bVisible = true;
                }
                this.m_iCommandMenuCurItem = 1;
                this.m_panmInteractionItem[0].setVisible(true);
                if (this.m_panmInteractionFrame[0] != null) {
                    this.m_panmInteractionFrame[0].setVisible(true);
                }
                if (this.m_pInteractionItemHighlight != null) {
                    this.m_pInteractionItemHighlight.setLocation(this.m_panmInteractionItem[0].getX(), this.m_panmInteractionItem[0].getY());
                    this.m_pInteractionItemHighlight.m_bVisible = true;
                }
                this.m_iCommandMenuCurItem = 0;
                this.setPhase(15);
                break;
            }
            case 15: {
                if (this.m_pDog.m_pInterest == this.m_pGame.getItem(2)) break;
                this.hideInteractionMenu();
                break;
            }
            case 16: {
                if (this.m_pDog.m_pInterest == this.m_pGame.getItem(2)) break;
                this.hideCommandMenu();
                break;
            }
            case 8: {
                this.m_iCommandSequenceTimer -= n;
                if (this.m_iCommandSequenceTimer <= 0) {
                    this.hideCommandSequence();
                    this.m_pDog.confuse();
                    this.setPhase(0);
                    break;
                }
                if (this.m_pboxInputTimer == null) break;
                if (!this.m_pboxInputTimer.m_bVisible && petsApp.getNumPopups() <= 0) {
                    this.m_pboxInputTimer.m_bVisible = true;
                }
                int n7 = this.m_iCommandSequenceTimer;
                n7 <<= 12;
                this.m_pboxInputTimer.m_iValue = n7 /= 5000;
                break;
            }
            case 17: {
                this.m_iCommandSequenceTimer -= n;
                if (this.m_iCommandSequenceTimer > 0) break;
                this.hideCommandSequence();
                this.m_pDog.confuse();
                this.m_pDog.dismiss();
                this.setPhase(0);
                break;
            }
            case 7: {
                this.m_iCommandSequenceTimer -= n;
                if (this.m_iCommandSequenceTimer <= 0) {
                    this.handleTLCSequenceKey(-1);
                    break;
                }
                if (this.m_pboxInputTimer == null) break;
                if (!this.m_pboxInputTimer.m_bVisible && petsApp.getNumPopups() <= 0) {
                    this.m_pboxInputTimer.m_bVisible = true;
                }
                int n8 = this.m_iCommandSequenceTimer;
                n8 <<= 12;
                this.m_pboxInputTimer.m_iValue = n8 /= 5000;
                break;
            }
            case 0: {
                if (this.m_ptxtTrainer != null && !this.m_ptxtTrainer.m_bVisible && this.m_pDog.m_iNeedTrainingTimer <= 0 && n3 < 0) {
                    this.checkTrainer();
                }
                if (this.m_pAcceptSoftKey == null && this.m_iPhase == 0 && this.m_pDog.m_iThought == -1 && !this.m_pDog.m_bTrickResponseTimeOn && !this.m_pDog.m_bCommandResponseTimeOn && this.m_pDog.m_iSuccessAnimState == -1 && this.m_pDog.m_iNeedTrainingTimer <= 0 && this.m_pDog.m_iAction != 12) {
                    this.m_pAcceptSoftKey = this.m_ptxtAcceptSoftKey;
                }
                if (this.m_iReopenMenu > 0 && this.m_ptxtTrainer != null && !this.m_ptxtTrainer.m_bVisible && this.m_pDog.m_iNeedTrainingTimer <= 0 && n3 < 0 && !this.m_pDog.m_bFoundObject) {
                    this.reopenMenu();
                    break;
                }
                if (!this.m_pDog.m_bFoundObject) break;
                this.setPhase(9);
            }
        }
        if (this.m_iPhase != 18 && this.m_iPhase != 0) {
            this.checkTrainer();
        }
        if (this.m_pGame.m_pCurrentObject != this.m_pDog) {
            n3 = -1;
            n4 = -1;
            n5 = -1;
        }
        this.updateBubble(n3);
        if (this.m_iFeedbackDisplayTime > 0) {
            this.m_iFeedbackDisplayTime -= n;
            this.updateFeedback(n5, n4);
            if (this.m_iFeedbackDisplayTime < 0) {
                this.m_iFeedbackDisplayTime = 0;
                this.m_pDog.setDisplayFeedback(-1, -1);
                this.updateFeedback(-1, -1);
            }
        }
        if (this.m_iPhase != 18 && (object = (Object)petsApp.deqGameMessage()) != null) {
            DialogScene dialogScene = new DialogScene(2000, 0, (byte[])object);
            if (dialogScene != null) {
                dialogScene.m_bGameMessage = true;
                petsApp.openScene(dialogScene);
            } else {
                GameApp.releaseStringBuffer((byte[])object);
            }
        }
    }

    public void onReloadText() {
        PetsApp petsApp;
        byte[] byArray;
        if (this.m_iPhase == 18 && this.m_ptxtTrainer != null && (byArray = (petsApp = (PetsApp)GameApp.m_instance).getLastPopup()) != null) {
            this.m_ptxtTrainer.setText(byArray, true);
        }
        super.onReloadText();
    }

    public void onCheckKeysChanged() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n = petsApp.m_iKeysChanged;
        super.onCheckKeysChanged();
        if (this.m_pDog == null || this.m_pGame == null) {
            return;
        }
        boolean bl = false;
        switch (this.m_iPhase) {
            case 7: {
                if ((n & 0x60000) != 0) {
                    this.handleTLCSequenceKey(4);
                    break;
                }
                if ((n & 0x1004) != 0) {
                    this.handleTLCSequenceKey(0);
                    break;
                }
                if ((n & 0x2100) != 0) {
                    this.handleTLCSequenceKey(2);
                    break;
                }
                if ((n & 0x4010) != 0) {
                    this.handleTLCSequenceKey(3);
                    break;
                }
                if ((n & 0x8040) == 0) break;
                this.handleTLCSequenceKey(1);
                break;
            }
            case 6: {
                if ((n & 0x70020) == 0) break;
                if ((n & 0x10020) != 0) {
                    this.m_pGame.throwObject(this.m_pThrowingObject, this.m_pGame.getThrowDirection_X(), this.m_pGame.getThrowDirection_Y(), this.m_pThrowingBar.m_iValue);
                }
                this.setThrowing(null);
                this.m_pGame.m_bKeepCameraNear = true;
                break;
            }
            case 5: {
                if ((n & 0x70020) == 0) break;
                this.m_pThrowingObject.m_xInterestLevel = 409600;
                if ((n & 0x10020) != 0) {
                    int n2 = GameApp.abs(GameApp.mul(this.m_xThrowSuccess, this.m_pThrowingDiscBar.getWidth()));
                    int n3 = this.m_pThrowingDiscBar.m_iLeft + n2;
                    int n4 = this.m_pThrowingDiscBar.getWidth() * 8 / 100;
                    int n5 = this.m_pThrowingDiscArrow.m_iLeft + (this.m_pThrowingDiscArrow.getWidth() >> 1);
                    this.m_pDog.m_bThrowSucceed = n3 <= n5 && n3 + n4 * this.m_pThrowingDiscBar.m_iValue >= n5;
                    this.m_pGame.selectInteractive(this.m_pThrowingObject);
                    this.m_pGame.throwObject(this.m_pThrowingObject, this.m_pDog.m_xWorldX, this.m_pDog.m_xWorldY, 7600);
                }
                this.setThrowing(null);
                this.m_pGame.m_bKeepCameraNear = true;
                break;
            }
            case 2: {
                if ((n & 0x1004) != 0) {
                    this.prevActionMenuSubItem();
                    break;
                }
                if ((n & 0x2100) != 0) {
                    this.nextActionMenuSubItem();
                    break;
                }
                if ((n & 0x4010) != 0) {
                    this.prevActionMenuItem();
                    break;
                }
                if ((n & 0x8040) != 0) {
                    this.nextActionMenuItem();
                    break;
                }
                if ((n & 0x90020) != 0) {
                    this.handleActionMenuSelect();
                    break;
                }
                if ((n & 0x60000) == 0) break;
                if (this.m_iActionMenuCurLevel > 0) {
                    --this.m_iActionMenuCurLevel;
                    this.rebuildActionMenu();
                    break;
                }
                this.hideActionMenu();
                break;
            }
            case 3: {
                if ((n & 0x1004) != 0) {
                    this.prevSuppliesMenuItem();
                    break;
                }
                if ((n & 0x2100) != 0) {
                    this.nextSuppliesMenuItem();
                    break;
                }
                if ((n & 0x90020) != 0) {
                    this.handleSuppliesMenuSelect();
                    break;
                }
                if ((n & 0x60000) == 0) break;
                this.hideListMenu();
                break;
            }
            case 4: {
                if ((n & 0x1004) != 0) {
                    this.prevTrainingMenuItem();
                    break;
                }
                if ((n & 0x2100) != 0) {
                    this.nextTrainingMenuItem();
                    break;
                }
                if ((n & 0x60000) == 0) break;
                this.hideListMenu();
                break;
            }
            case 15: {
                if ((n & 0x90020) != 0) {
                    if (this.m_iCommandMenuCurItem == 0) {
                        this.hideInteractions();
                        this.startTLC();
                        this.m_pGame.interaction(0);
                        break;
                    }
                    if (this.m_pDog.willRefuse()) {
                        this.hideInteractionMenu();
                        petsApp.triggerHint(-2147483644);
                        break;
                    }
                    this.hideInteractions();
                    this.showCommandMenu();
                    break;
                }
                if ((n & 0x60000) != 0) {
                    Toy toy = this.m_pGame.getItem(2);
                    toy.m_xInterestLevel = 0;
                    this.m_pDog.interrupt(1, 0, null);
                    break;
                }
                if ((n & 0x4010) != 0) {
                    if (this.m_iCommandMenuCurItem == 0) break;
                    if (this.m_pInteractionItemHighlight != null) {
                        this.m_pInteractionItemHighlight.setLocation(this.m_panmInteractionItem[0].getX(), this.m_panmInteractionItem[0].getY());
                    }
                    this.m_iCommandMenuCurItem = 0;
                    break;
                }
                if ((n & 0x8040) == 0 || this.m_iCommandMenuCurItem == 1) break;
                if (this.m_pInteractionItemHighlight != null) {
                    this.m_pInteractionItemHighlight.setLocation(this.m_panmInteractionItem[1].getX(), this.m_panmInteractionItem[1].getY());
                }
                this.m_iCommandMenuCurItem = 1;
                break;
            }
            case 16: {
                Toy toy;
                if (n != 0) {
                    toy = this.m_pGame.getItem(2);
                    toy.m_xInterestLevel = 409600;
                }
                if ((n & 0x90020) != 0) {
                    int n6 = this.m_iCommandItems[this.m_iCommandMenuCurGroup][this.m_iCommandMenuCurItem + this.m_iCommandMenuItemOffset[this.m_iCommandMenuCurGroup]];
                    this.hideCommandMenu();
                    this.sayCommand(n6);
                    this.m_iStoredInteraction = n6;
                    this.m_bCommandLearning = this.m_iCommandMenuCurGroup == 1;
                    this.setPhase(10);
                    if (this.m_iAvatarBalloonTimer > 0) break;
                    this.m_iAvatarBalloonTimer = 1;
                    break;
                }
                if ((n & 0x60000) != 0) {
                    toy = this.m_pGame.getItem(2);
                    toy.m_xInterestLevel = 0;
                    this.m_pDog.interrupt(1, 0, null);
                    break;
                }
                if ((n & 0x1004) != 0) {
                    this.prevCommandItem();
                    break;
                }
                if ((n & 0x2100) != 0) {
                    this.nextCommandItem();
                    break;
                }
                if ((n & 0x4010) != 0) {
                    if (this.m_iCommandMenuCurGroup == 0 || this.m_iNumCommandItems[0] <= 0) break;
                    this.m_iCommandMenuCurGroup = 0;
                    if (this.m_iCommandMenuCurItem >= this.m_iNumCommandItemsPerPage[this.m_iCommandMenuCurGroup]) {
                        this.m_iCommandMenuCurItem = this.m_iNumCommandItemsPerPage[this.m_iCommandMenuCurGroup] - 1;
                    }
                    if (this.m_iCommandMenuCurItem >= this.m_iNumCommandItems[1]) {
                        this.m_iCommandMenuCurItem = this.m_iNumCommandItems[1] - 1;
                    }
                    this.updateCommandMenuHighlight();
                    break;
                }
                if ((n & 0x8040) == 0 || this.m_iCommandMenuCurGroup == 1 || this.m_iNumCommandItems[1] <= 0) break;
                this.m_iCommandMenuCurGroup = 1;
                if (this.m_iCommandMenuCurItem >= this.m_iNumCommandItemsPerPage[this.m_iCommandMenuCurGroup]) {
                    this.m_iCommandMenuCurItem = this.m_iNumCommandItemsPerPage[this.m_iCommandMenuCurGroup] - 1;
                }
                if (this.m_iCommandMenuCurItem >= this.m_iNumCommandItems[1]) {
                    this.m_iCommandMenuCurItem = this.m_iNumCommandItems[1] - 1;
                }
                this.updateCommandMenuHighlight();
                break;
            }
            case 8: {
                if (this.m_pDog.m_bTrickSequenceTimeOn) break;
                if ((n & 0x60000) != 0) {
                    this.handleCommandSequenceKey(4);
                    break;
                }
                if ((n & 0x1004) != 0) {
                    this.handleCommandSequenceKey(0);
                    break;
                }
                if ((n & 0x2100) != 0) {
                    this.handleCommandSequenceKey(2);
                    break;
                }
                if ((n & 0x4010) != 0) {
                    this.handleCommandSequenceKey(3);
                    break;
                }
                if ((n & 0x8040) == 0) break;
                this.handleCommandSequenceKey(1);
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                if ((n & 0x90020) != 0) {
                    if (this.m_ptxtTrainer != null && this.m_ptxtTrainer.m_bVisible) {
                        this.hideTrainer();
                    }
                    this.m_pDog.setThought(-1);
                    if (this.m_iPreTrainerPhase == 8) {
                        this.m_iCommandSequenceTimer = 5000;
                    } else if (this.m_iPreTrainerPhase == 7) {
                        this.m_iCommandSequenceTimer = 5000;
                    }
                    this.setPhase(this.m_iPreTrainerPhase);
                    break;
                }
                bl = true;
                break;
            }
            case 0: {
                if ((n & 0x10020) != 0) {
                    if (this.m_pDog.m_iNeedTrainingTimer > 0) {
                        if (this.m_iPraiseOrScold == 2) {
                            this.showAvatarBubbleIcon(3);
                            petsApp.playSound(90);
                            this.m_iStoredInteraction = 3;
                            this.m_bScolded = true;
                        } else {
                            this.showAvatarBubbleIcon(2);
                            petsApp.playSound(92);
                            this.m_iStoredInteraction = 1;
                            this.m_bPraised = true;
                            this.m_bMakeExcited = true;
                        }
                        if (this.m_iPraiseOrScold != this.m_iWantPraiseOrScold) {
                            this.m_iStoredInteraction = 2;
                        }
                        this.setPhase(11);
                        this.setSelectionName(67);
                        if (this.m_iAvatarBalloonTimer <= 0) {
                            this.m_pGame.interaction(this.m_iStoredInteraction);
                        }
                        n = 0;
                    } else {
                        Toy toy = this.m_pGame.getItem(0);
                        boolean bl2 = true;
                        if (toy != null && toy.m_bVisible) {
                            bl2 = false;
                            if (this.m_pDog.m_pCarry == null && !toy.isMoving() && this.m_pGame.isInInteractionArea(toy) && this.m_pGame.isInCatchDiscArea(this.m_pDog)) {
                                this.setThrowing(toy);
                                break;
                            }
                            if (!toy.isMoving() && this.m_pDog.m_pCarry == null && this.m_pGame.isInInteractionArea(toy)) {
                                byte[] byArray = null;
                                byte[] byArray2 = null;
                                byte[][] byArrayArray = new byte[][]{this.m_pDog.m_pyName};
                                byArray = GameApp.loadStringResource(242);
                                byArray2 = GameApp.formatStringBuffer(byArray, byArrayArray, 1);
                                GameApp.releaseStringBuffer(byArray);
                                DialogScene dialogScene = new DialogScene(242, 0, byArray2);
                                if (dialogScene == null) break;
                                dialogScene.m_bGameMessage = true;
                                petsApp.openScene(dialogScene);
                                break;
                            }
                        }
                        if ((toy = this.m_pGame.getItem(3)) != null && toy.m_bVisible) {
                            bl2 = false;
                            if (!toy.isMoving() && this.m_pGame.isInInteractionArea(toy) && this.m_pDog.m_pCarry == null) {
                                this.setThrowing(toy);
                                break;
                            }
                            if (this.m_pDog.m_pCarry != null) {
                                bl2 = true;
                            }
                        }
                        if (this.m_pDog.m_iThought > -1) {
                            bl2 = false;
                        }
                        if (bl2 && this.m_pDog.m_iAction != 12 && (this.m_pDog.m_pInterest == null || this.m_pDog.m_pInterest != null && this.m_pDog.m_pInterest.m_iType != 2)) {
                            Toy toy2;
                            if (this.m_pDog.m_iState != 10) {
                                toy = this.m_pGame.getItem(3);
                                if (this.m_pDog.m_pCarry == toy) {
                                    toy = this.m_pGame.getItem(2);
                                    toy.m_xInterestLevel = 409600;
                                    this.m_pDog.interrupt(0, 0, toy);
                                } else {
                                    this.m_pDog.onUserSelected();
                                }
                            }
                            if (!this.m_pGame.isInInteractionArea(this.m_pDog)) {
                                this.showAvatarBubbleIcon(8);
                                petsApp.playSound(91);
                            }
                            if (this.m_pDog.m_iState == 10 || this.m_pDog.m_pCarry == (toy2 = this.m_pGame.getItem(3))) break;
                            this.setPhase(9);
                            break;
                        }
                    }
                } else if (this.m_pDog.m_iNeedTrainingTimer > 0) {
                    if ((n & 0x4010) != 0) {
                        int n7 = 2;
                        if (this.m_panmInteractionItem[3].getX() < this.m_panmInteractionItem[2].getX()) {
                            n7 = 3;
                        }
                        if (n7 != this.m_iCommandMenuCurItem) {
                            if (this.m_pInteractionItemHighlight != null) {
                                AnimObject animObject = this.m_panmInteractionItem[n7];
                                this.m_pInteractionItemHighlight.setLocation(animObject.m_iX, animObject.m_iY);
                            }
                            this.m_iPraiseOrScold = n7;
                        }
                        n = 0;
                    } else if ((n & 0x8040) != 0) {
                        int n8 = 2;
                        if (this.m_panmInteractionItem[3].getX() > this.m_panmInteractionItem[2].getX()) {
                            n8 = 3;
                        }
                        if (n8 != this.m_iCommandMenuCurItem) {
                            if (this.m_pInteractionItemHighlight != null) {
                                AnimObject animObject = this.m_panmInteractionItem[n8];
                                this.m_pInteractionItemHighlight.setLocation(animObject.m_iX, animObject.m_iY);
                            }
                            this.m_iPraiseOrScold = n8;
                        }
                        n = 0;
                    }
                }
                if ((n & 0x80000) != 0 && this.m_pAcceptSoftKey != null) {
                    this.showActionMenu();
                    break;
                }
            }
            default: {
                bl = true;
            }
        }
        if (bl && (n & 0x60000) != 0) {
            this.m_bPauseMenuOpen = petsApp.openPauseDialog();
            if (this.m_bPauseMenuOpen) {
                this.m_bDoOpenPause = false;
            }
        }
    }

    public void onPaint(Graphics graphics) {
        this.m_pGame.onPaint(graphics);
        graphics.setClip(this.m_rctViewPort[0] >> 12, this.m_rctViewPort[1] >> 12, this.m_iViewPortWidth >> 12, this.m_iViewPortHeight >> 12);
        super.onPaint(graphics);
    }
}

