/*
 * Decompiled with CFR 0.152.
 */
package sims_pets;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import sims_pets.AnimObject;
import sims_pets.Box;
import sims_pets.GameApp;
import sims_pets.GameObject;
import sims_pets.PetsApp;
import sims_pets.Scene;
import sims_pets.TextObject;

public class GameScene
extends Scene {
    public static final int kSoftKeyAcceptID = 99;
    public static final int kSoftKeyCancelID = 98;
    public static final int kCheatShowMem = 0;
    public static final int kCheatHighest = 0;
    public static final int kMaxNumCheats = 16;
    public static final int kCheatKeyTimeMS = 1000;
    public static final int kDataOffset = 14;
    public static final int kTypeGameObject = 1;
    public static final int kTypeAnimObject = 2;
    public static final int kTypeTextObject = 3;
    public static final int kTypeBoxObject = 4;
    private byte[] m_pyData;
    private int m_iItems;
    private int m_iCurItem;
    private int m_iCurOffset;
    private int m_iFileSize;
    private int m_iProgressStep;
    protected boolean m_bPaintBackground;
    protected int m_iSceneID;
    protected int m_iBackgroundColor;
    protected Image m_pimgBackground;
    protected byte[] m_pyLoadingLocationString;

    public GameScene(int n) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        this.m_iSceneID = n;
        this.m_bPaintBackground = true;
        switch (n) {
            case 70: {
                this.m_pyLoadingLocationString = GameApp.loadStringResource(1);
                break;
            }
            case 69: {
                this.m_pyLoadingLocationString = GameApp.loadStringResource(268);
                break;
            }
            case 74: {
                if (petsApp.getCurrentLocation() == 0) {
                    this.m_pyLoadingLocationString = GameApp.loadStringResource(176);
                    break;
                }
                if (petsApp.getCurrentLocation() != 1) break;
                this.m_pyLoadingLocationString = GameApp.loadStringResource(175);
            }
        }
    }

    public boolean onAddObject(GameObject gameObject) {
        int n = gameObject.m_iInstanceID;
        if (n == 99) {
            this.m_pAcceptSoftKey = gameObject;
            gameObject.m_bVisible = false;
        } else if (n == 98) {
            this.m_pCancelSoftKey = gameObject;
            gameObject.m_bVisible = false;
        }
        return true;
    }

    public int onClose() {
        if (this.m_pimgBackground != null) {
            GameApp.releaseImageResource(this.m_pimgBackground);
            this.m_pimgBackground = null;
        }
        return super.onClose();
    }

    public int onLoad(int n) {
        if (this.m_iSceneID > -1) {
            GameObject gameObject = null;
            int n2 = 0;
            int[] nArray = new int[4];
            if (n == 0) {
                this.m_iCurOffset = 0;
                this.m_pyData = GameApp.loadBinaryResource(this.m_iSceneID);
                this.m_iFileSize = GameApp.arrayToIntLE(this.m_pyData, this.m_iCurOffset);
                this.m_iCurOffset += 4;
                this.m_iItems = this.m_pyData[this.m_iCurOffset] & 0xFF;
                ++this.m_iCurOffset;
                this.m_iProgressStep = this.m_iItems <= 8 ? 100 : GameApp.div(409600, this.m_iItems << 12 >> 3) >> 12;
                int n3 = GameApp.arrayToIntLE(this.m_pyData, this.m_iCurOffset);
                this.m_iCurOffset += 4;
                if (n3 > -1) {
                    this.m_pimgBackground = GameApp.loadImageResource(n3, 0);
                }
                this.m_iBackgroundColor = GameApp.arrayToIntLE(this.m_pyData, this.m_iCurOffset);
                this.m_iCurOffset += 4;
                nArray[0] = GameApp.arrayToShortLE(this.m_pyData, this.m_iCurOffset) << 12;
                this.m_iCurOffset += 2;
                nArray[1] = GameApp.arrayToShortLE(this.m_pyData, this.m_iCurOffset) << 12;
                this.m_iCurOffset += 2;
                n3 = GameApp.arrayToShortLE(this.m_pyData, this.m_iCurOffset) << 12;
                this.m_iCurOffset += 2;
                nArray[2] = GameApp.arrayToShortLE(this.m_pyData, this.m_iCurOffset) << 12;
                this.m_iWidth = nArray[2];
                this.m_iCurOffset += 2;
                nArray[3] = GameApp.arrayToShortLE(this.m_pyData, this.m_iCurOffset) << 12;
                this.m_iHeight = nArray[3];
                this.m_iCurOffset += 2;
                this.setViewPort(nArray[0], nArray[1], nArray[0] + nArray[2], nArray[1] + nArray[3]);
                n = 1;
            } else if (this.m_pyData != null) {
                int n4 = 8;
                if (this.m_iItems - this.m_iCurItem >= 0 && this.m_iItems - this.m_iCurItem < n4) {
                    n4 = this.m_iItems - this.m_iCurItem;
                }
                for (int i = 0; i < n4; ++i) {
                    n2 = this.m_pyData[this.m_iCurOffset] & 0xFF;
                    ++this.m_iCurOffset;
                    ++this.m_iCurItem;
                    switch (n2) {
                        case 1: {
                            gameObject = new GameObject();
                            break;
                        }
                        case 2: {
                            gameObject = new AnimObject();
                            break;
                        }
                        case 3: {
                            gameObject = new TextObject();
                            break;
                        }
                        case 4: {
                            gameObject = new Box();
                            break;
                        }
                        default: {
                            gameObject = null;
                        }
                    }
                    if (gameObject == null) continue;
                    int n5 = GameApp.arrayToIntLE(this.m_pyData, this.m_iCurOffset);
                    this.m_iCurOffset += 4;
                    gameObject.m_iInstanceID = n5;
                    n5 = GameApp.arrayToIntLE(this.m_pyData, this.m_iCurOffset);
                    this.m_iCurOffset += 4;
                    gameObject.m_iUserData = n5;
                    n5 = this.m_pyData[this.m_iCurOffset] & 0xFF;
                    ++this.m_iCurOffset;
                    gameObject.m_bVisible = n5 != 0;
                    gameObject.m_iX = n5 = GameApp.arrayToShortLE(this.m_pyData, this.m_iCurOffset) << 12;
                    this.m_iCurOffset += 2;
                    gameObject.m_iY = n5 = GameApp.arrayToShortLE(this.m_pyData, this.m_iCurOffset) << 12;
                    this.m_iCurOffset += 2;
                    n5 = GameApp.arrayToShortLE(this.m_pyData, this.m_iCurOffset) << 12;
                    if (n5 >= 0x8000000) {
                        n5 -= 0x10000000;
                    }
                    gameObject.setZ(n5);
                    this.m_iCurOffset += 2;
                    gameObject.m_iWidth = n5 = GameApp.arrayToShortLE(this.m_pyData, this.m_iCurOffset) << 12;
                    this.m_iCurOffset += 2;
                    gameObject.m_iHeight = n5 = GameApp.arrayToShortLE(this.m_pyData, this.m_iCurOffset) << 12;
                    this.m_iCurOffset += 2;
                    gameObject.onUpdateRect();
                    if (n2 == 2) {
                        n5 = GameApp.arrayToIntLE(this.m_pyData, this.m_iCurOffset);
                        this.m_iCurOffset += 4;
                        int n6 = this.m_pyData[this.m_iCurOffset] & 0xFF;
                        ++this.m_iCurOffset;
                        if (n5 > -1 && gameObject.onLoadResource(n5)) {
                            ((AnimObject)gameObject).setState(n6, 0, false);
                        }
                    } else if (n2 == 3) {
                        n5 = GameApp.arrayToIntLE(this.m_pyData, this.m_iCurOffset);
                        this.m_iCurOffset += 4;
                        if (n5 > -1) {
                            ((TextObject)gameObject).setText(n5);
                        }
                        n5 = GameApp.arrayToIntLE(this.m_pyData, this.m_iCurOffset);
                        this.m_iCurOffset += 4;
                        n5 = this.m_pyData[this.m_iCurOffset] & 0xFF;
                        ++this.m_iCurOffset;
                        ((TextObject)gameObject).setHorzJustification(n5 >> 4 & 0xF);
                        ((TextObject)gameObject).setVertJustification(n5 & 0xF);
                        n5 = GameApp.arrayToIntLE(this.m_pyData, this.m_iCurOffset);
                        this.m_iCurOffset += 4;
                        ((TextObject)gameObject).setBackgroundColor(n5);
                        n5 = GameApp.arrayToIntLE(this.m_pyData, this.m_iCurOffset);
                        this.m_iCurOffset += 4;
                        ((TextObject)gameObject).setBorderColor(n5);
                    }
                    if (this.onAddObject(gameObject)) {
                        this.addObject(gameObject);
                        continue;
                    }
                    gameObject.m_bRemove = true;
                    this.m_listRemoved.addElement(gameObject);
                }
                n += this.m_iProgressStep;
            }
            if (n >= 100) {
                if (this.m_pyData != null) {
                    GameApp.releaseBinaryResource(this.m_pyData);
                    this.m_pyData = null;
                }
                return super.onLoad(0);
            }
        }
        return n;
    }

    public void onPaint(Graphics graphics) {
        if (this.m_bPaintBackground) {
            graphics.setClip(this.m_rctViewPort[0] >> 12, this.m_rctViewPort[1] >> 12, this.m_rctViewPort[2] >> 12, this.m_rctViewPort[3] >> 12);
            if (this.m_pimgBackground != null) {
                graphics.drawImage(this.m_pimgBackground, this.m_iX >> 12, this.m_iY >> 12, 0);
            } else {
                graphics.setColor(this.m_iBackgroundColor);
                graphics.fillRect(this.m_rctViewPort[0] >> 12, this.m_rctViewPort[1] >> 12, this.m_iViewPortWidth >> 12, this.m_iViewPortHeight >> 12);
            }
        }
        super.onPaint(graphics);
    }
}

