/*
 * Decompiled with CFR 0.152.
 */
package sims_pets;

import bundle.BundleMidlet;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import sims_pets.ArrayList;
import sims_pets.DeviceInfo;
import sims_pets.Font;
import sims_pets.GameObject;
import sims_pets.PetsCanvas;
import sims_pets.Scene;
import sims_pets.SoundManager;

public abstract class GameApp
implements Runnable,
DeviceInfo {
    public static BundleMidlet bMidlet;
    public static final boolean WAP_SUPPORTED = true;
    public static final boolean DEBUG = false;
    public static final boolean SHOW_MEM_TRACE = false;
    public static final boolean NEEDS_GC = false;
    public static final boolean ENABLE_CLASS_PRELOADING = false;
    public static final int key0 = 1;
    public static final int key1 = 2;
    public static final int key2 = 4;
    public static final int key3 = 8;
    public static final int key4 = 16;
    public static final int key5 = 32;
    public static final int key6 = 64;
    public static final int key7 = 128;
    public static final int key8 = 256;
    public static final int key9 = 512;
    public static final int keySTAR = 1024;
    public static final int keyPOUND = 2048;
    public static final int keyUp = 4096;
    public static final int keyDown = 8192;
    public static final int keyLeft = 16384;
    public static final int keyRight = 32768;
    public static final int keySELECT = 65536;
    public static final int keyCLR = 131072;
    public static final int keySOFTCANCEL = 262144;
    public static final int keySOFTACCEPT = 524288;
    public static final int kNumCharacterMaps = 11;
    public static final byte FORMAT_CONTROL_CHAR = 37;
    public static final int kSmallBufferSize = 64;
    public static final int kSmallBufferCount = 32;
    public static final int kMediumBufferSize = 256;
    public static final int kMediumBufferCount = 16;
    public static final int kLargeBufferSize = 1024;
    public static final int kLargeBufferCount = 8;
    public static final int kGiantBufferSize = 2048;
    public static final int kGiantBufferCount = 4;
    public static final int kFixed_Neg1 = -4096;
    public static final int kFixed_1 = 4096;
    public static final int kFixed_2 = 8192;
    public static final int kFixed_3 = 12288;
    public static final int kFixed_4 = 16384;
    public static final int kFixed_5 = 20480;
    public static final int kFixed_7 = 28672;
    public static final int kFixed_8 = 32768;
    public static final int kFixed_10 = 40960;
    public static final int kFixed_15 = 61440;
    public static final int kFixed_20 = 81920;
    public static final int kFixed_30 = 122880;
    public static final int kFixed_40 = 163840;
    public static final int kFixed_50 = 204800;
    public static final int kFixed_90 = 368640;
    public static final int kFixed_100 = 409600;
    public static final int kFixed_120 = 491520;
    public static final int kFixed_150 = 614400;
    public static final int kFixed_270 = 0x10E000;
    public static final int kFixed_360 = 1474560;
    public static final int kFixed_1000 = 4096000;
    public static final int kFixed_PointZeroThreeOneTwoFive = 128;
    public static final int kFixed_PointZeroSixTwoFive = 256;
    public static final int kFixed_PointOne = 409;
    public static final int kFixed_PointOneTwoFive = 512;
    public static final int kFixed_PointTwoFive = 1024;
    public static final int kFixed_PointFive = 2048;
    public static final int kFixed_PointSevenFive = 3072;
    public static final int kFixed_1PointTwoFive = 5120;
    public static final int kFixed_1PointFive = 6144;
    public static final int kFixed_OneThird = 1365;
    public static final int kFixed_TwoThirds = 2730;
    public static final int kPi = 12868;
    public static final int k2Pi = 25736;
    public static final int kHalfPi = 6434;
    public static final int kQuarterPi = 3217;
    public static final int kSixthPi = 2144;
    public static final int kTwelfthPi = 1072;
    public static final int kTanSixthPi = 2364;
    public static final int kTanTwelfthPi = 1097;
    public static final int kRadianCoeff = 234683;
    public static final int kFixedSin45 = 2896;
    public static final int k4OverPi = 5215;
    public static final int k724Fixed_1 = 0x1000000;
    public static final int k724SixthPi = 8784529;
    public static final int k724TanTwelfthPi = 4495441;
    public static final int k724TanSixthPi = 9686330;
    public static final int k724HalfPi = 26353589;
    private Random m_pRandom = new Random();
    protected boolean m_bInitialized;
    protected boolean m_bQuitRequested;
    protected int m_iErrorMsg;
    protected ArrayList m_listScenes = new ArrayList();
    protected Scene m_pSceneLoading;
    protected int m_iLoadProgress;
    protected int m_iDeferredScene = -1;
    private boolean m_bWaitBeforeLoad = false;
    protected ArrayList m_listOpening = new ArrayList();
    protected ArrayList m_listClosing = new ArrayList();
    protected int m_iKeysDown;
    protected int m_iKeysChanged;
    protected boolean m_bRedrawStack = true;
    protected boolean m_bSkipDraw;
    protected Font m_pFont;
    protected byte[][] m_pStrings;
    protected int[] m_pResFileSizes;
    protected boolean m_bShuttingDown;
    protected boolean m_bGamePaused;
    protected boolean m_bDemoMode;
    protected ArrayList m_listImageCache;
    protected int[] m_iaryImageRefs;
    protected int m_iImageCacheSize;
    protected ArrayList m_plstBuffersInUse;
    protected ArrayList m_plstSmallBuffers;
    protected ArrayList m_plstMediumBuffers;
    protected ArrayList m_plstLargeBuffers;
    protected ArrayList m_plstGiantBuffers;
    protected SoundManager m_pSoundManager;
    public byte[][] m_pCharKeyMap = new byte[11][];
    public long m_lMemCreate;
    public long m_lMemStartup;
    protected int m_iScreenWidth;
    protected int m_iScreenHeight;
    protected int m_iScreenDepth;
    public boolean m_bShowFPS;
    public boolean m_bShowMem;
    public boolean m_bAblePlayVib = true;
    public static GameApp m_instance;
    public static Graphics m_pGraphics;
    private PetsCanvas gameCanvas = null;
    private Thread idleThread = null;
    public int msElapsed = 0;
    private long msPreviousTime = 0L;
    public boolean m_bPainted = true;
    public boolean m_bVerbose = false;
    public boolean m_bDrawingSKSwap = false;
    protected long lPaintTime;
    boolean moneyCheat = false;

    public static int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public static int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public static int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static final int mul(int n, int n2) {
        return (int)((long)n * (long)n2 >> 12);
    }

    public static final int div(int n, int n2) {
        return (int)(((long)n << 12) / (long)n2);
    }

    public static int sqrt(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        int n5 = 21;
        do {
            n3 = n3 << 2 | n4 >> 30 & 3;
            n4 <<= 2;
            int n6 = ((n2 <<= 1) << 1) + 1;
            if (((long)n3 & 0xFFFFFFFFL) < ((long)n6 & 0xFFFFFFFFL)) continue;
            n3 -= n6;
            ++n2;
        } while (n5-- != 0);
        return n2;
    }

    public static int exp(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        if (n2 == 0) {
            return 1;
        }
        if (n2 == 1) {
            return n;
        }
        if (n2 < 0) {
            return -1;
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 *= n;
        }
        return n;
    }

    public static int normalize3D(int[] nArray, int[] nArray2) {
        int n = (int)((long)nArray2[0] * (long)nArray2[0] >> 12);
        n += (int)((long)nArray2[1] * (long)nArray2[1] >> 12);
        if ((n += (int)((long)nArray2[2] * (long)nArray2[2] >> 12)) != 0 && n != 4096) {
            n = GameApp.sqrt(n);
            int n2 = GameApp.div(4096, n);
            nArray[0] = (int)((long)nArray2[0] * (long)n2 >> 12);
            nArray[1] = (int)((long)nArray2[1] * (long)n2 >> 12);
            nArray[2] = (int)((long)nArray2[2] * (long)n2 >> 12);
        }
        return n;
    }

    public static int cos(int n) {
        int n2 = 0;
        while (n >= 25736) {
            n -= 25736;
        }
        while (n < 0) {
            n += 25736;
        }
        int n3 = GameApp.div(n, 6434) >> 12;
        switch (n3) {
            case 0: {
                n2 = n;
                break;
            }
            case 1: {
                n2 = 12868 - n;
                break;
            }
            case 2: {
                n2 = n - 12868;
                break;
            }
            case 3: {
                n2 = 25736 - n;
            }
        }
        int n4 = (int)((long)(n2 <<= 12) * (long)n2 >> 24);
        int n5 = (int)(16767201L + ((long)n4 * (-8314464L + (617261L * (long)n4 >> 24)) >> 24));
        n5 >>= 12;
        if (n3 == 1 || n3 == 2) {
            n5 = -n5;
        }
        return n5;
    }

    public static int sin(int n) {
        return GameApp.cos(6434 - n);
    }

    public static int deg2Rad(int n) {
        return GameApp.div(n, 234683);
    }

    public static int rad2Deg(int n) {
        return GameApp.mul(n, 234683);
    }

    public static int nextInt() {
        return GameApp.m_instance.m_pRandom.nextInt();
    }

    public static GameApp getInstance() {
        return m_instance;
    }

    public void setScreenWidth(int n) {
        this.m_iScreenWidth = n;
    }

    public void setScreenHeight(int n) {
        this.m_iScreenHeight = n;
    }

    public void setScreenDepth(int n) {
        this.m_iScreenDepth = n;
    }

    public int getScreenWidth() {
        return this.m_iScreenWidth;
    }

    public int getScreenHeight() {
        return this.m_iScreenHeight;
    }

    public int getScreenDepth() {
        return this.m_iScreenDepth;
    }

    public int getFixedScreenWidth() {
        return this.m_iScreenWidth << 12;
    }

    public int getFixedScreenHeight() {
        return this.m_iScreenHeight << 12;
    }

    public int getKeysDown() {
        return this.m_iKeysDown;
    }

    public int getKeysChanged() {
        return this.m_iKeysChanged;
    }

    public Graphics getGraphics() {
        return m_pGraphics;
    }

    public void forceRepaint() {
        this.m_bRedrawStack = true;
    }

    public int getLoadProgress() {
        return this.m_iLoadProgress;
    }

    public final void setDeferredScene(int n) {
        this.m_iDeferredScene = n;
    }

    public Scene getLoadingScene() {
        return this.m_pSceneLoading;
    }

    public Scene getCurrentScene() {
        if (this.m_listScenes.elementCount > 0) {
            Scene scene = (Scene)this.m_listScenes.lastElement();
            return scene;
        }
        return null;
    }

    public void openScene(Scene scene) {
        this.m_listOpening.addElement(scene);
    }

    public void closeScene(Scene scene) {
        if (this.m_listClosing.indexOf(scene) == -1) {
            this.m_listClosing.addElement(scene);
        }
        this.m_iKeysChanged = 0;
    }

    public void closeAllScenes() {
        Object object;
        int n;
        for (n = this.m_listScenes.elementCount - 1; n >= 0; --n) {
            object = this.m_listScenes.elementData[n];
            if (this.m_listClosing.indexOf(object) != -1) continue;
            this.m_listClosing.addElement(object);
        }
        for (n = this.m_listOpening.elementCount - 1; n >= 0; --n) {
            object = this.m_listOpening.elementData[n];
            if (this.m_listClosing.indexOf(object) != -1) continue;
            this.m_listClosing.addElement(object);
        }
        this.m_listOpening.removeAllElements();
        this.m_pSceneLoading = null;
    }

    public void exitApp() {
        this.m_bQuitRequested = true;
    }

    public boolean quitRequested() {
        return this.m_bQuitRequested;
    }

    public void setErrorMsg(int n) {
        this.m_iErrorMsg = n;
    }

    public int getErrorMsg() {
        return this.m_iErrorMsg;
    }

    public static Image loadImageResource(int n, int n2) {
        String string = "/";
        string = string + (n & 0xFFF);
        Image image = null;
        try {
            image = Image.createImage((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public static void releaseImageResource(Image image) {
    }

    protected final void loadStrings(int n) {
        if (n >= 0) {
            byte[] byArray = GameApp.loadBinaryResource(n);
            int n2 = 4;
            if (byArray != null && byArray.length >= 4) {
                int n3 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
                this.m_pStrings = new byte[n3 + 1][];
                for (int i = 0; i <= n3; ++i) {
                    int n4;
                    for (n4 = n2; n4 < byArray.length && byArray[n4] != 0; ++n4) {
                    }
                    int n5 = n4 - n2 + 1;
                    this.m_pStrings[i] = new byte[n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        this.m_pStrings[i][n4] = byArray[n2 + n4];
                    }
                    n2 += n5;
                }
            }
        }
    }

    public static byte[] loadStringResource(int n) {
        if (n >= 0 && n < GameApp.m_instance.m_pStrings.length) {
            return GameApp.dupeStringBuffer(GameApp.m_instance.m_pStrings[n]);
        }
        return null;
    }

    public static byte[] loadVersionStringResource() {
        String string = bMidlet.getAppProperty("MIDlet-Version");
        if (string != null) {
            return string.getBytes();
        }
        return null;
    }

    public static byte[] loadBinaryResource(int n) {
        n &= 0xFFF;
        if (GameApp.m_instance.m_pResFileSizes == null) {
            return null;
        }
        String string = "/";
        string = string + n;
        byte[] byArray = new byte[GameApp.m_instance.m_pResFileSizes[n]];
        try {
            InputStream inputStream = m_instance.getClass().getResourceAsStream(string);
            int n2 = inputStream.read(byArray);
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    public static void releaseBinaryResource(byte[] byArray) {
    }

    public static byte[] getStringBuffer(int n) {
        return new byte[n];
    }

    public static int getStringBufferLength(byte[] byArray) {
        int n = 0;
        if (byArray != null) {
            while (byArray[n] != 0) {
                ++n;
            }
        }
        return n;
    }

    public static byte[] getStringBufferForNumber(int n) {
        byte[] byArray = null;
        int n2 = n;
        int n3 = 0;
        int n4 = 1;
        if (n2 < 0) {
            ++n3;
            n2 = -n2;
        }
        while (n2 / n4 != 0) {
            n4 *= 10;
            ++n3;
        }
        int n5 = 0;
        if (n3 == 0) {
            byArray = GameApp.getStringBuffer(2);
            byArray[0] = 48;
            byArray[1] = 0;
        } else {
            byArray = GameApp.getStringBuffer(n3 + 1);
            if (n < 0) {
                byArray[0] = 45;
                n5 = 1;
                n = -n;
            }
            n4 = 10;
            int n6 = n3;
            while (--n6 >= n5) {
                byArray[n6] = (byte)(48 + (n - n4 * (n / n4)));
                n /= 10;
            }
            byArray[n3] = 0;
        }
        return byArray;
    }

    public static byte[] dupeStringBuffer(byte[] byArray) {
        byte[] byArray2 = null;
        int n = 0;
        while (byArray[n] != 0) {
            ++n;
        }
        byArray2 = GameApp.getStringBuffer(++n);
        int n2 = 0;
        while (byArray[n2] != 0) {
            byArray2[n2] = byArray[n2];
            ++n2;
        }
        byArray2[n2] = 0;
        return byArray2;
    }

    public static byte[] formatStringBuffer(byte[] byArray, byte[][] byArray2, int n) {
        byte[] byArray3 = null;
        int n2 = 0;
        if (n < 0) {
            n = 0;
        }
        if (n > 9) {
            n = 9;
        }
        if (byArray != null) {
            int n3;
            int n4 = 0;
            while (byArray[n4] != 0) {
                n2 = byArray[n4] == 37 && byArray[n3 = n4 + 1] != 0 && 0 <= (n3 = byArray[n3] - 49) && n3 < n ? (n2 += GameApp.getStringBufferLength(byArray2[n3])) : ++n2;
                ++n4;
            }
            byArray3 = GameApp.getStringBuffer(n2 + 1);
            n2 = 0;
            n4 = 0;
            while (byArray[n4] != 0) {
                if (byArray[n4] == 37 && byArray[n3 = n4 + 1] != 0 && 0 <= (n3 = byArray[n3] - 49) && n3 < n) {
                    int n5 = GameApp.getStringBufferLength(byArray2[n3]);
                    for (int i = 0; i < n5; ++i) {
                        byArray3[n2] = byArray2[n3][i];
                        ++n2;
                    }
                    ++n4;
                } else {
                    byArray3[n2] = byArray[n4];
                    ++n2;
                }
                ++n4;
            }
            byArray3[n2] = 0;
        }
        return byArray3;
    }

    public static void releaseStringBuffer(byte[] byArray) {
    }

    public Font getFont() {
        return this.m_pFont;
    }

    public void setShuttingDown(boolean bl) {
        this.m_bShuttingDown = bl;
    }

    public boolean isShuttingDown() {
        return this.m_bShuttingDown;
    }

    public void setGamePaused(boolean bl) {
        this.m_bGamePaused = bl;
    }

    public boolean getGamePaused() {
        return this.m_bGamePaused;
    }

    public void setSoundManager(SoundManager soundManager) {
        this.m_pSoundManager = soundManager;
    }

    public SoundManager getSoundManager() {
        return this.m_pSoundManager;
    }

    public void setDemoMode(boolean bl) {
        this.m_bDemoMode = bl;
    }

    public boolean getDemoMode() {
        return this.m_bDemoMode;
    }

    public static void intToArrayBE(int n, byte[] byArray, int n2) {
        n2 += 4;
        for (int i = 0; i < 4; ++i) {
            byArray[--n2] = (byte)(n & 0xFF);
            n >>= 8;
        }
    }

    public static int arrayToIntBE(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            n2 <<= 8;
            n2 |= byArray[n] & 0xFF;
            ++n;
        }
        return n2;
    }

    public static void intToArrayLE(int n, byte[] byArray, int n2) {
        for (int i = 0; i < 4; ++i) {
            byArray[n2] = (byte)(n & 0xFF);
            n >>= 8;
            ++n2;
        }
    }

    public static int arrayToIntLE(byte[] byArray, int n) {
        int n2 = 0;
        n += 4;
        for (int i = 0; i < 4; ++i) {
            n2 <<= 8;
            n2 |= byArray[--n] & 0xFF;
        }
        return n2;
    }

    public static int arrayToShortLE(byte[] byArray, int n) {
        int n2 = 0;
        n += 2;
        for (int i = 0; i < 2; ++i) {
            n2 <<= 8;
            n2 |= byArray[--n] & 0xFF;
        }
        return n2;
    }

    public final void makePlatformRequest(String string) {
        if (string != null) {
            try {
                BundleMidlet.bunMid.platformRequest(string);
                BundleMidlet.bunMid.notifyDestroyed();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void flushGraphics() {
        this.onPaint(this.getGraphics());
        this.gameCanvas.flushGraphics();
    }

    public abstract int onStartFirstScene();

    public abstract void onDeferredScene();

    protected abstract void initApp();

    public void startApp() {
        bMidlet = BundleMidlet.bunMid;
        if (!this.m_bInitialized) {
            this.m_bInitialized = true;
            m_instance = this;
            this.gameCanvas = new PetsCanvas();
            Display.getDisplay((MIDlet)bMidlet).setCurrent((Displayable)this.gameCanvas);
            this.m_pSoundManager = new SoundManager();
            m_pGraphics = this.gameCanvas.getGraphics();
            String string = bMidlet.getAppProperty("Fullscreen");
            if (string != null) {
                this.gameCanvas.setFullScreenMode(Integer.parseInt(string) == 1);
            } else {
                this.gameCanvas.setFullScreenMode(true);
            }
            string = bMidlet.getAppProperty("ScreenHeight");
            this.m_iScreenHeight = string != null ? Integer.parseInt(string) : this.gameCanvas.getHeight();
            string = bMidlet.getAppProperty("ScreenWidth");
            this.m_iScreenWidth = string != null ? Integer.parseInt(string) : this.gameCanvas.getWidth();
            this.flushGraphics();
            this.initApp();
            this.idleThread = new Thread(this);
            this.idleThread.start();
        } else {
            this.onResume();
            int n = this.m_listScenes.elementCount;
            while (--n >= 0) {
                Scene scene = (Scene)this.m_listScenes.elementData[n];
                if (scene == null) continue;
                scene.onResumeApp();
            }
        }
    }

    public void destroyApp(boolean bl) throws MIDletStateChangeException {
    }

    public void pauseApp() {
        this.onSuspend();
        int n = this.m_listScenes.elementCount;
        while (--n >= 0) {
            Scene scene = (Scene)this.m_listScenes.elementData[n];
            if (scene == null) continue;
            scene.onPauseApp();
        }
        while (this.m_listClosing.elementCount > 0) {
            this.onIdle(0);
        }
        System.gc();
    }

    public void run() {
        long l = 0L;
        this.msPreviousTime = System.currentTimeMillis();
        try {
            if (this.onStartFirstScene() == 0) {
                this.m_bQuitRequested = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.m_bQuitRequested = true;
        }
        while (!this.m_bQuitRequested) {
            try {
                Thread.sleep(10L);
                this.msElapsed = (int)(System.currentTimeMillis() - this.msPreviousTime);
                this.msPreviousTime = System.currentTimeMillis();
                if (this.m_bInitialized && !this.m_bGamePaused) {
                    this.onIdle(this.msElapsed);
                    this.m_pSoundManager.update(this.msElapsed);
                }
                if (this.m_bShowFPS) {
                    l = System.currentTimeMillis();
                }
                if (!this.m_bGamePaused) {
                    this.onPaint(m_pGraphics);
                    if (this.m_bShowFPS) {
                        this.lPaintTime = System.currentTimeMillis() - l;
                        m_pGraphics.setColor(0);
                        m_pGraphics.fillRect(0, 0, 20, 20);
                        m_pGraphics.setColor(-1);
                        m_pGraphics.drawString(Integer.toString(this.lPaintTime != 0L ? 1000 / (int)this.lPaintTime : 0), 0, 0, 20);
                    }
                    if (this.m_bShowMem) {
                        int n = this.m_iScreenWidth - 80;
                        int n2 = (int)Runtime.getRuntime().freeMemory();
                        m_pGraphics.setColor(0);
                        m_pGraphics.fillRect(n, 0, 80, 20);
                        m_pGraphics.setColor(-1);
                        m_pGraphics.drawString(Integer.toString(n2), this.m_iScreenWidth, 0, 24);
                    }
                    this.gameCanvas.flushGraphics();
                }
                this.m_bPainted = false;
            }
            catch (Exception exception) {
                System.out.println("exception on run");
                exception.printStackTrace();
            }
        }
        try {
            bMidlet.destroyApp(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        bMidlet.notifyDestroyed();
        m_instance = null;
    }

    public abstract int onDialogEvent(int var1, int var2);

    public void onSuspend() {
        this.m_bGamePaused = true;
        try {
            if (this.m_listScenes.elementCount > 0) {
                Scene scene = (Scene)this.m_listScenes.lastElement();
                scene.onSuspend();
            }
        }
        catch (Exception exception) {
            if (this.m_bVerbose) {
                System.err.println("### app: " + exception.toString() + " thrown from GameApp.onSuspend()");
            }
            this.m_bQuitRequested = true;
        }
    }

    public void onResume() {
        this.m_bGamePaused = false;
    }

    public boolean onKeyPressed(int n) {
        Scene scene;
        block0 : switch (n) {
            case 48: {
                this.m_iKeysDown |= 1;
                this.m_iKeysChanged |= 1;
                break;
            }
            case 49: {
                this.m_iKeysDown |= 2;
                this.m_iKeysChanged |= 2;
                break;
            }
            case 50: {
                this.m_iKeysDown |= 4;
                this.m_iKeysChanged |= 4;
                break;
            }
            case 51: {
                this.m_iKeysDown |= 8;
                this.m_iKeysChanged |= 8;
                break;
            }
            case 52: {
                this.m_iKeysDown |= 0x10;
                this.m_iKeysChanged |= 0x10;
                break;
            }
            case 53: {
                this.m_iKeysDown |= 0x20;
                this.m_iKeysChanged |= 0x20;
                break;
            }
            case 54: {
                this.m_iKeysDown |= 0x40;
                this.m_iKeysChanged |= 0x40;
                break;
            }
            case 55: {
                this.m_iKeysDown |= 0x80;
                this.m_iKeysChanged |= 0x80;
                break;
            }
            case 56: {
                this.m_iKeysDown |= 0x100;
                this.m_iKeysChanged |= 0x100;
                break;
            }
            case 57: {
                this.m_iKeysDown |= 0x200;
                this.m_iKeysChanged |= 0x200;
                break;
            }
            case 42: {
                this.m_iKeysDown |= 0x400;
                this.m_iKeysChanged |= 0x400;
                break;
            }
            case 35: {
                this.m_iKeysDown |= 0x800;
                this.m_iKeysChanged |= 0x800;
                break;
            }
            default: {
                int n2;
                if (n == -6) {
                    this.m_iKeysDown |= 0x80000;
                    this.m_iKeysChanged |= 0x80000;
                    break;
                }
                if (n == -7) {
                    this.m_iKeysDown |= 0x40000;
                    this.m_iKeysChanged |= 0x40000;
                    break;
                }
                if (n == -8 || (n2 = this.gameCanvas.getGameAction(n)) == 0) break;
                switch (n2) {
                    case 8: {
                        this.m_iKeysDown |= 0x10000;
                        this.m_iKeysChanged |= 0x10000;
                        break block0;
                    }
                    case 1: {
                        this.m_iKeysDown |= 0x1000;
                        this.m_iKeysChanged |= 0x1000;
                        break block0;
                    }
                    case 6: {
                        this.m_iKeysDown |= 0x2000;
                        this.m_iKeysChanged |= 0x2000;
                        break block0;
                    }
                    case 2: {
                        this.m_iKeysDown |= 0x4000;
                        this.m_iKeysChanged |= 0x4000;
                        break block0;
                    }
                    case 5: {
                        this.m_iKeysDown |= 0x8000;
                        this.m_iKeysChanged |= 0x8000;
                    }
                }
            }
        }
        if (this.m_listScenes.elementCount > 0 && this.m_listOpening.elementCount == 0 && this.m_listClosing.indexOf(scene = (Scene)this.m_listScenes.lastElement(), 0) == -1) {
            return scene.onKeyPressed(n);
        }
        return false;
    }

    public boolean onKeyReleased(int n) {
        Scene scene;
        block0 : switch (n) {
            case 48: {
                this.m_iKeysDown &= 0xFFFFFFFE;
                break;
            }
            case 49: {
                this.m_iKeysDown &= 0xFFFFFFFD;
                break;
            }
            case 50: {
                this.m_iKeysDown &= 0xFFFFFFFB;
                break;
            }
            case 51: {
                this.m_iKeysDown &= 0xFFFFFFF7;
                break;
            }
            case 52: {
                this.m_iKeysDown &= 0xFFFFFFEF;
                break;
            }
            case 53: {
                this.m_iKeysDown &= 0xFFFFFFDF;
                break;
            }
            case 54: {
                this.m_iKeysDown &= 0xFFFFFFBF;
                break;
            }
            case 55: {
                this.m_iKeysDown &= 0xFFFFFF7F;
                break;
            }
            case 56: {
                this.m_iKeysDown &= 0xFFFFFEFF;
                break;
            }
            case 57: {
                this.m_iKeysDown &= 0xFFFFFDFF;
                break;
            }
            case 42: {
                this.m_iKeysDown &= 0xFFFFFBFF;
                break;
            }
            case 35: {
                this.m_iKeysDown &= 0xFFFFF7FF;
                break;
            }
            default: {
                int n2;
                if (n == -6 || n == 6) {
                    this.m_iKeysDown &= 0xFFF7FFFF;
                    break;
                }
                if (n == -7 || n == 7) {
                    this.m_iKeysDown &= 0xFFFBFFFF;
                    break;
                }
                if (n == -8 || (n2 = this.gameCanvas.getGameAction(n)) == 0) break;
                switch (n2) {
                    case 8: {
                        this.m_iKeysDown &= 0xFFFEFFFF;
                        break block0;
                    }
                    case 1: {
                        this.m_iKeysDown &= 0xFFFFEFFF;
                        break block0;
                    }
                    case 6: {
                        this.m_iKeysDown &= 0xFFFFDFFF;
                        break block0;
                    }
                    case 2: {
                        this.m_iKeysDown &= 0xFFFFBFFF;
                        break block0;
                    }
                    case 5: {
                        this.m_iKeysDown &= 0xFFFF7FFF;
                    }
                }
            }
        }
        if (this.m_listScenes.elementCount > 0 && this.m_listClosing.indexOf(scene = (Scene)this.m_listScenes.lastElement(), 0) == -1) {
            return scene.onKeyReleased(n);
        }
        return false;
    }

    public int onIdle(int n) {
        Scene scene = null;
        boolean bl = true;
        if (this.m_listClosing.elementCount > 0) {
            Scene scene2 = (Scene)this.m_listClosing.elementData[0];
            this.m_listClosing.removeElementAt(0);
            int n2 = this.m_listScenes.indexOf(scene2, 0);
            scene2.onClose();
            if (n2 != -1) {
                this.m_listScenes.removeElementAt(n2);
            }
            scene2 = null;
            if (this.m_listScenes.elementCount > 0) {
                scene = (Scene)this.m_listScenes.lastElement();
                if (this.m_listClosing.indexOf(scene, 0) == -1) {
                    scene.onResume();
                }
            } else if (this.m_listClosing.elementCount == 0 && this.m_listOpening.elementCount == 0 && this.m_iDeferredScene == -1) {
                if (this.m_bVerbose) {
                    System.err.println("### app: No more scenes. Killing app.");
                }
                this.m_bQuitRequested = true;
            }
            this.m_bSkipDraw = true;
            this.m_bRedrawStack = true;
            return 1;
        }
        if (this.m_listOpening.elementCount > 0 && this.m_pSceneLoading == null) {
            Scene scene3 = (Scene)this.m_listOpening.elementData[0];
            this.m_listOpening.removeElementAt(0);
            if (this.m_listScenes.elementCount > 0) {
                scene = (Scene)this.m_listScenes.lastElement();
                scene.onSuspend();
            }
            this.m_pSceneLoading = scene3;
            this.m_iLoadProgress = 0;
            this.m_bSkipDraw = true;
            this.m_bRedrawStack = true;
            this.m_listScenes.addElement(scene3);
            return 2;
        }
        if (this.m_iDeferredScene > -1) {
            this.m_bWaitBeforeLoad = false;
            this.onDeferredScene();
            this.m_iDeferredScene = -1;
        } else if (this.m_listScenes.elementCount > 0) {
            if (this.m_pSceneLoading != null) {
                if (this.m_iLoadProgress == 0) {
                    // empty if block
                }
                if (this.m_bVerbose) {
                    System.err.println("### app: dispatching onLoad");
                }
                this.m_iLoadProgress = this.m_pSceneLoading.onLoad(this.m_iLoadProgress);
                if (this.m_iLoadProgress >= 100) {
                    Scene scene4 = this.m_pSceneLoading;
                    this.m_pSceneLoading = null;
                    this.m_iLoadProgress = 100;
                    if (scene4.onOpen() != 0) {
                        return -1;
                    }
                    this.m_bSkipDraw = true;
                } else if (this.m_iLoadProgress < 0) {
                    this.m_pSceneLoading = null;
                    return -1;
                }
            } else {
                if (this.m_bVerbose) {
                    System.err.println("### app: dispatching onIdle");
                }
                Scene scene5 = (Scene)this.m_listScenes.lastElement();
                if (this.m_iKeysChanged != 0) {
                    int n3 = this.m_iKeysChanged;
                    scene5.onCheckKeysChanged();
                    if (n3 == this.m_iKeysChanged) {
                        bl = true;
                    } else {
                        this.m_iKeysChanged = ~n3 & this.m_iKeysChanged;
                        bl = false;
                    }
                }
                scene5.onIdle(n);
                scene5.sortObjects();
            }
        }
        if (bl) {
            this.m_iKeysChanged = 0;
        }
        return 0;
    }

    public void onPaint(Graphics graphics) {
        Scene scene = null;
        if (this.m_bSkipDraw) {
            this.m_bSkipDraw = false;
            this.m_bPainted = true;
            return;
        }
        if (this.m_listScenes.elementCount > 0) {
            int n;
            if (this.m_bRedrawStack) {
                for (n = 0; n < this.m_listScenes.elementCount; ++n) {
                    scene = (Scene)this.m_listScenes.elementData[n];
                    if (scene == null) continue;
                    if (scene == this.m_pSceneLoading) {
                        scene.onPaintLoading(graphics, this.m_iLoadProgress);
                        continue;
                    }
                    scene.onPaint(graphics);
                }
                this.m_bRedrawStack = false;
            } else {
                scene = (Scene)this.m_listScenes.lastElement();
                if (scene != null) {
                    if (scene == this.m_pSceneLoading) {
                        scene.onPaintLoading(graphics, this.m_iLoadProgress);
                    } else {
                        scene.onPaint(graphics);
                    }
                }
            }
            if (scene != null && scene != this.m_pSceneLoading) {
                for (n = 0; n < 2; ++n) {
                    GameObject gameObject;
                    switch (n) {
                        case 0: {
                            gameObject = scene.m_pAcceptSoftKey;
                            break;
                        }
                        case 1: {
                            gameObject = scene.m_pCancelSoftKey;
                            break;
                        }
                        default: {
                            gameObject = null;
                        }
                    }
                    if (gameObject == null || gameObject.getParent() != scene) continue;
                    gameObject.m_pParent = null;
                    int n2 = gameObject.m_iX;
                    int n3 = gameObject.m_iY;
                    int n4 = gameObject.getLeft() + (gameObject.getWidth() >> 1);
                    int n5 = n2 - n4;
                    int n6 = this.m_iScreenWidth << 12 >> 1;
                    gameObject.setLocation(n6 + (n6 - n4) + n5, n3);
                    this.m_bDrawingSKSwap = true;
                    int n7 = gameObject.getLeft();
                    int n8 = gameObject.getTop();
                    int n9 = gameObject.getRight();
                    int n10 = gameObject.getBottom();
                    int n11 = n7;
                    int n12 = n8;
                    if (n7 < 0) {
                        n7 = 0;
                    }
                    if (n8 < 0) {
                        n8 = 0;
                    }
                    if (n9 > this.m_iScreenWidth << 12) {
                        n9 = this.m_iScreenWidth << 12;
                    }
                    if (n10 > this.m_iScreenHeight << 12) {
                        n10 = this.m_iScreenHeight << 12;
                    }
                    if (n7 < n9 && n8 < n10) {
                        gameObject.onPaint(graphics, n7 >> 12, n8 >> 12, n9 - n7 >> 12, n10 - n8 >> 12, n7 - n11 >> 12, n8 - n12 >> 12);
                    }
                    this.m_bDrawingSKSwap = false;
                    gameObject.setLocation(n2, n3);
                    gameObject.m_pParent = scene;
                }
            }
        }
        this.m_bPainted = true;
    }
}

