/*
 * Decompiled with CFR 0.152.
 */
package sims_pets;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import sims_pets.GameApp;
import sims_pets.GameObject;
import sims_pets.ts_AnimState;
import sims_pets.ts_Animation;

public class AnimObject
extends GameObject {
    protected ts_Animation m_pAnimation;
    protected ts_AnimState m_pCurState;
    protected Image m_pCurNativeState;
    private byte[] m_pWorkPalette;
    private byte[] m_pSwapPalette;
    private boolean m_bUsingSwapPalette;
    boolean m_bMirrored;
    public boolean m_bDynamicFrameUpdate;
    public short m_sLoadMaskOption = (short)-1;
    boolean m_bLockFrameAlloc;
    boolean m_bPlayForward;
    int m_iFrameTimeMul;
    int m_iPaletteID;
    int m_iState;
    int m_iFrame;
    int m_iFrameTime;

    AnimObject() {
    }

    protected final ts_AnimState findState(int n) {
        ts_AnimState ts_AnimState2 = null;
        if (this.m_pAnimation != null) {
            for (int i = 0; i < this.m_pAnimation.lNumStates; ++i) {
                if (this.m_pAnimation.pStateArray[i].sIndex != n) continue;
                ts_AnimState2 = this.m_pAnimation.pStateArray[i];
                break;
            }
            if (ts_AnimState2 == null && n > 0 && n >= this.m_pAnimation.pStateArray.length) {
                ts_AnimState2 = this.m_pAnimation.pStateArray[this.m_pAnimation.pStateArray.length - 1];
            }
            if (ts_AnimState2 == null) {
                ts_AnimState2 = this.m_pAnimation.pStateArray[0];
            }
        }
        return ts_AnimState2;
    }

    public boolean isMirrored() {
        return this.m_bMirrored;
    }

    public final void setLoadMaskOption(short s) {
        this.m_sLoadMaskOption = s;
    }

    public boolean getLockFrameAlloc() {
        return this.m_bLockFrameAlloc;
    }

    public void setLockFrameAlloc(boolean bl) {
        this.m_bLockFrameAlloc = bl;
    }

    public void setPaletteResID(int n) {
        this.m_iPaletteID = n;
    }

    public int getPaletteResID() {
        return this.m_iPaletteID;
    }

    public void restoreWorkPalette() {
        this.m_bUsingSwapPalette = false;
    }

    public void loadSwapPalette(int n) {
        this.m_pSwapPalette = GameApp.loadBinaryResource(n);
    }

    public void useSwapPalette() {
        this.m_bUsingSwapPalette = true;
    }

    public boolean getUsingSwapPalette() {
        return this.m_bUsingSwapPalette;
    }

    public void setState(int n, int n2, boolean bl) {
        this.m_pCurState = this.findState(n);
        if (this.m_pCurState != null) {
            if (n2 == -1) {
                n2 = this.m_bPlayForward ? 0 : this.m_pCurState.lNumFrames - 1;
            }
            if (this.m_iState != this.m_pCurState.sIndex || this.m_bMirrored != bl) {
                this.m_pCurNativeState = null;
            }
            if (this.m_pCurNativeState == null) {
                this.m_pCurNativeState = bl ? Image.createImage((Image)this.m_pCurState.pImg, (int)0, (int)0, (int)this.m_pCurState.pImg.getWidth(), (int)this.m_pCurState.pImg.getHeight(), (int)2) : this.m_pCurState.pImg;
            }
            this.m_iState = this.m_pCurState.sIndex;
            this.m_iFrame = -1;
            this.m_bMirrored = bl;
            this.setFrame(n2);
        }
    }

    protected final void setFrame(int n) {
        int n2 = this.m_iFrame;
        this.m_iFrame = n;
        if (this.m_pCurState != null) {
            if (n >= this.m_pCurState.lNumFrames) {
                this.m_iFrame = this.m_pCurState.lNumFrames - 1;
            } else if (n < 0) {
                this.m_iFrame = 0;
            }
            int n3 = this.m_pCurState.pFrames[this.m_iFrame].lPhysFrame;
            this.m_iFrameTime = this.m_pCurState.pFrames[this.m_iFrame].lDuration;
            this.m_iWidth = this.m_pCurState.psptFrameDimensions[n3].x << 12;
            this.m_iHeight = this.m_pCurState.psptFrameDimensions[n3].y << 12;
        }
        this.onUpdateRect();
    }

    public boolean getPlayForward() {
        return this.m_bPlayForward;
    }

    public void setPlayForward(boolean bl) {
        this.m_bPlayForward = bl;
    }

    public int getFrameTimeMul() {
        return this.m_iFrameTimeMul;
    }

    public void setFrameTimeMul(int n) {
        this.m_iFrameTimeMul = n;
    }

    public int getFrameTimeLeft() {
        return this.m_iFrameTime;
    }

    public int getState() {
        return this.m_iState;
    }

    public int getFrame() {
        return this.m_iFrame;
    }

    public int getFrameWidth() {
        return this.m_pCurState.sFrameWidth;
    }

    public int getFrameHeight() {
        return this.m_pCurState.sFrameHeight;
    }

    public int getNumFrames() {
        return this.m_pCurState.lNumFrames;
    }

    public int getAnchorX() {
        return this.m_pCurState.sAnchorX;
    }

    public int getAnchorY() {
        return this.m_pCurState.sAnchorY;
    }

    public int getStateDuration() {
        int n = 0;
        if (this.m_pCurState != null) {
            for (int i = 0; i < this.m_pCurState.lNumFrames; ++i) {
                n += this.m_pCurState.pFrames[i].lDuration;
            }
        }
        return n;
    }

    void getPointSet(int n, int[] nArray) {
        if (this.m_pCurState != null && n < this.m_pCurState.sNumPointSets) {
            nArray[0] = this.m_pCurState.pFrames[this.m_iFrame].psptCustom[n].x;
            nArray[1] = this.m_pCurState.pFrames[this.m_iFrame].psptCustom[n].y;
            if (this.m_bMirrored) {
                nArray[0] = this.m_pCurState.sFrameWidth - nArray[0];
            }
        }
    }

    public int getNumPointSets() {
        if (this.m_pCurState != null) {
            return this.m_pCurState.sNumPointSets;
        }
        return 0;
    }

    public boolean onStateDone() {
        return true;
    }

    public boolean onLoadResource(int n) {
        ts_Animation ts_Animation2 = null;
        this.m_iResourceID = n;
        ts_Animation2 = ts_Animation.load(n, this.m_iPaletteID, false, this.m_sLoadMaskOption);
        if (ts_Animation2 != null) {
            this.m_pAnimation = ts_Animation2;
            this.setState(0, 0, false);
        }
        return this.m_pAnimation != null;
    }

    public void onReleaseResource() {
        if (this.m_pAnimation != null) {
            ts_Animation.unload(this.m_pAnimation);
            this.m_pAnimation = null;
        }
    }

    public void onIdle(int n) {
        if (this.m_pCurState != null) {
            this.m_iFrameTime -= n;
            if (this.m_iFrameTime <= 0) {
                if (this.m_bPlayForward) {
                    if (this.m_iFrame < this.m_pCurState.lNumFrames - 1) {
                        this.setFrame(this.m_iFrame + 1);
                    } else if (this.onStateDone()) {
                        this.setFrame(0);
                    }
                } else if (this.m_iFrame > 0) {
                    this.setFrame(this.m_iFrame - 1);
                } else if (this.onStateDone()) {
                    this.setFrame(this.m_pCurState.lNumFrames - 1);
                }
            }
        }
    }

    public void onPaint(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = graphics.getClipX();
        int n8 = graphics.getClipY();
        int n9 = graphics.getClipWidth();
        int n10 = graphics.getClipHeight();
        if (this.m_pCurState != null && this.m_pCurNativeState != null) {
            int n11 = this.m_pCurState.pFrames[this.m_iFrame].lPhysFrame;
            int n12 = n5;
            n12 = this.m_bMirrored ? (n12 += this.m_pCurNativeState.getWidth() - this.m_pCurState.psptFrameOffsets[n11].x - this.m_pCurState.psptFrameDimensions[n11].x) : (n12 += this.m_pCurState.psptFrameOffsets[n11].x);
            int n13 = n6 + this.m_pCurState.psptFrameOffsets[n11].y;
            if (n3 == -1) {
                n3 = this.m_pCurState.psptFrameDimensions[n11].x;
            }
            if (n4 == -1) {
                n4 = this.m_pCurState.psptFrameDimensions[n11].y;
            }
            int n14 = n;
            int n15 = n2;
            int n16 = n3;
            int n17 = n4;
            if (n6 < 0) {
                n17 += n6;
            }
            graphics.setClip(n14, n15, n16, n17);
            graphics.drawImage(this.m_pCurNativeState, n - n12, n2 - n13, 20);
            graphics.setClip(n7, n8, n9, n10);
        }
        super.onPaint(graphics, n, n2, n4, n3, n5, n6);
    }

    public void onUpdateRect() {
        if (this.m_pCurState != null) {
            int n = this.m_pCurState.pFrames[this.m_iFrame].lPhysFrame;
            short s = this.m_pCurState.pFrames[this.m_iFrame].ptOffset.x;
            short s2 = this.m_pCurState.pFrames[this.m_iFrame].ptOffset.y;
            this.m_iLeft = this.m_bMirrored ? this.m_iX - (this.m_pCurState.psptFrameDimensions[n].x - (this.m_pCurState.sAnchorX - this.m_pCurState.psptFrameRefs[n].x + s) << 12) : this.m_iX - (this.m_pCurState.sAnchorX - this.m_pCurState.psptFrameRefs[n].x + s << 12);
            this.m_iTop = this.m_iY - (this.m_pCurState.sAnchorY - this.m_pCurState.psptFrameRefs[n].y + s2 << 12);
            this.m_iRight = this.m_iLeft + this.m_iWidth;
            this.m_iBottom = this.m_iTop + this.m_iHeight;
        } else {
            super.onUpdateRect();
        }
    }
}

