/*
 * Decompiled with CFR 0.152.
 */
package sims_pets;

import bundle.BundleMidlet;
import javax.microedition.lcdui.Display;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.MIDlet;
import sims_pets.ArrayList;
import sims_pets.Sound;

public class SoundManager
implements PlayerListener {
    public Sound[] sndAry;
    private Sound m_rCurrent;
    private Sound m_rPrefetched;
    private Sound m_rMusic;
    private boolean m_bAmbient;
    private int m_iVibeTimer;
    private int m_iSoundVolume = 100;
    private int m_iMusicVolume = 100;
    private ArrayList m_lstSounds = new ArrayList();

    public synchronized void loadResource(int n) {
        Sound sound = this.findSound(n);
        if (sound != null) {
            return;
        }
        sound = new Sound();
        sound.m_iResID = n;
        this.m_lstSounds.addElement(sound);
    }

    public synchronized Sound findSound(int n) {
        int n2 = this.m_lstSounds.elementCount;
        while (--n2 >= 0) {
            Sound sound = (Sound)this.m_lstSounds.elementData[n2];
            if (sound.m_iResID != n) continue;
            return sound;
        }
        return null;
    }

    public synchronized int getNumSounds() {
        return this.m_lstSounds.elementCount;
    }

    public synchronized int getSoundResID(int n) {
        Sound sound;
        if (0 <= n && n < this.m_lstSounds.elementCount && (sound = (Sound)this.m_lstSounds.elementData[n]) != null) {
            return sound.m_iResID;
        }
        return -1;
    }

    public synchronized void setSoundVolume(int n) {
        this.m_iSoundVolume = n;
        this.updateVolume();
    }

    public synchronized void setMusicVolume(int n) {
        this.m_iMusicVolume = n;
        this.updateVolume();
    }

    private synchronized void updateVolume() {
        VolumeControl volumeControl;
        if (this.m_rCurrent != null && this.m_rCurrent.m_pData != null && (volumeControl = (VolumeControl)this.m_rCurrent.m_pData.getControl("VolumeControl")) != null) {
            volumeControl.setLevel(this.m_bAmbient ? this.m_iMusicVolume : this.m_iSoundVolume);
        }
    }

    public synchronized boolean playVib(int n) {
        boolean bl = Display.getDisplay((MIDlet)BundleMidlet.bunMid).vibrate(n);
        if (bl) {
            this.m_iVibeTimer = n;
        }
        return bl;
    }

    public synchronized void playSound(int n) {
        Sound sound = this.findSound(n);
        if (sound == null) {
            return;
        }
        if (this.m_rCurrent != null) {
            this.stopPlayback();
        }
        if (this.m_rCurrent == null) {
            this.m_rCurrent = sound;
            if (this.m_rPrefetched != null) {
                if (this.m_rPrefetched != sound) {
                    this.m_rPrefetched.m_pData.close();
                    this.m_rPrefetched.m_pData = null;
                }
                this.m_rPrefetched = null;
            }
            if (this.m_rCurrent.m_pData == null) {
                this.m_rCurrent.loadResource(this.m_rCurrent.m_iResID);
            }
            if (this.m_rCurrent.m_pData != null) {
                try {
                    this.m_rCurrent.m_pData.addPlayerListener((PlayerListener)this);
                    this.m_rCurrent.m_pData.setLoopCount(-1);
                    this.m_rCurrent.m_pData.start();
                }
                catch (Exception exception) {
                    if (this.m_rCurrent.m_pData != null) {
                        this.m_rCurrent.m_pData.close();
                        this.m_rCurrent.m_pData = null;
                    }
                    this.m_rCurrent = null;
                }
            } else {
                this.m_rCurrent = null;
            }
            this.updateVolume();
        }
    }

    public synchronized void stopPlayback() {
        if (this.m_rCurrent != null && !this.m_bAmbient) {
            try {
                this.m_rCurrent.m_pData.close();
                this.m_rCurrent.m_pData = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_rCurrent = null;
        }
    }

    public synchronized void playMusic(int n) {
        Sound sound = this.findSound(n);
        if (sound != null) {
            if (this.m_rCurrent != null) {
                if (sound != this.m_rCurrent) {
                    try {
                        this.m_rCurrent.m_pData.stop();
                        if (this.m_rCurrent.m_pData.getState() == 300) {
                            this.m_rPrefetched = this.m_rCurrent;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.m_rCurrent = null;
                } else if (this.m_rCurrent.m_pData != null && this.m_rCurrent.m_pData.getState() == 400) {
                    return;
                }
            }
            this.m_rCurrent = sound;
            if (this.m_rPrefetched != null) {
                if (sound != this.m_rPrefetched) {
                    this.m_rPrefetched.m_pData.close();
                    this.m_rPrefetched.m_pData = null;
                }
                this.m_rPrefetched = null;
            }
            if (this.m_rCurrent.m_pData == null) {
                this.m_rCurrent.loadResource(this.m_rCurrent.m_iResID);
            }
            if (this.m_rCurrent.m_pData != null) {
                try {
                    this.m_rCurrent.m_pData.addPlayerListener((PlayerListener)this);
                    this.m_rCurrent.m_pData.realize();
                    this.m_rCurrent.m_pData.start();
                    this.m_rMusic = this.m_rCurrent;
                    this.m_bAmbient = true;
                }
                catch (Exception exception) {
                    if (this.m_rCurrent.m_pData != null) {
                        this.m_rCurrent.m_pData.close();
                        this.m_rCurrent.m_pData = null;
                    }
                    this.m_rCurrent = null;
                    this.m_bAmbient = false;
                }
            }
        }
        this.updateVolume();
    }

    public synchronized void stopAmbient() {
        if (this.m_rCurrent == null || this.m_rCurrent.m_pData == null) {
            return;
        }
        try {
            this.m_rCurrent.m_pData.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_rCurrent.m_pData.deallocate();
        this.m_rCurrent.m_pData.close();
        this.m_rCurrent.m_pData = null;
        this.m_bAmbient = false;
    }

    public synchronized boolean isAmbient() {
        return this.m_bAmbient;
    }

    public synchronized void update(int n) {
        if (this.m_iVibeTimer > 0) {
            this.m_iVibeTimer -= n;
            if (this.m_iVibeTimer <= 0) {
                this.playVib(0);
                if (!this.m_bAmbient || this.m_rCurrent != null) {
                    // empty if block
                }
            }
        }
    }

    public synchronized void playerUpdate(Player player, String string, Object object) {
        if (string == "endOfMedia" && this.m_iVibeTimer == 0) {
            if (this.m_rCurrent != null && this.m_rCurrent.m_pData == player) {
                if (this.m_bAmbient) {
                    try {
                        player.start();
                    }
                    catch (Exception exception) {
                        this.m_rCurrent = null;
                        this.m_bAmbient = false;
                    }
                } else {
                    try {
                        player.stop();
                        player.prefetch();
                        this.m_rPrefetched = this.m_rCurrent;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.m_rCurrent = null;
                }
            } else if (player.getState() != 0) {
                try {
                    player.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                player.deallocate();
            }
        }
    }

    public synchronized boolean isPlaying(int n) {
        if (this.m_rCurrent != null && this.m_rCurrent.m_iResID == n && this.m_rCurrent.m_pData != null) {
            return this.m_rCurrent.m_pData.getState() == 400;
        }
        return false;
    }

    public synchronized boolean isPlaying() {
        if (this.m_rCurrent != null && !this.m_bAmbient && this.m_rCurrent.m_pData != null) {
            return this.m_rCurrent.m_pData.getState() == 400;
        }
        return false;
    }
}

