/*
 * Decompiled with CFR 0.152.
 */
package sims_pets;

import bundle.BundleCanvas;
import bundle.BundleMidlet;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import sims_pets.AnimObject;
import sims_pets.ChoosePetScene;
import sims_pets.CreateSimScene;
import sims_pets.DeviceInfo;
import sims_pets.DialogScene;
import sims_pets.Font;
import sims_pets.GameApp;
import sims_pets.GameScene;
import sims_pets.HudScene;
import sims_pets.InfoPageScene;
import sims_pets.MainMenuScene;
import sims_pets.MenuScene;
import sims_pets.MetaGameScene;
import sims_pets.OptionScene;
import sims_pets.Scene;
import sims_pets.SoundManager;
import sims_pets.StoreScene;
import sims_pets.TextObject;
import sims_pets.pets;

public class PetsApp
extends GameApp {
    public static final int kCharMapDefault = 0;
    public static final int kCharMapNumeric = 1;
    public static final int kCharMapFull = 2;
    public static final int keyUp = 4100;
    public static final int keyDown = 8448;
    public static final int keyLeft = 16400;
    public static final int keyRight = 32832;
    public static final int keySELECT = 65568;
    public static final int kSelectorInstanceID = 100;
    public static final int kGameMessagePopupID = 2000;
    public static final int kPetNameID = 2001;
    public static final int kEndTagID = 9999;
    public static final int kNumKeyMasks = 15;
    public static final int kNumBones = 5;
    public static final int kOptionSoundOn = 1;
    public static final int kOptionVibeOn = 2;
    public static final int kNumOptions = 2;
    public static final int kDefaultOptions = 3;
    public static final int kDeferredMainMenu = 0;
    public static final int kDeferredCreateSim = 1;
    public static final int kDeferredChoosePet = 2;
    public static final int kDeferredGame = 3;
    public static final int kDeferredStore = 4;
    public static final int kDeferredMetaGoal = 5;
    public static final int kNumDeferredScenes = 6;
    public static final int kMoodLevelDefaultAvatar = 245760;
    public static final int kMoodLevelAvatarSuccessIncr = 40960;
    public static final int kMoodLevelAvatarUnsuccessDecr = 20480;
    public static final int kMoodLevelAvatarBadBehaveDecr = 40960;
    public static final int kMaxNumPopups = 32;
    public static final int kMaxNameLength = 10;
    public static final int kStipendSleepCount = 2;
    public static final int kNeedBladder = 0;
    public static final int kNeedEnergy = 1;
    public static final int kNeedFun = 2;
    public static final int kNeedHunger = 3;
    public static final int kNeedHygiene = 4;
    public static final int kNeedCount = 5;
    public static final int kOtherObjectSofa = 0;
    public static final int kOtherObjectVase = 1;
    public static final int kOtherObjectPlant = 2;
    public static final int kOtherObjectNewspaper = 3;
    public static final int kOtherObjectSlippers = 4;
    public static final int kNumOtherObjects = 10;
    public static final int kMaxNumMetaGoals = 4;
    public static final int kSaveVersion = 20;
    public static final int kDataCommonSaveVersion = 0;
    public static final int kDataCommonOptions = 4;
    public static final int kDataCommonLanguage = 8;
    public static final int kDataCommonSize = 9;
    public static final int kDataUserOffset = 9;
    public static final int kDataUserExists = 0;
    public static final int kDataUserName = 1;
    public static final int kDataUserSimParts = 12;
    public static final int kDataUserPetOffset = 17;
    public static final int kDataUserPetName = 0;
    public static final int kDataUserPetPart = 11;
    public static final int kDataUserPetCurrentLocation = 14;
    public static final int kDataUserPetSleepCount = 15;
    public static final int kDataUserPetCurrentSimoleons = 16;
    public static final int kDataUserPetEarnedSimoleons = 20;
    public static final int kDataUserPetLifetimeSimoleons = 24;
    public static final int kDataUserPetAvatarMood = 28;
    public static final int kDataUserPetAvatarGoalsMet = 32;
    public static final int kDataUserPetCatchLevel = 36;
    public static final int kDataUserPetTargetBladder = 40;
    public static final int kDataUserPetMotive = 44;
    public static final int kDataUserPetAbility = 64;
    public static final int kDataUserPetInventory = 172;
    public static final int kDataUserPetConsumable = 176;
    public static final int kDataUserPetOtherObject = 208;
    public static final int kDataUserPetHint = 248;
    public static final int kDataUserPetMGMasks = 256;
    public static final int kDataUserPetMGCurrent = 272;
    public static final int kDataUserPetMGTemp = 288;
    public static final int kDataUserPetSize = 289;
    public static final int kDataUserSize = 17;
    public static final int kDataSize = 315;
    public static final int kNumCachedLayouts = 32;
    public static final int kLoadingBarColour = Short.MAX_VALUE;
    public static final int kDefaultBackgroundColour = 3689872;
    public static final int kTempTextBufferSize = 4096;
    public static final int kMoreGamesOff = 0;
    public static final int kMoreGamesStatic = 1;
    public static final int kMoreGamesWAP = 2;
    public static final int kBuffer_256 = 256;
    public static final int kBuffer_64 = 64;
    public static final int kBuffer_32 = 32;
    public static final int kBuffer_16 = 16;
    protected int m_iCurrentCharMap;
    protected int m_iCharacterMap;
    protected int m_iCurrentLanguage;
    private int m_iSplashTimer;
    private int m_iSplashIndex;
    private Image m_pimgSplash;
    private AnimObject m_panmSplash;
    private int m_iStartupScreen;
    public int m_iBackgroundColour;
    private byte[] m_username = new byte[11];
    private byte[] m_petname = new byte[11];
    private byte[] m_data = new byte[315];
    private AnimObject m_panmLoadingBar;
    private byte[] m_pyLoadingString;
    public byte[] m_pNewUserName;
    public int[] m_iNewUserParts = new int[4];
    public byte[] m_pNewPetName;
    public int[] m_iNewPetParts = new int[2];
    public int[] m_iContextAbilityNameIDs = new int[27];
    public int[] m_iContextAbilityIDs = new int[27];
    public int m_iNumContextAbilities;
    private int[][] m_ilstPopups = new int[32][10];
    private int[] m_ilstPopupHintMasks = new int[32];
    private int m_iNumPopups;
    private byte[][] m_pPopupArgsTemp = new byte[10][];
    private int[] m_iAddPopupParams = new int[10];
    private int m_iNumPopupParams;
    private int m_iPopupHintMask;
    private int[] m_iLastPopupParams = new int[10];
    public boolean m_bWantMusic;
    public static int iUseStatic = -1;
    public static String pURLStatic = null;

    public final void setCharacterMap(int n) {
        switch (n) {
            case 0: {
                this.m_pCharKeyMap[0] = new byte[]{48, 0};
                this.m_pCharKeyMap[1] = new byte[]{49, 0};
                this.m_pCharKeyMap[2] = new byte[]{97, 98, 99, 50, 0};
                this.m_pCharKeyMap[3] = new byte[]{100, 101, 102, 51, 0};
                this.m_pCharKeyMap[4] = new byte[]{103, 104, 105, 52, 0};
                this.m_pCharKeyMap[5] = new byte[]{106, 107, 108, 53, 0};
                this.m_pCharKeyMap[6] = new byte[]{109, 110, 111, 54, 0};
                this.m_pCharKeyMap[7] = new byte[]{112, 113, 114, 115, 55, 0};
                this.m_pCharKeyMap[8] = new byte[]{116, 117, 118, 56, 0};
                this.m_pCharKeyMap[9] = new byte[]{119, 120, 121, 122, 57, 0};
                this.m_pCharKeyMap[10] = null;
                break;
            }
            case 1: {
                this.m_pCharKeyMap[0] = new byte[]{48, 0};
                this.m_pCharKeyMap[1] = new byte[]{49, 0};
                this.m_pCharKeyMap[2] = new byte[]{50, 0};
                this.m_pCharKeyMap[3] = new byte[]{51, 0};
                this.m_pCharKeyMap[4] = new byte[]{52, 0};
                this.m_pCharKeyMap[5] = new byte[]{53, 0};
                this.m_pCharKeyMap[6] = new byte[]{54, 0};
                this.m_pCharKeyMap[7] = new byte[]{55, 0};
                this.m_pCharKeyMap[8] = new byte[]{56, 0};
                this.m_pCharKeyMap[9] = new byte[]{57, 0};
                this.m_pCharKeyMap[10] = null;
                break;
            }
            case 2: {
                this.m_pCharKeyMap[0] = new byte[]{48, 0};
                this.m_pCharKeyMap[1] = new byte[]{49, 0};
                this.m_pCharKeyMap[2] = new byte[]{97, 98, 99, 50, 0};
                this.m_pCharKeyMap[3] = new byte[]{100, 101, 102, 51, 0};
                this.m_pCharKeyMap[4] = new byte[]{103, 104, 105, 52, 0};
                this.m_pCharKeyMap[5] = new byte[]{106, 107, 108, 53, 0};
                this.m_pCharKeyMap[6] = new byte[]{109, 110, 111, 54, 0};
                this.m_pCharKeyMap[7] = new byte[]{112, 113, 114, 115, 55, 0};
                this.m_pCharKeyMap[8] = new byte[]{116, 117, 118, 56, 0};
                this.m_pCharKeyMap[9] = new byte[]{119, 120, 121, 122, 57, 0};
                this.m_pCharKeyMap[10] = new byte[]{32, 0};
                break;
            }
            default: {
                return;
            }
        }
        this.m_iCurrentCharMap = n;
    }

    public final void updateCharacterMap(TextObject textObject, TextObject textObject2) {
        int n;
        switch (textObject.m_iKeyMask) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 4: {
                n = 2;
                break;
            }
            case 8: {
                n = 3;
                break;
            }
            case 16: {
                n = 4;
                break;
            }
            case 32: {
                n = 5;
                break;
            }
            case 64: {
                n = 6;
                break;
            }
            case 128: {
                n = 7;
                break;
            }
            case 256: {
                n = 8;
                break;
            }
            case 512: {
                n = 9;
                break;
            }
            case 2048: {
                n = 10;
                break;
            }
            default: {
                n = -1;
            }
        }
        int n2 = textObject.m_iCharIndex;
        int n3 = 0;
        if (n != -1) {
            n3 = GameApp.getStringBufferLength(this.m_pCharKeyMap[n]);
        }
        if (n3 <= 1) {
            textObject2.m_bVisible = false;
        } else if (this.m_iCharacterMap != n || !textObject2.m_bVisible) {
            int n4;
            byte[] byArray = GameApp.getStringBuffer(n3 + 1);
            int n5 = 0;
            for (n4 = n2; n4 < n3; ++n4) {
                byArray[n5++] = this.m_pCharKeyMap[n][n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                byArray[n5++] = this.m_pCharKeyMap[n][n4];
            }
            for (n4 = 0; n4 < n3; ++n4) {
                if (byArray[n4] != 32) continue;
                byArray[n4] = 31;
            }
            byArray[n5] = 0;
            textObject2.setText(byArray, true);
            textObject2.m_bVisible = true;
        } else {
            byte by = textObject2.m_pText[0];
            textObject2.removeCharAt(0);
            textObject2.insertCharAt(n3, by);
        }
        this.m_iCharacterMap = n;
    }

    public final void setLanguage(int n) {
        if (n != this.m_iCurrentLanguage) {
            switch (n) {
                case 1: {
                    this.loadStrings(80);
                    break;
                }
                case 2: {
                    this.loadStrings(81);
                    break;
                }
                case 3: {
                    this.loadStrings(82);
                    break;
                }
                case 4: {
                    this.loadStrings(83);
                    break;
                }
                case 5: {
                    this.loadStrings(84);
                }
            }
            this.m_data[8] = (byte)n;
            this.m_iCurrentLanguage = n;
            for (int i = 0; i < this.m_listScenes.elementCount; ++i) {
                Scene scene = (Scene)this.m_listScenes.elementData[i];
                scene.onReloadText();
            }
            if (this.m_pyLoadingString != null) {
                GameApp.releaseStringBuffer(this.m_pyLoadingString);
            }
            this.m_pyLoadingString = GameApp.loadStringResource(111);
        }
    }

    public final int getLanguage() {
        return this.m_iCurrentLanguage;
    }

    public final int getSavedLanguage() {
        return this.m_data[8];
    }

    private final int getSaveVersion() {
        return GameApp.arrayToIntBE(this.m_data, 0);
    }

    private final void setSaveVersion(int n) {
        GameApp.intToArrayBE(n, this.m_data, 0);
    }

    private final void setUserExists(boolean bl) {
        this.m_data[9] = (byte)(bl ? 1 : 0);
    }

    private final void setEarnedSimoleons(int n) {
        GameApp.intToArrayBE(n, this.m_data, 46);
    }

    private final void setLifetimeSimoleons(int n) {
        GameApp.intToArrayBE(n, this.m_data, 50);
    }

    private final void setAvatarMoodLevel(int n) {
        GameApp.intToArrayBE(n, this.m_data, 54);
    }

    private final void clearInventory(int n) {
        int n2 = 198;
        GameApp.intToArrayBE(GameApp.arrayToIntBE(this.m_data, n2) & ~n, this.m_data, n2);
    }

    private final void setInventory(int n) {
        this.clearExclusiveInventory(n);
        int n2 = 198;
        GameApp.intToArrayBE(GameApp.arrayToIntBE(this.m_data, n2) | n, this.m_data, n2);
    }

    private final void clearExclusiveInventory(int n) {
        int n2 = 0;
        while (DeviceInfo.k_iExclusiveItemsMask[n2] != 0) {
            if ((n & DeviceInfo.k_iExclusiveItemsMask[n2]) != 0) {
                this.clearInventory(DeviceInfo.k_iExclusiveItemsMask[n2] & ~n);
                break;
            }
            ++n2;
        }
    }

    private final void setMetaGoalMask(int n, int n2) {
        GameApp.intToArrayBE(n2, this.m_data, 282 + 4 * n);
    }

    private final int getMetaGoalMask(int n) {
        return GameApp.arrayToIntBE(this.m_data, 282 + 4 * n);
    }

    private final void setCurrentMetaGoal(int n, int n2) {
        GameApp.intToArrayBE(n2, this.m_data, 298 + 4 * n);
    }

    private final void setAvatarGoalsMet(int n) {
        GameApp.intToArrayBE(n, this.m_data, 58);
    }

    public final boolean getUserExists() {
        return this.m_data[9] != 0;
    }

    public final byte[] getUserName() {
        System.arraycopy(this.m_data, 10, this.m_username, 0, 11);
        return this.m_username;
    }

    public final void setUserName(byte[] byArray, int n) {
        int n2;
        int n3 = 10;
        for (n2 = 0; n2 < 10 && n2 < n; ++n2) {
            this.m_data[n3 + n2] = byArray[n2];
        }
        while (n2 < 10) {
            this.m_data[n3 + n2] = 0;
            ++n2;
        }
    }

    public final int getPetPartOption(int n) {
        return this.m_data[37 + n] & 0xFF;
    }

    public final void setPetPartOption(int n, int n2) {
        this.m_data[37 + n] = (byte)n2;
    }

    public final boolean checkOption(int n) {
        return (GameApp.arrayToIntBE(this.m_data, 4) & n) != 0;
    }

    public final void clearOption(int n) {
        GameApp.intToArrayBE(GameApp.arrayToIntBE(this.m_data, 4) & ~n, this.m_data, 4);
    }

    public final void setOption(int n) {
        GameApp.intToArrayBE(GameApp.arrayToIntBE(this.m_data, 4) | n, this.m_data, 4);
    }

    public final byte[] getPetName() {
        System.arraycopy(this.m_data, 26, this.m_petname, 0, 11);
        return this.m_petname;
    }

    public final void setPetName(byte[] byArray, int n) {
        int n2;
        int n3 = 26;
        for (n2 = 0; n2 < 10 && n2 < n; ++n2) {
            this.m_data[n3 + n2] = byArray[n2];
        }
        while (n2 < 10) {
            this.m_data[n3 + n2] = 0;
            ++n2;
        }
    }

    public final int getSimPartOption(int n) {
        return this.m_data[21 + n] & 0xFF;
    }

    public final void setSimPartOption(int n, int n2) {
        this.m_data[21 + n] = (byte)n2;
    }

    public final int getCurrentLocation() {
        return this.m_data[40] & 0xFF;
    }

    public final void setCurrentLocation(int n) {
        this.m_data[40] = (byte)n;
    }

    public final int getSleepCount() {
        return this.m_data[41] & 0xFF;
    }

    public final void setSleepCount(int n) {
        this.m_data[41] = (byte)n;
    }

    public final void setCurrentSimoleons(int n) {
        GameApp.intToArrayBE(n, this.m_data, 42);
    }

    public final int getCurrentSimoleons() {
        return GameApp.arrayToIntBE(this.m_data, 42);
    }

    public final int getEarnedSimoleons() {
        return GameApp.arrayToIntBE(this.m_data, 46);
    }

    public final int getLifetimeSimoleons() {
        return GameApp.arrayToIntBE(this.m_data, 50);
    }

    public final int getAvatarMoodLevel() {
        return GameApp.arrayToIntBE(this.m_data, 54);
    }

    public final int getMotive(int n) {
        return GameApp.arrayToIntBE(this.m_data, 70 + n * 4);
    }

    public final void setMotive(int n, int n2) {
        GameApp.intToArrayBE(n2, this.m_data, 70 + n * 4);
    }

    public final int getCatchLevel() {
        return GameApp.arrayToIntBE(this.m_data, 62);
    }

    public final void setCatchLevel(int n) {
        GameApp.intToArrayBE(n, this.m_data, 62);
    }

    public final int getTargetBladder() {
        return GameApp.arrayToIntBE(this.m_data, 66);
    }

    public final void setTargetBladder(int n) {
        GameApp.intToArrayBE(n, this.m_data, 66);
    }

    public final int getAbility(int n) {
        return GameApp.arrayToIntBE(this.m_data, 90 + n * 4);
    }

    public final void setAbility(int n, int n2) {
        GameApp.intToArrayBE(n2, this.m_data, 90 + n * 4);
    }

    public final boolean checkInventory(int n) {
        int n2 = 198;
        return (GameApp.arrayToIntBE(this.m_data, n2) & n) != 0;
    }

    public final int getConsumable(int n) {
        return GameApp.arrayToIntBE(this.m_data, 202 + n * 4);
    }

    public final void setConsumable(int n, int n2) {
        GameApp.intToArrayBE(n2, this.m_data, 202 + n * 4);
    }

    public final int getOtherObject(int n) {
        return GameApp.arrayToIntBE(this.m_data, 234 + n * 4);
    }

    public final void setOtherObject(int n, int n2) {
        GameApp.intToArrayBE(n2, this.m_data, 234 + n * 4);
    }

    public final int getCurrentMetaGoal(int n) {
        return GameApp.arrayToIntBE(this.m_data, 298 + 4 * n);
    }

    public final int getAvatarGoalsMet() {
        return GameApp.arrayToIntBE(this.m_data, 58);
    }

    public final int getNumPopups() {
        return this.m_iNumPopups;
    }

    public final boolean isMetaGoalMet(int n) {
        int n2 = this.getMetaGoalMask(n >> 16 & 0xFFFF);
        return (n2 & (n & 0xFFFF)) != 0;
    }

    public final void triggerHint(int n) {
        if (n == 0 || n == Integer.MIN_VALUE) {
            return;
        }
        int n2 = (n & Integer.MIN_VALUE) != 0 ? 1 : 0;
        int n3 = n & Integer.MAX_VALUE;
        int n4 = (n & Integer.MIN_VALUE) != 0 ? 4 : 0;
        int n5 = GameApp.arrayToIntBE(this.m_data, 248 + n4);
        if ((n3 & n5) == 0) {
            int n6;
            int n7 = 1;
            for (n6 = 0; n6 < 31 && (n7 & n3) != n3; ++n6) {
                n7 <<= 1;
            }
            int n8 = DeviceInfo.k_iHintTextIDs[n2][n6];
            if (n8 > -1) {
                switch (n) {
                    case -2147483644: 
                    case -2147483632: 
                    case -2147483584: 
                    case -2143289344: 
                    case 1: 
                    case 8: 
                    case 16: 
                    case 32: 
                    case 1024: 
                    case 2048: 
                    case 0x100000: 
                    case 0x200000: 
                    case 0x400000: 
                    case 0x800000: 
                    case 0x1000000: 
                    case 0x2000000: 
                    case 0x4000000: 
                    case 0x8000000: 
                    case 0x10000000: 
                    case 0x20000000: {
                        this.createTrainerPrompt(n8);
                        this.addStringToPopup(2001);
                        this.m_iPopupHintMask = n;
                        this.addPopup();
                        break;
                    }
                    case -2147450880: {
                        int n9 = 0;
                        for (n7 = 0; n7 < 4; ++n7) {
                            n6 = 0;
                            while (DeviceInfo.k_iMetaGoalList[n6][n7] >= 0) {
                                ++n9;
                                ++n6;
                            }
                        }
                        this.createTrainerPrompt(n8);
                        this.addNumberToPopup(n9);
                        this.m_iPopupHintMask = n;
                        this.addPopup();
                        break;
                    }
                    default: {
                        this.m_iPopupHintMask = n;
                        this.pushTrainerPromptStringID(n8);
                    }
                }
            }
        }
        switch (n) {
            case 0x100000: 
            case 0x200000: {
                if (this.getConsumable(0) != 0 || this.getConsumable(1) != 0 || this.getConsumable(2) != 0 || this.getConsumable(3) != 0) break;
                this.triggerHint(-2147483647);
                break;
            }
            case 0x8000000: 
            case 0x10000000: {
                if (this.getConsumable(7) != 0) break;
                this.triggerHint(-2147483646);
            }
        }
    }

    public final void saveNewUserAndPet() {
        int n;
        for (n = 9; n < 315; ++n) {
            this.m_data[n] = 0;
        }
        this.setUserName(this.m_pNewUserName, GameApp.getStringBufferLength(this.m_pNewUserName));
        for (n = 0; n < 4; ++n) {
            this.setSimPartOption(n, this.m_iNewUserParts[n]);
        }
        for (n = 0; n < 2; ++n) {
            this.setPetPartOption(n, this.m_iNewPetParts[n]);
        }
        this.setPetName(this.m_pNewPetName, GameApp.getStringBufferLength(this.m_pNewPetName));
        for (n = 0; n < 5; ++n) {
            if (n == 4) {
                this.setMotive(n, 163840);
                continue;
            }
            this.setMotive(n, 327680);
        }
        this.setAvatarMoodLevel(245760);
        this.setCurrentSimoleons(25);
        n = 0;
        while (DeviceInfo.k_iDefaultStartingItems[n] >= 0) {
            this.getInventoryItem(DeviceInfo.k_iDefaultStartingItems[n]);
            ++n;
        }
        this.setCatchLevel(1);
        this.setAbility(4, 409600);
        n = 0;
        while (DeviceInfo.k_iInitMetaGoals[n] != 0) {
            if (!this.addMetaGoal(DeviceInfo.k_iInitMetaGoals[n])) {
                // empty if block
            }
            ++n;
        }
        this.setUserExists(true);
        GameApp.releaseStringBuffer(this.m_pNewUserName);
        this.m_pNewUserName = null;
        GameApp.releaseStringBuffer(this.m_pNewPetName);
        this.m_pNewPetName = null;
        this.m_iNumPopups = 0;
    }

    public final void earnSimoleons(int n) {
        int n2 = this.getEarnedSimoleons();
        this.setEarnedSimoleons(n2 += n);
    }

    public final void refundSimoleons(int n) {
        int n2 = this.getCurrentSimoleons();
        this.setCurrentSimoleons(n2 += n);
    }

    public final void spendSimoleons(int n) {
        int n2 = this.getCurrentSimoleons();
        this.setCurrentSimoleons(n2 -= n);
    }

    public final void tallySimoleons() {
        int n = this.getEarnedSimoleons();
        int n2 = this.getCurrentSimoleons();
        this.setCurrentSimoleons(n2 += n);
        n2 = this.getLifetimeSimoleons();
        this.setLifetimeSimoleons(n2 += n);
        this.setEarnedSimoleons(0);
    }

    public final void getInventoryItem(int n) {
        int n2 = DeviceInfo.k_iInventoryItems[n][4];
        if (n2 != 0) {
            this.setInventory(n2);
        } else {
            int n3 = 1;
            switch (n) {
                case 0: {
                    n3 = 14;
                    break;
                }
                case 1: {
                    n3 = 14;
                    break;
                }
                case 2: {
                    n3 = 5;
                    break;
                }
                case 3: {
                    n3 = 2;
                    break;
                }
                case 4: {
                    n3 = 5;
                    break;
                }
                case 5: {
                    n3 = 10;
                    break;
                }
                case 22: {
                    n3 = 10;
                }
            }
            n2 = DeviceInfo.k_iInventoryItems[n][5];
            this.setConsumable(n2, this.getConsumable(n2) + n3);
        }
    }

    public final void buyInventoryItem(int n) {
        this.getInventoryItem(n);
        int n2 = DeviceInfo.k_iInventoryItems[n][2];
        n2 = GameApp.abs(n2);
        this.spendSimoleons(n2);
    }

    public final boolean isInventoryConsumable(int n) {
        return DeviceInfo.k_iInventoryItems[n][4] == 0;
    }

    public final int getInventoryItemQuantity(int n) {
        if (this.isInventoryConsumable(n)) {
            return this.getConsumable(DeviceInfo.k_iInventoryItems[n][5]);
        }
        if (this.checkInventory(DeviceInfo.k_iInventoryItems[n][4])) {
            return 1;
        }
        return 0;
    }

    public final int getWorldSceneID(int n) {
        int n2 = 2;
        while (--n2 >= 0) {
            if (DeviceInfo.k_iScenes[n2][1] != n) continue;
            return n2;
        }
        return 0;
    }

    public final void loadData() {
        int n;
        for (n = 0; n < 315; ++n) {
            this.m_data[n] = 0;
        }
        this.setOption(3);
        this.m_iCurrentLanguage = 1;
        this.m_data[8] = 0;
        this.setSaveVersion(20);
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"simpets", (boolean)false);
            if (recordStore != null) {
                if (recordStore.getNumRecords() >= 1) {
                    recordStore.getRecord(1, this.m_data, 0);
                }
                recordStore.closeRecordStore();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getSaveVersion() != 20) {
            for (n = 0; n < 315; ++n) {
                this.m_data[n] = 0;
            }
            this.setOption(3);
            this.m_iCurrentLanguage = 1;
            this.m_data[8] = 0;
            this.setSaveVersion(20);
        }
    }

    public final void saveData() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"simpets", (boolean)true);
            if (recordStore != null) {
                if (recordStore.getNumRecords() >= 1) {
                    recordStore.setRecord(1, this.m_data, 0, 315);
                } else {
                    recordStore.addRecord(this.m_data, 0, 315);
                }
                recordStore.closeRecordStore();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void openConfirmDialog(int n) {
        this.openConfirmDialog(n, 38);
    }

    public final void openConfirmDialog(int n, int n2) {
        DialogScene dialogScene = new DialogScene(n, n, null);
        if (dialogScene != null) {
            dialogScene.addString(39, -1);
            dialogScene.addString(38, n2);
            this.openScene(dialogScene);
        }
    }

    public final boolean openPauseDialog() {
        DialogScene dialogScene = new DialogScene(35, 35, null);
        if (dialogScene != null) {
            dialogScene.addString(36, -1);
            dialogScene.addString(2, 2);
            dialogScene.addString(8, 8);
            dialogScene.addString(1, 1);
            this.openScene(dialogScene);
            return true;
        }
        return false;
    }

    private final byte[] deqPopup() {
        byte[] byArray = null;
        if (this.m_iNumPopups > 0) {
            int n;
            int n2;
            if (this.m_ilstPopups[0][0] != 0) {
                byte[] byArray2 = GameApp.loadStringResource(this.m_ilstPopups[0][0]);
                for (n2 = 0; n2 < 9 && (n = this.m_ilstPopups[0][n2 + 1]) != -9999; ++n2) {
                    this.m_pPopupArgsTemp[n2] = n == -2001 ? GameApp.dupeStringBuffer(this.getPetName()) : (n < 0 ? GameApp.loadStringResource(-n) : GameApp.getStringBufferForNumber(n));
                }
                if (n2 > 0) {
                    byArray = GameApp.formatStringBuffer(byArray2, this.m_pPopupArgsTemp, n2);
                    while (--n2 >= 0) {
                        if (this.m_pPopupArgsTemp[n2] == null) continue;
                        GameApp.releaseStringBuffer(this.m_pPopupArgsTemp[n2]);
                        this.m_pPopupArgsTemp[n2] = null;
                    }
                    GameApp.releaseStringBuffer(byArray2);
                } else {
                    byArray = byArray2;
                }
                for (n2 = 0; n2 < 10; ++n2) {
                    this.m_iLastPopupParams[n2] = this.m_ilstPopups[0][n2];
                }
            }
            if (this.m_ilstPopupHintMasks[0] != 0) {
                int n3 = this.m_ilstPopupHintMasks[0];
                int n4 = (n3 & Integer.MIN_VALUE) != 0 ? 4 : 0;
                int n5 = GameApp.arrayToIntBE(this.m_data, 248 + n4);
                GameApp.intToArrayBE(n5 |= n3 & Integer.MAX_VALUE, this.m_data, 248 + n4);
            }
            --this.m_iNumPopups;
            for (n = 0; n < this.m_iNumPopups; ++n) {
                this.m_ilstPopupHintMasks[n] = this.m_ilstPopupHintMasks[n + 1];
                for (n2 = 0; n2 < 10; ++n2) {
                    this.m_ilstPopups[n][n2] = this.m_ilstPopups[n + 1][n2];
                }
                this.m_ilstPopups[n + 1][0] = 0;
                this.m_ilstPopups[n + 1][1] = -9999;
                this.m_ilstPopupHintMasks[n + 1] = 0;
            }
        }
        return byArray;
    }

    public final void createTrainerPrompt(int n) {
        this.m_iAddPopupParams[0] = n;
        this.m_iAddPopupParams[1] = -9999;
        this.m_iNumPopupParams = 1;
    }

    public final void createGameMessage(int n) {
        this.m_iAddPopupParams[0] = -n;
        this.m_iAddPopupParams[1] = -9999;
        this.m_iNumPopupParams = 1;
    }

    public final void addStringToPopup(int n) {
        if (this.m_iNumPopupParams < 10) {
            this.m_iAddPopupParams[this.m_iNumPopupParams] = -n;
            ++this.m_iNumPopupParams;
            if (this.m_iNumPopupParams < 10) {
                this.m_iAddPopupParams[this.m_iNumPopupParams] = -9999;
            }
        }
    }

    public final void addNumberToPopup(int n) {
        if (this.m_iNumPopupParams < 10) {
            this.m_iAddPopupParams[this.m_iNumPopupParams] = n;
            ++this.m_iNumPopupParams;
            if (this.m_iNumPopupParams < 10) {
                this.m_iAddPopupParams[this.m_iNumPopupParams] = -9999;
            }
        }
    }

    public final void addPopup() {
        if (this.m_iNumPopupParams > 0 && this.m_iAddPopupParams[0] != 0) {
            if (this.m_iNumPopups < 32) {
                for (int i = 0; i < 10; ++i) {
                    this.m_ilstPopups[this.m_iNumPopups][i] = this.m_iAddPopupParams[i];
                }
                this.m_ilstPopupHintMasks[this.m_iNumPopups] = this.m_iPopupHintMask;
                ++this.m_iNumPopups;
            }
            this.m_iAddPopupParams[0] = 0;
            this.m_iAddPopupParams[1] = -9999;
            this.m_iPopupHintMask = 0;
            this.m_iNumPopupParams = 0;
        }
    }

    public final byte[] deqTrainerPrompt() {
        if (this.m_iNumPopups > 0 && this.m_ilstPopups[0][0] > 0) {
            return this.deqPopup();
        }
        return null;
    }

    public final byte[] deqGameMessage() {
        if (this.m_iNumPopups > 0 && this.m_ilstPopups[0][0] < 0) {
            this.m_ilstPopups[0][0] = -this.m_ilstPopups[0][0];
            return this.deqPopup();
        }
        return null;
    }

    public final void clearPopups() {
        for (int i = 0; i < 32; ++i) {
            this.m_ilstPopups[i][0] = 0;
            this.m_ilstPopups[i][1] = -9999;
            this.m_ilstPopupHintMasks[i] = 0;
        }
        this.m_iNumPopups = 0;
        this.m_iAddPopupParams[0] = 0;
        this.m_iAddPopupParams[1] = -9999;
        this.m_iPopupHintMask = 0;
        this.m_iNumPopupParams = 0;
    }

    public final byte[] getLastPopup() {
        byte[] byArray = null;
        if (this.m_iLastPopupParams[0] != 0) {
            int n;
            int n2;
            byte[] byArray2 = GameApp.loadStringResource(this.m_iLastPopupParams[0]);
            for (n2 = 0; n2 < 9 && (n = this.m_iLastPopupParams[n2 + 1]) != -9999; ++n2) {
                this.m_pPopupArgsTemp[n2] = n == -2001 ? GameApp.dupeStringBuffer(this.getPetName()) : (n < 0 ? GameApp.loadStringResource(-n) : GameApp.getStringBufferForNumber(n));
            }
            if (n2 > 0) {
                byArray = GameApp.formatStringBuffer(byArray2, this.m_pPopupArgsTemp, n2);
                while (--n2 >= 0) {
                    if (this.m_pPopupArgsTemp[n2] == null) continue;
                    GameApp.releaseStringBuffer(this.m_pPopupArgsTemp[n2]);
                    this.m_pPopupArgsTemp[n2] = null;
                }
                GameApp.releaseStringBuffer(byArray2);
            } else {
                byArray = byArray2;
            }
        }
        return byArray;
    }

    public final void pushTrainerPromptStringID(int n) {
        this.createTrainerPrompt(n);
        this.addPopup();
    }

    public final void pushTrainerPromptLearnedAbility(int n) {
        if (0 <= n && n < 27) {
            this.createTrainerPrompt(121);
            this.addStringToPopup(2001);
            this.addStringToPopup(DeviceInfo.k_iPetAbilities[n][1]);
            this.addPopup();
        }
    }

    private final byte[] getMetagoalBuffer(int n, int n2, int n3) {
        byte[] byArray = GameApp.loadStringResource(n);
        byte[][] byArrayArray = new byte[][]{GameApp.loadStringResource(n2), GameApp.getStringBufferForNumber(n3)};
        byte[] byArray2 = GameApp.formatStringBuffer(byArray, byArrayArray, 2);
        GameApp.releaseStringBuffer(byArray);
        GameApp.releaseStringBuffer(byArrayArray[0]);
        GameApp.releaseStringBuffer(byArrayArray[1]);
        return byArray2;
    }

    public final byte[] getLearnedBuffer(int n, int n2) {
        byte[] byArray = GameApp.loadStringResource(n);
        byte[][] byArrayArray = new byte[][]{this.getPetName(), GameApp.loadStringResource(n2)};
        byte[] byArray2 = GameApp.formatStringBuffer(byArray, byArrayArray, 2);
        GameApp.releaseStringBuffer(byArray);
        GameApp.releaseStringBuffer(byArrayArray[1]);
        return byArray2;
    }

    public final byte[] getInventoryBuffer(int n, int n2) {
        return this.getMetagoalBuffer(216, n, n2);
    }

    private final int getNextMetaGoal(int n, int n2) {
        int n3;
        int n4 = this.getMetaGoalMask(n);
        for (n3 = 0; n4 != 0 && n3 < 9 && ((n4 & 1) != 0 || DeviceInfo.k_iMetaGoalList[n3][n] <= 0); ++n3, n4 >>= 1) {
        }
        if (DeviceInfo.k_iMetaGoalList[n3][n] > 0) {
            return n << 16 | 1 << n3;
        }
        if (0 <= n2 && n2 < 4) {
            return this.getNextMetaGoal(n2, n2 + 1);
        }
        return 0;
    }

    private final boolean addMetaGoal(int n) {
        int n2;
        if (this.getCurrentMetaGoal(3) != 0) {
            return false;
        }
        int n3 = (n & 0xFFFF0000) >> 16;
        if (n3 < 0 || n3 >= 4) {
            return false;
        }
        int n4 = 0;
        int n5 = -1;
        for (n2 = n & 0xFFFF; n2 != 0; n2 >>= 1) {
            if ((n2 & 1) != 0) {
                ++n4;
            }
            ++n5;
        }
        if (n4 != 1) {
            return false;
        }
        if (n5 < 0 || n5 >= 9) {
            return false;
        }
        if (DeviceInfo.k_iMetaGoalList[n5][n3] <= 0) {
            return false;
        }
        n5 = n & 0xFFFF;
        n2 = this.getMetaGoalMask(n3);
        if ((n2 & n5) != 0) {
            return false;
        }
        this.setMetaGoalMask(n3, n2 |= n5);
        for (n5 = 0; n5 < 3 && (n2 = this.getCurrentMetaGoal(n5)) != 0; ++n5) {
            if (n >= n2) continue;
            for (n4 = 3; n4 > n5; --n4) {
                n2 = this.getCurrentMetaGoal(n4 - 1);
                this.setCurrentMetaGoal(n4, n2);
            }
            break;
        }
        this.setCurrentMetaGoal(n5, n);
        return true;
    }

    public final boolean isCurrentMetaGoal(int n) {
        for (int i = 0; i < 4; ++i) {
            if (this.getCurrentMetaGoal(i) != n) continue;
            return true;
        }
        return false;
    }

    public final boolean completeMetaGoal(int n) {
        int n2;
        int n3;
        int n4;
        for (n4 = 0; n4 < 4 && this.getCurrentMetaGoal(n4) != n; ++n4) {
        }
        if (n4 >= 4) {
            return false;
        }
        while (++n4 < 4) {
            n3 = this.getCurrentMetaGoal(n4);
            this.setCurrentMetaGoal(n4 - 1, n3);
        }
        this.setCurrentMetaGoal(3, 0);
        int n5 = (n & 0xFFFF0000) >> 16;
        n4 = -1;
        for (n3 = n & 0xFFFF; n3 != 0; n3 >>= 1) {
            ++n4;
        }
        if (DeviceInfo.k_iMetaGoalMsgList[n4][n5] > 0) {
            if (DeviceInfo.k_iMetaGoalMsgList[n4][n5] == 185) {
                this.createTrainerPrompt(185);
                this.addStringToPopup(2001);
                this.addPopup();
            } else {
                this.pushTrainerPromptStringID(DeviceInfo.k_iMetaGoalMsgList[n4][n5]);
            }
        }
        if (n5 == 2 && this.getMetaGoalMask(3) == 0) {
            n5 = 3;
        }
        if ((n3 = this.getNextMetaGoal(n5, 2)) != 0 && this.addMetaGoal(n3)) {
            this.pushTrainerPromptStringID(222);
            n5 = (n3 & 0xFFFF0000) >> 16;
            n3 &= 0xFFFF;
            n4 = -1;
            while (n3 != 0) {
                ++n4;
                n3 >>= 1;
            }
            if (n4 >= 0) {
                switch (n5) {
                    case 0: {
                        this.createTrainerPrompt(275);
                        this.addStringToPopup(DeviceInfo.k_iMetaGoalList[n4][n5]);
                        this.addPopup();
                        break;
                    }
                    case 1: {
                        this.createTrainerPrompt(276);
                        this.addStringToPopup(DeviceInfo.k_iMetaGoalList[n4][n5]);
                        this.addPopup();
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.createTrainerPrompt(DeviceInfo.k_iMetaGoalList[n4][n5]);
                        this.addPopup();
                    }
                }
            }
        }
        int n6 = this.getAvatarRank();
        n4 = this.getAvatarGoalsMet();
        this.setAvatarGoalsMet(++n4);
        int n7 = this.getAvatarRank();
        if (n7 != n6) {
            n2 = DeviceInfo.k_iSimGoalInfo[n7][2];
            this.createGameMessage(234);
            this.addNumberToPopup(n2);
            this.addPopup();
            this.earnSimoleons(n2);
            this.tallySimoleons();
        }
        n2 = 0;
        for (n5 = 0; n5 < 4; ++n5) {
            n3 = 0;
            while (DeviceInfo.k_iMetaGoalList[n3][n5] >= 0) {
                ++n2;
                ++n3;
            }
        }
        if (n4 >= n2) {
            this.createTrainerPrompt(203);
            this.addNumberToPopup(n4);
            this.addPopup();
        }
        return true;
    }

    public final int getLastLearnedTrickMask() {
        int n = this.getMetaGoalMask(0);
        int n2 = this.getCurrentMetaGoal(0);
        if ((n2 & 0xFFFF0000) >> 16 == 0) {
            n &= ~(n2 &= 0xFFFF);
        }
        int n3 = -1;
        while (n != 0) {
            ++n3;
            n >>= 1;
        }
        if (n3 < 0 || n3 >= 9) {
            return -1;
        }
        return DeviceInfo.k_iMetaGoalList[n3][0];
    }

    public final int getAvatarRank() {
        int n = this.getAvatarGoalsMet();
        int n2 = 0;
        while (DeviceInfo.k_iSimGoalInfo[n2][3] != -1 && n >= DeviceInfo.k_iSimGoalInfo[n2][3]) {
            ++n2;
        }
        return n2;
    }

    public final void incrAvatarMood(int n) {
        int n2 = this.getAvatarMoodLevel() + n;
        if (n2 > 409600) {
            n2 = 409600;
        }
        this.setAvatarMoodLevel(n2);
    }

    public final void decrAvatarMood(int n) {
        int n2 = this.getAvatarMoodLevel() - n;
        if (n2 < 0) {
            n2 = 0;
        }
        this.setAvatarMoodLevel(n2);
    }

    public final int getAvatarMoodState(int n) {
        for (int i = 0; i < 4; ++i) {
            if (n >= DeviceInfo.k_iMoodLevels[i]) continue;
            return i - 1;
        }
        return 3;
    }

    public final int getAvatarMoodDegreeColor(int n) {
        int n2 = n * 100 / 360;
        for (int i = 0; i < 4; ++i) {
            if (n2 >= DeviceInfo.k_iMoodLevels[i]) continue;
            return DeviceInfo.k_iMoodLevels[i];
        }
        return DeviceInfo.k_iMoodLevels[3];
    }

    public final int getNeedColor(int n) {
        int n2 = 0;
        while (DeviceInfo.k_iNeedLevels[n2][0] != -1 && n >= DeviceInfo.k_iNeedLevels[n2][0]) {
            ++n2;
        }
        return DeviceInfo.k_iNeedLevels[n2][1];
    }

    private final void loadSounds() {
        SoundManager soundManager = this.getSoundManager();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 6 && DeviceInfo.k_iSFX[i][j] >= 0; ++j) {
                soundManager.loadResource(DeviceInfo.k_iSFX[i][j]);
            }
        }
    }

    public final boolean isPlayingSound(int n) {
        if (this.m_pSoundManager != null && this.checkOption(1)) {
            for (int i = 0; i < 6 && DeviceInfo.k_iSFX[n][i] >= 0; ++i) {
                if (!this.m_pSoundManager.isPlaying(DeviceInfo.k_iSFX[n][i])) continue;
                return true;
            }
        }
        return false;
    }

    public final void playSound(int n) {
        if (this.m_pSoundManager != null && this.checkOption(1)) {
            int n2;
            switch (n) {
                case 90: {
                    n = this.getSimPartOption(0) == 0 ? 9 : 6;
                    break;
                }
                case 91: {
                    n = this.getSimPartOption(0) == 0 ? 10 : 7;
                    break;
                }
                case 92: {
                    n = this.getSimPartOption(0) == 0 ? 11 : 8;
                }
            }
            for (n2 = 0; n2 < 6 && DeviceInfo.k_iSFX[n][n2] >= 0; ++n2) {
            }
            if (n2 > 0) {
                n2 = n2 > 1 ? (GameApp.nextInt() & Integer.MAX_VALUE) % n2 : 0;
                this.m_pSoundManager.playSound(DeviceInfo.k_iSFX[n][n2]);
            }
        }
    }

    public final void playMusic() {
        if (this.m_pSoundManager != null && this.checkOption(1)) {
            this.m_pSoundManager.playMusic(95);
        }
    }

    public final void playVib() {
        if (this.m_pSoundManager != null && this.checkOption(2)) {
            this.m_pSoundManager.playVib(500);
        }
    }

    public final void stopMusic() {
        if (this.m_pSoundManager != null) {
            this.m_pSoundManager.stopAmbient();
        }
    }

    public final void stopSound() {
        if (this.m_pSoundManager != null) {
            this.m_pSoundManager.stopPlayback();
        }
    }

    public final void setSoundVolume(int n) {
        if (this.m_pSoundManager != null) {
            this.m_pSoundManager.setSoundVolume(n);
        }
    }

    public final void setMusicVolume(int n) {
        if (this.m_pSoundManager != null) {
            this.m_pSoundManager.setMusicVolume(n);
        }
    }

    public final void moreGames() {
        int n = 0;
        if (iUseStatic == -1) {
            String string = BundleMidlet.bunMid.getAppProperty("MoreGames_WAP_URI");
            String string2 = BundleMidlet.bunMid.getAppProperty("MoreGames_Impl");
            if (string2 != null) {
                string2 = string2.trim();
                string2 = string2.toLowerCase();
            }
            if (string != null) {
                string = string.trim();
            }
            if (string2 != null && string2.length() > 0) {
                if (string2.equals("static")) {
                    n = 1;
                } else if (string2.equals("wap") || string2.equals("wapstatic")) {
                    if (string2.equals("wapstatic")) {
                        n = 1;
                    }
                    if (string != null && string.length() > 0 && string.compareTo("") != 0) {
                        n = 2;
                    }
                }
            }
            iUseStatic = n;
            pURLStatic = string;
        } else {
            n = iUseStatic;
            String string = pURLStatic;
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    InfoPageScene infoPageScene = new InfoPageScene(363, 360);
                    if (infoPageScene == null) break;
                    this.openScene(infoPageScene);
                    break;
                }
                case 2: {
                    this.makePlatformRequest(string);
                }
            }
        }
    }

    public PetsApp() {
        if (BundleCanvas.launch_once == 1) {
            BundleCanvas.launch_once = 0;
            GameApp.m_instance = this;
            GameApp.m_instance.startApp();
        }
        this.m_iCurrentCharMap = -1;
        this.m_iSplashTimer = 1;
        this.m_iSplashIndex = -1;
        this.moreGames();
    }

    public void destroyApp() {
        if (this.m_pNewUserName != null) {
            GameApp.releaseStringBuffer(this.m_pNewUserName);
            this.m_pNewUserName = null;
        }
        if (this.m_pNewPetName != null) {
            GameApp.releaseStringBuffer(this.m_pNewPetName);
            this.m_pNewPetName = null;
        }
        try {
            super.destroyApp(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saveData();
        this.stopMusic();
        this.stopSound();
        if (this.m_pimgSplash != null) {
            GameApp.releaseImageResource(this.m_pimgSplash);
            this.m_pimgSplash = null;
        }
        if (this.m_panmSplash != null) {
            this.m_panmSplash.onReleaseResource();
            this.m_panmSplash = null;
        }
        if (this.m_panmLoadingBar != null) {
            this.m_panmLoadingBar.onReleaseResource();
            this.m_panmLoadingBar = null;
        }
    }

    public void destroyApp(boolean bl) {
        this.destroyApp();
    }

    protected void initApp() {
        SoundManager soundManager = this.getSoundManager();
        this.m_pResFileSizes = pets.pets_FileSizes;
        this.m_pFont = new Font();
        this.m_pFont.loadResource(0);
        this.m_panmLoadingBar = new AnimObject();
        if (this.m_panmLoadingBar != null) {
            this.m_panmLoadingBar.onLoadResource(32);
            this.m_panmLoadingBar.setState(0, 0, false);
            this.m_panmLoadingBar.setLocation(this.m_iScreenWidth << 12 >> 1, this.m_iScreenHeight << 12 >> 1);
        }
        if (soundManager != null) {
            soundManager.loadResource(95);
            this.loadSounds();
        }
        this.setMusicVolume(100);
        this.setCharacterMap(0);
        this.loadData();
        this.m_iCurrentLanguage = 0;
        if (this.m_data[8] == 0) {
            this.loadStrings(80);
        } else {
            this.setLanguage(this.m_data[8]);
        }
        this.m_pyLoadingString = GameApp.loadStringResource(111);
    }

    public void onSuspend() {
        this.stopMusic();
        this.stopSound();
        super.onSuspend();
    }

    public void onResume() {
        super.onResume();
        if (this.m_bWantMusic) {
            // empty if block
        }
    }

    public final void drawCommonBackground(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n4 >= this.m_iScreenHeight - 4 && n3 >= this.m_iScreenWidth - 4) {
            graphics.setColor(3689872);
            graphics.fillRect(0, 0, n3, n4);
        } else {
            graphics.setColor(1645101);
            graphics.drawRect(n + 2, n2 - 1, n3 - 4, n4 + 2);
            graphics.fillRect(n + 3, n2 - 2, n3 - 5, n4 + 5);
            graphics.fillRect(n + 1, n2, n3 - 1, n4 + 1);
            graphics.setColor(4672127);
            graphics.drawRect(n + 2, n2 - 1, n3 - 5, n4 + 1);
            graphics.fillRect(n + 3, n2 - 2, n3 - 6, n4 + 4);
            graphics.fillRect(n + 1, n2, n3 - 2, n4);
            graphics.setColor(5463451);
            graphics.fillRect(n + 4, n2, n3 - 8, n4);
            graphics.fillRect(n + 3, n2 + 1, n3 - 6, n4 - 2);
        }
    }

    public final void drawLoadingBar(Graphics graphics, int n, int n2) {
        int n3 = this.m_iScreenHeight >> 1;
        int n4 = 0;
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        int n9 = 0;
        graphics.setColor(5463451);
        graphics.setClip(0, 0, 320, 320);
        graphics.fillRect(0, 0, 320, 320);
        if (this.m_panmLoadingBar != null) {
            int n10;
            int n11;
            int n12 = this.m_iScreenWidth / 5;
            int n13 = n / 20;
            int n14 = 0;
            int n15 = this.m_panmLoadingBar.getWidth() >> 12;
            n4 = this.m_panmLoadingBar.getHeight() >> 12;
            n3 -= n4 >> 1;
            if (n > 99) {
                n = 99;
            }
            int n16 = this.m_iScreenWidth - (n12 - n15);
            n16 = n * n16 / 99;
            this.drawCommonBackground(graphics, 0, 0, this.m_iScreenWidth, this.m_iScreenHeight);
            n14 = (n12 >> 1) - (n15 >> 1);
            for (n11 = 0; n11 < 5; ++n11) {
                n10 = n11 * n12 + (n12 >> 1) - (n15 >> 1);
                this.m_panmLoadingBar.setState(0, 0, false);
                this.m_panmLoadingBar.onPaint(graphics, n10, n3, n15, n4, 0, 0);
            }
            for (n11 = 0; n11 < 5; ++n11) {
                n10 = n11 * n12 + (n12 >> 1) - (n15 >> 1);
                if (n10 > n16) continue;
                int n17 = n10 + n15 > n16 ? n15 - (n10 + n15 - n16) + n14 : n15;
                this.m_panmLoadingBar.setState(1, 0, false);
                this.m_panmLoadingBar.onPaint(graphics, n10, n3, n17, n4, 0, 0);
            }
        }
        n3 += n4;
        GameScene gameScene = (GameScene)this.m_pSceneLoading;
        n9 = this.m_pFont.getHeight();
        if (gameScene != null && gameScene.m_pyLoadingLocationString != null) {
            byte[] byArray = gameScene.m_pyLoadingLocationString;
            this.m_pFont.textRender(graphics, 0, n3 + (n9 << 1) + (n9 >> 1), this.m_iScreenWidth, n9, 4, byArray, 0, 0, GameApp.getStringBufferLength(byArray), false, null);
        }
        if (this.m_pyLoadingString != null) {
            this.m_pFont.textRender(graphics, 0, n3 + n9, this.m_iScreenWidth, n9, 4, this.m_pyLoadingString, 0, 0, GameApp.getStringBufferLength(this.m_pyLoadingString), false, null);
        }
        graphics.setClip(n5, n6, n7, n8);
    }

    public int onStartFirstScene() {
        if (this.m_iSplashTimer == 0) {
            DialogScene dialogScene = null;
            if (this.m_iStartupScreen == 0) {
                this.m_iStartupScreen = DeviceInfo.k_iStartupScreenOrder[0];
            }
            switch (this.m_iStartupScreen) {
                case 1: {
                    break;
                }
                case 3: {
                    DialogScene dialogScene2 = new DialogScene(209, 209, null);
                    if (dialogScene2 == null) break;
                    dialogScene2.addString(38, 38);
                    dialogScene2.addString(39, 39);
                    dialogScene2.m_iAcceptSoftKeyTextID = 25;
                    dialogScene2.m_iCancelSoftKeyTextID = 5;
                    dialogScene = dialogScene2;
                    break;
                }
                case 4: {
                    this.m_iDeferredScene = 0;
                    this.closeAllScenes();
                }
            }
            if (DeviceInfo.k_iStartupScreenOrder[this.m_iStartupScreen] != -1) {
                this.m_iStartupScreen = DeviceInfo.k_iStartupScreenOrder[this.m_iStartupScreen];
            }
            if (dialogScene != null) {
                this.openScene(dialogScene);
            }
        }
        return 1;
    }

    public void onDeferredScene() {
        GameScene gameScene = null;
        switch (this.m_iDeferredScene) {
            case 0: {
                this.m_bWantMusic = true;
                gameScene = new MainMenuScene();
                break;
            }
            case 1: {
                gameScene = new CreateSimScene();
                break;
            }
            case 2: {
                gameScene = new ChoosePetScene();
                break;
            }
            case 3: {
                this.m_bWantMusic = false;
                gameScene = new HudScene();
                break;
            }
            case 4: {
                gameScene = new StoreScene(78);
                break;
            }
            case 5: {
                gameScene = new MetaGameScene();
                if (gameScene == null) break;
                this.openScene(gameScene);
                break;
            }
            default: {
                return;
            }
        }
        if (gameScene != null) {
            this.openScene(gameScene);
        }
    }

    public int onDialogEvent(int n, int n2) {
        MenuScene menuScene = null;
        switch (n2) {
            case 35: 
            case 122: {
                switch (n) {
                    case 2: {
                        menuScene = new OptionScene(76);
                        break;
                    }
                    case 8: {
                        menuScene = new MenuScene(73);
                        break;
                    }
                    case 124: {
                        menuScene = new MenuScene(72);
                        break;
                    }
                    case 1: {
                        this.closeAllScenes();
                        this.onStartFirstScene();
                        break;
                    }
                    case 175: 
                    case 176: {
                        this.setCurrentLocation(this.getWorldSceneID(n));
                        this.onDialogEvent(0, 61);
                    }
                }
                break;
            }
            case 37: {
                if (n != 38) break;
                this.m_bQuitRequested = true;
                break;
            }
            case 362: {
                if (n != 38) break;
                if (this.m_pNewUserName != null) {
                    GameApp.releaseStringBuffer(this.m_pNewUserName);
                    this.m_pNewUserName = null;
                }
                for (int i = 0; i < 4; ++i) {
                    this.m_iNewUserParts[i] = 0;
                }
                this.closeAllScenes();
                this.m_iDeferredScene = 1;
                break;
            }
            case 61: {
                this.stopMusic();
                this.stopSound();
                this.closeAllScenes();
                this.m_iDeferredScene = 3;
                break;
            }
            case 28: {
                this.buyInventoryItem(n);
                this.closeScene(this.getCurrentScene());
                break;
            }
            case 209: {
                switch (n) {
                    case 38: {
                        this.setOption(1);
                        break;
                    }
                    case 39: {
                        this.clearOption(1);
                        break;
                    }
                    default: {
                        return 0;
                    }
                }
                if (this.getUserExists()) {
                    this.setCurrentLocation(0);
                    this.onDialogEvent(0, 61);
                    break;
                }
                this.onStartFirstScene();
                break;
            }
            case 210: {
                break;
            }
            case 95: 
            case 98: {
                this.setCurrentLocation(0);
                this.onDialogEvent(0, 61);
                break;
            }
            case 373: {
                if (n != 38) break;
                this.moreGames();
            }
        }
        if (menuScene != null) {
            this.openScene(menuScene);
        }
        return 0;
    }

    public int onIdle(int n) {
        if (this.m_iSplashTimer > 0) {
            if (this.m_bGamePaused) {
                return 0;
            }
            switch (this.m_iKeysDown) {
                case 65568: 
                case 131072: 
                case 262144: {
                    this.m_iSplashTimer = 0;
                }
            }
            this.m_iSplashTimer -= n;
            if (this.m_iSplashTimer <= 0) {
                if (this.m_pimgSplash != null) {
                    GameApp.releaseImageResource(this.m_pimgSplash);
                    this.m_pimgSplash = null;
                }
                if (this.m_panmSplash != null) {
                    this.m_panmSplash.onReleaseResource();
                    this.m_panmSplash = null;
                }
                ++this.m_iSplashIndex;
                if (DeviceInfo.k_iSplashResID[this.m_iSplashIndex][0] >= 0) {
                    this.m_iSplashTimer = 3000;
                    if (this.m_pimgSplash == null && DeviceInfo.k_iSplashResID[this.m_iSplashIndex][0] > 0) {
                        this.m_pimgSplash = GameApp.loadImageResource(DeviceInfo.k_iSplashResID[this.m_iSplashIndex][0], 0);
                    }
                    if (1 == this.m_iSplashIndex) {
                        this.m_panmSplash = new AnimObject();
                        if (this.m_panmSplash != null) {
                            this.m_panmSplash.onLoadResource(2);
                            this.m_panmSplash.setLocation((this.m_iScreenWidth >> 1) - (this.m_panmSplash.getWidth() >> 1 >> 12), (this.m_iScreenHeight >> 1) - (this.m_panmSplash.getHeight() >> 1 >> 12));
                        }
                    }
                } else {
                    this.m_iSplashTimer = 0;
                    this.onStartFirstScene();
                }
            }
            return 0;
        }
        return super.onIdle(n);
    }

    public void onPaint(Graphics graphics) {
        if (this.moneyCheat) {
            this.earnSimoleons(500);
            this.tallySimoleons();
            this.moneyCheat = false;
        }
        if (this.m_iSplashTimer > 0) {
            if (this.m_iSplashIndex >= 0) {
                graphics.setColor(DeviceInfo.k_iSplashResID[this.m_iSplashIndex][1]);
                graphics.fillRect(0, 0, this.m_iScreenWidth, this.m_iScreenHeight);
            }
            if (this.m_pimgSplash != null) {
                int n = this.m_iScreenWidth - this.m_pimgSplash.getWidth() >> 1;
                int n2 = this.m_iScreenHeight - this.m_pimgSplash.getHeight() >> 1;
                graphics.drawImage(this.m_pimgSplash, n, n2, 0);
            }
            if (this.m_panmSplash != null) {
                this.m_panmSplash.onPaint(graphics, this.m_panmSplash.m_iX, this.m_panmSplash.m_iY, this.m_iScreenWidth, this.m_iScreenHeight, 0, 0);
            }
            this.m_bPainted = true;
        } else {
            super.onPaint(graphics);
        }
    }
}

