/*
 * Decompiled with CFR 0.152.
 */
package sims_pets;

import sims_pets.AnimObject;
import sims_pets.GameApp;
import sims_pets.HudScene;
import sims_pets.PetsGame;

public class Interactive
extends AnimObject {
    public static final int kPointSetObjectTL = 0;
    public static final int kPointSetObjectBR = 1;
    public static final int kPointSetHighest = 1;
    public static final int kGenericLevelMin = 0;
    public static final int kGenericLevelMax = 409600;
    public static final int kInteractionType = 0;
    public static final int kInteractionStringID = 1;
    public static final int kInteractionSize = 2;
    public static final int kMaxLocalInteractions = 20;
    public static final int kMaxSatisfierInterest = 368640;
    public static final int kMinSatisfierInterest = 40960;
    public static final int kMaxNumberOfInteractions = 27;
    public static final int kFixedCoeffGravity = 40140;
    public static final int kInteractionID = 0;
    public static final int kAbilityID = 0;
    public static final int kStringID = 1;
    protected boolean m_bPauseInterestGen;
    protected boolean m_bActive;
    protected boolean m_bNoContainment;
    protected boolean m_bStationary;
    protected boolean m_bRemovable;
    protected int m_xInterestLevel;
    protected int m_xInterestRate;
    protected int m_xMinInterestLevel;
    protected int m_xMaxInterestLevel;
    protected int m_xInterestEffectRadius;
    protected int[][] m_ppiInteractions = new int[20][2];
    protected int m_iCurrentAI;
    protected int m_iNextAI;
    protected int m_iPrevAI;
    protected byte[] m_pyName;
    protected int[][] m_ppiInteractionList = new int[27][2];
    protected int m_iInteractionCount;
    protected int m_iNumAvailableInteractions;
    protected int[][] m_ppiAbilityList = new int[27][2];
    protected int m_iAbilityCount;
    protected int m_iCollisionGroup;
    protected int m_iCollisionMask;
    protected int[] m_xVelocity = new int[3];
    protected int[] m_xAccel = new int[3];
    protected int m_xWorldX;
    protected int m_xWorldY;
    protected int m_xWorldZ;
    protected int m_xWorldWidth;
    protected int m_xWorldHeight;
    protected int m_xWorldLeft;
    protected int m_xWorldTop;
    protected int m_xWorldRight;
    protected int m_xWorldBottom;
    protected int[] m_piPoints = new int[3];

    public Interactive(int n) {
        this.m_iInstanceID = n;
        this.m_xMaxInterestLevel = 409600;
    }

    public final void setName(byte[] byArray) {
        if (this.m_pyName != null) {
            GameApp.releaseStringBuffer(this.m_pyName);
            this.m_pyName = null;
        }
        if (byArray != null) {
            this.m_pyName = GameApp.dupeStringBuffer(byArray);
        }
    }

    public final void setName(int n) {
        if (this.m_pyName != null) {
            GameApp.releaseStringBuffer(this.m_pyName);
            this.m_pyName = null;
        }
        if (n > 0) {
            this.m_pyName = GameApp.loadStringResource(n);
        }
    }

    protected final void shiftInteractionList() {
        int n = 0;
        int n2 = 0;
        while (n < this.m_iInteractionCount) {
            if (n == n2) {
                if (this.m_ppiInteractions[n][0] > 0) {
                    ++n;
                    ++n2;
                    continue;
                }
                ++n2;
                continue;
            }
            if (this.m_ppiInteractions[n2][0] > 0) {
                this.m_ppiInteractions[n][0] = this.m_ppiInteractions[n2][0];
                this.m_ppiInteractions[n][1] = this.m_ppiInteractions[n2][1];
                this.m_ppiInteractions[n2][0] = 0;
                this.m_ppiInteractions[n2][1] = 0;
                --this.m_iInteractionCount;
                n2 = ++n;
                continue;
            }
            if (++n2 < 20) continue;
            this.m_iInteractionCount = n;
            break;
        }
    }

    public final void removeInteraction(int n) {
        if (n >= 0 && n < this.m_iInteractionCount) {
            this.m_ppiInteractions[n][0] = 0;
            this.m_ppiInteractions[n][1] = 0;
            this.shiftInteractionList();
        }
    }

    public final void removeInteraction(int n, int n2) {
        int n3 = this.getInteractionIndex(n, n2);
        if (n3 >= 0) {
            this.removeInteraction(n3);
        }
    }

    public final void removeInteractionsByType(int n) {
        for (int i = 0; i < this.m_iInteractionCount; ++i) {
            if (this.m_ppiInteractions[i][0] != n) continue;
            this.m_ppiInteractions[i][0] = 0;
            this.m_ppiInteractions[i][1] = 0;
        }
        this.shiftInteractionList();
    }

    public final int getInteractionIndex(int n, int n2) {
        for (int i = 0; i < this.m_iInteractionCount; ++i) {
            if (this.m_ppiInteractions[i][0] != n || this.m_ppiInteractions[i][1] != n2) continue;
            return i;
        }
        return -1;
    }

    public final void setMinInterest(int n) {
        this.m_xMinInterestLevel = n;
        if (this.m_xInterestLevel < this.m_xMinInterestLevel) {
            this.m_xInterestLevel = this.m_xMinInterestLevel;
        }
    }

    public final void setMaxInterest(int n) {
        this.m_xMaxInterestLevel = n;
        if (this.m_xInterestLevel > this.m_xMaxInterestLevel) {
            this.m_xInterestLevel = this.m_xMaxInterestLevel;
        }
    }

    public void onActivate() {
        this.m_bActive = true;
    }

    public void onDeactivate() {
        this.m_bActive = false;
    }

    public void setCurrentAI(int n) {
    }

    public void setNextAI(int n) {
    }

    public void advanceAI() {
    }

    public void onUserSelected() {
    }

    public void handleInteractionAbility(int n) {
    }

    public final void addInteraction(int n, int n2) {
        if (this.m_iInteractionCount < 27) {
            this.m_ppiInteractionList[this.m_iInteractionCount][0] = n;
            this.m_ppiInteractionList[this.m_iInteractionCount][1] = n2;
            ++this.m_iInteractionCount;
        }
    }

    public final void addAbility(int n, int n2) {
        if (this.m_iAbilityCount < 27) {
            this.m_ppiAbilityList[this.m_iAbilityCount][0] = n;
            this.m_ppiAbilityList[this.m_iAbilityCount][1] = n2;
            ++this.m_iAbilityCount;
        }
    }

    public final void setupInteractionMenu(HudScene hudScene) {
        if (hudScene != null) {
            int n;
            for (n = 0; n < this.m_iInteractionCount; ++n) {
                if (!this.canAddInteraction(this.m_ppiInteractionList[n][0])) continue;
                hudScene.addString(this.m_ppiInteractionList[n][1], this.m_ppiInteractionList[n][0]);
            }
            for (n = 0; n < this.m_iAbilityCount; ++n) {
                if (!this.canAddAbility(this.m_ppiAbilityList[n][0])) continue;
                hudScene.addString(this.m_ppiAbilityList[n][1], this.m_ppiAbilityList[n][0]);
            }
            hudScene.addString(9, -1);
        }
    }

    protected boolean canAddInteraction(int n) {
        return true;
    }

    protected boolean canAddAbility(int n) {
        return true;
    }

    public final void setVelocity(int n, int n2, int n3) {
        this.m_xVelocity[0] = n;
        this.m_xVelocity[1] = n2;
        this.m_xVelocity[2] = n3;
    }

    public final void setAccel(int n, int n2, int n3) {
        this.m_xAccel[0] = n;
        this.m_xAccel[1] = n2;
        this.m_xAccel[2] = n3;
    }

    public final void setVelocity(int n, int n2, int n3, int n4) {
        this.m_xVelocity[0] = n;
        this.m_xVelocity[1] = n2;
        this.m_xVelocity[2] = n3;
        GameApp.normalize3D(this.m_xVelocity, this.m_xVelocity);
        this.m_xVelocity[0] = GameApp.mul(this.m_xVelocity[0], n4);
        this.m_xVelocity[1] = GameApp.mul(this.m_xVelocity[1], n4);
        this.m_xVelocity[2] = GameApp.mul(this.m_xVelocity[2], n4);
    }

    public final void stopMovement() {
        this.setVelocity(0, 0, 0);
        this.setAccel(0, 0, 0);
    }

    public final boolean isMoving() {
        return this.m_xVelocity[0] != 0 || this.m_xVelocity[1] != 0 || this.m_xVelocity[2] != 0 || this.m_xAccel[0] != 0 || this.m_xAccel[1] != 0 || this.m_xAccel[2] != 0;
    }

    public final void setWorldLocation(int n, int n2, int n3) {
        if (this.m_pParent == null) {
            return;
        }
        if (this.m_xWorldX != n || this.m_xWorldY != n2 || this.m_xWorldZ != n3) {
            this.m_xWorldX = n;
            this.m_xWorldY = n2;
            this.m_xWorldZ = n3;
            PetsGame petsGame = (PetsGame)this.m_pParent;
            int[] nArray = petsGame.toIsoCoord(this.m_xWorldX, this.m_xWorldY);
            this.setLocation(nArray[0], nArray[1] - this.m_xWorldZ);
            nArray = petsGame.toIsoCoord(this.m_xWorldRight, this.m_xWorldTop);
            this.setZ(nArray[1]);
        }
    }

    public final void setWorldX(int n) {
        this.setWorldLocation(n, this.m_xWorldY, this.m_xWorldZ);
    }

    public final void setWorldY(int n) {
        this.setWorldLocation(this.m_xWorldX, n, this.m_xWorldZ);
    }

    public final void setWorldZ(int n) {
        this.setWorldLocation(this.m_xWorldX, this.m_xWorldY, n);
    }

    public final void setWorldWidth(int n) {
        if (this.m_pParent == null) {
            return;
        }
        this.m_xWorldWidth = n;
    }

    public final void setWorldHeight(int n) {
        if (this.m_pParent == null) {
            return;
        }
        this.m_xWorldHeight = n;
    }

    public final int getScreenLeft() {
        return this.m_pParent != null ? this.m_iLeft - this.m_pParent.m_iX : 0;
    }

    public final int getScreenTop() {
        return this.m_pParent != null ? this.m_iTop - this.m_pParent.m_iY : 0;
    }

    public final int getScreenRight() {
        return this.m_pParent != null ? this.m_iRight - this.m_pParent.m_iX : 0;
    }

    public final int getScreenBottom() {
        return this.m_pParent != null ? this.m_iBottom - this.m_pParent.m_iY : 0;
    }

    public boolean onCheckContainment(int[] nArray) {
        return false;
    }

    public void onHandleContainment(int[] nArray) {
    }

    public boolean onCheckCollision(Interactive interactive) {
        return this.m_xWorldLeft < interactive.m_xWorldRight && this.m_xWorldRight > interactive.m_xWorldLeft && this.m_xWorldTop < interactive.m_xWorldBottom && this.m_xWorldBottom > interactive.m_xWorldTop;
    }

    public void onHandleCollision(Interactive interactive) {
    }

    public void onIdle(int n) {
        if (this.isMoving() && this.m_bVisible && !this.m_bStationary) {
            int[] nArray = new int[]{this.m_xVelocity[0], this.m_xVelocity[1], this.m_xVelocity[2]};
            long l = n << 2;
            this.m_xVelocity[0] = this.m_xVelocity[0] + (int)((long)this.m_xAccel[0] * l >> 12);
            this.m_xVelocity[1] = this.m_xVelocity[1] + (int)((long)this.m_xAccel[1] * l >> 12);
            this.m_xVelocity[2] = this.m_xVelocity[2] + (int)((long)this.m_xAccel[2] * l >> 12);
            this.setWorldLocation(this.m_xWorldX + this.m_xVelocity[0], this.m_xWorldY + this.m_xVelocity[1], this.m_xWorldZ + this.m_xVelocity[2]);
        }
        if (!this.m_bPauseInterestGen && this.m_xInterestRate != 0) {
            this.m_xInterestLevel += this.m_xInterestRate * n / 1000;
            if (this.m_xInterestLevel <= this.m_xMinInterestLevel) {
                this.m_xInterestLevel = this.m_xMinInterestLevel;
                if (this.m_xInterestLevel == 0) {
                    this.onDeactivate();
                }
            } else if (this.m_xInterestLevel > this.m_xMaxInterestLevel) {
                this.m_xInterestLevel = this.m_xMaxInterestLevel;
            }
        }
        super.onIdle(n);
    }

    public boolean onCheckIsoContainment(int[] nArray) {
        return false;
    }

    public void onHandleIsoContainment(int[] nArray) {
    }

    public void onUpdateRect() {
        if (this.m_pParent != null) {
            if (this.getNumPointSets() >= 2) {
                PetsGame petsGame = (PetsGame)this.m_pParent;
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                this.getPointSet(1, this.m_piPoints);
                if (this.m_bMirrored) {
                    n = this.m_piPoints[0];
                } else {
                    n3 = this.m_piPoints[0];
                }
                n4 = this.m_piPoints[1];
                this.getPointSet(0, this.m_piPoints);
                if (this.m_bMirrored) {
                    n3 = this.m_piPoints[0];
                } else {
                    n = this.m_piPoints[0];
                }
                n2 = this.m_piPoints[1];
                int[] nArray = petsGame.toWorldCoord(n3 << 12, n4 << 12);
                this.m_xWorldWidth = nArray[0];
                this.m_xWorldHeight = nArray[1];
                nArray = petsGame.toWorldCoord(n << 12, n2 << 12);
                this.m_xWorldWidth -= nArray[0];
                this.m_xWorldHeight -= nArray[1];
            }
            if (this.m_xWorldWidth < 0) {
                this.m_xWorldWidth = 0;
            }
            if (this.m_xWorldHeight < 0) {
                this.m_xWorldHeight = 0;
            }
            if (this.m_xWorldWidth == 0) {
                this.m_xWorldWidth = 20480;
            }
            if (this.m_xWorldHeight == 0) {
                this.m_xWorldHeight = 20480;
            }
            this.m_xWorldLeft = this.m_xWorldX - (this.m_xWorldWidth >> 1);
            this.m_xWorldTop = this.m_xWorldY - (this.m_xWorldHeight >> 1);
            this.m_xWorldRight = this.m_xWorldLeft + this.m_xWorldWidth;
            this.m_xWorldBottom = this.m_xWorldTop + this.m_xWorldHeight;
        }
        super.onUpdateRect();
    }
}

