/*
 * Decompiled with CFR 0.152.
 */
package sims_pets;

import javax.microedition.lcdui.Graphics;
import sims_pets.AnimObject;
import sims_pets.Box;
import sims_pets.Font;
import sims_pets.GameApp;
import sims_pets.GameObject;
import sims_pets.GameScene;
import sims_pets.PetsApp;
import sims_pets.TextObject;

public class InfoPageScene
extends GameScene {
    public static final int kTitleTextID = 7000;
    public static final int kMainBoxID = 7001;
    public static final int kArrowUpID = 7004;
    public static final int kArrowDownID = 7005;
    public static final int kMaxNumInfoPage = 16;
    private byte[] m_strInfoText;
    private int m_iInfoTextID;
    private int m_iTitleTextID;
    private Font m_pFont;
    private byte[] m_pyText;
    private int[] m_pOffsetOnPage = new int[16];
    private int m_iCurrentPage;
    private int m_iNumPages;
    private AnimObject m_pDownArrow;
    private AnimObject m_pUpArrow;
    private int m_iCurOffset;
    private int m_iTotalStrLen;
    private int m_iCurrentStrLen;
    private TextObject m_pTxtTitle;
    private Box m_pBoxMain;

    public InfoPageScene(int n, int n2) {
        super(75);
        this.m_iInfoTextID = n;
        this.m_iTitleTextID = n2;
        this.m_iTotalStrLen = 0;
        this.m_iCurrentStrLen = 0;
        this.m_iCurrentPage = 0;
        this.m_pOffsetOnPage[this.m_iCurrentPage] = 0;
        this.m_iNumPages = 1;
    }

    private final void updateArrows() {
        if (this.m_pDownArrow != null) {
            this.m_pDownArrow.m_bVisible = this.m_iCurrentStrLen < this.m_iTotalStrLen;
        }
        if (this.m_pUpArrow != null) {
            this.m_pUpArrow.m_bVisible = this.m_iCurrentPage > 0;
        }
    }

    private final void measureCurrentLength() {
        if (this.m_pFont != null && this.m_pBoxMain != null && this.m_pyText != null) {
            this.m_iCurrentStrLen = this.m_pFont.textRender(null, this.m_pBoxMain.m_iLeft >> 12, this.m_pBoxMain.m_iTop >> 12, this.m_pBoxMain.getWidth() >> 12, this.m_pBoxMain.getHeight() >> 12, 257, this.m_pyText, this.m_pOffsetOnPage[this.m_iCurrentPage], 0, -1, true, null);
        }
    }

    public boolean onAddObject(GameObject gameObject) {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        int n = gameObject.m_iInstanceID;
        boolean bl = super.onAddObject(gameObject);
        if (n == 7000) {
            this.m_pTxtTitle = (TextObject)gameObject;
            this.m_pTxtTitle.setText(this.m_iTitleTextID);
            this.m_pTxtTitle.m_bVisible = true;
        } else if (n == 7001) {
            this.m_pBoxMain = (Box)gameObject;
            this.m_pBoxMain.m_bVisible = false;
        } else if (n == 7005) {
            this.m_pDownArrow = (AnimObject)gameObject;
        } else if (n == 7004) {
            this.m_pUpArrow = (AnimObject)gameObject;
        }
        return bl;
    }

    public void onCheckKeysChanged() {
        GameApp gameApp = GameApp.m_instance;
        int n = gameApp.m_iKeysChanged;
        if ((n & 0x60000) != 0) {
            gameApp.closeScene(this);
            return;
        }
        if ((n & 0x1004) != 0) {
            if (this.m_iCurrentPage != 0) {
                --this.m_iCurrentPage;
                this.measureCurrentLength();
                this.updateArrows();
            }
            return;
        }
        if ((n & 0x2100) != 0) {
            if (this.m_iCurrentStrLen != this.m_iTotalStrLen) {
                ++this.m_iCurrentPage;
                if (this.m_iCurrentPage > this.m_iNumPages - 1) {
                    this.m_iNumPages = this.m_iCurrentPage + 1;
                }
                this.m_pOffsetOnPage[this.m_iCurrentPage] = this.m_iCurrentStrLen;
                this.measureCurrentLength();
                this.updateArrows();
            }
            return;
        }
        super.onCheckKeysChanged();
    }

    public void onPaint(Graphics graphics) {
        super.onPaint(graphics);
        if (this.m_pFont != null && this.m_pyText != null && this.m_pBoxMain != null) {
            this.m_pFont.textRender(graphics, this.m_pBoxMain.m_iLeft >> 12, this.m_pBoxMain.m_iTop >> 12, this.m_pBoxMain.getWidth() >> 12, this.m_pBoxMain.getHeight() >> 12, 257, this.m_pyText, this.m_pOffsetOnPage[this.m_iCurrentPage], 0, -1, false, null);
        }
    }

    public int onOpen() {
        PetsApp petsApp = (PetsApp)GameApp.m_instance;
        this.m_pyText = GameApp.loadStringResource(this.m_iInfoTextID);
        this.m_pFont = petsApp.m_pFont;
        if (this.m_pyText != null) {
            this.m_iTotalStrLen = GameApp.getStringBufferLength(this.m_pyText);
            this.measureCurrentLength();
            if (this.m_iCurrentStrLen < this.m_iTotalStrLen) {
                this.m_iNumPages = 2;
            }
        }
        this.updateArrows();
        return super.onOpen();
    }
}

