/*
 * Decompiled with CFR 0.152.
 */
package eyespyfx;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class WaitCanvas
extends Canvas {
    private int mCount;
    private int mMaximum;
    private int mInterval;
    private int backColour;
    private int foreColour;
    private int mWidth;
    private int mHeight;
    private int mX;
    private int mY;
    private int mRadius;
    private String mMessage;
    private Font f;
    private Timer timer;
    private TimerTask task;

    public WaitCanvas(int foreColour, int backColour) {
        this.foreColour = foreColour;
        this.backColour = backColour;
        this.mCount = 0;
        this.mMaximum = 36;
        this.mInterval = 100;
        this.f = Font.getFont((int)0, (int)1, (int)8);
        this.mWidth = this.getWidth();
        this.mHeight = this.getHeight();
        int halfWidth = (this.mWidth - this.mRadius) / 2;
        int halfHeight = (this.mHeight - this.mRadius) / 2;
        this.mRadius = Math.min(halfWidth, halfHeight);
        this.mX = halfWidth - this.mRadius / 2;
        this.mY = halfHeight - this.mRadius / 2;
    }

    protected void hideNotify() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    protected void keyPressed(int keyCode) {
    }

    public void paint(Graphics g) {
        int theta = -(this.mCount * 360 / this.mMaximum);
        g.setColor(this.backColour);
        g.fillRect(0, 0, this.mWidth, this.mHeight);
        g.setColor(this.foreColour);
        g.drawArc(this.mX, this.mY, this.mRadius, this.mRadius, 0, 360);
        g.fillArc(this.mX, this.mY, this.mRadius, this.mRadius, theta + 90, 90);
        g.fillArc(this.mX, this.mY, this.mRadius, this.mRadius, theta + 270, 90);
        if (this.mMessage != null) {
            g.setFont(this.f);
            g.drawString(this.mMessage, this.mWidth / 2, this.mHeight, 33);
        }
    }

    protected void showNotify() {
        this.task = new TimerTask(){

            public void run() {
                WaitCanvas.this.mCount = (WaitCanvas.this.mCount + 1) % WaitCanvas.this.mMaximum;
                WaitCanvas.this.repaint();
            }
        };
        this.timer = new Timer();
        this.timer.schedule(this.task, 0L, (long)this.mInterval);
    }

    public void setMessage(String s) {
        this.mMessage = s;
        this.repaint();
    }
}

