/*
 * Decompiled with CFR 0.152.
 */
package eyespyfx;

import eyespyfx.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class Properties {
    private static final String PROPERTIES = "/app.properties";
    private static final String PROP_SEP = "=";
    private static Hashtable properties;
    private static StringBuffer buffer;

    public static String getProperty(String key) {
        if (key != null) {
            if (properties == null && !Properties.initProperties()) {
                return null;
            }
            String prop = (String)properties.get(key);
            return prop;
        }
        return null;
    }

    public static boolean initProperties() {
        properties = new Hashtable();
        InputStream in = null;
        Class<?> c = Runtime.getRuntime().getClass();
        boolean success = false;
        try {
            in = c.getClass().getResourceAsStream(PROPERTIES);
            if (in != null) {
                Properties.loadProperties(in);
                success = true;
            }
        }
        catch (Throwable t) {
            System.out.println("initProperties Error: " + t.toString());
            properties = null;
            success = false;
        }
        return success;
    }

    private static void getBuffer() {
        if (buffer == null) {
            buffer = new StringBuffer();
        } else {
            buffer.delete(0, buffer.capacity());
        }
    }

    private static synchronized void loadProperties(InputStream in) throws IOException {
        InputStreamReader reader = new InputStreamReader(in);
        String line = null;
        String[] key_value_pair = null;
        while ((line = Properties.readLine(reader)) != null) {
            if (line.length() <= 0 || (key_value_pair = Tools.split(line, PROP_SEP, 1)).length != 2) continue;
            properties.put(key_value_pair[0], key_value_pair[1]);
        }
        return;
    }

    private static String readLine(InputStreamReader reader) throws IOException {
        int i;
        Properties.getBuffer();
        while ((i = reader.read()) != -1) {
            char c = (char)i;
            if (c == '\r' || c == '\n') {
                return buffer.toString();
            }
            buffer.append(c);
        }
        return buffer.length() > 0 ? buffer.toString() : null;
    }
}

